/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.Scroller;
import com.mob.tools.gui.SmoothScroller;
import com.mob.tools.utils.ResHelper;

public class MobDrawerLayout
extends ViewGroup {
    private static final int TOUCH_STATE_REST = 0;
    private static final int TOUCH_STATE_SCROLLING = 1;
    private static final int SNAP_VELOCITY = 500;
    private DrawerType type;
    private double drawerWidth;
    private OnDrawerStateChangeListener listener;
    private boolean lockScroll;
    private Scroller scroller;
    private int touchSlop;
    private int maximumVelocity;
    private FrameLayout bodyContainer;
    private FrameLayout drawerContainer;
    private boolean opened;
    private int touchState;
    private VelocityTracker velocityTracker;
    private float lastMotionX;
    private float lastMotionY;
    private Paint paint;

    public MobDrawerLayout(Context context) {
        super(context);
        this.init(context);
    }

    public MobDrawerLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MobDrawerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.scroller = SmoothScroller.DEFAULT.getScroller(context);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.touchSlop = configuration.getScaledTouchSlop();
        this.maximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.type = DrawerType.LEFT_COVER;
        this.drawerWidth = 0.8;
        this.touchState = 0;
        this.paint = new Paint();
        View.OnClickListener l = new View.OnClickListener(){

            public void onClick(View v) {
            }
        };
        this.bodyContainer = new FrameLayout(context);
        this.bodyContainer.setOnClickListener(l);
        this.drawerContainer = new FrameLayout(context);
        this.drawerContainer.setOnClickListener(l);
        this.addView((View)this.bodyContainer);
        this.addView((View)this.drawerContainer);
    }

    public void setDrawerType(DrawerType type) {
        if (type == null) {
            type = DrawerType.LEFT_COVER;
        }
        if (this.type != type) {
            this.type = type;
            switch (type) {
                case LEFT_COVER: 
                case RIGHT_COVER: {
                    this.drawerContainer.bringToFront();
                    break;
                }
                default: {
                    this.bodyContainer.bringToFront();
                }
            }
            this.postInvalidate();
        }
    }

    public void setDrawerWidth(double drawerWidth) {
        if (drawerWidth < 0.0) {
            drawerWidth = 0.8f;
        }
        if (drawerWidth > 1.0) {
            drawerWidth = 1.0;
        }
        if (this.drawerWidth != drawerWidth) {
            this.drawerWidth = drawerWidth;
            this.postInvalidate();
        }
    }

    public void open(boolean immediate) {
        this.switchDrawer(true, immediate);
    }

    public void open() {
        this.open(false);
    }

    public void close(boolean immediate) {
        this.switchDrawer(false, immediate);
    }

    public void close() {
        this.close(false);
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOnDrawerStateChangeListener(OnDrawerStateChangeListener l) {
        this.listener = l;
    }

    public void setBody(View body) {
        View myBody;
        View view = myBody = this.bodyContainer.getChildCount() == 0 ? null : this.bodyContainer.getChildAt(0);
        if (!ResHelper.isEqual(myBody, body)) {
            this.bodyContainer.removeAllViews();
            this.bodyContainer.addView(body);
        }
    }

    public void setDrawer(View drawer) {
        View myDrawer;
        View view = myDrawer = this.drawerContainer.getChildCount() == 0 ? null : this.drawerContainer.getChildAt(0);
        if (!ResHelper.isEqual(myDrawer, drawer)) {
            this.drawerContainer.removeAllViews();
            this.drawerContainer.addView(drawer);
        }
    }

    public void setLockScroll(boolean lock) {
        this.lockScroll = lock;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int adjustedWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        int adjustedHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        this.bodyContainer.measure(adjustedWidthMeasureSpec, adjustedHeightMeasureSpec);
        adjustedWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((double)width * this.drawerWidth)), (int)0x40000000);
        this.drawerContainer.measure(adjustedWidthMeasureSpec, adjustedHeightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        int height = b - t;
        int drawerWidth = (int)((double)width * this.drawerWidth);
        if (this.isOpened()) {
            switch (this.type) {
                case LEFT_BOTTOM: {
                    this.bodyContainer.layout(drawerWidth, 0, width + drawerWidth, height);
                    this.drawerContainer.layout(0, 0, drawerWidth, height);
                    break;
                }
                case LEFT_COVER: {
                    this.bodyContainer.layout(0, 0, width, height);
                    this.drawerContainer.layout(0, 0, drawerWidth, height);
                    break;
                }
                case LEFT_PUSH: {
                    this.bodyContainer.layout(drawerWidth, 0, width + drawerWidth, height);
                    this.drawerContainer.layout(0, 0, drawerWidth, height);
                    break;
                }
                case RIGHT_BOTTOM: {
                    this.bodyContainer.layout(-drawerWidth, 0, width - drawerWidth, height);
                    this.drawerContainer.layout(width - drawerWidth, 0, width, height);
                    break;
                }
                case RIGHT_COVER: {
                    this.bodyContainer.layout(0, 0, width, height);
                    this.drawerContainer.layout(width - drawerWidth, 0, width, height);
                    break;
                }
                case RIGHT_PUSH: {
                    this.bodyContainer.layout(-drawerWidth, 0, width - drawerWidth, height);
                    this.drawerContainer.layout(width - drawerWidth, 0, width, height);
                }
            }
        } else {
            switch (this.type) {
                case LEFT_BOTTOM: {
                    this.bodyContainer.layout(0, 0, width, height);
                    this.drawerContainer.layout(0, 0, drawerWidth, height);
                    break;
                }
                case LEFT_COVER: {
                    this.bodyContainer.layout(0, 0, width, height);
                    this.drawerContainer.layout(-drawerWidth, 0, 0, height);
                    break;
                }
                case LEFT_PUSH: {
                    this.bodyContainer.layout(0, 0, width, height);
                    this.drawerContainer.layout(-drawerWidth, 0, 0, height);
                    break;
                }
                case RIGHT_BOTTOM: {
                    this.bodyContainer.layout(0, 0, width, height);
                    this.drawerContainer.layout(width - drawerWidth, 0, width, height);
                    break;
                }
                case RIGHT_COVER: {
                    this.bodyContainer.layout(0, 0, width, height);
                    this.drawerContainer.layout(width, 0, width + drawerWidth, height);
                    break;
                }
                case RIGHT_PUSH: {
                    this.bodyContainer.layout(0, 0, width, height);
                    this.drawerContainer.layout(width, 0, width + drawerWidth, height);
                }
            }
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        FrameLayout second;
        FrameLayout first;
        long drawingTime = this.getDrawingTime();
        switch (this.type) {
            case LEFT_COVER: 
            case RIGHT_COVER: 
            case RIGHT_PUSH: {
                first = this.bodyContainer;
                second = this.drawerContainer;
                break;
            }
            default: {
                first = this.drawerContainer;
                second = this.bodyContainer;
            }
        }
        this.drawChild(canvas, (View)first, drawingTime);
        this.drawChild(canvas, (View)second, drawingTime);
        this.drawShadow(canvas);
    }

    private void drawShadow(Canvas canvas) {
        switch (this.type) {
            case LEFT_COVER: {
                int edge = this.drawerContainer.getRight();
                if (edge <= 0) break;
                this.paint.setShader((Shader)new LinearGradient((float)edge, 0.0f, (float)(edge + 25), 0.0f, Integer.MIN_VALUE, 0, Shader.TileMode.CLAMP));
                canvas.drawRect((float)edge, 0.0f, (float)(edge + 25), (float)this.getHeight(), this.paint);
                break;
            }
            case RIGHT_BOTTOM: 
            case RIGHT_PUSH: {
                int edge = this.bodyContainer.getRight();
                if (edge >= this.getWidth()) break;
                this.paint.setShader((Shader)new LinearGradient((float)edge, 0.0f, (float)(edge + 25), 0.0f, Integer.MIN_VALUE, 0, Shader.TileMode.CLAMP));
                canvas.drawRect((float)edge, 0.0f, (float)(edge + 25), (float)this.getHeight(), this.paint);
                break;
            }
            case RIGHT_COVER: {
                int edge = this.drawerContainer.getLeft();
                if (edge >= this.getWidth()) break;
                this.paint.setShader((Shader)new LinearGradient((float)(edge - 25), 0.0f, (float)edge, 0.0f, 0, Integer.MIN_VALUE, Shader.TileMode.CLAMP));
                canvas.drawRect((float)(edge - 25), 0.0f, (float)edge, (float)this.getHeight(), this.paint);
                break;
            }
            default: {
                int edge = this.bodyContainer.getLeft();
                if (edge <= 0) break;
                this.paint.setShader((Shader)new LinearGradient((float)(edge - 25), 0.0f, (float)edge, 0.0f, 0, Integer.MIN_VALUE, Shader.TileMode.CLAMP));
                canvas.drawRect((float)(edge - 25), 0.0f, (float)edge, (float)this.getHeight(), this.paint);
            }
        }
    }

    private void switchDrawer(boolean open, boolean immediate) {
        this.bodyContainer.clearFocus();
        this.drawerContainer.clearFocus();
        int from = 0;
        int to = 0;
        switch (this.type) {
            case LEFT_COVER: 
            case LEFT_PUSH: {
                from = this.drawerContainer.getLeft();
                to = (int)(open ? 0.0 : (double)(-this.getWidth()) * this.drawerWidth);
                break;
            }
            case LEFT_BOTTOM: {
                from = this.bodyContainer.getLeft();
                to = (int)(open ? (double)this.getWidth() * this.drawerWidth : 0.0);
                break;
            }
            case RIGHT_COVER: 
            case RIGHT_PUSH: {
                int width = this.getWidth();
                from = this.drawerContainer.getLeft();
                to = width - (int)(open ? (double)width * this.drawerWidth : 0.0);
                break;
            }
            case RIGHT_BOTTOM: {
                from = this.bodyContainer.getLeft();
                to = (int)(open ? (double)(-this.getWidth()) * this.drawerWidth : 0.0);
            }
        }
        this.scroller.abortAnimation();
        if (from != to) {
            this.scroller.startScroll(from, 0, to - from, 0, immediate ? 0 : 100);
        }
        this.invalidate();
    }

    public void computeScroll() {
        if (this.scroller.computeScrollOffset()) {
            switch (this.type) {
                case LEFT_COVER: 
                case RIGHT_COVER: {
                    int left = this.scroller.getCurrX();
                    int right = left + (int)((double)this.getWidth() * this.drawerWidth);
                    this.drawerContainer.layout(left, 0, right, this.getHeight());
                    break;
                }
                case LEFT_BOTTOM: 
                case RIGHT_BOTTOM: {
                    int left = this.scroller.getCurrX();
                    int right = left + this.getWidth();
                    this.bodyContainer.layout(left, 0, right, this.getHeight());
                    break;
                }
                case LEFT_PUSH: {
                    int width = this.getWidth();
                    int dLeft = this.scroller.getCurrX();
                    int bLeft = dLeft + (int)((double)width * this.drawerWidth);
                    int bRight = bLeft + width;
                    this.drawerContainer.layout(dLeft, 0, bLeft, this.getHeight());
                    this.bodyContainer.layout(bLeft, 0, bRight, this.getHeight());
                    break;
                }
                case RIGHT_PUSH: {
                    int width = this.getWidth();
                    int dLeft = this.scroller.getCurrX();
                    int bLeft = dLeft - width;
                    int dRight = dLeft + (int)((double)width * this.drawerWidth);
                    this.bodyContainer.layout(bLeft, 0, dLeft, this.getHeight());
                    this.drawerContainer.layout(dLeft, 0, dRight, this.getHeight());
                }
            }
        } else {
            if (this.isClose()) {
                this.opened = false;
                return;
            }
            this.opened = true;
            return;
        }
        this.postInvalidate();
        if (this.listener != null && this.scroller.getFinalX() != this.scroller.getStartX()) {
            int progress = (this.scroller.getCurrX() - this.scroller.getStartX()) * 100 / (this.scroller.getFinalX() - this.scroller.getStartX());
            if (this.opened) {
                this.listener.onClosing(this, progress);
            } else {
                this.listener.onOpening(this, progress);
            }
        }
    }

    private boolean isClose() {
        boolean close = false;
        switch (this.type) {
            case LEFT_COVER: {
                close = this.drawerContainer.getRight() == 0;
                break;
            }
            case LEFT_BOTTOM: 
            case LEFT_PUSH: {
                close = this.bodyContainer.getLeft() == 0;
                break;
            }
            case RIGHT_COVER: {
                close = this.drawerContainer.getLeft() == this.getWidth();
                break;
            }
            case RIGHT_BOTTOM: 
            case RIGHT_PUSH: {
                close = this.bodyContainer.getRight() == this.getWidth();
            }
        }
        return close;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(ev);
        switch (ev.getAction()) {
            case 0: {
                if (this.touchState == 0) break;
                if (!this.scroller.isFinished()) {
                    this.scroller.abortAnimation();
                }
                this.lastMotionX = ev.getX();
                break;
            }
            case 2: {
                if (this.touchState != 1 && (!this.onInterceptTouchEvent(ev) || this.touchState != 1)) break;
                float x = ev.getX();
                int deltaX = (int)(this.lastMotionX - x);
                if (deltaX < 0) {
                    this.dragToRight(-deltaX);
                } else if (deltaX > 0) {
                    this.dragToLeft(deltaX);
                }
                this.lastMotionX = x;
                break;
            }
            case 1: 
            case 3: {
                if (this.touchState == 1 && this.velocityTracker != null) {
                    this.velocityTracker.computeCurrentVelocity(1000, (float)this.maximumVelocity);
                    this.computeDrag((int)this.velocityTracker.getXVelocity());
                    this.velocityTracker.recycle();
                    this.velocityTracker = null;
                }
                this.touchState = 0;
            }
        }
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.lockScroll) {
            return false;
        }
        int action = ev.getAction();
        if (action == 2 && this.touchState != 0) {
            return true;
        }
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        this.velocityTracker.addMovement(ev);
        switch (action) {
            case 0: {
                this.lastMotionX = ev.getX();
                this.lastMotionY = ev.getY();
                this.touchState = this.scroller.isFinished() ? 0 : 1;
                break;
            }
            case 2: {
                float x = ev.getX();
                float y = ev.getY();
                int xDiff = (int)Math.abs(x - this.lastMotionX);
                int yDiff = (int)Math.abs(y - this.lastMotionY);
                if (yDiff >= xDiff || xDiff <= this.touchSlop) break;
                this.touchState = 1;
                this.lastMotionX = x;
                break;
            }
            case 1: 
            case 3: {
                if (this.velocityTracker != null) {
                    this.velocityTracker.recycle();
                    this.velocityTracker = null;
                }
                this.touchState = 0;
            }
        }
        return this.touchState != 0;
    }

    private void dragToRight(int deltaX) {
        switch (this.type) {
            case LEFT_COVER: {
                int left = this.drawerContainer.getLeft();
                if (left >= 0) break;
                if ((left += deltaX) > 0) {
                    left = 0;
                }
                int right = left + (int)((double)this.getWidth() * this.drawerWidth);
                this.drawerContainer.layout(left, 0, right, this.getHeight());
                break;
            }
            case LEFT_BOTTOM: {
                int left = this.bodyContainer.getLeft();
                int dw = (int)((double)this.getWidth() * this.drawerWidth);
                if (left >= dw) break;
                if ((left += deltaX) > dw) {
                    left = dw;
                }
                int right = left + this.getWidth();
                this.bodyContainer.layout(left, 0, right, this.getHeight());
                break;
            }
            case LEFT_PUSH: {
                int left = this.drawerContainer.getLeft();
                if (left >= 0) break;
                if ((left += deltaX) > 0) {
                    left = 0;
                }
                int dRight = left + (int)((double)this.getWidth() * this.drawerWidth);
                int bRight = dRight + this.getWidth();
                this.drawerContainer.layout(left, 0, dRight, this.getHeight());
                this.bodyContainer.layout(dRight, 0, bRight, this.getHeight());
                break;
            }
            case RIGHT_COVER: {
                int left = this.drawerContainer.getLeft();
                int width = this.getWidth();
                if (left >= width) break;
                if ((left += deltaX) > width) {
                    left = width;
                }
                int right = left + (int)((double)this.getWidth() * this.drawerWidth);
                this.drawerContainer.layout(left, 0, right, this.getHeight());
                break;
            }
            case RIGHT_BOTTOM: {
                int left = this.bodyContainer.getLeft();
                if (left >= 0) break;
                if ((left += deltaX) > 0) {
                    left = 0;
                }
                int right = left + this.getWidth();
                this.bodyContainer.layout(left, 0, right, this.getHeight());
                break;
            }
            case RIGHT_PUSH: {
                int left = this.bodyContainer.getLeft();
                if (left >= 0) break;
                if ((left += deltaX) > 0) {
                    left = 0;
                }
                int bRight = left + this.getWidth();
                int dRight = bRight + (int)((double)this.getWidth() * this.drawerWidth);
                this.bodyContainer.layout(left, 0, bRight, this.getHeight());
                this.drawerContainer.layout(bRight, 0, dRight, this.getHeight());
            }
        }
    }

    private void dragToLeft(int deltaX) {
        switch (this.type) {
            case LEFT_COVER: {
                int right = this.drawerContainer.getRight();
                if (right <= 0) break;
                if ((right -= deltaX) < 0) {
                    right = 0;
                }
                int left = right - (int)((double)this.getWidth() * this.drawerWidth);
                this.drawerContainer.layout(left, 0, right, this.getHeight());
                break;
            }
            case LEFT_BOTTOM: {
                int left = this.bodyContainer.getLeft();
                if (left <= 0) break;
                if ((left -= deltaX) < 0) {
                    left = 0;
                }
                int right = left + this.getWidth();
                this.bodyContainer.layout(left, 0, right, this.getHeight());
                break;
            }
            case LEFT_PUSH: {
                int dRight = this.drawerContainer.getRight();
                if (dRight <= 0) break;
                if ((dRight -= deltaX) < 0) {
                    dRight = 0;
                }
                int left = dRight - (int)((double)this.getWidth() * this.drawerWidth);
                int bRight = dRight + this.getWidth();
                this.drawerContainer.layout(left, 0, dRight, this.getHeight());
                this.bodyContainer.layout(dRight, 0, bRight, this.getHeight());
                break;
            }
            case RIGHT_COVER: {
                int right = this.drawerContainer.getRight();
                int width = this.getWidth();
                if (right <= width) break;
                if ((right -= deltaX) < width) {
                    right = width;
                }
                int left = right - (int)((double)this.getWidth() * this.drawerWidth);
                this.drawerContainer.layout(left, 0, right, this.getHeight());
                break;
            }
            case RIGHT_BOTTOM: {
                int left = this.bodyContainer.getLeft();
                int dw = (int)((double)(-this.getWidth()) * this.drawerWidth);
                if (left <= dw) break;
                if ((left -= deltaX) < dw) {
                    left = dw;
                }
                int right = left + this.getWidth();
                this.bodyContainer.layout(left, 0, right, this.getHeight());
                break;
            }
            case RIGHT_PUSH: {
                int right = this.drawerContainer.getRight();
                int width = this.getWidth();
                if (right <= width) break;
                if ((right -= deltaX) < width) {
                    right = width;
                }
                int dLeft = right - (int)((double)this.getWidth() * this.drawerWidth);
                int bLeft = dLeft - this.getWidth();
                this.drawerContainer.layout(dLeft, 0, right, this.getHeight());
                this.bodyContainer.layout(bLeft, 0, dLeft, this.getHeight());
            }
        }
    }

    private void computeDrag(int velocityX) {
        if (velocityX >= 500) {
            switch (this.type) {
                case LEFT_COVER: 
                case LEFT_BOTTOM: 
                case LEFT_PUSH: {
                    this.open();
                    break;
                }
                case RIGHT_COVER: 
                case RIGHT_BOTTOM: 
                case RIGHT_PUSH: {
                    this.close();
                }
            }
        } else if (velocityX <= -500) {
            switch (this.type) {
                case LEFT_COVER: 
                case LEFT_BOTTOM: 
                case LEFT_PUSH: {
                    this.close();
                    break;
                }
                case RIGHT_COVER: 
                case RIGHT_BOTTOM: 
                case RIGHT_PUSH: {
                    this.open();
                }
            }
        } else {
            int edge = 0;
            switch (this.type) {
                case LEFT_COVER: 
                case LEFT_PUSH: {
                    edge = this.drawerContainer.getRight();
                    break;
                }
                case LEFT_BOTTOM: {
                    edge = this.bodyContainer.getLeft();
                    break;
                }
                case RIGHT_COVER: 
                case RIGHT_PUSH: {
                    edge = this.getWidth() - this.drawerContainer.getLeft();
                    break;
                }
                case RIGHT_BOTTOM: {
                    edge = -this.bodyContainer.getLeft();
                }
            }
            if (edge >= (int)((double)this.getWidth() * this.drawerWidth) / 2) {
                this.open();
            } else {
                this.close();
            }
        }
    }

    public static interface OnDrawerStateChangeListener {
        public void onOpening(MobDrawerLayout var1, int var2);

        public void onClosing(MobDrawerLayout var1, int var2);
    }

    public static enum DrawerType {
        LEFT_COVER,
        RIGHT_COVER,
        LEFT_BOTTOM,
        RIGHT_BOTTOM,
        LEFT_PUSH,
        RIGHT_PUSH;

    }
}

