/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.mob.tools.utils.UIHandler;
import java.util.Iterator;

public class RxMob {
    public static <T> Subscribable<T> create(OnSubscribe<T> onSubscribe) {
        Subscribable s = new Subscribable();
        s.onSubscribe = onSubscribe;
        return s;
    }

    public static <T> Subscribable<T> just(final T ... datas) {
        return RxMob.create(new QuickSubscribe<T>(){

            @Override
            protected void doNext(Subscriber<T> subscriber) throws Throwable {
                for (Object data : datas) {
                    subscriber.onNext(data);
                }
            }
        });
    }

    public static <T> Subscribable<T> from(final Iterator<T> datas) {
        return RxMob.create(new QuickSubscribe<T>(){

            @Override
            protected void doNext(Subscriber<T> subscriber) throws Throwable {
                while (datas.hasNext()) {
                    subscriber.onNext(datas.next());
                }
            }
        });
    }

    private static final class SubscriberWarpper<T>
    extends Subscriber<T> {
        private Subscribable<T> subscribable;
        private Subscriber<T> subscriber;

        public SubscriberWarpper(Subscribable<T> subscribable, Subscriber<T> subscriber) {
            this.subscribable = subscribable;
            this.subscriber = subscriber;
            ((Subscriber)subscriber).setWarpper(this);
        }

        public void removeSubscriber() {
            this.subscriber = null;
        }

        @Override
        public void onStart() {
            if (this.subscriber != null) {
                if (((Subscribable)this.subscribable).observeThread == Thread.UI_THREAD) {
                    long mainThreadId = Looper.getMainLooper().getThread().getId();
                    if (java.lang.Thread.currentThread().getId() == mainThreadId) {
                        this.subscriber.onStart();
                    } else {
                        UIHandler.sendEmptyMessage(0, new Handler.Callback(){

                            public boolean handleMessage(Message msg) {
                                SubscriberWarpper.this.subscriber.onStart();
                                return false;
                            }
                        });
                    }
                } else if (((Subscribable)this.subscribable).observeThread == Thread.NEW_THREAD) {
                    new java.lang.Thread(){

                        @Override
                        public void run() {
                            SubscriberWarpper.this.subscriber.onStart();
                        }
                    }.start();
                } else {
                    this.subscriber.onStart();
                }
            }
        }

        @Override
        public void onNext(final T data) {
            if (this.subscriber != null) {
                if (((Subscribable)this.subscribable).observeThread == Thread.UI_THREAD) {
                    long mainThreadId = Looper.getMainLooper().getThread().getId();
                    if (java.lang.Thread.currentThread().getId() == mainThreadId) {
                        this.subscriber.onNext(data);
                    } else {
                        UIHandler.sendEmptyMessage(0, new Handler.Callback(){

                            public boolean handleMessage(Message msg) {
                                SubscriberWarpper.this.subscriber.onNext(data);
                                return false;
                            }
                        });
                    }
                } else if (((Subscribable)this.subscribable).observeThread == Thread.NEW_THREAD) {
                    new java.lang.Thread(){

                        @Override
                        public void run() {
                            SubscriberWarpper.this.subscriber.onNext(data);
                        }
                    }.start();
                } else {
                    this.subscriber.onNext(data);
                }
            }
        }

        @Override
        public void onCompleted() {
            if (this.subscriber != null) {
                if (((Subscribable)this.subscribable).observeThread == Thread.UI_THREAD) {
                    long mainThreadId = Looper.getMainLooper().getThread().getId();
                    if (java.lang.Thread.currentThread().getId() == mainThreadId) {
                        this.subscriber.onCompleted();
                        this.removeSubscriber();
                    } else {
                        UIHandler.sendEmptyMessage(0, new Handler.Callback(){

                            public boolean handleMessage(Message msg) {
                                SubscriberWarpper.this.subscriber.onCompleted();
                                SubscriberWarpper.this.removeSubscriber();
                                return false;
                            }
                        });
                    }
                } else if (((Subscribable)this.subscribable).observeThread == Thread.NEW_THREAD) {
                    new java.lang.Thread(){

                        @Override
                        public void run() {
                            SubscriberWarpper.this.subscriber.onCompleted();
                            SubscriberWarpper.this.removeSubscriber();
                        }
                    }.start();
                } else {
                    this.subscriber.onCompleted();
                    this.removeSubscriber();
                }
            }
        }

        @Override
        public void onError(final Throwable t) {
            if (this.subscriber != null) {
                if (((Subscribable)this.subscribable).observeThread == Thread.UI_THREAD) {
                    long mainThreadId = Looper.getMainLooper().getThread().getId();
                    if (java.lang.Thread.currentThread().getId() == mainThreadId) {
                        this.subscriber.onError(t);
                        this.removeSubscriber();
                    } else {
                        UIHandler.sendEmptyMessage(0, new Handler.Callback(){

                            public boolean handleMessage(Message msg) {
                                SubscriberWarpper.this.subscriber.onError(t);
                                SubscriberWarpper.this.removeSubscriber();
                                return false;
                            }
                        });
                    }
                } else if (((Subscribable)this.subscribable).observeThread == Thread.NEW_THREAD) {
                    new java.lang.Thread(){

                        @Override
                        public void run() {
                            SubscriberWarpper.this.subscriber.onError(t);
                            SubscriberWarpper.this.removeSubscriber();
                        }
                    }.start();
                } else {
                    this.subscriber.onError(t);
                    this.removeSubscriber();
                }
            }
        }
    }

    public static class Subscriber<T> {
        private SubscriberWarpper<T> warpper;

        private void setWarpper(SubscriberWarpper<T> warpper) {
            this.warpper = warpper;
        }

        public void onStart() {
        }

        public void onNext(T data) {
        }

        public void onCompleted() {
        }

        public void onError(Throwable t) {
        }

        public final void unsubscribe() {
            if (this.warpper != null) {
                this.warpper.removeSubscriber();
                this.warpper = null;
            }
        }
    }

    public static abstract class QuickSubscribe<T>
    implements OnSubscribe<T> {
        @Override
        public final void call(Subscriber<T> subscriber) {
            subscriber.onStart();
            try {
                this.doNext(subscriber);
                subscriber.onCompleted();
            }
            catch (Throwable t) {
                subscriber.onError(t);
            }
        }

        protected abstract void doNext(Subscriber<T> var1) throws Throwable;
    }

    public static interface OnSubscribe<T> {
        public void call(Subscriber<T> var1);
    }

    public static enum Thread {
        IMMEDIATE,
        UI_THREAD,
        NEW_THREAD;

    }

    public static final class Subscribable<T> {
        private OnSubscribe<T> onSubscribe;
        private Thread observeThread;
        private Thread subscribeThread;

        private Subscribable() {
        }

        public Subscribable<T> subscribeOn(Thread thread) {
            this.subscribeThread = thread;
            return this;
        }

        public Subscribable<T> observeOn(Thread thread) {
            this.observeThread = thread;
            return this;
        }

        public void subscribe(final Subscriber<T> subscriber) {
            if (this.onSubscribe != null) {
                if (this.subscribeThread == Thread.UI_THREAD) {
                    UIHandler.sendEmptyMessage(0, new Handler.Callback(){

                        public boolean handleMessage(Message msg) {
                            Subscribable.this.onSubscribe.call(new SubscriberWarpper(Subscribable.this, subscriber));
                            return false;
                        }
                    });
                } else if (this.subscribeThread == Thread.NEW_THREAD) {
                    new java.lang.Thread(){

                        @Override
                        public void run() {
                            Subscribable.this.onSubscribe.call(new SubscriberWarpper(Subscribable.this, subscriber));
                        }
                    }.start();
                } else {
                    this.onSubscribe.call(new SubscriberWarpper<T>(this, subscriber));
                }
            }
        }

        public void subscribeOnNewThreadAndObserveOnUIThread(Subscriber<T> subscriber) {
            this.subscribeOn(Thread.NEW_THREAD);
            this.observeOn(Thread.UI_THREAD);
            this.subscribe(subscriber);
        }
    }
}

