/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.map;

import android.graphics.Rect;
import com.tencent.mapsdk.raster.model.GeoPoint;
import com.tencent.mapsdk.raster.model.LatLng;
import com.tencent.mapsdk.raster.model.Marker;
import com.tencent.mapsdk.rastercore.f.a;
import com.tencent.tencentmap.mapsdk.map.CancelableCallback;
import com.tencent.tencentmap.mapsdk.map.MapView;
import com.tencent.tencentmap.mapsdk.map.OnLoadedListener;
import com.tencent.tencentmap.mapsdk.map.OnMapHitListener;
import com.tencent.tencentmap.mapsdk.map.OnMapLongPressListener;
import com.tencent.tencentmap.mapsdk.map.OnMarkerPressListener;
import com.tencent.tencentmap.mapsdk.map.Projection;
import com.tencent.tencentmap.mapsdk.map.TencentMap;

public class MapController {
    private boolean animateEable = true;
    private MapView mapView;

    public MapController(MapView mapView) {
        this.mapView = mapView;
    }

    public void animateTo(GeoPoint geoPoint) {
        this.mapView.getMap().animateTo(a.a(geoPoint));
    }

    public void animateTo(GeoPoint geoPoint, Runnable runnable) {
        this.mapView.getMap().animateTo(a.a(geoPoint), runnable);
    }

    public void animateTo(GeoPoint geoPoint, long l, CancelableCallback cancelableCallback) {
        this.mapView.getMap().animateTo(a.a(geoPoint), l, cancelableCallback);
    }

    public void animateTo(LatLng latLng, long l, CancelableCallback cancelableCallback) {
        this.mapView.getMap().animateTo(latLng, l, cancelableCallback);
    }

    public void scrollBy(float f2, float f3) {
        this.mapView.getMap().scrollBy(f2, f3);
    }

    public void scrollBy(float f2, float f3, long l, CancelableCallback cancelableCallback) {
        this.mapView.getMap().scrollBy(f2, f3, l, cancelableCallback);
    }

    public void setCenter(GeoPoint geoPoint) {
        this.mapView.getMap().setCenter(a.a(geoPoint));
    }

    public void setZoom(int n) {
        this.mapView.getMap().setZoom(n);
    }

    public void zoomIn() {
        this.mapView.getMap().zoomIn();
    }

    public void zoomInFixing(int n, int n2) {
        this.mapView.getMap().zoomInFixing(n, n2);
    }

    public void zoomOut() {
        this.mapView.getMap().zoomOut();
    }

    public void zoomOutFixing(int n, int n2) {
        this.mapView.getMap().zoomOutFixing(n, n2);
    }

    public void zoomToSpan(GeoPoint geoPoint, GeoPoint geoPoint2) {
        this.mapView.getMap().zoomToSpan(a.a(geoPoint), a.a(geoPoint2));
    }

    public void zoomToSpan(int n, int n2) {
        this.mapView.getMap().zoomToSpan((double)n / 1000000.0, (double)n2 / 1000000.0);
    }

    public void setOnMarkerDragListener(TencentMap.OnMarkerDraggedListener onMarkerDraggedListener) {
        this.mapView.getMap().setOnMarkerDraggedListener(onMarkerDraggedListener);
    }

    public void setOnMapLoadedListener(final OnLoadedListener onLoadedListener) {
        this.mapView.getMap().setOnMapLoadedListener(new TencentMap.OnMapLoadedListener(){

            @Override
            public void onMapLoaded() {
                onLoadedListener.onMapLoaded();
            }
        });
    }

    public void setOnMapLoadedListener(TencentMap.OnMapLoadedListener onMapLoadedListener) {
        this.mapView.getMap().setOnMapLoadedListener(onMapLoadedListener);
    }

    public void setOnInfoWindowClickListener(TencentMap.OnInfoWindowClickListener onInfoWindowClickListener) {
        this.mapView.getMap().setOnInfoWindowClickListener(onInfoWindowClickListener);
    }

    public void setOnMarkerClickListener(final OnMarkerPressListener onMarkerPressListener) {
        this.mapView.getMap().setOnMarkerClickListener(new TencentMap.OnMarkerClickListener(){

            @Override
            public boolean onMarkerClick(Marker marker) {
                onMarkerPressListener.onMarkerPressed(marker);
                return false;
            }
        });
    }

    public void setOnMarkerClickListener(TencentMap.OnMarkerClickListener onMarkerClickListener) {
        this.mapView.getMap().setOnMarkerClickListener(onMarkerClickListener);
    }

    public void setOnMapCameraChangeListener(TencentMap.OnMapCameraChangeListener onMapCameraChangeListener) {
        this.mapView.getMap().setOnMapCameraChangeListener(onMapCameraChangeListener);
    }

    public void setOnMapHitListener(final OnMapHitListener onMapHitListener) {
        this.mapView.getMap().setOnMapClickListener(new TencentMap.OnMapClickListener(){

            @Override
            public void onMapClick(LatLng latLng) {
                onMapHitListener.onMapClick(latLng);
            }
        });
    }

    public void setOnMapClickListener(TencentMap.OnMapClickListener onMapClickListener) {
        this.mapView.getMap().setOnMapClickListener(onMapClickListener);
    }

    public void setOnMapPressClickLisener(final OnMapLongPressListener onMapLongPressListener) {
        this.mapView.getMap().setOnMapLongClickListener(new TencentMap.OnMapLongClickListener(){

            @Override
            public void onMapLongClick(LatLng latLng) {
                onMapLongPressListener.onMapLongPress(latLng);
            }
        });
    }

    public void setOnMapLongClickLisener(TencentMap.OnMapLongClickListener onMapLongClickListener) {
        this.mapView.getMap().setOnMapLongClickListener(onMapLongClickListener);
    }

    public boolean isAnimateEable() {
        return this.animateEable;
    }

    public void setAnimateEable(boolean bl) {
        this.animateEable = bl;
    }

    public void stopAnimation() {
        this.mapView.stopAnimation();
    }

    public Projection getProjection() {
        return this.mapView.getProjection();
    }

    public void getScreenShot(TencentMap.OnScreenShotListener onScreenShotListener) {
        this.mapView.getMap().getScreenShot(onScreenShotListener);
    }

    public void getScreenShot(TencentMap.OnScreenShotListener onScreenShotListener, Rect rect) {
        this.mapView.getMap().getScreenShot(onScreenShotListener, rect);
    }

    public void setInfoWindowAdapter(TencentMap.InfoWindowAdapter infoWindowAdapter) {
        this.mapView.getMap().setInfoWindowAdapter(infoWindowAdapter);
    }
}

