/////////////////////////////////////////////////////////////////////////////
// Name:        wx/osx/colordlg.h
// Purpose:     wxColourDialog class. Use generic version if no
//              platform-specific implementation.
// Author:      Stefan Csomor
// Created:     1998-01-01
// Copyright:   (c) Stefan Csomor
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

#ifndef _WX_COLORDLG_H_
#define _WX_COLORDLG_H_

#include "wx/dialog.h"

/*
 * Platform-specific colour dialog implementation
 */

class WXDLLIMPEXP_CORE wxColourDialog: public wxDialog
{
    wxDECLARE_DYNAMIC_CLASS(wxColourDialog);
public:
    wxColourDialog();
    wxColourDialog(wxWindow *parent, const wxColourData *data = nullptr);

    bool Create(wxWindow *parent, const wxColourData *data = nullptr);

    int ShowModal() override;
    wxColourData& GetColourData() { return m_colourData; }

protected:
    wxColourData        m_colourData;
    wxWindow*           m_dialogParent;
};

#endif
    // _WX_COLORDLG_H_
