# Svelte 语法编译

![Svelte compilation process](https://s1.ax1x.com/2020/04/05/GrND2V.md.png)

The Svelte compilation process can be broken down into 4-steps

- Parsing source code into Abstract Syntax Tree (AST)
- Tracking references and dependencies
- Creating code blocks and fragments
- Generate code

Which sums out by the following pseudocode:

```js
const source = fs.readFileSync("App.svelte");

// parse source code into AST
const ast = parse(source);

// tracking references and dependencies
const component = new Component(ast);

// creating code blocks and fragments
const renderer =
  options.generate === "ssr" ? SSRRenderer(component) : DomRenderer(component);

// Generate code
const { js, css } = renderer.render();

fs.writeFileSync("App.js", js);
fs.writeFileSync("App.css", css);
```
