# Svelte

Svelte 是一个构建 web 应用程序的工具。Svelte 与诸如 React 和 Vue 等 JavaScript 框架类似，都怀揣着一颗让构建交互式用户界面变得更容易的心。但是有一个关键的区别：Svelte 在构建/编译阶段将你的应用程序转换为理想的 JavaScript 应用，而不是在运阶段解释应用程序的代码。这意味着你不需要为框架所消耗的性能付出成本，并且在应用程序首次加载时没有额外损失。

# 背景特性

Svelte 由 Rich Harris 开发，Rich Harris 曾在《卫报》工作，目前任职于《纽约时报》。Harris 先前创建的 Ractive Web 框架被《卫报》采用，并成为 Vue 的部分功能的灵感来源。Harris 还创建了 Rollup 模块打包器，它是 Webpack 和 Parcel 的替代品。

# 快速开始

你可以使用 Svelte 构建整个应用程序，也可以逐步将其融合到现有的代码中。你还可以将组件作为独立的包（package）交付到任何地方，并且不会有传统框架所带来的额外开销。

以最简单的模板为例，其会被编译为如下的 JS 代码：

```svelte
<h1>Hello world!</h1>
```

```js
/* App.svelte generated by Svelte v3.12.1 */
import {
  SvelteComponent,
  detach,
  element,
  init,
  insert,
  noop,
  safe_not_equal,
} from "svelte/internal";

function create_fragment(ctx) {
  var h1;

  return {
    c() {
      h1 = element("h1");
      h1.textContent = "Hello world!";
    },

    m(target, anchor) {
      insert(target, h1, anchor);
    },

    p: noop,
    i: noop,
    o: noop,

    d(detaching) {
      if (detaching) {
        detach(h1);
      }
    },
  };
}

class App extends SvelteComponent {
  constructor(options) {
    super();
    init(this, options, null, create_fragment, safe_not_equal, []);
  }
}

export default App;
```

# Links

- [2020~新兴前端框架 Svelte 从入门到原理](https://mp.weixin.qq.com/s/6MPG04HGo_S3SipPZ-Wmpg): 在这篇文章中，我们将会介绍 Svelte 框架的特性、优缺点和底层原理。TODO!
