# 框架范式

# 可变与不可变

Svelte 的作者 Rich 认为 React 中最核心的问题是 React 一方面强调函数式渲染，而在 Web 里面，不管是 DOM，BOM，CSS，JavaScript 还是 WebGL，都充满了内部状态和命令式风格的 API，跟 React 函数式风格的抽象方式相差甚远。

而 React Team 的成员们，还在致力于不断地扩大两者之间的鸿沟。其结果就是，尽管 React Hooks 是一项具有开创性的优秀技术；然而，绝大部分 React 开发者，都难以理解和习惯 React Hooks 的一些机制。在这种情况下，React Team 依然不认为这是 React 的问题，不试图解决困扰开发者们的反直觉事物。他们反而认为，需要教育 React 开发者，逐渐适应 React 的模式和思想，建立新的直觉。

并且，React Team 对于过去 4 年多的教育成果感到满意：大部分 React 开发者都不会在 render 函数里操作 DOM 了，甚至有些开发者，已经忘记 DOM API 怎么用。React Team 对未来新的教育，也抱有信心。Rich 对此不以为然，他在分享的最后指出，Svelte 框架与 React 不同，它致力于以符合人脑思维习惯的方式去构建 UI。

函数式编程的根基 Lambda Calculus 是一个跟 Turing machine 计算能力等价的通用计算模型。而当前主流的计算机，是建立在 Turing machine 和冯诺依曼架构上的设备。其中充满了可变的状态和命令式的指令集。

所有编写的函数式代码，最终都是通过非函数式的方式，运行在我们的电脑上。那么，如果因为底层是有状态的，命令式的，就有了充分的理由去拥抱它。那函数式编程多年的发展，不可能存在。

# Reactivity

一种是以 Vue 为代表的 mutable + change tracking。即可变的数据结构，配合变更追踪，触发更新函数。另一种是以 React 为代表的 immutability + referential equality testing。即不可变的数据结构，配合反复执行的渲染函数，以及在函数执行过程中，通过数据的引用相等性判断，找出变更部分，只应用变化的部分到 UI 上。

Sebastian 文章开篇就表示，两种实践方式都有各自的权衡。因为 mutable 的方式，已经有其它框架们很好的研究，所以 React Team 决定专注于挖掘 immutble 的方向，看看最后能引领我们走到哪一步。

![三种 Reactivity 对比](https://s2.ax1x.com/2019/10/25/Kwqun0.jpg)
