# 文件读写

## 读取本地 JSON 文件

```html
<div>
  <input type="file" id="files" />
</div>

<script>
  var inputElement = document.getElementById("files");
  inputElement.addEventListener("change", handleFiles, false);
  function handleFiles() {
    var selectedFile = document.getElementById("files").files[0]; //获取读取的File对象
    var name = selectedFile.name; //读取选中文件的文件名
    var size = selectedFile.size; //读取选中文件的大小
    console.log("文件名:" + name + "大小：" + size);
    var reader = new FileReader(); //这里是核心！！！读取操作就是由它完成的。
    reader.readAsText(selectedFile); //读取文件的内容

    reader.onload = function () {
      console.log("读取结果：", this.result); //当读取完成之后会回调这个函数，然后此时文件的内容存储到了result中。直接操作即可。

      console.log("读取结果转为JSON：");
      let json = JSON.parse(this.result);
      console.log(json.name);
      console.log(json.age);
    };
  }
</script>
```

## JSON 文件的保存

```html
<script type="text/javascript" src="./js/FileSaver.js" charset="utf-8"></script>
<br />
<br />
<input type="button" id="export" value="保存" />

<script>
  var button = document.getElementById("export");
  button.addEventListener("click", saveHandler, false);
  function saveHandler() {
    let data = {
      name: "hanmeimei",
      age: 88,
    };
    var content = JSON.stringify(data);
    var blob = new Blob([content], { type: "text/plain;charset=utf-8" });
    saveAs(blob, "save.json");
  }
</script>
```
