# 文件处理

# Blob

我们也可以使用 FileReader 读取 blob 数据，并打印出来：

```js
const ab = new ArrayBuffer(32);
const iA = new Int8Array(ab);
iA[0] = 97;
const blob = new Blob([iA], { type: "application/octet-binary" });
const fr = new FileReader();
fr.addEventListener("load", function (ev) {
  console.log(ev.target.result); //会输出字符：a
});
fr.readAsText(blob);
```

如果要把 blob 文件转化为二进制的数据的话，要先把 blob 转化为 arraybuffer，然后再使用 typedArray 就可以直接编辑二进制数据了：

```js
const ab = new ArrayBuffer(32);
const iA = new Int8Array(ab);
iA[0] = 97;
const blob = new Blob([iA], { type: "application/octet-binary" });
const fr = new FileReader();
fr.addEventListener("load", function (ev) {
  const abb = ev.target.result;
  const iAA = new Int8Array(abb);
  console.log(iAA);
});
//把blob文件转化为arraybuffer；
fr.readAsArrayBuffer(blob);
```

`arraybuffer -->> typedarray -->> blob -->> blob` 通过 FileReader 转化为 arraybuffer 或者 text 文本或者 base64 字符串；arraybuffer 和 typedarray 主要是处理二进制，如果要把 blob 往二进制转换，必须先把 blob 转换为 arraybuffer，然后再转换为可以编辑的 typedArray；实际上，还有一种比较常用的数据类型，base64 编码的数据，常用的比如 image 的 base64 的编码，文本的 base64 编码等，也可以把 base64 的编码转化为对应的 ascll 码，再转化为 typearray，然后再生成 blob 对象：

```js
function dataURLtoBlob(dataurl) {
  const arr = dataurl.split(","),
    mime = arr[0].match(/:(.*?);/)[1],
    bstr = atob(arr[1]),
    n = bstr.length,
    u8arr = new Uint8Array(n);
  //通过atob把base64转化为ascll码，然后再把ascll码转化为字节码
  while (n--) {
    u8arr[n] = bstr.charCodeAt(n);
  }
  //u8arr就是2进制的数据
  return new Blob([u8arr], { type: mime });
}
```

# FileReader

通过 FileReader，我们能够方便地在 ArrayBuffer 与 Blob 之间转化：

```js
// ArrayBuffer -> Blob
const uint8Array = new Uint8Array([1, 2, 3]);
const arrayBuffer = uint8Array.buffer;
const blob = new Blob([arrayBuffer]);

// Blob -> ArrayBuffer
const uint8ArrayNew = null;
const arrayBufferNew = null;
const fileReader = new FileReader();
fileReader.onload = function (event) {
  arrayBufferNew = event.target.result;
  uint8ArrayNew = new Uint8Array(arrayBufferNew);

  // warn if read values are not the same as the original values
  // arrayEqual from: http://stackoverflow.com/questions/3115982/how-to-check-javascript-array-equals
  function arrayEqual(a, b) {
    return !(a < b || b < a);
  }
  if (arrayBufferNew.byteLength !== arrayBuffer.byteLength)
    // should be 3
    console.warn("ArrayBuffer byteLength does not match");
  if (arrayEqual(uint8ArrayNew, uint8Array) !== true)
    // should be [1,2,3]
    console.warn("Uint8Array does not match");
};
fileReader.readAsArrayBuffer(blob);
fileReader.result; // also accessible this way once the blob has been read
```
