# 前端数据检索

# 第三方库使用

## Fuse.js

```sh
$ npm install fuse.js
```

在 TypeScript 中，我们可以准备如下的数据：

```ts
// Requires --esModuleInterop compiler flag!
// import * as Fuse with '--allowSyntheticDefaultImport'
// or import Fuse = require('fuse.js') with neither
import Fuse from "fuse.js";

type SimpleBookFuse = {
  title: string;
  author: {
    firstName: string;
    lastName: string;
  };
  tags: string[];
};

const books: SimpleBookFuse[] = [
  {
    title: "Old Man's War",
    author: {
      firstName: "John",
      lastName: "Scalzi"
    },
    tags: ["fiction"]
  },
  {
    title: "The Lock Artist",
    author: {
      firstName: "Steve",
      lastName: "Hamilton"
    },
    tags: ["thriller"]
  }
];
```

然后自定义 Fuse 实例以进行检索：

```ts
const options: Fuse.FuseOptions<SimpleBookFuse> = {
  keys: ['author', 'tags']
};
const fuse = new Fuse(books, options);

const results = fuse.search('tion');

[{
  "title": "The Lock Artist",
  "author": {
    "tags": [{
      "value": "English"
    }]
  }
}]

// IDE's will show full IntelliSense support
// for example when using
results[0].ti... => suggested to expand to title
```
