# 浏览器对象

# Window

## Location

Location 对象存储在 Window 对象的 Location 属性中，表示那个窗口中当前显示的文档的 Web 地址。它的 href 属性存 放的是文档的完整 URL，其他属性则分别描述了 URL 的各个部分。这些属性与 Anchor 对象(或 Area 对象)的 URL 属性非常相似。当一个 Location 对象被转换成字符串，href 属性的值被返回。这意味着你可以使用表达式 location 来替代 location.href。不过 Anchor 对象表示的是文档中的超链接，Location 对象表示的却是浏览器当前显示的文档的 URL(或位置)。但是 Location 对象所能做的远远不止这些，它还能控制浏览器显示的文档的位置。如果把一个含有 URL 的字符串赋予 Location 对象或它的 href 属性，浏览器就会把新的 URL 所指的文档装载进来，并显示出来。

除了设置 location 或 location.href 用完整的 URL 替换当前的 URL 之外，还可以修改部分 URL，只需要给 Location 对象的其他属性赋值即可。这样做就会创建新的 URL，其中的一部分与原来的 URL 不同，浏览器会将它装载并显示出来。例如，假设设置了 Location 对象的 hash 属性，那么浏览器就会转移到当前文档中的一个指定的位置。同样，如果设置了 search 属性，那么浏览器就会重新装载附加了新的查询字符串的 URL。

除了 URL 属性外，Location 对象的 reload() 方法可以重新装载当前文档，replace()  可以装载一个新文档而无须为它创建一个新的历史记录，也就是说，在浏览器的历史列表中，新文档将替换当前文档。

### Location 对象属性

| 属性                                                               | 描述                                      |
| ------------------------------------------------------------------ | ----------------------------------------- |
| [hash](http://www.w3school.com.cn/jsref/prop_loc_hash.asp)         | 设置或返回从井号 (#) 开始的 URL(锚)，     |
| [host](http://www.w3school.com.cn/jsref/prop_loc_host.asp)         | 设置或返回主机名和当前 URL 的端口号，     |
| [hostname](http://www.w3school.com.cn/jsref/prop_loc_hostname.asp) | 设置或返回当前 URL 的主机名，             |
| [href](http://www.w3school.com.cn/jsref/prop_loc_href.asp)         | 设置或返回完整的 URL，                    |
| [pathname](http://www.w3school.com.cn/jsref/prop_loc_pathname.asp) | 设置或返回当前 URL 的路径部分，           |
| [port](http://www.w3school.com.cn/jsref/prop_loc_port.asp)         | 设置或返回当前 URL 的端口号，             |
| [protocol](http://www.w3school.com.cn/jsref/prop_loc_protocol.asp) | 设置或返回当前 URL 的协议，               |
| [search](http://www.w3school.com.cn/jsref/prop_loc_search.asp)     | 设置或返回从问号 (?) 开始的 URL(查询部分) |

### Location 对象方法

| 属性                                                              | 描述                   |
| ----------------------------------------------------------------- | ---------------------- |
| [assign()](http://www.w3school.com.cn/jsref/met_loc_assign.asp)   | 加载新的文档，         |
| [reload()](http://www.w3school.com.cn/jsref/met_loc_reload.asp)   | 重新加载当前文档，     |
| [replace()](http://www.w3school.com.cn/jsref/met_loc_replace.asp) | 用新的文档替换当前文档 |

### Properties

对于这样一个 URL

http://www.maidq.com/index.html?ver=1.0&id=6#imhere

我们可以用 javascript 获得其中的各个部分

1, window.location.href 整个 URl 字符串(在浏览器中就是完整的地址栏) 本例返回值: http://www.maidq.com/index.html?ver=1.0&id=6#imhere

2,window.location.protocol URL 的协议部分 本例返回值:http:

3,window.location.host URL 的主机部分 本例返回值:www.maidq.com

4,window.location.port URL 的端口部分 如果采用默认的 80 端口(update:即使添加了:80)，那么返回值并不是默认的 80 而是空字符 本例返回值:""

5,window.location.pathname URL 的路径部分(就是文件地址) 本例返回值:/fisker/post/0703/window.location.html

6,window.location.search 查询(参数)部分 除了给动态语言赋值以外，我们同样可以给静态页面,并使用 javascript 来获得相信应的参数值 本例返回值:?ver=1.0&id=6

7,window.location.hash 锚点 本例返回值:#imhere

### Methods

### 获取路径参数

```js
function GetQueryString(name) {
  var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
  var r = window.location.search.substr(1).match(reg);
  if (r != null) return unescape(r[2]);
  return null;
}
// 调用方法
alert(GetQueryString("参数名1"));
alert(GetQueryString("参数名2"));
alert(GetQueryString("参数名3"));
```

# Performance:性能测试

- [Performance API](http://javascript.ruanyifeng.com/bom/performance.html)
