# 文档事件

## DomReady(页面加载完成)

在实际应用中，我们经常会遇到这样的场景，当页面加载完成后去做一些事情：[绑定事件](http://www.popo4j.com/tag/bind.html)、[DOM](http://www.popo4j.com/tag/DOM.html)操作某些结点等。原来比较常用的是 window 的 onload [事件](http://www.popo4j.com/tag/ShiJian.html)，而该事件的实际效果是：当页面解析/DOM 树建立完成，并完成了诸如图片、脚本、样式表甚至是 iframe 中所有资源的下载后才触发的。这对于很多 实际的应用而言有点太“迟”了，比较影响用户体验。为了解决这个问题，[ff](http://www.popo4j.com/tag/ff.html)中便增加了一个 DOMContentLoaded 方法，与 onload 相比，该 方法触发的时间更早，它是在页面的 DOM 内容加载完成后即触发，而无需等待[其他](http://www.popo4j.com/tag/QiTa.html)资源的加载。Webkit 引擎从版本 525(Webkit nightly 1/2008:525+)开始也引入了该事件，Opera 中也包含该方法。到目前为止主[流](http://www.popo4j.com/tag/Liu.html)的 IE 仍然没有要添加的意思。虽然 IE 下没有，但总是有解决办法 的，[这篇文章](http://www.cnblogs.com/JulyZhang/archive/2011/02/12/1952484.html)对比了一下几大主流框架对于该事件的兼容性版本实现方案，涉及的框架包括：

1. Prototype
2. jQeury
3. moontools
4. dojo
5. yui
6. ext

最后总结各大框架的 Polyfill 方法，可以得到如下一个函数：

```js
/*
 * 注册浏览器的DOMContentLoaded事件
 * @param { Function } onready [必填]在DOMContentLoaded事件触发时需要执行的函数
 * @param { Object } config [可选]配置项
 */
function onDOMContentLoaded(onready, config) {
  //浏览器检测相关对象，在此为节省代码未实现，实际使用时需要实现。
  //var Browser = {};
  //设置是否在FF下使用DOMContentLoaded(在FF2下的特定场景有Bug)
  this.conf = {
    enableMozDOMReady: true
  };
  if (config) for (var p in config) this.conf[p] = config[p];
  var isReady = false;
  function doReady() {
    if (isReady) return; //确保onready只执行一次
    isReady = true;
    onready();
  } /*IE*/
  if (Browser.ie) {
    (function() {
      if (isReady) return;
      try {
        document.documentElement.doScroll("left");
      } catch (error) {
        setTimeout(arguments.callee, 0);
        return;
      }
      doReady();
    })();
    window.attachEvent("onload", doReady);
  } /*Webkit*/ else if (Browser.webkit && Browser.version < 525) {
    (function() {
      if (isReady) return;
      if (/loaded|complete/.test(document.readyState)) doReady();
      else setTimeout(arguments.callee, 0);
    })();
    window.addEventListener("load", doReady, false);
  } /*FF Opera 高版webkit 其他*/ else {
    if (!Browser.ff || Browser.version != 2 || this.conf.enableMozDOMReady)
      document.addEventListener(
        "DOMContentLoaded",
        function() {
          document.removeEventListener(
            "DOMContentLoaded",
            arguments.callee,
            false
          );
          doReady();
        },
        false
      );
    window.addEventListener("load", doReady, false);
  }
}
```

## Page Visibility(页面可见性)

该 API 可以用来检测页面对于用户的可见性，即返回用户当前浏览的页面或标签 tap 的状态变化。在最小化浏览器、切换 tap 页面时生效.(如需对 app 中几个 webview 进行切换操作时，可使用 pageVisibility 接口进行相应的事件监听和处理。)

对于 visibility 的改变，我们可以怎么用了做什么呢。

- 我们可以对那些定期刷新内容的页面进行控制，当该页面不可见则不刷新，可见则刷新
- 我们还可以根据页面的是否可见来暂停和继续音频，视频的播放
- 我们还可以根据页面可见去计算我们网站的用户停留在本页面的更为精确的数据，而不仅仅是打开页面而不停留在本页面。

page visibility 的介绍

`【document.hidden】` 该值表示 page 是否是可见的,值为 boolean 值

`【document.visibilityState】` 这个 visibilitystate 可有三个值得可能：

> 【visible】 表示该 page 是处于最前面的页面并且不是处于一个最小化的窗口
>
> 【hidden】 表示该 page 不是处于最前面的页面或者是处于一个最小化的窗口
>
> 【prerender】 表示该页面内容正在重新渲染并且该页面对于用户是不可见的

`【isibilitychange Event】`监听 window visibility 的改变的事件

```js
// 设置隐藏属性和可见改变事件的名称，属性需要加浏览器前缀  // since some browsers only offer vendor-prefixed support  var hidden, state, visibilityChange;
if (typeof document.hidden !== "undefined") {
  hidden = "hidden";
  visibilityChange = "visibilitychange";
  state = "visibilityState";
} else if (typeof document.mozHidden !== "undefined") {
  hidden = "mozHidden";
  visibilityChange = "mozvisibilitychange";
  state = "mozVisibilityState";
} else if (typeof document.msHidden !== "undefined") {
  hidden = "msHidden";
  visibilityChange = "msvisibilitychange";
  state = "msVisibilityState";
} else if (typeof document.webkitHidden !== "undefined") {
  hidden = "webkitHidden";
  visibilityChange = "webkitvisibilitychange";
  state = "webkitVisibilityState";
}
// 添加一个标题改变的监听器
document.addEventListener(
  visibilityChange,
  function(e) {
    // 开始或停止状态处理
  },
  false
);
```

## Full Screen(全屏)

该 API 允许开发者以编程方式将 Web 应用程序全屏运行，使 Web 应用程序更像本地应用程序。十分简单有用的 api。

FullScreen 的 API 使用非常简单，其有**两种模式**

- **Launching Fullscreen Mode 启动全屏模式**

``` 
    // 找到适合浏览器的全屏方法  function launchFullScreen(element) {  
  if(element.requestFullScreen) {  
    element.requestFullScreen();  
  } else if(element.mozRequestFullScreen) {  
    element.mozRequestFullScreen();  
  } else if(element.webkitRequestFullScreen) {  
    element.webkitRequestFullScreen();  
  }  
}  
// 启动全屏模式  
launchFullScreen(document.documentElement); // the whole page  
launchFullScreen(document.getElementById("videoElement")); // any individual element

```

- **Exit FullScreen Mode 退出全屏模式**

```js
// Whack fullscreenfunction exitFullscreen() {
  if(document.exitFullscreen) {
    document.exitFullscreen();
  } else if(document.mozCancelFullScreen) {
    document.mozCancelFullScreen();
  } else if(document.webkitExitFullscreen) {
    document.webkitExitFullscreen();
  }
}

// Cancel fullscreen for browsers that support it!
exitFullscreen();

```

Full Screen 的相关属性和事件

目前 fullscreen 仍存在兼容的问题，许多能使用的浏览器仍需要在其相应的属性和事件加相关的前缀。

`【document.fullScreenElement】` 该属性表示启动全屏的元素(如 video 这些)

`【document.fullScreenEnabled】`该属性表示当前是否全屏

`【fullscreenchange 事件】` 监听全屏状态改变的事件

2.2 Full Scrren 的相关

css 有一些关于 fullscreen 的 css 属性

``` 
:-webkit-full-screen,
:-moz-full-screen,
:-ms-fullscreen,
:full-screen {
    /*pre-spec */
   /* properties */
}
:fullscreen { 
    /* spec */
   /* properties */
}
/* deeper elements */:-webkit-full-screen video {
   width: 100%;
   height: 100%;
}
/* styling the backdrop*/::backdrop {
  /* properties */
}
::-ms-backdrop {
  /* properties */
}

```

FullScreen 的小结

第一次见到这个 API 是在看一些手机小说和移动端漫画网站时，发现其有全屏的观看的功能。全屏 api 目前可能存在兼容性的问题，但相信不久的将来肯定会是一个使用频率超高的 api

# 元素事件

## Resize

- [simple-element-resize-detector](https://github.com/developit/simple-element-resize-detector)
