# Document Flow:文档流

将窗体自上而下分成一行行，并在每行中按从左至右的顺序排放元素，即为文档流。HTML 中元素可分为三大类：

- 块级元素(block level)：总是以一个块的形式表现出来，并且跟同级的兄弟一次竖直排列，左右撑满。
- 行内元素(inline)：对于文字这类元素，各个字母之间横向排列，到最右端自动折行，这就是另一种元素，称为“行内元素”。
- 浮动元素：浮动元素则按规定浮在行的一端。若当前行容不下，则另起新行再浮动。

有三种情况将使得元素脱离文档流而存在，分别是浮动，绝对定位(absolute)，固定定位(fixed)。但是在 IE 中浮动元素也存在于文档流中。

正常流是页面，大部分盒排布于正常流中。正常流中的盒必定位于某一格式化上下文中，正常流中有两种格式化上下文：块级格式化上下文(block formatting context，简称 BFC)和行内格式化上下文(inline formatting context,IFC)。在块级格式化上下文中，盒呈纵向排布，在行内格式化上下文中，盒则呈横向排布。正常流根容器中是块级格式化上下文，不同的盒可能会在内部产生行内格式化上下文或者块级格式化上下文。

正常流中的盒分为块级与行内级两种，任何一个行内级盒都不能够直接被放入块级格式化上下文中。如果有一个 HTML 元素生成了一个行内盒，而其所在的上下文是块级的话，那么应当为它生成一个匿名块级盒，匿名块级盒会在内部生成行内格式化上下文。元素的 display 属性会决定盒是行内级还是块级：
block, table, flex, grid, list-item 为块级
inline, inline-block, inline-table, inline-flex, inline-grid 为行内级

# BFC: 块级格式化上下文

具有 BFC 特性的元素可以看作是隔离了的独立容器，容器里面的元素不会在布局上影响到外面的元素，并且 BFC 具有普通容器所没有的一些特性。

- body 根元素
- 浮动元素：float 除 none 以外的值
- 绝对定位元素：position (absolute、fixed)
- display 为 inline-block、table-cells、flex
- overflow 除了 visible 以外的值 (hidden、auto、scroll)

## 定义与触发

## 特性与应用

# 属性详解

## display

## position

我们先来看看 CSS3 Api 中对 position 属性的相关定义：

static：无特殊定位，对象遵循正常文档流。top，right，bottom，left 等属性不会被应用。
relative：对象遵循正常文档流，但将依据 top，right，bottom，left 等属性在正常文档流中偏移位置。而其层叠通过 z-index 属性定义。
absolute：对象脱离正常文档流，使用 top，right，bottom，left 等属性进行绝对定位。而其层叠通过 z-index 属性定义。
fixed：对象脱离正常文档流，使用 top，right，bottom，left 等属性以窗口为参考点进行定位，当出现滚动条时，对象不会随着滚动。而其层叠通过 z-index 属性定义。

- 静态定位 / static: static，无特殊定位，它是 html 元素默认的定位方式，即我们不设定元素的 position 属性时默认的 position 值就是 static，它遵循正常的文档流对象，对象占用文档空间，该定位方式下，top、right、bottom、left、z-index 等属性是无效的。

- 相对定位(relative): relative 定位，又称为相对定位，从字面上来解析，我们就可以看出该属性的主要特性：相对。但是它相对的又是相对于什么地方而言的呢？这个是个重点，也是最让我迷糊的一个地方，现在让我们来做个测试，我想大家都会明白的：

# Center: 元素居中

## Horizonal Centering: 水平居中

## Vertical Centering: 垂直居中
