# 语义化标签

# 头标签

# 元标签

```html
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
<meta http-equiv="expires" content="Thu, 9 Sep 2015 12:45:43 GMT" />
<meta http-equiv="set-cookie" content="name=value; expires=date; path=url" />
<meta http-equiv="content-encoding" content="gzip" />
<meta http-equiv="allow" content="methods" />
<meta http-equiv="date" content="Thu, 9 Sep 2015 12:45:43 GMT" />
<meta http-equiv="last-modified" content="Thu, 9 Sep 2015 12:45:43 GMT" />
<meta http-equiv="location" content="5;http://www.frontendevelopers.com/" />
<meta http-equiv="refresh" content="5 url="http://www.frontendevelopers.com/" />
<meta http-equiv="window-target" content="_top" />
<meta http-equiv="www-authenticate" content="" />
<meta http-equiv="pics-label" content="labellist" />
<meta http-equiv="pragma" content="option" />
<meta http-equiv="cache-control" content="no-cache" />
<meta http-equiv="content-language" content="en-US,de" />
<meta http-equiv="content-script-type" content="text/VBscript" />
<meta
  http-equiv="page-enter"
  content="revealtrans(duration=seconds,transition=num)"
/>
<meta
  http-equiv="page-exit"
  content="revealtrans(duration=seconds,transition=num)"
/>
<meta http-equiv="imagetoolbar" content="no" />
```

```html
<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon" />
<link rel="icon" href="/favicon.ico" type="image/x-icon" />
<link rel="apple-touch-icon" sizes="57x57" href="/apple-icon-57x57.png" />
<link rel="apple-touch-icon" sizes="60x60" href="/apple-icon-60x60.png" />
<link rel="apple-touch-icon" sizes="72x72" href="/apple-icon-72x72.png" />
<link rel="apple-touch-icon" sizes="76x76" href="/apple-icon-76x76.png" />
<link rel="apple-touch-icon" sizes="114x114" href="/apple-icon-114x114.png" />
<link rel="apple-touch-icon" sizes="120x120" href="/apple-icon-120x120.png" />
<link rel="apple-touch-icon" sizes="144x144" href="/apple-icon-144x144.png" />
<link rel="apple-touch-icon" sizes="152x152" href="/apple-icon-152x152.png" />
<link rel="apple-touch-icon" sizes="180x180" href="/apple-icon-180x180.png" />
<link
  rel="icon"
  type="image/png"
  sizes="192x192"
  href="/android-icon-192x192.png"
/>
<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png" />
<link rel="icon" type="image/png" sizes="96x96" href="/favicon-96x96.png" />
<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png" />
<link rel="manifest" href="/manifest.json" />
<meta name="msapplication-TileColor" content="#ffffff" />
<meta name="msapplication-TileImage" content="/ms-icon-144x144.png" />
<meta name="theme-color" content="#ffffff" />
```

可以使用 [Favico.js](http://lab.ejci.net/favico.js/) 来实现动态的 Favico。

[react-document-meta](https://github.com/kodyl/react-document-meta) 或者 [react-helmet](https://github.com/nfl/react-helmet)

```js
import React from "react";
import DocumentMeta from "react-document-meta";

class Example extends React.Component {
  render() {
    const meta = {
      title: "Some Meta Title",
      description: "I am a description, and I can create multiple tags",
      canonical: "http://example.com/path/to/page",
      meta: {
        charset: "utf-8",
        name: {
          keywords: "react,meta,document,html,tags"
        }
      }
    };

    return (
      <div>
        <DocumentMeta {...meta} />
        <h1>Hello World!</h1>
      </div>
    );
  }
}

React.render(<Example />, document.getElementById("root"));
```
