# HTML 规范与模板

XHTML 是 HTML 像 XML 的一个过渡语言，它比 HTML 严谨性会高点，然后基本语言都还是沿用的 HTML 的标签，只不过废除了部分表现层的标签，同事在标准上要求高了点比如标签的严格嵌套，标签结束等等。

## DOCTYPE: 声明当前文档规范

<!DOCTYPE> 声明位于文档中的最前面的位置，处于 <html> 标签之前。此标签可告知浏览器文档使用哪种 HTML或XHTML 规范。该标签可声明三种 DTD 类型，分别表示严格版本、过渡版本以及基于框架的 HTML 文档。

- HTML 5

```
<!DOCTYPE html>
```

- HTML 4.01 Strict

该 DTD 包含所有 HTML 元素和属性，但不包括展示性的和弃用的元素(比如 font)。不允许框架集(Framesets)。

```
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
```

- HTML 4.01 Transitional

该 DTD 包含所有 HTML 元素和属性，包括展示性的和弃用的元素(比如 font)。不允许框架集(Framesets)。

```
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
```

- HTML 4.01 Frameset

该 DTD 等同于 HTML 4.01 Transitional，但允许框架集内容。

```
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN"
"http://www.w3.org/TR/html4/frameset.dtd">
```

- XHTML 1.0 Strict

该 DTD 包含所有 HTML 元素和属性，但不包括展示性的和弃用的元素(比如 font)。不允许框架集(Framesets)。必须以格式正确的 XML 来编写标记。

```
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
```

- XHTML 1.0 Transitional

该 DTD 包含所有 HTML 元素和属性，包括展示性的和弃用的元素(比如 font)。不允许框架集(Framesets)。必须以格式正确的 XML 来编写标记。

```
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "
http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
```

- XHTML 1.0 Frameset

该 DTD 等同于 XHTML 1.0 Transitional，但允许框架集内容。

```
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd">
```

- XHTML 1.1

该 DTD 等同于 XHTML 1.0 Strict，但允许添加模型(例如提供对东亚语系的 ruby 支持)。

```
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
```

HTML5 的概念在近些年非常火爆，其核心一方面是对于 HTML 语言本身的改进以及浏览器支持度的升级，也包括了利用 HTML 语言对于现在流行的 Mobile First 概念的诠释。

[HTML5 Boilerplate][1]提供了一套 HTML5 的规范化库与建议写法，同时也提供了一些模板，来方便你快速搭建响应式网站。

```html
<!DOCTYPE html>
<html class="no-js" lang="">
  <head>
    <meta charset="utf-8" />
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <title></title>
    <meta name="description" content="" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />

    <link rel="apple-touch-icon" href="apple-touch-icon.png" />
    <!-- Place favicon.ico in the root directory -->

    <link rel="stylesheet" href="css/normalize.css" />
    <link rel="stylesheet" href="css/main.css" />
    <script src="js/vendor/modernizr-2.8.3.min.js"></script>
  </head>
  <body>
    <!--[if lt IE 8]>
      <p class="browserupgrade">
        You are using an <strong>outdated</strong> browser. Please
        <a href="http://browsehappy.com/">upgrade your browser</a> to improve
        your experience.
      </p>
    <![endif]-->

    <!-- Add your site or application content here -->
    <p>Hello world! This is HTML5 Boilerplate.</p>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
    <script>
      window.jQuery ||
        document.write(
          '<script src="js/vendor/jquery-1.11.3.min.js"><\/script>'
        );
    </script>
    <script src="js/plugins.js"></script>
    <script src="js/main.js"></script>

    <!-- Google Analytics: change UA-XXXXX-X to be your site's ID. -->
    <script>
      (function (b, o, i, l, e, r) {
        b.GoogleAnalyticsObject = l;
        b[l] ||
          (b[l] = function () {
            (b[l].q = b[l].q || []).push(arguments);
          });
        b[l].l = +new Date();
        e = o.createElement(i);
        r = o.getElementsByTagName(i)[0];
        e.src = "https://www.google-analytics.com/analytics.js";
        r.parentNode.insertBefore(e, r);
      })(window, document, "script", "ga");
      ga("create", "UA-XXXXX-X", "auto");
      ga("send", "pageview");
    </script>
  </body>
</html>
```

### Mobile-First Boilerplate

```html
<!DOCTYPE html>
<html class="no-js">
  <head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <meta
      name="viewport"
      content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no"
    />
    <title>Hello Amaze UI</title>

    <!-- Set render engine for 360 browser -->
    <meta name="renderer" content="webkit" />

    <!-- No Baidu Siteapp-->
    <meta http-equiv="Cache-Control" content="no-siteapp" />

    <link rel="icon" type="image/png" href="assets/i/favicon.png" />

    <!-- Add to homescreen for Chrome on Android -->
    <meta name="mobile-web-app-capable" content="yes" />
    <link rel="icon" sizes="192x192" href="assets/i/app-icon72x72@2x.png" />

    <!-- Add to homescreen for Safari on iOS -->
    <meta name="apple-mobile-web-app-capable" content="yes" />
    <meta name="apple-mobile-web-app-status-bar-style" content="black" />
    <meta name="apple-mobile-web-app-title" content="Amaze UI" />
    <link
      rel="apple-touch-icon-precomposed"
      href="assets/i/app-icon72x72@2x.png"
    />

    <!-- Tile icon for Win8 (144x144 + tile color) -->
    <meta
      name="msapplication-TileImage"
      content="assets/i/app-icon72x72@2x.png"
    />
    <meta name="msapplication-TileColor" content="#0e90d2" />

    <link rel="stylesheet" href="assets/css/amazeui.min.css" />
    <link rel="stylesheet" href="assets/css/app.css" />
  </head>
  <body>
    <p>Hello Amaze UI.</p>

    <!--在这里编写你的代码-->

    <!--[if (gte IE 9)|!(IE)]><!-->
    <script src="assets/js/jquery.min.js"></script>
    <!--<![endif]-->
    <!--[if lte IE 8]>
      <script src="http://libs.baidu.com/jquery/1.11.3/jquery.min.js"></script>
      <script src="http://cdn.staticfile.org/modernizr/2.8.3/modernizr.js"></script>
      <script src="assets/js/amazeui.ie8polyfill.min.js"></script>
    <![endif]-->
    <script src="assets/js/amazeui.min.js"></script>
  </body>
</html>
```

# Semantic HTML

我们对于 HTML 的学习，背标签记属性只是表象，背后的是学习如何去用语义化分析页面，做出合理的 HTML 文档结构。
![](http://media02.hongkiat.com/html-5-semantics/document-outline-example.jpg)

语义化的第一个层面是选择正确的标签。比如在 HTML5 标准中新增了很多语义化的标签，利用好这些标签可以更清晰的表达页面的内容。再比如我们要加粗一段文字，可以选择用 strong 标签，或者用 CSS 的 font-weight 属性加粗，选择哪一种方式呢？如果是为了强调内容，那么我们选择标签加粗，如果是设计样式，并不表示着重和强调，选用 CSS 来处理更好一些。

语义化的第二个层面是选择正确的 id 和 class 命名。因为常用的 HTML 标签只有大约 50 个，比如 title，subtitle，close 这种也很常见的语义并没有对应的标签，要通过 class 的方式体现出来。HTML 标准中有两个无意义的标签：div 和 span，纯粹的块级元素和行内元素。我和学生说，永远不要不带 class 或者 id 裸写 div 元素，div 元素不能单独表意，我们通过 class 去命名它，并不是为了要给 CSS 去用，而是真实的为了表明它在这个页面的结构中扮演了什么角色。比如它是个标题(title)，或者是个备注(note)，这些 HTML 标签覆盖不到的语义，我们用 class 来补充。

id 和 class 又有什么区别？class 指的是一个类别，比如程序员，电脑，键盘。而 id 指的是某一个具体的东西，比如我这个程序员，公司的电脑，我家的机械键盘。初学者往往会混淆两个概念，不知道什么时候要用 id，或者用命名 id 的原则命名 class，比如设置一个 class 名为“my_photo_1”，这很明显是一个具体的东西，我们先来看这个元素是不是需要被选中，如果确实需要的话，能不能用更通用的选择器，而不需要设置一个这样特殊的类名。

这里还要说到 class 的命名策略。有一段时间很流行 BEM 命名法，追捧的人很多，诟病的人也很多，虽然略显繁琐，但是确实也是语义化的一个很好实践。与之相对的另一种极端的原子类命名法，命名的原则更多的受样式影响，语义被样式左右，就完全背离了 HTML+CSS 这种分离语义和样式的初衷。
语义化第三个层面是文档结构。作家写作是从大纲到章节，画家作图是从框架到细节。而我们切图的原则同样是从大到小，从外到内。

# Boilerplate

- https://html5boilerplate.com/
- http://segmentfault.com/a/1190000002884052
- http://www.uisdc.com/tgideas-html5-api-test-1
