# 断点调试

本篇主要讨论 VSCode 中的断点调试是如何实现的，最简单的方式自然是直接调试 VSCode 源码，在安装依赖后点击调试按钮，先点击 Launch VS Code，待 VSCode-OSS 启动后打开一个简单的调试项目，再点击 Attach to Extension Host 对 ExtensionHost 进程进行调试，此时便可针对调试的核心代码进行调试了。

![VSCode 断点调试流程](https://s2.ax1x.com/2019/09/11/nwguTO.png)

从时序图我们可以看出，整个调试的流程无非就是简单的视图层到调试进程间的通讯，调试的核心在于在多个调试器中实现了统一的数据传输协议，即 DAP(Debug Adapter Protocol) 协议。

# DAP

调试适配器协议（DAP）背后的想法是抽象开发工具的调试支持与调试器或运行时通信协议的方式。对于现有的调试器想要去快速去实现这套协议是不现实的，故我们宁愿去实现一个调试的中间层，即一个调试适配器，去使现有的调试器去适应这套调试适配器协议。调试适配器协议让开发工具实现通用调试器成为可能，同时对应的调试器也可以通过调试适配器与不同的调试器通信。调试适配器可以在多个开发工具中重复使用，这大大减少了在不同工具中支持新调试器的工作量。

通过实现适配器，让不同的调试器实现在工具端上的接入达到统一，即由适配器负责去管理上下游消息通信时的数据处理及转换工作，从多个 IDE 工具自己去适配调试器，逐渐演变为多个 IDE 工具去适配同一套调试协议，如下图所示：

![调试模式的演化](https://s2.ax1x.com/2019/09/11/nwg81A.md.png)

图右可以看出，从左侧调试 UI 消息到达对应调试器（Debugger）中间通过 Adaptor 层统一进行消息的转换，一旦调试相关的消息通讯协议达到一定完成度，工具侧便可无需进行任何修改支持多个调试器中的调试逻辑。
