> 本文翻译整理自 FreeCodeCamp 的 [From Zero to Frontend Hero](https://medium.freecodecamp.com/from-zero-to-front-end-hero-part-1-7d4f7f0bff02#.ailsv41bd) 系列，归档于[现代 Web 全栈开发与工程架构 https://github.com/wx-chevalier/Web-Notes](https://github.com/wx-chevalier/Web-Notes) 系列。

# 从路人甲到英雄无敌的前端开发指南

记得那年，我初学前端，遇见了很多的文章，在浩瀚的知识海洋里我手足无措，不知从何开始。己所不欲，勿施于人。这篇文章就会帮你去遨游前端学习的海洋，主要包含了在我之前的学习过程中整理的一些资源和一些感悟。我打算将整篇文章切分为两部分，第一部分重温 HTML 与 CSS 的基本知识，第二部分概括 JavaScript、前端框架与设计模式。

# HTML 与 CSS 基础

前端的领域里，任何东西都离不开[HTML](https://en.wikipedia.org/wiki/HTML) 与 [CSS](https://en.wikipedia.org/wiki/Cascading_Style_Sheets)。HTML 与 CSS 基本上控制了你看到的所有东西，HTML 用来定义内容而 CSS 负责样式与布局。

首先从[HTML](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/Introduction) 以及 [CSS](https://developer.mozilla.org/en-US/docs/Web/Guide/CSS/Getting_Started/What_is_CSS) 开始，这里推荐的是 MDN 的官方指南。MDN 对于重要的 HTML 与 CSS 内容进行了详细条理的阐述，除此之外，每一章都是单独的一页，提供了在 CodePen 与 JSFiddle 展示的 Demo。看完了这些基础教程之后，可以来看看由 CodeAcademy 提供的 t[Make a Website](https://www.codecademy.com/learn/make-a-website)系列课程。这个课程只要几个小时就能看完，如果你想要更多的锻炼，可以瞅瞅[CSS Diner](http://flukeout.github.io/)，这是一个 CSS 挑战的小游戏。最后，可以看看怎么使用 [Google Fonts](https://www.google.com/fonts)，参考下 CSSTricks 出的[Basics of Google Font API](https://css-tricks.com/snippets/css/basics-of-google-font-api/)。

> 国内用不了 Google Fonts 的话可以参考下 FontAwesome，如果你要用中文字体的话建议参考 FontSpider，请自行 Github 搜索。

Typography-- 排版也是个构建界面时候很重要的部分，有时间的话推荐你看看 Donny Truong 写的[Professional Web Typography](https://prowebtype.com/)这本书，它会教你基本上关于排版的所有东西。在学习这些的时候不要太担心自己会忘了，反正记不住。你应该着重于记录这些并且理解 HTML 和 CSS 是怎么工作的。

# Practicing HTML and CSS Basics

到这里你应该已经明白了 HTML 与 CSS 的基本使用，下面我们要学以致用了。这一部分就设计了两个小实验来让你自己动手构建网站与界面。我是把它们形容成实验，所以不要害怕失败。

## Experiment 1

第一个实验里，我们用的是[CodePen](http://codepen.io/)，一个在线的 HTML 与 CSS 实验台。同时也提供了实时预览功能，一石二鸟呦。好了，下面我们要看看我们做的界面的原型了，转到 [Dribbble](https://dribbble.com/)吧, 这嘎达可全是设计创意啊。我是看上了这个系列：[1](https://dribbble.com/shots/2262761-Mobile-Blog-App-Interface/attachments/424147), [2](https://dribbble.com/shots/2492038-Task-List-App/attachments/489171), [3](https://dribbble.com/shots/2144170-Day-014-Location-Card/attachments/392323), [4](https://dribbble.com/shots/2639709-Confirm-Reservation/attachments/528798), 以及 [5](https://dribbble.com/shots/2314157-Daily-UI-Day-1/attachments/439137).。我选择了一个移动优先的设计是因为与桌面设计相比更简单一点，不过你也可以自己找一个。

在你选定了设计之后，就可以在 CodePen 上面开始动手了。你也可以看看其他人设计的 Pen: [pens on CodePen](http://codepen.io/pens/). 另外，别忘了[StackOverflow](http://stackoverflow.com/)，这可是你的小伙伴呦。如果你最后实现的东西跟设计相去甚远，也不要灰心，不断尝试总会提高的。## Experiment 2 经过实验一估计你已经有点自信了，在实验二里面我们将会先借鉴一些大公司的经典站点。有不少站点会用一些 CSS 框架或者混淆它们的 CSS 类名，这会让源代码的阅读比较麻烦，这嘎达我列举了几个源代码可读性比较好的：

- [Dropbox for Business](https://www.dropbox.com/business): Try replicating their [hero](https://en.wikipedia.org/wiki/Hero_image) section

- [AirBnB](https://www.airbnb.com/): Try replicating their footer

- [PayPal](https://www.paypal.com/home): Try replicating their navigation bar

- [Invision](http://www.invisionapp.com/): Try replicating their signup section at the bottom of the page

- [Stripe](https://stripe.com/us/pricing): Try replicating their payments section

再次强调下，实验二的目的并不是让你去重构整个页面，而是知道怎么去分割组件以及人家是怎么做的。如果你没有设计的背景，可能你要好好发掘下你的潜能了。一个优秀的前端开发者要能够辨别好的设计然后完美地重现它们，可以参考下我的这篇文章：[develop your design eye](https://medium.com/@JonathanZWhite/developing-your-eye-for-design-cce944bbeae4#.tsg9204dm).

你可以选择在线编程：[CodePen](http://codepen.io/) 或者直接本地开发。如果你选择本地做，那你可以使用这个 [模板项目](https://github.com/murtaugh/HTML5-Reset)。我推荐是使用[Atom](https://atom.io/) 或者[Sublime](https://www.sublimetext.com/)这样的编辑器。另外，对于 Firefox 或者 Chrome 自带的控制台与开发者工具也要好好瞅瞅。

# HTML and CSS Best Practices

好了，现在你已经能够用 HTML 与 CSS 做一些简单的事情了，下面就要看看所谓的最佳实践了。最佳实践实际上就是一系列的在日常开发中总结出来的约定俗成的规范的集合，来让你更快地开发与构建更高质量的代码。

## **Semantic Markup**: 语义标记

HTML 与 CSS 最佳实践中重要的一条就是怎么来写出有语义可读性的标记。好的语义即是你使用了合适的 HTML 标签与 CSS 的类名来传达出你想表达的结构含义。譬如 *h1 *标签会告诉我们里面包裹的是一些很重要的标题信息，另一个例子就是*footer *标签，会直截了当地跟你说，这里面是包含一些页脚信息。建议你阅读 [A Look Into Proper HTML5 Semantics](http://www.hongkiat.com/blog/html-5-semantics/) 以及 CSSTricks 的 [What Makes For a Semantic Class Name](https://css-tricks.com/semantic-class-names/)。

## **CSS Naming Conventions**

下面一个比较重要的事情就是怎么给你的 CSS 定一个合适的类名。好的命名习惯，譬如语义化的标记，可以更好地传达含义，让代码的可读性与可维护性大大增加。你可以瞅瞅[OOCSS, ACSS, BEM, SMACSS: what are they? What should I use?](http://clubmate.fi/oocss-acss-bem-smacss-what-are-they-what-should-i-use/)这篇文章里提及的 CSS 的一些命名的习惯。总体来说，我的建议是跟着你的直觉来确定命名习惯，随着时间的发展你会觉得这样看上去很舒服。如果你要看看大公司，譬如 Medium 是怎么实践 BEM 这样的命名规范的，可以阅读 [Medium’s CSS is actually pretty f\*\*\*ing good](https://medium.com/@fat/mediums-css-is-actually-pretty-fucking-good-b8e2a6c78b06#.ef81j61eg)这篇文章，在这里你会学到怎么在一个快速迭代地情况下也维护你的有效地 CSS 命名习惯。

## CSS Reset

不同的浏览器在譬如 margin 以及 line-height 这些小的样式点之间存在着一些不一致性，因此你要学会重置你的 CSS 环境。[MeyerWeb](http://meyerweb.com/eric/tools/css/reset/index.html) 就是一个常见的重置手段，如果你想深入了解下，推荐你阅读 [Create Your Own Simple Reset.css File](http://code.tutsplus.com/tutorials/weekend-quick-tip-create-your-own-resetcss-file--net-206)这篇文章。

## **Cross Browser Support**

跨浏览器支持意味着你的代码要去支持绝大部分的现代浏览器，一些常见的 CSS 属性，譬如 _transition_ 需要 [vendor prefixes](https://developer.mozilla.org/en-US/docs/Glossary/Vendor_Prefix) 来运行在不同的浏览器中。你可以在 [CSS Vendor Prefixes](http://webdesign.about.com/od/css/a/css-vendor-prefixes.htm)这篇文章里获取更多的知识。这就意味着你需要花费更多的时间来在不同的浏览器之间进行测试。

## **CSS Preprocessors and Postprocessors**

翻开 CSS 的历史，自 90 年代以来，CSS 走过了一段漫长而崎岖的道路。整个 UI 系统变得日益繁复，人们也会去选择使用一些预处理器或者后处理器来管理这种复杂性。CSS 的预处理器或者 CSS 语言的扩展会在无声无息之间提供类似于变量、Mixins 以及继承这些特性。最主要的两个 CSS 的预处理器就是[Sass](http://sass-lang.com/guide) 与 [Less](http://lesscss.org/)。2016 年中 Sass 被越发广泛地使用，著名的响应式框架 BootStrap 就是从 Less 迁移到了 Sass。另外，很多人谈到 SASS 的时候也会提到 Scss，你可以参考 [whats-difference-sass-scss](https://www.sitepoint.com/whats-difference-sass-scss/)这篇文章。

CSS 后处理器则对于手写的 CSS 文件或者经过预编译的 CSS 文件进行一些处理，以著名的[PostCSS](https://github.com/postcss/postcss) 为例，它有一个插件可以帮你自动地添加一些渲染前缀。当你接触过 CSS 的预处理与后处理器之后，你会把它们提升到日常伴侣的。不过，过犹不及，像变量和 Mixins 这些特性不能滥用啊，还是应该在合适的地方使用(译者注：此言非常有理)。还是推荐下[Medium’s CSS is actually pretty f\*\*\*ing good](https://medium.com/@fat/mediums-css-is-actually-pretty-fucking-good-b8e2a6c78b06#.ef81j61eg)这篇文章。

## **Grid Systems and Responsiveness**

网格系统即是用来水平或者垂直地排布元素的 CSS 架构。

著名的网格框架有[Bootstrap](http://getbootstrap.com/), [Skeleton](http://getskeleton.com/), 以及 [Foundation](http://foundation.zurb.com/)，它们提供了用于在布局中进行行列管理的样式表。这些框架用起来很方便，不过我们也是要理解网格的工作原理，推荐看[Understanding CSS Grid Systems](http://www.sitepoint.com/understanding-css-grid-systems/) 以及 [Don’t Overthink Grids](https://css-tricks.com/dont-overthink-it-grids/)。网格系统另一个目标就是是你的网站具有响应式特性。响应式意味着你的网站可以根据屏幕的大小来动态调整你网站大小与布局。很多时候这个响应式特性都是基于[CSS media queries](http://www.w3schools.com/css/css_rwd_mediaqueries.asp), 即根据不同的屏幕大小选用不同的 CSS 样式规则。

你可以看一下 [Intro to Media Queries](https://varvy.com/mobile/media-queries.html)来了解更多。另外，因为我们正在进行一场所谓[mobile-first](http://zurb.com/word/mobile-first)变革，推荐你看下[An Introduction to Mobile-First Media Queries](http://www.sitepoint.com/introduction-mobile-first-media-queries/)。

# Practicing HTML and CSS Best Practices

恭喜道友，筑基成功，你已经能够了解一些关于 HTML 与 CSS 的最佳实践了，下面又到了学以致用的时间。这里的两个实验主要是让你锻炼下编写整洁的代码和保证长期的可读性与可维护性。

## Experiment 3

实验 3 中，你需要选一个你之前自己做的项目并且用上文中提及的最佳实践去重构它们，从而保证你的代码更易读并且更简洁。掌握如何有效地重构代码是前端开发者的一个重要技能。当然，写出高质量的代码并非一蹴而就，而是需要一个长期的迭代过程，[CSS Architectures: Refactor Your CSS](https://www.sitepoint.com/css-architectures-refactor-your-css/)这篇文章就是一个不错的学习起点。

当你决定要重构代码之前，你要先扪心自问以下几点

- 你的类名定义是不是模糊不清的，6 个月之后你还能否明白你类名的意义。
- 你的 HTML 与 CSS 是否足够语义化，一眼望去是否就能明白你的代码架构与关系意义？
- 你是否 N 次的重复使用了相同的颜色代码，别忘了可以用[Sass variable](http://webdesign.tutsplus.com/articles/understanding-variable-scope-in-sass--cms-23498)。
- 你的代码是否能够在 Safari 与 Chrome 都能正常运行？
- 能否用像[Skeleton](http://getskeleton.com/)这样的网格框架来代替你自己的布局 ?
- 你是不是经常使用了`!important`?

#### Experiment 4

最后一个实验是一个大杂烩，把前面讲的所有知识都混杂起来。不过要知道的是，上面讲的很多最佳实践在一个草稿或者小型项目里难见分晓，只有在大项目里才能显露峥嵘。因此，最后一个项目我是建议建立一个自己的作品剪辑网站，作为一个前端开发者，个人网站就是自己的电子名片。这里会展示你的作品与项目的积累，也是一个回溯你发展的进程与开发履历的地方。

可以参考 Adham Dannaway 的文章 [My (Simple) Workflow To Design And Develop A Portfolio Website](https://www.smashingmagazine.com/2013/06/workflow-design-develop-modern-portfolio-website/)来从零开始。

# Stay current

当 HTML 与 CSS 已经是小菜一碟，你就算是进入了前端开发者的殿堂，一个不断发生改变的地方。

这里推荐一些博客或者期刊，你可以随时关注：

- [CSSTricks](https://css-tricks.com/)

- [Smashing Magazine](https://www.smashingmagazine.com/)

- [Designer News](https://www.designernews.co/)

- [Nettuts+](http://code.tutsplus.com/)

- [CSS Wizard](http://csswizardry.com/)

---

# Learn by example

最后，一般来说，最好的学习方式呢就是跟着例子来，这里再安利一波别人家的公司的样式与命名规范。

## **Styleguides**

![](https://cdn-images-1.medium.com/max/1600/1*792UDPCcmauyc7MDehMHYg.png)

- [Mapbox](https://www.mapbox.com/base/styling/)

- [LonelyPlanet](http://rizzo.lonelyplanet.com/styleguide/design-elements/colours)

- [SalesForce](https://www.lightningdesignsystem.com/)

- [MailChimp](http://ux.mailchimp.com/patterns/)

## **Code Conventions**

- [CSS Guidelines](http://cssguidelin.es/)

- [Github internal CSS toolkit and guidelines](https://github.com/primer/primer)

- [AirBnB’s CSS Styleguide](https://github.com/airbnb/css)

---

# Further Reading

- [我的前端之路](https://segmentfault.com/a/1190000004292245)

- [百度前端训练营](https://github.com/baidu-ife/ife/tree/master/2015_summer)

本文翻译自 FreeCodeCamp 的[from-zero-to-front-end-hero-part](https://medium.freecodecamp.com/from-zero-to-front-end-hero-part-2-adfa4824da9b#.vbcyfngpa)。

> 继续译者的废话，这篇文章是[前端攻略 - 从路人甲到英雄无敌](https://segmentfault.com/a/1190000005174755)的下半部分，在上半篇中介绍了 HTML 与 CSS 的基础知识，在这里就主要介绍 JavaScript 与各种各样的前端框架。再安利一波笔者的[我的前端之路](https://segmentfault.com/a/1190000004292245) 笔者一直觉得不断变革的前端永远充满活力与激情，但是，哪有那么多激情燃烧的岁月，很多时候会有一种深深的无力感。B 狗的才学会某个东西发现又被抛弃了，就好像笔者才决定大规模使用 React+Redux+Webpack，就看到了这个[from-a-react-point-of-vue-comparing...](https://engineering.footballradar.com/from-a-react-point-of-vue-comparing-reactjs-to-vuejs-for-dynamic-tabular-data/)。实际上，就包括 React 本身已经 OverWhelming，对于初学者很不友好。并且各种各样的最佳实践、Boilerplate 在某些意义上会反而提高学习门槛与曲线，对于这方面的讨论笔者推荐几个瞅瞅，当然，笔者本身也在思考，打腹稿中：

- [javascript-fatigue](https://medium.com/@ericclemmons/javascript-fatigue-48d4011b6fc4#.8okr4h152)
  >
- [state-of-the-union-js](https://medium.com/@matthiasak/state-of-the-union-js-d664bdbffd14#.9agxss2s2)

**我做到我已知的最好的，让最佳实践留给未来的我吧**

> 以下是正文部分

# JavaScript Basics

作为目前最流行的跨平台语言之一，JavaScript 几乎出现在了所有的地方，但是千里之行始于足下，我们还是要先来理解 JavaScript 的一些基础知识。

## Language

在学习怎么将 JavaScript 应用到 Web 开发之前，我们还是要看下 JavaScript 的基本语法。推荐阅读 Mozilla Developer Network 的 [Language basics crash course](https://developer.mozilla.org/zh-CN/Learn/Getting_started_with_the_web/JavaScript_basics)。本教程会导引学习譬如基本的变量、流程控制与函数等等语言基础部分。读完了这个，你就可以读 MDN 的 [JavaScript guide](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Guide)中的剩余部分：

- [语法与类型](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Guide/Grammar_and_types)

- [流程控制与异常处理](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Guide/Control_flow_and_error_handling)

- [循环与迭代](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Guide/Loops_and_iteration)

- [函数](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Guide/Functions)

- [JavaScript Introduction, 可以参考里面的 Reference 部分，有很多推荐的阅读参考](https://github.com/wx-chevalier/web-frontend-practice-handbook/blob/master/javascript/introduction.md)

同样的，不要死记硬背，你可以在你记不住的时候多看看，当然，最好的是能形成你自己的阅读笔记或者知识体系框架，譬如[这个](https://segmentfault.com/a/1190000004612590)。你应当专注于理解变量初始化、循环以及函数等等关键的知识点，譬如 for-in、forEach、for-of 的区别，this 的 N 种绑定方法等。如果你实在觉得这货太单调了，那也能直接跳过，以后发现啥东西不理解的时候再滚回来瞅一眼。在实践中学习可能能让你理解地更好。读书读累了，那可以看看视频换个脑子，这个 Codecademy 提供的 [JavaScript 系列教程](https://www.codecademy.com/learn/javascript) 不错，可以随手看也很有意思。另一个，如果你还有时间，可以看看 [Eloquent JavaScript](http://eloquentjavascript.net/) 中的相关章节来加深你的记忆。Eloquent JavaScript 是个非常优秀的在线的免费的 JavaScript 学习工具书。## Interactivity

![](http://7xlgth.com1.z0.glb.clouddn.com/1-V4UtSyfCN9DDpl70IxXSHA.gif) 到这一步你应该已经对 JavaScript 这门语言本身的基础知识有了了解，那么下一步就是学会如何应用到 Web 项目开发中。你首先需要来瞅几眼[文档对象模型 (DOM)](https://developer.mozilla.org/zh-CN/docs/Web/API/Document_Object_Model/Introduction)来理解 JavaScript 是如何完成与网页的交互的。文档对象模型 (DOM) 是 HTML 和 XML 文档的编程接口。它提供了对文档的结构化的表述，并定义了一种方式可以使从程序中对该结构进行访问，从而改变文档的结构，样式和内容。DOM 将文档解析为一个由节点和对象(包含属性和方法的对象)组成的结构集合。简言之，它会将 web 页面和脚本或程序语言连接起来。如果要做进一步了解的话推荐阅读 CSSTricks 出品的[What is the DOM](https://css-tricks.com/dom/)，它也提供了简单而直接的对于 DOM 的介绍。![](http://7xi5sw.com1.z0.glb.clouddn.com/1-o1lGaXpnKYgp2r9CFOI_9A.png)

> 好像刚才那段对 DOM 的介绍有点照本宣科，CSS Tricks 里是这么说的，关于 DOM 与 HTML 的区别。可能你在 HTML 代码中写了个`<table>`元素，但是忘了写`<tbody>`，没关系，浏览器会自动帮你插入`<tbody>`到 DOM 中，你可以利用 JavaScript 来控制该节点并且赋予样式，尽管它从未出现在你的 HTML 中。

这里提供了一个简单的例子，通过 JavaScript 是如何改变某个 DOM 元素里的内容来展示基本的 JavaScript 与 DOM 树的交互，首先需要选择到对应 DOM 节点

```
var container = document.getElementById(“container”);
```

然后使用该 DOM 节点的属性来改变其内容

```
container.innerHTML = 'New Content!';
```

这只是一个简单的例子，你还可以用 JavaScript DOM API 干更多的事情，你可以阅读以下的 MDN 的教程来进行了解, [The Document Object Model](https://developer.mozilla.org/zh-CN/docs/Web/API/Document_Object_Model).

- [Events](https://developer.mozilla.org/zh-CN/docs/Web/API/Document_Object_Model/Events)

- [使用 DOM 进行 Web 与 XML 开发示例](https://developer.mozilla.org/zh-CN/docs/Web/API/Document_Object_Model/Examples)

- [怎么创建一个 DOM 树](https://developer.mozilla.org/zh-CN/docs/Web/API/Document_object_model/How_to_create_a_DOM_tree)

- [DOM 介绍](https://developer.mozilla.org/zh-CN/docs/Web/API/Document_Object_Model/Introduction)

- [利用选择器来定位 DOM 节点](https://developer.mozilla.org/zh-CN/docs/Web/API/Document_object_model/Locating_DOM_elements_using_selectors)

老生常谈了，不能舍本逐末，还是要专注于理解概念而不是简单地表达式使用，要在心中默问自己几个问题：

- DOM 是什么鬼 ?
- 怎么查询元素 ?
- 怎么进行事件监听 ?
- 怎么改变 DOM 节点的属性 ?

对于常见的 JavaScript 与 DOM 之间的交互, 可以参考 PlainJS 出品的 [JavaScript Functions and Helpers](https://plainjs.com/javascript/)。这个站点会给你提供很多的例子，譬如 [如何操作 DOM 元素样式](https://plainjs.com/javascript/styles/set-and-get-css-styles-of-elements-53/) 或者 [怎么添加键盘事件响应](https://plainjs.com/javascript/events/getting-the-keycode-from-keyboard-events-17/)等等。如果你希望再深入一点，同样推荐[Eloquent JavaScript](http://eloquentjavascript.net/13_dom.html)中的 DOM 介绍的章节。

## Inspector

在浏览器中，我们可以用开发者工具来调试客户端运行的 JavaScript 代码，譬如 Firefox 的 Firebug 和 Chrome 的开发者工具，可以帮你审视网页源代码，追踪 JavaScript 的执行过程和结果，打印出调试语句，还能瞅瞅譬如网络请求、Cookie 等等资源。这个 [tutorial](https://developer.chrome.com/devtools) 是关于如何使用 Chrome 的开发者工具，如果你是火狐的话，瞅瞅这个 [tutorial](https://developer.mozilla.org/zh-CN/docs/Tools/Page_Inspector)。![](http://7xi5sw.com1.z0.glb.clouddn.com/1-wW-FbgJhP0R_id-XPOSKpg.jpeg)

# Practicing the basics

上面聊完了基础的语法和交互操作，但是对于不知道有多少个坑的 JS 而言不过沧海一粟，不过我把一些新的东西放到了最后一节介绍，这边先放松放松，做点小实验玩玩。

## Experiment 1

实验 1 里让我们把目光投向 [AirBnB](https://www.airbnb.com/), 打开你浏览器的 [page inspector](https://developer.chrome.com/devtools), 然后点击 [console tab](https://developer.chrome.com/devtools/docs/console)。这样你就可以在页面上执行一些 JavaScript 脚本了，你可以尝试着控制一些界面元素，改个字体样式啥的。![](http://7xi5sw.com1.z0.glb.clouddn.com/1-5L17hFKIMTsBFQOLCy8tCQ.png) 我选用 airbnb 的网站作为介绍是因为它的 CSS 类命名比较直接，并且没有被编译器混淆过，当然，你也可以看看百度啊之类的调试。

- 选择一个拥有唯一类名的 header 标签，改变其文字内容
- 移除页面上的随机一个元素
- 改变任意元素的 CSS 属性
- 将一块区域的高度减小 250px
- 改变一个组件，譬如 panel 的可见性
- 定义一个叫做 *doSomething *的函数，让它弹出 “Hello world”，并且执行它
- 为某个文本块添加一个点击响应事件

如果你在那边卡住了，别忘了去看看[JavaScript Functions and Helpers](https://plainjs.com/javascript/) 指南，我在这边也给一个小小的例子：

```
var header = document.querySelector(‘.text-branding’)
header.innerText = ‘Boop'
```

这个实验的主要目的就是回顾下你学到的 JavaScript 的基本语法以及一些 DOM 操作的知识。

## Experiment 2

![](http://7xi5sw.com1.z0.glb.clouddn.com/1-7365CToqHiLkXf16Di8xRw.gif)

第二个实验使用 [CodePen-JonathanZWhite](https://twitter.com/JonathanZWhite)编写一个较大较复杂的 JavaScript 交互项目，会用到一些[programmatic logic](https://en.wikipedia.org/wiki/Logic_in_computer_science)。这个实验的关注点会综合你在[前端攻略 - 从路人甲到英雄无敌](https://segmentfault.com/a/1190000005174755)中学到的关于 HTML 与 CSS 的知识，这边有几个参考项目：

- [Periodic Table](http://codepen.io/tony_the_coder/pen/GZdNQY)

- [Mood Color Generator](http://codepen.io/mecarter/pen/RNomVo)

- [Calculator](http://codepen.io/nodws/pen/heILd)

- [JavaScript Quiz](http://codepen.io/jasonchan/pen/wMaEwN)

- [Playable Canvas Asteroids](http://codepen.io/jeffibacache/pen/bzBsp)

# More JavaScript

看过了基础知识，动手做了几个小实验，下面我们会进入一些更有难度的概念的学习。这边的列举的概念可能之间并么有什么必然的练习，不过我还是把它们放在了一起是因为它们能有助于你通往专家的道路，并且也能有助于你理解下面关于框架部分的讲解。

## Language

实际上 JavaScript 并不是一门浅薄的语言，虽然它只用了短短一周时间就创建出来了，它包含了很多高级的概念与用法(并且因为历史版本问题存在着大量的 Polyfill)。这里是列举出了常见的概念，同样地 [Eloquent JavaScript](http://eloquentjavascript.net/)也攘括了这些点：

- [原型与继承](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Inheritance_and_the_prototype_chain)

- [作用域](https://spin.atomicobject.com/2014/10/20/javascript-scope-closures/)

- [闭包](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Closures)

- [回环](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/EventLoop)

- [事件冒泡](http://javascript.info/tutorial/bubbling-and-capturing)

- [Apply, call, and bind](http://javascriptissexy.com/javascript-apply-call-and-bind-methods-are-essential-for-javascript-professionals/)

- [Callbacks and promises](https://www.quora.com/Whats-the-difference-between-a-promise-and-a-callback-in-Javascript)

- [变量与提升](http://adripofjavascript.com/blog/drips/variable-and-function-hoisting)

- [Currying](http://www.sitepoint.com/currying-in-functional-javascript/)

## Imperative vs. Declarative(命令式 VS 声明式)

就如同常见的两种编程方式，JavaScript 与 DOM 交互的方式也分为命令式与声明式。一般来说，声明式编程关注于发生了啥，而命令式则同时关注与咋发生的。

```
var hero = document.querySelector('.hero')


hero.addEventListener(‘click’, function() {
  var newChild = document.createElement(‘p’)


  newChild.appendChild(document.createTextNode(‘Hello world!’))
  newChild.setAttribute(‘class’, ‘text’)
  newChild.setAttribute(‘data-info’, ‘header’)
  hero.appendChild(newChild)
 })
}
```

上面这个小例子就是典型的命令式编程，我们手动地查找到某个元素，然后将 UI 状态存储在 DOM 中，换言之，就是关注于如何达成某个目标。命令式编程的优势在于很直观，不过缺点也很明显，整个程序的健壮性很差，也不易于扩展。譬如如果某人把那个元素的类名从`hero`变成了`villain`，那么事件监听器就永远不会被调用了。声明式编程可以较好地解决这个问题，刚才提到的比较麻烦的元素选择这个动作可以交托给框架或者库区处理，这样就能让开发者专注于发生了啥，这里推荐一波 [The State Of JavaScript — A Shift From Imperative To Declarative](http://www.tysoncadenhead.com/blog/the-state-of-javascript-a-shift-from-imperative-to-declarative#.Vz0WEZMrIUE) 与 [Three D’s of Web Development #1: Declarative vs. Imperative](http://developer.telerik.com/featured/three-ds-of-web-development-1-declarative-vs-imperative/)。本指南并没有一上来先给你看 Angular 或者 React 的 HelloWord，而是告诉你命令式的做法和声明式的区别在哪，这样你就能更好地理解为啥我们会需要框架。

> 响应式与声明式也可以看看笔者在[我的前端之路](https://segmentfault.com/a/1190000004292245)里面提到的从以 DOM 操作为核心到数据流驱动的页面，关注发生了啥本质上就是关注状态与数据，而不是额外的操作。

## Ajax

虽然已经有了很多关于 Ajax 的教程指南，还是建议你阅读下官方的[Ajax](https://developer.mozilla.org/zh-CN/docs/AJAX/Getting_Started) 介绍。Ajax 即是一个允许 Web 页面通过 JavaScript 与服务端完成交互的技术，Ajax 也是前后端分离的一个基石。![](http://7xi5sw.com1.z0.glb.clouddn.com/1-kkezNwUnuEiAztlQRkJ69A.gif) 譬如，如果你要去提交一个表单，那么就要先收集下输入的内容然后通过 HTTP 请求发送到服务端。你在发 Twitter 的时候，就是 Twitter 客户端发送 HTTP 请求到 Twitter 的服务器，然后根据服务端响应来修正页面状态。推荐阅读下 [What is Ajax](http://www.vandelaydesign.com/what-is-ajax-webdev/)来深入理解 Ajax，如果还是觉得有些疑惑，那可以看看 [Explain it like i’m 5, what is Ajax](https://www.reddit.com/r/explainlikeimfive/comments/19gvn9/explain_it_like_im_5_what_is_ajax/)，要是还不够，那就回到[eloquentjavascript chapter](http://eloquentjavascript.net/17_http.html) 关于 HTTP 的章节吧。早期，笔者是习惯用 jQuery 的 \$.ajax 来进行 Ajax 操作，不过现在已经慢慢统一到了标准的 [Fetch](https://developer.mozilla.org/zh-CN/docs/Web/API/Fetch_API)，你可以看看由 [Dan Walsh](https://davidwalsh.name/fetch)写的文章来多了解下 Fetch，它涵盖了 Fetch 的工作原理与基本的用法。因为 Fetch 在部分低版本浏览器上还不能使用，因此我们会选择一些 Fetch [polyfill](http://stackoverflow.com/questions/7087331/what-is-the-meaning-of-polyfills-in-html5)，文档是 [这里](https://github.com/github/fetch)。

## jQuery

- [一些 jQuery 使用技巧](https://segmentfault.com/a/1190000003911481) > [也需要你压根用不到 jQuery](http://youmightnotneedjquery.com/)

到这里，咱们一直是用单纯的 JavaScript 来进行节点操作，怪麻烦的说，而且在不同的浏览器里还有写不同的 Polyfill。实际上，已经有了大量的 DOM 节点的操作库来帮我们简化常用代码，其中最著名的就是[jQuery](https://jquery.com/)，一个当年前端程序猿的标配。要记住，jQuery 是一个典型的命令式的操作库，它编写与前端井喷之前，在那个年代有着无可比拟的先进行。虽然今天，我们应该用像 Angular、React 这样的声明式编程的框架来进行复杂 UI 界面的编写，但是仍然是推荐学习下 jQuery，毕竟还有大量的项目仍然是基于 jQuery 的。![](http://7xi5sw.com1.z0.glb.clouddn.com/1-4XD5t8AEjQFWeTWEIdhQpw.gif) jQuery 官方提供了一个[Learning Center](http://learn.jquery.com/)，是不错的基础学习的教程，它会一步一步带你学习重要的概念，譬如[animations](http://learn.jquery.com/effects/intro-to-effects/) 与 [event handling](http://learn.jquery.com/events/handling-events/)。如果你想要更多的学习资源，那么可以参考 Codecademy 的 [jQuery course](https://www.codecademy.com/learn/jquery)。不过一定要记住，jQuery 并不是唯一的进行 DOM 操作的库，[PlainJS](https://plainjs.com/javascript/) 和 [You Might Not Need jQuery](http://youmightnotneedjquery.com/) 也提供了基于原本的 JavaScript 代码怎么实现常见的 jQuery 中的操作。

## ES5 vs. ES6

在现代的前端开发中，另一个绕不过去的概念就是 [ECMAScript](https://en.wikipedia.org/wiki/ECMAScript)。现在主要有两个常用的 JavaScript 版本，分布是 ES5 和 ES6，它们呢都是 JavaScript 使用的 ECMAScript 标准。你可以把它们看做不同版本的 JavaScript，ES5 是在 2009 年定稿，然后使用至今。而 ES6, 也叫作 ES2015，是一个新的标准，它提供了很多譬如[常量](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Statements/const), [类](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Classes), 以及 [模板字符串](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Reference/Template_literals)等等特性。ES6 是兼容 ES5 的，不像 Python3 和 Python2，并且很多 ES6 带来的语法特性都是在 ES5 的封装的基础上，譬如 ES6 中的类是基于 JavaScript [prototypal inheritance](https://developer.mozilla.org/zh-CN/docs/Web/JavaScript/Inheritance_and_the_prototype_chain)的[syntactical sugar](https://en.wikipedia.org/wiki/Syntactic_sugar)。这里推荐一个不错的 ES6 的教程[ES5, ES6, ES2016, ES.Next: What’s going on with JavaScript versioning](http://benmccormick.org/2015/09/14/es5-es6-es2016-es-next-whats-going-on-with-javascript-versioning/) 以及 Dan Wahlin 的[Getting Started with ES6 — The Next Version of JavaScript](http://weblogs.asp.net/dwahlin/getting-started-with-es6-%E2%80%93-the-next-version-of-javascript).。看完了这些，你也可以看看 ES5 和 ES6 特性的详细列表: [ES6 Features](http://es6-features.org/#Constants)以及 [Github repository](https://github.com/lukehoban/es6features)。

# More Practice

恭喜你，成功到达存档点，你已经学了不少关于 JavaScript 的知识了，下面让我们来温习一波。![](http://7xi5sw.com1.z0.glb.clouddn.com/1-vThR7vEzW40OloxGnbmwuA.png) ## Experiment 3 Experiment 3 着重于如何利用 jQuery 进行常见的 DOM 节点操作，本实验中，我们会以一种更加结构化的方式。我是选择了 Flipboard 的主页作为范本，你可以参考下 Codecademy 的[Flipboard’s home page and add interactivity with JavaScript](https://www.codecademy.com/skills/make-an-interactive-website) 教程。## Experiment 4 ![](http://7xi5sw.com1.z0.glb.clouddn.com/1-OxwMghRSssqkALRIaS72iw.png) 按照惯例，实验 4 呢又把你学过的 HTML 和 CSS 的知识跟 JavaScript 的知识混杂到了一起进行锻炼，这是一个关于钟的实验，各种各样的钟。在动手之前推荐你看看 [Decoupling Your HTML, CSS, and JavaScript](http://philipwalton.com/articles/decoupling-html-css-and-javascript/)来了解下 JavaScript 混入的情况下基本的 CSS 类名命名规范。同样的，我也准备了一系列的 CodePen 来当做你的教材：

- [Flat Clock](http://codepen.io/stevenfabre/pen/Cyhjb)

- [jQuery Wall Clock](http://codepen.io/mattlitzinger/pen/ruEyz)

- [Fancy Clock](http://codepen.io/rapidrob/pen/IGEhn)

- [Retro Clock](http://codepen.io/OfficialAntarctica/pen/VYzvgj)

- [Simple JavaScript Clock](http://codepen.io/dudleystorey/pen/unEyp)

如果你要更多的例子，请在 CodePen 上搜索 [clock](http://codepen.io/search/pens?q=clock&limit=all&type=type-pens)。你可以选择先写基本的 HTML 与 CSS 样式然后再加上 JavaScript 逻辑，也可以先写 JavaScript 逻辑代码然后再放入到样式中。你可以选择用 jQuery，不过尽量还是用纯粹的 JavaScript 代码吧。

# JavaScript Frameworks

小怪清完了，下面开始刷 BOSS 了，拿起你的剑吧勇士，美丽的公主就在前方。我们在这一章节会开始介绍常用的 JavaScript 框架。我们不提倡重复造轮子，但是一定要理解轮子并且能给它上上油或者换换螺丝钉，这些 JavaScript 框架可以帮你更好地组织你的代码。它们为前端开发者提供了可复用的解决方案，就好像所谓的设计模式一样，它可以用来解决状态管理、路由以及性能优化等等，正是因为有了这些框架，我们才能更好地构建[web apps](http://www.visionmobile.com/blog/2013/07/web-sites-vs-web-apps-what-the-experts-think/)。贪多嚼不烂，我不打算介绍所有的 JavaScript 框架，不过还是列个目录下来，这些框架包括但不限于 [Angular](https://angularjs.org/), [React](https://facebook.github.io/react/) + [Flux](https://facebook.github.io/react/docs/flux-overview.html), [Ember](http://emberjs.com/), [Aurelia](http://aurelia.io/),[Vue](http://vuejs.org/), 以及 [Meteor](https://www.meteor.com/)。你并不需要学习所有的框架，选择一个然后深入，最合适自己的才是最好的。

> 便如译者在文首所说，我们并不能盲目地追赶框架，而是要理解框架背后的思想与原则。另一个在译者自己的实践中，会尽可能的基于 ES6 进行抽象，这样保证了即使换框架也能有很好地兼容于复用。

## Architectural Patterns

在学习框架之前，首先要了解下常用的架构模式：

- [model-view-controller](https://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93controller)

- [model-view-viewmodel](https://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93viewmodel)

- [model–view–presenter](https://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93presenter)

这些模式可以用来创建清晰的多层应用[关注分离](https://en.wikipedia.org/wiki/Separation_of_concerns)。关注分离是一个设计原则，即是讲一个巨石型应用切分到不同的领域专注层，譬如前面我们都是在 HTML 中保留应用状态，而你可以使用一个 JavaScript 对象，或者说是 Model 层来存储应用状态。如果你想要了解地更多，可以先看下[Chrome Developers](https://developer.chrome.com/apps/app_frameworks)里对于 MVC 的讲解，然后阅读[Understanding MVC And MVP (For JavaScript And Backbone Developers)](https://addyosmani.com/blog/understanding-mvc-and-mvp-for-javascript-and-backbone-developers/)。阅读这篇文章的时候不要在意有没有学过 Backbone，只要关注 MVC 与 MVP 比较的部分。Addy Osman 也写了另一篇关于 MVVM 的文章[Understanding MVVM — A Guide For JavaScript Developers](https://addyosmani.com/blog/understanding-mvvm-a-guide-for-javascript-developers/)。如果你想了解 MVC 的源起，可以参考 Martin Fowler 的 [GUI Architectures](http://martinfowler.com/eaaDev/uiArchs.html)。最后，阅读这篇[JavaScript `MV*` Patterns](https://addyosmani.com/resources/essentialjsdesignpatterns/book/#detailmvcmvp)，[Learning JavaScript Design Patterns](https://addyosmani.com/resources/essentialjsdesignpatterns/book/)也是个很不错的在线免费电子书。

## Design Patterns

JavaScript 的框架也并没有重复造轮子，很多还是基于[已有的设计模式](https://en.wikipedia.org/wiki/Software_design_pattern)，你可以认为设计模式是在软件开发中用于解决通用问题的可复用的方法。尽管理解设计模式并不是学习一个框架的前提，不过我还是建议你可以先了解一些：

- [Decorator](https://addyosmani.com/resources/essentialjsdesignpatterns/book/#decoratorpatternjavascript)

- [Factory](https://addyosmani.com/resources/essentialjsdesignpatterns/book/#factorypatternjavascript)

- [Singleton](https://addyosmani.com/resources/essentialjsdesignpatterns/book/#singletonpatternjavascript)

- [Revealing module](https://addyosmani.com/resources/essentialjsdesignpatterns/book/#revealingmodulepatternjavascript)

- [Facade](https://addyosmani.com/resources/essentialjsdesignpatterns/book/#facadepatternjavascript)

- [Observer](https://addyosmani.com/resources/essentialjsdesignpatterns/book/#observerpatternjavascript)

理解这些设计模式不仅会让你变成一个更好地设计师，也能有助于你更好地理解这些框架。

## AngularJS

AngularJS 是一个 JavaScript [MVC](https://addyosmani.com/resources/essentialjsdesignpatterns/book/#detailmvc)框架，不过有时候也是一个 [MVVM](https://addyosmani.com/resources/essentialjsdesignpatterns/book/#detailmvvm)框架。它由在 2010 年由 Google 进行维护并且迅速在社区刮起了一波浪潮。![](http://7xi5sw.com1.z0.glb.clouddn.com/1-lFZ7nP3KlRtb69abn19xJQ.png) Angular 是一个典型的声明式框架，这里推荐一个阅读，可以帮你理解命令式编程到声明式编程的转变: [How is AngularJS different from jQuery](http://stackoverflow.com/questions/13151725/how-is-angularjs-different-from-jquery)。如果你希望了解更多关于 Angular 的知识，可以参考 Angular[documentation](https://docs.angularjs.org/guide)。还有一个叫做 [Angular Cat](https://docs.angularjs.org/tutorial/step_00) 的渐进教程。[angular2-education](https://github.com/timjacobi/angular2-education) 是一个由 Tim Jacobi. 整理的完整的关于 angular2 的教程，另外，还有 John Papa 编写的 [最佳实践指南](https://github.com/johnpapa/angular-styleguide)。

## React + Flux

Angular 帮助开发者解决了很多前端系统构建中遇到的问题，不过 Angular 1 存在着极大的性能问题。今年才出的 Angular 2 也是组件化思维，不过太过庞大。另一个常用的小而美的工具就是 [React](https://facebook.github.io/react/)，专注于用户交互的构建。React 可以认为是 MVC 层中的 View 层，React 只是一个 Library，通常与 [Flux](https://facebook.github.io/flux/)或者 Redux 一起结合起来使用。![](http://7xi5sw.com1.z0.glb.clouddn.com/1-c0JXNVxVnTlOuQCnDqA6CA.png) Facebook 最早设计 React 与 Flux 是为了解决 MVC 中的一些缺陷与扩展问题，可以参考著名的[Hacker Way: Rethinking Web App Development at Facebook](https://www.youtube.com/watch?list=PLb0IAmt7-GS188xDYE-u1ShQmFFGbrk0v&v=nYkdrAPrdcw)演讲，这里介绍了 Flux 的起源。首先，我们来学习 React，推荐是直接看[React 官方文档](https://facebook.github.io/react/docs/getting-started.html)，然后看看[React.js Introduction For People Who Know Just Enough jQuery To Get By](http://reactfordesigners.com/labs/reactjs-introduction-for-people-who-know-just-enough-jquery-to-get-by/) 来帮你从 jQuery 思维转移到 React 思维。

> 可以参照译者的[React Introduction](https://github.com/wx-chevalier/web-frontend-practice-handbook/blob/master/framework/view/react/introduction/react-introduction.md)来获取更多关于 React 参考资料的东东

在你对 React 有了基本的了解之后，下面就可以开始学习 Flux 了，同样的首先推荐[官方 Flux 文档](https://facebook.github.io/flux/docs/overview.html)。然后你可以看看[Awesome React](https://github.com/enaqx/awesome-react), 这里包含了很多你可以慢慢咀嚼的内容。

# Practicing with Frameworks

又到了实践环节了，现在你已经对于 JavaScript 框架与架构模式有了基本的了解，是时候带一波节奏了。在这两个实验中，注意体会架构设计的理念，首先要保证 [DRY](https://en.wikipedia.org/wiki/Don%27t_repeat_yourself), 然后有一个 [清晰的分层概念](https://en.wikipedia.org/wiki/Separation_of_concerns), 最后要注意 [单一职责原则](https://en.wikipedia.org/wiki/Single_responsibility_principle).

## Experiment 5

实验 5 是不用框架重构著名的 TodoMVC，换言之，就是用最基础的 JavaScript 代码来实现一个 TodoMVC。本实验的目的就是为了向你展示在没有框架介入的情况下怎么构建一个完整的 MVC 应用 ![](http://7xi5sw.com1.z0.glb.clouddn.com/1-ISCVxjX3_691DLnV3EPZ3w.png) 你可以参考 [TodoMVC](http://todomvc.com/examples/vanillajs/)，第一步就是创建一个新的本地项目然后建立三个基本的组件，你可以参考[Github repository](https://github.com/tastejs/todomvc/tree/gh-pages/examples/vanillajs)这里的完整代码。如果你觉得现在的自己能力还不足以 Hold 住整个项目，表担心，先把它们下载下来，然后慢慢实践。

## Experiment 6

Experiment 6 就是跟着 Scotch.io 的教程来实现一个下面这样的站点: ![](http://7xi5sw.com1.z0.glb.clouddn.com/1-zOIJ31nV3rDYBidYkPSH_A.png)

[Build an Etsy Clone with Angular and Stamplay](https://scotch.io/tutorials/build-an-etsy-clone-with-angular-and-stamplay-part-1) 会教你怎么基于 Angular 来构建一个网站，提供[APIs](https://en.wikipedia.org/wiki/Application_programming_interface)并且在一个大型的项目中进行架构组织。学完了这些之后，你要能理解以下这些问题：

- 啥是 web app?
- 怎么用 Angular 实践 MVC/MVVM?
- API 是啥，肿么用 ?
- 怎么组织与管理一个大型的 CodeBase?
- 将一个 UI 切分为声明式组件的好处在哪 ?

如果这个教程还不够，那还可以看看[Build a Real-Time Status Update App with AngularJS & Firebase](https://www.sitepoint.com/real-time-status-update-app-angularjs-firebase/)。

## Experiment 7

![](http://7xi5sw.com1.z0.glb.clouddn.com/1-3HrnGSbAzIM5Lwu0_eqmjw.png)

第 7 个实验是将 React 与 Flux 综合使用，即利用 React 来构建一个 TODOMVC。你可以参考[Facebook’s Flux documentation site](https://facebook.github.io/flux/docs/todo-list.html)这个教程，它会教你一步一步地从零开始构建界面然后将 Flux 应用到整个 Web 项目中。通过了第一关，就可以移步到 [怎么利用 React、Redux 与 Immutable.js 构建一个 TodoMVC](https://www.sitepoint.com/how-to-build-a-todo-app-using-react-redux-and-immutable-js/) 以及 [利用 Flux 与 React 构建一个微博客](http://code.tutsplus.com/courses/build-a-microblogging-app-with-flux-and-react)。

# Stay current

就像前端一样，JavaScript 也永远不会停下前进的步伐。

![](http://7xi5sw.com1.z0.glb.clouddn.com/1-gcVLvWktBPvc3rgp5fLvBA.jpeg)

下面列举了一系列博客，多读读，能够随时了解最新的发展与消息：

- [Smashing Magazine](https://www.smashingmagazine.com/tag/javascript/)

- [JavaScript Weekly](http://javascriptweekly.com/)

- [Ng Weekly](http://www.ng-newsletter.com/)

- [Reddit JavaScript](https://www.reddit.com/r/javascript/)

- [JavaScript Jabber](https://devchat.tv/js-jabber)

# Learn by example

## Styleguides

- [AirBnB JavaScript Styleguide](https://github.com/airbnb/javascript)

- [Principles of Writing Consistent, Idiomatic JavaScript](https://github.com/rwaldron/idiomatic.js/)

- [Node Styleguide](https://github.com/felixge/node-style-guide)

- [MDN Coding Style](https://developer.mozilla.org/zh-CN/docs/Mozilla/Developer_guide/Coding_Style)

## Codebases

- [Lodash](https://github.com/lodash/lodash)

- [Underscore](https://github.com/jashkenas/underscore)

- [Babel](https://github.com/babel/babel)

- [Ghost](https://github.com/TryGhost/Ghost)

- [NodeBB](https://github.com/NodeBB/NodeBB)

- [KeystoneJS](https://github.com/keystonejs/keystone)
