<?php
namespace wstshop\mobile\controller;
use think\Loader;
use wstshop\common\model\Payments as M;
use wstshop\mobile\model\Orders as OM;
use wstshop\common\model\LogPayParams as PM;
use wstshop\common\model\ChargeItems as CM;
use wstshop\common\model\LogMoneys as LM;
/**
 * ============================================================================
 * wstshop多用户商城
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wstshop.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 阿里支付控制器
 */
class Alipays extends Base{

    /**
     * 支付宝支付跳转方法
     */
    public function toAliPay(){
        $payObj = input("payObj/s");
        $returnUrl = "";
        $subject = "";
        $passback_params = "";
        $orderAmount = 0;
        $userId = 0;
        $payParams = array();
        Loader::import('alipay.aop.AopClient');
        Loader::import('alipay.aop.request.AlipayTradeWapPayRequest');
        if($payObj=="recharge"){//充值
            $itemId = (int)input("itemId/d");
            $orderAmount = 0;
            if($itemId>0){
                $cm = new CM();
                $item = $cm->getItemMoney($itemId);
                $orderAmount = isSet($item["chargeMoney"])?$item["chargeMoney"]:0;
            }else{
                $orderAmount = (int)input("needPay/d");
            }
            $targetType = 0;
            $targetId = (int)session('WST_USER.userId');
            $userId = $targetId;
            $out_trade_no = WSTOrderNo();
            $passback_params = $targetId."@".$targetType."@".$itemId."@".$payObj;
            $subject = '钱包充值 ¥'.$orderAmount.'元';
            $body = '钱包充值';
            $returnUrl = url("mobile/logmoneys/usermoneys","",true,true);

        }else{
            $orderId = (int)WSTBase64urlDecode(input("pkey"));
			$om = new OM();
			$userId = (int)session('WST_USER.userId');
			$obj["userId"] = $userId;
			$obj["orderId"] = $orderId;
			$data = $om->checkOrderPay2($obj);
			if($data["status"]==-1){
				echo "<span style='font-size:40px;'>您的订单已支付，不要重复支付！</span>";
				return;
			}else if($data["status"]==-2){
				echo "<span style='font-size:40px;'>您的订单因商品库存不足，不能支付！</span>";
				return;
			}
            $order = $om->getPayOrders($obj);
			$orderAmount = $order["needPay"];
			$payRand = $order["payRand"];
			$out_trade_no = $obj["orderId"]."a".$payRand;
            $passback_params = $userId;
            $returnUrl = url("mobile/orders/index","",true,true);
            $subject = '支付购买商品费用';
            $body = '支付订单费用';
        }
        $m = new M();
        $payment = $m->getPayment("alipays");
        $aop = new \AopClient ();  
        $aop->gatewayUrl = 'https://openapi.alipay.com/gateway.do';  
        $aop->appId = $payment["appId"];  
        $aop->rsaPrivateKey = $payment["rsaPrivateKey"]; 
        $aop->alipayrsaPublicKey = $payment["alipayrsaPublicKey"];
        $aop->apiVersion = '1.0';  
        $aop->signType = 'RSA2';  
        $aop->postCharset= "UTF-8";;  
        $aop->format='json';  
        $request = new \AlipayTradeWapPayRequest  ();  
        $request->setReturnUrl($returnUrl);  
        $request->setNotifyUrl(url("mobile/alipays/aliNotify","",true,true));
        $passback_params = urlencode($passback_params);
        $bizcontent = "{\"body\":\"$body\","
                    . "\"subject\": \"$subject\","
                    . "\"out_trade_no\": \"$out_trade_no\","
                    . "\"timeout_express\": \"90m\","
                    . "\"total_amount\": \"$orderAmount\","
                    . "\"passback_params\": \"$passback_params\","
                    . "\"product_code\":\"QUICK_WAP_WAY\""
                    . "}";
        $request->setBizContent($bizcontent);
        //请求  
        $result = $aop->pageExecute ($request);
        echo $result;
    }
    
    function aliCheck($params){
        Loader::import('alipay.aop.AopClient');
        $aop = new \AopClient;
        $m = new M();
        $payment = $m->getPayment("alipays");
        $aop->alipayrsaPublicKey = $payment["alipayrsaPublicKey"];
        $flag = $aop->rsaCheckV1($params, NULL, "RSA2");
        return $flag;
    }

    /**
     * 服务器异步通知方法
     */
    function aliNotify() {
        if($this->aliCheck($_POST)){
            if ($_POST['trade_status'] == 'TRADE_SUCCESS' || $_POST['trade_status'] == 'TRADE_FINISHED'){
                $extras = explode("@",urldecode($_POST['passback_params']));
                $payObj = isSet($extras[3])?$extras[3]:"";
                $obj["trade_no"] = $_POST['trade_no'];
                $tradeNo = explode("a",$_POST["out_trade_no"]);
                $obj["out_trade_no"] = $tradeNo[0];
                $obj["payFrom"] = 'alipays';
                $obj["total_fee"] = $_POST['total_amount'];
                if($payObj=='recharge'){
                    $obj["targetId"] = (int)$extras[0];
                    $obj["targetType"] = (int)$extras[1];
                    $obj["itemId"] = (int)$extras[2];
                    // 支付成功业务逻辑
                    $m = new LM();
                    $rs = $m->complateRecharge ( $obj );
                }else{
                    $obj["userId"] = (int)$extras[0];
                    //支付成功业务逻辑
                    $om = new OM();
                    $rs = $om->complatePay($obj);
                }
                if($rs["status"]==1){
                    echo 'success';
                }else{
                    echo 'fail';
                }
            }
        } else {
            // 验证失败
            echo "fail";
        }
    }
}
