SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `wst_orders`;
CREATE TABLE `wst_orders` (
  `orderId` int(11) NOT NULL AUTO_INCREMENT,
  `orderNo` varchar(20) NOT NULL,
  `userId` int(11) NOT NULL,
  `goodsMoney` decimal(11,2) NOT NULL,
  `deliverType` tinyint(4) NOT NULL DEFAULT '0',
  `deliverMoney` decimal(11,2) NOT NULL DEFAULT '0.00',
  `totalMoney` decimal(11,2) NOT NULL,
  `realTotalMoney` decimal(11,2) NOT NULL DEFAULT '0.00',
  `orderStatus` tinyint(4) DEFAULT '0',
  `payType` tinyint(4) NOT NULL DEFAULT '0',
  `payFrom` varchar(20) DEFAULT '',
  `isPay` tinyint(4) NOT NULL DEFAULT '0',
  `areaId` int(11) NOT NULL,
  `areaIdPath` varchar(255) DEFAULT NULL,
  `userName` varchar(20) NOT NULL,
  `userAddress` varchar(255) NOT NULL,
  `userPhone` varchar(20) DEFAULT NULL,
  `orderScore` int(11) NOT NULL DEFAULT '0',
  `isInvoice` tinyint(4) NOT NULL DEFAULT '0',
  `invoiceClient` varchar(255) DEFAULT NULL,
  `orderRemarks` varchar(255) DEFAULT NULL,
  `orderSrc` tinyint(4) NOT NULL DEFAULT '0',
  `needPay` decimal(11,2) DEFAULT '0.00',
  `isRefund` tinyint(4) NOT NULL DEFAULT '0',
  `isAppraise` tinyint(4) DEFAULT '0',
  `cancelReason` int(11) DEFAULT '0',
  `rejectReason` int(11) DEFAULT '0',
  `rejectOtherReason` varchar(255) DEFAULT NULL,
  `isClosed` tinyint(4) NOT NULL DEFAULT '0',
  `goodsSearchKeys` text,
  `receiveTime` datetime DEFAULT NULL,
  `deliveryTime` datetime DEFAULT NULL,
  `expressId` int(11) DEFAULT NULL,
  `expressNo` varchar(20) DEFAULT NULL,
  `tradeNo` varchar(100) DEFAULT NULL,
  `dataFlag` tinyint(4) NOT NULL DEFAULT '1',
  `createTime` datetime NOT NULL,
  `payRand` int(11) DEFAULT '1',
  `orderType` tinyint(4) DEFAULT '0',
  `scoreMoney` decimal(11,2) DEFAULT '0.00',
  `useScore` int(11) DEFAULT '0',
  `orderCode` varchar(20) DEFAULT 'order',
  `extraJson` text,
  `orderCodeTargetId` int(11) DEFAULT '0',
  `noticeDeliver` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '提醒发货 0:未提醒 1:已提醒',
  `lockCashMoney` decimal(11,2) DEFAULT '0.00',
  `invoiceJson` text COMMENT '发票信息',
  `payTime` datetime DEFAULT NULL COMMENT '支付时间',
  `isMakeInvoice` tinyint(4) DEFAULT '0' COMMENT '是否开发票 1:是 0:否',
  PRIMARY KEY (`orderId`),
  KEY `shopId` (`dataFlag`),
  KEY `userId` (`userId`,`dataFlag`),
  KEY `isRefund` (`isRefund`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;


