<?php
namespace wstshop\admin\model;
use think\Db;
/**
 * ============================================================================
 * wstshop多用户商城
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wstshop.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 资金流水日志业务处理
 */
class LogMoneys extends Base{
	/**
	 * 用户资金列表 
	 */
	public function pageQueryByUser(){
		$key = input('key');
		$where = [];
		// 排序
		$sort = input('sort');
		$order = [];
		if($sort!=''){
			$sortArr = explode('.',$sort);
			$order[$sortArr[0]] = $sortArr[1];
		}
		$where['dataFlag'] = 1;
        $where['loginName'] = ['like','%'.$key.'%'];
		return model('users')->where($where)->field('loginName,userId,userName,userMoney,lockMoney,rechargeMoney')->order($order)->paginate(input('limit/d'));
	}
	/**
	 * 获取用户信息
	 */
	public function getUserInfoByType(){
		$type = (int)input('type',0);
		$id = (int)input('id');
		$data = model('users')->where('userId',$id)->field('loginName,userId,userName,0 as userType')->find();
        return $data;
	}

    /**
	 * 分页
	 */
	public function pageQuery($moneySrc = -100000){
		$key = input('key');
		$userId = input('get.id');
		$startDate = input('startDate');
		$endDate = input('endDate');
		$where = [];
        if($moneySrc!=-100000)$where['l.dataSrc'] = $moneySrc;
		if($startDate!='')$where['l.createTime'] = ['>=',$startDate." 00:00:00"];
		if($endDate!='')$where[' l.createTime'] = ['<=',$endDate." 23:59:59"];
		$where['l.targetType'] = 0;
		if($userId!='')$where['l.targetId'] = $userId;
		if($key!='')$where['u.loginName'] = ['like','%'.$key.'%'];
		$page = $this->alias('l')->join('__USERS__ u','l.targetId=u.userId','inner')->where($where)->field('l.*,u.loginName')->order('l.id', 'desc')->paginate(input('l.limit/d'))->toArray();
		if(count($page['Rows'])>0){
			foreach ($page['Rows'] as $key => $v) {
				$page['Rows'][$key]['dataSrc'] = WSTLangMoneySrc($v['dataSrc']);
			}
		}
		return $page;
	}

    /**
     * 新增记录
     */
    public function add($log){
        $log['createTime'] = date('Y-m-d H:i:s');
        $this->create($log);
        if($log['moneyType']==1){
            Db::name('users')->where(["userId"=>$log['targetId']])->setInc('userMoney',$log['money']);
        }else{
            Db::name('users')->where(["userId"=>$log['targetId']])->setDec('userMoney',$log['money']);
        }
    }

    /**
     * 新增记录
     */
    public function addByAdmin(){
        $data = [];
        $data['targetType'] = (int)input('targetType');
        $data['targetId'] = (int)input('targetId');
        $data['money'] = (float)input('money');
        $data['dataSrc'] = 10001;
        $data['dataId'] = 0;
        $data['moneyType'] = (int)input('moneyType');
        $data['remark'] = input('remark');
        $data['dataFlag'] = 1;
        $data['createTime'] = date('Y-m-d H:i:s');
        //判断用户身份
        $rs = Db::name('users')->where(['userId'=>$data['targetId'],'dataFlag'=>1])->find();
        if(empty($rs))return WSTReturn('无效的会员');
        if(!in_array($data['moneyType'],[0,1]))return WSTReturn('无效的资金类型');
        if($data['money']<=0.01) return WSTReturn('变动资金必须大于0');
        Db::startTrans();
        try{
            $result = $this->insert($data);
            if(false !== $result){
                if($data['moneyType']==1){
                     Db::name('users')->where(["userId"=>$data['targetId']])->setInc('userMoney',$data['money']);
                }else{
                     Db::name('users')->where(["userId"=>$data['targetId']])->setDec('userMoney',$data['money']);
                }
            }
            Db::commit();
            return WSTReturn('操作成功',1);
        }catch (\Exception $e) {
            Db::rollback();
            return WSTReturn('操作失败',-1);
        }
    }
}
