<?php
namespace wstshop\admin\model;
/**
 * ============================================================================
 * WSTShop网上商店
 * 版权所有 2016-2066 广州商淘信息科技有限公司，并保留所有权利。
 * 官网地址:http://www.wstshop.net
 * 交流社区:http://bbs.shangtao.net
 * 联系QQ:153289970
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经本公司授权您只能在不用于商业目的的前提下对程序代码进行修改和使用；
 * 不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 经营范围业务处理
 */
use think\Db;
class Datas extends Base{
	protected $insert = ['dataFlag'=>1]; 
	/**
	 * 获取指定分类的列表
	 */
	public function listQuery($catId){
		return Db::name('datas')->where('catId',$catId)->field('dataName,dataVal')->select();
	}
	/**
	* 根据catId获取子数据
	*/
	public function childQuery(){
		$catId = (int)input('post.id');
		return $this->where(['dataFlag'=>1,'catId'=>$catId])->paginate(input('limit/d'));
	}
	/**
	 * 获取菜单列表
	 */
	public function dataQuery($catId = -1){
		if($catId==-1)return ['id'=>0,'name'=>'系统数据','isParent'=>true,'open'=>true];
		$rs = Db::name('data_cats')->where(['dataFlag'=>1])->field('catId id,catName name')->select();
		return $rs;
	}
	/**
	 * 获取菜单
	 */
	public function getById($id){
		return $this->get(['dataFlag'=>1,'id'=>$id]);
	}
	
	/**
	 * 新增菜单
	 */
	public function add(){
		$result = $this->validate('Datas.add')->save(input('post.'));
        if(false !== $result){
        	return WSTReturn("新增成功", 1);
        }else{
        	return WSTReturn($this->getError(),-1);
        }
	}
    /**
	 * 编辑菜单
	 */
	public function edit(){
		$id = input('post.id/d');
	    $result = $this->validate('Datas.edit')->allowField(['dataName','dataVal','dataSort'])->save(input('post.'),['id'=>$id]);
        if(false !== $result){
        	return WSTReturn("编辑成功", 1);
        }else{
        	return WSTReturn($this->getError(),-1);
        }
	}
	/**
	 * 删除菜单
	 */
	public function del(){
	    $id = input('post.id/d');
		$data = [];
		$data['dataFlag'] = -1;
	    $result = $this->update($data,['id'=>$id]);
        if(false !== $result){
        	return WSTReturn("删除成功", 1);
        }else{
        	return WSTReturn($this->getError(),-1);
        }
	}
	
	/**
	 * 获取用户菜单
	 */
	public function getMenus(){
		$STAFF = session('WST_STAFF');
		return $this->where(['parentId'=>0,'dataFlag'=>1,'menuId'=>['in',$STAFF['menuIds']]])->field('menuId,menuName')->order('menuSort', 'asc')->select();
	}
	
	/**
	 * 获取子菜单
	 */
	public function getSubMenus($parentId){
		//用户权限判断
		$STAFF = session('WST_STAFF');
		$allowMenus = [];
		$rs2 = $this->where(['parentId'=>$parentId,'dataFlag'=>1,'menuId'=>['in',$STAFF['menuIds']]])->field('menuId,menuName')->order('menuSort', 'asc')->select();
		foreach ($rs2 as $key2 =>$v2){
			if(!in_array($v2['menuId'],$STAFF['menuIds']))continue;
			$rs3 = Db::name('menus')->alias('m')->join('__PRIVILEGES__ p','m.menuId= p.menuId and isMenuPrivilege=1 and p.dataFlag=1','inner')
			->where(['parentId'=>$v2['menuId'],'m.dataFlag'=>1,'m.menuId'=>['in',$STAFF['menuIds']]])
			->field('m.menuId,m.menuName,privilegeUrl')
			->order('menuSort', 'asc')
			->select();
			if(!empty($rs3))$rs2[$key2]['list'] = $rs3;
		}
		return $rs2;
	}
}
