使用vue

import Cookies from 'universal-cookie'
const cookies = new Cookies()
import { CookieDomain } from '../config.js'
let cookieConfig = {}
if(CookieDomain !== ''){
  cookieConfig = { domain: CookieDomain } //path:'/',maxAge:365*24*60*60
}

export function saveCookie(name,value) {
  cookies.set(name, value, cookieConfig)
}

export function getCookie(name) {
  return cookies.get(name)
}

export function removeCookie(name) {
  cookies.remove(name, cookieConfig)
}

export function signOut() {
  cookies.remove('token', cookieConfig)
}

export function isLogin() {
  console.log(!!cookies.get('token'),'islogin');
  return !!cookies.get('token')
}



router.beforeEach((to, from, next) => {
  // to.matched.some(
  //   function(record){
  //     console.log(record.meta)
  //   }
  // )
  // console.log(to.matched.some(record => record.meta.requiresAuth))
  if (to.matched.some(record => record.meta.goTop)) {
    window.scroll(0, 0) 
  }

  if (to.matched.some(record => record.meta.requiresAuth)) {
    // console.log(record.meta.requiresAuth)
    if (!isLogin()) {
      return next({path: '/pages/login'})
    }
  }
  if (to.matched.some(record => record.meta.requiresNotAuth)) {
    if (isLogin()) {
      return next({path: '/'})
    }
  }
  next()
})

export default router
