## 29.封装全局模态框组件
把静态写好的组件放在 Modal.vue组件里面
代码如下

## 通过props父子组件传惨，通过slot定义插槽
```
<template>
  <div>
      <div class="md-modal modal-msg md-modal-transition" :class="{'md-show':mdShow}" >
        <div class="md-modal-inner">
          <div class="md-top">
            <div class="md-title">信息展示</div>
            <button class="md-close">Close</button>
          </div>
          <div class="md-content">
            <div class="confirm-tips">
                <slot name="message"> </slot>
            </div>
            <div class="btn-wrap">
                <slot name="btnGroup"></slot>
            </div>
          </div>
        </div>
      </div>
      <div class="md-overlay" v-if="mdShow">
      </div>
  </div>
</template>
<script>
    export default {
        props:['mdShow']
    }
</script>

```

## 在父组件里面使用

```
import Modal from '@/components/Modal'


components:{
    NavHeader,
    NavFooter,
    NavBread,
    Modal  //在这加上
},

在打他里面加上
    data(){
        return{
            mdShowCart:false,
            mdShow:false,
        }
    }

```

```
    <!-- 在未登录的情况下 -->
    <modal :mdShow="mdShow">
        <p slot="message">请先登录，否则无法加入购物车</p>
        <div slot="btnGroup">
            <a href="javascript:;" class="btn  btn--m" @click="mdShow = false">关闭</a>
        </div>
    </modal>

    <!-- 在登录的情况下 -->
    <modal :mdShow="mdShowCart">
        <p slot="message">加入购物车成功</p>
        <div slot="btnGroup">
            <a href="javascript:;" class="btn  btn--m" @click="mdShowCart = false">继续购物</a>
            <router-link class="btn  btn--m" to="/cart">查看购物车列表</router-link>
        </div>
    </modal>
```

## 在业务层面操作
```
    addCart(productId){
        axios.post('/goods/addCart',{productId:productId}).then(res=>{
            console.log(res.data);
            if(res.data.status == 1){
                this.mdShow = true;  //判断一下当未登录的情况下把未登录的模态框弹出
            }else{
            }
        })
    }
```