#购物车列表页面渲染
## 把购物车组件写好
    创建组件，设置路由，拷贝静态文件
## 写购物车api
查询出登录的用户的详细信息，取里面的购物列表返回给前台

## 前台代码

## dom循环出来
 ```
<li v-for="(item,index) in cartList" :key="index">
 <img :src="'/static/img/'+ item.productImage">
 <div class="item-name">{{item.productName}}</div>
 <div class="item-price">{{item.salePrice}}</div>
 <span class="select-ipt">{{item.productNum}}</span>
 <div class="item-price-total">{{item.salePrice * item.productNum}}</div>

```
```
  import NavHeader from '@/components/Header'
    import NavFooter from '@/components/Footer'
    import NavBread from '@/components/NavBread'
    export default {
        data(){
            return{
                cartList:''
            }
        },
        components:{
            NavHeader,
            NavFooter,
            NavBread
        },
        created(){
            this.getCartList()
        },
        methods:{
            getCartList(){
                this.$http.post('/users/cartList').then(result=>{
                    let res = result.data;
                    this.cartList = res.result;
                    console.log(res);
                })
            }
        }
    }
```

## 后端接口
```
router.post("/cartList", function(req, res, next) {
    let userId = req.cookies.userId;
    User.findOne({ userId: userId }, function(err, doc) {
        if (err) { res.json({ status: '1', msg: err.message, result: '' }) } else {
            res.json({
                status: 0,
                msg: '',
                result: doc.cartList
            })
        }
    })
})
```