##后台登录接口
接收前台传过来的用户名和密码，去数据库里面查询

在rootes 里面的user.js
### 后台登录接口代码
```
router.post('/login', function(req, res, next) {
    let param = {
        userName: req.body.userName,
        userPwd: req.body.userPwd
    }
    console.log(param);
    User.findOne(param, function(err, doc) {
        console.log(err);
        if (err) { res.json({ "status": "1", msg: err.message }) } else {
            console.log('doc', doc);
            if (!doc) { res.json({ 'status': '1', msg: '', result: '用户名和密码错误' }) }

            //把userId 和 userName 存到cookie里面，在控制台的application里面找到cookie可以查看

            第一个参数存的是 cookie 名字，第二个参数存的是值，地三个对象，里面
            path 是存的路径，maxAge 过期时间，以毫秒为单位
            res.cookie('userId', doc.userId, { 
                path: '/',  
                maxAge: 1000 * 60 * 60
            })

            res.cookie("userName", doc.userName, {
                path: '/',
                maxAge: 1000 * 60 * 60
            })

            if (doc) {
                res.json({
                    status: 0,
                    msg: '',
                    result: {
                        userName: doc.userName  //最后返回用户名
                    }
                })
            }
        }
    })
})
```

##前台实现
在Header组件里面

把静态页面的模态框代码拷贝进来


模态框依靠 md-show 来控制显示隐藏

遮罩层 依靠v-if 来控制显示隐藏

```

      <div class="md-modal modal-msg md-modal-transition " :class="{'md-show':loginModalFlag}">
        <div class="md-modal-inner">
          <div class="md-top">
            <div class="md-title" >登录</div>
            <button class="md-close" @click="loginModalFlag = false">关闭</button>
          </div>
          <div class="md-content">
            <div class="confirm-tips">
              <div class="error-wrap">
                <span class="error error-show" >用户名或密码错误</span>
              </div>
              <ul>
                <li class="regi_form_input">
                  <input type="text" tabindex="1" name="loginname" v-model="userName" placeholder="User Name" data-type="loginname" class="regi_login_input regi_login_input_left">
                </li>
                <li class="regi_form_input noMargin">
                  <i class="icon IconPwd"></i>
                  <input type="password" tabindex="2" name="password" v-model="userPwd" placeholder="Password" class="regi_login_input regi_login_input_left login-input-no input_text" @keyup.enter="login">
                </li>
              </ul>

            </div>
            <div class="login-wrap">
              <a href="javascript:;" class="btn-login" @click="login">登录</a>
            </div>
          </div>
        </div>
      </div>
<div class="md-overlay" v-if="loginModalFlag" @click="loginModalFlag = false">
```

### js代码逻辑实现
```
  import axios from 'axios'
    export default {
        data(){
            return{
                nickName:'',
                userName:'',
                userPwd:'',
                loginModalFlag:false  // 控制
            }
        },
        methods:{
            login(){
                axios.post('/users/login',{
                    userName:this.userName,
                    userPwd:this.userPwd
                }).then(result=>{
                    let res = result.data;
                    this.nickName = res.result.userName;
                    this.loginModalFlag = false;
                })
            }
        }
    }
``` 