
## 分析需求

###  需求1：价格排序：
    点击页面的按钮从大到小排序，然后再点击从小到大排序

    前台：
        点击页面按钮 让下面的产品安装价格排序
        需要一个api
        同过两次点击，切换正序和倒序 ，给后端传一个参数

        开始开发：
            先思考，设计的时间越长，需要修改的时间越短
            请求接口的时候，携带参数，1 -1
            这个怎么来的，通过点击按钮来的
            每次点击按钮 都会改变一个变量值
            变量值默认是 1

        拿到接口：
            postman 测试

    后端api：
    baseurl: localhost:3000
    1:表示接口正常
    0：表示接口不正常

    http 状态码 
    200 ok
    400 表示错误

    拿到需求：
        规定两个参数，来判断输出的结果

        参数：sort

        api:/goods/list?sort=-1 
        接受两个参数：
            接收： 1参数
            /goods/list?sort=1   
            返回数据：
                status:1
                msg:
                result:
                商品正序数据
            接收：-1 参数
            /goods/list?sort=-1   
            返回数据：商品倒序

开始开发：
    在teambition 新建任务
    第一步：从master 检出 最新代码
        git pull origin master

    第二步：git 创建新的分支
        git checkout -b sort

    测试完成：
        git checkout master //切换到master
        git merge sort // 合并到master

        develop 
        每次开发完一个功能，先合并到develop
        
     

## 接口代码：
```
router.get('/list', function(req, res, next) {
    let sort = req.param('sort');

    let goodsModel = Goods.find({}).sort({ 'salePrice': sort });

    goodsModel.exec({}, function(err, doc) {
        if (err) {
            res.json({ status: "1", msg: err.message })
        } else {
            res.json({ status: '0', msg: '', result: doc })
        }
    })

})
```

## vue前端操作


### 在dom里面添加了一个事件

```
<a href="javascript:void(0)" class="price" @click="sortGoods">价格 <svg class="icon icon-arrow-short"><use xlink:href="#icon-arrow-short"></use></svg></a>
```

### 定义了一个data

```
data(){
    return {
        goods:{},
        sortFlag:true
    }
},

```

### 在methods里面定义了一个方法

```
sortGoods(){
    this.sortFlag = !this.sortFlag;
    this.getGoodsList();
}
```

### 修改了之前的请求接口，增加了传sort参数
```
getGoodsList(){
    let sort = this.sortFlag ? 1 : -1;
    axios.get('/goods/list',{params:{sort:sort}}).then(res=>{
        this.goods = res.data.result;
    })
},
```