# Frontend App with Rust and Yew.rs: User SignUp and Login

In this comprehensive guide, you will learn how to build a single-page frontend web application in Rust using the Yew.rs framework. The application will include essential authentication features such as user sign-up, login, logout, and restricting access to protected pages.

![Frontend App with Rust and Yew.rs: User SignUp and Login](https://codevoweb.com/wp-content/uploads/2023/02/Frontend-App-with-Rust-and-Yew.rs-User-SignUp-and-Login.webp)

## Topics Covered

- Run the Yew.rs JWT Frontend App Locally
- Run the Yew.rs Web App with a Rust API
- Scaffold the Yew Project
- Setup Tailwind CSS for Styling
- Define the API Requests with the Reqwasm Crate
    - API Response Types
    - Create the API Requests
- Setup a Global Store with the Yewdux Library
- Create Reusable Yew Components
    - Create a Spinner Component
    - Create a Loading Button Component
    - Create a Notification Toast Component
    - Create a Form Input Component
    - Create a Header Component
- Implement the Authentication Flow
    - Create the Account Registration Page
    - Create the Account Login Page
    - Add the Logout Functionality to the Header
- Create the Remaining Yew Pages
    - Create the Home Page Component
    - Create the Profile Page Component
- Setup Routes using the Yew Router Crate
- Render the Yew Application in the Main File
- Test the Yew Application in the Browser
    - Visit the Home Page
    - Register a New User
    - Login the User
    - Access the Protected Page

Read the entire article here: [https://codevoweb.com/frontend-app-with-rust-and-yew-user-signup-and-login/](https://codevoweb.com/frontend-app-with-rust-and-yew-user-signup-and-login/)

