# Awesome ChatGPT Resources

![ChatGPT](/chatgpt-banner.png)

> Curated list of resources for [ChatGPT](https://chat.openai.com) and GPT-3 from OpenAI

#### GPT General Resources

- [ChatGPT Official App](https://chat.openai.com)
- [OpenAI API Documentation](https://beta.openai.com/docs)
- [chatGPT launch blog](https://openai.com/blog/chatgpt/)

#### ChatGPT Community / Discussion
- [OpenAI Discord Channel](https://discord.com/invite/openai)


### API tools
- [Unoffical API in Python](https://github.com/acheong08/ChatGPT)
- [TLS-based API (Python)](https://github.com/rawandahmad698/PyChatGPT)
- [Unofficial API in JS/TS](https://github.com/transitive-bullshit/chatgpt-api)
- [Unofficial API in Dart](https://github.com/MisterJimson/chatgpt_api_dart)
- [ChatGPT (GPT-3.5-turbo) API Client in Golang](https://github.com/AlmazDelDiablo/gpt3-5-turbo-go)

### Chrome Extensions
- [Chrome extension to access ChatGPT as a popup on any page](https://github.com/kazuki-sf/ChatGPT_Extension)
- [Extension to display ChatGPT response alongside Google Search results](https://github.com/wong2/chat-gpt-google-extension)
- [Extension to add share abilities to ChatGPT (PDF, PNG or a sharable link](https://github.com/liady/ChatGPT-pdf)
- [Chrome extension to add input history, copy, and counters to ChatGPT](https://chrome.google.com/webstore/detail/superpower-chatgpt/amhmeenmapldpjdedekalnfifgnpfnkc)
- [ChassistantGPT - embeds ChatGPT as a hands-free voice assistant in the background](https://github.com/idosal/assistant-chat-gpt)
- [WebChatGPT - augment your prompts to ChatGPT with web search results](https://github.com/qunash/chatgpt-advanced/)
- [Talk to ChatGPT (voice interface)](https://github.com/C-Nedelcu/talk-to-chatgpt)


### Access ChatGPT from other platforms
- [Serverless Telegram bot](https://github.com/franalgaba/chatgpt-telegram-bot-serverless)
- [WhatsApp bot](https://github.com/danielgross/whatsapp-gpt)
- [RayCast Extension (unofficial)](https://github.com/abielzulio/chatgpt-raycast)
- [VSCode extension](https://github.com/mpociot/chatgpt-vscode) ([demo](https://twitter.com/marcelpociot/status/1599180144551526400))
- [Go Telegram bot](https://github.com/m1guelpf/chatgpt-telegram)
- [Twitter Bot](https://github.com/transitive-bullshit/chatgpt-twitter-bot) powered by ChatGPT
- [Chrome extension](https://github.com/kazuki-sf/ChatGPT_Extension)
- [Google docs](https://github.com/cesarhuret/docGPT)
- [Mac menubar app](https://github.com/vincelwt/chatgpt-mac)
- [Multi-platform desktop app (Windows, Mac, Linux)](https://github.com/lencx/ChatGPT) powered by ChatGPT & Tauri
- [Windows, Mac, Linux desktop app](https://github.com/sonnylazuardi/chatgpt-desktop)
- [Jetbrains IDEs plugin](https://github.com/LiLittleCat/intellij-chatgpt)
- [ChatGPT for Slack Bot](https://github.com/pedrorito/ChatGPTSlackBot)
- [ChatGPT for Discord Bot](https://github.com/m1guelpf/chatgpt-discord)


### Social Tools
- [shareGPT - permenent links to your conversations](https://github.com/domeccleston/sharegpt)

### Applications
- [Adrenaline: Debugger that fixes errors and explains them with GPT-3](https://github.com/shobrook/adrenaline/)
- [ChatARKit: Using ChatGPT to Create AR Experiences with Natural Language](https://github.com/trzy/ChatARKit)
- [GPT3 Blog Post Generator](https://github.com/simplysabir/AI-Writing-Assistant)

### CLI tools
- [Voice-based chatGPT](https://github.com/platelminto/chatgpt-conversation)
- [Explain your runtime errors with ChatGPT](https://github.com/shobrook/stackexplain)
- [GPT3 WordPress post generator](https://github.com/nicolaballotta/gtp3-wordpress-post-generator)
- [Assistant CLI](https://github.com/diciaup/assistant-cli)
- [AI Commit - Automagically generate conventional commit messages with AI](https://github.com/guanguans/ai-commit)
- [Use ChatGPT to generate PPT automatically, all in one single file](https://github.com/williamfzc/chat-gpt-ppt)

### DevOps
- [ChatGPT Code Review](https://github.com/kxxt/chatgpt-action)
- [Kubernetes and Prometheus ChatGPT Bot](https://github.com/robusta-dev/kubernetes-chatgpt-bot)
- [AI-powered Infrastructure-as-Code Generator](https://github.com/gofireflyio/aiac)

### Cybersecurity
- [Beelzebub ChatGPT Honeypot](https://github.com/mariocandela/beelzebub)
- [Penetration Testing Findings Generator](https://github.com/Stratus-Security/FinGen)

### Example prompts
- [Awesome ChatGPT prompts](https://github.com/wordmaxai/awesome-chatgpt-prompts)



---

### Contribution

This list started as personal collection of interesting things about chatGPT from OpenAI by Humanloop. Your contributions and suggestions are warmly welcomed.
