# Web CGI Exploits
[![License](https://img.shields.io/github/license/wofeiwo/webcgi-exploits.svg)](LICENSE)
[![README](https://img.shields.io/badge/README-English-blue.svg)](README.md)
[![README](https://img.shields.io/badge/README-中文-blue.svg)](README-zh.md)

Here's several exploits related to different web CGIs. I wrote those exploits in last few years.

## How it works
Web app are basicly those layers:

1. applications
2. web frameworks       
3. script language engines
4. web containers(servers)
5. web front proxy(nginx etc.)

* `4` and `5` could be the same thing.`3` and `4` could the same thing too.

There are communications between each layer. each layer software are developed by different teams. they do have standards to communicate each other, but they always have misunderstandings or design faults. So we can take advantage of those faults to achieve our goals, like RCE, spwan a shell, port forward etc.

## Exploits
### PHP

- Fastcgi 
  - Reference: [PHP FastCGI Remote Exploit(Chinese)](php/Fastcgi/php-fastcgi-remote-exploit.md)
  1. `fcgi_exp.go` use fastcgi to read or execute file if the fcgi port exposed to public( or with a `SSRF`).
  2. `fcgi_jailbreak.php` use fastcgi params to change some php ini configs and break php-based sandbox.
  - Reference: [Using PHP-FPM as memory shell(Chinese)](php/Fastcgi/php-fpm-memory-shell.md)
 
- Apache Mod_php 
  - Reference: [PHP Port Reuse With Mod_php(Chinese)](https://blog.wofeiwo.com/post/2011-10-09/PHPDuan-Kou-Fu-Yong-De-Li-Yong-.html)
  1. `mod_php_port_reuse.php` reuse the 80 connection to spawn a interactive shell. Bypass the firewall.
  2. `mod_php_port_proxy.py` work together with `mod_php_port_reuse.php`, create a 80 tcp proxy to bypass the firewall.

### Python

- Uwsgi
  - Reference: [uWSGI RCE Exploit(Chinese)](python/uwsgi-rce-zh.md)
  1. `uwsgi_exp.py` exploit uwsgi to execute any command remotely if the uwsgi port exposed to public( or with a `SSRF`).
