# Web CGI Exploits
[![License](https://img.shields.io/github/license/wofeiwo/webcgi-exploits.svg)](LICENSE)
[![README](https://img.shields.io/badge/README-English-blue.svg)](README.md)
[![README](https://img.shields.io/badge/README-中文-blue.svg)](README-zh.md)

这是我前几年写的和Web CGI相关的各种exp的集合。

## 原理
通常情况下，web的应用架构是这样分层的:

1. web应用程序
2. web框架       
3. 脚本语言解释器
4. web容器(服务器)
5. web前端反向代理(通常是nginx等等.)

* `4` & `5` 有可能是同一个东西，甚至有些时候`3` & `4`也可能是同一个东西。

可以把上面的内容想象成一个数据管道，每一个分层做一些处理和解析。请求和返回就在这么一来一回两个管道中生存和传递。每一层和下一层如何沟通通讯？相对而言比较复杂，通常会有一些标准，包括内存共享，socket通讯等等。不同语言有不同的实现。在`3`和`4`分层之间的通讯模式，通常这种被叫做CGI，fastcgi和python的wsgi都是常见的标准协议。
但是由于web容器和脚本语言的位置不同，因此在对通讯的使用和信任上并不完全一致。会有一些错误和误解存在。这也就给了我们很多机会，利用这里面的功能去挖掘漏洞，实现我们想要实现的功能。例如远程代码执行，端口转发等等。

## Exploits
### PHP

- Fastcgi

  参考文章[《PHP FastCGI 的远程利用》](php/Fastcgi/php-fastcgi-remote-exploit.md)

  1. `fcgi_exp.go`：当fastcgi端口对外，或者配合`SSRF`漏洞时候，可以利用此exp进行远程代码执行.
  2. `fcgi_jailbreak.php`：对一些基于php自身配置形成沙盒的环境，可以利用此脚本进行越狱.

  参考文章[利用PHP-FPM做内存马的方法](php/Fastcgi/php-fpm-memory-shell.md)
 
- Apache Mod_php

  mod_php和其他cgi不太一致的地方在于，他是以模块形式加载在apache进程中的，因此他可以操作进程中的相关资源。而apache的工作模式又通常是fork一些worker进程，会带入主进程的一些文件句柄可供操作。利用这些可以做一些很不错的trick。具体可以参考曾经的文章：[《PHP端口复用的利用》](https://blog.wofeiwo.com/post/2011-10-09/PHPDuan-Kou-Fu-Yong-De-Li-Yong-.html)

  1. `mod_php_port_reuse.php`：复用你的当前80端口链接，生成一个交互式的shell，可以绕过一些防火墙.
  2. `mod_php_port_proxy.py` 与 `mod_php_port_reuse.php` 共用，可以直接复用当前80端口链接，进行端口转发通讯.

### Python
Python 通常来说主要使用的就是wsgi模式做统一接口。但是在具体实现上有`uwsgi`、`gunicorn`、`scgi`、`mod_python`、`fastcgi`等多种。但是最常见的还是`uwsgi`、`gunicorn`这两个。其中`uwsgi`由于支持功能较多，通过协议直接传参，因此可以被利用。

- Uwsgi
  1. `uwsgi_exp.py`：利用uwsgi协议，远程执行任意命令，原理和使用场景和php fastcgi类似.具体可以参考[《uWSGI 远程代码执行漏洞》](python/uwsgi-rce-zh.md)
