---
slug: zero-shot-prompting
title: Zero-Shot Prompting
---

## Zero-Shot Prompt

相比于Few-Shot，此类别中是没有提供任何Examples，此时模型没有任何先验知识可以参考，那如何提升模型效果呢？

> 个人感觉 Zero-Shot的方法可以使用在Few-Shot 上面，进而让Few-Shot的效果上升一个档次。

### Role Prompting

编写角色说明，此时能够让模型能够站在某个角色的立场上有更符合目标偏好的输出。比如：

```prompt
你是一个可爱旅游导员，擅长使用俏皮可爱的话语来给大家介绍不同的景点，在面对旅客的刁难，你总是会用撒娇的方式来向用户表达歉意，然后给出一定具有建设性的建议给旅客。
```

以上的角色描述其实是在整体层面来规范输出风格，基本上属于 Prompt Engineering中的基操了。

### Emotion Prompting

如果模型的输出不太稳定时，此时可以加入一下强调描述词，进而增加输出内容的稳定性。

比如你想让模型输出 JSON 格式的内容，可随机性就是很大，此时可通过以下描述词来提升效果：

```prompt
求求你了，一定要输出JSON格式的内容！！！
重要的事情说三遍：你一定要输出JSON 格式的内容！你一定要输出JSON 格式的内容！你一定要输出JSON 格式的内容！
```

类似于以上的prompt可以增加输出的稳定性。

听起来很扯，可是大模型时代的编程就是如此。

### System2 Attention

不知道大家读过《思考快与慢》这本书没，可以大致了解下：人通常有两种思考方式，一种是快思考，可以认为是人的本能反应，另外一种是慢思考，就是经过缜密的思考之后的结果。

而这个对于大模型解决复杂问题有非常明显的提升效果。

此方法就是通过：在生成之前先慢思考，仔细分析用户的问题并重新调整 Prompt 之后再让模型来输出，这样可以生成有针对性的思考内容，进而提升整体效果。

:::tip 思考快与慢

有一点需要注意，重新prompt 可以认为是一个 Rewrite Agent，然后最后的生成也可以认为是一个Agent，所以用到了Agent Workflow的相关方法。

:::

### Rephrase and Response(RaR)

这个方法没有修改整体的Prompt，而是修改用户的Question。

在生成之前，对用户的Question进行重写，然后将其拆分成多个相关的问题，让模型来生成，此方法能够有效提升用户Question 的质量，进而让模型有更好的输出。

### Re-Reading（RE2）

在Instruction 中可以写上：在生成正式回答之前请再认真阅读用户的问题，据作者说可以有效提升在复杂问题上的效果。

### Self-Ask

对于一个复杂问题，模型通常无法直接回答，此时可让模型决定：是否要对齐问题进行拆解成多个子问题，然后依次回答对应子问题，等最终都回答完毕后，再回答最终问题。

其实这个方法也算是任务拆解，只不过问题呗拆解之后，还是自己来解决此问题，没有使用外部工具，甚至独立的LLM 来解决。