---
slug: what-is-prompt-engineering
title: 介绍
---

# Introduction to Prompt Engineering

Prompt Engineering 是一个新兴研究方向，无论是在学术界还是工业界都有非常热门，每周都会出现一些新方法，在此我给大家介绍一些当前比较热门或我觉得有价值推荐给大家的方法，其中会不定期的更新文章细节和添加实现代码，大家可以点击 [agent-handbook](https://github.com/wj-Mcat/agent-handbook) 中所有的Event，进而获取最新进展消息。

Prompt Engineering 的方法整体上可以分为六大类：

* In-Context Learning：从提示中的示例/指令中学习
* Zero-Shot Learning：零样本 - 无示例提示
* Chain-of-Thought：思维生成 - 提示LLM阐述推理过程
* Decomposition：任务拆解，将复杂问题拆分为多个简单问题
* Ensembling：融合多种不同的信息并生成最终回复。
* Self-Criticism：让模型来评估模型的输出，如果不太好就需要重新解决。

以上六类方法之间有部分交集，可是处理的阶段不同，大家按照自己实际情况来选择使用即可。

## 什么是Prompt

简单来说，就是你给LLM的输入。可是为了让LLM完成人们不同种类的任务，就需要不同类型的Prompt（具体方法下面会介绍）。

### Prompt 的构成

通常为了完成一个复杂的任务，其 Prompt 当中包含以下内容：

* Instruction：就是你想让LLM 帮你完成任务的各种指令，比如：`当用户咨询你天气时，你需要调用 get_weather 工具然后回复用户真实的天气信息`。
* Examples：如果不给examples，那就是zero-shot，效果可能会不太好。面对复杂任务，我们还是建议在Prompt 当中适当的增加高质量的examples（few-shot）进而让LLM 更精准的遵循你的指令。
* Output Format：你可以控制LLM的输出格式，比如输出markdown、json、yaml 等相关格式，进而更好的用编程语言进行读取加载，进而实现与现有系统进行对接。
* Style Instruction：和Instruction 不一样的是，这个主要是对于输出做整体的要求，比如：输出内容俏皮可爱、输出言简意赅等。
* Role：通常你可以在Prompt 设置一个agent 的角色，进而提升LLM 的输出内容质量，更符合人类的偏好，比如：**假设你是一个段子手，请用风趣幽默的话语来回答用户的各种问题**。
* User Info：在对话的过程中，可以将用户的最新信息动态的添加到 Prompt 当中，进而实现更加精准的对话状态控制，比如用户的姓名为：XXX，用户的所在地为：YYY，用户是否有购买意愿：无购买意愿，......等等。
* System Info：可以添加一些系统信息，比如当前北京实现，Agent的介绍信息等。

### Prompt 相关的术语

因为 Prompting 相关的技术目前处于早起，相关术语正在快速发展，不确定未来会不会出现新的相关术语，在此我先罗列出目前出现的最新术语，提供大家参考：

* Prompting：包含 prompt + LLM generating + parse response 等多个过程。
* Prompt Chain：包含多个Prompting 的过程，是 Prompt Workflow 或 Multi-Agent 的关键部分。
* Prompt Engineering：主要介绍通过prompt 来完成某指定任务的过程，可以认为这是Prompt Engineer（提示词工程师）的工作内容；
* Exemplar：主要是对于一个任务的输入和输出的示例，进而让模型更精准的理解用户的用途，更稳定的输出指定格式的内容。
* Agent：智能体的概念就比较复杂，最简单的Agent就是：Prompt + LLM，提前编写好Prompt，然后包装成一个应用与外界进行对话，此时就是一个Agent。当然内部可以包含非常复杂的逻辑，甚至一个Agent可以嵌套另外一个Agent，这都是可以的。


## 为何 Prompt Engineering 如此重要

从现在招聘JD中即可看出一些端倪：Prompt Engineering 已在各大公司广泛应用，主要能够为各大业务赋能，我罗列出如下几点：

### 提升大模型性能和效果

通过设计和优化模型的输入提示（Prompt），能够显著提高AI的性能和效果。这种优化使得大模型在执行特定任务时更加准确、可靠。

一个会写Prompt的工程师，能够让大模型更精准的理解并完成各类复杂的任务，然后输出指定格式的内容，进而实现与现有系统进行对接，这点对于接入现有系统而言至关重要，推荐大家了解一下JSON Mode，目前主流厂商的API 当中都会加上这个功能。

### 广泛的应用场景

由于大模型现在啥都能干，完全颠覆了传统的NLP 范式，现在只需要通过编写Prompt即可完成传统的：文本分类、命名实体识别、对话系统、机器翻译、文本摘要等任务。而每个人而任务都需要编写有针对性的Prompt，即可引导模型生成更准确、更符合要求的输出。

:::tip 科技是第一生产力

以前三个工程师两个月才能完成的任务，现如今只需要使用大模型，一个 Prompt Engineer 一两天即可完成，这是一件非常颠覆性的事情，本人也非常感叹科技带来的革命性改变。

:::

图像识别与智能推荐：在图像识别和智能推荐系统中，Prompt Engineering同样发挥着重要作用。通过优化Prompt，可以提高图像识别的准确性和推荐系统的个性化程度。此外在推荐系统当中已经有一些尝试了，这是一个非常新的方向，建议老铁们可以冲一冲。

跨领域应用：随着不同领域对AI技术的需求增加，Prompt Engineering有望在更多领域得到应用，如医疗、金融、教育等，帮助这些领域更好地利用AI技术解决复杂问题。你看最近百川也是入局了大模型医疗，这是一个造福人类的方向，也希望能够在这个方向上能够做出一些颠覆性的工作，让人们看病、诊病、康复更加简单科学，进而延长人类的寿命。

### 模型的可解释性和可控性

Prompt Engineering有助于提高大模型的可解释性。通过设计和优化Prompt，可以更好地理解模型的内部工作原理，从而增强人们对AI技术的信任和接受度。CoT 中的 Thought 就是一个非常具备可解释性的内容，能够让我们看到大模型是如何推理的，如果有任何问题，我们可以有针对性的优化 Instruction，进而不断地提升应用效果。

通过精心设计的Prompt，可以更加精准地控制大模型的行为和输出，使其更加符合用户的期望和需求。

### 推动自然语言编程的发展

随着Prompt Engineering技术的不断进步，自然语言编程的应用空间变得更加广阔，用户可以通过自然语言指令与大模型进行交互，实现各种复杂的任务和功能。

:::tip 未来人机交互

未来人机交互都将会是通过自然语言来完成，你只需要告诉机器人你的诉求，他就可以完成指定任务，甚至能够自我更新，自我进化，不断满足你的各类需求。

:::

Prompt Engineering 使得开发人员能够更加高效地利用大模型进行开发工作，减少了对传统编程语言的依赖，降低了开发门槛和成本。

### 应对大语言模型的挑战

Prompt Engineering有助于缓解大语言模型中存在的幻觉问题（即生成并不存在的信息或事实）。通过优化Prompt设计和通过RAG相关技术，可以让模型的输出更加真实、准确。

随着大语言模型能力的不断增强，编写高质量的Prompt变得越来越重要。Prompt Engineering使得开发人员能够更好地发挥大语言模型的优势，实现更加复杂的任务和功能。

说了这么多，你能理解Prompt Engineering为何如此重要了吧。快学起来 ！！！