﻿# Contributing

Contributions to this project are [released][Github Terms of Service] to the public under the project's open source [license].

This project adheres to a [Code of Conduct]. By participating, you are expected to honor this code.

<!--A quick introduction of what this project does and what it does not do.-->
This is a support library to build CLI applications in .Net.

## Pull Request Process
1. Fork the project.
1. Clone the repository in your development machine (`git clone develop git@github.com:wizaro/CommandLine.git`).
1. Create a branch in the cloned repository (`git checkout -b topic/{my-feature}`).
1. Make your changes following these guidelines.
1. Commit your changes (`git commit -am "{Changes Summary}."`).
1. Push to the branch (`git push origin topic/{my-feature}`).
1. Open a [Pull Request].

## Environment
<!--This section should contain a short summary of the development environment.-->
Developed in C# on Visual Studio 2019.

## Prerequisites
<!--This section should contain the steps on what needs to be done, installed and run before working in the project.-->
- Git Flow (AVH) extensions are preferred but not required.

## Developing
<!--This section should contain the commands to lint the code and the steps to ensure high code quality and reduce the likelihood that the changes inadvertently break something.-->
The project has dependencies on code analysis tools to automate some coding standards. Please follow the [C# Coding Conventions] and the [Open-Source Library Guidance].

## Testing
<!--This section should contain instructions for running the tests.-->
Currently there are no tests.

## Releasing
<!--This section should contain instructions for creating a release of the project.-->
There is no release path yet, just build the project.

<!--Links-->
[C# Coding Conventions]: https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/inside-a-program/coding-conventions
[Code of Conduct]: ./CODE_OF_CONDUCT.md
[Github Terms of Service]: https://help.github.com/en/github/site-policy/github-terms-of-service#6-contributions-under-repository-license "Github Terms of Service / User-Generated Content / Contributions Under Repository License"
[License]: ./LICENSE "MIT License"
[Open-Source Library Guidance]: https://docs.microsoft.com/en-us/dotnet/standard/library-guidance/
[Pull Request]: https://github.com/wizaro/CommandLine/pulls