package net.wizardsoflua.lua.classes.event;

import com.google.auto.service.AutoService;

import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.sandius.rembulan.Table;
import net.wizardsoflua.annotation.GenerateLuaClassTable;
import net.wizardsoflua.annotation.GenerateLuaDoc;
import net.wizardsoflua.annotation.GenerateLuaInstanceTable;
import net.wizardsoflua.annotation.LuaProperty;
import net.wizardsoflua.extension.api.inject.Resource;
import net.wizardsoflua.extension.spell.api.resource.Injector;
import net.wizardsoflua.extension.spell.api.resource.LuaConverters;
import net.wizardsoflua.extension.spell.spi.LuaConverter;
import net.wizardsoflua.lua.classes.BasicLuaClass;
import net.wizardsoflua.lua.classes.LuaClassAttributes;
import net.wizardsoflua.lua.classes.common.Delegator;

/**
 * The <span class="notranslate">LivingEvent</span> is the base class of events about living
 * entities.
 */
@AutoService(LuaConverter.class)
@LuaClassAttributes(name = LivingEventClass.NAME, superClass = EntityEventClass.class)
@GenerateLuaClassTable(instance = LivingEventClass.Instance.class)
@GenerateLuaDoc(type = EventClass.TYPE)
public final class LivingEventClass
    extends BasicLuaClass<LivingEvent, LivingEventClass.Instance<LivingEvent>> {
  public static final String NAME = "LivingEvent";
  @Resource
  private LuaConverters converters;
  @Resource
  private Injector injector;

  @Override
  protected Table createRawTable() {
    return new LivingEventClassTable<>(this, converters);
  }

  @Override
  protected Delegator<Instance<LivingEvent>> toLuaInstance(LivingEvent javaInstance) {
    return new LivingEventClassInstanceTable<>(new Instance<>(javaInstance, getName(), injector),
        getTable(), converters);
  }

  @GenerateLuaInstanceTable
  public static class Instance<D extends LivingEvent> extends EntityEventClass.Instance<D> {
    public Instance(D delegate, String name, Injector injector) {
      super(delegate, name, injector);
    }

    /**
     * The entity that this event is about.
     */
    @LuaProperty
    @Override
    public EntityLivingBase getEntity() {
      return delegate.getEntityLiving();
    }
  }
}
