---
title: Features
---
*The Wizards of Lua modification adds the /lua command to Minecraft, which
gives you the power to cast magical spells in Minecraft.*

With a spell you can, for example, do the following:

* Create [magical items](/examples/rocket-thrower).
* Create mini games.
* Create procedural structures.

To do all this, you just need to become a Wizard of Lua.
That means, getting familiar with [Lua](http://www.lua.org), the language of magic,
and studying the magic words documented in the secretive [spell book library](/spellbooklibrary).

As a wizard, you will know how to execute the following great magical powers:

* Creating spells with the [built-in Lua editor](/introduction.html#Editor).
* Using all Lua language features, like variables, loops, conditional bocks, and functions.
* Running multiple spells simultaneously.
* Breaking spells.
* [Accessing and changing any block](/modules/Blocks) in the Minecraft world, including data values and NBT values.
* [Querying](/modules/Entities) and manipulating [players](/modules/Player), [creatures](/modules/Entity), and [items](/modules/Items).
* [Receiving](/modules/Events/#collect) in-game events like [left-click-block](/modules/LeftClickBlockEvent), [swing-arm](/modules/SwingArmEvent), and many others.
* [Firing](/modules/Events/#fire) and handling [custom events](/modules/CustomEvent).
* [Executing](/modules/Spell/#execute) any Minecraft command, even those added by other mods.
* [Accessing](/tutorials/importing_lua_files/) self-made Lua modules from the server's file system.

If you want to start right now, please read the [introduction](/introduction).
