# 练习5：一个C程序的结构

> 原文：[Exercise 5: The Structure Of A C Program](http://c.learncodethehardway.org/book/ex5.html)

> 译者：[飞龙](https://github.com/wizardforcel)

你已经知道了如何使用`printf`，也有了可以随意使用的一些工具，现在让我们逐行分析一个简单的C程序，以便你了解它是如何组织的。在这个程序里你会编写一些不是很熟悉的东西，我会轻松地把它们拆开。之后在后面的几章我们将会处理这些概念。

```c
#include <stdio.h>

/* This is a comment. */
int main(int argc, char *argv[])
{
    int distance = 100;

    // this is also a comment
    printf("You are %d miles away.\n", distance);

    return 0;
}
```

手动输入这段代码并运行它，之后确保在`Valgrind`下不出现任何错误。你可能不会这样做，但你得习惯它。

## 你会看到什么

这真是一段无聊的输出，但是这个练习的目的是让你分析代码：

```sh
$ make ex5
cc -Wall -g    ex5.c   -o ex5
$ ./ex5
You are 100 miles away.
$
```

## 分解代码

当你输出这段代码时，可能你只弄清楚了这段代码中的一小部分C语言特性。让我们快速地逐行分解它，之后我们可以做一些练习来更好地了解每一部分：

　　ex5.c:1

　　这是一个`include`，它是将一个文件的内容导入到这个文件的方式。C具有使用`.h`扩展名作为头文件的惯例。头文件中拥有一些函数的列表，这些都是你想在程序中使用的函数。

　　ex5.c:3

　　这是多行注释，你可以在`/*`和`*/`之间放置任意多行。

　　ex5.c:4

　　这是一个你遇到的更复杂的 `main` 函数。操作系统加载完你的程序，之后会运行叫做`main`的函数，这是C程序的工作方式。这个函数只需要返回`int`，并接受两个参数，一个是`int`作为命令行参数的数量，另一个是`char*`字符串的数组作为命令行参数。这是不是让人难以理解？不用担心，我们稍后会讲解它。

　　ex5.c:5

　　任何函数都以`{`字符开始，它表示“程序块”的开始。在Python中用一个`:`来表示。在其它语言中，可能需要用`begin`或者`do`来表示。

　　ex5.c:6

　　一个变量的声明和同时的赋值。你可以使用语法`type name = value;`来创建变量。在C的语句中，除了逻辑语句，都以一个`;`（分号）来结尾。

　　ex5.c:8

　　注释的另一种形式，它就像Python或Ruby的注释。它以`//`开头，直到行末结束。

　　ex5.c:9

　　调用了我们的老朋友`printf`。就像许多语言中的函数调用，使用语法`name(arg1, arg2);`。函数可以不带任何参数，也可以拥有任何数量的参数。`printf`函数是一类特别的函数，可以带可变数量的参数。我们会在之后说明。

　　ex5.c:11

　　一个`main`函数的返回语句，它会向OS提供退出值。你可能不熟悉Unix软件的返回代码，所以这个也放到后面去讲。

　　ex5.c:12

　　最后，我们以一个闭合的`}`花括号来结束了`main`函数。它就是整个程序的结尾了。

在这次分解中有大量的信息，所以你应该逐行来学习，并且确保至少掌握了背后发生了什么。你不一定了解所有东西，但是在我们继续之前，你可以猜猜它们的意思。

## 附加题

+ 对于每一行，写出你不理解的符号，并且看看是否能猜出它们的意思。在纸上写下你的猜测，你可以在以后检查它，看看是否正确。
+ 回头去看之前几个练习的源代码，并且像这样分解代码，来看看你是否了解它们。写下你不了解和不能自己解释的东西。
