# 练习16：结构体和指向它们的指针

> 原文：[Exercise 16: Structs And Pointers To Them](http://c.learncodethehardway.org/book/ex16.html)

> 译者：[飞龙](https://github.com/wizardforcel)

在这个练习中你将会学到如何创建`struct`，将一个指针指向它们，以及使用它们来理解内存的内部结构。我也会借助上一节课中的指针知识，并且让你使用`malloc`从原始内存中构造这些结构体。

像往常一样，下面是我们将要讨论的程序，你应该把它打下来并且使它正常工作：

```c
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>

struct Person {
    char *name;
    int age;
    int height;
    int weight;
};

struct Person *Person_create(char *name, int age, int height, int weight)
{
    struct Person *who = malloc(sizeof(struct Person));
    assert(who != NULL);

    who->name = strdup(name);
    who->age = age;
    who->height = height;
    who->weight = weight;

    return who;
}

void Person_destroy(struct Person *who)
{
    assert(who != NULL);

    free(who->name);
    free(who);
}

void Person_print(struct Person *who)
{
    printf("Name: %s\n", who->name);
    printf("\tAge: %d\n", who->age);
    printf("\tHeight: %d\n", who->height);
    printf("\tWeight: %d\n", who->weight);
}

int main(int argc, char *argv[])
{
    // make two people structures
    struct Person *joe = Person_create(
            "Joe Alex", 32, 64, 140);

    struct Person *frank = Person_create(
            "Frank Blank", 20, 72, 180);

    // print them out and where they are in memory
    printf("Joe is at memory location %p:\n", joe);
    Person_print(joe);

    printf("Frank is at memory location %p:\n", frank);
    Person_print(frank);

    // make everyone age 20 years and print them again
    joe->age += 20;
    joe->height -= 2;
    joe->weight += 40;
    Person_print(joe);

    frank->age += 20;
    frank->weight += 20;
    Person_print(frank);

    // destroy them both so we clean up
    Person_destroy(joe);
    Person_destroy(frank);

    return 0;
}
```

我打算使用一种和之前不一样的方法来描述这段程序。我并不会对程序做逐行的拆分，而是由你自己写出来。我会基于程序所包含的部分来给你提示，你的任务就是写出每行是干什么的。

包含（`include`）

我包含了一些新的头文件，来访问一些新的函数。每个头文件都提供了什么东西？

`struct Person`

这就是我创建结构体的地方了，结构体含有四个成员来描述一个人。最后我们得到了一个复合类型，让我们通过一个名字来整体引用这些成员，或它们的每一个。这就像数据库表中的一行或者OOP语言中的一个类那样。

`Pearson_create` 函数

我需要一个方法来创建这些结构体，于是我定义了一个函数来实现。下面是这个函数做的几件重要的事情：

+ 使用用于内存分配的`malloc`来向OS申请一块原始的内存。
+ 向`malloc`传递`sizeof(struct Person)`参数，它计算结构体的大小，包含其中的所有成员。
+ 使用了`assert`来确保从`malloc`得到一块有效的内存。有一个特殊的常量叫做`NULL`，表示“未设置或无效的指针”。这个`assert`大致检查了`malloc`是否会返回`NULL`。
+ 使用`x->y`语法来初始化`struct Person`的每个成员，它指明了所初始化的成员。
+ 使用`strdup`来复制字符串`name`，是为了确保结构体真正拥有它。`strdup`的行为实际上类似`malloc`但是它同时会将原来的字符串复制到新创建的内存。

> 译者注：`x->y`是`(*x).y`的简写。

`Person_destroy` 函数

如果定义了创建函数，那么一定需要一个销毁函数，它会销毁`Person`结构体。我再一次使用了`assert`来确保不会得到错误的输入。接着我使用了`free`函数来交还通过`malloc`和`strdup`得到的内存。如果你不这么做则会出现“内存泄露”。

> 译者注：不想显式释放内存又能避免内存泄露的办法是引入`libGC`库。你需要把所有的`malloc`换成`GC_malloc`，然后把所有的`free`删掉。

`Person_print` 函数

接下来我需要一个方法来打印出人们的信息，这就是这个函数所做的事情。它用了相同的`x->y`语法从结构体中获取成员来打印。

`main` 函数

我在`main`函数中使用了所有前面的函数和`struct Person`来执行下面的事情：

+ 创建了两个人：`joe`和`frank`。
+ 把它们打印出来，注意我用了`%p`占位符，所以你可以看到程序实际上把结构体放到了哪里。
+ 把它们的年龄增加20岁，同时增加它们的体重。
+ 之后打印出每个人。
+ 最后销毁结构体，以正确的方式清理它们。

请仔细阅读上面的描述，然后做下面的事情：

+ 查询每个你不了解的函数或头文件。记住你通常可以使用`man 2 function`或者`man 3 function`来让它告诉你。你也可以上网搜索资料。
+ 在每一行上方编写注释，写下这一行代码做了什么。
+ 跟踪每一个函数调用和变量，你会知道它在程序中是在哪里出现的。
+ 同时也查询你不清楚的任何符号。

## 你会看到什么

在你使用描述性注释扩展程序之后，要确保它实际上能够运行，并且产生下面的输出：

```sh
$ make ex16
cc -Wall -g    ex16.c   -o ex16

$ ./ex16
Joe is at memory location 0xeba010:
Name: Joe Alex
    Age: 32
    Height: 64
    Weight: 140
Frank is at memory location 0xeba050:
Name: Frank Blank
   Age: 20
   Height: 72
   Weight: 180
Name: Joe Alex
   Age: 52
   Height: 62
   Weight: 180
Name: Frank Blank
   Age: 40
   Height: 72
   Weight: 200
```

## 解释结构体

如果你完成了我要求的任务，你应该理解了结构体。不过让我来做一个明确的解释，确保你真正理解了它。

C中的结构体是其它数据类型（变量）的一个集合，它们储存在一块内存中，然而你可以通过独立的名字来访问每个变量。它们就类似于数据库表中的一行记录，或者面向对象语言中的一个非常简单的类。让我们以这种方式来理解它：


+ 在上面的代码中，你创建了一个结构体，它们的成员用于描述一个人：名称、年龄、体重、身高。
+ 每个成员都有一个类型，比如是`int`。
+ C会将它们打包到一起，于是它们可以用单个的结构体来存放。
+ `struct Person`是一个复合类型，这意味着你可以在同种表达式中将其引用为其它的数据类型。
+ 你可以将这一紧密的组合传递给其它函数，就像`Person_print`那样。
+ 如果结构体是指针的形式，接着你可以使用`x->y`通过它们的名字来访问结构体中独立的部分。
+ 还有一种创建结构体的方法，不需要指针，通过`x.y`来访问。你将会在附加题里面见到它。

如果你不使用结构体，则需要自己计算出大小、打包以及定位出指定内容的内存片位置。实际上，在大多数早期（甚至现在的一些）的汇编代码中，这就是唯一的方式。在C中你就可以让C来处理这些复合数据类型的内存构造，并且专注于和它们交互。

## 如何使它崩溃

使这个程序崩溃的办法涉及到使用指针和`malloc`系统的方法：

+ 试着传递`NULL`给`Person_destroy`来看看会发生什么。如果它没有崩溃，你必须移除Makefile的`CFLAGS`中的`-g`选项。
+ 在结尾处忘记调用`Person_destroy`，在`Valgrind`下运行程序，你会看到它报告出你忘记释放内存。弄清楚你应该向`valgrind`传递什么参数来让它向你报告内存如何泄露。
+ 忘记在`Person_destroy`中释放`who->name`，并且对比两次的输出。同时，使用正确的选项来让`Valgrind`告诉你哪里错了。
+ 这一次，向`Person_print`传递`NULL`，并且观察`Valgrind`会输出什么。
+ 你应该明白了`NULL`是个使程序崩溃的快速方法。

## 附加题

在这个练习的附加题中我想让你尝试一些有难度的东西：将这个程序改为不用指针和`malloc`的版本。这可能很困难，所以你需要研究下面这些东西：

+ 如何在栈上创建结构体，就像你创建任何其它变量那样。
+ 如何使用`x.y`而不是`x->y`来初始化结构体。
+ 如何不使用指针来将结构体传给其它函数。
