// DO NOT EDIT. This file is auto-generated by `amalgamate.py`.

#include "Zydis.h"


//
// Source file: /home/ath/devel/zydis/src/Decoder.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

// ReSharper disable CppClangTidyClangDiagnosticImplicitFallthrough
// ReSharper disable CppClangTidyClangDiagnosticSwitchEnum
// ReSharper disable CppClangTidyClangDiagnosticCoveredSwitchDefault

// Temporarily disabled due to a LLVM issue:
// ReSharper disable CppClangTidyBugproneNarrowingConversions


//
// Header: Zycore/LibC.h
//

/***************************************************************************************************

  Zyan Core Library (Zycore-C)

  Original Author : Florian Bernd, Joel Hoener

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

/**
 * @file
 * Provides a simple LibC abstraction and fallback routines.
 */

#ifndef ZYCORE_LIBC_H
#define ZYCORE_LIBC_H

#ifndef ZYAN_CUSTOM_LIBC

// Include a custom LibC header and define `ZYAN_CUSTOM_LIBC` to provide your own LibC
// replacement functions

#ifndef ZYAN_NO_LIBC

/* ============================================================================================== */
/* LibC is available                                                                              */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* errno.h                                                                                        */
/* ---------------------------------------------------------------------------------------------- */

#include <errno.h>

#define ZYAN_ERRNO  errno

/* ---------------------------------------------------------------------------------------------- */
/* stdarg.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

#include <stdarg.h>

/**
 * Defines the `ZyanVAList` datatype.
 */
typedef va_list ZyanVAList;

#define ZYAN_VA_START               va_start
#define ZYAN_VA_ARG                 va_arg
#define ZYAN_VA_END                 va_end
#define ZYAN_VA_COPY(dest, source)  va_copy((dest), (source))

/* ---------------------------------------------------------------------------------------------- */
/* stdio.h                                                                                        */
/* ---------------------------------------------------------------------------------------------- */

#include <stdio.h>

#define ZYAN_FPUTS      fputs
#define ZYAN_FPUTC      fputc
#define ZYAN_FPRINTF    fprintf
#define ZYAN_PRINTF     printf
#define ZYAN_PUTC       putc
#define ZYAN_PUTS       puts
#define ZYAN_SCANF      scanf
#define ZYAN_SSCANF     sscanf
#define ZYAN_VSNPRINTF  vsnprintf

/**
 * Defines the `ZyanFile` datatype.
 */
typedef FILE ZyanFile;

#define ZYAN_STDIN      stdin
#define ZYAN_STDOUT     stdout
#define ZYAN_STDERR     stderr

/* ---------------------------------------------------------------------------------------------- */
/* stdlib.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

#include <stdlib.h>
#define ZYAN_CALLOC     calloc
#define ZYAN_FREE       free
#define ZYAN_MALLOC     malloc
#define ZYAN_REALLOC    realloc

/* ---------------------------------------------------------------------------------------------- */
/* string.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

#include <string.h>
#define ZYAN_MEMCHR     memchr
#define ZYAN_MEMCMP     memcmp
#define ZYAN_MEMCPY     memcpy
#define ZYAN_MEMMOVE    memmove
#define ZYAN_MEMSET     memset
#define ZYAN_STRCAT     strcat
#define ZYAN_STRCHR     strchr
#define ZYAN_STRCMP     strcmp
#define ZYAN_STRCOLL    strcoll
#define ZYAN_STRCPY     strcpy
#define ZYAN_STRCSPN    strcspn
#define ZYAN_STRLEN     strlen
#define ZYAN_STRNCAT    strncat
#define ZYAN_STRNCMP    strncmp
#define ZYAN_STRNCPY    strncpy
#define ZYAN_STRPBRK    strpbrk
#define ZYAN_STRRCHR    strrchr
#define ZYAN_STRSPN     strspn
#define ZYAN_STRSTR     strstr
#define ZYAN_STRTOK     strtok
#define ZYAN_STRXFRM    strxfrm

/* ---------------------------------------------------------------------------------------------- */

#else  // if ZYAN_NO_LIBC

/* ============================================================================================== */
/* No LibC available, use our own functions                                                       */
/* ============================================================================================== */


/*
 * These implementations are by no means optimized and will be outperformed by pretty much any
 * libc implementation out there. We do not aim towards providing competetive implementations here,
 * but towards providing a last resort fallback for environments without a working libc.
 */

/* ---------------------------------------------------------------------------------------------- */
/* stdarg.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

#if defined(ZYAN_MSVC) || defined(ZYAN_ICC)

/**
 * Defines the `ZyanVAList` datatype.
 */
typedef char* ZyanVAList;

#   define ZYAN_VA_START __crt_va_start
#   define ZYAN_VA_ARG   __crt_va_arg
#   define ZYAN_VA_END   __crt_va_end
#   define ZYAN_VA_COPY(destination, source) ((destination) = (source))

#elif defined(ZYAN_GNUC)

/**
 * Defines the `ZyanVAList` datatype.
 */
typedef __builtin_va_list  ZyanVAList;

#   define ZYAN_VA_START(v, l)  __builtin_va_start(v, l)
#   define ZYAN_VA_END(v)       __builtin_va_end(v)
#   define ZYAN_VA_ARG(v, l)    __builtin_va_arg(v, l)
#   define ZYAN_VA_COPY(d, s)   __builtin_va_copy(d, s)

#else
#   error "Unsupported compiler for no-libc mode."
#endif

/* ---------------------------------------------------------------------------------------------- */
/* stdio.h                                                                                        */
/* ---------------------------------------------------------------------------------------------- */

// ZYAN_INLINE int ZYAN_VSNPRINTF (char* const buffer, ZyanUSize const count,
//     char const* const format, ZyanVAList args)
// {
//      // We cant provide a fallback implementation for this function
//     ZYAN_UNUSED(buffer);
//     ZYAN_UNUSED(count);
//     ZYAN_UNUSED(format);
//     ZYAN_UNUSED(args);
//     return ZYAN_NULL;
// }

/* ---------------------------------------------------------------------------------------------- */
/* stdlib.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

// ZYAN_INLINE void* ZYAN_CALLOC(ZyanUSize nitems, ZyanUSize size)
// {
//      // We cant provide a fallback implementation for this function
//     ZYAN_UNUSED(nitems);
//     ZYAN_UNUSED(size);
//     return ZYAN_NULL;
// }
//
// ZYAN_INLINE void ZYAN_FREE(void *p)
// {
//      // We cant provide a fallback implementation for this function
//     ZYAN_UNUSED(p);
// }
//
// ZYAN_INLINE void* ZYAN_MALLOC(ZyanUSize n)
// {
//     // We cant provide a fallback implementation for this function
//     ZYAN_UNUSED(n);
//     return ZYAN_NULL;
// }
//
// ZYAN_INLINE void* ZYAN_REALLOC(void* p, ZyanUSize n)
// {
//      // We cant provide a fallback implementation for this function
//     ZYAN_UNUSED(p);
//     ZYAN_UNUSED(n);
//     return ZYAN_NULL;
// }

/* ---------------------------------------------------------------------------------------------- */
/* string.h                                                                                       */
/* ---------------------------------------------------------------------------------------------- */

ZYAN_INLINE void* ZYAN_MEMCHR(const void* str, int c, ZyanUSize n)
{
    const ZyanU8* p = (ZyanU8*)str;
    while (n--)
    {
        if (*p != (ZyanU8)c)
        {
            p++;
        } else
        {
            return (void*)p;
        }
    }
    return 0;
}

ZYAN_INLINE int ZYAN_MEMCMP(const void* s1, const void* s2, ZyanUSize n)
{
    const ZyanU8* p1 = s1, *p2 = s2;
    while (n--)
    {
        if (*p1 != *p2)
        {
            return *p1 - *p2;
        }
        p1++, p2++;
    }
    return 0;
}

ZYAN_INLINE void* ZYAN_MEMCPY(void* dst, const void* src, ZyanUSize n)
{
    volatile ZyanU8* dp = dst;
    const ZyanU8* sp = src;
    while (n--)
    {
        *dp++ = *sp++;
    }
    return dst;
}

ZYAN_INLINE void* ZYAN_MEMMOVE(void* dst, const void* src, ZyanUSize n)
{
    volatile ZyanU8* pd = dst;
    const ZyanU8* ps = src;
    if (ps < pd)
    {
        for (pd += n, ps += n; n--;)
        {
            *--pd = *--ps;
        }
    } else
    {
        while (n--)
        {
            *pd++ = *ps++;
        }
    }
    return dst;
}

ZYAN_INLINE void* ZYAN_MEMSET(void* dst, int val, ZyanUSize n)
{
    volatile ZyanU8* p = dst;
    while (n--)
    {
        *p++ = (unsigned char)val;
    }
    return dst;
}

ZYAN_INLINE char* ZYAN_STRCAT(char* dest, const char* src)
{
    char* ret = dest;
    while (*dest)
    {
        dest++;
    }
    while ((*dest++ = *src++));
    return ret;
}

ZYAN_INLINE char* ZYAN_STRCHR(const char* s, int c)
{
    while (*s != (char)c)
    {
        if (!*s++)
        {
            return 0;
        }
    }
    return (char*)s;
}

ZYAN_INLINE int ZYAN_STRCMP(const char* s1, const char* s2)
{
    while (*s1 && (*s1 == *s2))
    {
        s1++, s2++;
    }
    return *(const ZyanU8*)s1 - *(const ZyanU8*)s2;
}

ZYAN_INLINE int ZYAN_STRCOLL(const char *s1, const char *s2)
{
    // TODO: Implement

    ZYAN_UNUSED(s1);
    ZYAN_UNUSED(s2);

    return 0;
}

ZYAN_INLINE char* ZYAN_STRCPY(char* dest, const char* src)
{
    char* ret = dest;
    while ((*dest++ = *src++));
    return ret;
}

ZYAN_INLINE ZyanUSize ZYAN_STRCSPN(const char *s1, const char *s2)
{
    ZyanUSize ret = 0;
    while (*s1)
    {
        if (ZYAN_STRCHR(s2, *s1))
        {
            return ret;
        }
        s1++, ret++;
    }
    return ret;
}

ZYAN_INLINE ZyanUSize ZYAN_STRLEN(const char* str)
{
    const char* p = str;
    while (*str)
    {
        ++str;
    }
    return str - p;
}

ZYAN_INLINE char* ZYAN_STRNCAT(char* dest, const char* src, ZyanUSize n)
{
    char* ret = dest;
    while (*dest)
    {
        dest++;
    }
    while (n--)
    {
        if (!(*dest++ = *src++))
        {
            return ret;
        }
    }
    *dest = 0;
    return ret;
}

ZYAN_INLINE int ZYAN_STRNCMP(const char* s1, const char* s2, ZyanUSize n)
{
    while (n--)
    {
        if (*s1++ != *s2++)
        {
            return *(unsigned char*)(s1 - 1) - *(unsigned char*)(s2 - 1);
        }
    }
    return 0;
}

ZYAN_INLINE char* ZYAN_STRNCPY(char* dest, const char* src, ZyanUSize n)
{
    char* ret = dest;
    do
    {
        if (!n--)
        {
            return ret;
        }
    } while ((*dest++ = *src++));
    while (n--)
    {
        *dest++ = 0;
    }
    return ret;
}

ZYAN_INLINE char* ZYAN_STRPBRK(const char* s1, const char* s2)
{
    while (*s1)
    {
        if(ZYAN_STRCHR(s2, *s1++))
        {
            return (char*)--s1;
        }
    }
    return 0;
}

ZYAN_INLINE char* ZYAN_STRRCHR(const char* s, int c)
{
    char* ret = 0;
    do
    {
        if (*s == (char)c)
        {
            ret = (char*)s;
        }
    } while (*s++);
    return ret;
}

ZYAN_INLINE ZyanUSize ZYAN_STRSPN(const char* s1, const char* s2)
{
    ZyanUSize ret = 0;
    while (*s1 && ZYAN_STRCHR(s2, *s1++))
    {
        ret++;
    }
    return ret;
}

ZYAN_INLINE char* ZYAN_STRSTR(const char* s1, const char* s2)
{
    const ZyanUSize n = ZYAN_STRLEN(s2);
    while (*s1)
    {
        if (!ZYAN_MEMCMP(s1++, s2, n))
        {
            return (char*)(s1 - 1);
        }
    }
    return 0;
}

ZYAN_INLINE char* ZYAN_STRTOK(char* str, const char* delim)
{
    static char* p = 0;
    if (str)
    {
        p = str;
    } else
    if (!p)
    {
        return 0;
    }
    str = p + ZYAN_STRSPN(p, delim);
    p = str + ZYAN_STRCSPN(str, delim);
    if (p == str)
    {
        return p = 0;
    }
    p = *p ? *p = 0, p + 1 : 0;
    return str;
}

ZYAN_INLINE ZyanUSize ZYAN_STRXFRM(char* dest, const char* src, ZyanUSize n)
{
    const ZyanUSize n2 = ZYAN_STRLEN(src);
    if (n > n2)
    {
        ZYAN_STRCPY(dest, src);
    }
    return n2;
}

/* ---------------------------------------------------------------------------------------------- */

#endif

#endif

/* ============================================================================================== */

#endif /* ZYCORE_LIBC_H */

//
// Header: Zydis/Internal/DecoderData.h
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

#ifndef ZYDIS_INTERNAL_DECODERDATA_H
#define ZYDIS_INTERNAL_DECODERDATA_H


#ifdef __cplusplus
extern "C" {
#endif

/* ============================================================================================== */
/* Enums and types                                                                                */
/* ============================================================================================== */

// MSVC does not like types other than (un-)signed int for bit-fields
#ifdef ZYAN_MSVC
#   pragma warning(push)
#   pragma warning(disable:4214)
#endif

#pragma pack(push, 1)

/* ---------------------------------------------------------------------------------------------- */
/* Decoder tree                                                                                   */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisDecoderTreeNodeType` data-type.
 */
typedef ZyanU8 ZydisDecoderTreeNodeType;

/**
 * Values that represent zydis decoder tree node types.
 */
enum ZydisDecoderTreeNodeTypes
{
    ZYDIS_NODETYPE_INVALID                  = 0x00,
    /**
     * Reference to an instruction-definition.
     */
    ZYDIS_NODETYPE_DEFINITION_MASK          = 0x80,
    /**
     * Reference to an XOP-map filter.
     */
    ZYDIS_NODETYPE_FILTER_XOP               = 0x01,
    /**
     * Reference to an VEX-map filter.
     */
    ZYDIS_NODETYPE_FILTER_VEX               = 0x02,
    /**
     * Reference to an EVEX/MVEX-map filter.
     */
    ZYDIS_NODETYPE_FILTER_EMVEX             = 0x03,
    /**
     * Reference to an opcode filter.
     */
    ZYDIS_NODETYPE_FILTER_OPCODE            = 0x04,
    /**
     * Reference to an instruction-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE              = 0x05,
    /**
     * Reference to an compacted instruction-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_COMPACT      = 0x06,
    /**
     * Reference to a ModRM.mod filter.
     */
    ZYDIS_NODETYPE_FILTER_MODRM_MOD         = 0x07,
    /**
     * Reference to a compacted ModRM.mod filter.
     */
    ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT = 0x08,
    /**
     * Reference to a ModRM.reg filter.
     */
    ZYDIS_NODETYPE_FILTER_MODRM_REG         = 0x09,
    /**
     * Reference to a ModRM.rm filter.
     */
    ZYDIS_NODETYPE_FILTER_MODRM_RM          = 0x0A,
    /**
     * Reference to a PrefixGroup1 filter.
     */
    ZYDIS_NODETYPE_FILTER_PREFIX_GROUP1     = 0x0B,
    /**
     * Reference to a mandatory-prefix filter.
     */
    ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX  = 0x0C,
    /**
     * Reference to an operand-size filter.
     */
    ZYDIS_NODETYPE_FILTER_OPERAND_SIZE      = 0x0D,
    /**
     * Reference to an address-size filter.
     */
    ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE      = 0x0E,
    /**
     * Reference to a vector-length filter.
     */
    ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH     = 0x0F,
    /**
     * Reference to an REX/VEX/EVEX.W filter.
     */
    ZYDIS_NODETYPE_FILTER_REX_W             = 0x10,
    /**
     * Reference to an REX/VEX/EVEX.B filter.
     */
    ZYDIS_NODETYPE_FILTER_REX_B             = 0x11,
    /**
     * Reference to an EVEX.b filter.
     */
    ZYDIS_NODETYPE_FILTER_EVEX_B            = 0x12,
    /**
     * Reference to an MVEX.E filter.
     */
    ZYDIS_NODETYPE_FILTER_MVEX_E            = 0x13,
    /**
     * Reference to a AMD-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_AMD          = 0x14,
    /**
     * Reference to a KNC-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_KNC          = 0x15,
    /**
     * Reference to a MPX-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_MPX          = 0x16,
    /**
     * Reference to a CET-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_CET          = 0x17,
    /**
     * Reference to a LZCNT-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_LZCNT        = 0x18,
    /**
     * Reference to a TZCNT-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_TZCNT        = 0x19,
    /**
     * Reference to a WBNOINVD-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_WBNOINVD     = 0x1A,
    /**
     * Reference to a CLDEMOTE-mode filter.
     */
    ZYDIS_NODETYPE_FILTER_MODE_CLDEMOTE     = 0x1B
};

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisDecoderTreeNodeValue` data-type.
 */
typedef ZyanU16 ZydisDecoderTreeNodeValue;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisDecoderTreeNode` struct.
 */
typedef struct ZydisDecoderTreeNode_
{
    ZydisDecoderTreeNodeType type;
    ZydisDecoderTreeNodeValue value;
} ZydisDecoderTreeNode;

/* ---------------------------------------------------------------------------------------------- */

#pragma pack(pop)

#ifdef ZYAN_MSVC
#   pragma warning(pop)
#endif

/* ---------------------------------------------------------------------------------------------- */
/* Physical instruction encoding info                                                             */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisInstructionEncodingFlags` data-type.
 */
typedef ZyanU8 ZydisInstructionEncodingFlags;

/**
 * The instruction has an optional modrm byte.
 */
#define ZYDIS_INSTR_ENC_FLAG_HAS_MODRM      0x01

/**
 * The instruction has an optional displacement value.
 */
#define ZYDIS_INSTR_ENC_FLAG_HAS_DISP       0x02

/**
 * The instruction has an optional immediate value.
 */
#define ZYDIS_INSTR_ENC_FLAG_HAS_IMM0       0x04

/**
 * The instruction has a second optional immediate value.
 */
#define ZYDIS_INSTR_ENC_FLAG_HAS_IMM1       0x08

/**
 * The instruction ignores the value of `modrm.mod` and always assumes `modrm.mod == 3`
 *          ("reg, reg" - form).
 *
 *          Instructions with this flag can't have a SIB byte or a displacement value.
 */
#define ZYDIS_INSTR_ENC_FLAG_FORCE_REG_FORM 0x10

/**
 * Defines the `ZydisInstructionEncodingInfo` struct.
 */
typedef struct ZydisInstructionEncodingInfo_
{
    /**
     * Contains flags with information about the physical instruction-encoding.
     */
    ZydisInstructionEncodingFlags flags;
    /**
     * Displacement info.
     */
    struct
    {
        /**
         * The size of the displacement value.
         */
        ZyanU8 size[3];
    } disp;
    /**
     * Immediate info.
     */
    struct
    {
        /**
         * The size of the immediate value.
         */
        ZyanU8 size[3];
        /**
         * Signals, if the value is signed.
         */
        ZyanBool is_signed;
        /**
         * Signals, if the value is a relative offset.
         */
        ZyanBool is_relative;
    } imm[2];
} ZydisInstructionEncodingInfo;

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Functions                                                                                      */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Decoder tree                                                                                   */
/* ---------------------------------------------------------------------------------------------- */

extern const ZydisDecoderTreeNode zydis_decoder_tree_root;

/**
 * Returns the root node of the instruction tree.
 *
 * @return  The root node of the instruction tree.
 */
ZYAN_INLINE const ZydisDecoderTreeNode* ZydisDecoderTreeGetRootNode(void)
{
    return &zydis_decoder_tree_root;
}

/**
 * Returns the child node of `parent` specified by `index`.
 *
 * @param   parent  The parent node.
 * @param   index   The index of the child node to retrieve.
 *
 * @return  The specified child node.
 */
ZYDIS_NO_EXPORT const ZydisDecoderTreeNode* ZydisDecoderTreeGetChildNode(
    const ZydisDecoderTreeNode* parent, ZyanU16 index);

/**
 * Returns information about optional instruction parts (like modrm, displacement or
 * immediates) for the instruction that is linked to the given `node`.
 *
 * @param   node    The instruction definition node.
 * @param   info    A pointer to the `ZydisInstructionParts` struct.
 */
ZYDIS_NO_EXPORT void ZydisGetInstructionEncodingInfo(const ZydisDecoderTreeNode* node,
    const ZydisInstructionEncodingInfo** info);

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

#ifdef __cplusplus
}
#endif

#endif /* ZYDIS_INTERNAL_DECODERDATA_H */

//
// Header: Zydis/Internal/SharedData.h
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/

#ifndef ZYDIS_INTERNAL_SHAREDDATA_H
#define ZYDIS_INTERNAL_SHAREDDATA_H


#ifdef __cplusplus
extern "C" {
#endif

/* ============================================================================================== */
/* Enums and types                                                                                */
/* ============================================================================================== */

// MSVC does not like types other than (un-)signed int for bit-fields
#ifdef ZYAN_MSVC
#   pragma warning(push)
#   pragma warning(disable:4214)
#endif

#pragma pack(push, 1)

/* ---------------------------------------------------------------------------------------------- */
/* Operand definition                                                                             */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisSemanticOperandType` enum.
 */
typedef enum ZydisSemanticOperandType_
{
    ZYDIS_SEMANTIC_OPTYPE_UNUSED,
    ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_REG,
    ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_MEM,
    ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_IMM1,
    ZYDIS_SEMANTIC_OPTYPE_GPR8,
    ZYDIS_SEMANTIC_OPTYPE_GPR16,
    ZYDIS_SEMANTIC_OPTYPE_GPR32,
    ZYDIS_SEMANTIC_OPTYPE_GPR64,
    ZYDIS_SEMANTIC_OPTYPE_GPR16_32_64,
    ZYDIS_SEMANTIC_OPTYPE_GPR32_32_64,
    ZYDIS_SEMANTIC_OPTYPE_GPR16_32_32,
    ZYDIS_SEMANTIC_OPTYPE_GPR_ASZ,
    ZYDIS_SEMANTIC_OPTYPE_FPR,
    ZYDIS_SEMANTIC_OPTYPE_MMX,
    ZYDIS_SEMANTIC_OPTYPE_XMM,
    ZYDIS_SEMANTIC_OPTYPE_YMM,
    ZYDIS_SEMANTIC_OPTYPE_ZMM,
    ZYDIS_SEMANTIC_OPTYPE_TMM,
    ZYDIS_SEMANTIC_OPTYPE_BND,
    ZYDIS_SEMANTIC_OPTYPE_SREG,
    ZYDIS_SEMANTIC_OPTYPE_CR,
    ZYDIS_SEMANTIC_OPTYPE_DR,
    ZYDIS_SEMANTIC_OPTYPE_MASK,
    ZYDIS_SEMANTIC_OPTYPE_MEM,
    ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBX,
    ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBY,
    ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBZ,
    ZYDIS_SEMANTIC_OPTYPE_IMM,
    ZYDIS_SEMANTIC_OPTYPE_REL,
    ZYDIS_SEMANTIC_OPTYPE_PTR,
    ZYDIS_SEMANTIC_OPTYPE_AGEN,
    ZYDIS_SEMANTIC_OPTYPE_MOFFS,
    ZYDIS_SEMANTIC_OPTYPE_MIB,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_SEMANTIC_OPTYPE_MAX_VALUE = ZYDIS_SEMANTIC_OPTYPE_MIB,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_SEMANTIC_OPTYPE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_SEMANTIC_OPTYPE_MAX_VALUE)
} ZydisSemanticOperandType;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisInternalElementType` enum.
 */
typedef enum ZydisInternalElementType_
{
    ZYDIS_IELEMENT_TYPE_INVALID,
    ZYDIS_IELEMENT_TYPE_VARIABLE,
    ZYDIS_IELEMENT_TYPE_STRUCT,
    ZYDIS_IELEMENT_TYPE_INT,
    ZYDIS_IELEMENT_TYPE_UINT,
    ZYDIS_IELEMENT_TYPE_INT1,
    ZYDIS_IELEMENT_TYPE_INT8,
    ZYDIS_IELEMENT_TYPE_INT16,
    ZYDIS_IELEMENT_TYPE_INT32,
    ZYDIS_IELEMENT_TYPE_INT64,
    ZYDIS_IELEMENT_TYPE_UINT8,
    ZYDIS_IELEMENT_TYPE_UINT16,
    ZYDIS_IELEMENT_TYPE_UINT32,
    ZYDIS_IELEMENT_TYPE_UINT64,
    ZYDIS_IELEMENT_TYPE_UINT128,
    ZYDIS_IELEMENT_TYPE_UINT256,
    ZYDIS_IELEMENT_TYPE_FLOAT16,
    ZYDIS_IELEMENT_TYPE_FLOAT16X2,
    ZYDIS_IELEMENT_TYPE_FLOAT32,
    ZYDIS_IELEMENT_TYPE_FLOAT64,
    ZYDIS_IELEMENT_TYPE_FLOAT80,
    ZYDIS_IELEMENT_TYPE_BCD80,
    ZYDIS_IELEMENT_TYPE_CC3,
    ZYDIS_IELEMENT_TYPE_CC5,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_IELEMENT_TYPE_MAX_VALUE = ZYDIS_IELEMENT_TYPE_CC5,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_IELEMENT_TYPE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_IELEMENT_TYPE_MAX_VALUE)
} ZydisInternalElementType;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisImplicitRegisterType` enum.
 */
typedef enum ZydisImplicitRegisterType_
{
    // TODO: Rename OSZ|ASZ|SSZ_
    ZYDIS_IMPLREG_TYPE_STATIC,
    ZYDIS_IMPLREG_TYPE_GPR_OSZ,
    ZYDIS_IMPLREG_TYPE_GPR_ASZ,
    ZYDIS_IMPLREG_TYPE_IP_ASZ,
    ZYDIS_IMPLREG_TYPE_IP_SSZ,
    ZYDIS_IMPLREG_TYPE_GPR_SSZ,
    ZYDIS_IMPLREG_TYPE_FLAGS_SSZ,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_IMPLREG_TYPE_MAX_VALUE = ZYDIS_IMPLREG_TYPE_FLAGS_SSZ,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_IMPLREG_TYPE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_IMPLREG_TYPE_MAX_VALUE)
} ZydisImplicitRegisterType;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisImplicitMemBase` enum.
 */
typedef enum ZydisImplicitMemBase_
{
    // TODO: Rename OSZ|ASZ|SSZ_
    ZYDIS_IMPLMEM_BASE_AGPR_REG,
    ZYDIS_IMPLMEM_BASE_AGPR_RM,
    ZYDIS_IMPLMEM_BASE_AAX,
    ZYDIS_IMPLMEM_BASE_ADX,
    ZYDIS_IMPLMEM_BASE_ABX,
    ZYDIS_IMPLMEM_BASE_ASI,
    ZYDIS_IMPLMEM_BASE_ADI,
    ZYDIS_IMPLMEM_BASE_SSP,
    ZYDIS_IMPLMEM_BASE_SBP,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_IMPLMEM_BASE_MAX_VALUE = ZYDIS_IMPLMEM_BASE_SBP,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_IMPLMEM_BASE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_IMPLMEM_BASE_MAX_VALUE)
} ZydisImplicitMemBase;

/* ---------------------------------------------------------------------------------------------- */

// MSVC does not correctly execute the `pragma pack(1)` compiler-directive, if we use the correct
// enum types
ZYAN_STATIC_ASSERT(ZYDIS_SEMANTIC_OPTYPE_REQUIRED_BITS     <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_OPERAND_VISIBILITY_REQUIRED_BITS  <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_OPERAND_ACTION_REQUIRED_BITS      <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_IELEMENT_TYPE_REQUIRED_BITS       <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_OPERAND_ENCODING_REQUIRED_BITS    <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_IMPLREG_TYPE_REQUIRED_BITS        <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_REGISTER_REQUIRED_BITS            <= 16);
ZYAN_STATIC_ASSERT(ZYDIS_IMPLMEM_BASE_REQUIRED_BITS        <=  8);

/**
 * Defines the `ZydisOperandDefinition` struct.
 */
typedef struct ZydisOperandDefinition_
{
    ZyanU8 type                            ZYAN_BITFIELD(ZYDIS_SEMANTIC_OPTYPE_REQUIRED_BITS);
    ZyanU8 visibility                      ZYAN_BITFIELD(ZYDIS_OPERAND_VISIBILITY_REQUIRED_BITS);
    ZyanU8 actions                         ZYAN_BITFIELD(ZYDIS_OPERAND_ACTION_REQUIRED_BITS);
    ZyanU16 size[3];
    ZyanU8 element_type                    ZYAN_BITFIELD(ZYDIS_IELEMENT_TYPE_REQUIRED_BITS);
    union
    {
        ZyanU8 encoding                    ZYAN_BITFIELD(ZYDIS_OPERAND_ENCODING_REQUIRED_BITS);
        struct
        {
            ZyanU8 type                    ZYAN_BITFIELD(ZYDIS_IMPLREG_TYPE_REQUIRED_BITS);
            union
            {
                ZyanU16 reg                ZYAN_BITFIELD(ZYDIS_REGISTER_REQUIRED_BITS);
                ZyanU8 id                  ZYAN_BITFIELD(6);
            } reg;
        } reg;
        struct
        {
            ZyanU8 seg                     ZYAN_BITFIELD(3);
            ZyanU8 base                    ZYAN_BITFIELD(ZYDIS_IMPLMEM_BASE_REQUIRED_BITS);
        } mem;
    } op;
    ZyanBool is_multisource4               ZYAN_BITFIELD(1);
    ZyanBool ignore_seg_override           ZYAN_BITFIELD(1);
} ZydisOperandDefinition;

/* ---------------------------------------------------------------------------------------------- */
/* Instruction definition                                                                         */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisReadWriteAction` enum.
 */
typedef enum ZydisReadWriteAction_
{
    ZYDIS_RW_ACTION_NONE,
    ZYDIS_RW_ACTION_READ,
    ZYDIS_RW_ACTION_WRITE,
    ZYDIS_RW_ACTION_READWRITE,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_RW_ACTION_MAX_VALUE = ZYDIS_RW_ACTION_READWRITE,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_RW_ACTION_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_RW_ACTION_MAX_VALUE)
} ZydisReadWriteAction;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisInternalVectorLength` enum.
 */
typedef enum ZydisInternalVectorLength_
{
    ZYDIS_IVECTOR_LENGTH_DEFAULT,
    ZYDIS_IVECTOR_LENGTH_FIXED_128,
    ZYDIS_IVECTOR_LENGTH_FIXED_256,
    ZYDIS_IVECTOR_LENGTH_FIXED_512,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_IVECTOR_LENGTH_MAX_VALUE = ZYDIS_IVECTOR_LENGTH_FIXED_512,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_IVECTOR_LENGTH_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_IVECTOR_LENGTH_MAX_VALUE)
} ZydisInternalVectorLength;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisInternalElementSize` enum.
 */
typedef enum ZydisInternalElementSize_
{
    ZYDIS_IELEMENT_SIZE_INVALID,
    ZYDIS_IELEMENT_SIZE_8,
    ZYDIS_IELEMENT_SIZE_16,
    ZYDIS_IELEMENT_SIZE_32,
    ZYDIS_IELEMENT_SIZE_64,
    ZYDIS_IELEMENT_SIZE_128,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_IELEMENT_SIZE_MAX_VALUE = ZYDIS_IELEMENT_SIZE_128,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_IELEMENT_SIZE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_IELEMENT_SIZE_MAX_VALUE)
} ZydisInternalElementSize;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisEVEXFunctionality` enum.
 */
typedef enum ZydisEVEXFunctionality_
{
    ZYDIS_EVEX_FUNC_INVALID,
    /**
     * `EVEX.b` enables broadcast functionality.
     */
    ZYDIS_EVEX_FUNC_BC,
    /**
     * `EVEX.b` enables embedded-rounding functionality.
     */
    ZYDIS_EVEX_FUNC_RC,
    /**
     * `EVEX.b` enables sae functionality.
     */
    ZYDIS_EVEX_FUNC_SAE,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_EVEX_FUNC_MAX_VALUE = ZYDIS_EVEX_FUNC_SAE,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_EVEX_FUNC_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_EVEX_FUNC_MAX_VALUE)
} ZydisEVEXFunctionality;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisEVEXTupleType` enum.
 */
typedef enum ZydisEVEXTupleType_
{
    ZYDIS_TUPLETYPE_INVALID,
    /**
     * Full Vector
     */
    ZYDIS_TUPLETYPE_FV,
    /**
     * Half Vector
     */
    ZYDIS_TUPLETYPE_HV,
    /**
     * Full Vector Mem
     */
    ZYDIS_TUPLETYPE_FVM,
    /**
     * Tuple1 Scalar
     */
    ZYDIS_TUPLETYPE_T1S,
    /**
     * Tuple1 Fixed
     */
    ZYDIS_TUPLETYPE_T1F,
    /**
     * Tuple1 4x32
     */
    ZYDIS_TUPLETYPE_T1_4X,
    /**
     * Gather / Scatter
     */
    ZYDIS_TUPLETYPE_GSCAT,
    /**
     * Tuple2
     */
    ZYDIS_TUPLETYPE_T2,
    /**
     * Tuple4
     */
    ZYDIS_TUPLETYPE_T4,
    /**
     * Tuple8
     */
    ZYDIS_TUPLETYPE_T8,
    /**
     * Half Mem
     */
    ZYDIS_TUPLETYPE_HVM,
    /**
     * QuarterMem
     */
    ZYDIS_TUPLETYPE_QVM,
    /**
     * OctMem
     */
    ZYDIS_TUPLETYPE_OVM,
    /**
     * Mem128
     */
    ZYDIS_TUPLETYPE_M128,
    /**
     * MOVDDUP
     */
    ZYDIS_TUPLETYPE_DUP,
    /**
     * Quarter of the vector-length.
     */
    ZYDIS_TUPLETYPE_QUARTER,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_TUPLETYPE_MAX_VALUE = ZYDIS_TUPLETYPE_QUARTER,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_TUPLETYPE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_TUPLETYPE_MAX_VALUE)
} ZydisEVEXTupleType;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisMVEXFunctionality` enum.
 */
typedef enum ZydisMVEXFunctionality_
{
    /**
     * The `MVEX.SSS` value is ignored.
     */
    ZYDIS_MVEX_FUNC_IGNORED,
    /**
     * `MVEX.SSS` must be `000b`.
     */
    ZYDIS_MVEX_FUNC_INVALID,
    /**
     * `MVEX.SSS` controls embedded-rounding functionality.
     */
    ZYDIS_MVEX_FUNC_RC,
    /**
     * `MVEX.SSS` controls sae functionality.
     */
    ZYDIS_MVEX_FUNC_SAE,
    /**
     * No special operation (32bit float elements).
     */
    ZYDIS_MVEX_FUNC_F_32,
    /**
     * No special operation (32bit uint elements).
     */
    ZYDIS_MVEX_FUNC_I_32,
    /**
     * No special operation (64bit float elements).
     */
    ZYDIS_MVEX_FUNC_F_64,
    /**
     * No special operation (64bit uint elements).
     */
    ZYDIS_MVEX_FUNC_I_64,
    /**
     * Sf32(reg) or Si32(reg).
     */
    ZYDIS_MVEX_FUNC_SWIZZLE_32,
    /**
     * Sf64(reg) or Si64(reg).
     */
    ZYDIS_MVEX_FUNC_SWIZZLE_64,
    /**
     * Sf32(mem).
     */
    ZYDIS_MVEX_FUNC_SF_32,
    /**
     * Sf32(mem) broadcast only.
     */
    ZYDIS_MVEX_FUNC_SF_32_BCST,
    /**
     * Sf32(mem) broadcast 4to16 only.
     */
    ZYDIS_MVEX_FUNC_SF_32_BCST_4TO16,
    /**
     * Sf64(mem).
     */
    ZYDIS_MVEX_FUNC_SF_64,
    /**
     * Si32(mem).
     */
    ZYDIS_MVEX_FUNC_SI_32,
    /**
     * Si32(mem) broadcast only.
     */
    ZYDIS_MVEX_FUNC_SI_32_BCST,
    /**
     * Si32(mem) broadcast 4to16 only.
     */
    ZYDIS_MVEX_FUNC_SI_32_BCST_4TO16,
    /**
     * Si64(mem).
     */
    ZYDIS_MVEX_FUNC_SI_64,
    /**
     * Uf32.
     */
    ZYDIS_MVEX_FUNC_UF_32,
    /**
     * Uf64.
     */
    ZYDIS_MVEX_FUNC_UF_64,
    /**
     * Ui32.
     */
    ZYDIS_MVEX_FUNC_UI_32,
    /**
     * Ui64.
     */
    ZYDIS_MVEX_FUNC_UI_64,
    /**
     * Df32.
     */
    ZYDIS_MVEX_FUNC_DF_32,
    /**
     * Df64.
     */
    ZYDIS_MVEX_FUNC_DF_64,
    /**
     * Di32.
     */
    ZYDIS_MVEX_FUNC_DI_32,
    /**
     * Di64.
     */
    ZYDIS_MVEX_FUNC_DI_64,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_MVEX_FUNC_MAX_VALUE = ZYDIS_MVEX_FUNC_DI_64,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_MVEX_FUNC_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_MVEX_FUNC_MAX_VALUE)
} ZydisMVEXFunctionality;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisVEXStaticBroadcast` enum.
 */
typedef enum ZydisVEXStaticBroadcast
{
    ZYDIS_VEX_STATIC_BROADCAST_NONE,
    ZYDIS_VEX_STATIC_BROADCAST_1_TO_2,
    ZYDIS_VEX_STATIC_BROADCAST_1_TO_4,
    ZYDIS_VEX_STATIC_BROADCAST_1_TO_8,
    ZYDIS_VEX_STATIC_BROADCAST_1_TO_16,
    ZYDIS_VEX_STATIC_BROADCAST_1_TO_32,
    ZYDIS_VEX_STATIC_BROADCAST_2_TO_4,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_VEX_STATIC_BROADCAST_MAX_VALUE = ZYDIS_VEX_STATIC_BROADCAST_2_TO_4,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_VEX_STATIC_BROADCAST_REQUIRED_BITS =
        ZYAN_BITS_TO_REPRESENT(ZYDIS_VEX_STATIC_BROADCAST_MAX_VALUE)
} ZydisVEXStaticBroadcast;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisEVEXStaticBroadcast` enum.
 */
typedef enum ZydisEVEXStaticBroadcast_
{
    ZYDIS_EVEX_STATIC_BROADCAST_NONE,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_2,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_4,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_8,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_16,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_32,
    ZYDIS_EVEX_STATIC_BROADCAST_1_TO_64,
    ZYDIS_EVEX_STATIC_BROADCAST_2_TO_4,
    ZYDIS_EVEX_STATIC_BROADCAST_2_TO_8,
    ZYDIS_EVEX_STATIC_BROADCAST_2_TO_16,
    ZYDIS_EVEX_STATIC_BROADCAST_4_TO_8,
    ZYDIS_EVEX_STATIC_BROADCAST_4_TO_16,
    ZYDIS_EVEX_STATIC_BROADCAST_8_TO_16,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_EVEX_STATIC_BROADCAST_MAX_VALUE = ZYDIS_EVEX_STATIC_BROADCAST_8_TO_16,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_EVEX_STATIC_BROADCAST_REQUIRED_BITS =
        ZYAN_BITS_TO_REPRESENT(ZYDIS_EVEX_STATIC_BROADCAST_MAX_VALUE)
} ZydisEVEXStaticBroadcast;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisMVEXStaticBroadcast` enum.
 */
typedef enum ZydisMVEXStaticBroadcast_
{
    ZYDIS_MVEX_STATIC_BROADCAST_NONE,
    ZYDIS_MVEX_STATIC_BROADCAST_1_TO_8,
    ZYDIS_MVEX_STATIC_BROADCAST_1_TO_16,
    ZYDIS_MVEX_STATIC_BROADCAST_4_TO_8,
    ZYDIS_MVEX_STATIC_BROADCAST_4_TO_16,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_MVEX_STATIC_BROADCAST_MAX_VALUE = ZYDIS_MVEX_STATIC_BROADCAST_4_TO_16,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_MVEX_STATIC_BROADCAST_REQUIRED_BITS =
        ZYAN_BITS_TO_REPRESENT(ZYDIS_MVEX_STATIC_BROADCAST_MAX_VALUE)
} ZydisMVEXStaticBroadcast;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisMaskPolicy` enum.
 */
typedef enum ZydisMaskPolicy_
{
    ZYDIS_MASK_POLICY_INVALID,
    /**
     * The instruction accepts mask-registers other than the default-mask (K0), but
     *          does not require them.
     */
    ZYDIS_MASK_POLICY_ALLOWED,
    /**
     * The instruction requires a mask-register other than the default-mask (K0).
     */
    ZYDIS_MASK_POLICY_REQUIRED,
    /**
     * The instruction does not allow a mask-register other than the default-mask (K0).
     */
    ZYDIS_MASK_POLICY_FORBIDDEN,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_MASK_POLICY_MAX_VALUE = ZYDIS_MASK_POLICY_FORBIDDEN,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_MASK_POLICY_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_MASK_POLICY_MAX_VALUE)
} ZydisMaskPolicy;

/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisMaskOverride` enum.
 */
typedef enum ZydisMaskOverride_
{
    ZYDIS_MASK_OVERRIDE_DEFAULT,
    ZYDIS_MASK_OVERRIDE_ZEROING,
    ZYDIS_MASK_OVERRIDE_CONTROL,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_MASK_OVERRIDE_MAX_VALUE = ZYDIS_MASK_OVERRIDE_CONTROL,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_MASK_OVERRIDE_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_MASK_OVERRIDE_MAX_VALUE)
} ZydisMaskOverride;

/* ---------------------------------------------------------------------------------------------- */

#define ZYDIS_OPDEF_REQUIRED_BITS \
    ZYAN_MAX(ZYDIS_REGKIND_REQUIRED_BITS, ZYDIS_MEMOP_TYPE_REQUIRED_BITS + 1) + 1

#define ZYDIS_OPDEF_GET_REG(operand_definition) \
    ((operand_definition) & ((1 << ZYDIS_REGKIND_REQUIRED_BITS   ) - 1))

#define ZYDIS_OPDEF_GET_MEM(operand_definition) \
    ((operand_definition) & ((1 << ZYDIS_MEMOP_TYPE_REQUIRED_BITS) - 1))

#define ZYDIS_OPDEF_GET_REG_HIGH_BIT(operand_definition) \
    (((operand_definition) >> ZYDIS_REGKIND_REQUIRED_BITS   ) & 0x01)

#define ZYDIS_OPDEF_GET_MEM_HIGH_BIT(operand_definition) \
    (((operand_definition) >> ZYDIS_MEMOP_TYPE_REQUIRED_BITS) & 0x01)

// MSVC does not correctly execute the `pragma pack(1)` compiler-directive, if we use the correct
// enum types
ZYAN_STATIC_ASSERT(ZYDIS_MNEMONIC_REQUIRED_BITS        <= 16);
ZYAN_STATIC_ASSERT(ZYDIS_CATEGORY_REQUIRED_BITS        <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_ISA_SET_REQUIRED_BITS         <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_ISA_EXT_REQUIRED_BITS         <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_BRANCH_TYPE_REQUIRED_BITS     <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_EXCEPTION_CLASS_REQUIRED_BITS <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_OPDEF_REQUIRED_BITS           <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_RW_ACTION_REQUIRED_BITS       <=  8);

#ifndef ZYDIS_MINIMAL_MODE
#   define ZYDIS_INSTRUCTION_DEFINITION_BASE \
        ZyanU16 mnemonic                       ZYAN_BITFIELD(ZYDIS_MNEMONIC_REQUIRED_BITS); \
        ZyanU8 operand_count                   ZYAN_BITFIELD( 4); \
        ZyanU8 operand_count_visible           ZYAN_BITFIELD( 3); \
        ZyanU16 operand_reference              ZYAN_BITFIELD(15); \
        ZyanU8 operand_size_map                ZYAN_BITFIELD( 3); \
        ZyanU8 address_size_map                ZYAN_BITFIELD( 2); \
        ZyanU8 flags_reference                 ZYAN_BITFIELD( 7); \
        ZyanBool requires_protected_mode       ZYAN_BITFIELD( 1); \
        ZyanBool no_compat_mode                ZYAN_BITFIELD( 1); \
        ZyanU8 category                        ZYAN_BITFIELD(ZYDIS_CATEGORY_REQUIRED_BITS); \
        ZyanU8 isa_set                         ZYAN_BITFIELD(ZYDIS_ISA_SET_REQUIRED_BITS); \
        ZyanU8 isa_ext                         ZYAN_BITFIELD(ZYDIS_ISA_EXT_REQUIRED_BITS); \
        ZyanU8 branch_type                     ZYAN_BITFIELD(ZYDIS_BRANCH_TYPE_REQUIRED_BITS); \
        ZyanU8 exception_class                 ZYAN_BITFIELD(ZYDIS_EXCEPTION_CLASS_REQUIRED_BITS); \
        ZyanU8 op_reg                          ZYAN_BITFIELD(ZYDIS_OPDEF_REQUIRED_BITS); \
        ZyanU8 op_rm                           ZYAN_BITFIELD(ZYDIS_OPDEF_REQUIRED_BITS); \
        ZyanU8 cpu_state                       ZYAN_BITFIELD(ZYDIS_RW_ACTION_REQUIRED_BITS); \
        ZyanU8 fpu_state                       ZYAN_BITFIELD(ZYDIS_RW_ACTION_REQUIRED_BITS); \
        ZyanU8 xmm_state                       ZYAN_BITFIELD(ZYDIS_RW_ACTION_REQUIRED_BITS); \
        ZyanBool accepts_segment               ZYAN_BITFIELD( 1)
#else
#   define ZYDIS_INSTRUCTION_DEFINITION_BASE \
        ZyanU16 mnemonic                       ZYAN_BITFIELD(ZYDIS_MNEMONIC_REQUIRED_BITS); \
        ZyanU8 operand_size_map                ZYAN_BITFIELD( 3); \
        ZyanU8 address_size_map                ZYAN_BITFIELD( 2); \
        ZyanBool requires_protected_mode       ZYAN_BITFIELD( 1); \
        ZyanBool no_compat_mode                ZYAN_BITFIELD( 1); \
        ZyanU8 op_reg                          ZYAN_BITFIELD(ZYDIS_OPDEF_REQUIRED_BITS); \
        ZyanU8 op_rm                           ZYAN_BITFIELD(ZYDIS_OPDEF_REQUIRED_BITS)
#endif

#define ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR \
    ZYDIS_INSTRUCTION_DEFINITION_BASE; \
    ZyanU8 op_ndsndd                       ZYAN_BITFIELD(ZYDIS_OPDEF_REQUIRED_BITS)

#define ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR_INTEL \
    ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR; \
    ZyanBool is_gather                     ZYAN_BITFIELD( 1); \
    ZyanBool no_source_dest_match          ZYAN_BITFIELD( 1); \
    ZyanBool no_source_source_match        ZYAN_BITFIELD( 1)        // TODO: Could be moved to VEX

/**
 * Defines the `ZydisInstructionDefinition` struct.
 */
typedef struct ZydisInstructionDefinition_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE;
} ZydisInstructionDefinition;

/**
 * Defines the `ZydisInstructionDefinitionLEGACY` struct.
 */
typedef struct ZydisInstructionDefinitionLEGACY_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE;
#ifndef ZYDIS_MINIMAL_MODE
    ZyanBool is_privileged                 ZYAN_BITFIELD( 1);
#endif
    ZyanBool accepts_LOCK                  ZYAN_BITFIELD( 1);
#ifndef ZYDIS_MINIMAL_MODE
    ZyanBool accepts_REP                   ZYAN_BITFIELD( 1);
    ZyanBool accepts_REPEREPZ              ZYAN_BITFIELD( 1);
    ZyanBool accepts_REPNEREPNZ            ZYAN_BITFIELD( 1);
    ZyanBool accepts_BOUND                 ZYAN_BITFIELD( 1);
    ZyanBool accepts_XACQUIRE              ZYAN_BITFIELD( 1);
    ZyanBool accepts_XRELEASE              ZYAN_BITFIELD( 1);
    ZyanBool accepts_NOTRACK               ZYAN_BITFIELD( 1);
    ZyanBool accepts_hle_without_lock      ZYAN_BITFIELD( 1);
    ZyanBool accepts_branch_hints          ZYAN_BITFIELD( 1);
#endif
} ZydisInstructionDefinitionLEGACY;

/**
 * Defines the `ZydisInstructionDefinition3DNOW` struct.
 */
typedef struct ZydisInstructionDefinition3DNOW_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE;
} ZydisInstructionDefinition3DNOW;

/**
 * Defines the `ZydisInstructionDefinitionXOP` struct.
 */
typedef struct ZydisInstructionDefinitionXOP_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR;
} ZydisInstructionDefinitionXOP;

// MSVC does not correctly execute the `pragma pack(1)` compiler-directive, if we use the correct
// enum types
ZYAN_STATIC_ASSERT(ZYDIS_VEX_STATIC_BROADCAST_REQUIRED_BITS  <=  8);

/**
 * Defines the `ZydisInstructionDefinitionVEX` struct.
 */
typedef struct ZydisInstructionDefinitionVEX_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR_INTEL;
#ifndef ZYDIS_MINIMAL_MODE
    ZyanU8 broadcast                       ZYAN_BITFIELD(ZYDIS_VEX_STATIC_BROADCAST_REQUIRED_BITS);
#endif
} ZydisInstructionDefinitionVEX;

#ifndef ZYDIS_DISABLE_AVX512

// MSVC does not correctly execute the `pragma pack(1)` compiler-directive, if we use the correct
// enum types
ZYAN_STATIC_ASSERT(ZYDIS_IVECTOR_LENGTH_REQUIRED_BITS        <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_TUPLETYPE_REQUIRED_BITS             <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_IELEMENT_SIZE_REQUIRED_BITS         <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_EVEX_FUNC_REQUIRED_BITS             <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_MASK_POLICY_REQUIRED_BITS           <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_MASK_OVERRIDE_REQUIRED_BITS         <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_EVEX_STATIC_BROADCAST_REQUIRED_BITS <=  8);

/**
 * Defines the `ZydisInstructionDefinitionEVEX` struct.
 */
typedef struct ZydisInstructionDefinitionEVEX_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR_INTEL;
#ifndef ZYDIS_MINIMAL_MODE
    ZyanU8 vector_length                   ZYAN_BITFIELD(ZYDIS_IVECTOR_LENGTH_REQUIRED_BITS);
    ZyanU8 tuple_type                      ZYAN_BITFIELD(ZYDIS_TUPLETYPE_REQUIRED_BITS);
    ZyanU8 element_size                    ZYAN_BITFIELD(ZYDIS_IELEMENT_SIZE_REQUIRED_BITS);
    ZyanU8 functionality                   ZYAN_BITFIELD(ZYDIS_EVEX_FUNC_REQUIRED_BITS);
#endif
    ZyanU8 mask_policy                     ZYAN_BITFIELD(ZYDIS_MASK_POLICY_REQUIRED_BITS);
    ZyanBool accepts_zero_mask             ZYAN_BITFIELD( 1);
#ifndef ZYDIS_MINIMAL_MODE
    ZyanU8 mask_override                   ZYAN_BITFIELD(ZYDIS_MASK_OVERRIDE_REQUIRED_BITS);
    ZyanU8 broadcast                       ZYAN_BITFIELD(ZYDIS_EVEX_STATIC_BROADCAST_REQUIRED_BITS);
#endif
} ZydisInstructionDefinitionEVEX;
#endif

#ifndef ZYDIS_DISABLE_KNC

// MSVC does not correctly execute the `pragma pack(1)` compiler-directive, if we use the correct
// enum types
ZYAN_STATIC_ASSERT(ZYDIS_MVEX_FUNC_REQUIRED_BITS             <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_MASK_POLICY_REQUIRED_BITS           <=  8);
ZYAN_STATIC_ASSERT(ZYDIS_MVEX_STATIC_BROADCAST_REQUIRED_BITS <=  8);

/**
 * Defines the `ZydisInstructionDefinitionMVEX` struct.
 */
typedef struct ZydisInstructionDefinitionMVEX_
{
    ZYDIS_INSTRUCTION_DEFINITION_BASE_VECTOR_INTEL;
    ZyanU8 functionality                   ZYAN_BITFIELD(ZYDIS_MVEX_FUNC_REQUIRED_BITS);
    ZyanU8 mask_policy                     ZYAN_BITFIELD(ZYDIS_MASK_POLICY_REQUIRED_BITS);
#ifndef ZYDIS_MINIMAL_MODE
    ZyanBool has_element_granularity       ZYAN_BITFIELD( 1);
    ZyanU8 broadcast                       ZYAN_BITFIELD(ZYDIS_MVEX_STATIC_BROADCAST_REQUIRED_BITS);
#endif
} ZydisInstructionDefinitionMVEX;
#endif

/* ---------------------------------------------------------------------------------------------- */

#pragma pack(pop)

#ifdef ZYAN_MSVC
#   pragma warning(pop)
#endif

/* ---------------------------------------------------------------------------------------------- */
/* Accessed CPU/FPU flags                                                                         */
/* ---------------------------------------------------------------------------------------------- */

/*
 * Contains information about the CPU/FPU flags accessed by an instruction.
 *
 * We don't want this struct to be packed! A pointer to the individual members will be used by the
 * `ZydisDecodedInstruction` struct.
 */
typedef struct ZydisDefinitionAccessedFlags_
{
    ZydisAccessedFlags cpu_flags;
    ZydisAccessedFlags fpu_flags;
} ZydisDefinitionAccessedFlags;

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Functions                                                                                      */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Instruction definition                                                                         */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Returns the instruction-definition with the given `encoding` and `id`.
 *
 * @param   encoding    The instruction-encoding.
 * @param   id          The definition-id.
 * @param   definition  A pointer to the variable that receives a pointer to the instruction-
 *                      definition.
 */
ZYDIS_NO_EXPORT void ZydisGetInstructionDefinition(ZydisInstructionEncoding encoding,
    ZyanU16 id, const ZydisInstructionDefinition** definition);

/* ---------------------------------------------------------------------------------------------- */
/* Operand definition                                                                             */
/* ---------------------------------------------------------------------------------------------- */

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Returns the the operand-definitions for the given instruction-`definition`.
 *
 * @param   definition  A pointer to the instruction-definition.
 *
 * @return  A pointer to the first operand definition of the instruction, or `ZYAN_NULL`.
 */
ZYDIS_NO_EXPORT const ZydisOperandDefinition* ZydisGetOperandDefinitions(
    const ZydisInstructionDefinition* definition);
#endif

/* ---------------------------------------------------------------------------------------------- */
/* Element info                                                                                   */
/* ---------------------------------------------------------------------------------------------- */

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Returns the actual type and size of an internal element-type.
 *
 * @param   element The internal element type.
 * @param   type    The actual element type.
 * @param   size    The element size.
 */
ZYDIS_NO_EXPORT void ZydisGetElementInfo(ZydisInternalElementType element, ZydisElementType* type,
    ZydisElementSize* size);
#endif

/* ---------------------------------------------------------------------------------------------- */
/* Accessed CPU flags                                                                             */
/* ---------------------------------------------------------------------------------------------- */

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Returns the the operand-definitions for the given instruction-`definition`.
 *
 * @param   definition  A pointer to the instruction-definition.
 * @param   flags       A pointer to the variable that receives the `ZydisDefinitionAccessedFlags`
 *                      struct.
 *
 * @return  `ZYAN_TRUE`, if the instruction accesses any flags, or `ZYAN_FALSE`, if not.
 */
ZYDIS_NO_EXPORT ZyanBool ZydisGetAccessedFlags(const ZydisInstructionDefinition* definition,
    const ZydisDefinitionAccessedFlags** flags);
#endif

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */

#ifdef __cplusplus
}
#endif

#endif /* ZYDIS_INTERNAL_SHAREDDATA_H */

/* ============================================================================================== */
/* Internal enums and types                                                                       */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Decoder context                                                                                */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisDecoderState` struct.
 */
typedef struct ZydisDecoderState_
{
    /**
     * A pointer to the `ZydisDecoder` instance.
     */
    const ZydisDecoder* decoder;
    /**
     * A pointer to the `ZydisDecoderContext` struct.
     */
    ZydisDecoderContext* context;
    /**
     * The input buffer.
     */
    const ZyanU8* buffer;
    /**
     * The input buffer length.
     */
    ZyanUSize buffer_len;
    /**
     * Prefix information.
     */
    struct
    {
        /**
         * Signals, if the instruction has a `LOCK` prefix (`F0`).
         *
         * This prefix originally belongs to group 1, but separating it from the other ones makes
         * parsing easier for us later.
         */
        ZyanBool has_lock;
        /**
         * The effective prefix of group 1 (either `F2` or `F3`).
         */
        ZyanU8 group1;
        /**
         * The effective prefix of group 2 (`2E`, `36`, `3E`, `26`, `64` or `65`).
         */
        ZyanU8 group2;
        /**
         * The effective segment prefix.
         */
        ZyanU8 effective_segment;
        /**
         * The prefix that should be treated as the mandatory-prefix, if the
         * current instruction needs one.
         *
         * The last `F3`/`F2` prefix has precedence over previous ones and
         * `F3`/`F2` in general have precedence over `66`.
         */
        ZyanU8 mandatory_candidate;
        /**
         * The offset of the effective `LOCK` prefix.
         */
        ZyanU8 offset_lock;
        /**
         * The offset of the effective prefix in group 1.
         */
        ZyanU8 offset_group1;
        /**
         * The offset of the effective prefix in group 2.
         */
        ZyanU8 offset_group2;
        /**
         * The offset of the operand-size override prefix (`66`).
         *
         * This is the only prefix in group 3.
         */
        ZyanU8 offset_osz_override;
        /**
         * The offset of the address-size override prefix (`67`).
         *
         * This is the only prefix in group 4.
         */
        ZyanU8 offset_asz_override;
        /**
         * The offset of the effective segment prefix.
         */
        ZyanU8 offset_segment;
        /**
         * The offset of the mandatory-candidate prefix.
         */
        ZyanU8 offset_mandatory;
        /**
         * The offset of a possible `CET` `no-lock` prefix.
         */
        ZyanI8 offset_notrack;
    } prefixes;
} ZydisDecoderState;

/* ---------------------------------------------------------------------------------------------- */
/* Register encoding                                                                              */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Defines the `ZydisRegisterEncoding` enum.
 */
typedef enum ZydisRegisterEncoding_
{
    ZYDIS_REG_ENCODING_INVALID,
    /**
     * The register-id is encoded as part of the opcode (bits [3..0]).
     *
     * Possible extension by:
     * - `REX.B`
     */
    ZYDIS_REG_ENCODING_OPCODE,
    /**
     * The register-id is encoded in `modrm.reg`.
     *
     * Possible extension by:
     * - `.R`
     * - `.R'` (vector only, EVEX/MVEX)
     */
    ZYDIS_REG_ENCODING_REG,
    /**
     * The register-id is encoded in `.vvvv`.
     *
     * Possible extension by:
     * - `.v'` (vector only, EVEX/MVEX).
     */
    ZYDIS_REG_ENCODING_NDSNDD,
    /**
     * The register-id is encoded in `modrm.rm`.
     *
     * Possible extension by:
     * - `.B`
     * - `.X` (vector only, EVEX/MVEX)`
     */
    ZYDIS_REG_ENCODING_RM,
    /**
     * The register-id is encoded in `modrm.rm` or `sib.base` (if `SIB` is present).
     *
     * Possible extension by:
     * - `.B`
     */
    ZYDIS_REG_ENCODING_BASE,
    /**
     * The register-id is encoded in `sib.index`.
     *
     * Possible extension by:
     * - `.X`
     */
    ZYDIS_REG_ENCODING_INDEX,
    /**
     * The register-id is encoded in `sib.index`.
     *
     * Possible extension by:
     * - `.X`
     * - `.V'` (vector only, EVEX/MVEX)
     */
    ZYDIS_REG_ENCODING_VIDX,
    /**
     * The register-id is encoded in an additional 8-bit immediate value.
     *
     * Bits [7:4] in 64-bit mode with possible extension by bit [3] (vector only), bits [7:5] for
     * all other modes.
     */
    ZYDIS_REG_ENCODING_IS4,
    /**
     * The register-id is encoded in `EVEX.aaa/MVEX.kkk`.
     */
    ZYDIS_REG_ENCODING_MASK,

    /**
     * Maximum value of this enum.
     */
    ZYDIS_REG_ENCODING_MAX_VALUE = ZYDIS_REG_ENCODING_MASK,
    /**
     * The minimum number of bits required to represent all values of this enum.
     */
    ZYDIS_REG_ENCODING_REQUIRED_BITS = ZYAN_BITS_TO_REPRESENT(ZYDIS_REG_ENCODING_MAX_VALUE)
} ZydisRegisterEncoding;

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Internal functions                                                                             */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Input helper functions                                                                         */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Reads one byte from the current read-position of the input data-source.
 *
 * @param   state       A pointer to the `ZydisDecoderState` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   value       A pointer to the memory that receives the byte from the input data-source.
 *
 * @return  A zyan status code.
 *
 * This function may fail, if the `ZYDIS_MAX_INSTRUCTION_LENGTH` limit got exceeded, or no more
 * data is available.
 */
static ZyanStatus ZydisInputPeek(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU8* value)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(value);

    if (instruction->length >= ZYDIS_MAX_INSTRUCTION_LENGTH)
    {
        return ZYDIS_STATUS_INSTRUCTION_TOO_LONG;
    }

    if (state->buffer_len > 0)
    {
        *value = state->buffer[0];
        return ZYAN_STATUS_SUCCESS;
    }

    return ZYDIS_STATUS_NO_MORE_DATA;
}

/**
 * Increases the read-position of the input data-source by one byte.
 *
 * @param   state       A pointer to the `ZydisDecoderState` instance
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 *
 * This function is supposed to get called ONLY after a successful call of `ZydisInputPeek`.
 *
 * This function increases the `length` field of the `ZydisDecodedInstruction` struct by one.
 */
static void ZydisInputSkip(ZydisDecoderState* state, ZydisDecodedInstruction* instruction)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(instruction->length < ZYDIS_MAX_INSTRUCTION_LENGTH);

    ++instruction->length;
    ++state->buffer;
    --state->buffer_len;
}

/**
 * Reads one byte from the current read-position of the input data-source and increases
 *          the read-position by one byte afterwards.
 *
 * @param   state       A pointer to the `ZydisDecoderState` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   value       A pointer to the memory that receives the byte from the input data-source.
 *
 * @return  A zyan status code.
 *
 * This function acts like a subsequent call of `ZydisInputPeek` and `ZydisInputSkip`.
 */
static ZyanStatus ZydisInputNext(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU8* value)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(value);

    if (instruction->length >= ZYDIS_MAX_INSTRUCTION_LENGTH)
    {
        return ZYDIS_STATUS_INSTRUCTION_TOO_LONG;
    }

    if (state->buffer_len > 0)
    {
        *value = state->buffer++[0];
        ++instruction->length;
        --state->buffer_len;
        return ZYAN_STATUS_SUCCESS;
    }

    return ZYDIS_STATUS_NO_MORE_DATA;
}

/**
 * Reads a variable amount of bytes from the current read-position of the input
 *          data-source and increases the read-position by specified amount of bytes afterwards.
 *
 * @param   state           A pointer to the `ZydisDecoderState` struct.
 * @param   instruction     A pointer to the `ZydisDecodedInstruction` struct.
 * @param   value           A pointer to the memory that receives the byte from the input
 *                          data-source.
 * @param   number_of_bytes The number of bytes to read from the input data-source.
 *
 * @return  A zyan status code.
 *
 * This function acts like a subsequent call of `ZydisInputPeek` and `ZydisInputSkip`.
 */
static ZyanStatus ZydisInputNextBytes(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU8* value, ZyanU8 number_of_bytes)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(value);

    if (instruction->length + number_of_bytes > ZYDIS_MAX_INSTRUCTION_LENGTH)
    {
        return ZYDIS_STATUS_INSTRUCTION_TOO_LONG;
    }

    if (state->buffer_len >= number_of_bytes)
    {
        instruction->length += number_of_bytes;

        ZYAN_MEMCPY(value, state->buffer, number_of_bytes);
        state->buffer += number_of_bytes;
        state->buffer_len -= number_of_bytes;

        return ZYAN_STATUS_SUCCESS;
    }

    return ZYDIS_STATUS_NO_MORE_DATA;
}

/* ---------------------------------------------------------------------------------------------- */
/* Decode functions                                                                               */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Decodes the `REX`-prefix.
 *
 * @param   context     A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   data        The `REX` byte.
 */
static void ZydisDecodeREX(ZydisDecoderContext* context, ZydisDecodedInstruction* instruction,
    ZyanU8 data)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT((data & 0xF0) == 0x40);

    instruction->attributes |= ZYDIS_ATTRIB_HAS_REX;
    instruction->raw.rex.W   = (data >> 3) & 0x01;
    instruction->raw.rex.R   = (data >> 2) & 0x01;
    instruction->raw.rex.X   = (data >> 1) & 0x01;
    instruction->raw.rex.B   = (data >> 0) & 0x01;

    // Update internal fields
    context->vector_unified.W = instruction->raw.rex.W;
    context->vector_unified.R = instruction->raw.rex.R;
    context->vector_unified.X = instruction->raw.rex.X;
    context->vector_unified.B = instruction->raw.rex.B;
}

/**
 * Decodes the `XOP`-prefix.
 *
 * @param   context     A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   data        The `XOP` bytes.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisDecodeXOP(ZydisDecoderContext* context,
    ZydisDecodedInstruction* instruction, const ZyanU8 data[3])
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(data[0] == 0x8F);
    ZYAN_ASSERT(((data[1] >> 0) & 0x1F) >= 8);
    ZYAN_ASSERT(instruction->raw.xop.offset == instruction->length - 3);

    if (instruction->machine_mode == ZYDIS_MACHINE_MODE_REAL_16)
    {
        // XOP is invalid in 16-bit real mode
        return ZYDIS_STATUS_DECODING_ERROR;
    }

    instruction->attributes |= ZYDIS_ATTRIB_HAS_XOP;
    instruction->raw.xop.R       = (data[1] >> 7) & 0x01;
    instruction->raw.xop.X       = (data[1] >> 6) & 0x01;
    instruction->raw.xop.B       = (data[1] >> 5) & 0x01;
    instruction->raw.xop.m_mmmm  = (data[1] >> 0) & 0x1F;

    if ((instruction->raw.xop.m_mmmm < 0x08) || (instruction->raw.xop.m_mmmm > 0x0A))
    {
        // Invalid according to the AMD documentation
        return ZYDIS_STATUS_INVALID_MAP;
    }

    instruction->raw.xop.W    = (data[2] >> 7) & 0x01;
    instruction->raw.xop.vvvv = (data[2] >> 3) & 0x0F;
    instruction->raw.xop.L    = (data[2] >> 2) & 0x01;
    instruction->raw.xop.pp   = (data[2] >> 0) & 0x03;

    // Update internal fields
    context->vector_unified.W    = instruction->raw.xop.W;
    context->vector_unified.R    = 0x01 & ~instruction->raw.xop.R;
    context->vector_unified.X    = 0x01 & ~instruction->raw.xop.X;
    context->vector_unified.B    = 0x01 & ~instruction->raw.xop.B;
    context->vector_unified.L    = instruction->raw.xop.L;
    context->vector_unified.LL   = instruction->raw.xop.L;
    context->vector_unified.vvvv = (0x0F & ~instruction->raw.xop.vvvv);

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Decodes the `VEX`-prefix.
 *
 * @param   context     A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   data        The `VEX` bytes.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisDecodeVEX(ZydisDecoderContext* context,
    ZydisDecodedInstruction* instruction, const ZyanU8 data[3])
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT((data[0] == 0xC4) || (data[0] == 0xC5));

    if (instruction->machine_mode == ZYDIS_MACHINE_MODE_REAL_16)
    {
        // VEX is invalid in 16-bit real mode
        return ZYDIS_STATUS_DECODING_ERROR;
    }

    instruction->attributes |= ZYDIS_ATTRIB_HAS_VEX;
    switch (data[0])
    {
    case 0xC4:
        ZYAN_ASSERT(instruction->raw.vex.offset == instruction->length - 3);
        instruction->raw.vex.size    = 3;
        instruction->raw.vex.R       = (data[1] >> 7) & 0x01;
        instruction->raw.vex.X       = (data[1] >> 6) & 0x01;
        instruction->raw.vex.B       = (data[1] >> 5) & 0x01;
        instruction->raw.vex.m_mmmm  = (data[1] >> 0) & 0x1F;
        instruction->raw.vex.W       = (data[2] >> 7) & 0x01;
        instruction->raw.vex.vvvv    = (data[2] >> 3) & 0x0F;
        instruction->raw.vex.L       = (data[2] >> 2) & 0x01;
        instruction->raw.vex.pp      = (data[2] >> 0) & 0x03;
        break;
    case 0xC5:
        ZYAN_ASSERT(instruction->raw.vex.offset == instruction->length - 2);
        instruction->raw.vex.size    = 2;
        instruction->raw.vex.R       = (data[1] >> 7) & 0x01;
        instruction->raw.vex.X       = 1;
        instruction->raw.vex.B       = 1;
        instruction->raw.vex.m_mmmm  = 1;
        instruction->raw.vex.W       = 0;
        instruction->raw.vex.vvvv    = (data[1] >> 3) & 0x0F;
        instruction->raw.vex.L       = (data[1] >> 2) & 0x01;
        instruction->raw.vex.pp      = (data[1] >> 0) & 0x03;
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    // Map 0 is only valid for some KNC instructions
#ifdef ZYDIS_DISABLE_KNC
    if ((instruction->raw.vex.m_mmmm == 0) || (instruction->raw.vex.m_mmmm > 0x03))
#else
    if (instruction->raw.vex.m_mmmm > 0x03)
#endif
    {
        // Invalid according to the intel documentation
        return ZYDIS_STATUS_INVALID_MAP;
    }

    // Update internal fields
    context->vector_unified.W    = instruction->raw.vex.W;
    context->vector_unified.R    = 0x01 & ~instruction->raw.vex.R;
    context->vector_unified.X    = 0x01 & ~instruction->raw.vex.X;
    context->vector_unified.B    = 0x01 & ~instruction->raw.vex.B;
    context->vector_unified.L    = instruction->raw.vex.L;
    context->vector_unified.LL   = instruction->raw.vex.L;
    context->vector_unified.vvvv = (0x0F & ~instruction->raw.vex.vvvv);

    return ZYAN_STATUS_SUCCESS;
}

#ifndef ZYDIS_DISABLE_AVX512
/**
 * Decodes the `EVEX`-prefix.
 *
 * @param   context     A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   data        The `EVEX` bytes.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisDecodeEVEX(ZydisDecoderContext* context,
    ZydisDecodedInstruction* instruction, const ZyanU8 data[4])
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(data[0] == 0x62);
    ZYAN_ASSERT(instruction->raw.evex.offset == instruction->length - 4);

    if (instruction->machine_mode == ZYDIS_MACHINE_MODE_REAL_16)
    {
        // EVEX is invalid in 16-bit real mode
        return ZYDIS_STATUS_DECODING_ERROR;
    }

    instruction->attributes |= ZYDIS_ATTRIB_HAS_EVEX;
    instruction->raw.evex.R         = (data[1] >> 7) & 0x01;
    instruction->raw.evex.X         = (data[1] >> 6) & 0x01;
    instruction->raw.evex.B         = (data[1] >> 5) & 0x01;
    instruction->raw.evex.R2        = (data[1] >> 4) & 0x01;

    if (data[1] & 0x08)
    {
        // Invalid according to the intel documentation
        return ZYDIS_STATUS_MALFORMED_EVEX;
    }

    instruction->raw.evex.mmm       = (data[1] >> 0) & 0x07;

    if ((instruction->raw.evex.mmm == 0x00) ||
        (instruction->raw.evex.mmm == 0x04) ||
        (instruction->raw.evex.mmm == 0x07))
    {
        // Invalid according to the intel documentation
        return ZYDIS_STATUS_INVALID_MAP;
    }

    instruction->raw.evex.W         = (data[2] >> 7) & 0x01;
    instruction->raw.evex.vvvv      = (data[2] >> 3) & 0x0F;

    ZYAN_ASSERT(((data[2] >> 2) & 0x01) == 0x01);

    instruction->raw.evex.pp        = (data[2] >> 0) & 0x03;
    instruction->raw.evex.z         = (data[3] >> 7) & 0x01;
    instruction->raw.evex.L2        = (data[3] >> 6) & 0x01;
    instruction->raw.evex.L         = (data[3] >> 5) & 0x01;
    instruction->raw.evex.b         = (data[3] >> 4) & 0x01;
    instruction->raw.evex.V2        = (data[3] >> 3) & 0x01;

    if (!instruction->raw.evex.V2 &&
        (instruction->machine_mode != ZYDIS_MACHINE_MODE_LONG_64))
    {
        return ZYDIS_STATUS_MALFORMED_EVEX;
    }

    instruction->raw.evex.aaa       = (data[3] >> 0) & 0x07;

    if (instruction->raw.evex.z && !instruction->raw.evex.aaa)
    {
        return ZYDIS_STATUS_INVALID_MASK; // TODO: Dedicated status code
    }

    // Update internal fields
    context->vector_unified.W    = instruction->raw.evex.W;
    context->vector_unified.R    = 0x01 & ~instruction->raw.evex.R;
    context->vector_unified.X    = 0x01 & ~instruction->raw.evex.X;
    context->vector_unified.B    = 0x01 & ~instruction->raw.evex.B;
    context->vector_unified.LL   = (data[3] >> 5) & 0x03;
    context->vector_unified.R2   = 0x01 & ~instruction->raw.evex.R2;
    context->vector_unified.V2   = 0x01 & ~instruction->raw.evex.V2;
    context->vector_unified.vvvv = 0x0F & ~instruction->raw.evex.vvvv;
    context->vector_unified.mask = instruction->raw.evex.aaa;

    if (!instruction->raw.evex.V2 && (instruction->machine_mode != ZYDIS_MACHINE_MODE_LONG_64))
    {
        return ZYDIS_STATUS_MALFORMED_EVEX;
    }
    if (!instruction->raw.evex.b && (context->vector_unified.LL == 3))
    {
        // LL = 3 is only valid for instructions with embedded rounding control
        return ZYDIS_STATUS_MALFORMED_EVEX;
    }

    return ZYAN_STATUS_SUCCESS;
}
#endif

#ifndef ZYDIS_DISABLE_KNC
/**
 * Decodes the `MVEX`-prefix.
 *
 * @param   context     A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   data        The `MVEX` bytes.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisDecodeMVEX(ZydisDecoderContext* context,
    ZydisDecodedInstruction* instruction, const ZyanU8 data[4])
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(data[0] == 0x62);
    ZYAN_ASSERT(instruction->raw.mvex.offset == instruction->length - 4);

    if (instruction->machine_mode != ZYDIS_MACHINE_MODE_LONG_64)
    {
        // MVEX is only valid in 64-bit mode
        return ZYDIS_STATUS_DECODING_ERROR;
    }

    instruction->attributes |= ZYDIS_ATTRIB_HAS_MVEX;
    instruction->raw.mvex.R    = (data[1] >> 7) & 0x01;
    instruction->raw.mvex.X    = (data[1] >> 6) & 0x01;
    instruction->raw.mvex.B    = (data[1] >> 5) & 0x01;
    instruction->raw.mvex.R2   = (data[1] >> 4) & 0x01;
    instruction->raw.mvex.mmmm = (data[1] >> 0) & 0x0F;

    if (instruction->raw.mvex.mmmm > 0x03)
    {
        // Invalid according to the intel documentation
        return ZYDIS_STATUS_INVALID_MAP;
    }

    instruction->raw.mvex.W    = (data[2] >> 7) & 0x01;
    instruction->raw.mvex.vvvv = (data[2] >> 3) & 0x0F;

    ZYAN_ASSERT(((data[2] >> 2) & 0x01) == 0x00);

    instruction->raw.mvex.pp   = (data[2] >> 0) & 0x03;
    instruction->raw.mvex.E    = (data[3] >> 7) & 0x01;
    instruction->raw.mvex.SSS  = (data[3] >> 4) & 0x07;
    instruction->raw.mvex.V2   = (data[3] >> 3) & 0x01;
    instruction->raw.mvex.kkk  = (data[3] >> 0) & 0x07;

    // Update internal fields
    context->vector_unified.W    = instruction->raw.mvex.W;
    context->vector_unified.R    = 0x01 & ~instruction->raw.mvex.R;
    context->vector_unified.X    = 0x01 & ~instruction->raw.mvex.X;
    context->vector_unified.B    = 0x01 & ~instruction->raw.mvex.B;
    context->vector_unified.R2   = 0x01 & ~instruction->raw.mvex.R2;
    context->vector_unified.V2   = 0x01 & ~instruction->raw.mvex.V2;
    context->vector_unified.LL   = 2;
    context->vector_unified.vvvv = 0x0F & ~instruction->raw.mvex.vvvv;
    context->vector_unified.mask = instruction->raw.mvex.kkk;

    return ZYAN_STATUS_SUCCESS;
}
#endif

/**
 * Decodes the `ModRM`-byte.
 *
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   data        The `ModRM` byte.
 */
static void ZydisDecodeModRM(ZydisDecodedInstruction* instruction, ZyanU8 data)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(!(instruction->attributes & ZYDIS_ATTRIB_HAS_MODRM));
    ZYAN_ASSERT(instruction->raw.modrm.offset == instruction->length - 1);

    instruction->attributes   |= ZYDIS_ATTRIB_HAS_MODRM;
    instruction->raw.modrm.mod = (data >> 6) & 0x03;
    instruction->raw.modrm.reg = (data >> 3) & 0x07;
    instruction->raw.modrm.rm  = (data >> 0) & 0x07;
}

/**
 * Decodes the `SIB`-byte.
 *
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct
 * @param   data        The `SIB` byte.
 */
static void ZydisDecodeSIB(ZydisDecodedInstruction* instruction, ZyanU8 data)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_MODRM);
    ZYAN_ASSERT(instruction->raw.modrm.rm == 4);
    ZYAN_ASSERT(!(instruction->attributes & ZYDIS_ATTRIB_HAS_SIB));
    ZYAN_ASSERT(instruction->raw.sib.offset == instruction->length - 1);

    instruction->attributes    |= ZYDIS_ATTRIB_HAS_SIB;
    instruction->raw.sib.scale = (data >> 6) & 0x03;
    instruction->raw.sib.index = (data >> 3) & 0x07;
    instruction->raw.sib.base  = (data >> 0) & 0x07;
}

/* ---------------------------------------------------------------------------------------------- */

/**
 * Reads a displacement value.
 *
 * @param   state       A pointer to the `ZydisDecoderState` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   size        The physical size of the displacement value.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisReadDisplacement(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU8 size)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(instruction->raw.disp.size == 0);

    instruction->raw.disp.size = size;
    instruction->raw.disp.offset = instruction->length;

    switch (size)
    {
    case 8:
    {
        ZyanU8 value;
        ZYAN_CHECK(ZydisInputNext(state, instruction, &value));
        instruction->raw.disp.value = *(ZyanI8*)&value;
        break;
    }
    case 16:
    {
        ZyanU16 value;
        ZYAN_CHECK(ZydisInputNextBytes(state, instruction, (ZyanU8*)&value, 2));
        instruction->raw.disp.value = *(ZyanI16*)&value;
        break;
    }
    case 32:
    {
        ZyanU32 value;
        ZYAN_CHECK(ZydisInputNextBytes(state, instruction, (ZyanU8*)&value, 4));
        instruction->raw.disp.value = *(ZyanI32*)&value;
        break;
    }
    case 64:
    {
        ZyanU64 value;
        ZYAN_CHECK(ZydisInputNextBytes(state, instruction, (ZyanU8*)&value, 8));
        instruction->raw.disp.value = *(ZyanI64*)&value;
        break;
    }
    default:
        ZYAN_UNREACHABLE;
    }

    // TODO: Fix endianess on big-endian systems

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Reads an immediate value.
 *
 * @param   state       A pointer to the `ZydisDecoderState` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   id          The immediate id (either `0` or `1`).
 * @param   size        The physical size of the immediate value.
 * @param   is_signed   Signals, if the immediate value is signed.
 * @param   is_relative Signals, if the immediate value is a relative offset.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisReadImmediate(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU8 id, ZyanU8 size, ZyanBool is_signed,
    ZyanBool is_relative)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT((id == 0) || (id == 1));
    ZYAN_ASSERT(is_signed || !is_relative);
    ZYAN_ASSERT(instruction->raw.imm[id].size == 0);

    instruction->raw.imm[id].size = size;
    instruction->raw.imm[id].offset = instruction->length;
    instruction->raw.imm[id].is_signed = is_signed;
    instruction->raw.imm[id].is_relative = is_relative;
    switch (size)
    {
    case 8:
    {
        ZyanU8 value;
        ZYAN_CHECK(ZydisInputNext(state, instruction, &value));
        if (is_signed)
        {
            instruction->raw.imm[id].value.s = (ZyanI8)value;
        } else
        {
            instruction->raw.imm[id].value.u = value;
        }
        break;
    }
    case 16:
    {
        ZyanU16 value;
        ZYAN_CHECK(ZydisInputNextBytes(state, instruction, (ZyanU8*)&value, 2));
        if (is_signed)
        {
            instruction->raw.imm[id].value.s = (ZyanI16)value;
        } else
        {
            instruction->raw.imm[id].value.u = value;
        }
        break;
    }
    case 32:
    {
        ZyanU32 value;
        ZYAN_CHECK(ZydisInputNextBytes(state, instruction, (ZyanU8*)&value, 4));
        if (is_signed)
        {
            instruction->raw.imm[id].value.s = (ZyanI32)value;
        } else
        {
            instruction->raw.imm[id].value.u = value;
        }
        break;
    }
    case 64:
    {
        ZyanU64 value;
        ZYAN_CHECK(ZydisInputNextBytes(state, instruction, (ZyanU8*)&value, 8));
        if (is_signed)
        {
            instruction->raw.imm[id].value.s = (ZyanI64)value;
        } else
        {
            instruction->raw.imm[id].value.u = value;
        }
        break;
    }
    default:
        ZYAN_UNREACHABLE;
    }

    // TODO: Fix endianess on big-endian systems

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */
/* Semantic instruction decoding                                                                  */
/* ---------------------------------------------------------------------------------------------- */

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Calculates the register-id for a specific register-encoding and register-class.
 *
 * @param   context         A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction     A pointer to the ` ZydisDecodedInstruction` struct.
 * @param   encoding        The register-encoding.
 * @param   register_class  The register-class.
 *
 * @return  A zyan status code.
 *
 * This function calculates the register-id by combining different fields and flags of previously
 * decoded structs.
 */
static ZyanU8 ZydisCalcRegisterId(const ZydisDecoderContext* context,
    const ZydisDecodedInstruction* instruction, ZydisRegisterEncoding encoding,
    ZydisRegisterClass register_class)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(instruction);

    // TODO: Combine OPCODE and IS4 in `ZydisPopulateRegisterIds` and get rid of this
    // TODO: function entirely

    switch (encoding)
    {
    case ZYDIS_REG_ENCODING_REG:
        return context->reg_info.id_reg;
    case ZYDIS_REG_ENCODING_NDSNDD:
        return context->reg_info.id_ndsndd;
    case ZYDIS_REG_ENCODING_RM:
        return context->reg_info.id_rm;
    case ZYDIS_REG_ENCODING_BASE:
        return context->reg_info.id_base;
    case ZYDIS_REG_ENCODING_INDEX:
    case ZYDIS_REG_ENCODING_VIDX:
        return context->reg_info.id_index;
    case ZYDIS_REG_ENCODING_OPCODE:
    {
        ZYAN_ASSERT((register_class == ZYDIS_REGCLASS_GPR8) ||
                    (register_class == ZYDIS_REGCLASS_GPR16) ||
                    (register_class == ZYDIS_REGCLASS_GPR32) ||
                    (register_class == ZYDIS_REGCLASS_GPR64));
        ZyanU8 value = (instruction->opcode & 0x0F);
        if (value > 7)
        {
            value = value - 8;
        }
        if (instruction->machine_mode != ZYDIS_MACHINE_MODE_LONG_64)
        {
            return value;
        }
        return value | (context->vector_unified.B << 3);
    }
    case ZYDIS_REG_ENCODING_IS4:
    {
        if (instruction->machine_mode != ZYDIS_MACHINE_MODE_LONG_64)
        {
            return (instruction->raw.imm[0].value.u >> 4) & 0x07;
        }
        ZyanU8 value = (instruction->raw.imm[0].value.u >> 4) & 0x0F;
        // We have to check the instruction-encoding, because the extension by bit [3] is only
        // valid for EVEX and MVEX instructions
        if ((instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX) ||
            (instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX))
        {
            switch (register_class)
            {
            case ZYDIS_REGCLASS_XMM:
            case ZYDIS_REGCLASS_YMM:
            case ZYDIS_REGCLASS_ZMM:
                value |= ((instruction->raw.imm[0].value.u & 0x08) << 1);
            default:
                break;
            }
        }
        return value;
    }
    case ZYDIS_REG_ENCODING_MASK:
        return context->vector_unified.mask;
    default:
        ZYAN_UNREACHABLE;
    }
}
#endif

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Sets the operand-size and element-specific information for the given operand.
 *
 * @param   context         A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction     A pointer to the `ZydisDecodedInstruction` struct.
 * @param   operand         A pointer to the `ZydisDecodedOperand` struct.
 * @param   definition      A pointer to the `ZydisOperandDefinition` struct.
 */
static void ZydisSetOperandSizeAndElementInfo(const ZydisDecoderContext* context,
    const ZydisDecodedInstruction* instruction, ZydisDecodedOperand* operand,
    const ZydisOperandDefinition* definition)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(operand);
    ZYAN_ASSERT(definition);

    // Operand size
    switch (operand->type)
    {
    case ZYDIS_OPERAND_TYPE_REGISTER:
    {
        if (definition->size[context->eosz_index])
        {
            operand->size = definition->size[context->eosz_index] * 8;
        } else
        {
            operand->size = ZydisRegisterGetWidth(instruction->machine_mode,
                operand->reg.value);
        }
        operand->element_type = ZYDIS_ELEMENT_TYPE_INT;
        operand->element_size = operand->size;
        break;
    }
    case ZYDIS_OPERAND_TYPE_MEMORY:
        switch (instruction->encoding)
        {
        case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
        case ZYDIS_INSTRUCTION_ENCODING_3DNOW:
        case ZYDIS_INSTRUCTION_ENCODING_XOP:
        case ZYDIS_INSTRUCTION_ENCODING_VEX:
            if (operand->mem.type == ZYDIS_MEMOP_TYPE_AGEN)
            {
                ZYAN_ASSERT(definition->size[context->eosz_index] == 0);
                operand->size = instruction->address_width;
                operand->element_type = ZYDIS_ELEMENT_TYPE_INT;
            } else
            {
                ZYAN_ASSERT(definition->size[context->eosz_index] ||
                    (instruction->meta.category == ZYDIS_CATEGORY_AMX_TILE));
                operand->size = definition->size[context->eosz_index] * 8;
            }
            break;
        case ZYDIS_INSTRUCTION_ENCODING_EVEX:
#ifndef ZYDIS_DISABLE_AVX512
            if (definition->size[context->eosz_index])
            {
                // Operand size is hardcoded
                operand->size = definition->size[context->eosz_index] * 8;
            } else
            {
                // Operand size depends on the tuple-type, the element-size and the number of
                // elements
                ZYAN_ASSERT(instruction->avx.vector_length);
                ZYAN_ASSERT(context->evex.element_size);
                switch (context->evex.tuple_type)
                {
                case ZYDIS_TUPLETYPE_FV:
                    if (instruction->avx.broadcast.mode)
                    {
                        operand->size = context->evex.element_size;
                    } else
                    {
                        operand->size = instruction->avx.vector_length;
                    }
                    break;
                case ZYDIS_TUPLETYPE_HV:
                    if (instruction->avx.broadcast.mode)
                    {
                        operand->size = context->evex.element_size;
                    } else
                    {
                        operand->size = (ZyanU16)instruction->avx.vector_length / 2;
                    }
                    break;
                case ZYDIS_TUPLETYPE_QUARTER:
                    if (instruction->avx.broadcast.mode)
                    {
                        operand->size = context->evex.element_size;
                    }
                    else
                    {
                        operand->size = (ZyanU16)instruction->avx.vector_length / 4;
                    }
                    break;
                default:
                    ZYAN_UNREACHABLE;
                }
            }
            ZYAN_ASSERT(operand->size);
#else
            ZYAN_UNREACHABLE;
#endif
            break;
        case ZYDIS_INSTRUCTION_ENCODING_MVEX:
#ifndef ZYDIS_DISABLE_KNC
            if (definition->size[context->eosz_index])
            {
                // Operand size is hardcoded
                operand->size = definition->size[context->eosz_index] * 8;
            } else
            {
                ZYAN_ASSERT(definition->element_type == ZYDIS_IELEMENT_TYPE_VARIABLE);
                ZYAN_ASSERT(instruction->avx.vector_length == 512);

                switch (instruction->avx.conversion.mode)
                {
                case ZYDIS_CONVERSION_MODE_INVALID:
                    operand->size = 512;
                    switch (context->mvex.functionality)
                    {
                    case ZYDIS_MVEX_FUNC_SF_32:
                    case ZYDIS_MVEX_FUNC_SF_32_BCST_4TO16:
                    case ZYDIS_MVEX_FUNC_UF_32:
                    case ZYDIS_MVEX_FUNC_DF_32:
                        operand->element_type = ZYDIS_ELEMENT_TYPE_FLOAT32;
                        operand->element_size = 32;
                        break;
                    case ZYDIS_MVEX_FUNC_SF_32_BCST:
                        operand->size = 256;
                        operand->element_type = ZYDIS_ELEMENT_TYPE_FLOAT32;
                        operand->element_size = 32;
                        break;
                    case ZYDIS_MVEX_FUNC_SI_32:
                    case ZYDIS_MVEX_FUNC_SI_32_BCST_4TO16:
                    case ZYDIS_MVEX_FUNC_UI_32:
                    case ZYDIS_MVEX_FUNC_DI_32:
                        operand->element_type = ZYDIS_ELEMENT_TYPE_INT;
                        operand->element_size = 32;
                        break;
                    case ZYDIS_MVEX_FUNC_SI_32_BCST:
                        operand->size = 256;
                        operand->element_type = ZYDIS_ELEMENT_TYPE_INT;
                        operand->element_size = 32;
                        break;
                    case ZYDIS_MVEX_FUNC_SF_64:
                    case ZYDIS_MVEX_FUNC_UF_64:
                    case ZYDIS_MVEX_FUNC_DF_64:
                        operand->element_type = ZYDIS_ELEMENT_TYPE_FLOAT64;
                        operand->element_size = 64;
                        break;
                    case ZYDIS_MVEX_FUNC_SI_64:
                    case ZYDIS_MVEX_FUNC_UI_64:
                    case ZYDIS_MVEX_FUNC_DI_64:
                        operand->element_type = ZYDIS_ELEMENT_TYPE_INT;
                        operand->element_size = 64;
                        break;
                    default:
                        ZYAN_UNREACHABLE;
                    }
                    break;
                case ZYDIS_CONVERSION_MODE_FLOAT16:
                    operand->size = 256;
                    operand->element_type = ZYDIS_ELEMENT_TYPE_FLOAT16;
                    operand->element_size = 16;
                    break;
                case ZYDIS_CONVERSION_MODE_SINT16:
                    operand->size = 256;
                    operand->element_type = ZYDIS_ELEMENT_TYPE_INT;
                    operand->element_size = 16;
                    break;
                case ZYDIS_CONVERSION_MODE_UINT16:
                    operand->size = 256;
                    operand->element_type = ZYDIS_ELEMENT_TYPE_UINT;
                    operand->element_size = 16;
                    break;
                case ZYDIS_CONVERSION_MODE_SINT8:
                    operand->size = 128;
                    operand->element_type = ZYDIS_ELEMENT_TYPE_INT;
                    operand->element_size = 8;
                    break;
                case ZYDIS_CONVERSION_MODE_UINT8:
                    operand->size = 128;
                    operand->element_type = ZYDIS_ELEMENT_TYPE_UINT;
                    operand->element_size = 8;
                    break;
                default:
                    ZYAN_UNREACHABLE;
                }

                switch (instruction->avx.broadcast.mode)
                {
                case ZYDIS_BROADCAST_MODE_INVALID:
                    // Nothing to do here
                    break;
                case ZYDIS_BROADCAST_MODE_1_TO_8:
                case ZYDIS_BROADCAST_MODE_1_TO_16:
                    operand->size = operand->element_size;
                    break;
                case ZYDIS_BROADCAST_MODE_4_TO_8:
                case ZYDIS_BROADCAST_MODE_4_TO_16:
                    operand->size = operand->element_size * 4;
                    break;
                default:
                    ZYAN_UNREACHABLE;
                }
            }
#else
            ZYAN_UNREACHABLE;
#endif
            break;
        default:
            ZYAN_UNREACHABLE;
        }
        break;
    case ZYDIS_OPERAND_TYPE_POINTER:
        ZYAN_ASSERT((instruction->raw.imm[0].size == 16) ||
                    (instruction->raw.imm[0].size == 32));
        ZYAN_ASSERT( instruction->raw.imm[1].size == 16);
        operand->size = instruction->raw.imm[0].size + instruction->raw.imm[1].size;
        break;
    case ZYDIS_OPERAND_TYPE_IMMEDIATE:
        operand->size = definition->size[context->eosz_index] * 8;
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    // Element-type and -size
    if (definition->element_type && (definition->element_type != ZYDIS_IELEMENT_TYPE_VARIABLE))
    {
        ZydisGetElementInfo(definition->element_type, &operand->element_type,
            &operand->element_size);
        if (!operand->element_size)
        {
            // The element size is the same as the operand size. This is used for single element
            // scaling operands
            operand->element_size = operand->size;
        }
    }

    // Element count
    if (operand->element_size && operand->size && (operand->element_type != ZYDIS_ELEMENT_TYPE_CC))
    {
        operand->element_count = operand->size / operand->element_size;
    } else
    {
        operand->element_count = 1;
    }
}
#endif

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Decodes an register-operand.
 *
 * @param   instruction      A pointer to the `ZydisDecodedInstruction` struct.
 * @param   operand          A pointer to the `ZydisDecodedOperand` struct.
 * @param   register_class   The register class.
 * @param   register_id      The register id.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisDecodeOperandRegister(const ZydisDecodedInstruction* instruction,
    ZydisDecodedOperand* operand, ZydisRegisterClass register_class, ZyanU8 register_id)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(operand);

    operand->type = ZYDIS_OPERAND_TYPE_REGISTER;

    if (register_class == ZYDIS_REGCLASS_GPR8)
    {
        if ((instruction->attributes & ZYDIS_ATTRIB_HAS_REX) && (register_id >= 4))
        {
            operand->reg.value = ZYDIS_REGISTER_SPL + (register_id - 4);
        } else
        {
            operand->reg.value = ZYDIS_REGISTER_AL + register_id;
        }
    } else
    {
        operand->reg.value = ZydisRegisterEncode(register_class, register_id);
        ZYAN_ASSERT(operand->reg.value);
        /*if (!operand->reg.value)
        {
            return ZYAN_STATUS_BAD_REGISTER;
        }*/
    }

    return ZYAN_STATUS_SUCCESS;
}
#endif

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Decodes a memory operand.
 *
 * @param   context             A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction         A pointer to the `ZydisDecodedInstruction` struct.
 * @param   operand             A pointer to the `ZydisDecodedOperand` struct.
 * @param   vidx_register_class The register-class to use as the index register-class for
 *                              instructions with `VSIB` addressing.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisDecodeOperandMemory(const ZydisDecoderContext* context,
    const ZydisDecodedInstruction* instruction, ZydisDecodedOperand* operand,
    ZydisRegisterClass vidx_register_class)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(operand);
    ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_MODRM);
    ZYAN_ASSERT(instruction->raw.modrm.mod != 3);
    ZYAN_ASSERT(!vidx_register_class || ((instruction->raw.modrm.rm == 4) &&
        ((instruction->address_width == 32) || (instruction->address_width == 64))));

    operand->type = ZYDIS_OPERAND_TYPE_MEMORY;
    operand->mem.type = ZYDIS_MEMOP_TYPE_MEM;

    const ZyanU8 modrm_rm = instruction->raw.modrm.rm;
    ZyanU8 displacement_size = 0;
    switch (instruction->address_width)
    {
    case 16:
    {
        static const ZydisRegister bases[] =
        {
            ZYDIS_REGISTER_BX,   ZYDIS_REGISTER_BX,   ZYDIS_REGISTER_BP,   ZYDIS_REGISTER_BP,
            ZYDIS_REGISTER_SI,   ZYDIS_REGISTER_DI,   ZYDIS_REGISTER_BP,   ZYDIS_REGISTER_BX
        };
        static const ZydisRegister indices[] =
        {
            ZYDIS_REGISTER_SI,   ZYDIS_REGISTER_DI,   ZYDIS_REGISTER_SI,   ZYDIS_REGISTER_DI,
            ZYDIS_REGISTER_NONE, ZYDIS_REGISTER_NONE, ZYDIS_REGISTER_NONE, ZYDIS_REGISTER_NONE
        };
        operand->mem.base = bases[modrm_rm];
        operand->mem.index = indices[modrm_rm];
        operand->mem.scale = (operand->mem.index == ZYDIS_REGISTER_NONE) ? 0 : 1;
        switch (instruction->raw.modrm.mod)
        {
        case 0:
            if (modrm_rm == 6)
            {
                displacement_size = 16;
                operand->mem.base = ZYDIS_REGISTER_NONE;
            }
            break;
        case 1:
            displacement_size = 8;
            break;
        case 2:
            displacement_size = 16;
            break;
        default:
            ZYAN_UNREACHABLE;
        }
        break;
    }
    case 32:
    {
        operand->mem.base = ZYDIS_REGISTER_EAX + ZydisCalcRegisterId(context, instruction,
            ZYDIS_REG_ENCODING_BASE, ZYDIS_REGCLASS_GPR32);
        switch (instruction->raw.modrm.mod)
        {
        case 0:
            if (modrm_rm == 5)
            {
                if (instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
                {
                    operand->mem.base = ZYDIS_REGISTER_EIP;
                } else
                {
                    operand->mem.base = ZYDIS_REGISTER_NONE;
                }
                displacement_size = 32;
            }
            break;
        case 1:
            displacement_size = 8;
            break;
        case 2:
            displacement_size = 32;
            break;
        default:
            ZYAN_UNREACHABLE;
        }
        if (modrm_rm == 4)
        {
            ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_SIB);
            operand->mem.index =
                ZydisRegisterEncode(vidx_register_class ? vidx_register_class : ZYDIS_REGCLASS_GPR32,
                    ZydisCalcRegisterId(context, instruction,
                        vidx_register_class ? ZYDIS_REG_ENCODING_VIDX : ZYDIS_REG_ENCODING_INDEX,
                        vidx_register_class ? vidx_register_class : ZYDIS_REGCLASS_GPR32));
            operand->mem.scale = (1 << instruction->raw.sib.scale);
            if (operand->mem.index == ZYDIS_REGISTER_ESP)
            {
                operand->mem.index = ZYDIS_REGISTER_NONE;
                operand->mem.scale = 0;
            }
            if (operand->mem.base == ZYDIS_REGISTER_EBP)
            {
                if (instruction->raw.modrm.mod == 0)
                {
                    operand->mem.base = ZYDIS_REGISTER_NONE;
                }
                displacement_size = (instruction->raw.modrm.mod == 1) ? 8 : 32;
            }
        } else
        {
            operand->mem.index = ZYDIS_REGISTER_NONE;
            operand->mem.scale = 0;
        }
        break;
    }
    case 64:
    {
        operand->mem.base = ZYDIS_REGISTER_RAX + ZydisCalcRegisterId(context, instruction,
            ZYDIS_REG_ENCODING_BASE, ZYDIS_REGCLASS_GPR64);
        switch (instruction->raw.modrm.mod)
        {
        case 0:
            if (modrm_rm == 5)
            {
                if (instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
                {
                    operand->mem.base = ZYDIS_REGISTER_RIP;
                } else
                {
                    operand->mem.base = ZYDIS_REGISTER_NONE;
                }
                displacement_size = 32;
            }
            break;
        case 1:
            displacement_size = 8;
            break;
        case 2:
            displacement_size = 32;
            break;
        default:
            ZYAN_UNREACHABLE;
        }
        if ((modrm_rm & 0x07) == 4)
        {
            ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_SIB);
            operand->mem.index =
                ZydisRegisterEncode(vidx_register_class ? vidx_register_class : ZYDIS_REGCLASS_GPR64,
                    ZydisCalcRegisterId(context, instruction,
                        vidx_register_class ? ZYDIS_REG_ENCODING_VIDX : ZYDIS_REG_ENCODING_INDEX,
                        vidx_register_class ? vidx_register_class : ZYDIS_REGCLASS_GPR64));
            operand->mem.scale = (1 << instruction->raw.sib.scale);
            if (operand->mem.index == ZYDIS_REGISTER_RSP)
            {
                operand->mem.index = ZYDIS_REGISTER_NONE;
                operand->mem.scale = 0;
            }
            if ((operand->mem.base == ZYDIS_REGISTER_RBP) ||
                (operand->mem.base == ZYDIS_REGISTER_R13))
            {
                if (instruction->raw.modrm.mod == 0)
                {
                    operand->mem.base = ZYDIS_REGISTER_NONE;
                }
                displacement_size = (instruction->raw.modrm.mod == 1) ? 8 : 32;
            }
        } else
        {
            operand->mem.index = ZYDIS_REGISTER_NONE;
            operand->mem.scale = 0;
        }
        break;
    }
    default:
        ZYAN_UNREACHABLE;
    }
    if (displacement_size)
    {
        ZYAN_ASSERT(instruction->raw.disp.size == displacement_size);
        operand->mem.disp.has_displacement = ZYAN_TRUE;
        operand->mem.disp.value = instruction->raw.disp.value;
    }
    return ZYAN_STATUS_SUCCESS;
}
#endif

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Decodes an implicit register operand.
 *
 * @param   decoder         A pointer to the `ZydisDecoder` instance.
 * @param   context         A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction     A pointer to the `ZydisDecodedInstruction` struct.
 * @param   operand         A pointer to the `ZydisDecodedOperand` struct.
 * @param   definition      A pointer to the `ZydisOperandDefinition` struct.
 */
static void ZydisDecodeOperandImplicitRegister(const ZydisDecoder* decoder,
    const ZydisDecoderContext* context, const ZydisDecodedInstruction* instruction,
    ZydisDecodedOperand* operand, const ZydisOperandDefinition* definition)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(operand);
    ZYAN_ASSERT(definition);

    operand->type = ZYDIS_OPERAND_TYPE_REGISTER;

    switch (definition->op.reg.type)
    {
    case ZYDIS_IMPLREG_TYPE_STATIC:
        operand->reg.value = definition->op.reg.reg.reg;
        break;
    case ZYDIS_IMPLREG_TYPE_GPR_OSZ:
    {
        static const ZydisRegisterClass lookup[3] =
        {
            ZYDIS_REGCLASS_GPR16,
            ZYDIS_REGCLASS_GPR32,
            ZYDIS_REGCLASS_GPR64
        };
        operand->reg.value =
            ZydisRegisterEncode(lookup[context->eosz_index], definition->op.reg.reg.id);
        break;
    }
    case ZYDIS_IMPLREG_TYPE_GPR_ASZ:
        operand->reg.value = ZydisRegisterEncode(
            (instruction->address_width    == 16) ? ZYDIS_REGCLASS_GPR16  :
            (instruction->address_width    == 32) ? ZYDIS_REGCLASS_GPR32  : ZYDIS_REGCLASS_GPR64,
            definition->op.reg.reg.id);
        break;
    case ZYDIS_IMPLREG_TYPE_IP_ASZ:
        operand->reg.value =
            (instruction->address_width    == 16) ? ZYDIS_REGISTER_IP     :
            (instruction->address_width    == 32) ? ZYDIS_REGISTER_EIP    : ZYDIS_REGISTER_RIP;
        break;
    case ZYDIS_IMPLREG_TYPE_GPR_SSZ:
        operand->reg.value = ZydisRegisterEncode(
            (decoder->stack_width == ZYDIS_STACK_WIDTH_16) ? ZYDIS_REGCLASS_GPR16 :
            (decoder->stack_width == ZYDIS_STACK_WIDTH_32) ? ZYDIS_REGCLASS_GPR32 :
                                                             ZYDIS_REGCLASS_GPR64,
            definition->op.reg.reg.id);
        break;
    case ZYDIS_IMPLREG_TYPE_IP_SSZ:
        operand->reg.value =
            (decoder->stack_width == ZYDIS_STACK_WIDTH_16) ? ZYDIS_REGISTER_EIP    :
            (decoder->stack_width == ZYDIS_STACK_WIDTH_32) ? ZYDIS_REGISTER_EIP    :
                                                             ZYDIS_REGISTER_RIP;
        break;
    case ZYDIS_IMPLREG_TYPE_FLAGS_SSZ:
        operand->reg.value =
            (decoder->stack_width == ZYDIS_STACK_WIDTH_16) ? ZYDIS_REGISTER_FLAGS  :
            (decoder->stack_width == ZYDIS_STACK_WIDTH_32) ? ZYDIS_REGISTER_EFLAGS :
                                                             ZYDIS_REGISTER_RFLAGS;
        break;
    default:
        ZYAN_UNREACHABLE;
    }
}
#endif

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Decodes an implicit memory operand.
 *
 * @param   decoder         A pointer to the `ZydisDecoder` instance.
 * @param   context         A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction     A pointer to the `ZydisDecodedInstruction` struct.
 * @param   operand         A pointer to the `ZydisDecodedOperand` struct.
 * @param   definition      A pointer to the `ZydisOperandDefinition` struct.
 */
static void ZydisDecodeOperandImplicitMemory(const ZydisDecoder* decoder,
    const ZydisDecoderContext* context, const ZydisDecodedInstruction* instruction,
    ZydisDecodedOperand* operand, const ZydisOperandDefinition* definition)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(operand);
    ZYAN_ASSERT(definition);

    static const ZydisRegisterClass lookup[3] =
    {
        ZYDIS_REGCLASS_GPR16,
        ZYDIS_REGCLASS_GPR32,
        ZYDIS_REGCLASS_GPR64
    };

    operand->type = ZYDIS_OPERAND_TYPE_MEMORY;
    operand->mem.type = ZYDIS_MEMOP_TYPE_MEM;

    switch (definition->op.mem.base)
    {
    case ZYDIS_IMPLMEM_BASE_AGPR_REG:
        operand->mem.base = ZydisRegisterEncode(lookup[context->easz_index],
            ZydisCalcRegisterId(context, instruction, ZYDIS_REG_ENCODING_REG,
                lookup[context->easz_index]));
        break;
    case ZYDIS_IMPLMEM_BASE_AGPR_RM:
        operand->mem.base = ZydisRegisterEncode(lookup[context->easz_index],
            ZydisCalcRegisterId(context, instruction, ZYDIS_REG_ENCODING_RM,
                lookup[context->easz_index]));
        break;
    case ZYDIS_IMPLMEM_BASE_AAX:
        operand->mem.base = ZydisRegisterEncode(lookup[context->easz_index], 0);
        break;
    case ZYDIS_IMPLMEM_BASE_ADX:
        operand->mem.base = ZydisRegisterEncode(lookup[context->easz_index], 2);
        break;
    case ZYDIS_IMPLMEM_BASE_ABX:
        operand->mem.base = ZydisRegisterEncode(lookup[context->easz_index], 3);
        break;
    case ZYDIS_IMPLMEM_BASE_ASI:
        operand->mem.base = ZydisRegisterEncode(lookup[context->easz_index], 6);
        break;
    case ZYDIS_IMPLMEM_BASE_ADI:
        operand->mem.base = ZydisRegisterEncode(lookup[context->easz_index], 7);
        break;
    case ZYDIS_IMPLMEM_BASE_SSP:
        operand->mem.base = ZydisRegisterEncode(lookup[decoder->stack_width], 4);
        break;
    case ZYDIS_IMPLMEM_BASE_SBP:
        operand->mem.base = ZydisRegisterEncode(lookup[decoder->stack_width], 5);
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    if (definition->op.mem.seg)
    {
        operand->mem.segment =
            ZydisRegisterEncode(ZYDIS_REGCLASS_SEGMENT, definition->op.mem.seg - 1);
        ZYAN_ASSERT(operand->mem.segment);
    }
}
#endif

#ifndef ZYDIS_MINIMAL_MODE
ZyanStatus ZydisDecodeOperands(const ZydisDecoder* decoder, const ZydisDecoderContext* context,
    const ZydisDecodedInstruction* instruction, ZydisDecodedOperand* operands, ZyanU8 operand_count)
{
    ZYAN_ASSERT(decoder);
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(context->definition);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(operands);
    ZYAN_ASSERT(operand_count);
    ZYAN_ASSERT(operand_count <= instruction->operand_count);

    const ZydisInstructionDefinition* definition = context->definition;
    const ZydisOperandDefinition* operand = ZydisGetOperandDefinitions(definition);

    ZYAN_MEMSET(operands, 0, sizeof(ZydisDecodedOperand) * operand_count);

    ZyanU8 imm_id = 0;
    for (ZyanU8 i = 0; i < operand_count; ++i)
    {
        ZydisRegisterClass register_class = ZYDIS_REGCLASS_INVALID;

        operands[i].id = i;
        operands[i].visibility = operand->visibility;
        operands[i].actions = operand->actions;
        ZYAN_ASSERT(!(operand->actions &
            ZYDIS_OPERAND_ACTION_READ & ZYDIS_OPERAND_ACTION_CONDREAD) ||
            (operand->actions & ZYDIS_OPERAND_ACTION_READ) ^
            (operand->actions & ZYDIS_OPERAND_ACTION_CONDREAD));
        ZYAN_ASSERT(!(operand->actions &
            ZYDIS_OPERAND_ACTION_WRITE & ZYDIS_OPERAND_ACTION_CONDWRITE) ||
            (operand->actions & ZYDIS_OPERAND_ACTION_WRITE) ^
            (operand->actions & ZYDIS_OPERAND_ACTION_CONDWRITE));

        // Implicit operands
        switch (operand->type)
        {
        case ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_REG:
            ZydisDecodeOperandImplicitRegister(decoder, context, instruction, &operands[i], operand);
            break;
        case ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_MEM:
            ZydisDecodeOperandImplicitMemory(decoder, context, instruction, &operands[i], operand);
            break;
        case ZYDIS_SEMANTIC_OPTYPE_IMPLICIT_IMM1:
            operands[i].type = ZYDIS_OPERAND_TYPE_IMMEDIATE;
            operands[i].size = 8;
            operands[i].imm.value.u = 1;
            operands[i].imm.is_signed = ZYAN_FALSE;
            operands[i].imm.is_relative = ZYAN_FALSE;
            break;
        default:
            break;
        }
        if (operands[i].type)
        {
            goto FinalizeOperand;
        }

        operands[i].encoding = operand->op.encoding;

        // Register operands
        switch (operand->type)
        {
        case ZYDIS_SEMANTIC_OPTYPE_GPR8:
            register_class = ZYDIS_REGCLASS_GPR8;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_GPR16:
            register_class = ZYDIS_REGCLASS_GPR16;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_GPR32:
            register_class = ZYDIS_REGCLASS_GPR32;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_GPR64:
            register_class = ZYDIS_REGCLASS_GPR64;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_GPR16_32_64:
            ZYAN_ASSERT((instruction->operand_width == 16) || (instruction->operand_width == 32) ||
                (instruction->operand_width == 64));
            register_class =
                (instruction->operand_width == 16) ? ZYDIS_REGCLASS_GPR16 : (
                    (instruction->operand_width == 32) ? ZYDIS_REGCLASS_GPR32 : ZYDIS_REGCLASS_GPR64);
            break;
        case ZYDIS_SEMANTIC_OPTYPE_GPR32_32_64:
            ZYAN_ASSERT((instruction->operand_width == 16) || (instruction->operand_width == 32) ||
                (instruction->operand_width == 64));
            register_class =
                (instruction->operand_width == 16) ? ZYDIS_REGCLASS_GPR32 : (
                    (instruction->operand_width == 32) ? ZYDIS_REGCLASS_GPR32 : ZYDIS_REGCLASS_GPR64);
            break;
        case ZYDIS_SEMANTIC_OPTYPE_GPR16_32_32:
            ZYAN_ASSERT((instruction->operand_width == 16) || (instruction->operand_width == 32) ||
                (instruction->operand_width == 64));
            register_class =
                (instruction->operand_width == 16) ? ZYDIS_REGCLASS_GPR16 : ZYDIS_REGCLASS_GPR32;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_GPR_ASZ:
            ZYAN_ASSERT((instruction->address_width == 16) || (instruction->address_width == 32) ||
                (instruction->address_width == 64));
            register_class =
                (instruction->address_width == 16) ? ZYDIS_REGCLASS_GPR16 : (
                    (instruction->address_width == 32) ? ZYDIS_REGCLASS_GPR32 : ZYDIS_REGCLASS_GPR64);
            break;
        case ZYDIS_SEMANTIC_OPTYPE_FPR:
            register_class = ZYDIS_REGCLASS_X87;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_MMX:
            register_class = ZYDIS_REGCLASS_MMX;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_XMM:
            register_class = ZYDIS_REGCLASS_XMM;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_YMM:
            register_class = ZYDIS_REGCLASS_YMM;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_ZMM:
            register_class = ZYDIS_REGCLASS_ZMM;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_TMM:
            register_class = ZYDIS_REGCLASS_TMM;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_BND:
            register_class = ZYDIS_REGCLASS_BOUND;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_SREG:
            register_class = ZYDIS_REGCLASS_SEGMENT;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_CR:
            register_class = ZYDIS_REGCLASS_CONTROL;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_DR:
            register_class = ZYDIS_REGCLASS_DEBUG;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_MASK:
            register_class = ZYDIS_REGCLASS_MASK;
            break;
        default:
            break;
        }
        if (register_class)
        {
            switch (operand->op.encoding)
            {
            case ZYDIS_OPERAND_ENCODING_MODRM_REG:
                ZYAN_CHECK(
                    ZydisDecodeOperandRegister(
                        instruction, &operands[i], register_class,
                        ZydisCalcRegisterId(
                            context, instruction, ZYDIS_REG_ENCODING_REG, register_class)));
                break;
            case ZYDIS_OPERAND_ENCODING_MODRM_RM:
                ZYAN_CHECK(
                    ZydisDecodeOperandRegister(
                        instruction, &operands[i], register_class,
                        ZydisCalcRegisterId(
                            context, instruction, ZYDIS_REG_ENCODING_RM, register_class)));
                break;
            case ZYDIS_OPERAND_ENCODING_OPCODE:
                ZYAN_CHECK(
                    ZydisDecodeOperandRegister(
                        instruction, &operands[i], register_class,
                        ZydisCalcRegisterId(
                            context, instruction, ZYDIS_REG_ENCODING_OPCODE, register_class)));
                break;
            case ZYDIS_OPERAND_ENCODING_NDSNDD:
                ZYAN_CHECK(
                    ZydisDecodeOperandRegister(
                        instruction, &operands[i], register_class,
                        ZydisCalcRegisterId(
                            context, instruction, ZYDIS_REG_ENCODING_NDSNDD, register_class)));
                break;
            case ZYDIS_OPERAND_ENCODING_MASK:
                ZYAN_CHECK(
                    ZydisDecodeOperandRegister(
                        instruction, &operands[i], register_class,
                        ZydisCalcRegisterId(
                            context, instruction, ZYDIS_REG_ENCODING_MASK, register_class)));
                break;
            case ZYDIS_OPERAND_ENCODING_IS4:
                ZYAN_CHECK(
                    ZydisDecodeOperandRegister(
                        instruction, &operands[i], register_class,
                        ZydisCalcRegisterId(
                            context, instruction, ZYDIS_REG_ENCODING_IS4, register_class)));
                break;
            default:
                ZYAN_UNREACHABLE;
            }

            if (operand->is_multisource4)
            {
                operands[i].attributes |= ZYDIS_OATTRIB_IS_MULTISOURCE4;
            }

            goto FinalizeOperand;
        }

        // Memory operands
        switch (operand->type)
        {
        case ZYDIS_SEMANTIC_OPTYPE_MEM:
            ZYAN_CHECK(
                ZydisDecodeOperandMemory(
                    context, instruction, &operands[i], ZYDIS_REGCLASS_INVALID));
            break;
        case ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBX:
            ZYAN_CHECK(
                ZydisDecodeOperandMemory(
                    context, instruction, &operands[i], ZYDIS_REGCLASS_XMM));
            operands[i].mem.type = ZYDIS_MEMOP_TYPE_VSIB;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBY:
            ZYAN_CHECK(
                ZydisDecodeOperandMemory(
                    context, instruction, &operands[i], ZYDIS_REGCLASS_YMM));
            operands[i].mem.type = ZYDIS_MEMOP_TYPE_VSIB;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_MEM_VSIBZ:
            ZYAN_CHECK(
                ZydisDecodeOperandMemory(
                    context, instruction, &operands[i], ZYDIS_REGCLASS_ZMM));
            operands[i].mem.type = ZYDIS_MEMOP_TYPE_VSIB;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_PTR:
            ZYAN_ASSERT((instruction->raw.imm[0].size == 16) ||
                (instruction->raw.imm[0].size == 32));
            ZYAN_ASSERT(instruction->raw.imm[1].size == 16);
            operands[i].type = ZYDIS_OPERAND_TYPE_POINTER;
            operands[i].ptr.offset = (ZyanU32)instruction->raw.imm[0].value.u;
            operands[i].ptr.segment = (ZyanU16)instruction->raw.imm[1].value.u;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_AGEN:
            operands[i].actions = 0; // TODO: Remove after generator update
            ZYAN_CHECK(
                ZydisDecodeOperandMemory(
                    context, instruction, &operands[i], ZYDIS_REGCLASS_INVALID));
            operands[i].mem.type = ZYDIS_MEMOP_TYPE_AGEN;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_MOFFS:
            ZYAN_ASSERT(instruction->raw.disp.size);
            operands[i].type = ZYDIS_OPERAND_TYPE_MEMORY;
            operands[i].mem.type = ZYDIS_MEMOP_TYPE_MEM;
            operands[i].mem.disp.has_displacement = ZYAN_TRUE;
            operands[i].mem.disp.value = instruction->raw.disp.value;
            break;
        case ZYDIS_SEMANTIC_OPTYPE_MIB:
            operands[i].actions = 0; // TODO: Remove after generator update
            ZYAN_CHECK(
                ZydisDecodeOperandMemory(
                    context, instruction, &operands[i], ZYDIS_REGCLASS_INVALID));
            operands[i].mem.type = ZYDIS_MEMOP_TYPE_MIB;
            break;
        default:
            break;
        }
        if (operands[i].type)
        {
#if !defined(ZYDIS_DISABLE_AVX512) || !defined(ZYDIS_DISABLE_KNC)
            // Handle compressed 8-bit displacement
            if (((instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX) ||
                (instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX)) &&
                (instruction->raw.disp.size == 8))
            {
                operands[i].mem.disp.value *= context->cd8_scale;
            }
#endif

            goto FinalizeOperand;
        }

        // Immediate operands
        switch (operand->type)
        {
        case ZYDIS_SEMANTIC_OPTYPE_REL:
            ZYAN_ASSERT(instruction->raw.imm[imm_id].is_relative);
            ZYAN_FALLTHROUGH;
        case ZYDIS_SEMANTIC_OPTYPE_IMM:
            ZYAN_ASSERT((imm_id == 0) || (imm_id == 1));
            operands[i].type = ZYDIS_OPERAND_TYPE_IMMEDIATE;
            operands[i].size = operand->size[context->eosz_index] * 8;
            if (operand->op.encoding == ZYDIS_OPERAND_ENCODING_IS4)
            {
                // The upper half of the 8-bit immediate is used to encode a register specifier
                ZYAN_ASSERT(instruction->raw.imm[imm_id].size == 8);
                operands[i].imm.value.u = (ZyanU8)instruction->raw.imm[imm_id].value.u & 0x0F;
            }
            else
            {
                operands[i].imm.value.u = instruction->raw.imm[imm_id].value.u;
            }
            operands[i].imm.is_signed = instruction->raw.imm[imm_id].is_signed;
            operands[i].imm.is_relative = instruction->raw.imm[imm_id].is_relative;
            ++imm_id;
            break;
        default:
            break;
        }
        ZYAN_ASSERT(operands[i].type == ZYDIS_OPERAND_TYPE_IMMEDIATE);

    FinalizeOperand:
        // Set segment-register for memory operands
        if (operands[i].type == ZYDIS_OPERAND_TYPE_MEMORY)
        {
            if (!operand->ignore_seg_override &&
                instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_CS)
            {
                operands[i].mem.segment = ZYDIS_REGISTER_CS;
            }
            else
                if (!operand->ignore_seg_override &&
                    instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_SS)
                {
                    operands[i].mem.segment = ZYDIS_REGISTER_SS;
                }
                else
                    if (!operand->ignore_seg_override &&
                        instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_DS)
                    {
                        operands[i].mem.segment = ZYDIS_REGISTER_DS;
                    }
                    else
                        if (!operand->ignore_seg_override &&
                            instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_ES)
                        {
                            operands[i].mem.segment = ZYDIS_REGISTER_ES;
                        }
                        else
                            if (!operand->ignore_seg_override &&
                                instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_FS)
                            {
                                operands[i].mem.segment = ZYDIS_REGISTER_FS;
                            }
                            else
                                if (!operand->ignore_seg_override &&
                                    instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT_GS)
                                {
                                    operands[i].mem.segment = ZYDIS_REGISTER_GS;
                                }
                                else
                                {
                                    if (operands[i].mem.segment == ZYDIS_REGISTER_NONE)
                                    {
                                        if ((operands[i].mem.base == ZYDIS_REGISTER_RSP) ||
                                            (operands[i].mem.base == ZYDIS_REGISTER_RBP) ||
                                            (operands[i].mem.base == ZYDIS_REGISTER_ESP) ||
                                            (operands[i].mem.base == ZYDIS_REGISTER_EBP) ||
                                            (operands[i].mem.base == ZYDIS_REGISTER_SP) ||
                                            (operands[i].mem.base == ZYDIS_REGISTER_BP))
                                        {
                                            operands[i].mem.segment = ZYDIS_REGISTER_SS;
                                        }
                                        else
                                        {
                                            operands[i].mem.segment = ZYDIS_REGISTER_DS;
                                        }
                                    }
                                }
        }

        ZydisSetOperandSizeAndElementInfo(context, instruction, &operands[i], operand);
        ++operand;
    }

#if !defined(ZYDIS_DISABLE_AVX512) || !defined(ZYDIS_DISABLE_KNC)
    // Fix operand-action for EVEX/MVEX instructions with merge-mask
    if (instruction->avx.mask.mode == ZYDIS_MASK_MODE_MERGING)
    {
        ZYAN_ASSERT(operand_count >= 1);
        switch (operands[0].actions)
        {
        case ZYDIS_OPERAND_ACTION_WRITE:
            if (operands[0].type == ZYDIS_OPERAND_TYPE_MEMORY)
            {
                operands[0].actions = ZYDIS_OPERAND_ACTION_CONDWRITE;
            }
            else
            {
                operands[0].actions = ZYDIS_OPERAND_ACTION_READ_CONDWRITE;
            }
            break;
        case ZYDIS_OPERAND_ACTION_READWRITE:
            operands[0].actions = ZYDIS_OPERAND_ACTION_READ_CONDWRITE;
            break;
        default:
            break;
        }
    }
#endif

    return ZYAN_STATUS_SUCCESS;
}
#endif

/* ---------------------------------------------------------------------------------------------- */

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Sets attributes for the given instruction.
 *
 * @param   state       A pointer to the `ZydisDecoderState` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   definition  A pointer to the `ZydisInstructionDefinition` struct.
 */
static void ZydisSetAttributes(ZydisDecoderState* state, ZydisDecodedInstruction* instruction,
    const ZydisInstructionDefinition* definition)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(definition);

    if (definition->cpu_state != ZYDIS_RW_ACTION_NONE)
    {
        static const ZydisInstructionAttributes mapping[ZYDIS_RW_ACTION_MAX_VALUE + 1] =
        {
            /* NONE      */ 0,
            /* READ      */ ZYDIS_ATTRIB_CPU_STATE_CR,
            /* WRITE     */ ZYDIS_ATTRIB_CPU_STATE_CW,
            /* READWRITE */ ZYDIS_ATTRIB_CPU_STATE_CR | ZYDIS_ATTRIB_CPU_STATE_CW
        };
        ZYAN_ASSERT(definition->cpu_state < ZYAN_ARRAY_LENGTH(mapping));
        instruction->attributes |= mapping[definition->cpu_state];
    }

    if (definition->fpu_state != ZYDIS_RW_ACTION_NONE)
    {
        static const ZydisInstructionAttributes mapping[ZYDIS_RW_ACTION_MAX_VALUE + 1] =
        {
            /* NONE      */ 0,
            /* READ      */ ZYDIS_ATTRIB_FPU_STATE_CR,
            /* WRITE     */ ZYDIS_ATTRIB_FPU_STATE_CW,
            /* READWRITE */ ZYDIS_ATTRIB_FPU_STATE_CR | ZYDIS_ATTRIB_FPU_STATE_CW
        };
        ZYAN_ASSERT(definition->fpu_state < ZYAN_ARRAY_LENGTH(mapping));
        instruction->attributes |= mapping[definition->fpu_state];
    }

    if (definition->xmm_state != ZYDIS_RW_ACTION_NONE)
    {
        static const ZydisInstructionAttributes mapping[ZYDIS_RW_ACTION_MAX_VALUE + 1] =
        {
            /* NONE      */ 0,
            /* READ      */ ZYDIS_ATTRIB_XMM_STATE_CR,
            /* WRITE     */ ZYDIS_ATTRIB_XMM_STATE_CW,
            /* READWRITE */ ZYDIS_ATTRIB_XMM_STATE_CR | ZYDIS_ATTRIB_XMM_STATE_CW
        };
        ZYAN_ASSERT(definition->xmm_state < ZYAN_ARRAY_LENGTH(mapping));
        instruction->attributes |= mapping[definition->xmm_state];
    }

    switch (instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
    {
        const ZydisInstructionDefinitionLEGACY* def =
            (const ZydisInstructionDefinitionLEGACY*)definition;

        if (def->is_privileged)
        {
            instruction->attributes |= ZYDIS_ATTRIB_IS_PRIVILEGED;
        }
        if (def->accepts_LOCK)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_LOCK;
            if (state->prefixes.has_lock)
            {
                instruction->attributes |= ZYDIS_ATTRIB_HAS_LOCK;
                instruction->raw.prefixes[state->prefixes.offset_lock].type =
                    ZYDIS_PREFIX_TYPE_EFFECTIVE;
            }
        }
        if (def->accepts_REP)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_REP;
        }
        if (def->accepts_REPEREPZ)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_REPE;
        }
        if (def->accepts_REPNEREPNZ)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_REPNE;
        }
        if (def->accepts_BOUND)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_BND;
        }
        if (def->accepts_XACQUIRE)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_XACQUIRE;
        }
        if (def->accepts_XRELEASE)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_XRELEASE;
        }
        if (def->accepts_hle_without_lock)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_HLE_WITHOUT_LOCK;
        }

        switch (state->prefixes.group1)
        {
        case 0xF2:
            if (instruction->attributes & ZYDIS_ATTRIB_ACCEPTS_REPNE)
            {
                instruction->attributes |= ZYDIS_ATTRIB_HAS_REPNE;
                break;
            }
            if (instruction->attributes & ZYDIS_ATTRIB_ACCEPTS_XACQUIRE)
            {
                if ((instruction->attributes & ZYDIS_ATTRIB_HAS_LOCK) ||
                    (def->accepts_hle_without_lock))
                {
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_XACQUIRE;
                    break;
                }
            }
            if (state->decoder->decoder_mode[ZYDIS_DECODER_MODE_MPX] &&
                instruction->attributes & ZYDIS_ATTRIB_ACCEPTS_BND)
            {
                instruction->attributes |= ZYDIS_ATTRIB_HAS_BND;
                break;
            }
            break;
        case 0xF3:
            if (instruction->attributes & ZYDIS_ATTRIB_ACCEPTS_REP)
            {
                instruction->attributes |= ZYDIS_ATTRIB_HAS_REP;
                break;
            }
            if (instruction->attributes & ZYDIS_ATTRIB_ACCEPTS_REPE)
            {
                instruction->attributes |= ZYDIS_ATTRIB_HAS_REPE;
                break;
            }
            if (instruction->attributes & ZYDIS_ATTRIB_ACCEPTS_XRELEASE)
            {
                if ((instruction->attributes & ZYDIS_ATTRIB_HAS_LOCK) ||
                    (def->accepts_hle_without_lock))
                {
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_XRELEASE;
                    break;
                }
            }
            break;
        default:
            break;
        }
        if ((instruction->raw.prefixes[state->prefixes.offset_group1].type ==
             ZYDIS_PREFIX_TYPE_IGNORED) &&
            (instruction->attributes & (
             ZYDIS_ATTRIB_HAS_REP | ZYDIS_ATTRIB_HAS_REPE | ZYDIS_ATTRIB_HAS_REPNE |
             ZYDIS_ATTRIB_HAS_BND | ZYDIS_ATTRIB_HAS_XACQUIRE | ZYDIS_ATTRIB_HAS_XRELEASE)))
        {
            instruction->raw.prefixes[state->prefixes.offset_group1].type =
                ZYDIS_PREFIX_TYPE_EFFECTIVE;
        }

        if (def->accepts_branch_hints)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_BRANCH_HINTS;
            switch (state->prefixes.group2)
            {
            case 0x2E:
                instruction->attributes |= ZYDIS_ATTRIB_HAS_BRANCH_NOT_TAKEN;
                instruction->raw.prefixes[state->prefixes.offset_group2].type =
                    ZYDIS_PREFIX_TYPE_EFFECTIVE;
                break;
            case 0x3E:
                instruction->attributes |= ZYDIS_ATTRIB_HAS_BRANCH_TAKEN;
                instruction->raw.prefixes[state->prefixes.offset_group2].type =
                    ZYDIS_PREFIX_TYPE_EFFECTIVE;
                break;
            default:
                break;
            }
        }

        if (def->accepts_NOTRACK)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_NOTRACK;
            if (state->decoder->decoder_mode[ZYDIS_DECODER_MODE_CET] &&
                (state->prefixes.offset_notrack >= 0))
            {
                instruction->attributes |= ZYDIS_ATTRIB_HAS_NOTRACK;
                instruction->raw.prefixes[state->prefixes.offset_notrack].type =
                    ZYDIS_PREFIX_TYPE_EFFECTIVE;
            }
        }

        if (def->accepts_segment && !def->accepts_branch_hints)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_SEGMENT;
            if (state->prefixes.effective_segment &&
                !(instruction->attributes & ZYDIS_ATTRIB_HAS_NOTRACK))
            {
                switch (state->prefixes.effective_segment)
                {
                case 0x2E:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_CS;
                    break;
                case 0x36:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_SS;
                    break;
                case 0x3E:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_DS;
                    break;
                case 0x26:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_ES;
                    break;
                case 0x64:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_FS;
                    break;
                case 0x65:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_GS;
                    break;
                default:
                    ZYAN_UNREACHABLE;
                }
            }
            if (instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT)
            {
                instruction->raw.prefixes[state->prefixes.offset_segment].type =
                    ZYDIS_PREFIX_TYPE_EFFECTIVE;
            }
        }

        break;
    }
    case ZYDIS_INSTRUCTION_ENCODING_3DNOW:
    case ZYDIS_INSTRUCTION_ENCODING_XOP:
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
        if (definition->accepts_segment)
        {
            instruction->attributes |= ZYDIS_ATTRIB_ACCEPTS_SEGMENT;
            if (state->prefixes.effective_segment)
            {
                switch (state->prefixes.effective_segment)
                {
                case 0x2E:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_CS;
                    break;
                case 0x36:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_SS;
                    break;
                case 0x3E:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_DS;
                    break;
                case 0x26:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_ES;
                    break;
                case 0x64:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_FS;
                    break;
                case 0x65:
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_SEGMENT_GS;
                    break;
                default:
                    ZYAN_UNREACHABLE;
                }
            }
            if (instruction->attributes & ZYDIS_ATTRIB_HAS_SEGMENT)
            {
                instruction->raw.prefixes[state->prefixes.offset_segment].type =
                    ZYDIS_PREFIX_TYPE_EFFECTIVE;
            }
        }
        break;
    default:
        ZYAN_UNREACHABLE;
    }
}
#endif

#ifndef ZYDIS_MINIMAL_MODE
/**
 * Sets AVX-specific information for the given instruction.
 *
 * @param   context     A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   definition  A pointer to the `ZydisInstructionDefinition` struct.
 *
 * Information set for `XOP`:
 * - Vector Length
 *
 * Information set for `VEX`:
 * - Vector length
 * - Static broadcast-factor
 *
 * Information set for `EVEX`:
 * - Vector length
 * - Broadcast-factor (static and dynamic)
 * - Rounding-mode and SAE
 * - Mask mode
 * - Compressed 8-bit displacement scale-factor
 *
 * Information set for `MVEX`:
 * - Vector length
 * - Broadcast-factor (static and dynamic)
 * - Rounding-mode and SAE
 * - Swizzle- and conversion-mode
 * - Mask mode
 * - Eviction hint
 * - Compressed 8-bit displacement scale-factor
 */
static void ZydisSetAVXInformation(ZydisDecoderContext* context,
    ZydisDecodedInstruction* instruction, const ZydisInstructionDefinition* definition)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(definition);

    switch (instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_XOP:
    {
        // Vector length
        static const ZyanU16 lookup[2] =
        {
            128,
            256
        };
        ZYAN_ASSERT(context->vector_unified.LL < ZYAN_ARRAY_LENGTH(lookup));
        instruction->avx.vector_length = lookup[context->vector_unified.LL];
        break;
    }
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
    {
        // Vector length
        static const ZyanU16 lookup[2] =
        {
            128,
            256
        };
        ZYAN_ASSERT(context->vector_unified.LL < ZYAN_ARRAY_LENGTH(lookup));
        instruction->avx.vector_length = lookup[context->vector_unified.LL];

        // Static broadcast-factor
        const ZydisInstructionDefinitionVEX* def =
            (const ZydisInstructionDefinitionVEX*)definition;
        if (def->broadcast)
        {
            instruction->avx.broadcast.is_static = ZYAN_TRUE;
            static ZydisBroadcastMode broadcasts[ZYDIS_VEX_STATIC_BROADCAST_MAX_VALUE + 1] =
            {
                ZYDIS_BROADCAST_MODE_INVALID,
                ZYDIS_BROADCAST_MODE_1_TO_2,
                ZYDIS_BROADCAST_MODE_1_TO_4,
                ZYDIS_BROADCAST_MODE_1_TO_8,
                ZYDIS_BROADCAST_MODE_1_TO_16,
                ZYDIS_BROADCAST_MODE_1_TO_32,
                ZYDIS_BROADCAST_MODE_2_TO_4
            };
            instruction->avx.broadcast.mode = broadcasts[def->broadcast];
        }
        break;
    }
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
    {
#ifndef ZYDIS_DISABLE_AVX512
        const ZydisInstructionDefinitionEVEX* def =
            (const ZydisInstructionDefinitionEVEX*)definition;

        // Vector length
        ZyanU8 vector_length = context->vector_unified.LL;
        if (def->vector_length)
        {
            vector_length = def->vector_length - 1;
        }
        static const ZyanU16 lookup[3] =
        {
            128,
            256,
            512
        };
        ZYAN_ASSERT(vector_length < ZYAN_ARRAY_LENGTH(lookup));
        instruction->avx.vector_length = lookup[vector_length];

        context->evex.tuple_type = def->tuple_type;
        if (def->tuple_type)
        {
            ZYAN_ASSERT(instruction->raw.modrm.mod != 3);
            ZYAN_ASSERT(def->element_size);

            // Element size
            static const ZyanU8 element_sizes[ZYDIS_IELEMENT_SIZE_MAX_VALUE + 1] =
            {
                  0,   8,  16,  32,  64, 128
            };
            ZYAN_ASSERT(def->element_size < ZYAN_ARRAY_LENGTH(element_sizes));
            context->evex.element_size = element_sizes[def->element_size];

            // Compressed disp8 scale and broadcast-factor
            switch (def->tuple_type)
            {
            case ZYDIS_TUPLETYPE_FV:
            {
                const ZyanU8 evex_b = instruction->raw.evex.b;
                ZYAN_ASSERT(evex_b < 2);
                ZYAN_ASSERT(!evex_b || ((!context->vector_unified.W && (context->evex.element_size == 16 ||
                                                                        context->evex.element_size == 32)) ||
                                        ( context->vector_unified.W &&  context->evex.element_size == 64)));
                ZYAN_ASSERT(!evex_b || def->functionality == ZYDIS_EVEX_FUNC_BC);

                static const ZyanU8 scales[2][3][3] =
                {
                    /*B0*/ { /*16*/ { 16, 32, 64 }, /*32*/ { 16, 32, 64 }, /*64*/ { 16, 32, 64 } },
                    /*B1*/ { /*16*/ {  2,  2,  2 }, /*32*/ {  4,  4,  4 }, /*64*/ {  8,  8,  8 } }
                };
                static const ZydisBroadcastMode broadcasts[2][3][3] =
                {
                    /*B0*/
                    {
                        /*16*/
                        {
                            ZYDIS_BROADCAST_MODE_INVALID,
                            ZYDIS_BROADCAST_MODE_INVALID,
                            ZYDIS_BROADCAST_MODE_INVALID
                        },
                        /*32*/
                        {
                            ZYDIS_BROADCAST_MODE_INVALID,
                            ZYDIS_BROADCAST_MODE_INVALID,
                            ZYDIS_BROADCAST_MODE_INVALID
                        },
                        /*64*/
                        {
                            ZYDIS_BROADCAST_MODE_INVALID,
                            ZYDIS_BROADCAST_MODE_INVALID,
                            ZYDIS_BROADCAST_MODE_INVALID
                        }
                    },
                    /*B1*/
                    {
                        /*16*/
                        {
                            ZYDIS_BROADCAST_MODE_1_TO_8,
                            ZYDIS_BROADCAST_MODE_1_TO_16,
                            ZYDIS_BROADCAST_MODE_1_TO_32
                        },
                        /*32*/
                        {
                            ZYDIS_BROADCAST_MODE_1_TO_4,
                            ZYDIS_BROADCAST_MODE_1_TO_8,
                            ZYDIS_BROADCAST_MODE_1_TO_16
                        },
                        /*64*/
                        {
                            ZYDIS_BROADCAST_MODE_1_TO_2,
                            ZYDIS_BROADCAST_MODE_1_TO_4,
                            ZYDIS_BROADCAST_MODE_1_TO_8
                        }
                    }
                };

                const ZyanU8 size_index = context->evex.element_size >> 5;
                ZYAN_ASSERT(size_index < 3);

                context->cd8_scale = scales[evex_b][size_index][vector_length];
                instruction->avx.broadcast.mode = broadcasts[evex_b][size_index][vector_length];
                break;
            }
            case ZYDIS_TUPLETYPE_HV:
            {
                const ZyanU8 evex_b = instruction->raw.evex.b;
                ZYAN_ASSERT(evex_b < 2);
                ZYAN_ASSERT(!context->vector_unified.W);
                ZYAN_ASSERT((context->evex.element_size == 16) ||
                            (context->evex.element_size == 32));
                ZYAN_ASSERT(!evex_b || def->functionality == ZYDIS_EVEX_FUNC_BC);

                static const ZyanU8 scales[2][2][3] =
                {
                    /*B0*/ { /*16*/ {  8, 16, 32 }, /*32*/ {  8, 16, 32 } },
                    /*B1*/ { /*16*/ {  2,  2,  2 }, /*32*/ {  4,  4,  4 } }
                };
                static const ZydisBroadcastMode broadcasts[2][2][3] =
                {
                    /*B0*/
                    {
                        /*16*/
                        {
                            ZYDIS_BROADCAST_MODE_INVALID,
                            ZYDIS_BROADCAST_MODE_INVALID,
                            ZYDIS_BROADCAST_MODE_INVALID
                        },
                        /*32*/
                        {
                            ZYDIS_BROADCAST_MODE_INVALID,
                            ZYDIS_BROADCAST_MODE_INVALID,
                            ZYDIS_BROADCAST_MODE_INVALID
                        }
                    },
                    /*B1*/
                    {
                        /*16*/
                        {
                            ZYDIS_BROADCAST_MODE_1_TO_4,
                            ZYDIS_BROADCAST_MODE_1_TO_8,
                            ZYDIS_BROADCAST_MODE_1_TO_16
                        },
                        /*32*/
                        {
                            ZYDIS_BROADCAST_MODE_1_TO_2,
                            ZYDIS_BROADCAST_MODE_1_TO_4,
                            ZYDIS_BROADCAST_MODE_1_TO_8
                        }
                    }
                };

                const ZyanU8 size_index = context->evex.element_size >> 5;
                ZYAN_ASSERT(size_index < 3);

                context->cd8_scale = scales[evex_b][size_index][vector_length];
                instruction->avx.broadcast.mode = broadcasts[evex_b][size_index][vector_length];
                break;
            }
            case ZYDIS_TUPLETYPE_FVM:
            {
                static const ZyanU8 scales[3] =
                {
                    16, 32, 64
                };
                context->cd8_scale = scales[vector_length];
                break;
            }
            case ZYDIS_TUPLETYPE_GSCAT:
                switch (context->vector_unified.W)
                {
                case 0:
                    ZYAN_ASSERT(context->evex.element_size == 32);
                    break;
                case 1:
                    ZYAN_ASSERT(context->evex.element_size == 64);
                    break;
                default:
                    ZYAN_UNREACHABLE;
                }
                ZYAN_FALLTHROUGH;
            case ZYDIS_TUPLETYPE_T1S:
            {
                static const ZyanU8 scales[6] =
                {
                    /*   */  0,
                    /*  8*/  1,
                    /* 16*/  2,
                    /* 32*/  4,
                    /* 64*/  8,
                    /*128*/ 16,
                };
                ZYAN_ASSERT(def->element_size < ZYAN_ARRAY_LENGTH(scales));
                context->cd8_scale = scales[def->element_size];
                break;
            };
            case ZYDIS_TUPLETYPE_T1F:
            {
                static const ZyanU8 scales[3] =
                {
                    /* 16*/ 2,
                    /* 32*/ 4,
                    /* 64*/ 8
                };

                const ZyanU8 size_index = context->evex.element_size >> 5;
                ZYAN_ASSERT(size_index < 3);

                context->cd8_scale = scales[size_index];
                break;
            }
            case ZYDIS_TUPLETYPE_T1_4X:
                ZYAN_ASSERT(context->evex.element_size == 32);
                ZYAN_ASSERT(context->vector_unified.W == 0);
                context->cd8_scale = 16;
                break;
            case ZYDIS_TUPLETYPE_T2:
                switch (context->vector_unified.W)
                {
                case 0:
                    ZYAN_ASSERT(context->evex.element_size == 32);
                    context->cd8_scale = 8;
                    break;
                case 1:
                    ZYAN_ASSERT(context->evex.element_size == 64);
                    ZYAN_ASSERT((instruction->avx.vector_length == 256) ||
                                (instruction->avx.vector_length == 512));
                    context->cd8_scale = 16;
                    break;
                default:
                    ZYAN_UNREACHABLE;
                }
                break;
            case ZYDIS_TUPLETYPE_T4:
                switch (context->vector_unified.W)
                {
                case 0:
                    ZYAN_ASSERT(context->evex.element_size == 32);
                    ZYAN_ASSERT((instruction->avx.vector_length == 256) ||
                                (instruction->avx.vector_length == 512));
                    context->cd8_scale = 16;
                    break;
                case 1:
                    ZYAN_ASSERT(context->evex.element_size == 64);
                    ZYAN_ASSERT(instruction->avx.vector_length == 512);
                    context->cd8_scale = 32;
                    break;
                default:
                    ZYAN_UNREACHABLE;
                }
                break;
            case ZYDIS_TUPLETYPE_T8:
                ZYAN_ASSERT(!context->vector_unified.W);
                ZYAN_ASSERT(instruction->avx.vector_length == 512);
                ZYAN_ASSERT(context->evex.element_size == 32);
                context->cd8_scale = 32;
                break;
            case ZYDIS_TUPLETYPE_HVM:
            {
                static const ZyanU8 scales[3] =
                {
                     8, 16, 32
                };
                context->cd8_scale = scales[vector_length];
                break;
            }
            case ZYDIS_TUPLETYPE_QVM:
            {
                static const ZyanU8 scales[3] =
                {
                     4,  8, 16
                };
                context->cd8_scale = scales[vector_length];
                break;
            }
            case ZYDIS_TUPLETYPE_OVM:
            {
                static const ZyanU8 scales[3] =
                {
                     2,  4,  8
                };
                context->cd8_scale = scales[vector_length];
                break;
            }
            case ZYDIS_TUPLETYPE_M128:
                context->cd8_scale = 16;
                break;
            case ZYDIS_TUPLETYPE_DUP:
            {
                static const ZyanU8 scales[3] =
                {
                     8, 32, 64
                };
                context->cd8_scale = scales[vector_length];
                break;
            }
            case ZYDIS_TUPLETYPE_QUARTER:
            {
                const ZyanU8 evex_b = instruction->raw.evex.b;
                ZYAN_ASSERT(evex_b < 2);
                ZYAN_ASSERT(!context->vector_unified.W);
                ZYAN_ASSERT(context->evex.element_size == 16);
                ZYAN_ASSERT(!evex_b || def->functionality == ZYDIS_EVEX_FUNC_BC);

                static const ZyanU8 scales[2][3] =
                {
                    /*B0*/ {  4,  8, 16 },
                    /*B1*/ {  2,  2,  2 }
                };
                static const ZydisBroadcastMode broadcasts[2][3] =
                {
                    /*B0*/
                    {
                        ZYDIS_BROADCAST_MODE_INVALID,
                        ZYDIS_BROADCAST_MODE_INVALID,
                        ZYDIS_BROADCAST_MODE_INVALID
                    },
                    /*B1*/
                    {
                        ZYDIS_BROADCAST_MODE_1_TO_2,
                        ZYDIS_BROADCAST_MODE_1_TO_4,
                        ZYDIS_BROADCAST_MODE_1_TO_8
                    }
                };
                context->cd8_scale = scales[evex_b][vector_length];
                instruction->avx.broadcast.mode = broadcasts[evex_b][vector_length];
                break;
            }
            default:
                ZYAN_UNREACHABLE;
            }
        } else
        {
            ZYAN_ASSERT(instruction->raw.modrm.mod == 3);
        }

        // Static broadcast-factor
        if (def->broadcast)
        {
            ZYAN_ASSERT(!instruction->avx.broadcast.mode);
            instruction->avx.broadcast.is_static = ZYAN_TRUE;
            static const ZydisBroadcastMode broadcasts[ZYDIS_EVEX_STATIC_BROADCAST_MAX_VALUE + 1] =
            {
                ZYDIS_BROADCAST_MODE_INVALID,
                ZYDIS_BROADCAST_MODE_1_TO_2,
                ZYDIS_BROADCAST_MODE_1_TO_4,
                ZYDIS_BROADCAST_MODE_1_TO_8,
                ZYDIS_BROADCAST_MODE_1_TO_16,
                ZYDIS_BROADCAST_MODE_1_TO_32,
                ZYDIS_BROADCAST_MODE_1_TO_64,
                ZYDIS_BROADCAST_MODE_2_TO_4,
                ZYDIS_BROADCAST_MODE_2_TO_8,
                ZYDIS_BROADCAST_MODE_2_TO_16,
                ZYDIS_BROADCAST_MODE_4_TO_8,
                ZYDIS_BROADCAST_MODE_4_TO_16,
                ZYDIS_BROADCAST_MODE_8_TO_16
            };
            ZYAN_ASSERT(def->broadcast < ZYAN_ARRAY_LENGTH(broadcasts));
            instruction->avx.broadcast.mode = broadcasts[def->broadcast];
        }

        // Rounding mode and SAE
        if (instruction->raw.evex.b)
        {
            switch (def->functionality)
            {
            case ZYDIS_EVEX_FUNC_INVALID:
            case ZYDIS_EVEX_FUNC_BC:
                // Noting to do here
                break;
            case ZYDIS_EVEX_FUNC_RC:
                instruction->avx.rounding.mode = ZYDIS_ROUNDING_MODE_RN + context->vector_unified.LL;
                ZYAN_FALLTHROUGH;
            case ZYDIS_EVEX_FUNC_SAE:
                instruction->avx.has_sae = ZYAN_TRUE;
                break;
            default:
                ZYAN_UNREACHABLE;
            }
        }

        // Mask
        instruction->avx.mask.reg = ZYDIS_REGISTER_K0 + instruction->raw.evex.aaa;
        switch (def->mask_override)
        {
        case ZYDIS_MASK_OVERRIDE_DEFAULT:
            instruction->avx.mask.mode = ZYDIS_MASK_MODE_MERGING + instruction->raw.evex.z;
            break;
        case ZYDIS_MASK_OVERRIDE_ZEROING:
            instruction->avx.mask.mode = ZYDIS_MASK_MODE_ZEROING;
            break;
        case ZYDIS_MASK_OVERRIDE_CONTROL:
            instruction->avx.mask.mode = ZYDIS_MASK_MODE_CONTROL + instruction->raw.evex.z;
            break;
        default:
            ZYAN_UNREACHABLE;
        }
        if (!instruction->raw.evex.aaa)
        {
            instruction->avx.mask.mode = ZYDIS_MASK_MODE_DISABLED;
        }
#else
        ZYAN_UNREACHABLE;
#endif
        break;
    }
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
    {
#ifndef ZYDIS_DISABLE_KNC
        // Vector length
        instruction->avx.vector_length = 512;

        const ZydisInstructionDefinitionMVEX* def =
            (const ZydisInstructionDefinitionMVEX*)definition;

        // Static broadcast-factor
        ZyanU8 index = def->has_element_granularity;
        ZYAN_ASSERT(!index || !def->broadcast);
        if (!index && def->broadcast)
        {
            instruction->avx.broadcast.is_static = ZYAN_TRUE;
            switch (def->broadcast)
            {
            case ZYDIS_MVEX_STATIC_BROADCAST_1_TO_8:
                instruction->avx.broadcast.mode = ZYDIS_BROADCAST_MODE_1_TO_8;
                index = 1;
                break;
            case ZYDIS_MVEX_STATIC_BROADCAST_1_TO_16:
                instruction->avx.broadcast.mode = ZYDIS_BROADCAST_MODE_1_TO_16;
                index = 1;
                break;
            case ZYDIS_MVEX_STATIC_BROADCAST_4_TO_8:
                instruction->avx.broadcast.mode = ZYDIS_BROADCAST_MODE_4_TO_8;
                index = 2;
                break;
            case ZYDIS_MVEX_STATIC_BROADCAST_4_TO_16:
                instruction->avx.broadcast.mode = ZYDIS_BROADCAST_MODE_4_TO_16;
                index = 2;
                break;
            default:
                ZYAN_UNREACHABLE;
            }
        }

        // Compressed disp8 scale and broadcast-factor
        switch (def->functionality)
        {
        case ZYDIS_MVEX_FUNC_IGNORED:
        case ZYDIS_MVEX_FUNC_INVALID:
        case ZYDIS_MVEX_FUNC_RC:
        case ZYDIS_MVEX_FUNC_SAE:
        case ZYDIS_MVEX_FUNC_SWIZZLE_32:
        case ZYDIS_MVEX_FUNC_SWIZZLE_64:
            // Nothing to do here
            break;
        case ZYDIS_MVEX_FUNC_F_32:
        case ZYDIS_MVEX_FUNC_I_32:
        case ZYDIS_MVEX_FUNC_F_64:
        case ZYDIS_MVEX_FUNC_I_64:
            context->cd8_scale = 64;
            break;
        case ZYDIS_MVEX_FUNC_SF_32:
        case ZYDIS_MVEX_FUNC_SF_32_BCST:
        case ZYDIS_MVEX_FUNC_SF_32_BCST_4TO16:
        case ZYDIS_MVEX_FUNC_UF_32:
        {
            static const ZyanU8 lookup[3][8] =
            {
                { 64,  4, 16, 32, 16, 16, 32, 32 },
                {  4,  0,  0,  2,  1,  1,  2,  2 },
                { 16,  0,  0,  8,  4,  4,  8,  8 }
            };
            ZYAN_ASSERT(instruction->raw.mvex.SSS < ZYAN_ARRAY_LENGTH(lookup[index]));
            context->cd8_scale = lookup[index][instruction->raw.mvex.SSS];
            break;
        }
        case ZYDIS_MVEX_FUNC_SI_32:
        case ZYDIS_MVEX_FUNC_UI_32:
        case ZYDIS_MVEX_FUNC_SI_32_BCST:
        case ZYDIS_MVEX_FUNC_SI_32_BCST_4TO16:
        {
            static const ZyanU8 lookup[3][8] =
            {
                { 64,  4, 16,  0, 16, 16, 32, 32 },
                {  4,  0,  0,  0,  1,  1,  2,  2 },
                { 16,  0,  0,  0,  4,  4,  8,  8 }
            };
            ZYAN_ASSERT(instruction->raw.mvex.SSS < ZYAN_ARRAY_LENGTH(lookup[index]));
            context->cd8_scale = lookup[index][instruction->raw.mvex.SSS];
            break;
        }
        case ZYDIS_MVEX_FUNC_SF_64:
        case ZYDIS_MVEX_FUNC_UF_64:
        case ZYDIS_MVEX_FUNC_SI_64:
        case ZYDIS_MVEX_FUNC_UI_64:
        {
            static const ZyanU8 lookup[3][3] =
            {
                { 64,  8, 32 },
                {  8,  0,  0 },
                { 32,  0,  0 }
            };
            ZYAN_ASSERT(instruction->raw.mvex.SSS < ZYAN_ARRAY_LENGTH(lookup[index]));
            context->cd8_scale = lookup[index][instruction->raw.mvex.SSS];
            break;
        }
        case ZYDIS_MVEX_FUNC_DF_32:
        case ZYDIS_MVEX_FUNC_DI_32:
        {
            static const ZyanU8 lookup[2][8] =
            {
                { 64,  0,  0, 32, 16, 16, 32, 32 },
                {  4,  0,  0,  2,  1,  1,  2,  2 }
            };
            ZYAN_ASSERT(index < 2);
            ZYAN_ASSERT(instruction->raw.mvex.SSS < ZYAN_ARRAY_LENGTH(lookup[index]));
            context->cd8_scale = lookup[index][instruction->raw.mvex.SSS];
            break;
        }
        case ZYDIS_MVEX_FUNC_DF_64:
        case ZYDIS_MVEX_FUNC_DI_64:
        {
            static const ZyanU8 lookup[2][1] =
            {
                { 64 },
                {  8 }
            };
            ZYAN_ASSERT(index < 2);
            ZYAN_ASSERT(instruction->raw.mvex.SSS < ZYAN_ARRAY_LENGTH(lookup[index]));
            context->cd8_scale = lookup[index][instruction->raw.mvex.SSS];
            break;
        }
        default:
            ZYAN_UNREACHABLE;
        }

        // Rounding mode, sae, swizzle, convert
        context->mvex.functionality = def->functionality;
        switch (def->functionality)
        {
        case ZYDIS_MVEX_FUNC_IGNORED:
        case ZYDIS_MVEX_FUNC_INVALID:
        case ZYDIS_MVEX_FUNC_F_32:
        case ZYDIS_MVEX_FUNC_I_32:
        case ZYDIS_MVEX_FUNC_F_64:
        case ZYDIS_MVEX_FUNC_I_64:
            // Nothing to do here
            break;
        case ZYDIS_MVEX_FUNC_RC:
            instruction->avx.rounding.mode = ZYDIS_ROUNDING_MODE_RN + (instruction->raw.mvex.SSS & 3);
            ZYAN_FALLTHROUGH;
        case ZYDIS_MVEX_FUNC_SAE:
            if (instruction->raw.mvex.SSS >= 4)
            {
                instruction->avx.has_sae = ZYAN_TRUE;
            }
            break;
        case ZYDIS_MVEX_FUNC_SWIZZLE_32:
        case ZYDIS_MVEX_FUNC_SWIZZLE_64:
            instruction->avx.swizzle.mode = ZYDIS_SWIZZLE_MODE_DCBA + instruction->raw.mvex.SSS;
            break;
        case ZYDIS_MVEX_FUNC_SF_32:
        case ZYDIS_MVEX_FUNC_SF_32_BCST:
        case ZYDIS_MVEX_FUNC_SF_32_BCST_4TO16:
            switch (instruction->raw.mvex.SSS)
            {
            case 0:
                break;
            case 1:
                instruction->avx.broadcast.mode = ZYDIS_BROADCAST_MODE_1_TO_16;
                break;
            case 2:
                instruction->avx.broadcast.mode = ZYDIS_BROADCAST_MODE_4_TO_16;
                break;
            case 3:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_FLOAT16;
                break;
            case 4:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_UINT8;
                break;
            case 5:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_SINT8;
                break;
            case 6:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_UINT16;
                break;
            case 7:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_SINT16;
                break;
            default:
                ZYAN_UNREACHABLE;
            }
            break;
        case ZYDIS_MVEX_FUNC_SI_32:
        case ZYDIS_MVEX_FUNC_SI_32_BCST:
        case ZYDIS_MVEX_FUNC_SI_32_BCST_4TO16:
            switch (instruction->raw.mvex.SSS)
            {
            case 0:
                break;
            case 1:
                instruction->avx.broadcast.mode = ZYDIS_BROADCAST_MODE_1_TO_16;
                break;
            case 2:
                instruction->avx.broadcast.mode = ZYDIS_BROADCAST_MODE_4_TO_16;
                break;
            case 4:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_UINT8;
                break;
            case 5:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_SINT8;
                break;
            case 6:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_UINT16;
                break;
            case 7:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_SINT16;
                break;
            default:
                ZYAN_UNREACHABLE;
            }
            break;
        case ZYDIS_MVEX_FUNC_SF_64:
        case ZYDIS_MVEX_FUNC_SI_64:
            switch (instruction->raw.mvex.SSS)
            {
            case 0:
                break;
            case 1:
                instruction->avx.broadcast.mode = ZYDIS_BROADCAST_MODE_1_TO_8;
                break;
            case 2:
                instruction->avx.broadcast.mode = ZYDIS_BROADCAST_MODE_4_TO_8;
                break;
            default:
                ZYAN_UNREACHABLE;
            }
            break;
        case ZYDIS_MVEX_FUNC_UF_32:
        case ZYDIS_MVEX_FUNC_DF_32:
            switch (instruction->raw.mvex.SSS)
            {
            case 0:
                break;
            case 3:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_FLOAT16;
                break;
            case 4:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_UINT8;
                break;
            case 5:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_SINT8;
                break;
            case 6:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_UINT16;
                break;
            case 7:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_SINT16;
                break;
            default:
                ZYAN_UNREACHABLE;
            }
            break;
        case ZYDIS_MVEX_FUNC_UF_64:
        case ZYDIS_MVEX_FUNC_DF_64:
            break;
        case ZYDIS_MVEX_FUNC_UI_32:
        case ZYDIS_MVEX_FUNC_DI_32:
            switch (instruction->raw.mvex.SSS)
            {
            case 0:
                break;
            case 4:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_UINT8;
                break;
            case 5:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_SINT8;
                break;
            case 6:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_UINT16;
                break;
            case 7:
                instruction->avx.conversion.mode = ZYDIS_CONVERSION_MODE_SINT16;
                break;
            default:
                ZYAN_UNREACHABLE;
            }
            break;
        case ZYDIS_MVEX_FUNC_UI_64:
        case ZYDIS_MVEX_FUNC_DI_64:
            break;
        default:
            ZYAN_UNREACHABLE;
        }

        // Eviction hint
        if ((instruction->raw.modrm.mod != 3) && instruction->raw.mvex.E)
        {
            instruction->avx.has_eviction_hint = ZYAN_TRUE;
        }

        // Mask
        instruction->avx.mask.mode = ZYDIS_MASK_MODE_MERGING;
        instruction->avx.mask.reg = ZYDIS_REGISTER_K0 + instruction->raw.mvex.kkk;
#else
        ZYAN_UNREACHABLE;
#endif
        break;
    }
    default:
        // Nothing to do here
        break;
    }
}
#endif

/* ---------------------------------------------------------------------------------------------- */
/* Physical instruction decoding                                                                  */
/* ---------------------------------------------------------------------------------------------- */

/**
 * Collects optional instruction prefixes.
 *
 * @param   state     A pointer to the `ZydisDecoderState` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 *
 * @return  A zyan status code.
 *
 * This function sets the corresponding flag for each prefix and automatically decodes the last
 * `REX`-prefix (if exists).
 */
static ZyanStatus ZydisCollectOptionalPrefixes(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(instruction->raw.prefix_count == 0);

    ZyanU8 rex = 0x00;
    ZyanU8 offset = 0;
    ZyanBool done = ZYAN_FALSE;
    do
    {
        ZyanU8 prefix_byte;
        ZYAN_CHECK(ZydisInputPeek(state, instruction, &prefix_byte));
        switch (prefix_byte)
        {
        case 0xF0:
            state->prefixes.has_lock = ZYAN_TRUE;
            state->prefixes.offset_lock = offset;
            break;
        case 0xF2:
            ZYAN_FALLTHROUGH;
        case 0xF3:
            state->prefixes.group1 = prefix_byte;
            state->prefixes.mandatory_candidate = prefix_byte;
            state->prefixes.offset_group1 = offset;
            state->prefixes.offset_mandatory = offset;
            break;
        case 0x2E:
            ZYAN_FALLTHROUGH;
        case 0x36:
            ZYAN_FALLTHROUGH;
        case 0x3E:
            ZYAN_FALLTHROUGH;
        case 0x26:
            if (state->decoder->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
            {
                if ((prefix_byte == 0x3E) &&
                    (state->prefixes.effective_segment != 0x64) &&
                    (state->prefixes.effective_segment != 0x65))
                {
                    state->prefixes.offset_notrack = offset;
                }
                state->prefixes.group2 = prefix_byte;
                state->prefixes.offset_group2 = offset;
                break;
            }
            ZYAN_FALLTHROUGH;
        case 0x64:
            ZYAN_FALLTHROUGH;
        case 0x65:
            state->prefixes.group2 = prefix_byte;
            state->prefixes.offset_group2 = offset;
            state->prefixes.effective_segment = prefix_byte;
            state->prefixes.offset_segment = offset;
            state->prefixes.offset_notrack = -1;
            break;
        case 0x66:
            // context->prefixes.has_osz_override = ZYAN_TRUE;
            state->prefixes.offset_osz_override = offset;
            if (!state->prefixes.mandatory_candidate)
            {
                state->prefixes.mandatory_candidate = 0x66;
                state->prefixes.offset_mandatory = offset;
            }
            instruction->attributes |= ZYDIS_ATTRIB_HAS_OPERANDSIZE;
            break;
        case 0x67:
            // context->prefixes.has_asz_override = ZYAN_TRUE;
            state->prefixes.offset_asz_override = offset;
            instruction->attributes |= ZYDIS_ATTRIB_HAS_ADDRESSSIZE;
            break;
        default:
            if ((state->decoder->machine_mode == ZYDIS_MACHINE_MODE_LONG_64) &&
                (prefix_byte & 0xF0) == 0x40)
            {
                rex = prefix_byte;
                instruction->raw.rex.offset = offset;
            } else
            {
                done = ZYAN_TRUE;
            }
            break;
        }
        if (!done)
        {
            // Invalidate `REX`, if it's not the last legacy prefix
            if (rex && (rex != prefix_byte))
            {
                rex = 0x00;
                instruction->raw.rex.offset = 0;
            }
            instruction->raw.prefixes[instruction->raw.prefix_count++].value = prefix_byte;
            ZydisInputSkip(state, instruction);
            ++offset;
        }
    } while (!done);

    if (instruction->attributes & ZYDIS_ATTRIB_HAS_OPERANDSIZE)
    {
        instruction->raw.prefixes[state->prefixes.offset_osz_override].type =
            ZYDIS_PREFIX_TYPE_EFFECTIVE;
    }
    if (instruction->attributes & ZYDIS_ATTRIB_HAS_ADDRESSSIZE)
    {
        instruction->raw.prefixes[state->prefixes.offset_asz_override].type =
            ZYDIS_PREFIX_TYPE_EFFECTIVE;
    }
    if (rex)
    {
        instruction->raw.prefixes[instruction->raw.rex.offset].type = ZYDIS_PREFIX_TYPE_EFFECTIVE;
        ZydisDecodeREX(state->context, instruction, rex);
    }
    if ((state->decoder->machine_mode != ZYDIS_MACHINE_MODE_LONG_64) &&
        (state->prefixes.group2 == 0x3E))
    {
        state->prefixes.offset_notrack = state->prefixes.offset_group2;
    }

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Decodes optional instruction parts like the ModRM byte, the SIB byte and
 * additional displacements and/or immediate values.
 *
 * @param   state       A pointer to the `ZydisDecoderState` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   info        A pointer to the `ZydisInstructionEncodingInfo` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisDecodeOptionalInstructionParts(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, const ZydisInstructionEncodingInfo* info)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(info);

    ZydisDecoderContext* context = state->context;

    if (info->flags & ZYDIS_INSTR_ENC_FLAG_HAS_MODRM)
    {
        if (!instruction->raw.modrm.offset)
        {
            instruction->raw.modrm.offset = instruction->length;
            ZyanU8 modrm_byte;
            ZYAN_CHECK(ZydisInputNext(state, instruction, &modrm_byte));
            ZydisDecodeModRM(instruction, modrm_byte);
        }

        if (!(info->flags & ZYDIS_INSTR_ENC_FLAG_FORCE_REG_FORM))
        {
            ZyanU8 has_sib = 0;
            ZyanU8 displacement_size = 0;
            switch (instruction->address_width)
            {
            case 16:
                switch (instruction->raw.modrm.mod)
                {
                case 0:
                    if (instruction->raw.modrm.rm == 6)
                    {
                        displacement_size = 16;
                    }
                    break;
                case 1:
                    displacement_size = 8;
                    break;
                case 2:
                    displacement_size = 16;
                    break;
                case 3:
                    break;
                default:
                    ZYAN_UNREACHABLE;
                }
                break;
            case 32:
            case 64:
                has_sib =
                    (instruction->raw.modrm.mod != 3) && (instruction->raw.modrm.rm == 4);
                switch (instruction->raw.modrm.mod)
                {
                case 0:
                    if (instruction->raw.modrm.rm == 5)
                    {
                        if (instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
                        {
                            instruction->attributes |= ZYDIS_ATTRIB_IS_RELATIVE;
                        }
                        displacement_size = 32;
                    }
                    break;
                case 1:
                    displacement_size = 8;
                    break;
                case 2:
                    displacement_size = 32;
                    break;
                case 3:
                    break;
                default:
                    ZYAN_UNREACHABLE;
                }
                break;
            default:
                ZYAN_UNREACHABLE;
            }
            if (has_sib)
            {
                instruction->raw.sib.offset = instruction->length;
                ZyanU8 sib_byte;
                ZYAN_CHECK(ZydisInputNext(state, instruction, &sib_byte));
                ZydisDecodeSIB(instruction, sib_byte);
                if (instruction->raw.sib.base == 5)
                {
                    displacement_size = (instruction->raw.modrm.mod == 1) ? 8 : 32;
                }
            }
            if (displacement_size)
            {
                ZYAN_CHECK(ZydisReadDisplacement(state, instruction, displacement_size));
            }
        }

        context->reg_info.is_mod_reg = (instruction->raw.modrm.mod == 3) ||
                                       (info->flags & ZYDIS_INSTR_ENC_FLAG_FORCE_REG_FORM);
    }

    if (info->flags & ZYDIS_INSTR_ENC_FLAG_HAS_DISP)
    {
        ZYAN_CHECK(ZydisReadDisplacement(
            state, instruction, info->disp.size[context->easz_index]));
    }

    if (info->flags & ZYDIS_INSTR_ENC_FLAG_HAS_IMM0)
    {
        if (info->imm[0].is_relative)
        {
            instruction->attributes |= ZYDIS_ATTRIB_IS_RELATIVE;
        }
        ZYAN_CHECK(ZydisReadImmediate(state, instruction, 0,
            info->imm[0].size[context->eosz_index], info->imm[0].is_signed,
            info->imm[0].is_relative));
    }

    if (info->flags & ZYDIS_INSTR_ENC_FLAG_HAS_IMM1)
    {
        ZYAN_ASSERT(!(info->flags & ZYDIS_INSTR_ENC_FLAG_HAS_DISP));
        ZYAN_CHECK(ZydisReadImmediate(state, instruction, 1,
            info->imm[1].size[context->eosz_index], info->imm[1].is_signed,
            info->imm[1].is_relative));
    }

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */

/**
 * Sets the effective operand size for the given instruction.
 *
 * @param   context     A pointer to the `ZydisDecoderContext` struct
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   definition  A pointer to the `ZydisInstructionDefinition` struct.
 */
static void ZydisSetEffectiveOperandWidth(ZydisDecoderContext* context,
    ZydisDecodedInstruction* instruction, const ZydisInstructionDefinition* definition)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(definition);

    static const ZyanU8 operand_size_map[8][8] =
    {
        // Default for most instructions
        {
            16, // 16 __ W0
            32, // 16 66 W0
            32, // 32 __ W0
            16, // 32 66 W0
            32, // 64 __ W0
            16, // 64 66 W0
            64, // 64 __ W1
            64  // 64 66 W1
        },
        // Operand size is forced to 8-bit (this is done later to preserve the `eosz_index`)
        {
            16, // 16 __ W0
            32, // 16 66 W0
            32, // 32 __ W0
            16, // 32 66 W0
            32, // 64 __ W0
            16, // 64 66 W0
            64, // 64 __ W1
            64  // 64 66 W1
        },
        // Operand size override 0x66 is ignored
        {
            16, // 16 __ W0
            16, // 16 66 W0
            32, // 32 __ W0
            32, // 32 66 W0
            32, // 64 __ W0
            32, // 64 66 W0
            64, // 64 __ W1
            64  // 64 66 W1
        },
        // REX.W promotes to 32-bit instead of 64-bit
        {
            16, // 16 __ W0
            32, // 16 66 W0
            32, // 32 __ W0
            16, // 32 66 W0
            32, // 64 __ W0
            16, // 64 66 W0
            32, // 64 __ W1
            32  // 64 66 W1
        },
        // Operand size defaults to 64-bit in 64-bit mode
        {
            16, // 16 __ W0
            32, // 16 66 W0
            32, // 32 __ W0
            16, // 32 66 W0
            64, // 64 __ W0
            16, // 64 66 W0
            64, // 64 __ W1
            64  // 64 66 W1
        },
        // Operand size is forced to 64-bit in 64-bit mode
        {
            16, // 16 __ W0
            32, // 16 66 W0
            32, // 32 __ W0
            16, // 32 66 W0
            64, // 64 __ W0
            64, // 64 66 W0
            64, // 64 __ W1
            64  // 64 66 W1
        },
        // Operand size is forced to 32-bit, if no REX.W is present.
        {
            32, // 16 __ W0
            32, // 16 66 W0
            32, // 32 __ W0
            32, // 32 66 W0
            32, // 64 __ W0
            32, // 64 66 W0
            64, // 64 __ W1
            64  // 64 66 W1
        },
        // Operand size is forced to 64-bit in 64-bit mode and forced to 32-bit in all other modes.
        // This is used for e.g. `mov CR, GPR` and `mov GPR, CR`.
        {
            32, // 16 __ W0
            32, // 16 66 W0
            32, // 32 __ W0
            32, // 32 66 W0
            64, // 64 __ W0
            64, // 64 66 W0
            64, // 64 __ W1
            64  // 64 66 W1
        }
    };

    ZyanU8 index = (instruction->attributes & ZYDIS_ATTRIB_HAS_OPERANDSIZE) ? 1 : 0;
    if ((instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_COMPAT_32) ||
        (instruction->machine_mode == ZYDIS_MACHINE_MODE_LEGACY_32))
    {
        index += 2;
    }
    else if (instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
    {
        index += 4;
        index += (context->vector_unified.W & 0x01) << 1;
    }

    ZYAN_ASSERT(definition->operand_size_map < ZYAN_ARRAY_LENGTH(operand_size_map));
    ZYAN_ASSERT(index < ZYAN_ARRAY_LENGTH(operand_size_map[definition->operand_size_map]));

    instruction->operand_width = operand_size_map[definition->operand_size_map][index];
    context->eosz_index = instruction->operand_width >> 5;

    // TODO: Cleanup code and remove hardcoded condition
    if (definition->operand_size_map == 1)
    {
        instruction->operand_width = 8;
    }
}

/**
 * Sets the effective address width for the given instruction.
 *
 * @param   context     A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   definition  A pointer to the `ZydisInstructionDefinition` struct.
 */
static void ZydisSetEffectiveAddressWidth(ZydisDecoderContext* context,
    ZydisDecodedInstruction* instruction, const ZydisInstructionDefinition* definition)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(instruction);

    static const ZyanU8 address_size_map[3][8] =
    {
        // Default for most instructions
        {
            16, // 16 __
            32, // 16 67
            32, // 32 __
            16, // 32 67
            64, // 64 __
            32  // 64 67
        },
        // The address-size override is ignored
        {
            16, // 16 __
            16, // 16 67
            32, // 32 __
            32, // 32 67
            64, // 64 __
            64  // 64 67
        },
        // The address-size is forced to 64-bit in 64-bit mode and 32-bit in non 64-bit mode. This
        // is used by e.g. `ENCLS`, `ENCLV`, `ENCLU`.
        {
            32, // 16 __
            32, // 16 67
            32, // 32 __
            32, // 32 67
            64, // 64 __
            64  // 64 67
        }
    };

    ZyanU8 index = (instruction->attributes & ZYDIS_ATTRIB_HAS_ADDRESSSIZE) ? 1 : 0;
    if ((instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_COMPAT_32) ||
        (instruction->machine_mode == ZYDIS_MACHINE_MODE_LEGACY_32))
    {
        index += 2;
    }
    else if (instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
    {
        index += 4;
    }

    ZYAN_ASSERT(definition->address_size_map < ZYAN_ARRAY_LENGTH(address_size_map));
    ZYAN_ASSERT(index < ZYAN_ARRAY_LENGTH(address_size_map[definition->address_size_map]));

    instruction->address_width = address_size_map[definition->address_size_map][index];
    context->easz_index = instruction->address_width >> 5;
}

/* ---------------------------------------------------------------------------------------------- */

static ZyanStatus ZydisNodeHandlerXOP(const ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    switch (instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
        *index = 0;
        break;
    case ZYDIS_INSTRUCTION_ENCODING_XOP:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_XOP);
        *index = (instruction->raw.xop.m_mmmm - 0x08) + (instruction->raw.xop.pp * 3) + 1;
        break;
    default:
        ZYAN_UNREACHABLE;
    }
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerVEX(const ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    switch (instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
        *index = 0;
        break;
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_VEX);
        *index = instruction->raw.vex.m_mmmm + (instruction->raw.vex.pp << 2) + 1;
        break;
    default:
        ZYAN_UNREACHABLE;
    }
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerEMVEX(const ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    switch (instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
        *index = 0;
        break;
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_EVEX);
        *index = instruction->raw.evex.mmm + (instruction->raw.evex.pp << 3) + 1;
        break;
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_MVEX);
        *index = instruction->raw.mvex.mmmm + (instruction->raw.mvex.pp << 2) + 33;
        break;
    default:
        ZYAN_UNREACHABLE;
    }
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerOpcode(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    // Handle possible encoding-prefix and opcode-map changes
    switch (instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
        ZYAN_CHECK(ZydisInputNext(state, instruction, &instruction->opcode));
        switch (instruction->opcode_map)
        {
        case ZYDIS_OPCODE_MAP_DEFAULT:
            switch (instruction->opcode)
            {
            case 0x0F:
                instruction->opcode_map = ZYDIS_OPCODE_MAP_0F;
                break;
            case 0xC4:
            case 0xC5:
            case 0x62:
            {
                ZyanU8 next_input;
                ZYAN_CHECK(ZydisInputPeek(state, instruction, &next_input));
                if (((next_input & 0xF0) >= 0xC0) ||
                    (instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_64))
                {
                    if (instruction->attributes & ZYDIS_ATTRIB_HAS_REX)
                    {
                        return ZYDIS_STATUS_ILLEGAL_REX;
                    }
                    if (state->prefixes.has_lock)
                    {
                        return ZYDIS_STATUS_ILLEGAL_LOCK;
                    }
                    if (state->prefixes.mandatory_candidate)
                    {
                        return ZYDIS_STATUS_ILLEGAL_LEGACY_PFX;
                    }
                    ZyanU8 prefix_bytes[4] = { 0, 0, 0, 0 };
                    prefix_bytes[0] = instruction->opcode;
                    switch (instruction->opcode)
                    {
                    case 0xC4:
                        instruction->raw.vex.offset = instruction->length - 1;
                        // Read additional 3-byte VEX-prefix data
                        ZYAN_ASSERT(!(instruction->attributes & ZYDIS_ATTRIB_HAS_VEX));
                        ZYAN_CHECK(ZydisInputNextBytes(state, instruction, &prefix_bytes[1], 2));
                        break;
                    case 0xC5:
                        instruction->raw.vex.offset = instruction->length - 1;
                        // Read additional 2-byte VEX-prefix data
                        ZYAN_ASSERT(!(instruction->attributes & ZYDIS_ATTRIB_HAS_VEX));
                        ZYAN_CHECK(ZydisInputNext(state, instruction, &prefix_bytes[1]));
                        break;
                    case 0x62:
#if !defined(ZYDIS_DISABLE_AVX512) || !defined(ZYDIS_DISABLE_KNC)
                        // Read additional EVEX/MVEX-prefix data
                        ZYAN_ASSERT(!(instruction->attributes & ZYDIS_ATTRIB_HAS_EVEX));
                        ZYAN_ASSERT(!(instruction->attributes & ZYDIS_ATTRIB_HAS_MVEX));
                        ZYAN_CHECK(ZydisInputNextBytes(state, instruction, &prefix_bytes[1], 3));
                        break;
#else
                        return ZYDIS_STATUS_DECODING_ERROR;
#endif
                    default:
                        ZYAN_UNREACHABLE;
                    }
                    switch (instruction->opcode)
                    {
                    case 0xC4:
                    case 0xC5:
                        // Decode VEX-prefix
                        instruction->encoding = ZYDIS_INSTRUCTION_ENCODING_VEX;
                        ZYAN_CHECK(ZydisDecodeVEX(state->context, instruction, prefix_bytes));
                        instruction->opcode_map =
                            ZYDIS_OPCODE_MAP_DEFAULT + instruction->raw.vex.m_mmmm;
                        break;
                    case 0x62:
#if defined(ZYDIS_DISABLE_AVX512) && defined(ZYDIS_DISABLE_KNC)
                        return ZYDIS_STATUS_DECODING_ERROR;
#else
                        switch ((prefix_bytes[2] >> 2) & 0x01)
                        {
                        case 0:
#ifndef ZYDIS_DISABLE_KNC
                            instruction->raw.mvex.offset = instruction->length - 4;
                            // `KNC` instructions are only valid in 64-bit mode.
                            // This condition catches the `MVEX` encoded ones to save a bunch of
                            // `mode` filters in the data-tables.
                            // `KNC` instructions with `VEX` encoding still require a `mode` filter.
                            if (state->decoder->machine_mode != ZYDIS_MACHINE_MODE_LONG_64)
                            {
                                return ZYDIS_STATUS_DECODING_ERROR;
                            }
                            // Decode MVEX-prefix
                            instruction->encoding = ZYDIS_INSTRUCTION_ENCODING_MVEX;
                            ZYAN_CHECK(ZydisDecodeMVEX(state->context, instruction, prefix_bytes));
                            instruction->opcode_map =
                                ZYDIS_OPCODE_MAP_DEFAULT + instruction->raw.mvex.mmmm;
                            break;
#else
                            return ZYDIS_STATUS_DECODING_ERROR;
#endif
                        case 1:
#ifndef ZYDIS_DISABLE_AVX512
                            instruction->raw.evex.offset = instruction->length - 4;
                            // Decode EVEX-prefix
                            instruction->encoding = ZYDIS_INSTRUCTION_ENCODING_EVEX;
                            ZYAN_CHECK(ZydisDecodeEVEX(state->context, instruction, prefix_bytes));
                            instruction->opcode_map =
                                ZYDIS_OPCODE_MAP_DEFAULT + instruction->raw.evex.mmm;
                            break;
#else
                            return ZYDIS_STATUS_DECODING_ERROR;
#endif
                        default:
                            ZYAN_UNREACHABLE;
                        }
                        break;
#endif
                    default:
                        ZYAN_UNREACHABLE;
                    }
                }
                break;
            }
            case 0x8F:
            {
                ZyanU8 next_input;
                ZYAN_CHECK(ZydisInputPeek(state, instruction, &next_input));
                if ((next_input & 0x1F) >= 8)
                {
                    if (instruction->attributes & ZYDIS_ATTRIB_HAS_REX)
                    {
                        return ZYDIS_STATUS_ILLEGAL_REX;
                    }
                    if (state->prefixes.has_lock)
                    {
                        return ZYDIS_STATUS_ILLEGAL_LOCK;
                    }
                    if (state->prefixes.mandatory_candidate)
                    {
                        return ZYDIS_STATUS_ILLEGAL_LEGACY_PFX;
                    }
                    instruction->raw.xop.offset = instruction->length - 1;
                    ZyanU8 prefixBytes[3] = { 0x8F, 0x00, 0x00 };
                    // Read additional xop-prefix data
                    ZYAN_CHECK(ZydisInputNextBytes(state, instruction, &prefixBytes[1], 2));
                    // Decode xop-prefix
                    instruction->encoding = ZYDIS_INSTRUCTION_ENCODING_XOP;
                    ZYAN_CHECK(ZydisDecodeXOP(state->context, instruction, prefixBytes));
                    instruction->opcode_map =
                        ZYDIS_OPCODE_MAP_XOP8 + instruction->raw.xop.m_mmmm - 0x08;
                }
                break;
            }
            default:
                break;
            }
            break;
        case ZYDIS_OPCODE_MAP_0F:
            switch (instruction->opcode)
            {
            case 0x0F:
                if (state->prefixes.has_lock)
                {
                    return ZYDIS_STATUS_ILLEGAL_LOCK;
                }
                instruction->encoding = ZYDIS_INSTRUCTION_ENCODING_3DNOW;
                instruction->opcode_map = ZYDIS_OPCODE_MAP_0F0F;
                break;
            case 0x38:
                instruction->opcode_map = ZYDIS_OPCODE_MAP_0F38;
                break;
            case 0x3A:
                instruction->opcode_map = ZYDIS_OPCODE_MAP_0F3A;
                break;
            default:
                break;
            }
            break;
        case ZYDIS_OPCODE_MAP_0F38:
        case ZYDIS_OPCODE_MAP_0F3A:
        case ZYDIS_OPCODE_MAP_XOP8:
        case ZYDIS_OPCODE_MAP_XOP9:
        case ZYDIS_OPCODE_MAP_XOPA:
            // Nothing to do here
            break;
        default:
            ZYAN_UNREACHABLE;
        }
        break;
    case ZYDIS_INSTRUCTION_ENCODING_3DNOW:
        // All 3DNOW (0x0F 0x0F) instructions are using the same operand encoding. We just
        // decode a random (pi2fw) instruction and extract the actual opcode later.
        *index = 0x0C;
        return ZYAN_STATUS_SUCCESS;
    default:
        ZYAN_CHECK(ZydisInputNext(state, instruction, &instruction->opcode));
        break;
    }

    *index = instruction->opcode;
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerMode(const ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    switch (instruction->machine_mode)
    {
    case ZYDIS_MACHINE_MODE_LONG_COMPAT_16:
    case ZYDIS_MACHINE_MODE_LEGACY_16:
    case ZYDIS_MACHINE_MODE_REAL_16:
        *index = 0;
        break;
    case ZYDIS_MACHINE_MODE_LONG_COMPAT_32:
    case ZYDIS_MACHINE_MODE_LEGACY_32:
        *index = 1;
        break;
    case ZYDIS_MACHINE_MODE_LONG_64:
        *index = 2;
        break;
    default:
        ZYAN_UNREACHABLE;
    }
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerModeCompact(const ZydisDecodedInstruction* instruction,
    ZyanU16* index)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    *index = (instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_64) ? 0 : 1;
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerModrmMod(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    if (!instruction->raw.modrm.offset)
    {
        instruction->raw.modrm.offset = instruction->length;
        ZyanU8 modrm_byte;
        ZYAN_CHECK(ZydisInputNext(state, instruction, &modrm_byte));
        ZydisDecodeModRM(instruction, modrm_byte);
    }
    *index = instruction->raw.modrm.mod;
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerModrmModCompact(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_CHECK(ZydisNodeHandlerModrmMod(state, instruction, index));
    *index = (*index == 0x3) ? 0 : 1;
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerModrmReg(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    if (!instruction->raw.modrm.offset)
    {
        instruction->raw.modrm.offset = instruction->length;
        ZyanU8 modrm_byte;
        ZYAN_CHECK(ZydisInputNext(state, instruction, &modrm_byte));
        ZydisDecodeModRM(instruction, modrm_byte);
    }
    *index = instruction->raw.modrm.reg;
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerModrmRm(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    if (!instruction->raw.modrm.offset)
    {
        instruction->raw.modrm.offset = instruction->length;
        ZyanU8 modrm_byte;
        ZYAN_CHECK(ZydisInputNext(state, instruction, &modrm_byte));
        ZydisDecodeModRM(instruction, modrm_byte);
    }
    *index = instruction->raw.modrm.rm;
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerMandatoryPrefix(const ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    switch (state->prefixes.mandatory_candidate)
    {
    case 0x66:
        instruction->raw.prefixes[state->prefixes.offset_mandatory].type =
            ZYDIS_PREFIX_TYPE_MANDATORY;
        instruction->attributes &= ~ZYDIS_ATTRIB_HAS_OPERANDSIZE;
        *index = 2;
        break;
    case 0xF3:
        instruction->raw.prefixes[state->prefixes.offset_mandatory].type =
            ZYDIS_PREFIX_TYPE_MANDATORY;
        *index = 3;
        break;
    case 0xF2:
        instruction->raw.prefixes[state->prefixes.offset_mandatory].type =
            ZYDIS_PREFIX_TYPE_MANDATORY;
        *index = 4;
        break;
    default:
        *index = 1;
        break;
    }
    // TODO: Consume prefix and make sure it's available again, if we need to fallback

    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerOperandSize(const ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    if ((instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_64) &&
        (state->context->vector_unified.W))
    {
        *index = 2;
    } else
    {
        if (instruction->attributes & ZYDIS_ATTRIB_HAS_OPERANDSIZE)
        {
            instruction->raw.prefixes[state->prefixes.offset_osz_override].type =
                ZYDIS_PREFIX_TYPE_EFFECTIVE;
        }
        switch (instruction->machine_mode)
        {
        case ZYDIS_MACHINE_MODE_LONG_COMPAT_16:
        case ZYDIS_MACHINE_MODE_LEGACY_16:
        case ZYDIS_MACHINE_MODE_REAL_16:
            *index = (instruction->attributes & ZYDIS_ATTRIB_HAS_OPERANDSIZE) ? 1 : 0;
            break;
        case ZYDIS_MACHINE_MODE_LONG_COMPAT_32:
        case ZYDIS_MACHINE_MODE_LEGACY_32:
        case ZYDIS_MACHINE_MODE_LONG_64:
            *index = (instruction->attributes & ZYDIS_ATTRIB_HAS_OPERANDSIZE) ? 0 : 1;
            break;
        default:
            ZYAN_UNREACHABLE;
        }
    }

    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerAddressSize(ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    /*if (instruction->attributes & ZYDIS_ATTRIB_HAS_ADDRESSSIZE)
    {
        instruction->raw.prefixes[context->prefixes.offset_asz_override].type =
            ZYDIS_PREFIX_TYPE_EFFECTIVE;
    }*/
    switch (instruction->machine_mode)
    {
    case ZYDIS_MACHINE_MODE_LONG_COMPAT_16:
    case ZYDIS_MACHINE_MODE_LEGACY_16:
    case ZYDIS_MACHINE_MODE_REAL_16:
        *index = (instruction->attributes & ZYDIS_ATTRIB_HAS_ADDRESSSIZE) ? 1 : 0;
        break;
    case ZYDIS_MACHINE_MODE_LONG_COMPAT_32:
    case ZYDIS_MACHINE_MODE_LEGACY_32:
        *index = (instruction->attributes & ZYDIS_ATTRIB_HAS_ADDRESSSIZE) ? 0 : 1;
        break;
    case ZYDIS_MACHINE_MODE_LONG_64:
        *index = (instruction->attributes & ZYDIS_ATTRIB_HAS_ADDRESSSIZE) ? 1 : 2;
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerVectorLength(const ZydisDecoderContext* context,
    const ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    switch (instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_XOP:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_XOP);
        break;
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_VEX);
        break;
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_EVEX);
        break;
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_MVEX);
        break;
    default:
        ZYAN_UNREACHABLE;
    }

    *index = context->vector_unified.LL;
    if (*index == 3)
    {
        return ZYDIS_STATUS_DECODING_ERROR;
    }
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerRexW(const ZydisDecoderContext* context,
    const ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    switch (instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
        // nothing to do here
        break;
    case ZYDIS_INSTRUCTION_ENCODING_XOP:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_XOP);
        break;
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_VEX);
        break;
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_EVEX);
        break;
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_MVEX);
        break;
    default:
        ZYAN_UNREACHABLE;
    }
    *index = context->vector_unified.W;
    return ZYAN_STATUS_SUCCESS;
}

static ZyanStatus ZydisNodeHandlerRexB(const ZydisDecoderContext* context,
    const ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    switch (instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
        // nothing to do here
        break;
    case ZYDIS_INSTRUCTION_ENCODING_XOP:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_XOP);
        break;
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_VEX);
        break;
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_EVEX);
        break;
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
        ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_MVEX);
        break;
    default:
        ZYAN_UNREACHABLE;
    }
    *index = context->vector_unified.B;
    return ZYAN_STATUS_SUCCESS;
}

#ifndef ZYDIS_DISABLE_AVX512
static ZyanStatus ZydisNodeHandlerEvexB(const ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    ZYAN_ASSERT(instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX);
    ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_EVEX);
    *index = instruction->raw.evex.b;
    return ZYAN_STATUS_SUCCESS;
}
#endif

#ifndef ZYDIS_DISABLE_KNC
static ZyanStatus ZydisNodeHandlerMvexE(const ZydisDecodedInstruction* instruction, ZyanU16* index)
{
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(index);

    ZYAN_ASSERT(instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX);
    ZYAN_ASSERT(instruction->attributes & ZYDIS_ATTRIB_HAS_MVEX);
    *index = instruction->raw.mvex.E;
    return ZYAN_STATUS_SUCCESS;
}
#endif

/* ---------------------------------------------------------------------------------------------- */

/**
 * Populates the internal register id fields for `REG`, `RM`, `NDSNDD`, `BASE` and `INDEX`/`VIDX`
 * encoded operands and performs sanity checks.
 *
 * @param   context     A pointer to the `ZydisDecoderContext` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   def_reg     The type definition for the `.reg` encoded operand.
 * @param   def_rm      The type definition for the `.rm` encoded operand.
 * @param   def_ndsndd  The type definition for the `.vvvv` encoded operand.
 *
 * @return  A zyan status code.
 *
 * This function sets all unused register ids to `-1`. This rule does currently not apply to
 * `base` and `index`.
 *
 * Definition encoding:
 * - `def_reg`    -> `ZydisRegisterKind`
 * - `def_ndsndd` -> `ZydisRegisterKind`
 * - `def_rm`     -> `ZydisRegisterKind` (`.mod == 3`) or ZydisMemoryOperandType (`.mod != 3`)
 */
static ZyanStatus ZydisPopulateRegisterIds(ZydisDecoderContext* context,
    const ZydisDecodedInstruction* instruction, ZyanU8 def_reg, ZyanU8 def_rm, ZyanU8 def_ndsndd)
{
    ZYAN_ASSERT(context);
    ZYAN_ASSERT(instruction);

    const ZyanBool is_64_bit = (instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_64);
    const ZyanBool is_reg    = context->reg_info.is_mod_reg;
    const ZyanBool has_sib   = !is_reg && (instruction->raw.modrm.rm == 4);
    const ZyanBool has_vsib  = has_sib && (def_rm == ZYDIS_MEMOP_TYPE_VSIB);

    ZyanU8 id_reg    = instruction->raw.modrm.reg;
    ZyanU8 id_rm     = instruction->raw.modrm.rm;
    ZyanU8 id_ndsndd = is_64_bit ? context->vector_unified.vvvv : context->vector_unified.vvvv & 0x07;
    ZyanU8 id_base   = has_sib ? instruction->raw.sib.base : instruction->raw.modrm.rm;
    ZyanU8 id_index  = instruction->raw.sib.index;

    if (instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_64)
    {
        const ZyanBool is_emvex = (instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX) ||
                                  (instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX);

        // The `index` extension by `.v'` is only valid for VSIB operands
        const ZyanU8 vsib_v2 = has_vsib ? context->vector_unified.V2 : 0;
        // The `rm` extension by `.X` is only valid for EVEX/MVEX instructions
        const ZyanU8 evex_x  = is_emvex ? context->vector_unified.X  : 0;

        id_reg    |= (context->vector_unified.R2 << 4) | (context->vector_unified.R << 3);
        id_rm     |= (evex_x                     << 4) | (context->vector_unified.B << 3);
        id_ndsndd |= (context->vector_unified.V2 << 4)                                   ;
        id_base   |=                                     (context->vector_unified.B << 3);
        id_index  |= (vsib_v2                    << 4) | (context->vector_unified.X << 3);

        // The masking emulates the actual CPU behavior and does not verify if the resulting ids
        // are actually valid for the given register kind.

        static const ZyanU8 mask_reg[ZYDIS_REGKIND_MAX_VALUE + 1] =
        {
            /* INVALID */ 0,
            /* GPR     */ (1 << 5) - 1,
            /* X87     */ (1 << 3) - 1, // ignore `.R`, ignore `.R'`
            /* MMX     */ (1 << 3) - 1, // ignore `.R`, ignore `.R'`
            /* VR      */ (1 << 5) - 1,
            /* TMM     */ (1 << 5) - 1,
            /* SEGMENT */ (1 << 3) - 1, // ignore `.R`, ignore `.R'`
            /* TEST    */ (1 << 3) - 1, // ignore `.R`, ignore `.R'`
            /* CONTROL */ (1 << 4) - 1, //              ignore `.R'`
            /* DEBUG   */ (1 << 4) - 1, //              ignore `.R'`
            /* MASK    */ (1 << 5) - 1,
            /* BOUND   */ (1 << 4) - 1  //              ignore `.R'`
        };
        id_reg &= mask_reg[def_reg];

        static const ZyanU8 mask_rm[ZYDIS_REGKIND_MAX_VALUE + 1] =
        {
            /* INVALID */ 0,
            /* GPR     */ (1 << 4) - 1, //              ignore `.X`
            /* X87     */ (1 << 3) - 1, // ignore `.B`, ignore `.X`
            /* MMX     */ (1 << 3) - 1, // ignore `.B`, ignore `.X`
            /* VR      */ (1 << 5) - 1,
            /* TMM     */ (1 << 4) - 1, //              ignore `.X`
            /* SEGMENT */ (1 << 3) - 1, // ignore `.B`, ignore `.X`
            /* TEST    */ (1 << 3) - 1, // ignore `.B`, ignore `.X`
            /* CONTROL */ (1 << 4) - 1, //              ignore `.X`
            /* DEBUG   */ (1 << 4) - 1, //              ignore `.X`
            /* MASK    */ (1 << 3) - 1, // ignore `.B`, ignore `.X`
            /* BOUND   */ (1 << 4) - 1  //              ignore `.X`
        };
        id_rm &= (is_reg ? mask_rm[def_rm] : 0xFF);

        // Commented out for future reference. Not required at the moment as it's always either
        // a "take all" or "take nothing" situation.

        //static const ZyanU8 mask_ndsndd[ZYDIS_REGKIND_MAX_VALUE + 1] =
        //{
        //    /* INVALID */ 0,
        //    /* GPR     */ (1 << 5) - 1,
        //    /* X87     */ 0,            // never encoded in `.vvvv`
        //    /* MMX     */ 0,            // never encoded in `.vvvv`
        //    /* VR      */ (1 << 5) - 1,
        //    /* TMM     */ (1 << 5) - 1,
        //    /* SEGMENT */ 0,            // never encoded in `.vvvv`
        //    /* TEST    */ 0,            // never encoded in `.vvvv`
        //    /* CONTROL */ 0,            // never encoded in `.vvvv`
        //    /* DEBUG   */ 0,            // never encoded in `.vvvv`
        //    /* MASK    */ (1 << 5) - 1,
        //    /* BOUND   */ 0             // never encoded in `.vvvv`
        //};
    }

    // Validate

    // `.vvvv` is not allowed, if the instruction does not encode a NDS/NDD operand
    if (!def_ndsndd && context->vector_unified.vvvv)
    {
        return ZYDIS_STATUS_BAD_REGISTER;
    }
    // `.v'` is not allowed, if the instruction does not encode a NDS/NDD or VSIB operand
    if (!def_ndsndd && !has_vsib && context->vector_unified.V2)
    {
        return ZYDIS_STATUS_BAD_REGISTER;
    }

    static const ZyanU8 available_regs[2][ZYDIS_REGKIND_MAX_VALUE + 1] =
    {
        // 16/32 bit mode
        {
            /* INVALID */ 255,
            /* GPR     */   8,
            /* X87     */   8,
            /* MMX     */   8,
            /* VR      */   8,
            /* TMM     */   8,
            /* SEGMENT */   6,
            /* TEST    */   8,
            /* CONTROL */   8,
            /* DEBUG   */   8,
            /* MASK    */   8,
            /* BOUND   */   4
        },
        // 64 bit mode
        {
            /* INVALID */ 255,
            /* GPR     */  16,
            /* X87     */   8,
            /* MMX     */   8,
            /* VR      */  32,
            /* TMM     */   8,
            /* SEGMENT */   6,
            /* TEST    */   8,
            /* CONTROL */  16,
            // Attempts to reference DR8..DR15 result in undefined opcode (#UD) exceptions. DR4 and
            // DR5 are only valid, if the debug extension (DE) flag in CR4 is set. As we can't
            // check this at runtime we just allow them.
            /* DEBUG   */   8,
            /* MASK    */   8,
            /* BOUND   */   4
        }
    };

    if ((id_reg >= available_regs[is_64_bit][def_reg]) ||
        (id_ndsndd >= available_regs[is_64_bit][def_ndsndd]) ||
        (is_reg && (id_rm >= available_regs[is_64_bit][def_rm])))
    {
        return ZYDIS_STATUS_BAD_REGISTER;
    }

    ZyanI8 id_cr = -1;
    if (def_reg == ZYDIS_REGKIND_CONTROL)
    {
        id_cr = id_reg;
    }
    if (is_reg && (def_rm == ZYDIS_REGKIND_CONTROL))
    {
        id_cr = id_rm;
    }
    if (id_cr >= 0)
    {
        // Attempts to reference CR1, CR5, CR6, CR7, and CR9..CR15 result in undefined opcode (#UD)
        // exceptions
        static const ZyanU8 lookup[16] =
        {
            1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0
        };
        ZYAN_ASSERT((ZyanUSize)id_cr < ZYAN_ARRAY_LENGTH(lookup));
        if (!lookup[id_cr])
        {
            return ZYDIS_STATUS_BAD_REGISTER;
        }
    }

    // Assign to context

    context->reg_info.id_reg    = def_reg          ? id_reg    : -1;
    context->reg_info.id_rm     = def_rm && is_reg ? id_rm     : -1;
    context->reg_info.id_ndsndd = def_ndsndd       ? id_ndsndd : -1;
    context->reg_info.id_base   = id_base;  // TODO: Set unused register to -1 as well
    context->reg_info.id_index  = id_index; // TODO: Set unused register to -1 as well

    return ZYAN_STATUS_SUCCESS;
}

/**
 * Checks for certain post-decode error-conditions.
 *
 * @param   state       A pointer to the `ZydisDecoderState` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 * @param   definition  A pointer to the `ZydisInstructionDefinition` struct.
 *
 * @return  A zyan status code.
 *
 * This function is called immediately after a valid instruction-definition was found.
 */
static ZyanStatus ZydisCheckErrorConditions(ZydisDecoderState* state,
    const ZydisDecodedInstruction* instruction, const ZydisInstructionDefinition* definition)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);
    ZYAN_ASSERT(definition);

    ZyanU8 def_reg                  = definition->op_reg;
    ZyanU8 def_rm                   = definition->op_rm;
    ZyanU8 def_ndsndd               = ZYDIS_REGKIND_INVALID;
    ZyanBool is_gather              = ZYAN_FALSE;
    ZyanBool no_source_dest_match   = ZYAN_FALSE;
    ZyanBool no_source_source_match = ZYAN_FALSE;
#if !defined(ZYDIS_DISABLE_AVX512) || !defined(ZYDIS_DISABLE_KNC)
    ZydisMaskPolicy mask_policy     = ZYDIS_MASK_POLICY_INVALID;
#endif

    switch (instruction->encoding)
    {
    case ZYDIS_INSTRUCTION_ENCODING_LEGACY:
    {
        const ZydisInstructionDefinitionLEGACY* def =
            (const ZydisInstructionDefinitionLEGACY*)definition;

        if (def->requires_protected_mode &&
            (instruction->machine_mode == ZYDIS_MACHINE_MODE_REAL_16))
        {
            return ZYDIS_STATUS_DECODING_ERROR;
        }

        if (def->no_compat_mode &&
            ((instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_COMPAT_16) ||
             (instruction->machine_mode == ZYDIS_MACHINE_MODE_LONG_COMPAT_32)))
        {
            return ZYDIS_STATUS_DECODING_ERROR;
        }

        if (state->prefixes.has_lock && !def->accepts_LOCK)
        {
            return ZYDIS_STATUS_ILLEGAL_LOCK;
        }
        break;
    }
    case ZYDIS_INSTRUCTION_ENCODING_3DNOW:
    {
        break;
    }
    case ZYDIS_INSTRUCTION_ENCODING_XOP:
    {
        const ZydisInstructionDefinitionXOP* def =
            (const ZydisInstructionDefinitionXOP*)definition;
        def_ndsndd = def->op_ndsndd;
        break;
    }
    case ZYDIS_INSTRUCTION_ENCODING_VEX:
    {
        const ZydisInstructionDefinitionVEX* def =
            (const ZydisInstructionDefinitionVEX*)definition;
        def_ndsndd             = def->op_ndsndd;
        is_gather              = def->is_gather;
        no_source_source_match = def->no_source_source_match;
        break;
    }
    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
    {
#ifndef ZYDIS_DISABLE_AVX512
        const ZydisInstructionDefinitionEVEX* def =
            (const ZydisInstructionDefinitionEVEX*)definition;
        def_ndsndd           = def->op_ndsndd;
        is_gather            = def->is_gather;
        no_source_dest_match = def->no_source_dest_match;
        mask_policy          = def->mask_policy;

        // Check for invalid zero-mask
        if ((instruction->raw.evex.z) && (!def->accepts_zero_mask))
        {
            return ZYDIS_STATUS_INVALID_MASK; // TODO: Dedicated status code
        }
#else
        ZYAN_UNREACHABLE;
#endif
        break;
    }
    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
    {
#ifndef ZYDIS_DISABLE_KNC
        const ZydisInstructionDefinitionMVEX* def =
            (const ZydisInstructionDefinitionMVEX*)definition;
        def_ndsndd  = def->op_ndsndd;
        is_gather   = def->is_gather;
        mask_policy = def->mask_policy;

        // Check for invalid MVEX.SSS values
        static const ZyanU8 lookup[26][8] =
        {
            // ZYDIS_MVEX_FUNC_IGNORED
            { 1, 1, 1, 1, 1, 1, 1, 1 },
            // ZYDIS_MVEX_FUNC_INVALID
            { 1, 0, 0, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_RC
            { 1, 1, 1, 1, 1, 1, 1, 1 },
            // ZYDIS_MVEX_FUNC_SAE
            { 1, 1, 1, 1, 1, 1, 1, 1 },
            // ZYDIS_MVEX_FUNC_F_32
            { 1, 0, 0, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_I_32
            { 1, 0, 0, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_F_64
            { 1, 0, 0, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_I_64
            { 1, 0, 0, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_SWIZZLE_32
            { 1, 1, 1, 1, 1, 1, 1, 1 },
            // ZYDIS_MVEX_FUNC_SWIZZLE_64
            { 1, 1, 1, 1, 1, 1, 1, 1 },
            // ZYDIS_MVEX_FUNC_SF_32
            { 1, 1, 1, 1, 1, 0, 1, 1 },
            // ZYDIS_MVEX_FUNC_SF_32_BCST
            { 1, 1, 1, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_SF_32_BCST_4TO16
            { 1, 0, 1, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_SF_64
            { 1, 1, 1, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_SI_32
            { 1, 1, 1, 0, 1, 1, 1, 1 },
            // ZYDIS_MVEX_FUNC_SI_32_BCST
            { 1, 1, 1, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_SI_32_BCST_4TO16
            { 1, 0, 1, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_SI_64
            { 1, 1, 1, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_UF_32
            { 1, 0, 0, 1, 1, 1, 1, 1 },
            // ZYDIS_MVEX_FUNC_UF_64
            { 1, 0, 0, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_UI_32
            { 1, 0, 0, 0, 1, 1, 1, 1 },
            // ZYDIS_MVEX_FUNC_UI_64
            { 1, 0, 0, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_DF_32
            { 1, 0, 0, 1, 1, 1, 1, 1 },
            // ZYDIS_MVEX_FUNC_DF_64
            { 1, 0, 0, 0, 0, 0, 0, 0 },
            // ZYDIS_MVEX_FUNC_DI_32
            { 1, 0, 0, 0, 1, 1, 1, 1 },
            // ZYDIS_MVEX_FUNC_DI_64
            { 1, 0, 0, 0, 0, 0, 0, 0 }
        };
        ZYAN_ASSERT(def->functionality < ZYAN_ARRAY_LENGTH(lookup));
        ZYAN_ASSERT(instruction->raw.mvex.SSS < 8);
        if (!lookup[def->functionality][instruction->raw.mvex.SSS])
        {
            return ZYDIS_STATUS_DECODING_ERROR;
        }
#else
        ZYAN_UNREACHABLE;
#endif
        break;
    }
    default:
        ZYAN_UNREACHABLE;
    }

    ZydisDecoderContext* context = state->context;
    const ZyanBool is_reg = context->reg_info.is_mod_reg;

    ZyanU8 no_rip_rel     = ZYAN_FALSE;
    ZyanU8 is_sr_dest_reg = ZYAN_FALSE;
    ZyanU8 is_sr_dest_rm  = ZYAN_FALSE;
    if (def_reg)
    {
        is_sr_dest_reg = ZYDIS_OPDEF_GET_REG_HIGH_BIT(def_reg);
        def_reg = ZYDIS_OPDEF_GET_REG(def_reg);
    }
    if (def_rm)
    {
        if (is_reg)
        {
            is_sr_dest_rm = ZYDIS_OPDEF_GET_REG_HIGH_BIT(def_rm);
            def_rm = ZYDIS_OPDEF_GET_REG(def_rm);
        }
        else
        {
            no_rip_rel = ZYDIS_OPDEF_GET_MEM_HIGH_BIT(def_rm);
            def_rm = ZYDIS_OPDEF_GET_MEM(def_rm);
        }
    }

    // Check RIP-relative memory addressing
    if (no_rip_rel)
    {
        const ZyanBool is_rip_rel =
            (state->decoder->machine_mode == ZYDIS_MACHINE_MODE_LONG_64) &&
            (instruction->raw.modrm.mod == 0) && (instruction->raw.modrm.rm == 5);
        if (is_rip_rel)
        {
            return ZYDIS_STATUS_BAD_REGISTER;
        }
    }

    // Populate- and validate register constraints
    ZYAN_CHECK(ZydisPopulateRegisterIds(context, instruction, def_reg, def_rm, def_ndsndd));

    // `ZYDIS_REGISTER_CS` is not allowed as `MOV` target
    if (is_sr_dest_reg && (context->reg_info.id_reg == 1))
    {
        return ZYDIS_STATUS_BAD_REGISTER;
    }
    if (is_sr_dest_rm && (context->reg_info.id_rm == 1))
    {
        return ZYDIS_STATUS_BAD_REGISTER;
    }

    // Check gather registers
    if (is_gather)
    {
        // ZYAN_ASSERT(has_VSIB);
        ZYAN_ASSERT(instruction->raw.modrm.mod != 3);
        ZYAN_ASSERT(instruction->raw.modrm.rm  == 4);

        const ZyanU8 index = context->reg_info.id_index;
        ZyanU8 dest        = context->reg_info.id_reg;
        ZyanU8 mask        = 0xF0;

        if (instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_VEX)
        {
            ZYAN_ASSERT((def_reg    == ZYDIS_REGKIND_VR) &&
                        (def_rm     == ZYDIS_MEMOP_TYPE_VSIB) &&
                        (def_ndsndd == ZYDIS_REGKIND_VR));
            mask = context->reg_info.id_ndsndd;
        }

        if ((instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX) ||
            (instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_MVEX))
        {
            ZYAN_ASSERT(((def_reg    == ZYDIS_REGKIND_INVALID) ||
                         (def_reg    == ZYDIS_REGKIND_VR)) &&
                         (def_rm     == ZYDIS_MEMOP_TYPE_VSIB) &&
                         (def_ndsndd == ZYDIS_REGKIND_INVALID));

            // Some gather instructions (like `VGATHERPF0{D|Q}{PS|PD}`) do not have a destination
            // operand
            if (!def_reg)
            {
                dest = 0xF1;
            }
        }

        // If any pair of the index, mask, or destination registers are the same, the instruction
        // results a UD fault
        if ((dest == index) || (dest == mask) || (index == mask))
        {
            return ZYDIS_STATUS_BAD_REGISTER;
        }
    }

    // Check if any source register matches the destination register
    if (no_source_dest_match)
    {
        ZYAN_ASSERT((instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_EVEX) ||
                    (instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_VEX));

        const ZyanU8 dest    = context->reg_info.id_reg;
        const ZyanU8 source1 = context->reg_info.id_ndsndd;
        const ZyanU8 source2 = context->reg_info.id_rm;

        if ((dest == source1) || (is_reg && (dest == source2)))
        {
            return ZYDIS_STATUS_BAD_REGISTER;
        }
    }

    // If any pair of the source or destination registers are the same, the instruction results a
    // UD fault
    if (no_source_source_match) // TODO: Find better name
    {
        ZYAN_ASSERT(instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_VEX);
        ZYAN_ASSERT(is_reg);

        const ZyanU8 dest    = context->reg_info.id_reg;
        const ZyanU8 source1 = context->reg_info.id_ndsndd;
        const ZyanU8 source2 = context->reg_info.id_rm;

        if ((dest == source1) || (dest == source2) || (source1 == source2))
        {
            return ZYDIS_STATUS_BAD_REGISTER;
        }
    }

#if !defined(ZYDIS_DISABLE_AVX512) || !defined(ZYDIS_DISABLE_KNC)
    // Check for invalid MASK registers
    switch (mask_policy)
    {
    case ZYDIS_MASK_POLICY_INVALID:
    case ZYDIS_MASK_POLICY_ALLOWED:
        // Nothing to do here
        break;
    case ZYDIS_MASK_POLICY_REQUIRED:
        if (!context->vector_unified.mask)
        {
            return ZYDIS_STATUS_INVALID_MASK;
        }
        break;
    case ZYDIS_MASK_POLICY_FORBIDDEN:
        if (context->vector_unified.mask)
        {
            return ZYDIS_STATUS_INVALID_MASK;
        }
        break;
    default:
        ZYAN_UNREACHABLE;
    }
#endif

    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */

/**
 * Uses the decoder-tree to decode the current instruction.
 *
 * @param   state       A pointer to the `ZydisDecoderState` struct.
 * @param   instruction A pointer to the `ZydisDecodedInstruction` struct.
 *
 * @return  A zyan status code.
 */
static ZyanStatus ZydisDecodeInstruction(ZydisDecoderState* state,
    ZydisDecodedInstruction* instruction)
{
    ZYAN_ASSERT(state);
    ZYAN_ASSERT(instruction);

    // Iterate through the decoder tree
    const ZydisDecoderTreeNode* node = ZydisDecoderTreeGetRootNode();
    const ZydisDecoderTreeNode* temp = ZYAN_NULL;
    ZydisDecoderTreeNodeType node_type;
    do
    {
        node_type = node->type;
        ZyanU16 index = 0;
        ZyanStatus status = 0;
        switch (node_type)
        {
        case ZYDIS_NODETYPE_INVALID:
            if (temp)
            {
                node = temp;
                temp = ZYAN_NULL;
                node_type = ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX;
                if (state->prefixes.mandatory_candidate != 0x00)
                {
                    instruction->raw.prefixes[state->prefixes.offset_mandatory].type =
                        ZYDIS_PREFIX_TYPE_IGNORED;
                }
                if (state->prefixes.mandatory_candidate == 0x66)
                {
                    if (state->prefixes.offset_osz_override ==
                        state->prefixes.offset_mandatory)
                    {
                        instruction->raw.prefixes[state->prefixes.offset_mandatory].type =
                            ZYDIS_PREFIX_TYPE_EFFECTIVE;
                    }
                    instruction->attributes |= ZYDIS_ATTRIB_HAS_OPERANDSIZE;
                }
                continue;
            }
            return ZYDIS_STATUS_DECODING_ERROR;
        case ZYDIS_NODETYPE_FILTER_XOP:
            status = ZydisNodeHandlerXOP(instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_VEX:
            status = ZydisNodeHandlerVEX(instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_EMVEX:
            status = ZydisNodeHandlerEMVEX(instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_OPCODE:
            status = ZydisNodeHandlerOpcode(state, instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_MODE:
            status = ZydisNodeHandlerMode(instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_MODE_COMPACT:
            status = ZydisNodeHandlerModeCompact(instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_MODRM_MOD:
            status = ZydisNodeHandlerModrmMod(state, instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT:
            status = ZydisNodeHandlerModrmModCompact(state, instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_MODRM_REG:
            status = ZydisNodeHandlerModrmReg(state, instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_MODRM_RM:
            status = ZydisNodeHandlerModrmRm(state, instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_PREFIX_GROUP1:
            index = state->prefixes.group1 ? 1 : 0;
            break;
        case ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX:
            status = ZydisNodeHandlerMandatoryPrefix(state, instruction, &index);
            temp = ZydisDecoderTreeGetChildNode(node, 0);
            // TODO: Return to this point, if index == 0 contains a value and the previous path
            // TODO: was not successful
            // TODO: Restore consumed prefix
            break;
        case ZYDIS_NODETYPE_FILTER_OPERAND_SIZE:
            status = ZydisNodeHandlerOperandSize(state, instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE:
            status = ZydisNodeHandlerAddressSize(instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH:
            status = ZydisNodeHandlerVectorLength(state->context, instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_REX_W:
            status = ZydisNodeHandlerRexW(state->context, instruction, &index);
            break;
        case ZYDIS_NODETYPE_FILTER_REX_B:
            status = ZydisNodeHandlerRexB(state->context, instruction, &index);
            break;
#ifndef ZYDIS_DISABLE_AVX512
        case ZYDIS_NODETYPE_FILTER_EVEX_B:
            status = ZydisNodeHandlerEvexB(instruction, &index);
            break;
#endif
#ifndef ZYDIS_DISABLE_KNC
        case ZYDIS_NODETYPE_FILTER_MVEX_E:
            status = ZydisNodeHandlerMvexE(instruction, &index);
            break;
#endif
        case ZYDIS_NODETYPE_FILTER_MODE_AMD:
            index = state->decoder->decoder_mode[ZYDIS_DECODER_MODE_AMD_BRANCHES] ? 1 : 0;
            break;
        case ZYDIS_NODETYPE_FILTER_MODE_KNC:
            index = state->decoder->decoder_mode[ZYDIS_DECODER_MODE_KNC] ? 1 : 0;
            break;
        case ZYDIS_NODETYPE_FILTER_MODE_MPX:
            index = state->decoder->decoder_mode[ZYDIS_DECODER_MODE_MPX] ? 1 : 0;
            break;
        case ZYDIS_NODETYPE_FILTER_MODE_CET:
            index = state->decoder->decoder_mode[ZYDIS_DECODER_MODE_CET] ? 1 : 0;
            break;
        case ZYDIS_NODETYPE_FILTER_MODE_LZCNT:
            index = state->decoder->decoder_mode[ZYDIS_DECODER_MODE_LZCNT] ? 1 : 0;
            break;
        case ZYDIS_NODETYPE_FILTER_MODE_TZCNT:
            index = state->decoder->decoder_mode[ZYDIS_DECODER_MODE_TZCNT] ? 1 : 0;
            break;
        case ZYDIS_NODETYPE_FILTER_MODE_WBNOINVD:
            index = state->decoder->decoder_mode[ZYDIS_DECODER_MODE_WBNOINVD] ? 1 : 0;
            break;
        case ZYDIS_NODETYPE_FILTER_MODE_CLDEMOTE:
            index = state->decoder->decoder_mode[ZYDIS_DECODER_MODE_CLDEMOTE] ? 1 : 0;
            break;
        default:
            if (node_type & ZYDIS_NODETYPE_DEFINITION_MASK)
            {
                const ZydisInstructionDefinition* definition;
                ZydisGetInstructionDefinition(instruction->encoding, node->value, &definition);
                ZydisSetEffectiveOperandWidth(state->context, instruction, definition);
                ZydisSetEffectiveAddressWidth(state->context, instruction, definition);

                const ZydisInstructionEncodingInfo* info;
                ZydisGetInstructionEncodingInfo(node, &info);
                ZYAN_CHECK(ZydisDecodeOptionalInstructionParts(state, instruction, info));
                ZYAN_CHECK(ZydisCheckErrorConditions(state, instruction, definition));

                if (instruction->encoding == ZYDIS_INSTRUCTION_ENCODING_3DNOW)
                {
                    // Get actual 3DNOW opcode and definition
                    ZYAN_CHECK(ZydisInputNext(state, instruction, &instruction->opcode));
                    node = ZydisDecoderTreeGetRootNode();
                    node = ZydisDecoderTreeGetChildNode(node, 0x0F);
                    node = ZydisDecoderTreeGetChildNode(node, 0x0F);
                    node = ZydisDecoderTreeGetChildNode(node, instruction->opcode);
                    if (node->type == ZYDIS_NODETYPE_INVALID)
                    {
                        return ZYDIS_STATUS_DECODING_ERROR;
                    }
                    ZYAN_ASSERT(node->type == ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT);
                    node = ZydisDecoderTreeGetChildNode(
                        node, (instruction->raw.modrm.mod == 0x3) ? 0 : 1);
                    ZYAN_ASSERT(node->type & ZYDIS_NODETYPE_DEFINITION_MASK);
                    ZydisGetInstructionDefinition(instruction->encoding, node->value, &definition);
                }

                instruction->mnemonic = definition->mnemonic;

#ifndef ZYDIS_MINIMAL_MODE

                instruction->operand_count = definition->operand_count;
                instruction->operand_count_visible = definition->operand_count_visible;
                state->context->definition = definition;

                instruction->meta.category = definition->category;
                instruction->meta.isa_set = definition->isa_set;
                instruction->meta.isa_ext = definition->isa_ext;
                instruction->meta.branch_type = definition->branch_type;
                ZYAN_ASSERT((instruction->meta.branch_type == ZYDIS_BRANCH_TYPE_NONE) ||
                        ((instruction->meta.category == ZYDIS_CATEGORY_CALL) ||
                         (instruction->meta.category == ZYDIS_CATEGORY_COND_BR) ||
                         (instruction->meta.category == ZYDIS_CATEGORY_UNCOND_BR) ||
                         (instruction->meta.category == ZYDIS_CATEGORY_RET)));
                instruction->meta.exception_class = definition->exception_class;

                if (!state->decoder->decoder_mode[ZYDIS_DECODER_MODE_MINIMAL])
                {
                    ZydisSetAttributes(state, instruction, definition);
                    switch (instruction->encoding)
                    {
                    case ZYDIS_INSTRUCTION_ENCODING_XOP:
                    case ZYDIS_INSTRUCTION_ENCODING_VEX:
                    case ZYDIS_INSTRUCTION_ENCODING_EVEX:
                    case ZYDIS_INSTRUCTION_ENCODING_MVEX:
                        ZydisSetAVXInformation(state->context, instruction, definition);
                        break;
                    default:
                        break;
                    }

                    const ZydisDefinitionAccessedFlags* flags;
                    if (ZydisGetAccessedFlags(definition, &flags))
                    {
                        instruction->attributes |= ZYDIS_ATTRIB_CPUFLAG_ACCESS;
                    }
                    instruction->cpu_flags = &flags->cpu_flags;
                    instruction->fpu_flags = &flags->fpu_flags;
                }

#endif

                return ZYAN_STATUS_SUCCESS;
            }
            ZYAN_UNREACHABLE;
        }
        ZYAN_CHECK(status);
        node = ZydisDecoderTreeGetChildNode(node, index);
    } while ((node_type != ZYDIS_NODETYPE_INVALID) && !(node_type & ZYDIS_NODETYPE_DEFINITION_MASK));
    return ZYAN_STATUS_SUCCESS;
}

/* ---------------------------------------------------------------------------------------------- */

/* ============================================================================================== */
/* Exported functions                                                                             */
/* ============================================================================================== */

ZyanStatus ZydisDecoderInit(ZydisDecoder* decoder, ZydisMachineMode machine_mode,
    ZydisStackWidth stack_width)
{
    static const ZyanBool decoder_modes[ZYDIS_DECODER_MODE_MAX_VALUE + 1] =
    {
#ifdef ZYDIS_MINIMAL_MODE
        ZYAN_TRUE , // ZYDIS_DECODER_MODE_MINIMAL
#else
        ZYAN_FALSE, // ZYDIS_DECODER_MODE_MINIMAL
#endif
        ZYAN_FALSE, // ZYDIS_DECODER_MODE_AMD_BRANCHES
        ZYAN_FALSE, // ZYDIS_DECODER_MODE_KNC
        ZYAN_TRUE , // ZYDIS_DECODER_MODE_MPX
        ZYAN_TRUE , // ZYDIS_DECODER_MODE_CET
        ZYAN_TRUE , // ZYDIS_DECODER_MODE_LZCNT
        ZYAN_TRUE , // ZYDIS_DECODER_MODE_TZCNT
        ZYAN_FALSE, // ZYDIS_DECODER_MODE_WBNOINVD
        ZYAN_TRUE   // ZYDIS_DECODER_MODE_CLDEMOTE
    };

    if (!decoder)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }
    switch (machine_mode)
    {
    case ZYDIS_MACHINE_MODE_LONG_64:
        if (stack_width != ZYDIS_STACK_WIDTH_64)
        {
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
        break;
    case ZYDIS_MACHINE_MODE_LONG_COMPAT_32:
    case ZYDIS_MACHINE_MODE_LONG_COMPAT_16:
    case ZYDIS_MACHINE_MODE_LEGACY_32:
    case ZYDIS_MACHINE_MODE_LEGACY_16:
    case ZYDIS_MACHINE_MODE_REAL_16:
        if ((stack_width != ZYDIS_STACK_WIDTH_16) && (stack_width != ZYDIS_STACK_WIDTH_32))
        {
            return ZYAN_STATUS_INVALID_ARGUMENT;
        }
        break;
    default:
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    decoder->machine_mode = machine_mode;
    decoder->stack_width = stack_width;
    ZYAN_MEMCPY(&decoder->decoder_mode, &decoder_modes, sizeof(decoder_modes));

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisDecoderEnableMode(ZydisDecoder* decoder, ZydisDecoderMode mode, ZyanBool enabled)
{
    if (!decoder || ((ZyanUSize)mode > ZYDIS_DECODER_MODE_MAX_VALUE))
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

#ifdef ZYDIS_MINIMAL_MODE
    if ((mode == ZYDIS_DECODER_MODE_MINIMAL) && !enabled)
    {
        return ZYAN_STATUS_INVALID_OPERATION;
    }
#endif

    decoder->decoder_mode[mode] = enabled;

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisDecoderDecodeFull(const ZydisDecoder* decoder,
    const void* buffer, ZyanUSize length, ZydisDecodedInstruction* instruction,
    ZydisDecodedOperand operands[ZYDIS_MAX_OPERAND_COUNT])
{
    if (!decoder || !instruction || !buffer || !operands)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }
    if (!length)
    {
        return ZYDIS_STATUS_NO_MORE_DATA;
    }
    if (decoder->decoder_mode[ZYDIS_DECODER_MODE_MINIMAL])
    {
        return ZYAN_STATUS_MISSING_DEPENDENCY; // TODO: Introduce better status code
    }

    ZydisDecoderContext context;
    ZYAN_CHECK(ZydisDecoderDecodeInstruction(decoder, &context, buffer, length, instruction));
    ZYAN_CHECK(ZydisDecoderDecodeOperands(decoder, &context, instruction, operands,
        instruction->operand_count));
    ZYAN_MEMSET(&operands[instruction->operand_count], 0,
        (ZYDIS_MAX_OPERAND_COUNT - instruction->operand_count) * sizeof(operands[0]));

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisDecoderDecodeInstruction(const ZydisDecoder* decoder, ZydisDecoderContext* context,
    const void* buffer, ZyanUSize length, ZydisDecodedInstruction* instruction)
{
    if (!decoder || !instruction || !buffer)
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    if (!length)
    {
        return ZYDIS_STATUS_NO_MORE_DATA;
    }

    ZydisDecoderState state;
    ZYAN_MEMSET(&state, 0, sizeof(state));
    state.decoder = decoder;
    state.buffer = (const ZyanU8*)buffer;
    state.buffer_len = length;
    state.prefixes.offset_notrack = -1;

    ZydisDecoderContext default_context;
    if (!context)
    {
        // Use a fallback context if no custom one has been provided
        context = &default_context;
    }
    ZYAN_MEMSET(context, 0, sizeof(*context));
    state.context = context;

    ZYAN_MEMSET(instruction, 0, sizeof(*instruction));
    instruction->machine_mode = decoder->machine_mode;
    instruction->stack_width = 16 << decoder->stack_width;

    ZYAN_CHECK(ZydisCollectOptionalPrefixes(&state, instruction));
    ZYAN_CHECK(ZydisDecodeInstruction(&state, instruction));

    instruction->raw.encoding2 = instruction->encoding;

    return ZYAN_STATUS_SUCCESS;
}

ZyanStatus ZydisDecoderDecodeOperands(const ZydisDecoder* decoder,
    const ZydisDecoderContext* context, const ZydisDecodedInstruction* instruction,
    ZydisDecodedOperand* operands, ZyanU8 operand_count)
{
#ifdef ZYDIS_MINIMAL_MODE

    ZYAN_UNUSED(decoder);
    ZYAN_UNUSED(context);
    ZYAN_UNUSED(instruction);
    ZYAN_UNUSED(operands);
    ZYAN_UNUSED(operand_count);

    return ZYAN_STATUS_MISSING_DEPENDENCY; // TODO: Introduce better status code

#else

    if (!decoder || !context || !context->definition || !instruction ||
        (operand_count && !operands) || (operand_count > ZYDIS_MAX_OPERAND_COUNT))
    {
        return ZYAN_STATUS_INVALID_ARGUMENT;
    }

    if (decoder->decoder_mode[ZYDIS_DECODER_MODE_MINIMAL])
    {
        return ZYAN_STATUS_MISSING_DEPENDENCY; // TODO: Introduce better status code
    }

    operand_count = ZYAN_MIN(operand_count, instruction->operand_count);
    if (!operand_count)
    {
        return ZYAN_STATUS_SUCCESS;
    }

    return ZydisDecodeOperands(decoder, context, instruction, operands, operand_count);

#endif
}

/* ============================================================================================== */

//
// Source file: /home/ath/devel/zydis/src/DecoderData.c
//

/***************************************************************************************************

  Zyan Disassembler Library (Zydis)

  Original Author : Florian Bernd

 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.

***************************************************************************************************/


/* ============================================================================================== */
/* Data tables                                                                                    */
/* ============================================================================================== */

/* ---------------------------------------------------------------------------------------------- */
/* Physical instruction encodings                                                                 */
/* ---------------------------------------------------------------------------------------------- */


//
// Header: Generated/InstructionEncodings.inc
//

static const ZydisInstructionEncodingInfo INSTR_ENCODINGS[] =
{
    { 0, { { 0, 0, 0 } }, { { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM, { { 0, 0, 0 } }, { { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_DISP, { { 16, 32, 64 } }, { { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 16, 16 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_TRUE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 32, 32 }, ZYAN_TRUE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 32, 64 }, ZYAN_TRUE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_TRUE, ZYAN_TRUE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 32, 32 }, ZYAN_TRUE, ZYAN_TRUE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 32, 32, 32 }, ZYAN_TRUE, ZYAN_TRUE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 32, 32, 32 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_TRUE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 32, 32 }, ZYAN_TRUE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0, { { 0, 0, 0 } }, { { { 16, 32, 32 }, ZYAN_TRUE, ZYAN_TRUE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_FORCE_REG_FORM, { { 0, 0, 0 } }, { { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE }, { { 0, 0, 0 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0 | ZYDIS_INSTR_ENC_FLAG_HAS_IMM1, { { 0, 0, 0 } }, { { { 16, 16, 16 }, ZYAN_FALSE, ZYAN_FALSE }, { { 8, 8, 8 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_IMM0 | ZYDIS_INSTR_ENC_FLAG_HAS_IMM1, { { 0, 0, 0 } }, { { { 16, 32, 32 }, ZYAN_FALSE, ZYAN_FALSE }, { { 16, 16, 16 }, ZYAN_FALSE, ZYAN_FALSE } } },
    { ZYDIS_INSTR_ENC_FLAG_HAS_MODRM | ZYDIS_INSTR_ENC_FLAG_HAS_IMM0 | ZYDIS_INSTR_ENC_FLAG_HAS_IMM1, { { 0, 0, 0 } }, { { { 8, 8, 8 }, ZYAN_FALSE, ZYAN_FALSE }, { { 8, 8, 8 }, ZYAN_FALSE, ZYAN_FALSE } } }
};

/* ---------------------------------------------------------------------------------------------- */
/* Decoder tree                                                                                   */
/* ---------------------------------------------------------------------------------------------- */

#define ZYDIS_INVALID \
    { ZYDIS_NODETYPE_INVALID, 0x00000000 }
#define ZYDIS_FILTER(type, id) \
    { type, id }
#define ZYDIS_DEFINITION(encoding_id, id) \
    { ZYDIS_NODETYPE_DEFINITION_MASK | encoding_id, id }


//
// Header: Generated/DecoderTables.inc
//

const ZydisDecoderTreeNode FILTERS_XOP[][13] =
{
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x20), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x21), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x22), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_VEX[][17] =
{
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x43A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x23), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x24), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x25), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x27), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x28), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x29), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x723), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x23), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x24), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x26), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x29), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2B), ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_EMVEX[][49] =
{
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x158), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x5), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x6), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xB), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0xF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x10), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x11), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x12), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x13), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x14), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x15), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x16), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x17), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x18), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x19), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1F) }
};

const ZydisDecoderTreeNode FILTERS_OPCODE[][256] =
{
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3), ZYDIS_DEFINITION(0x5, 0x22), ZYDIS_DEFINITION(0x6, 0x23), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7), ZYDIS_DEFINITION(0x5, 0x3EE), ZYDIS_DEFINITION(0x6, 0x3EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x140), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x141), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x142), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x143), ZYDIS_DEFINITION(0x5, 0xC), ZYDIS_DEFINITION(0x6, 0xD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x56), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x57), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x144), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x145), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x146), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x147), ZYDIS_DEFINITION(0x5, 0x640), ZYDIS_DEFINITION(0x6, 0x641), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x58), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x59), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x148), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x149), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14B), ZYDIS_DEFINITION(0x5, 0x58), ZYDIS_DEFINITION(0x6, 0x59), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14F), ZYDIS_DEFINITION(0x5, 0x6E9), ZYDIS_DEFINITION(0x6, 0x6EA), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x150), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x151), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x152), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x153), ZYDIS_DEFINITION(0x5, 0x76C), ZYDIS_DEFINITION(0x6, 0x76D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x154), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x155), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x156), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x157), ZYDIS_DEFINITION(0x5, 0xE7), ZYDIS_DEFINITION(0x6, 0xE8), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x60), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x61), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x62), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x63), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x64), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x65), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x66), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x67), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x68), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x69), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6D), ZYDIS_DEFINITION(0x0, 0x5C2), ZYDIS_DEFINITION(0x0, 0x5C2), ZYDIS_DEFINITION(0x0, 0x5C2), ZYDIS_DEFINITION(0x0, 0x5C2), ZYDIS_DEFINITION(0x0, 0x5C2), ZYDIS_DEFINITION(0x0, 0x5C2), ZYDIS_DEFINITION(0x0, 0x5C2), ZYDIS_DEFINITION(0x0, 0x5C2), ZYDIS_DEFINITION(0x0, 0x518), ZYDIS_DEFINITION(0x0, 0x518), ZYDIS_DEFINITION(0x0, 0x518), ZYDIS_DEFINITION(0x0, 0x518), ZYDIS_DEFINITION(0x0, 0x518), ZYDIS_DEFINITION(0x0, 0x518), ZYDIS_DEFINITION(0x0, 0x518), ZYDIS_DEFINITION(0x0, 0x518), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EMVEX, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x6, 0x5C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DC), ZYDIS_DEFINITION(0x5, 0x5C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xAC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xAD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xAE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xAF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_XOP, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A8), ZYDIS_DEFINITION(0x0, 0x75B), ZYDIS_DEFINITION(0x0, 0x75B), ZYDIS_DEFINITION(0x0, 0x75B), ZYDIS_DEFINITION(0x0, 0x75B), ZYDIS_DEFINITION(0x0, 0x75B), ZYDIS_DEFINITION(0x0, 0x75B), ZYDIS_DEFINITION(0x0, 0x75B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0xB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0xC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCC), ZYDIS_DEFINITION(0x0, 0x207), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCE), ZYDIS_DEFINITION(0x0, 0x629), ZYDIS_DEFINITION(0x0, 0x2BD), ZYDIS_DEFINITION(0x2, 0x30D), ZYDIS_DEFINITION(0x2, 0x30E), ZYDIS_DEFINITION(0x2, 0x30F), ZYDIS_DEFINITION(0x2, 0x310), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AC), ZYDIS_DEFINITION(0x5, 0x70B), ZYDIS_DEFINITION(0x6, 0x70C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1B2), ZYDIS_DEFINITION(0x5, 0x311), ZYDIS_DEFINITION(0x5, 0x311), ZYDIS_DEFINITION(0x5, 0x311), ZYDIS_DEFINITION(0x5, 0x311), ZYDIS_DEFINITION(0x5, 0x311), ZYDIS_DEFINITION(0x5, 0x311), ZYDIS_DEFINITION(0x5, 0x311), ZYDIS_DEFINITION(0x5, 0x311), ZYDIS_DEFINITION(0x7, 0x312), ZYDIS_DEFINITION(0x7, 0x312), ZYDIS_DEFINITION(0x7, 0x312), ZYDIS_DEFINITION(0x7, 0x312), ZYDIS_DEFINITION(0x7, 0x312), ZYDIS_DEFINITION(0x7, 0x312), ZYDIS_DEFINITION(0x7, 0x312), ZYDIS_DEFINITION(0x7, 0x312), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x438), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x439), ZYDIS_DEFINITION(0x4, 0x5FD), ZYDIS_DEFINITION(0x0, 0x5FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VEX, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VEX, 0x1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x724), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x725), ZYDIS_DEFINITION(0x11, 0x174), ZYDIS_DEFINITION(0x0, 0x2C4), ZYDIS_DEFINITION(0x4, 0x5FF), ZYDIS_DEFINITION(0x0, 0x600), ZYDIS_DEFINITION(0x0, 0x251), ZYDIS_DEFINITION(0x3, 0x24F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x11D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x20), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x726), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x727), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x728), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x729), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x11E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x11F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x120), ZYDIS_DEFINITION(0x0, 0x763), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x72A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x72B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x72C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x72D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x72E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x72F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x730), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x731), ZYDIS_DEFINITION(0x8, 0x2E0), ZYDIS_DEFINITION(0x8, 0x2DF), ZYDIS_DEFINITION(0x8, 0x2DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x121), ZYDIS_DEFINITION(0x3, 0x232), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x25), ZYDIS_DEFINITION(0x3, 0x3FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x122), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x123), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x124), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x125), ZYDIS_DEFINITION(0x0, 0x235), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x27), ZYDIS_DEFINITION(0x0, 0x3FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x28), ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x250), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x21E), ZYDIS_DEFINITION(0x0, 0xBE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x732), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x733), ZYDIS_DEFINITION(0x0, 0xB2), ZYDIS_DEFINITION(0x0, 0x6CD), ZYDIS_DEFINITION(0x0, 0xB8), ZYDIS_DEFINITION(0x0, 0x6D0), ZYDIS_DEFINITION(0x0, 0xB3), ZYDIS_DEFINITION(0x0, 0x6CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x734), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x735) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1B), ZYDIS_DEFINITION(0x0, 0xBA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1C), ZYDIS_DEFINITION(0x0, 0x253), ZYDIS_DEFINITION(0x0, 0x747), ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x722), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC), ZYDIS_DEFINITION(0x0, 0x1A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_MPX, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_MPX, 0x1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x29), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3E), ZYDIS_DEFINITION(0x0, 0x74A), ZYDIS_DEFINITION(0x0, 0x5FB), ZYDIS_DEFINITION(0x0, 0x5F1), ZYDIS_DEFINITION(0x0, 0x5F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x25), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x3), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPCODE, 0x4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xAF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xB9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xBF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xC9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xCF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x129), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x3F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x40), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x41), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x42), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x43), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x44), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x45), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x46), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x47), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x48), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x49), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xDF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xEA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xEB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xEC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xED), ZYDIS_DEFINITION(0x0, 0x5C7), ZYDIS_DEFINITION(0x0, 0x51B), ZYDIS_DEFINITION(0x0, 0x110), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xEE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xEF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF2), ZYDIS_DEFINITION(0x0, 0x5C8), ZYDIS_DEFINITION(0x0, 0x51C), ZYDIS_DEFINITION(0x0, 0x623), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xFF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x100), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x101), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x102), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x103), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x104), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x105), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x106), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x107), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x108), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x109), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10F), ZYDIS_DEFINITION(0x0, 0x96), ZYDIS_DEFINITION(0x0, 0x96), ZYDIS_DEFINITION(0x0, 0x96), ZYDIS_DEFINITION(0x0, 0x96), ZYDIS_DEFINITION(0x0, 0x96), ZYDIS_DEFINITION(0x0, 0x96), ZYDIS_DEFINITION(0x0, 0x96), ZYDIS_DEFINITION(0x0, 0x96), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x110), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x111), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x112), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x113), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x114), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x115), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x116), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x117), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x118), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x119), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x120), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x121), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x122), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x123), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x124), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x125), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x126), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x127), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x128), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x129), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x130), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x131), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x132), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x133), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x134), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x135), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x136), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x137), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x138), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x139), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13F) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x10), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x11), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x12), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x13), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x14), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x40), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x41), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x42), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x43), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x46), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x47), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x50), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x51), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x52), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x53), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x54), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x55), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x56), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x57), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x58), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x59), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x60), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x61), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x62), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x63), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x64), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x65), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x66), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x67), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x68), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x69), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x71), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x72), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x73), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x74), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x75), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x76), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x77), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x78), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x79), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x7F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x80), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x81), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x82), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x83), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x84), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x85), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x86), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x87), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x88), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x89), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x8F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x90), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x91), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x92), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x93), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x94), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x95), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x96), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x97), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x98), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x99), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x9F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0xA0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x159), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x15F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x160), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x161), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x162), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x163), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x164), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x165), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x166), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x167), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x168), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x169), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x16F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x170), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x171), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x172), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x173), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x174), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x175), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x176), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x177), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x178), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x179), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x17F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x180), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x181), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x182), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x183), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x184), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x185), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x186), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x187), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x188), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x189), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x18F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x190), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x191), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x192), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x193), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x194), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x195), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x196), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x197), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x198), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x199), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19A), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x19F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1BF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C1), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C8), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1C9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1CF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D1), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1E9), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1EF), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1F9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x1FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x200), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x201), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x202), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x203), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x204), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x205), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x206), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x207), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x208), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x209), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x20F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x210), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x211), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x212), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x213), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x214), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x215), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x216), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x217), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x218), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x219), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x21F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x220), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x221), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x222), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x223), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x224), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x225), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x226), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x227), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x228), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x229), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x22F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x230), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x231), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x232), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x233), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x234), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x235), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x236), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x237), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x238), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x239), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x23F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x240), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x241), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x242), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x243), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x244), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x245), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x246), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x247), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x248), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x249), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x24F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x250), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x251), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x252), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x253), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x254), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x255), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x256), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x257), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x258), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x259), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x25F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x260), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x261), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x262), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x263), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x264), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x265), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x266), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x267), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x268), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x269), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x26F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x270), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x271), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x272), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x273), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x274), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x275), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x276), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x277), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x278), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x279), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x27F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x280), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x281), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x282), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x283), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x284), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x285), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x286), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x287), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x288), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x289), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x28F), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x290), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x291), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x292), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x293), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x294), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x295), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x296), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x297), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x298), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x299), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x29F), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A6), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2A9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2AF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2BF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C3), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2C9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2CF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F7), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2F9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x2FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x300), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x301), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x302), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x303), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x304), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x305), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x306), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x307), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x308), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x309), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x30F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x310), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x311), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x312), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x313), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x314), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x315), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x316), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x317), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x318), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x319), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x31F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x320), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x321), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x322), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x323), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x324), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x325), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x326), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x327), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x328), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x329), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x32F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x330), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x331), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x332), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x333), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x334), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x335), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x336), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x337), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x338), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x339), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33A), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x33F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x340), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x341), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x342), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x343), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x344), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x345), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x346), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x347), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x348), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x349), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x34F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x350), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x351), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x352), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x353), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x354), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x355), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x356), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x357), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x358), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x359), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x35F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x360), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x361), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x362), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x363), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x364), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x365), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x366), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x367), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x368), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x369), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36B), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x36F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x370), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x371), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x372), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x373), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x374), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x375), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x376), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x377), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x378), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x379), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x37F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x380), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x381), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x382), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x383), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x384), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x385), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x386), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x387), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x388), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x389), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x38F), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x390), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x391), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x392), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x393), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x394), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x395), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x396), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x397), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x398), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x399), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x39F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3A9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AA), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AD), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3AF), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B0), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B1), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B2), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B3), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B4), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B6), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B7), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B8), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3B9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BC), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BD), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BE), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3BF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C0), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3C9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3CF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D3), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3D9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3DA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x448), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x449), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x450), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x451), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x452), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x453), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x454), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x455), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x456), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x457), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x458), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x459), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x45F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x460), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x461), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x43), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x44), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x45), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x470), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x471), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x472), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x473), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x474), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x475), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x476), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x477), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x478), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x479), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x47F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x480), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x481), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x482), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x483), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x484), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x485), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x486), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x487), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x488), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x489), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x46), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x490), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x491), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x492), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x493), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x494), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x495), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x496), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A0), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x455), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x456), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xE3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xE4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4BF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C1), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C2), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D7), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E2), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E3), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4BE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E5), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4E9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4EB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4ED), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x500), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x501), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x502), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x503), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x504), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x505), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x506), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x507), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x508), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x509), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x50), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x51), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x515), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x516), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x517), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x518), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x519), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x51F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x520), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x521), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x522), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x523), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x524), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x525), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x526), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x527), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x528), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x529), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x530), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x531), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x532), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x533), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x534), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x535), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x536), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x537), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x538), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x539), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x53F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x540), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x541), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x542), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x543), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x544), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x545), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x546), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x547), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x548), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x549), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x550), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x551), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x552), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x553), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x554), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x555), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x556), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x557), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x558), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x559), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x55F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x560), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x561), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x562), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x563), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x564), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x565), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x566), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x567), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x568), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x569), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x570), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x571), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x572), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x573), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x574), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x575), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x576), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x577), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x578), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x579), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x57F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x580), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x581), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x582), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x583), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x584), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x585), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x586), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x587), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x588), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x589), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58F), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x52), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x33), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x592), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x593), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x594), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x595), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x596), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x597), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x598), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x599), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x34), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x35), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x36), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x37), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x626), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x629), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x62C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x62F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x636), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x639), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x63C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x63F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x646), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x649), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x64C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x64F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5B9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BA), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BD), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5BF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C0), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x66A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x66B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5CF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D7), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DA), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DB), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DC), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6BE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F3), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x100), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x101), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x102), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5F9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x53), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x600), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x601), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x38), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x603), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x604), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x605), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x606), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x607), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x10D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x10E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x10F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6FC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6FD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6FF), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x700), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x701), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x702), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x703), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x608), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x609), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x54), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x711), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x610), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x611), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x612), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x39), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x615), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x616), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x617), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x618), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x619), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_MODE[][3] =
{
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_MODE_COMPACT[][2] =
{
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x5BE) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x515) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x5BF) },
    { ZYDIS_DEFINITION(0x1, 0x6FB), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x16C), ZYDIS_DEFINITION(0x1, 0x16D) },
    { ZYDIS_DEFINITION(0x1, 0x48B), ZYDIS_DEFINITION(0x1, 0x48C) },
    { ZYDIS_DEFINITION(0x1, 0x2FC), ZYDIS_DEFINITION(0x1, 0x2FD) },
    { ZYDIS_DEFINITION(0x1, 0x3A6), ZYDIS_DEFINITION(0x1, 0x3A7) },
    { ZYDIS_DEFINITION(0x1, 0x168), ZYDIS_DEFINITION(0x1, 0x169) },
    { ZYDIS_DEFINITION(0x1, 0x16A), ZYDIS_DEFINITION(0x1, 0x16B) },
    { ZYDIS_DEFINITION(0x1, 0x2FE), ZYDIS_DEFINITION(0x1, 0x2FF) },
    { ZYDIS_DEFINITION(0x1, 0x3A8), ZYDIS_DEFINITION(0x1, 0x3A9) },
    { ZYDIS_DEFINITION(0x1, 0x705), ZYDIS_DEFINITION(0x1, 0x706) },
    { ZYDIS_DEFINITION(0x1, 0x658), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x657), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x656), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x723), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x715), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0xBB), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6E0), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x601), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x55E), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x602), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x67D), ZYDIS_DEFINITION(0x1, 0x67E) },
    { ZYDIS_DEFINITION(0x1, 0x6BD), ZYDIS_DEFINITION(0x1, 0x6BE) },
    { ZYDIS_DEFINITION(0x1, 0x2C8), ZYDIS_DEFINITION(0x1, 0x2C9) },
    { ZYDIS_DEFINITION(0x1, 0x2CB), ZYDIS_DEFINITION(0x1, 0x2CC) },
    { ZYDIS_DEFINITION(0x0, 0x6FC), ZYDIS_DEFINITION(0x0, 0x6FD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x0), ZYDIS_DEFINITION(0x0, 0x704) },
    { ZYDIS_DEFINITION(0x1, 0x74), ZYDIS_DEFINITION(0x1, 0x76) },
    { ZYDIS_DEFINITION(0x1, 0x7C), ZYDIS_DEFINITION(0x1, 0x7E) },
    { ZYDIS_DEFINITION(0x1, 0x80), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x0) },
    { ZYDIS_DEFINITION(0x1, 0x85), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x1) },
    { ZYDIS_DEFINITION(0x1, 0x75), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x2) },
    { ZYDIS_DEFINITION(0x1, 0x7D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x3) },
    { ZYDIS_DEFINITION(0x1, 0x78), ZYDIS_DEFINITION(0x1, 0x7A) },
    { ZYDIS_DEFINITION(0x1, 0x8A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x4) },
    { ZYDIS_DEFINITION(0x1, 0x88), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x5) },
    { ZYDIS_DEFINITION(0x1, 0x82), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x6) },
    { ZYDIS_DEFINITION(0x1, 0x79), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1) },
    { ZYDIS_DEFINITION(0x10, 0x317), ZYDIS_DEFINITION(0x10, 0x318) },
    { ZYDIS_DEFINITION(0x10, 0x319), ZYDIS_DEFINITION(0x10, 0x31A) },
    { ZYDIS_DEFINITION(0x10, 0x31B), ZYDIS_DEFINITION(0x10, 0x31C) },
    { ZYDIS_DEFINITION(0x10, 0x31D), ZYDIS_DEFINITION(0x10, 0x31E) },
    { ZYDIS_DEFINITION(0x0, 0x6FE), ZYDIS_DEFINITION(0x0, 0x6FF) },
    { ZYDIS_DEFINITION(0x0, 0x700), ZYDIS_DEFINITION(0x0, 0x701) },
    { ZYDIS_DEFINITION(0x1, 0x254), ZYDIS_DEFINITION(0x1, 0x255) },
    { ZYDIS_DEFINITION(0x1, 0x25B), ZYDIS_DEFINITION(0x1, 0x25C) },
    { ZYDIS_DEFINITION(0x1, 0x259), ZYDIS_DEFINITION(0x1, 0x25A) },
    { ZYDIS_DEFINITION(0x1, 0x33B), ZYDIS_DEFINITION(0x1, 0x33C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D), ZYDIS_DEFINITION(0x1, 0x32B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E), ZYDIS_DEFINITION(0x1, 0x32F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F), ZYDIS_DEFINITION(0x1, 0x32C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20), ZYDIS_DEFINITION(0x1, 0x330) },
    { ZYDIS_DEFINITION(0x1, 0x73A), ZYDIS_DEFINITION(0x1, 0x73C) },
    { ZYDIS_DEFINITION(0x1, 0x73B), ZYDIS_DEFINITION(0x1, 0x73D) },
    { ZYDIS_DEFINITION(0x1, 0x741), ZYDIS_DEFINITION(0x1, 0x743) },
    { ZYDIS_DEFINITION(0x1, 0x742), ZYDIS_DEFINITION(0x1, 0x744) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21), ZYDIS_DEFINITION(0x1, 0x333) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22), ZYDIS_DEFINITION(0x1, 0x337) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23), ZYDIS_DEFINITION(0x1, 0x334) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24), ZYDIS_DEFINITION(0x1, 0x338) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x0), ZYDIS_DEFINITION(0x9, 0x2AC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x1), ZYDIS_DEFINITION(0x9, 0x298) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x2), ZYDIS_DEFINITION(0x9, 0x264) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x3), ZYDIS_DEFINITION(0x9, 0x284) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x4), ZYDIS_DEFINITION(0x9, 0x2BC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x5), ZYDIS_DEFINITION(0x9, 0x2A7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x6), ZYDIS_DEFINITION(0x9, 0x269) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x7), ZYDIS_DEFINITION(0x9, 0x289) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x8), ZYDIS_DEFINITION(0x9, 0x2B7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x9), ZYDIS_DEFINITION(0x9, 0x2A2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xA), ZYDIS_DEFINITION(0x9, 0x2B1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xB), ZYDIS_DEFINITION(0x9, 0x29D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xC), ZYDIS_DEFINITION(0x9, 0x271) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xD), ZYDIS_DEFINITION(0x9, 0x28E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xE), ZYDIS_DEFINITION(0x9, 0x276) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0xF), ZYDIS_DEFINITION(0x9, 0x293) },
    { ZYDIS_DEFINITION(0x1, 0x5EF), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x5F0), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x748), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x749), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x659), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x5F2), ZYDIS_DEFINITION(0x1, 0x5F3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B), ZYDIS_DEFINITION(0x1, 0x10B) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x5C0) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x516) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x5C1) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x517) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x150) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x151) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x0) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x3) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x238) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x238) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x238) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x238) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x238) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x238) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x238) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x238) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x152) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x152) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x152) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x152) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x152) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x152) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x152) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x152) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x2) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x83), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x84) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x86), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x87) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xAF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1C7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x28A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x28B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x28D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x28E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2AD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2B0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x348), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x349) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x34B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x34C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x34E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x34F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x351), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x352) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x354), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x355) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x357), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x358) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x371), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x372) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x374), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x375) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x377), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x378) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x37A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x37B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x37F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x380) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x382), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x383) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3CF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3DA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3DB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3EE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3EF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3FA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3FB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3FD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3FE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x40C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x40D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x40F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x410) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x412), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x413) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x415), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x416) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x418), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x419) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x41B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x41C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x434), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x435) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x437), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x438) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x43A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x43B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x43D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x43E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x441), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x442) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x444), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x445) },
    { ZYDIS_DEFINITION(0x1, 0x38A), ZYDIS_DEFINITION(0x1, 0x6A) },
    { ZYDIS_DEFINITION(0x1, 0x38B), ZYDIS_DEFINITION(0x1, 0x6B) },
    { ZYDIS_DEFINITION(0x8, 0x2A8), ZYDIS_DEFINITION(0x8, 0x2A9) },
    { ZYDIS_DEFINITION(0x8, 0x294), ZYDIS_DEFINITION(0x8, 0x295) },
    { ZYDIS_DEFINITION(0x8, 0x260), ZYDIS_DEFINITION(0x8, 0x261) },
    { ZYDIS_DEFINITION(0x8, 0x280), ZYDIS_DEFINITION(0x8, 0x281) },
    { ZYDIS_DEFINITION(0x8, 0x2B8), ZYDIS_DEFINITION(0x8, 0x2B9) },
    { ZYDIS_DEFINITION(0x8, 0x2A3), ZYDIS_DEFINITION(0x8, 0x2A4) },
    { ZYDIS_DEFINITION(0x8, 0x265), ZYDIS_DEFINITION(0x8, 0x266) },
    { ZYDIS_DEFINITION(0x8, 0x285), ZYDIS_DEFINITION(0x8, 0x286) },
    { ZYDIS_DEFINITION(0x8, 0x2B3), ZYDIS_DEFINITION(0x8, 0x2B4) },
    { ZYDIS_DEFINITION(0x8, 0x29E), ZYDIS_DEFINITION(0x8, 0x29F) },
    { ZYDIS_DEFINITION(0x8, 0x2AD), ZYDIS_DEFINITION(0x8, 0x2AE) },
    { ZYDIS_DEFINITION(0x8, 0x299), ZYDIS_DEFINITION(0x8, 0x29A) },
    { ZYDIS_DEFINITION(0x8, 0x26D), ZYDIS_DEFINITION(0x8, 0x26E) },
    { ZYDIS_DEFINITION(0x8, 0x28A), ZYDIS_DEFINITION(0x8, 0x28B) },
    { ZYDIS_DEFINITION(0x8, 0x272), ZYDIS_DEFINITION(0x8, 0x273) },
    { ZYDIS_DEFINITION(0x8, 0x28F), ZYDIS_DEFINITION(0x8, 0x290) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x28) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x3F4) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x12) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x646) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x5E) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x6EF) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x772) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0xED) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x29) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x3F5) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x13) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x647) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x5F) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x6F0) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0x773) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xD, 0xEE) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x12, 0xA7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0xD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0xE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0xF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x10) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2C5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4EF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x447), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x448), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x449), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x457), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x459), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x460), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x462), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x464), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x465), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x502), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x503), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x488), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x489) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x490), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x491), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x492) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x49F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x500) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x523), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x524) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x600), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x601), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x60F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x65B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x65C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x676), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x677) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x67F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x680) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x687), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6CB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6CD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6CF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E3), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6EB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6EC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6ED), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6EF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6FB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x70F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x710), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x718), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x719), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x71A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x71B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x71C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x71D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x71E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x71F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x720) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x721), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x722) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2C2) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x252) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x3, 0x2) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x3, 0x1) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x62A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x38), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_ADDRESS_SIZE, 0x39) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x10), ZYDIS_DEFINITION(0x9, 0xAA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_AMD, 0x11), ZYDIS_DEFINITION(0x9, 0x279) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x12, 0x27A) },
    { ZYDIS_DEFINITION(0x8, 0x27B), ZYDIS_DEFINITION(0x8, 0x27C) }
};

const ZydisDecoderTreeNode FILTERS_PREFIX_GROUP1[][2] =
{
    { ZYDIS_DEFINITION(0x1, 0x327), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9E) },
    { ZYDIS_DEFINITION(0x1, 0x328), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x1A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x137) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x25), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x148) }
};

const ZydisDecoderTreeNode FILTERS_MODRM_MOD[][4] =
{
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_MODRM_MOD_COMPACT[][2] =
{
    { ZYDIS_DEFINITION(0x1, 0x1A), ZYDIS_DEFINITION(0x1, 0x1B) },
    { ZYDIS_DEFINITION(0x1, 0x1C), ZYDIS_DEFINITION(0x1, 0x1D) },
    { ZYDIS_DEFINITION(0x1, 0x1E), ZYDIS_DEFINITION(0x1, 0x1F) },
    { ZYDIS_DEFINITION(0x1, 0x20), ZYDIS_DEFINITION(0x1, 0x21) },
    { ZYDIS_DEFINITION(0x1, 0x3E6), ZYDIS_DEFINITION(0x1, 0x3E7) },
    { ZYDIS_DEFINITION(0x1, 0x3E8), ZYDIS_DEFINITION(0x1, 0x3E9) },
    { ZYDIS_DEFINITION(0x1, 0x3EA), ZYDIS_DEFINITION(0x1, 0x3EB) },
    { ZYDIS_DEFINITION(0x1, 0x3EC), ZYDIS_DEFINITION(0x1, 0x3ED) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1) },
    { ZYDIS_DEFINITION(0x1, 0x2BE), ZYDIS_DEFINITION(0x1, 0x2BF) },
    { ZYDIS_DEFINITION(0x1, 0x2E1), ZYDIS_DEFINITION(0x1, 0x2E2) },
    { ZYDIS_DEFINITION(0x1, 0x3AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x9) },
    { ZYDIS_DEFINITION(0x1, 0x2A), ZYDIS_DEFINITION(0x1, 0x2B) },
    { ZYDIS_DEFINITION(0x1, 0x28), ZYDIS_DEFINITION(0x1, 0x29) },
    { ZYDIS_DEFINITION(0x1, 0x4), ZYDIS_DEFINITION(0x1, 0x5) },
    { ZYDIS_DEFINITION(0x1, 0x2), ZYDIS_DEFINITION(0x1, 0x3) },
    { ZYDIS_DEFINITION(0x1, 0x18), ZYDIS_DEFINITION(0x1, 0x19) },
    { ZYDIS_DEFINITION(0x1, 0x1A), ZYDIS_DEFINITION(0x1, 0x1B) },
    { ZYDIS_DEFINITION(0x1, 0xC), ZYDIS_DEFINITION(0x1, 0xD) },
    { ZYDIS_DEFINITION(0x1, 0x14), ZYDIS_DEFINITION(0x1, 0x15) },
    { ZYDIS_DEFINITION(0x1, 0x1C), ZYDIS_DEFINITION(0x1, 0x1D) },
    { ZYDIS_DEFINITION(0x1, 0x22), ZYDIS_DEFINITION(0x1, 0x23) },
    { ZYDIS_DEFINITION(0x1, 0x24), ZYDIS_DEFINITION(0x1, 0x25) },
    { ZYDIS_DEFINITION(0x1, 0x8), ZYDIS_DEFINITION(0x1, 0x9) },
    { ZYDIS_DEFINITION(0x1, 0xE), ZYDIS_DEFINITION(0x1, 0xF) },
    { ZYDIS_DEFINITION(0x1, 0x12), ZYDIS_DEFINITION(0x1, 0x13) },
    { ZYDIS_DEFINITION(0x1, 0x10), ZYDIS_DEFINITION(0x1, 0x11) },
    { ZYDIS_DEFINITION(0x1, 0x20), ZYDIS_DEFINITION(0x1, 0x21) },
    { ZYDIS_DEFINITION(0x1, 0x26), ZYDIS_DEFINITION(0x1, 0x27) },
    { ZYDIS_DEFINITION(0x1, 0x6), ZYDIS_DEFINITION(0x1, 0x7) },
    { ZYDIS_DEFINITION(0x1, 0xA), ZYDIS_DEFINITION(0x1, 0xB) },
    { ZYDIS_DEFINITION(0x1, 0x16), ZYDIS_DEFINITION(0x1, 0x17) },
    { ZYDIS_DEFINITION(0x1, 0x1E), ZYDIS_DEFINITION(0x1, 0x1F) },
    { ZYDIS_DEFINITION(0x1, 0x2C), ZYDIS_DEFINITION(0x1, 0x2D) },
    { ZYDIS_DEFINITION(0x1, 0x2E), ZYDIS_DEFINITION(0x1, 0x2F) },
    { ZYDIS_DEFINITION(0x1, 0x0), ZYDIS_DEFINITION(0x1, 0x1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0xA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0xB) },
    { ZYDIS_DEFINITION(0x1, 0x3BC), ZYDIS_DEFINITION(0x1, 0x3BD) },
    { ZYDIS_DEFINITION(0x1, 0x3BE), ZYDIS_DEFINITION(0x1, 0x3BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11) },
    { ZYDIS_DEFINITION(0x1, 0x3C1), ZYDIS_DEFINITION(0x1, 0x3C2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13) },
    { ZYDIS_DEFINITION(0x1, 0x3C5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_CLDEMOTE, 0x0) },
    { ZYDIS_DEFINITION(0x1, 0x3C7), ZYDIS_DEFINITION(0x1, 0x3C8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15), ZYDIS_DEFINITION(0x1, 0x3C9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0xE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0xF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x20) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x21), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x22) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x23), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x24) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x27) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x28), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x29) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x2F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x30), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x31) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x32), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x33) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x34), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x35) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x36), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x37) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x38), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x39) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x3F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x40), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x41) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x42), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x43) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x44), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x45) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x46), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x47) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x48), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x49) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x4F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x50), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x51) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x52), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x53) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x54), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x55) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x56), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x57) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x58), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x59) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x5F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x60) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x61), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x62) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x63), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x64) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x65), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x66) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x67), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x68) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x69), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x6F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x70) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x71), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x72) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x73), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x74) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x75), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x76) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x77), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x78) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x79), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x7F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x80) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x81) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x82) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x83) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x84), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x85) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x86), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x87) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x88), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x89) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x8F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x90), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x91) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x92) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x93), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x94) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x95), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x96) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x97), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x98) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x99), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_PREFIX_GROUP1, 0x0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x9F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_PREFIX_GROUP1, 0x1) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA4) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xA9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xAF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xB9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xBF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xC9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xCF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xD9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDE), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0xD7), ZYDIS_DEFINITION(0x1, 0xD8) },
    { ZYDIS_DEFINITION(0x1, 0xCF), ZYDIS_DEFINITION(0x1, 0xD0) },
    { ZYDIS_DEFINITION(0x1, 0xBF), ZYDIS_DEFINITION(0x1, 0xC0) },
    { ZYDIS_DEFINITION(0x1, 0xC7), ZYDIS_DEFINITION(0x1, 0xC8) },
    { ZYDIS_DEFINITION(0x1, 0xDD), ZYDIS_DEFINITION(0x1, 0xDE) },
    { ZYDIS_DEFINITION(0x1, 0xD5), ZYDIS_DEFINITION(0x1, 0xD6) },
    { ZYDIS_DEFINITION(0x1, 0xC1), ZYDIS_DEFINITION(0x1, 0xC2) },
    { ZYDIS_DEFINITION(0x1, 0xC9), ZYDIS_DEFINITION(0x1, 0xCA) },
    { ZYDIS_DEFINITION(0x1, 0xDB), ZYDIS_DEFINITION(0x1, 0xDC) },
    { ZYDIS_DEFINITION(0x1, 0xD3), ZYDIS_DEFINITION(0x1, 0xD4) },
    { ZYDIS_DEFINITION(0x1, 0xD9), ZYDIS_DEFINITION(0x1, 0xDA) },
    { ZYDIS_DEFINITION(0x1, 0xD1), ZYDIS_DEFINITION(0x1, 0xD2) },
    { ZYDIS_DEFINITION(0x1, 0xC3), ZYDIS_DEFINITION(0x1, 0xC4) },
    { ZYDIS_DEFINITION(0x1, 0xCB), ZYDIS_DEFINITION(0x1, 0xCC) },
    { ZYDIS_DEFINITION(0x1, 0xC5), ZYDIS_DEFINITION(0x1, 0xC6) },
    { ZYDIS_DEFINITION(0x1, 0xCD), ZYDIS_DEFINITION(0x1, 0xCE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xDF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xE9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xEA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xEB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xEC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xED) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xEE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xEF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xF9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0xFF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x100), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x101) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x102), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x103) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x104), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x105) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x106), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x107) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x108), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x109) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x10F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x110), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x111) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x112), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x113) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x114), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x115) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x116), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x117) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x118), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x119) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x11F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x120), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x121), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x122), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x123), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x124) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x125), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x126) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x127), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x128) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x12F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x130), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x131) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x132), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x133) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x134), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x135) },
    { ZYDIS_DEFINITION(0x1, 0x673), ZYDIS_DEFINITION(0x1, 0x674) },
    { ZYDIS_DEFINITION(0x1, 0x66B), ZYDIS_DEFINITION(0x1, 0x66C) },
    { ZYDIS_DEFINITION(0x1, 0x65B), ZYDIS_DEFINITION(0x1, 0x65C) },
    { ZYDIS_DEFINITION(0x1, 0x663), ZYDIS_DEFINITION(0x1, 0x664) },
    { ZYDIS_DEFINITION(0x1, 0x67A), ZYDIS_DEFINITION(0x1, 0x67B) },
    { ZYDIS_DEFINITION(0x1, 0x671), ZYDIS_DEFINITION(0x1, 0x672) },
    { ZYDIS_DEFINITION(0x1, 0x65D), ZYDIS_DEFINITION(0x1, 0x65E) },
    { ZYDIS_DEFINITION(0x1, 0x665), ZYDIS_DEFINITION(0x1, 0x666) },
    { ZYDIS_DEFINITION(0x1, 0x677), ZYDIS_DEFINITION(0x1, 0x678) },
    { ZYDIS_DEFINITION(0x1, 0x66F), ZYDIS_DEFINITION(0x1, 0x670) },
    { ZYDIS_DEFINITION(0x1, 0x675), ZYDIS_DEFINITION(0x1, 0x676) },
    { ZYDIS_DEFINITION(0x1, 0x66D), ZYDIS_DEFINITION(0x1, 0x66E) },
    { ZYDIS_DEFINITION(0x1, 0x65F), ZYDIS_DEFINITION(0x1, 0x660) },
    { ZYDIS_DEFINITION(0x1, 0x667), ZYDIS_DEFINITION(0x1, 0x668) },
    { ZYDIS_DEFINITION(0x1, 0x661), ZYDIS_DEFINITION(0x1, 0x662) },
    { ZYDIS_DEFINITION(0x1, 0x669), ZYDIS_DEFINITION(0x1, 0x66A) },
    { ZYDIS_DEFINITION(0x1, 0x97), ZYDIS_DEFINITION(0x1, 0x98) },
    { ZYDIS_DEFINITION(0xB, 0x6A5), ZYDIS_DEFINITION(0xB, 0x6A6) },
    { ZYDIS_DEFINITION(0x1, 0x6A7), ZYDIS_DEFINITION(0x1, 0x6A8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x136), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_PREFIX_GROUP1, 0x2), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0xA3), ZYDIS_DEFINITION(0x1, 0xA4) },
    { ZYDIS_DEFINITION(0xB, 0x6B5), ZYDIS_DEFINITION(0xB, 0x6B6) },
    { ZYDIS_DEFINITION(0x1, 0x6B7), ZYDIS_DEFINITION(0x1, 0x6B8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x138), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x139) },
    { ZYDIS_DEFINITION(0x1, 0x230), ZYDIS_DEFINITION(0x1, 0x231) },
    { ZYDIS_DEFINITION(0x1, 0x105), ZYDIS_DEFINITION(0x1, 0x106) },
    { ZYDIS_DEFINITION(0x1, 0x107), ZYDIS_DEFINITION(0x1, 0x108) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2E3) },
    { ZYDIS_DEFINITION(0x1, 0x9F), ZYDIS_DEFINITION(0x1, 0xA0) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2C7) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2CA) },
    { ZYDIS_DEFINITION(0x1, 0x394), ZYDIS_DEFINITION(0x1, 0x395) },
    { ZYDIS_DEFINITION(0x1, 0x396), ZYDIS_DEFINITION(0x1, 0x397) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13B) },
    { ZYDIS_DEFINITION(0x1, 0x720), ZYDIS_DEFINITION(0x1, 0x721) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x23), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x24) },
    { ZYDIS_DEFINITION(0x1, 0x9D), ZYDIS_DEFINITION(0x1, 0x9E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x13F) },
    { ZYDIS_DEFINITION(0x1, 0x386), ZYDIS_DEFINITION(0x1, 0x387) },
    { ZYDIS_DEFINITION(0x1, 0x388), ZYDIS_DEFINITION(0x1, 0x389) },
    { ZYDIS_DEFINITION(0x1, 0x751), ZYDIS_DEFINITION(0x1, 0x752) },
    { ZYDIS_DEFINITION(0x1, 0x753), ZYDIS_DEFINITION(0x1, 0x754) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x140), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x141) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x142) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x143), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x144) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x145), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x146), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x147) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_PREFIX_GROUP1, 0x3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x149) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x14F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x150), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x151) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x152), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x153) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x154), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x155) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x156), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x157) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x158), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x159), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x15F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x160) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x161), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x162) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x163), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x164) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x165), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x166) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x167), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x168) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x169), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x16F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x170) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x171), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x172) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x173), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x174) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x175), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x176) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x177) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x178), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x179) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x17F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x180), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x181) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x182), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x183) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x184), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x185) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x186), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x187) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x188) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x189), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x18F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x190) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x191), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x192) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x193), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x194) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x195), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x196), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x197) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x198), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x199) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x19F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MANDATORY_PREFIX, 0x1A3) },
    { ZYDIS_DEFINITION(0x1, 0x71E), ZYDIS_DEFINITION(0x1, 0x71F) },
    { ZYDIS_DEFINITION(0x1, 0x4), ZYDIS_DEFINITION(0x1, 0x5) },
    { ZYDIS_DEFINITION(0x1, 0x6), ZYDIS_DEFINITION(0x1, 0x7) },
    { ZYDIS_DEFINITION(0x1, 0x8), ZYDIS_DEFINITION(0x1, 0x9) },
    { ZYDIS_DEFINITION(0x1, 0xA), ZYDIS_DEFINITION(0x1, 0xB) },
    { ZYDIS_DEFINITION(0x1, 0x638), ZYDIS_DEFINITION(0x1, 0x639) },
    { ZYDIS_DEFINITION(0x1, 0x63A), ZYDIS_DEFINITION(0x1, 0x63B) },
    { ZYDIS_DEFINITION(0x1, 0x63C), ZYDIS_DEFINITION(0x1, 0x63D) },
    { ZYDIS_DEFINITION(0x1, 0x63E), ZYDIS_DEFINITION(0x1, 0x63F) },
    { ZYDIS_DEFINITION(0x1, 0x50), ZYDIS_DEFINITION(0x1, 0x51) },
    { ZYDIS_DEFINITION(0x1, 0x52), ZYDIS_DEFINITION(0x1, 0x53) },
    { ZYDIS_DEFINITION(0x1, 0x54), ZYDIS_DEFINITION(0x1, 0x55) },
    { ZYDIS_DEFINITION(0x1, 0x56), ZYDIS_DEFINITION(0x1, 0x57) },
    { ZYDIS_DEFINITION(0x1, 0x6E1), ZYDIS_DEFINITION(0x1, 0x6E2) },
    { ZYDIS_DEFINITION(0x1, 0x6E3), ZYDIS_DEFINITION(0x1, 0x6E4) },
    { ZYDIS_DEFINITION(0x1, 0x6E5), ZYDIS_DEFINITION(0x1, 0x6E6) },
    { ZYDIS_DEFINITION(0x1, 0x6E7), ZYDIS_DEFINITION(0x1, 0x6E8) },
    { ZYDIS_DEFINITION(0x1, 0x764), ZYDIS_DEFINITION(0x1, 0x765) },
    { ZYDIS_DEFINITION(0x1, 0x766), ZYDIS_DEFINITION(0x1, 0x767) },
    { ZYDIS_DEFINITION(0x1, 0x768), ZYDIS_DEFINITION(0x1, 0x769) },
    { ZYDIS_DEFINITION(0x1, 0x76A), ZYDIS_DEFINITION(0x1, 0x76B) },
    { ZYDIS_DEFINITION(0x1, 0xDF), ZYDIS_DEFINITION(0x1, 0xE0) },
    { ZYDIS_DEFINITION(0x1, 0xE1), ZYDIS_DEFINITION(0x1, 0xE2) },
    { ZYDIS_DEFINITION(0x1, 0xE3), ZYDIS_DEFINITION(0x1, 0xE4) },
    { ZYDIS_DEFINITION(0x1, 0xE5), ZYDIS_DEFINITION(0x1, 0xE6) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x70) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x44), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x70), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x71) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x72), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x73) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x74), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x75) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x76), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x77) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x78), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x79) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x80), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x81) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x82), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x83) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x84), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x85) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x86), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x87) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x88), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x89) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x90), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x91) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x92), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x93) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x94), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x95) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x96), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x97) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x98), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x99) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA0) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA5) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA6) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAB) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xAF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xBF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x6C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x6D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x6E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x6F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x71), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x72) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x73), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x74) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x75), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x76) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x78), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x79) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x7A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x7B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x7C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x7D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xCF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x30) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xEB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xEC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xEE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xEF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xBA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xBB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xBD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xBE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xFF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x100) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x101), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x102) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x103), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x104) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xCA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xCB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xCC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xCD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x105), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x106) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x107), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x108) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xDA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xDB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x109), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xEA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xEB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xEC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xED) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x110), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x111) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x112), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x113) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x114), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x115) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x116), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x117) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xFF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x100) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x101), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x102) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x103), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x104) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x105), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x106) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x118), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x119) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x109), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x110), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x111) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x112), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x113) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x120), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x121) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x122), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x123) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x124), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x125) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x126), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x127) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x128), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x129) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x130), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x131) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x132), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x133) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x134) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x135) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x12E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x12F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x130), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x131) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x136), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x137) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x138), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x139) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x134), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x135) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x136), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x137) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x138), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x139) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x13A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x13B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x13C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x13D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x140), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x141) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x142), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x143) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x144) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x145), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x146) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x147), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x148) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x149), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x150), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x151) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x152), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x153) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x154), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x155) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x156), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x157) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x158), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x159) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x150) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x15F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x160) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x151), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x152) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x163), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x164) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x153), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x154) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x167), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x168) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x155), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x156) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x16B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x16C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x157), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x158) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x159), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x160) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x161), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x162) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x163), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x164) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x165), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x166) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x167), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x168) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x169), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x170) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x171), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x172) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x173), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x174) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x175), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x176) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x177), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x178) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x179), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x180) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x181), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x182) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x183), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x184) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x185), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x186) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x187), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x188) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x189), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x190) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x191), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x192) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x193), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x194) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x195), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x196) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x197), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x198) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x199), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1AF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x18) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x19) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1BB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1BD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CB) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1D9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1DF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1E9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1EB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1ED) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1EF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1F9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FD) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x31) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x32) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x206), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x207) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x208), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x209) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x20F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x210), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x211) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x26F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x270) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x271), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x272) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x273), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x274) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x275), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x276) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x212), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x213) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x214), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x215) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x216), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x217) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x218), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x219) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x21F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x220), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x221) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x222), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x223) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x283), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x284) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x285), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x286) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x287), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x288) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x224), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x225) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x28F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x290) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x226), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x227) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x228), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x229) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x22F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x230), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x231) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x232), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x233) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2A8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x234), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x235) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x236), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x237) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x238), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x239) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x23F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x240), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x241) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x242), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x243) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x244), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x245) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x246), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x247) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x248), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x249) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x24F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2D8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x250), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x251) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x252), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x253) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x254), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x255) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x256), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x257) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x258), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x259) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x260), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x261) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x262), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x263) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x264), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x265) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x266), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x267) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x268), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x269) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x270), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x271) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2FF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x272), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x273) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x274), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x275) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x276), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x277) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x278), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x279) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x306), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x307) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x280), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x281) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x282), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x283) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x284), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x285) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x286), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x287) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x288), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x289) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x290), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x291) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x292), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x293) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x294), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x295) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x296), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x297) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x298), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x299) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2AF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2B9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2CF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2DF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2EB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2ED) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x36E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x36F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2EF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2F9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2FF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x300), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x301) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x302), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x303) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x304), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x305) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x306), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x307) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x308), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x309) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x30F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x310), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x311) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x312), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x313) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x314), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x315) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x316), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x317) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x318), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x319) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x31F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x320) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x321), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x322) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x323), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x324) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x325), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x326) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x327), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x328) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x329), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x32F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x330), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x331) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x332), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x333) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x334), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x335) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x336), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x337) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x338), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x339) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x33F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x340), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x341) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x342), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x343) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x344), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x345) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x346), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x347) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x348), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x349) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x34F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x350), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x351) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x352), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x353) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x354), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x355) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x356), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x357) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x358), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x359) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x35F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x360), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x361) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x362), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x363) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x364), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x365) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x366), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x367) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x368), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x369) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x36F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x370), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x371) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x372), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x373) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x374), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x375) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x376), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x377) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x378), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x379) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x431), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x432) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x37F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x380), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x381) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x382), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x383) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x384), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x385) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x386), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x387) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x388), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x389) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x38F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x390) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x391) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x392) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x393) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x394), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x395) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x396), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x397) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x398), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x399) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x39F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A1) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x33) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AE) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3AF) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B0) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B1) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B8) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3B9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x34), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x35) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CF) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DE) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3DF) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E0) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E1) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3EA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3EC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3EE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3F9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x400) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x401), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x402) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x403) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x404) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x405) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x406) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x407), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x408) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x409), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x40F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x410) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x411), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x412) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x413), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x414) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x415), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x416) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x417), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x418) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x419), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x41F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x420) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x421), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x422) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x28) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x29) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x425), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x426) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x427), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x428) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x429), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x430) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x431), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x432) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x433), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x434) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x435), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x436) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x437), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x438) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x439), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x43F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x440) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x441), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x442) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x443), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x444) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x36) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x44B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x44C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x44D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x44E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x44F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x450) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x451), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x452) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x453), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x454) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x455), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x456) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x457) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x458) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x459) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x45F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x460) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x461), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x462) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x463), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x464) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x465), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x466) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x467), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x468) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x469), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x37) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x46F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x470) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x38) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x471), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x472) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x473), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x474) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xAA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xAB) },
    { ZYDIS_DEFINITION(0xE, 0x228), ZYDIS_DEFINITION(0xE, 0x229) },
    { ZYDIS_DEFINITION(0xD, 0x22A), ZYDIS_DEFINITION(0xD, 0x22B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x39), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x40) },
    { ZYDIS_DEFINITION(0x1, 0x707), ZYDIS_DEFINITION(0x1, 0x708) },
    { ZYDIS_DEFINITION(0x1, 0x709), ZYDIS_DEFINITION(0x1, 0x70A) },
    { ZYDIS_DEFINITION(0x1, 0x756), ZYDIS_DEFINITION(0x1, 0x757) },
    { ZYDIS_DEFINITION(0x1, 0x758), ZYDIS_DEFINITION(0x1, 0x759) },
    { ZYDIS_DEFINITION(0x1, 0x301), ZYDIS_DEFINITION(0x1, 0x302) },
    { ZYDIS_DEFINITION(0x1, 0x303), ZYDIS_DEFINITION(0x1, 0x304) },
    { ZYDIS_DEFINITION(0x1, 0x305), ZYDIS_DEFINITION(0x1, 0x306) },
    { ZYDIS_DEFINITION(0x1, 0x307), ZYDIS_DEFINITION(0x1, 0x308) },
    { ZYDIS_DEFINITION(0x1, 0x309), ZYDIS_DEFINITION(0x1, 0x30A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2C3) },
    { ZYDIS_DEFINITION(0x1, 0x30B), ZYDIS_DEFINITION(0x1, 0x30C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x41), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x42) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x475), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x476) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x477), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x478) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x479), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x47F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x480) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x481), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x482) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x483), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x484) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x485), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x486) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x487), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x488) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x489), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x48F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x490) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x491), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x492) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x493), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x494) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x495), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x496) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x497), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x498) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x499), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x49F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AA) },
    { ZYDIS_DEFINITION(0x1, 0x2), ZYDIS_DEFINITION(0x1, 0x3) },
    { ZYDIS_DEFINITION(0x1, 0xC), ZYDIS_DEFINITION(0x1, 0xD) },
    { ZYDIS_DEFINITION(0x1, 0xA), ZYDIS_DEFINITION(0x1, 0xB) },
    { ZYDIS_DEFINITION(0x1, 0x18), ZYDIS_DEFINITION(0x1, 0x19) },
    { ZYDIS_DEFINITION(0x1, 0x6), ZYDIS_DEFINITION(0x1, 0x7) },
    { ZYDIS_DEFINITION(0x1, 0xE), ZYDIS_DEFINITION(0x1, 0xF) },
    { ZYDIS_DEFINITION(0x1, 0x16), ZYDIS_DEFINITION(0x1, 0x17) },
    { ZYDIS_DEFINITION(0x1, 0x8), ZYDIS_DEFINITION(0x1, 0x9) },
    { ZYDIS_DEFINITION(0x1, 0x4), ZYDIS_DEFINITION(0x1, 0x5) },
    { ZYDIS_DEFINITION(0x1, 0x10), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x15), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4BF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4C9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4CF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4EA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4EC) },
    { ZYDIS_DEFINITION(0xC, 0x0), ZYDIS_DEFINITION(0xC, 0x1) },
    { ZYDIS_DEFINITION(0xC, 0x11), ZYDIS_DEFINITION(0xC, 0x12) },
    { ZYDIS_DEFINITION(0xC, 0x13), ZYDIS_DEFINITION(0xC, 0x14) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x47), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x48) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x49), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCF) },
    { ZYDIS_DEFINITION(0x1, 0x369), ZYDIS_DEFINITION(0x1, 0x36B) },
    { ZYDIS_DEFINITION(0x1, 0x36A), ZYDIS_DEFINITION(0x1, 0x36C) },
    { ZYDIS_DEFINITION(0x1, 0x36D), ZYDIS_DEFINITION(0x1, 0x36F) },
    { ZYDIS_DEFINITION(0x1, 0x36E), ZYDIS_DEFINITION(0x1, 0x370) },
    { ZYDIS_DEFINITION(0x1, 0x333), ZYDIS_DEFINITION(0x1, 0x33B) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x33C) },
    { ZYDIS_DEFINITION(0x1, 0x635), ZYDIS_DEFINITION(0x1, 0x637) },
    { ZYDIS_DEFINITION(0x1, 0x636), ZYDIS_DEFINITION(0x1, 0x638) },
    { ZYDIS_DEFINITION(0x1, 0x62D), ZYDIS_DEFINITION(0x1, 0x62F) },
    { ZYDIS_DEFINITION(0x1, 0x62E), ZYDIS_DEFINITION(0x1, 0x630) },
    { ZYDIS_DEFINITION(0x1, 0x338), ZYDIS_DEFINITION(0x1, 0x336) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x337) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x533) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x52C) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x52D) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x52E) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x532) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x52F) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x530) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x531) },
    { ZYDIS_DEFINITION(0x1, 0x30F), ZYDIS_DEFINITION(0x1, 0x311) },
    { ZYDIS_DEFINITION(0x1, 0x310), ZYDIS_DEFINITION(0x1, 0x312) },
    { ZYDIS_DEFINITION(0x1, 0x313), ZYDIS_DEFINITION(0x1, 0x315) },
    { ZYDIS_DEFINITION(0x1, 0x314), ZYDIS_DEFINITION(0x1, 0x316) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x347) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x348) },
    { ZYDIS_DEFINITION(0x1, 0x627), ZYDIS_DEFINITION(0x1, 0x628) },
    { ZYDIS_DEFINITION(0x1, 0x10F), ZYDIS_DEFINITION(0x1, 0x110) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F3), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4F9), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FD), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4FF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x500), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x501), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x33F), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x340), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x608), ZYDIS_DEFINITION(0x1, 0x60A) },
    { ZYDIS_DEFINITION(0x1, 0x609), ZYDIS_DEFINITION(0x1, 0x60B) },
    { ZYDIS_DEFINITION(0x1, 0x5F6), ZYDIS_DEFINITION(0x1, 0x5F8) },
    { ZYDIS_DEFINITION(0x1, 0x5F7), ZYDIS_DEFINITION(0x1, 0x5F9) },
    { ZYDIS_DEFINITION(0x1, 0x5E4), ZYDIS_DEFINITION(0x1, 0x5E6) },
    { ZYDIS_DEFINITION(0x1, 0x5E5), ZYDIS_DEFINITION(0x1, 0x5E7) },
    { ZYDIS_DEFINITION(0x1, 0xE5), ZYDIS_DEFINITION(0x1, 0xE7) },
    { ZYDIS_DEFINITION(0x1, 0xE6), ZYDIS_DEFINITION(0x1, 0xE8) },
    { ZYDIS_DEFINITION(0x1, 0xDD), ZYDIS_DEFINITION(0x1, 0xDF) },
    { ZYDIS_DEFINITION(0x1, 0xDE), ZYDIS_DEFINITION(0x1, 0xE0) },
    { ZYDIS_DEFINITION(0x1, 0x385), ZYDIS_DEFINITION(0x1, 0x387) },
    { ZYDIS_DEFINITION(0x1, 0x386), ZYDIS_DEFINITION(0x1, 0x388) },
    { ZYDIS_DEFINITION(0x1, 0x63D), ZYDIS_DEFINITION(0x1, 0x63F) },
    { ZYDIS_DEFINITION(0x1, 0x63E), ZYDIS_DEFINITION(0x1, 0x640) },
    { ZYDIS_DEFINITION(0x1, 0xB5), ZYDIS_DEFINITION(0x1, 0xB7) },
    { ZYDIS_DEFINITION(0x1, 0xB6), ZYDIS_DEFINITION(0x1, 0xB8) },
    { ZYDIS_DEFINITION(0x1, 0x379), ZYDIS_DEFINITION(0x1, 0x37B) },
    { ZYDIS_DEFINITION(0x1, 0x37A), ZYDIS_DEFINITION(0x1, 0x37C) },
    { ZYDIS_DEFINITION(0x1, 0x129), ZYDIS_DEFINITION(0x1, 0x12B) },
    { ZYDIS_DEFINITION(0x1, 0x12A), ZYDIS_DEFINITION(0x1, 0x12C) },
    { ZYDIS_DEFINITION(0x1, 0x115), ZYDIS_DEFINITION(0x1, 0x117) },
    { ZYDIS_DEFINITION(0x1, 0x116), ZYDIS_DEFINITION(0x1, 0x118) },
    { ZYDIS_DEFINITION(0x1, 0x615), ZYDIS_DEFINITION(0x1, 0x617) },
    { ZYDIS_DEFINITION(0x1, 0x616), ZYDIS_DEFINITION(0x1, 0x618) },
    { ZYDIS_DEFINITION(0x1, 0x2FF), ZYDIS_DEFINITION(0x1, 0x301) },
    { ZYDIS_DEFINITION(0x1, 0x300), ZYDIS_DEFINITION(0x1, 0x302) },
    { ZYDIS_DEFINITION(0x1, 0x165), ZYDIS_DEFINITION(0x1, 0x167) },
    { ZYDIS_DEFINITION(0x1, 0x166), ZYDIS_DEFINITION(0x1, 0x168) },
    { ZYDIS_DEFINITION(0x1, 0x2F3), ZYDIS_DEFINITION(0x1, 0x2F5) },
    { ZYDIS_DEFINITION(0x1, 0x2F4), ZYDIS_DEFINITION(0x1, 0x2F6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x504), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x505) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x506), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x507) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x508) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x509), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x50F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x510), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x511), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2E5) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x610) },
    { ZYDIS_DEFINITION(0xB, 0x105), ZYDIS_DEFINITION(0xB, 0x107) },
    { ZYDIS_DEFINITION(0xB, 0x106), ZYDIS_DEFINITION(0xB, 0x108) },
    { ZYDIS_DEFINITION(0xB, 0x600), ZYDIS_DEFINITION(0xB, 0x602) },
    { ZYDIS_DEFINITION(0xB, 0x601), ZYDIS_DEFINITION(0xB, 0x603) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x512), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x513) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x514) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x515) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x516) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x517) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x518) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x519) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51D) },
    { ZYDIS_DEFINITION(0x1, 0x4), ZYDIS_DEFINITION(0x1, 0x5) },
    { ZYDIS_DEFINITION(0x1, 0xC), ZYDIS_DEFINITION(0x1, 0xD) },
    { ZYDIS_DEFINITION(0x1, 0xA), ZYDIS_DEFINITION(0x1, 0xB) },
    { ZYDIS_DEFINITION(0x1, 0x8), ZYDIS_DEFINITION(0x1, 0x9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x51F) },
    { ZYDIS_DEFINITION(0x1, 0x12), ZYDIS_DEFINITION(0x1, 0x13) },
    { ZYDIS_DEFINITION(0x1, 0x6), ZYDIS_DEFINITION(0x1, 0x7) },
    { ZYDIS_DEFINITION(0x1, 0x361), ZYDIS_DEFINITION(0x1, 0x363) },
    { ZYDIS_DEFINITION(0x1, 0x362), ZYDIS_DEFINITION(0x1, 0x364) },
    { ZYDIS_DEFINITION(0x1, 0x365), ZYDIS_DEFINITION(0x1, 0x367) },
    { ZYDIS_DEFINITION(0x1, 0x366), ZYDIS_DEFINITION(0x1, 0x368) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x339) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x33A) },
    { ZYDIS_DEFINITION(0x1, 0x631), ZYDIS_DEFINITION(0x1, 0x633) },
    { ZYDIS_DEFINITION(0x1, 0x632), ZYDIS_DEFINITION(0x1, 0x634) },
    { ZYDIS_DEFINITION(0x1, 0x629), ZYDIS_DEFINITION(0x1, 0x62B) },
    { ZYDIS_DEFINITION(0x1, 0x62A), ZYDIS_DEFINITION(0x1, 0x62C) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x334) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x335) },
    { ZYDIS_DEFINITION(0x1, 0x307), ZYDIS_DEFINITION(0x1, 0x309) },
    { ZYDIS_DEFINITION(0x1, 0x308), ZYDIS_DEFINITION(0x1, 0x30A) },
    { ZYDIS_DEFINITION(0x1, 0x30B), ZYDIS_DEFINITION(0x1, 0x30D) },
    { ZYDIS_DEFINITION(0x1, 0x30C), ZYDIS_DEFINITION(0x1, 0x30E) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x345) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x346) },
    { ZYDIS_DEFINITION(0x1, 0x625), ZYDIS_DEFINITION(0x1, 0x626) },
    { ZYDIS_DEFINITION(0x1, 0x10D), ZYDIS_DEFINITION(0x1, 0x10E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x520), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x521), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x522), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x523), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x524), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x525), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x526), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x527), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x33D), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x33E), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x604), ZYDIS_DEFINITION(0x1, 0x606) },
    { ZYDIS_DEFINITION(0x1, 0x605), ZYDIS_DEFINITION(0x1, 0x607) },
    { ZYDIS_DEFINITION(0x1, 0xE1), ZYDIS_DEFINITION(0x1, 0xE3) },
    { ZYDIS_DEFINITION(0x1, 0xE2), ZYDIS_DEFINITION(0x1, 0xE4) },
    { ZYDIS_DEFINITION(0x1, 0xD9), ZYDIS_DEFINITION(0x1, 0xDB) },
    { ZYDIS_DEFINITION(0x1, 0xDA), ZYDIS_DEFINITION(0x1, 0xDC) },
    { ZYDIS_DEFINITION(0x1, 0x381), ZYDIS_DEFINITION(0x1, 0x383) },
    { ZYDIS_DEFINITION(0x1, 0x382), ZYDIS_DEFINITION(0x1, 0x384) },
    { ZYDIS_DEFINITION(0x1, 0x639), ZYDIS_DEFINITION(0x1, 0x63B) },
    { ZYDIS_DEFINITION(0x1, 0x63A), ZYDIS_DEFINITION(0x1, 0x63C) },
    { ZYDIS_DEFINITION(0x1, 0xB1), ZYDIS_DEFINITION(0x1, 0xB3) },
    { ZYDIS_DEFINITION(0x1, 0xB2), ZYDIS_DEFINITION(0x1, 0xB4) },
    { ZYDIS_DEFINITION(0x1, 0x375), ZYDIS_DEFINITION(0x1, 0x377) },
    { ZYDIS_DEFINITION(0x1, 0x376), ZYDIS_DEFINITION(0x1, 0x378) },
    { ZYDIS_DEFINITION(0x1, 0x11D), ZYDIS_DEFINITION(0x1, 0x11F) },
    { ZYDIS_DEFINITION(0x1, 0x11E), ZYDIS_DEFINITION(0x1, 0x120) },
    { ZYDIS_DEFINITION(0x1, 0x125), ZYDIS_DEFINITION(0x1, 0x127) },
    { ZYDIS_DEFINITION(0x1, 0x126), ZYDIS_DEFINITION(0x1, 0x128) },
    { ZYDIS_DEFINITION(0x1, 0x611), ZYDIS_DEFINITION(0x1, 0x613) },
    { ZYDIS_DEFINITION(0x1, 0x612), ZYDIS_DEFINITION(0x1, 0x614) },
    { ZYDIS_DEFINITION(0x1, 0x2FB), ZYDIS_DEFINITION(0x1, 0x2FD) },
    { ZYDIS_DEFINITION(0x1, 0x2FC), ZYDIS_DEFINITION(0x1, 0x2FE) },
    { ZYDIS_DEFINITION(0x1, 0x161), ZYDIS_DEFINITION(0x1, 0x163) },
    { ZYDIS_DEFINITION(0x1, 0x162), ZYDIS_DEFINITION(0x1, 0x164) },
    { ZYDIS_DEFINITION(0x1, 0x2EF), ZYDIS_DEFINITION(0x1, 0x2F1) },
    { ZYDIS_DEFINITION(0x1, 0x2F0), ZYDIS_DEFINITION(0x1, 0x2F2) },
    { ZYDIS_DEFINITION(0x1, 0x5D0), ZYDIS_DEFINITION(0x1, 0x5D2) },
    { ZYDIS_DEFINITION(0x1, 0x5D1), ZYDIS_DEFINITION(0x1, 0x5D3) },
    { ZYDIS_DEFINITION(0x1, 0x5DC), ZYDIS_DEFINITION(0x1, 0x5DE) },
    { ZYDIS_DEFINITION(0x1, 0x5DD), ZYDIS_DEFINITION(0x1, 0x5DF) },
    { ZYDIS_DEFINITION(0x1, 0x5D4), ZYDIS_DEFINITION(0x1, 0x5D6) },
    { ZYDIS_DEFINITION(0x1, 0x5D5), ZYDIS_DEFINITION(0x1, 0x5D7) },
    { ZYDIS_DEFINITION(0x1, 0x399), ZYDIS_DEFINITION(0x1, 0x39B) },
    { ZYDIS_DEFINITION(0x1, 0x39A), ZYDIS_DEFINITION(0x1, 0x39C) },
    { ZYDIS_DEFINITION(0x1, 0x413), ZYDIS_DEFINITION(0x1, 0x415) },
    { ZYDIS_DEFINITION(0x1, 0x414), ZYDIS_DEFINITION(0x1, 0x416) },
    { ZYDIS_DEFINITION(0x1, 0x41F), ZYDIS_DEFINITION(0x1, 0x421) },
    { ZYDIS_DEFINITION(0x1, 0x420), ZYDIS_DEFINITION(0x1, 0x422) },
    { ZYDIS_DEFINITION(0x1, 0x417), ZYDIS_DEFINITION(0x1, 0x419) },
    { ZYDIS_DEFINITION(0x1, 0x418), ZYDIS_DEFINITION(0x1, 0x41A) },
    { ZYDIS_DEFINITION(0x1, 0x3A1), ZYDIS_DEFINITION(0x1, 0x3A3) },
    { ZYDIS_DEFINITION(0x1, 0x3A2), ZYDIS_DEFINITION(0x1, 0x3A4) },
    { ZYDIS_DEFINITION(0x1, 0x5C0), ZYDIS_DEFINITION(0x1, 0x5C2) },
    { ZYDIS_DEFINITION(0x1, 0x5C1), ZYDIS_DEFINITION(0x1, 0x5C3) },
    { ZYDIS_DEFINITION(0x1, 0x5CC), ZYDIS_DEFINITION(0x1, 0x5CE) },
    { ZYDIS_DEFINITION(0x1, 0x5CD), ZYDIS_DEFINITION(0x1, 0x5CF) },
    { ZYDIS_DEFINITION(0x1, 0x5C4), ZYDIS_DEFINITION(0x1, 0x5C6) },
    { ZYDIS_DEFINITION(0x1, 0x5C5), ZYDIS_DEFINITION(0x1, 0x5C7) },
    { ZYDIS_DEFINITION(0x1, 0x395), ZYDIS_DEFINITION(0x1, 0x397) },
    { ZYDIS_DEFINITION(0x1, 0x396), ZYDIS_DEFINITION(0x1, 0x398) },
    { ZYDIS_DEFINITION(0x1, 0x5D8), ZYDIS_DEFINITION(0x1, 0x5DA) },
    { ZYDIS_DEFINITION(0x1, 0x5D9), ZYDIS_DEFINITION(0x1, 0x5DB) },
    { ZYDIS_DEFINITION(0x1, 0x5C8), ZYDIS_DEFINITION(0x1, 0x5CA) },
    { ZYDIS_DEFINITION(0x1, 0x5C9), ZYDIS_DEFINITION(0x1, 0x5CB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x528), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x529) },
    { ZYDIS_DEFINITION(0x1, 0x319), ZYDIS_DEFINITION(0x1, 0x31A) },
    { ZYDIS_DEFINITION(0x1, 0x323), ZYDIS_DEFINITION(0x1, 0x325) },
    { ZYDIS_DEFINITION(0x1, 0x324), ZYDIS_DEFINITION(0x1, 0x326) },
    { ZYDIS_DEFINITION(0xB, 0x53C), ZYDIS_DEFINITION(0xB, 0x53E) },
    { ZYDIS_DEFINITION(0xB, 0x53D), ZYDIS_DEFINITION(0xB, 0x53F) },
    { ZYDIS_DEFINITION(0xB, 0x596), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x597), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x57A), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x57B), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x56A), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x56B), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x580), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x581), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x570), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x571), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x554), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x555), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x588), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x589), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x586), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x587), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x55C), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x55D), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x55A), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x55B), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x3F9), ZYDIS_DEFINITION(0x1, 0x3FB) },
    { ZYDIS_DEFINITION(0x1, 0x3FA), ZYDIS_DEFINITION(0x1, 0x3FC) },
    { ZYDIS_DEFINITION(0x1, 0x405), ZYDIS_DEFINITION(0x1, 0x407) },
    { ZYDIS_DEFINITION(0x1, 0x406), ZYDIS_DEFINITION(0x1, 0x408) },
    { ZYDIS_DEFINITION(0x1, 0x3FD), ZYDIS_DEFINITION(0x1, 0x3FF) },
    { ZYDIS_DEFINITION(0x1, 0x3FE), ZYDIS_DEFINITION(0x1, 0x400) },
    { ZYDIS_DEFINITION(0x1, 0x2CD), ZYDIS_DEFINITION(0x1, 0x2CF) },
    { ZYDIS_DEFINITION(0x1, 0x2CE), ZYDIS_DEFINITION(0x1, 0x2D0) },
    { ZYDIS_DEFINITION(0x1, 0x2D5), ZYDIS_DEFINITION(0x1, 0x2D7) },
    { ZYDIS_DEFINITION(0x1, 0x2D6), ZYDIS_DEFINITION(0x1, 0x2D8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52B) },
    { ZYDIS_DEFINITION(0x1, 0x31D), ZYDIS_DEFINITION(0x1, 0x31E) },
    { ZYDIS_DEFINITION(0x1, 0x327), ZYDIS_DEFINITION(0x1, 0x329) },
    { ZYDIS_DEFINITION(0x1, 0x328), ZYDIS_DEFINITION(0x1, 0x32A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x52F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x530), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x531), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x532), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x101), ZYDIS_DEFINITION(0xB, 0x103) },
    { ZYDIS_DEFINITION(0xB, 0x102), ZYDIS_DEFINITION(0xB, 0x104) },
    { ZYDIS_DEFINITION(0xB, 0x498), ZYDIS_DEFINITION(0xB, 0x499) },
    { ZYDIS_DEFINITION(0xB, 0x46B), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5FC), ZYDIS_DEFINITION(0xB, 0x5FE) },
    { ZYDIS_DEFINITION(0xB, 0x5FD), ZYDIS_DEFINITION(0xB, 0x5FF) },
    { ZYDIS_DEFINITION(0x1, 0xBD), ZYDIS_DEFINITION(0x1, 0xBF) },
    { ZYDIS_DEFINITION(0x1, 0xBE), ZYDIS_DEFINITION(0x1, 0xC0) },
    { ZYDIS_DEFINITION(0x1, 0x598), ZYDIS_DEFINITION(0x1, 0x59A) },
    { ZYDIS_DEFINITION(0x1, 0x599), ZYDIS_DEFINITION(0x1, 0x59B) },
    { ZYDIS_DEFINITION(0x1, 0x582), ZYDIS_DEFINITION(0x1, 0x584) },
    { ZYDIS_DEFINITION(0x1, 0x583), ZYDIS_DEFINITION(0x1, 0x585) },
    { ZYDIS_DEFINITION(0x1, 0x58A), ZYDIS_DEFINITION(0x1, 0x58C) },
    { ZYDIS_DEFINITION(0x1, 0x58B), ZYDIS_DEFINITION(0x1, 0x58D) },
    { ZYDIS_DEFINITION(0x1, 0x3AD), ZYDIS_DEFINITION(0x1, 0x3AF) },
    { ZYDIS_DEFINITION(0x1, 0x3AE), ZYDIS_DEFINITION(0x1, 0x3B0) },
    { ZYDIS_DEFINITION(0x1, 0x520), ZYDIS_DEFINITION(0x1, 0x522) },
    { ZYDIS_DEFINITION(0x1, 0x521), ZYDIS_DEFINITION(0x1, 0x523) },
    { ZYDIS_DEFINITION(0x1, 0x34F), ZYDIS_DEFINITION(0x1, 0x350) },
    { ZYDIS_DEFINITION(0x1, 0x4DA), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x4DB), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x5B0), ZYDIS_DEFINITION(0x1, 0x5B2) },
    { ZYDIS_DEFINITION(0x1, 0x5B1), ZYDIS_DEFINITION(0x1, 0x5B3) },
    { ZYDIS_DEFINITION(0x1, 0x5B4), ZYDIS_DEFINITION(0x1, 0x5B6) },
    { ZYDIS_DEFINITION(0x1, 0x5B5), ZYDIS_DEFINITION(0x1, 0x5B7) },
    { ZYDIS_DEFINITION(0x1, 0x4CE), ZYDIS_DEFINITION(0x1, 0x4D0) },
    { ZYDIS_DEFINITION(0x1, 0x4CF), ZYDIS_DEFINITION(0x1, 0x4D1) },
    { ZYDIS_DEFINITION(0x1, 0x3C9), ZYDIS_DEFINITION(0x1, 0x3CB) },
    { ZYDIS_DEFINITION(0x1, 0x3CA), ZYDIS_DEFINITION(0x1, 0x3CC) },
    { ZYDIS_DEFINITION(0x1, 0x3B9), ZYDIS_DEFINITION(0x1, 0x3BB) },
    { ZYDIS_DEFINITION(0x1, 0x3BA), ZYDIS_DEFINITION(0x1, 0x3BC) },
    { ZYDIS_DEFINITION(0x1, 0x3BD), ZYDIS_DEFINITION(0x1, 0x3BF) },
    { ZYDIS_DEFINITION(0x1, 0x3BE), ZYDIS_DEFINITION(0x1, 0x3C0) },
    { ZYDIS_DEFINITION(0x1, 0x4B6), ZYDIS_DEFINITION(0x1, 0x4B8) },
    { ZYDIS_DEFINITION(0x1, 0x4B7), ZYDIS_DEFINITION(0x1, 0x4B9) },
    { ZYDIS_DEFINITION(0x1, 0x3CD), ZYDIS_DEFINITION(0x1, 0x3CF) },
    { ZYDIS_DEFINITION(0x1, 0x3CE), ZYDIS_DEFINITION(0x1, 0x3D0) },
    { ZYDIS_DEFINITION(0x1, 0x3D1), ZYDIS_DEFINITION(0x1, 0x3D3) },
    { ZYDIS_DEFINITION(0x1, 0x3D2), ZYDIS_DEFINITION(0x1, 0x3D4) },
    { ZYDIS_DEFINITION(0x1, 0x57C), ZYDIS_DEFINITION(0x1, 0x57E) },
    { ZYDIS_DEFINITION(0x1, 0x57D), ZYDIS_DEFINITION(0x1, 0x57F) },
    { ZYDIS_DEFINITION(0x1, 0x572), ZYDIS_DEFINITION(0x1, 0x574) },
    { ZYDIS_DEFINITION(0x1, 0x573), ZYDIS_DEFINITION(0x1, 0x575) },
    { ZYDIS_DEFINITION(0x1, 0x3D5), ZYDIS_DEFINITION(0x1, 0x3D7) },
    { ZYDIS_DEFINITION(0x1, 0x3D6), ZYDIS_DEFINITION(0x1, 0x3D8) },
    { ZYDIS_DEFINITION(0x1, 0x514), ZYDIS_DEFINITION(0x1, 0x516) },
    { ZYDIS_DEFINITION(0x1, 0x515), ZYDIS_DEFINITION(0x1, 0x517) },
    { ZYDIS_DEFINITION(0x1, 0x518), ZYDIS_DEFINITION(0x1, 0x51A) },
    { ZYDIS_DEFINITION(0x1, 0x519), ZYDIS_DEFINITION(0x1, 0x51B) },
    { ZYDIS_DEFINITION(0x1, 0x14D), ZYDIS_DEFINITION(0x1, 0x14F) },
    { ZYDIS_DEFINITION(0x1, 0x14E), ZYDIS_DEFINITION(0x1, 0x150) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x341) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x342) },
    { ZYDIS_DEFINITION(0x1, 0x5A8), ZYDIS_DEFINITION(0x1, 0x5AA) },
    { ZYDIS_DEFINITION(0x1, 0x5A9), ZYDIS_DEFINITION(0x1, 0x5AB) },
    { ZYDIS_DEFINITION(0x1, 0x5AC), ZYDIS_DEFINITION(0x1, 0x5AE) },
    { ZYDIS_DEFINITION(0x1, 0x5AD), ZYDIS_DEFINITION(0x1, 0x5AF) },
    { ZYDIS_DEFINITION(0x1, 0x4CA), ZYDIS_DEFINITION(0x1, 0x4CC) },
    { ZYDIS_DEFINITION(0x1, 0x4CB), ZYDIS_DEFINITION(0x1, 0x4CD) },
    { ZYDIS_DEFINITION(0x1, 0x528), ZYDIS_DEFINITION(0x1, 0x52A) },
    { ZYDIS_DEFINITION(0x1, 0x529), ZYDIS_DEFINITION(0x1, 0x52B) },
    { ZYDIS_DEFINITION(0x1, 0x3B1), ZYDIS_DEFINITION(0x1, 0x3B3) },
    { ZYDIS_DEFINITION(0x1, 0x3B2), ZYDIS_DEFINITION(0x1, 0x3B4) },
    { ZYDIS_DEFINITION(0x1, 0x3B5), ZYDIS_DEFINITION(0x1, 0x3B7) },
    { ZYDIS_DEFINITION(0x1, 0x3B6), ZYDIS_DEFINITION(0x1, 0x3B8) },
    { ZYDIS_DEFINITION(0x1, 0x4B2), ZYDIS_DEFINITION(0x1, 0x4B4) },
    { ZYDIS_DEFINITION(0x1, 0x4B3), ZYDIS_DEFINITION(0x1, 0x4B5) },
    { ZYDIS_DEFINITION(0x1, 0x5E0), ZYDIS_DEFINITION(0x1, 0x5E2) },
    { ZYDIS_DEFINITION(0x1, 0x5E1), ZYDIS_DEFINITION(0x1, 0x5E3) },
    { ZYDIS_DEFINITION(0x1, 0x56C), ZYDIS_DEFINITION(0x1, 0x56E) },
    { ZYDIS_DEFINITION(0x1, 0x56D), ZYDIS_DEFINITION(0x1, 0x56F) },
    { ZYDIS_DEFINITION(0x1, 0x556), ZYDIS_DEFINITION(0x1, 0x558) },
    { ZYDIS_DEFINITION(0x1, 0x557), ZYDIS_DEFINITION(0x1, 0x559) },
    { ZYDIS_DEFINITION(0x1, 0x55E), ZYDIS_DEFINITION(0x1, 0x560) },
    { ZYDIS_DEFINITION(0x1, 0x55F), ZYDIS_DEFINITION(0x1, 0x561) },
    { ZYDIS_DEFINITION(0x1, 0x524), ZYDIS_DEFINITION(0x1, 0x526) },
    { ZYDIS_DEFINITION(0x1, 0x525), ZYDIS_DEFINITION(0x1, 0x527) },
    { ZYDIS_DEFINITION(0x1, 0x49E), ZYDIS_DEFINITION(0x1, 0x4A0) },
    { ZYDIS_DEFINITION(0x1, 0x49F), ZYDIS_DEFINITION(0x1, 0x4A1) },
    { ZYDIS_DEFINITION(0x1, 0x534), ZYDIS_DEFINITION(0x1, 0x536) },
    { ZYDIS_DEFINITION(0x1, 0x535), ZYDIS_DEFINITION(0x1, 0x537) },
    { ZYDIS_DEFINITION(0x1, 0x2E6), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x59C), ZYDIS_DEFINITION(0x1, 0x59E) },
    { ZYDIS_DEFINITION(0x1, 0x59D), ZYDIS_DEFINITION(0x1, 0x59F) },
    { ZYDIS_DEFINITION(0x1, 0x5B8), ZYDIS_DEFINITION(0x1, 0x5BA) },
    { ZYDIS_DEFINITION(0x1, 0x5B9), ZYDIS_DEFINITION(0x1, 0x5BB) },
    { ZYDIS_DEFINITION(0x1, 0x5A0), ZYDIS_DEFINITION(0x1, 0x5A2) },
    { ZYDIS_DEFINITION(0x1, 0x5A1), ZYDIS_DEFINITION(0x1, 0x5A3) },
    { ZYDIS_DEFINITION(0x1, 0x5A4), ZYDIS_DEFINITION(0x1, 0x5A6) },
    { ZYDIS_DEFINITION(0x1, 0x5A5), ZYDIS_DEFINITION(0x1, 0x5A7) },
    { ZYDIS_DEFINITION(0x1, 0x3A5), ZYDIS_DEFINITION(0x1, 0x3A7) },
    { ZYDIS_DEFINITION(0x1, 0x3A6), ZYDIS_DEFINITION(0x1, 0x3A8) },
    { ZYDIS_DEFINITION(0x1, 0x3C1), ZYDIS_DEFINITION(0x1, 0x3C3) },
    { ZYDIS_DEFINITION(0x1, 0x3C2), ZYDIS_DEFINITION(0x1, 0x3C4) },
    { ZYDIS_DEFINITION(0x1, 0x3A9), ZYDIS_DEFINITION(0x1, 0x3AB) },
    { ZYDIS_DEFINITION(0x1, 0x3AA), ZYDIS_DEFINITION(0x1, 0x3AC) },
    { ZYDIS_DEFINITION(0x1, 0x538), ZYDIS_DEFINITION(0x1, 0x53A) },
    { ZYDIS_DEFINITION(0x1, 0x539), ZYDIS_DEFINITION(0x1, 0x53B) },
    { ZYDIS_DEFINITION(0x1, 0x47E), ZYDIS_DEFINITION(0x1, 0x480) },
    { ZYDIS_DEFINITION(0x1, 0x47F), ZYDIS_DEFINITION(0x1, 0x481) },
    { ZYDIS_DEFINITION(0x1, 0x476), ZYDIS_DEFINITION(0x1, 0x478) },
    { ZYDIS_DEFINITION(0x1, 0x477), ZYDIS_DEFINITION(0x1, 0x479) },
    { ZYDIS_DEFINITION(0x1, 0x47A), ZYDIS_DEFINITION(0x1, 0x47C) },
    { ZYDIS_DEFINITION(0x1, 0x47B), ZYDIS_DEFINITION(0x1, 0x47D) },
    { ZYDIS_DEFINITION(0x1, 0x49A), ZYDIS_DEFINITION(0x1, 0x49C) },
    { ZYDIS_DEFINITION(0x1, 0x49B), ZYDIS_DEFINITION(0x1, 0x49D) },
    { ZYDIS_DEFINITION(0x1, 0x48C), ZYDIS_DEFINITION(0x1, 0x48E) },
    { ZYDIS_DEFINITION(0x1, 0x48D), ZYDIS_DEFINITION(0x1, 0x48F) },
    { ZYDIS_DEFINITION(0x1, 0x484), ZYDIS_DEFINITION(0x1, 0x486) },
    { ZYDIS_DEFINITION(0x1, 0x485), ZYDIS_DEFINITION(0x1, 0x487) },
    { ZYDIS_DEFINITION(0x1, 0x488), ZYDIS_DEFINITION(0x1, 0x48A) },
    { ZYDIS_DEFINITION(0x1, 0x489), ZYDIS_DEFINITION(0x1, 0x48B) },
    { ZYDIS_DEFINITION(0x1, 0x548), ZYDIS_DEFINITION(0x1, 0x54A) },
    { ZYDIS_DEFINITION(0x1, 0x549), ZYDIS_DEFINITION(0x1, 0x54B) },
    { ZYDIS_DEFINITION(0x1, 0x550), ZYDIS_DEFINITION(0x1, 0x552) },
    { ZYDIS_DEFINITION(0x1, 0x551), ZYDIS_DEFINITION(0x1, 0x553) },
    { ZYDIS_DEFINITION(0x1, 0x54C), ZYDIS_DEFINITION(0x1, 0x54E) },
    { ZYDIS_DEFINITION(0x1, 0x54D), ZYDIS_DEFINITION(0x1, 0x54F) },
    { ZYDIS_DEFINITION(0x1, 0x510), ZYDIS_DEFINITION(0x1, 0x512) },
    { ZYDIS_DEFINITION(0x1, 0x511), ZYDIS_DEFINITION(0x1, 0x513) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x533), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x534) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x535), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x536) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x537), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x538) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x539), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x53F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x540) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x541), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x542) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x543), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x544) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x545), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x546) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x547), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x548) },
    { ZYDIS_DEFINITION(0x1, 0x5BC), ZYDIS_DEFINITION(0x1, 0x5BE) },
    { ZYDIS_DEFINITION(0x1, 0x5BD), ZYDIS_DEFINITION(0x1, 0x5BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x549), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x54F) },
    { ZYDIS_DEFINITION(0x1, 0x389), ZYDIS_DEFINITION(0x1, 0x38B) },
    { ZYDIS_DEFINITION(0x1, 0x38A), ZYDIS_DEFINITION(0x1, 0x38C) },
    { ZYDIS_DEFINITION(0x1, 0x391), ZYDIS_DEFINITION(0x1, 0x393) },
    { ZYDIS_DEFINITION(0x1, 0x392), ZYDIS_DEFINITION(0x1, 0x394) },
    { ZYDIS_DEFINITION(0x1, 0x38D), ZYDIS_DEFINITION(0x1, 0x38F) },
    { ZYDIS_DEFINITION(0x1, 0x38E), ZYDIS_DEFINITION(0x1, 0x390) },
    { ZYDIS_DEFINITION(0x1, 0x4E4), ZYDIS_DEFINITION(0x1, 0x4E6) },
    { ZYDIS_DEFINITION(0x1, 0x4E5), ZYDIS_DEFINITION(0x1, 0x4E7) },
    { ZYDIS_DEFINITION(0x1, 0x4DC), ZYDIS_DEFINITION(0x1, 0x4DE) },
    { ZYDIS_DEFINITION(0x1, 0x4DD), ZYDIS_DEFINITION(0x1, 0x4DF) },
    { ZYDIS_DEFINITION(0x1, 0x4E0), ZYDIS_DEFINITION(0x1, 0x4E2) },
    { ZYDIS_DEFINITION(0x1, 0x4E1), ZYDIS_DEFINITION(0x1, 0x4E3) },
    { ZYDIS_DEFINITION(0x1, 0x4EC), ZYDIS_DEFINITION(0x1, 0x4EE) },
    { ZYDIS_DEFINITION(0x1, 0x4ED), ZYDIS_DEFINITION(0x1, 0x4EF) },
    { ZYDIS_DEFINITION(0x1, 0x4F0), ZYDIS_DEFINITION(0x1, 0x4F2) },
    { ZYDIS_DEFINITION(0x1, 0x4F1), ZYDIS_DEFINITION(0x1, 0x4F3) },
    { ZYDIS_DEFINITION(0x1, 0x4E8), ZYDIS_DEFINITION(0x1, 0x4EA) },
    { ZYDIS_DEFINITION(0x1, 0x4E9), ZYDIS_DEFINITION(0x1, 0x4EB) },
    { ZYDIS_DEFINITION(0x1, 0x50C), ZYDIS_DEFINITION(0x1, 0x50E) },
    { ZYDIS_DEFINITION(0x1, 0x50D), ZYDIS_DEFINITION(0x1, 0x50F) },
    { ZYDIS_DEFINITION(0x1, 0x401), ZYDIS_DEFINITION(0x1, 0x403) },
    { ZYDIS_DEFINITION(0x1, 0x402), ZYDIS_DEFINITION(0x1, 0x404) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x343) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x344) },
    { ZYDIS_DEFINITION(0x1, 0x39D), ZYDIS_DEFINITION(0x1, 0x39F) },
    { ZYDIS_DEFINITION(0x1, 0x39E), ZYDIS_DEFINITION(0x1, 0x3A0) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x550) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x551) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x552) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x553) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x554) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x555) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x556) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x557) },
    { ZYDIS_DEFINITION(0x1, 0x4FC), ZYDIS_DEFINITION(0x1, 0x4FE) },
    { ZYDIS_DEFINITION(0x1, 0x4FD), ZYDIS_DEFINITION(0x1, 0x4FF) },
    { ZYDIS_DEFINITION(0x1, 0x4F4), ZYDIS_DEFINITION(0x1, 0x4F6) },
    { ZYDIS_DEFINITION(0x1, 0x4F5), ZYDIS_DEFINITION(0x1, 0x4F7) },
    { ZYDIS_DEFINITION(0x1, 0x4F8), ZYDIS_DEFINITION(0x1, 0x4FA) },
    { ZYDIS_DEFINITION(0x1, 0x4F9), ZYDIS_DEFINITION(0x1, 0x4FB) },
    { ZYDIS_DEFINITION(0x1, 0x504), ZYDIS_DEFINITION(0x1, 0x506) },
    { ZYDIS_DEFINITION(0x1, 0x505), ZYDIS_DEFINITION(0x1, 0x507) },
    { ZYDIS_DEFINITION(0x1, 0x508), ZYDIS_DEFINITION(0x1, 0x50A) },
    { ZYDIS_DEFINITION(0x1, 0x509), ZYDIS_DEFINITION(0x1, 0x50B) },
    { ZYDIS_DEFINITION(0x1, 0x500), ZYDIS_DEFINITION(0x1, 0x502) },
    { ZYDIS_DEFINITION(0x1, 0x501), ZYDIS_DEFINITION(0x1, 0x503) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x558), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x559) },
    { ZYDIS_DEFINITION(0x1, 0x41B), ZYDIS_DEFINITION(0x1, 0x41D) },
    { ZYDIS_DEFINITION(0x1, 0x41C), ZYDIS_DEFINITION(0x1, 0x41E) },
    { ZYDIS_DEFINITION(0x1, 0x4C2), ZYDIS_DEFINITION(0x1, 0x4C4) },
    { ZYDIS_DEFINITION(0x1, 0x4C3), ZYDIS_DEFINITION(0x1, 0x4C5) },
    { ZYDIS_DEFINITION(0x1, 0x4C6), ZYDIS_DEFINITION(0x1, 0x4C8) },
    { ZYDIS_DEFINITION(0x1, 0x4C7), ZYDIS_DEFINITION(0x1, 0x4C9) },
    { ZYDIS_DEFINITION(0x1, 0x4D6), ZYDIS_DEFINITION(0x1, 0x4D8) },
    { ZYDIS_DEFINITION(0x1, 0x4D7), ZYDIS_DEFINITION(0x1, 0x4D9) },
    { ZYDIS_DEFINITION(0x1, 0x4D2), ZYDIS_DEFINITION(0x1, 0x4D4) },
    { ZYDIS_DEFINITION(0x1, 0x4D3), ZYDIS_DEFINITION(0x1, 0x4D5) },
    { ZYDIS_DEFINITION(0x1, 0x4AA), ZYDIS_DEFINITION(0x1, 0x4AC) },
    { ZYDIS_DEFINITION(0x1, 0x4AB), ZYDIS_DEFINITION(0x1, 0x4AD) },
    { ZYDIS_DEFINITION(0x1, 0x4AE), ZYDIS_DEFINITION(0x1, 0x4B0) },
    { ZYDIS_DEFINITION(0x1, 0x4AF), ZYDIS_DEFINITION(0x1, 0x4B1) },
    { ZYDIS_DEFINITION(0x1, 0x4BE), ZYDIS_DEFINITION(0x1, 0x4C0) },
    { ZYDIS_DEFINITION(0x1, 0x4BF), ZYDIS_DEFINITION(0x1, 0x4C1) },
    { ZYDIS_DEFINITION(0x1, 0x4BA), ZYDIS_DEFINITION(0x1, 0x4BC) },
    { ZYDIS_DEFINITION(0x1, 0x4BB), ZYDIS_DEFINITION(0x1, 0x4BD) },
    { ZYDIS_DEFINITION(0x1, 0x51C), ZYDIS_DEFINITION(0x1, 0x51E) },
    { ZYDIS_DEFINITION(0x1, 0x51D), ZYDIS_DEFINITION(0x1, 0x51F) },
    { ZYDIS_DEFINITION(0x1, 0x482), ZYDIS_DEFINITION(0x1, 0x483) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x55F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x560), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x561) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x562), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x563) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x564), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x565) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x566) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x567) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x568), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x569) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x56F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x570), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x571) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x572), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x573) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x574), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x575) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x576), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x577) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x578), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x579) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x57F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x580) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x581), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x582), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x583) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x584), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x585) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x586), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x587) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x588), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x589) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x58F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x590) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x591) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x592) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x593) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x594) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x595) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x596), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x597) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x598), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x599) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x59F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5A9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5AF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5B9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5BF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5C9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5CF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5D9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5DF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5E9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5EB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5ED) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5EF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5F9) },
    { ZYDIS_DEFINITION(0x1, 0xD5), ZYDIS_DEFINITION(0x1, 0xD6) },
    { ZYDIS_DEFINITION(0x1, 0xCD), ZYDIS_DEFINITION(0x1, 0xCF) },
    { ZYDIS_DEFINITION(0x1, 0xCE), ZYDIS_DEFINITION(0x1, 0xD0) },
    { ZYDIS_DEFINITION(0x1, 0xD1), ZYDIS_DEFINITION(0x1, 0xD3) },
    { ZYDIS_DEFINITION(0x1, 0xD2), ZYDIS_DEFINITION(0x1, 0xD4) },
    { ZYDIS_DEFINITION(0x1, 0xC5), ZYDIS_DEFINITION(0x1, 0xC7) },
    { ZYDIS_DEFINITION(0x1, 0xC6), ZYDIS_DEFINITION(0x1, 0xC8) },
    { ZYDIS_DEFINITION(0x1, 0xC9), ZYDIS_DEFINITION(0x1, 0xCB) },
    { ZYDIS_DEFINITION(0x1, 0xCA), ZYDIS_DEFINITION(0x1, 0xCC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FB) },
    { ZYDIS_DEFINITION(0x1, 0x98), ZYDIS_DEFINITION(0x1, 0x99) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5FF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x600), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x601) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x602), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x603) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x604), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x605) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x606), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x607) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x608), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x609) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60D) },
    { ZYDIS_DEFINITION(0xB, 0x5EE), ZYDIS_DEFINITION(0xB, 0x5F0) },
    { ZYDIS_DEFINITION(0xB, 0x5EF), ZYDIS_DEFINITION(0xB, 0x5F1) },
    { ZYDIS_DEFINITION(0xB, 0x5EA), ZYDIS_DEFINITION(0xB, 0x5EC) },
    { ZYDIS_DEFINITION(0xB, 0x5EB), ZYDIS_DEFINITION(0xB, 0x5ED) },
    { ZYDIS_DEFINITION(0xB, 0x5F4), ZYDIS_DEFINITION(0xB, 0x5F5) },
    { ZYDIS_DEFINITION(0xB, 0x5F2), ZYDIS_DEFINITION(0xB, 0x5F3) },
    { ZYDIS_DEFINITION(0xB, 0xED), ZYDIS_DEFINITION(0xB, 0xEF) },
    { ZYDIS_DEFINITION(0xB, 0xEE), ZYDIS_DEFINITION(0xB, 0xF0) },
    { ZYDIS_DEFINITION(0xB, 0xE9), ZYDIS_DEFINITION(0xB, 0xEB) },
    { ZYDIS_DEFINITION(0xB, 0xEA), ZYDIS_DEFINITION(0xB, 0xEC) },
    { ZYDIS_DEFINITION(0xB, 0x3E1), ZYDIS_DEFINITION(0xB, 0x3E3) },
    { ZYDIS_DEFINITION(0xB, 0x3E2), ZYDIS_DEFINITION(0xB, 0x3E4) },
    { ZYDIS_DEFINITION(0xB, 0x3C5), ZYDIS_DEFINITION(0xB, 0x3C7) },
    { ZYDIS_DEFINITION(0xB, 0x3C6), ZYDIS_DEFINITION(0xB, 0x3C8) },
    { ZYDIS_DEFINITION(0xB, 0x463), ZYDIS_DEFINITION(0xB, 0x464) },
    { ZYDIS_DEFINITION(0xB, 0x46C), ZYDIS_DEFINITION(0xB, 0x46D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x60F) },
    { ZYDIS_DEFINITION(0xB, 0x467), ZYDIS_DEFINITION(0xB, 0x468) },
    { ZYDIS_DEFINITION(0xB, 0x177), ZYDIS_DEFINITION(0xB, 0x178) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x610), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x611) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x612), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x613) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x614), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x615) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x616), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x617) },
    { ZYDIS_DEFINITION(0xB, 0x490), ZYDIS_DEFINITION(0xB, 0x491) },
    { ZYDIS_DEFINITION(0xB, 0x2E1), ZYDIS_DEFINITION(0xB, 0x2E2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x618), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x619) },
    { ZYDIS_DEFINITION(0xB, 0x494), ZYDIS_DEFINITION(0xB, 0x495) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x61F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x620), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x621) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x622), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x16F), ZYDIS_DEFINITION(0xB, 0x171) },
    { ZYDIS_DEFINITION(0xB, 0x170), ZYDIS_DEFINITION(0xB, 0x172) },
    { ZYDIS_DEFINITION(0xB, 0x16D), ZYDIS_DEFINITION(0xB, 0x16E) },
    { ZYDIS_DEFINITION(0xB, 0x371), ZYDIS_DEFINITION(0xB, 0x373) },
    { ZYDIS_DEFINITION(0xB, 0x372), ZYDIS_DEFINITION(0xB, 0x374) },
    { ZYDIS_DEFINITION(0xB, 0x3F5), ZYDIS_DEFINITION(0xB, 0x3F7) },
    { ZYDIS_DEFINITION(0xB, 0x3F6), ZYDIS_DEFINITION(0xB, 0x3F8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x623), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x624) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x625), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x626) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x627), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x628) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x629), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x62F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x630) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x631), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x632) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x633), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x634) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x635), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x636) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x637), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x638) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x639), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x63F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x640) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x641), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x642) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x643), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x644) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x645), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x646) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x647), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x648) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x649), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64A) },
    { ZYDIS_DEFINITION(0xB, 0x411), ZYDIS_DEFINITION(0xB, 0x412) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64C) },
    { ZYDIS_DEFINITION(0xB, 0x425), ZYDIS_DEFINITION(0xB, 0x426) },
    { ZYDIS_DEFINITION(0xB, 0x423), ZYDIS_DEFINITION(0xB, 0x424) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x64F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x650) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x651), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x652) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x653), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x654) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x655), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x656) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x657), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x658) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x659), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x65F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x660) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x661), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x662) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x663), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x664) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x665), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x666) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x667), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x668) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x669), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x66F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x670) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x671), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x672) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x673), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x674) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x675), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x676) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x677), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x678) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x679), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x67F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x680) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x681), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x682) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x683), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x684) },
    { ZYDIS_DEFINITION(0xB, 0xD7), ZYDIS_DEFINITION(0xB, 0xD8) },
    { ZYDIS_DEFINITION(0x1, 0x35D), ZYDIS_DEFINITION(0x1, 0x35E) },
    { ZYDIS_DEFINITION(0x1, 0x35F), ZYDIS_DEFINITION(0x1, 0x360) },
    { ZYDIS_DEFINITION(0x1, 0x359), ZYDIS_DEFINITION(0x1, 0x35B) },
    { ZYDIS_DEFINITION(0x1, 0x35A), ZYDIS_DEFINITION(0x1, 0x35C) },
    { ZYDIS_DEFINITION(0x1, 0x355), ZYDIS_DEFINITION(0x1, 0x357) },
    { ZYDIS_DEFINITION(0x1, 0x356), ZYDIS_DEFINITION(0x1, 0x358) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x685), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x686) },
    { ZYDIS_DEFINITION(0x1, 0x143), ZYDIS_DEFINITION(0x1, 0x144) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x687), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x688) },
    { ZYDIS_DEFINITION(0x1, 0x15F), ZYDIS_DEFINITION(0x1, 0x160) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x689), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68A) },
    { ZYDIS_DEFINITION(0x1, 0x14B), ZYDIS_DEFINITION(0x1, 0x14C) },
    { ZYDIS_DEFINITION(0x1, 0x60E), ZYDIS_DEFINITION(0x1, 0x60F) },
    { ZYDIS_DEFINITION(0x1, 0x5FA), ZYDIS_DEFINITION(0x1, 0x5FB) },
    { ZYDIS_DEFINITION(0x1, 0x5E8), ZYDIS_DEFINITION(0x1, 0x5E9) },
    { ZYDIS_DEFINITION(0x1, 0xBB), ZYDIS_DEFINITION(0x1, 0xBC) },
    { ZYDIS_DEFINITION(0x1, 0x37F), ZYDIS_DEFINITION(0x1, 0x380) },
    { ZYDIS_DEFINITION(0x1, 0x145), ZYDIS_DEFINITION(0x1, 0x146) },
    { ZYDIS_DEFINITION(0x1, 0x151), ZYDIS_DEFINITION(0x1, 0x153) },
    { ZYDIS_DEFINITION(0x1, 0x152), ZYDIS_DEFINITION(0x1, 0x154) },
    { ZYDIS_DEFINITION(0x1, 0x61B), ZYDIS_DEFINITION(0x1, 0x61C) },
    { ZYDIS_DEFINITION(0x1, 0x305), ZYDIS_DEFINITION(0x1, 0x306) },
    { ZYDIS_DEFINITION(0x1, 0x16B), ZYDIS_DEFINITION(0x1, 0x16C) },
    { ZYDIS_DEFINITION(0x1, 0x2F9), ZYDIS_DEFINITION(0x1, 0x2FA) },
    { ZYDIS_DEFINITION(0x1, 0x32B), ZYDIS_DEFINITION(0x1, 0x32D) },
    { ZYDIS_DEFINITION(0x1, 0x32C), ZYDIS_DEFINITION(0x1, 0x32E) },
    { ZYDIS_DEFINITION(0xB, 0x540), ZYDIS_DEFINITION(0xB, 0x542) },
    { ZYDIS_DEFINITION(0xB, 0x541), ZYDIS_DEFINITION(0xB, 0x543) },
    { ZYDIS_DEFINITION(0x1, 0x34D), ZYDIS_DEFINITION(0x1, 0x34E) },
    { ZYDIS_DEFINITION(0x1, 0x32F), ZYDIS_DEFINITION(0x1, 0x331) },
    { ZYDIS_DEFINITION(0x1, 0x330), ZYDIS_DEFINITION(0x1, 0x332) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68B), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x15) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68E), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x10B), ZYDIS_DEFINITION(0xB, 0x10C) },
    { ZYDIS_DEFINITION(0x1, 0x111), ZYDIS_DEFINITION(0x1, 0x113) },
    { ZYDIS_DEFINITION(0x1, 0x112), ZYDIS_DEFINITION(0x1, 0x114) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x68F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x690), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x691), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x692), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x693) },
    { ZYDIS_DEFINITION(0x1, 0x84), ZYDIS_DEFINITION(0x1, 0x85) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x694), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x695) },
    { ZYDIS_DEFINITION(0x1, 0x92), ZYDIS_DEFINITION(0x1, 0x93) },
    { ZYDIS_DEFINITION(0x1, 0x351), ZYDIS_DEFINITION(0x1, 0x352) },
    { ZYDIS_DEFINITION(0x1, 0x353), ZYDIS_DEFINITION(0x1, 0x354) },
    { ZYDIS_DEFINITION(0x1, 0x31F), ZYDIS_DEFINITION(0x1, 0x321) },
    { ZYDIS_DEFINITION(0x1, 0x320), ZYDIS_DEFINITION(0x1, 0x322) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x696), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x697) },
    { ZYDIS_DEFINITION(0x1, 0x13D), ZYDIS_DEFINITION(0x1, 0x13E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x698), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x699) },
    { ZYDIS_DEFINITION(0x1, 0x159), ZYDIS_DEFINITION(0x1, 0x15A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69B) },
    { ZYDIS_DEFINITION(0x1, 0x135), ZYDIS_DEFINITION(0x1, 0x136) },
    { ZYDIS_DEFINITION(0x1, 0x60C), ZYDIS_DEFINITION(0x1, 0x60D) },
    { ZYDIS_DEFINITION(0x1, 0xB9), ZYDIS_DEFINITION(0x1, 0xBA) },
    { ZYDIS_DEFINITION(0x1, 0x37D), ZYDIS_DEFINITION(0x1, 0x37E) },
    { ZYDIS_DEFINITION(0x1, 0x137), ZYDIS_DEFINITION(0x1, 0x138) },
    { ZYDIS_DEFINITION(0x1, 0x619), ZYDIS_DEFINITION(0x1, 0x61A) },
    { ZYDIS_DEFINITION(0x1, 0x303), ZYDIS_DEFINITION(0x1, 0x304) },
    { ZYDIS_DEFINITION(0x1, 0x169), ZYDIS_DEFINITION(0x1, 0x16A) },
    { ZYDIS_DEFINITION(0x1, 0x2F7), ZYDIS_DEFINITION(0x1, 0x2F8) },
    { ZYDIS_DEFINITION(0xB, 0x544), ZYDIS_DEFINITION(0xB, 0x546) },
    { ZYDIS_DEFINITION(0xB, 0x545), ZYDIS_DEFINITION(0xB, 0x547) },
    { ZYDIS_DEFINITION(0x1, 0x2D1), ZYDIS_DEFINITION(0x1, 0x2D3) },
    { ZYDIS_DEFINITION(0x1, 0x2D2), ZYDIS_DEFINITION(0x1, 0x2D4) },
    { ZYDIS_DEFINITION(0x1, 0x2D9), ZYDIS_DEFINITION(0x1, 0x2DB) },
    { ZYDIS_DEFINITION(0x1, 0x2DA), ZYDIS_DEFINITION(0x1, 0x2DC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69C), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x3C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69D), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x3E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69E), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x14) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x69F), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x109), ZYDIS_DEFINITION(0xB, 0x10A) },
    { ZYDIS_DEFINITION(0x1, 0xC1), ZYDIS_DEFINITION(0x1, 0xC3) },
    { ZYDIS_DEFINITION(0x1, 0xC2), ZYDIS_DEFINITION(0x1, 0xC4) },
    { ZYDIS_DEFINITION(0x1, 0x119), ZYDIS_DEFINITION(0x1, 0x11B) },
    { ZYDIS_DEFINITION(0x1, 0x11A), ZYDIS_DEFINITION(0x1, 0x11C) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2E3) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2E4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A0), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A4) },
    { ZYDIS_DEFINITION(0x1, 0x7E), ZYDIS_DEFINITION(0x1, 0x7F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A6) },
    { ZYDIS_DEFINITION(0x1, 0x78), ZYDIS_DEFINITION(0x1, 0x79) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A8) },
    { ZYDIS_DEFINITION(0x1, 0x9E), ZYDIS_DEFINITION(0x1, 0x9F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6AA) },
    { ZYDIS_DEFINITION(0xB, 0x8C), ZYDIS_DEFINITION(0xB, 0x8D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x11C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x55), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x56) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x57), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x58) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x59), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x60) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x61), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x62) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x63), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x64) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x65), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x66) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x67), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x68) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x69), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x70) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x71), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x72) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x73), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x74) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x75), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x76) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x77), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x78) }
};

const ZydisDecoderTreeNode FILTERS_MODRM_REG[][8] =
{
    { ZYDIS_DEFINITION(0x1, 0x6C0), ZYDIS_DEFINITION(0x1, 0x6DE), ZYDIS_DEFINITION(0x1, 0x2CD), ZYDIS_DEFINITION(0x1, 0x2E4), ZYDIS_DEFINITION(0x1, 0x72E), ZYDIS_DEFINITION(0x1, 0x730), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6C1), ZYDIS_DEFINITION(0x1, 0x6DF), ZYDIS_DEFINITION(0x1, 0x2CE), ZYDIS_DEFINITION(0x1, 0x2E5), ZYDIS_DEFINITION(0x1, 0x72F), ZYDIS_DEFINITION(0x1, 0x731), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x0), ZYDIS_DEFINITION(0x1, 0x6C2), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2CF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x5), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x6) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x8), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x9) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xA), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x17), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x18), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x19), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1A), ZYDIS_DEFINITION(0x1, 0x6C3), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2D0), ZYDIS_DEFINITION(0x1, 0x256) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x628), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x528), ZYDIS_DEFINITION(0x1, 0x52D), ZYDIS_DEFINITION(0x1, 0x52E), ZYDIS_DEFINITION(0x1, 0x528), ZYDIS_DEFINITION(0x1, 0x528), ZYDIS_DEFINITION(0x1, 0x528), ZYDIS_DEFINITION(0x1, 0x528), ZYDIS_DEFINITION(0x1, 0x528) },
    { ZYDIS_DEFINITION(0x1, 0x3B0), ZYDIS_DEFINITION(0x1, 0x3B1), ZYDIS_DEFINITION(0x1, 0x3B2), ZYDIS_DEFINITION(0x1, 0x3B3), ZYDIS_DEFINITION(0x1, 0x3B4), ZYDIS_DEFINITION(0x1, 0x3B5), ZYDIS_DEFINITION(0x1, 0x3B6), ZYDIS_DEFINITION(0x1, 0x3B7) },
    { ZYDIS_DEFINITION(0x1, 0x529), ZYDIS_DEFINITION(0x1, 0x52A), ZYDIS_DEFINITION(0x1, 0x52B), ZYDIS_DEFINITION(0x1, 0x52C), ZYDIS_DEFINITION(0x1, 0x3B8), ZYDIS_DEFINITION(0x1, 0x3B9), ZYDIS_DEFINITION(0x1, 0x3BA), ZYDIS_DEFINITION(0x1, 0x3BB) },
    { ZYDIS_DEFINITION(0x1, 0xB4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x3CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x28), ZYDIS_DEFINITION(0x1, 0x3CE), ZYDIS_DEFINITION(0x1, 0x3CF), ZYDIS_DEFINITION(0x1, 0x3D0), ZYDIS_DEFINITION(0x1, 0x3D1), ZYDIS_DEFINITION(0x1, 0x3D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_KNC, 0x0), ZYDIS_DEFINITION(0x1, 0x3DE), ZYDIS_DEFINITION(0x1, 0x3DE), ZYDIS_DEFINITION(0x1, 0x3DE), ZYDIS_DEFINITION(0x1, 0x3DE), ZYDIS_DEFINITION(0x1, 0x3DE), ZYDIS_DEFINITION(0x1, 0x3DE), ZYDIS_DEFINITION(0x1, 0x3DE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_KNC, 0x1), ZYDIS_DEFINITION(0x1, 0x3E0), ZYDIS_DEFINITION(0x1, 0x3E0), ZYDIS_DEFINITION(0x1, 0x3E0), ZYDIS_DEFINITION(0x1, 0x3E0), ZYDIS_DEFINITION(0x1, 0x3E0), ZYDIS_DEFINITION(0x1, 0x3E0), ZYDIS_DEFINITION(0x1, 0x3E0) },
    { ZYDIS_DEFINITION(0x1, 0x4A), ZYDIS_DEFINITION(0x1, 0x42), ZYDIS_DEFINITION(0x1, 0x4B), ZYDIS_DEFINITION(0x1, 0x43), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x578), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x565), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x558), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x579), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x566), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x559), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x56B), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x55F), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x54B), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x56C), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x560), ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x54C), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x572), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x552), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x573), ZYDIS_DEFINITION(0xB, 0x571), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x553), ZYDIS_DEFINITION(0xB, 0x551) },
    { ZYDIS_DEFINITION(0x13, 0x177), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0xF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x10), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x11), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x12), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x13), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x14), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x15), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x16), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x17), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2C6), ZYDIS_DEFINITION(0x1, 0x2F3), ZYDIS_DEFINITION(0x1, 0x67C) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x717), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x50), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x51), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x52), ZYDIS_DEFINITION(0x1, 0x5A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x25), ZYDIS_DEFINITION(0x1, 0x724), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x725), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x27), ZYDIS_DEFINITION(0x1, 0x2C1), ZYDIS_DEFINITION(0x1, 0x6D1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x28), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x29), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2A), ZYDIS_DEFINITION(0x1, 0xB5) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xBC), ZYDIS_DEFINITION(0x1, 0xB6) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5A1), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xB9), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x99), ZYDIS_DEFINITION(0xB, 0xA5), ZYDIS_DEFINITION(0xB, 0xA1), ZYDIS_DEFINITION(0xB, 0x9B) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x9A), ZYDIS_DEFINITION(0xB, 0xA6), ZYDIS_DEFINITION(0xB, 0xA2), ZYDIS_DEFINITION(0xB, 0x9C) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5F7), ZYDIS_DEFINITION(0x1, 0x5F8) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x53), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x54) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x55), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2E), ZYDIS_DEFINITION(0x1, 0x738), ZYDIS_DEFINITION(0x1, 0x739) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x733), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x746), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x8D), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x8E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x8F), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x90), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x91), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x92), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xDF), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE0), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE4), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE5), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE6), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x9C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x9E) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x9F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xEA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA0) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x20), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x21), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x22), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x23), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x24), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x25), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x27), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x43E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x43F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x440), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x441), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x442), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x443), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x444), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x445) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C8), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3C9), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CA), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CB), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CC), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3CD), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x2F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x30), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x31), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x446) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x447) },
    { ZYDIS_DEFINITION(0xD, 0x24), ZYDIS_DEFINITION(0xD, 0x3F0), ZYDIS_DEFINITION(0xD, 0xE), ZYDIS_DEFINITION(0xD, 0x642), ZYDIS_DEFINITION(0xD, 0x5A), ZYDIS_DEFINITION(0xD, 0x6EB), ZYDIS_DEFINITION(0xD, 0x76E), ZYDIS_DEFINITION(0xD, 0xE9) },
    { ZYDIS_DEFINITION(0xD, 0x25), ZYDIS_DEFINITION(0xD, 0x3F1), ZYDIS_DEFINITION(0xD, 0xF), ZYDIS_DEFINITION(0xD, 0x643), ZYDIS_DEFINITION(0xD, 0x5B), ZYDIS_DEFINITION(0xD, 0x6EC), ZYDIS_DEFINITION(0xD, 0x76F), ZYDIS_DEFINITION(0xD, 0xEA) },
    { ZYDIS_DEFINITION(0xE, 0x26), ZYDIS_DEFINITION(0xE, 0x3F2), ZYDIS_DEFINITION(0xE, 0x10), ZYDIS_DEFINITION(0xE, 0x644), ZYDIS_DEFINITION(0xE, 0x5C), ZYDIS_DEFINITION(0xE, 0x6ED), ZYDIS_DEFINITION(0xE, 0x770), ZYDIS_DEFINITION(0xE, 0xEB) },
    { ZYDIS_DEFINITION(0xE, 0x27), ZYDIS_DEFINITION(0xE, 0x3F3), ZYDIS_DEFINITION(0xE, 0x11), ZYDIS_DEFINITION(0xE, 0x645), ZYDIS_DEFINITION(0xE, 0x5D), ZYDIS_DEFINITION(0xE, 0x6EE), ZYDIS_DEFINITION(0xE, 0x771), ZYDIS_DEFINITION(0xE, 0xEC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xBF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xCB) },
    { ZYDIS_DEFINITION(0xD, 0x2A), ZYDIS_DEFINITION(0xD, 0x3F6), ZYDIS_DEFINITION(0xD, 0x14), ZYDIS_DEFINITION(0xD, 0x648), ZYDIS_DEFINITION(0xD, 0x60), ZYDIS_DEFINITION(0xD, 0x6F1), ZYDIS_DEFINITION(0xD, 0x774), ZYDIS_DEFINITION(0xD, 0xEF) },
    { ZYDIS_DEFINITION(0xD, 0x2B), ZYDIS_DEFINITION(0xD, 0x3F7), ZYDIS_DEFINITION(0xD, 0x15), ZYDIS_DEFINITION(0xD, 0x649), ZYDIS_DEFINITION(0xD, 0x61), ZYDIS_DEFINITION(0xD, 0x6F2), ZYDIS_DEFINITION(0xD, 0x775), ZYDIS_DEFINITION(0xD, 0xF0) },
    { ZYDIS_DEFINITION(0x1, 0x519), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x51A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x462), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x463), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x464), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x465), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x466), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x467), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x468) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x469), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x603), ZYDIS_DEFINITION(0xB, 0x60F), ZYDIS_DEFINITION(0xB, 0x5D3), ZYDIS_DEFINITION(0xB, 0x5E3), ZYDIS_DEFINITION(0xB, 0x68D), ZYDIS_DEFINITION(0xB, 0x6A9), ZYDIS_DEFINITION(0xB, 0x68E), ZYDIS_DEFINITION(0xB, 0x62B) },
    { ZYDIS_DEFINITION(0xB, 0x604), ZYDIS_DEFINITION(0xB, 0x610), ZYDIS_DEFINITION(0xB, 0x5D4), ZYDIS_DEFINITION(0xB, 0x5E4), ZYDIS_DEFINITION(0xB, 0x68F), ZYDIS_DEFINITION(0xB, 0x6AA), ZYDIS_DEFINITION(0xB, 0x690), ZYDIS_DEFINITION(0xB, 0x62C) },
    { ZYDIS_DEFINITION(0xB, 0x605), ZYDIS_DEFINITION(0xB, 0x611), ZYDIS_DEFINITION(0xB, 0x5D5), ZYDIS_DEFINITION(0xB, 0x5E5), ZYDIS_DEFINITION(0xB, 0x691), ZYDIS_DEFINITION(0xB, 0x6AB), ZYDIS_DEFINITION(0xB, 0x692), ZYDIS_DEFINITION(0xB, 0x62D) },
    { ZYDIS_DEFINITION(0xB, 0x606), ZYDIS_DEFINITION(0xB, 0x612), ZYDIS_DEFINITION(0xB, 0x5D6), ZYDIS_DEFINITION(0xB, 0x5E6), ZYDIS_DEFINITION(0xB, 0x693), ZYDIS_DEFINITION(0xB, 0x6AC), ZYDIS_DEFINITION(0xB, 0x694), ZYDIS_DEFINITION(0xB, 0x62E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x497), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x498), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x499), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x49E) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x32), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50B), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50C), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50D), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50E), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50F), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x510), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x511), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x512), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x513), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x514) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x590), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5FD) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60E) },
    { ZYDIS_DEFINITION(0xD, 0x313), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3B) },
    { ZYDIS_DEFINITION(0xD, 0x314), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xE, 0x315), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3C) },
    { ZYDIS_DEFINITION(0xE, 0x316), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x607), ZYDIS_DEFINITION(0x1, 0x613), ZYDIS_DEFINITION(0x1, 0x5D7), ZYDIS_DEFINITION(0x1, 0x5E7), ZYDIS_DEFINITION(0x1, 0x695), ZYDIS_DEFINITION(0x1, 0x6AD), ZYDIS_DEFINITION(0x1, 0x696), ZYDIS_DEFINITION(0x1, 0x62F) },
    { ZYDIS_DEFINITION(0x1, 0x608), ZYDIS_DEFINITION(0x1, 0x614), ZYDIS_DEFINITION(0x1, 0x5D8), ZYDIS_DEFINITION(0x1, 0x5E8), ZYDIS_DEFINITION(0x1, 0x697), ZYDIS_DEFINITION(0x1, 0x6AE), ZYDIS_DEFINITION(0x1, 0x698), ZYDIS_DEFINITION(0x1, 0x630) },
    { ZYDIS_DEFINITION(0x1, 0x609), ZYDIS_DEFINITION(0x1, 0x615), ZYDIS_DEFINITION(0x1, 0x5D9), ZYDIS_DEFINITION(0x1, 0x5E9), ZYDIS_DEFINITION(0x1, 0x699), ZYDIS_DEFINITION(0x1, 0x6AF), ZYDIS_DEFINITION(0x1, 0x69A), ZYDIS_DEFINITION(0x1, 0x631) },
    { ZYDIS_DEFINITION(0x1, 0x60A), ZYDIS_DEFINITION(0x1, 0x616), ZYDIS_DEFINITION(0x1, 0x5DA), ZYDIS_DEFINITION(0x1, 0x5EA), ZYDIS_DEFINITION(0x1, 0x69B), ZYDIS_DEFINITION(0x1, 0x6B0), ZYDIS_DEFINITION(0x1, 0x69C), ZYDIS_DEFINITION(0x1, 0x632) },
    { ZYDIS_DEFINITION(0x1, 0x60B), ZYDIS_DEFINITION(0x1, 0x617), ZYDIS_DEFINITION(0x1, 0x5DB), ZYDIS_DEFINITION(0x1, 0x5EB), ZYDIS_DEFINITION(0x1, 0x69D), ZYDIS_DEFINITION(0x1, 0x6B1), ZYDIS_DEFINITION(0x1, 0x69E), ZYDIS_DEFINITION(0x1, 0x633) },
    { ZYDIS_DEFINITION(0x1, 0x60C), ZYDIS_DEFINITION(0x1, 0x618), ZYDIS_DEFINITION(0x1, 0x5DC), ZYDIS_DEFINITION(0x1, 0x5EC), ZYDIS_DEFINITION(0x1, 0x69F), ZYDIS_DEFINITION(0x1, 0x6B2), ZYDIS_DEFINITION(0x1, 0x6A0), ZYDIS_DEFINITION(0x1, 0x634) },
    { ZYDIS_DEFINITION(0x1, 0x60D), ZYDIS_DEFINITION(0x1, 0x619), ZYDIS_DEFINITION(0x1, 0x5DD), ZYDIS_DEFINITION(0x1, 0x5ED), ZYDIS_DEFINITION(0x1, 0x6A1), ZYDIS_DEFINITION(0x1, 0x6B3), ZYDIS_DEFINITION(0x1, 0x6A2), ZYDIS_DEFINITION(0x1, 0x635) },
    { ZYDIS_DEFINITION(0x1, 0x60E), ZYDIS_DEFINITION(0x1, 0x61A), ZYDIS_DEFINITION(0x1, 0x5DE), ZYDIS_DEFINITION(0x1, 0x5EE), ZYDIS_DEFINITION(0x1, 0x6A3), ZYDIS_DEFINITION(0x1, 0x6B4), ZYDIS_DEFINITION(0x1, 0x6A4), ZYDIS_DEFINITION(0x1, 0x636) },
    { ZYDIS_DEFINITION(0x1, 0x17B), ZYDIS_DEFINITION(0x1, 0x1D2), ZYDIS_DEFINITION(0x1, 0x18B), ZYDIS_DEFINITION(0x1, 0x191), ZYDIS_DEFINITION(0x1, 0x1F7), ZYDIS_DEFINITION(0x1, 0x1FC), ZYDIS_DEFINITION(0x1, 0x19A), ZYDIS_DEFINITION(0x1, 0x19F) },
    { ZYDIS_DEFINITION(0x1, 0x17C), ZYDIS_DEFINITION(0x1, 0x1D3), ZYDIS_DEFINITION(0x1, 0x18C), ZYDIS_DEFINITION(0x1, 0x192), ZYDIS_DEFINITION(0x1, 0x1F8), ZYDIS_DEFINITION(0x1, 0x1FD), ZYDIS_DEFINITION(0x1, 0x19B), ZYDIS_DEFINITION(0x1, 0x1A0) },
    { ZYDIS_DEFINITION(0x1, 0x1C4), ZYDIS_DEFINITION(0x1, 0x209), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3D), ZYDIS_DEFINITION(0x1, 0x1F6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x3F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x40), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x41) },
    { ZYDIS_DEFINITION(0x1, 0x1C5), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x1ED), ZYDIS_DEFINITION(0x1, 0x1F0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x21), ZYDIS_DEFINITION(0x1, 0x1C9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x22), ZYDIS_DEFINITION(0x1, 0x1DC) },
    { ZYDIS_DEFINITION(0x1, 0x183), ZYDIS_DEFINITION(0x1, 0x185), ZYDIS_DEFINITION(0x1, 0x184), ZYDIS_DEFINITION(0x1, 0x18A), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x42), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x1A8), ZYDIS_DEFINITION(0x1, 0x1B5), ZYDIS_DEFINITION(0x1, 0x1AA), ZYDIS_DEFINITION(0x1, 0x1AC), ZYDIS_DEFINITION(0x1, 0x1C0), ZYDIS_DEFINITION(0x1, 0x1C2), ZYDIS_DEFINITION(0x1, 0x1AE), ZYDIS_DEFINITION(0x1, 0x1B0) },
    { ZYDIS_DEFINITION(0x1, 0x186), ZYDIS_DEFINITION(0x1, 0x188), ZYDIS_DEFINITION(0x1, 0x187), ZYDIS_DEFINITION(0x1, 0x189), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x43), ZYDIS_DEFINITION(0x1, 0x203), ZYDIS_DEFINITION(0x1, 0x18F), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x1B2), ZYDIS_DEFINITION(0x1, 0x1BD), ZYDIS_DEFINITION(0x1, 0x1B8), ZYDIS_DEFINITION(0x1, 0x1BA), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x1C6), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x1F1) },
    { ZYDIS_DEFINITION(0x1, 0x17D), ZYDIS_DEFINITION(0x1, 0x1D4), ZYDIS_DEFINITION(0x1, 0x18D), ZYDIS_DEFINITION(0x1, 0x193), ZYDIS_DEFINITION(0x1, 0x1FE), ZYDIS_DEFINITION(0x1, 0x1F9), ZYDIS_DEFINITION(0x1, 0x1A1), ZYDIS_DEFINITION(0x1, 0x19C) },
    { ZYDIS_DEFINITION(0x1, 0x17E), ZYDIS_DEFINITION(0x1, 0x1D5), ZYDIS_DEFINITION(0x1, 0x18E), ZYDIS_DEFINITION(0x1, 0x194), ZYDIS_DEFINITION(0x1, 0x1FA), ZYDIS_DEFINITION(0x1, 0x1FF), ZYDIS_DEFINITION(0x1, 0x19D), ZYDIS_DEFINITION(0x1, 0x1A2) },
    { ZYDIS_DEFINITION(0x1, 0x1A6), ZYDIS_DEFINITION(0x1, 0x20A), ZYDIS_DEFINITION(0x1, 0x1EE), ZYDIS_DEFINITION(0x1, 0x1F2), ZYDIS_DEFINITION(0x1, 0x202), ZYDIS_DEFINITION(0x1, 0x205), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x1C7), ZYDIS_DEFINITION(0x1, 0x1BE), ZYDIS_DEFINITION(0x1, 0x1EF), ZYDIS_DEFINITION(0x1, 0x1F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x23), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x24), ZYDIS_DEFINITION(0x1, 0x1DF) },
    { ZYDIS_DEFINITION(0x1, 0x17F), ZYDIS_DEFINITION(0x1, 0x1D6), ZYDIS_DEFINITION(0x1, 0x195), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x44), ZYDIS_DEFINITION(0x1, 0x200), ZYDIS_DEFINITION(0x1, 0x1FB), ZYDIS_DEFINITION(0x1, 0x1A3), ZYDIS_DEFINITION(0x1, 0x19E) },
    { ZYDIS_DEFINITION(0x1, 0x1A9), ZYDIS_DEFINITION(0x1, 0x1B6), ZYDIS_DEFINITION(0x1, 0x1AB), ZYDIS_DEFINITION(0x1, 0x1AD), ZYDIS_DEFINITION(0x1, 0x1C1), ZYDIS_DEFINITION(0x1, 0x1C3), ZYDIS_DEFINITION(0x1, 0x1AF), ZYDIS_DEFINITION(0x1, 0x1B1) },
    { ZYDIS_DEFINITION(0x1, 0x1A7), ZYDIS_DEFINITION(0x1, 0x20B), ZYDIS_DEFINITION(0x1, 0x1F4), ZYDIS_DEFINITION(0x1, 0x1F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_RM, 0x45), ZYDIS_DEFINITION(0x1, 0x204), ZYDIS_DEFINITION(0x1, 0x190), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x1B3), ZYDIS_DEFINITION(0x1, 0x1BF), ZYDIS_DEFINITION(0x1, 0x1B9), ZYDIS_DEFINITION(0x1, 0x1BB), ZYDIS_DEFINITION(0x1, 0x180), ZYDIS_DEFINITION(0x1, 0x1B4), ZYDIS_DEFINITION(0x1, 0x181), ZYDIS_DEFINITION(0x1, 0x1BC) },
    { ZYDIS_DEFINITION(0xD, 0x70D), ZYDIS_DEFINITION(0xD, 0x70E), ZYDIS_DEFINITION(0x1, 0x3E2), ZYDIS_DEFINITION(0x1, 0x3AA), ZYDIS_DEFINITION(0x1, 0x39A), ZYDIS_DEFINITION(0x1, 0x22C), ZYDIS_DEFINITION(0x1, 0x157), ZYDIS_DEFINITION(0x1, 0x224) },
    { ZYDIS_DEFINITION(0xD, 0x70F), ZYDIS_DEFINITION(0xD, 0x710), ZYDIS_DEFINITION(0x1, 0x3E3), ZYDIS_DEFINITION(0x1, 0x3AB), ZYDIS_DEFINITION(0x1, 0x39B), ZYDIS_DEFINITION(0x1, 0x22D), ZYDIS_DEFINITION(0x1, 0x158), ZYDIS_DEFINITION(0x1, 0x225) },
    { ZYDIS_DEFINITION(0xE, 0x711), ZYDIS_DEFINITION(0xE, 0x712), ZYDIS_DEFINITION(0x1, 0x3E4), ZYDIS_DEFINITION(0x1, 0x3AC), ZYDIS_DEFINITION(0x1, 0x39C), ZYDIS_DEFINITION(0x1, 0x22E), ZYDIS_DEFINITION(0x1, 0x159), ZYDIS_DEFINITION(0x1, 0x226) },
    { ZYDIS_DEFINITION(0xE, 0x713), ZYDIS_DEFINITION(0xE, 0x714), ZYDIS_DEFINITION(0x1, 0x3E5), ZYDIS_DEFINITION(0x1, 0x3AD), ZYDIS_DEFINITION(0x1, 0x39D), ZYDIS_DEFINITION(0x1, 0x22F), ZYDIS_DEFINITION(0x1, 0x15A), ZYDIS_DEFINITION(0x1, 0x227) },
    { ZYDIS_DEFINITION(0x1, 0x239), ZYDIS_DEFINITION(0x1, 0x153), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x23A), ZYDIS_DEFINITION(0x1, 0x154), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x23B), ZYDIS_DEFINITION(0x1, 0x155), ZYDIS_DEFINITION(0x1, 0xAB), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x27D), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5C5), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x23C), ZYDIS_DEFINITION(0x1, 0x156), ZYDIS_DEFINITION(0x1, 0xAC), ZYDIS_DEFINITION(0x1, 0xAD), ZYDIS_DEFINITION(0x1, 0x27E), ZYDIS_DEFINITION(0x1, 0x27F), ZYDIS_DEFINITION(0x1, 0x5C6), ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_MODRM_RM[][8] =
{
    { ZYDIS_DEFINITION(0x1, 0x73F), ZYDIS_DEFINITION(0x1, 0x737), ZYDIS_DEFINITION(0x1, 0x736), ZYDIS_DEFINITION(0x1, 0x740), ZYDIS_DEFINITION(0x1, 0x6CF), ZYDIS_DEFINITION(0x1, 0xB7), ZYDIS_DEFINITION(0x1, 0x6BF), ZYDIS_DEFINITION(0x1, 0x257) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x3), ZYDIS_DEFINITION(0x1, 0x5FC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xBD), ZYDIS_DEFINITION(0x1, 0x5F6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x4), ZYDIS_DEFINITION(0x1, 0x732), ZYDIS_DEFINITION(0x1, 0x735), ZYDIS_DEFINITION(0x1, 0x73E), ZYDIS_DEFINITION(0x1, 0x745), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x7), ZYDIS_DEFINITION(0x1, 0xB1), ZYDIS_DEFINITION(0x1, 0x6CC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x8) },
    { ZYDIS_DEFINITION(0x1, 0x762), ZYDIS_DEFINITION(0x1, 0x787), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x734), ZYDIS_DEFINITION(0x1, 0x761), ZYDIS_DEFINITION(0x1, 0x78D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x9) },
    { ZYDIS_DEFINITION(0x1, 0x65A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5F4), ZYDIS_DEFINITION(0x1, 0x74B) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xB), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x258), ZYDIS_DEFINITION(0x1, 0x716) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xF) },
    { ZYDIS_DEFINITION(0x1, 0x679), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x637), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x10), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x11), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x12), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x13) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2F2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x14), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x15) },
    { ZYDIS_DEFINITION(0x1, 0x78C), ZYDIS_DEFINITION(0x1, 0x77A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x16), ZYDIS_DEFINITION(0x1, 0x5CE) },
    { ZYDIS_DEFINITION(0x1, 0x3D3), ZYDIS_DEFINITION(0x1, 0x3D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_CET, 0x3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_CET, 0x4), ZYDIS_DEFINITION(0x1, 0x3D7), ZYDIS_DEFINITION(0x1, 0x3D8), ZYDIS_DEFINITION(0x1, 0x3D9), ZYDIS_DEFINITION(0x1, 0x3DA) },
    { ZYDIS_DEFINITION(0xB, 0x21F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x300), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x788), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x789), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x78A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x78B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x75F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x75C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x75E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x75D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x760), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B4), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B6), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CD), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1CF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FE), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1FF), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x200), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x201), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x202), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x203), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x204), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x205), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x423), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x424), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x42E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x445), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x446), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x447), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x448), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x449), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x44A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4CB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4CF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4D1) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x591), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x59F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x602), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x613), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x614), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x750), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xF, 0x755), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x1D9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x182), ZYDIS_DEFINITION(0x1, 0x17A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x201), ZYDIS_DEFINITION(0x1, 0x208), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x1C8), ZYDIS_DEFINITION(0x1, 0x1CD), ZYDIS_DEFINITION(0x1, 0x1CC), ZYDIS_DEFINITION(0x1, 0x1D0), ZYDIS_DEFINITION(0x1, 0x1CE), ZYDIS_DEFINITION(0x1, 0x1CF), ZYDIS_DEFINITION(0x1, 0x1D1), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x179), ZYDIS_DEFINITION(0x1, 0x211), ZYDIS_DEFINITION(0x1, 0x1E4), ZYDIS_DEFINITION(0x1, 0x1E1), ZYDIS_DEFINITION(0x1, 0x210), ZYDIS_DEFINITION(0x1, 0x1E3), ZYDIS_DEFINITION(0x1, 0x198), ZYDIS_DEFINITION(0x1, 0x1B7) },
    { ZYDIS_DEFINITION(0x1, 0x1E2), ZYDIS_DEFINITION(0x1, 0x212), ZYDIS_DEFINITION(0x1, 0x1EC), ZYDIS_DEFINITION(0x1, 0x1EB), ZYDIS_DEFINITION(0x1, 0x1E5), ZYDIS_DEFINITION(0x1, 0x1E8), ZYDIS_DEFINITION(0x1, 0x1EA), ZYDIS_DEFINITION(0x1, 0x197) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x206), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x1A5), ZYDIS_DEFINITION(0x1, 0x199), ZYDIS_DEFINITION(0x1, 0x1D7), ZYDIS_DEFINITION(0x1, 0x1D8), ZYDIS_DEFINITION(0x1, 0x1E9), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x196), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x1E0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_MANDATORY_PREFIX[][5] =
{
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x7), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x8), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x390), ZYDIS_DEFINITION(0x1, 0x38C), ZYDIS_DEFINITION(0x1, 0x37F), ZYDIS_DEFINITION(0x1, 0x374) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x391), ZYDIS_DEFINITION(0x1, 0x38D), ZYDIS_DEFINITION(0x1, 0x380), ZYDIS_DEFINITION(0x1, 0x375) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x392), ZYDIS_DEFINITION(0x1, 0x38E), ZYDIS_DEFINITION(0x1, 0x381), ZYDIS_DEFINITION(0x1, 0x376) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x393), ZYDIS_DEFINITION(0x1, 0x38F), ZYDIS_DEFINITION(0x1, 0x382), ZYDIS_DEFINITION(0x1, 0x377) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x348), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x37A), ZYDIS_DEFINITION(0x1, 0x339) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x350), ZYDIS_DEFINITION(0x1, 0x34E), ZYDIS_DEFINITION(0x1, 0x37B), ZYDIS_DEFINITION(0x1, 0x33A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x351), ZYDIS_DEFINITION(0x1, 0x34F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x72C), ZYDIS_DEFINITION(0x1, 0x72A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x72D), ZYDIS_DEFINITION(0x1, 0x72B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x728), ZYDIS_DEFINITION(0x1, 0x726), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x729), ZYDIS_DEFINITION(0x1, 0x727), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x34D), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x378), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x34B), ZYDIS_DEFINITION(0x1, 0x349), ZYDIS_DEFINITION(0x1, 0x379), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x34C), ZYDIS_DEFINITION(0x1, 0x34A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x3C0), ZYDIS_DEFINITION(0x1, 0x84), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x1F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x20), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x21), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x22) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x3C3), ZYDIS_DEFINITION(0x1, 0x87), ZYDIS_DEFINITION(0x1, 0x3C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x23) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x24), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x25), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x26), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x27) },
    { ZYDIS_DEFINITION(0x1, 0x3C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0xC), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x3CA), ZYDIS_DEFINITION(0x1, 0x3CB), ZYDIS_DEFINITION(0x1, 0x3CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0xD), ZYDIS_DEFINITION(0x1, 0x3DD) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x323), ZYDIS_DEFINITION(0x1, 0x31F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x324), ZYDIS_DEFINITION(0x1, 0x320), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x325), ZYDIS_DEFINITION(0x1, 0x321), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x326), ZYDIS_DEFINITION(0x1, 0x322), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x122), ZYDIS_DEFINITION(0x1, 0x120), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x3) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x123), ZYDIS_DEFINITION(0x1, 0x121), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x5) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x359), ZYDIS_DEFINITION(0x1, 0x358), ZYDIS_DEFINITION(0x1, 0x35C), ZYDIS_DEFINITION(0x1, 0x35B) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x144), ZYDIS_DEFINITION(0x1, 0x140), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x7) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x145), ZYDIS_DEFINITION(0x1, 0x141), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x9) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x128), ZYDIS_DEFINITION(0x1, 0x11C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xB) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x129), ZYDIS_DEFINITION(0x1, 0x11D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xD) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x71C), ZYDIS_DEFINITION(0x1, 0x71A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x71D), ZYDIS_DEFINITION(0x1, 0x71B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x10E), ZYDIS_DEFINITION(0x1, 0x10C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x10F), ZYDIS_DEFINITION(0x1, 0x10D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x213), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x533), ZYDIS_DEFINITION(0x1, 0x535), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x534), ZYDIS_DEFINITION(0x1, 0x536), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x49F), ZYDIS_DEFINITION(0x1, 0x4A1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4A0), ZYDIS_DEFINITION(0x1, 0x4A2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x497), ZYDIS_DEFINITION(0x1, 0x499), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x498), ZYDIS_DEFINITION(0x1, 0x49A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x49B), ZYDIS_DEFINITION(0x1, 0x49D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x49C), ZYDIS_DEFINITION(0x1, 0x49E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4BB), ZYDIS_DEFINITION(0x1, 0x4BD), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4BC), ZYDIS_DEFINITION(0x1, 0x4BE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4AD), ZYDIS_DEFINITION(0x1, 0x4AF), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4AE), ZYDIS_DEFINITION(0x1, 0x4B0), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4A5), ZYDIS_DEFINITION(0x1, 0x4A7), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4A6), ZYDIS_DEFINITION(0x1, 0x4A8), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4A9), ZYDIS_DEFINITION(0x1, 0x4AB), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4AA), ZYDIS_DEFINITION(0x1, 0x4AC), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x53F), ZYDIS_DEFINITION(0x1, 0x541), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x540), ZYDIS_DEFINITION(0x1, 0x542), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x547), ZYDIS_DEFINITION(0x1, 0x549), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x548), ZYDIS_DEFINITION(0x1, 0x54A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x543), ZYDIS_DEFINITION(0x1, 0x545), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x544), ZYDIS_DEFINITION(0x1, 0x546), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4FF), ZYDIS_DEFINITION(0x1, 0x501), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x500), ZYDIS_DEFINITION(0x1, 0x502), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x45D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x45E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x72), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x73), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x70), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x71), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x59E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x59F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x40E), ZYDIS_DEFINITION(0x1, 0x410), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x40F), ZYDIS_DEFINITION(0x1, 0x411), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x416), ZYDIS_DEFINITION(0x1, 0x418), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x417), ZYDIS_DEFINITION(0x1, 0x419), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x412), ZYDIS_DEFINITION(0x1, 0x414), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x413), ZYDIS_DEFINITION(0x1, 0x415), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4E9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4EA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4E5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4E6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4E7), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4E8), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4ED), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4EE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4EF), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4F0), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4EB), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4EC), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4FD), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4FE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x46B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x46C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x355), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x422), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x423), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4F5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4F6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4F1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4F2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4F3), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4F4), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4F9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4FA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4FB), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4FC), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4F7), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4F8), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x481), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x482), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4D3), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4D4), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4D5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4D6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4E1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4E2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4DF), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4E0), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4C3), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4C4), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4C5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4C6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4D1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4D2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4CF), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4D0), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x50B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x50C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4A3), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4A4), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x2F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x30), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x31), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x683), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x684), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x67F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x680), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x681), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x682), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x68B), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x68C), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x687), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x688), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x689), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x68A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x218), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x219), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x10), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x44), ZYDIS_DEFINITION(0x1, 0x2D1), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x45), ZYDIS_DEFINITION(0x1, 0x46), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x48), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x49), ZYDIS_DEFINITION(0x1, 0x3E), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x3C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x3D), ZYDIS_DEFINITION(0x1, 0x47), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x40), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x41), ZYDIS_DEFINITION(0x1, 0x3F), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x112) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x113) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x114) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x115) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0xF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x10), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x11), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x12), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x13), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x32), ZYDIS_DEFINITION(0x1, 0x173), ZYDIS_DEFINITION(0x1, 0x172) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x14), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x16E), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x16F), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x61D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x61E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x61B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x61C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x621), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x622), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x61F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x620), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x6E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x6F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x6C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x6D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x45F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x460), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x448), ZYDIS_DEFINITION(0xB, 0x44A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x449), ZYDIS_DEFINITION(0xB, 0x44B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x48D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x48E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x495), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x496), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x15), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x16), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x175), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x176), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x4B1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x4B2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x248), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x249), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x17), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x18), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x165), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x166), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x163), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x164), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x398), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x399), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x461), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x462), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x19), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x1C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x489), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x48A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x487), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x488), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x685), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x686), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x216), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x217), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x214), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x215), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x4E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x4F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x11), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x353), ZYDIS_DEFINITION(0x1, 0x352), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x6C6), ZYDIS_DEFINITION(0x1, 0x6C4), ZYDIS_DEFINITION(0x1, 0x6CA), ZYDIS_DEFINITION(0x1, 0x6C8) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x6C7), ZYDIS_DEFINITION(0x1, 0x6C5), ZYDIS_DEFINITION(0x1, 0x6CB), ZYDIS_DEFINITION(0x1, 0x6C9) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x624), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x626), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x625), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x627), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5DF), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5E1), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5E0), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5E2), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x68), ZYDIS_DEFINITION(0x1, 0x66), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x69), ZYDIS_DEFINITION(0x1, 0x67), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x64), ZYDIS_DEFINITION(0x1, 0x62), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x65), ZYDIS_DEFINITION(0x1, 0x63), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x3FA), ZYDIS_DEFINITION(0x1, 0x3F8), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x3FB), ZYDIS_DEFINITION(0x1, 0x3F9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x778), ZYDIS_DEFINITION(0x1, 0x776), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x779), ZYDIS_DEFINITION(0x1, 0x777), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2E), ZYDIS_DEFINITION(0x1, 0x2C), ZYDIS_DEFINITION(0x1, 0x32), ZYDIS_DEFINITION(0x1, 0x30) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2F), ZYDIS_DEFINITION(0x1, 0x2D), ZYDIS_DEFINITION(0x1, 0x33), ZYDIS_DEFINITION(0x1, 0x31) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x3A0), ZYDIS_DEFINITION(0x1, 0x39E), ZYDIS_DEFINITION(0x1, 0x3A4), ZYDIS_DEFINITION(0x1, 0x3A2) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x3A1), ZYDIS_DEFINITION(0x1, 0x39F), ZYDIS_DEFINITION(0x1, 0x3A5), ZYDIS_DEFINITION(0x1, 0x3A3) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x126), ZYDIS_DEFINITION(0x1, 0x11E), ZYDIS_DEFINITION(0x1, 0x138), ZYDIS_DEFINITION(0x1, 0x12E) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x127), ZYDIS_DEFINITION(0x1, 0x11F), ZYDIS_DEFINITION(0x1, 0x139), ZYDIS_DEFINITION(0x1, 0x12F) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x118), ZYDIS_DEFINITION(0x1, 0x124), ZYDIS_DEFINITION(0x1, 0x142), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x119), ZYDIS_DEFINITION(0x1, 0x125), ZYDIS_DEFINITION(0x1, 0x143), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x6F5), ZYDIS_DEFINITION(0x1, 0x6F3), ZYDIS_DEFINITION(0x1, 0x6F9), ZYDIS_DEFINITION(0x1, 0x6F7) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x6F6), ZYDIS_DEFINITION(0x1, 0x6F4), ZYDIS_DEFINITION(0x1, 0x6FA), ZYDIS_DEFINITION(0x1, 0x6F8) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2F6), ZYDIS_DEFINITION(0x1, 0x2F4), ZYDIS_DEFINITION(0x1, 0x2FA), ZYDIS_DEFINITION(0x1, 0x2F8) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2F7), ZYDIS_DEFINITION(0x1, 0x2F5), ZYDIS_DEFINITION(0x1, 0x2FB), ZYDIS_DEFINITION(0x1, 0x2F9) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x15D), ZYDIS_DEFINITION(0x1, 0x15B), ZYDIS_DEFINITION(0x1, 0x161), ZYDIS_DEFINITION(0x1, 0x15F) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x15E), ZYDIS_DEFINITION(0x1, 0x15C), ZYDIS_DEFINITION(0x1, 0x162), ZYDIS_DEFINITION(0x1, 0x160) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2EC), ZYDIS_DEFINITION(0x1, 0x2EA), ZYDIS_DEFINITION(0x1, 0x2F0), ZYDIS_DEFINITION(0x1, 0x2EE) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2ED), ZYDIS_DEFINITION(0x1, 0x2EB), ZYDIS_DEFINITION(0x1, 0x2F1), ZYDIS_DEFINITION(0x1, 0x2EF) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5B0), ZYDIS_DEFINITION(0x1, 0x5B2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5B1), ZYDIS_DEFINITION(0x1, 0x5B3), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5BA), ZYDIS_DEFINITION(0x1, 0x5BC), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5BB), ZYDIS_DEFINITION(0x1, 0x5BD), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5B4), ZYDIS_DEFINITION(0x1, 0x5B6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5B5), ZYDIS_DEFINITION(0x1, 0x5B7), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x41E), ZYDIS_DEFINITION(0x1, 0x420), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x41F), ZYDIS_DEFINITION(0x1, 0x421), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x479), ZYDIS_DEFINITION(0x1, 0x47B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x47A), ZYDIS_DEFINITION(0x1, 0x47C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x483), ZYDIS_DEFINITION(0x1, 0x485), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x484), ZYDIS_DEFINITION(0x1, 0x486), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x47D), ZYDIS_DEFINITION(0x1, 0x47F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x47E), ZYDIS_DEFINITION(0x1, 0x480), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x424), ZYDIS_DEFINITION(0x1, 0x426), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x425), ZYDIS_DEFINITION(0x1, 0x427), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5A2), ZYDIS_DEFINITION(0x1, 0x5A4), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5A3), ZYDIS_DEFINITION(0x1, 0x5A5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5AC), ZYDIS_DEFINITION(0x1, 0x5AE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5AD), ZYDIS_DEFINITION(0x1, 0x5AF), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5A6), ZYDIS_DEFINITION(0x1, 0x5A8), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5A7), ZYDIS_DEFINITION(0x1, 0x5A9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x41A), ZYDIS_DEFINITION(0x1, 0x41C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x41B), ZYDIS_DEFINITION(0x1, 0x41D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5B8), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5B9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5AA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5AB), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x33), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x34), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x35), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x36), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x361), ZYDIS_DEFINITION(0x1, 0x340), ZYDIS_DEFINITION(0x1, 0x344), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x362), ZYDIS_DEFINITION(0x1, 0x341), ZYDIS_DEFINITION(0x1, 0x345), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x53D), ZYDIS_DEFINITION(0xB, 0x537), ZYDIS_DEFINITION(0xB, 0x539), ZYDIS_DEFINITION(0xB, 0x53B) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x53E), ZYDIS_DEFINITION(0xB, 0x538), ZYDIS_DEFINITION(0xB, 0x53A), ZYDIS_DEFINITION(0xB, 0x53C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x12), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x13), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x14), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x15), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x16), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x17), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x463), ZYDIS_DEFINITION(0x1, 0x465), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x464), ZYDIS_DEFINITION(0x1, 0x466), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x46D), ZYDIS_DEFINITION(0x1, 0x46F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x46E), ZYDIS_DEFINITION(0x1, 0x470), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x467), ZYDIS_DEFINITION(0x1, 0x469), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x468), ZYDIS_DEFINITION(0x1, 0x46A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x167), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x37), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x18), ZYDIS_INVALID, ZYDIS_DEFINITION(0x13, 0x24A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x38), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x39), ZYDIS_DEFINITION(0x1, 0x178), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x24B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x3A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x21A), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x21C) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x21B), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x21D) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x220), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x222) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x221), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x223) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x3B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x3C), ZYDIS_DEFINITION(0x1, 0x367), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x3D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x3E), ZYDIS_DEFINITION(0x1, 0x368), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x369), ZYDIS_DEFINITION(0x1, 0x342), ZYDIS_DEFINITION(0x1, 0x346), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x36A), ZYDIS_DEFINITION(0x1, 0x343), ZYDIS_DEFINITION(0x1, 0x347), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x19), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x1B), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x1C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x1D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x1E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x1F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x20), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x21), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x22), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x51F), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x520), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x8E), ZYDIS_DEFINITION(0x1, 0x90), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_TZCNT, 0x0), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x8F), ZYDIS_DEFINITION(0x1, 0x91), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_TZCNT, 0x1), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x92), ZYDIS_DEFINITION(0x1, 0x94), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_LZCNT, 0x0), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x93), ZYDIS_DEFINITION(0x1, 0x95), ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_LZCNT, 0x1), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xF3), ZYDIS_DEFINITION(0xB, 0xF1), ZYDIS_DEFINITION(0xB, 0x100), ZYDIS_DEFINITION(0xB, 0xFB) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xF4), ZYDIS_DEFINITION(0xB, 0xF2), ZYDIS_DEFINITION(0xB, 0x101), ZYDIS_DEFINITION(0xB, 0xFC) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x1), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x4B7), ZYDIS_DEFINITION(0xB, 0x4B9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x4B8), ZYDIS_DEFINITION(0xB, 0x4BA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x493), ZYDIS_DEFINITION(0xB, 0x494), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x6BB), ZYDIS_DEFINITION(0xB, 0x6B9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x6BC), ZYDIS_DEFINITION(0xB, 0x6BA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x26), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x27), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x28), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x29), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_REG, 0x2A), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x34), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x36) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x35), ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x37) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x57A), ZYDIS_DEFINITION(0x1, 0x57C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x57B), ZYDIS_DEFINITION(0x1, 0x57D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x56D), ZYDIS_DEFINITION(0x1, 0x56F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x56E), ZYDIS_DEFINITION(0x1, 0x570), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x574), ZYDIS_DEFINITION(0x1, 0x576), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x575), ZYDIS_DEFINITION(0x1, 0x577), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x430), ZYDIS_DEFINITION(0x1, 0x432), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x431), ZYDIS_DEFINITION(0x1, 0x433), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x50D), ZYDIS_DEFINITION(0x1, 0x50F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x50E), ZYDIS_DEFINITION(0x1, 0x510), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x36B), ZYDIS_DEFINITION(0x1, 0x36D), ZYDIS_DEFINITION(0x1, 0x33F) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x36C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4E3), ZYDIS_DEFINITION(0x1, 0x4E4), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x592), ZYDIS_DEFINITION(0x1, 0x594), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x593), ZYDIS_DEFINITION(0x1, 0x595), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x596), ZYDIS_DEFINITION(0x1, 0x598), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x597), ZYDIS_DEFINITION(0x1, 0x599), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4DB), ZYDIS_DEFINITION(0x1, 0x4DD), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4DC), ZYDIS_DEFINITION(0x1, 0x4DE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x44C), ZYDIS_DEFINITION(0x1, 0x44E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x44D), ZYDIS_DEFINITION(0x1, 0x44F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x43C), ZYDIS_DEFINITION(0x1, 0x43E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x43D), ZYDIS_DEFINITION(0x1, 0x43F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x440), ZYDIS_DEFINITION(0x1, 0x442), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x441), ZYDIS_DEFINITION(0x1, 0x443), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4CB), ZYDIS_DEFINITION(0x1, 0x4CD), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4CC), ZYDIS_DEFINITION(0x1, 0x4CE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x450), ZYDIS_DEFINITION(0x1, 0x452), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x451), ZYDIS_DEFINITION(0x1, 0x453), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x455), ZYDIS_DEFINITION(0x1, 0x457), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x456), ZYDIS_DEFINITION(0x1, 0x458), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x567), ZYDIS_DEFINITION(0x1, 0x569), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x568), ZYDIS_DEFINITION(0x1, 0x56A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x561), ZYDIS_DEFINITION(0x1, 0x563), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x562), ZYDIS_DEFINITION(0x1, 0x564), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x459), ZYDIS_DEFINITION(0x1, 0x45B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x45A), ZYDIS_DEFINITION(0x1, 0x45C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x503), ZYDIS_DEFINITION(0x1, 0x505), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x504), ZYDIS_DEFINITION(0x1, 0x506), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x507), ZYDIS_DEFINITION(0x1, 0x509), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x508), ZYDIS_DEFINITION(0x1, 0x50A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x13E), ZYDIS_DEFINITION(0x1, 0x116), ZYDIS_DEFINITION(0x1, 0x11A) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x13F), ZYDIS_DEFINITION(0x1, 0x117), ZYDIS_DEFINITION(0x1, 0x11B) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x35A), ZYDIS_DEFINITION(0x1, 0x354), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x58A), ZYDIS_DEFINITION(0x1, 0x58C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x58B), ZYDIS_DEFINITION(0x1, 0x58D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x58E), ZYDIS_DEFINITION(0x1, 0x590), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x58F), ZYDIS_DEFINITION(0x1, 0x591), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4D7), ZYDIS_DEFINITION(0x1, 0x4D9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4D8), ZYDIS_DEFINITION(0x1, 0x4DA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x524), ZYDIS_DEFINITION(0x1, 0x526), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x525), ZYDIS_DEFINITION(0x1, 0x527), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x434), ZYDIS_DEFINITION(0x1, 0x436), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x435), ZYDIS_DEFINITION(0x1, 0x437), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x438), ZYDIS_DEFINITION(0x1, 0x43A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x439), ZYDIS_DEFINITION(0x1, 0x43B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4C7), ZYDIS_DEFINITION(0x1, 0x4C9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4C8), ZYDIS_DEFINITION(0x1, 0x4CA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5CF), ZYDIS_DEFINITION(0x1, 0x5D1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x5D0), ZYDIS_DEFINITION(0x1, 0x5D2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2C0) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x55A), ZYDIS_DEFINITION(0x1, 0x55C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x55B), ZYDIS_DEFINITION(0x1, 0x55D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x54D), ZYDIS_DEFINITION(0x1, 0x54F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x54E), ZYDIS_DEFINITION(0x1, 0x550), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x554), ZYDIS_DEFINITION(0x1, 0x556), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x555), ZYDIS_DEFINITION(0x1, 0x557), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x511), ZYDIS_DEFINITION(0x1, 0x513), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x512), ZYDIS_DEFINITION(0x1, 0x514), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4BF), ZYDIS_DEFINITION(0x1, 0x4C1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x4C0), ZYDIS_DEFINITION(0x1, 0x4C2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x52F), ZYDIS_DEFINITION(0x1, 0x531), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x530), ZYDIS_DEFINITION(0x1, 0x532), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2E9), ZYDIS_DEFINITION(0x1, 0x2E8), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x57E), ZYDIS_DEFINITION(0x1, 0x580), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x57F), ZYDIS_DEFINITION(0x1, 0x581), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x59A), ZYDIS_DEFINITION(0x1, 0x59C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x59B), ZYDIS_DEFINITION(0x1, 0x59D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x582), ZYDIS_DEFINITION(0x1, 0x584), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x583), ZYDIS_DEFINITION(0x1, 0x585), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x586), ZYDIS_DEFINITION(0x1, 0x588), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x587), ZYDIS_DEFINITION(0x1, 0x589), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x428), ZYDIS_DEFINITION(0x1, 0x42A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x429), ZYDIS_DEFINITION(0x1, 0x42B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x444), ZYDIS_DEFINITION(0x1, 0x446), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x445), ZYDIS_DEFINITION(0x1, 0x447), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x42C), ZYDIS_DEFINITION(0x1, 0x42E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x42D), ZYDIS_DEFINITION(0x1, 0x42F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x0, 0x23F), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x240), ZYDIS_DEFINITION(0x0, 0x241) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x7) },
    { ZYDIS_DEFINITION(0x0, 0x402), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x403), ZYDIS_DEFINITION(0x0, 0x404) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x8), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0xA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_B, 0x0), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x454), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x0, 0x36E), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x36F), ZYDIS_DEFINITION(0x0, 0x370) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x11), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x12), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x13) },
    { ZYDIS_DEFINITION(0x0, 0xF5), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0xF6), ZYDIS_DEFINITION(0x0, 0xF7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x14), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x15), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x16) },
    { ZYDIS_DEFINITION(0x0, 0x6D2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x6D3), ZYDIS_DEFINITION(0x0, 0x6D4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x17), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x18), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x19) },
    { ZYDIS_DEFINITION(0x0, 0x2D2), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x2D3), ZYDIS_DEFINITION(0x0, 0x2D4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x1A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x1B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x1C) },
    { ZYDIS_DEFINITION(0x0, 0x64A), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x0, 0x64B), ZYDIS_DEFINITION(0x0, 0x64C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x1D), ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x1E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_OPERAND_SIZE, 0x1F) }
};

const ZydisDecoderTreeNode FILTERS_OPERAND_SIZE[][3] =
{
    { ZYDIS_DEFINITION(0x0, 0x703), ZYDIS_DEFINITION(0x0, 0x703), ZYDIS_DEFINITION(0x0, 0x702) },
    { ZYDIS_DEFINITION(0x1, 0x357), ZYDIS_DEFINITION(0x1, 0x357), ZYDIS_DEFINITION(0x1, 0x356) },
    { ZYDIS_DEFINITION(0x0, 0x5C9), ZYDIS_DEFINITION(0x0, 0x5CA), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x0, 0x51D), ZYDIS_DEFINITION(0x0, 0x51E), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x8C), ZYDIS_DEFINITION(0x1, 0x8D), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x0, 0x24C), ZYDIS_DEFINITION(0x0, 0x242), ZYDIS_DEFINITION(0x0, 0x243) },
    { ZYDIS_DEFINITION(0x0, 0x24D), ZYDIS_DEFINITION(0x0, 0x244), ZYDIS_DEFINITION(0x0, 0x245) },
    { ZYDIS_DEFINITION(0x0, 0x24E), ZYDIS_DEFINITION(0x0, 0x246), ZYDIS_DEFINITION(0x0, 0x247) },
    { ZYDIS_DEFINITION(0x0, 0x40B), ZYDIS_DEFINITION(0x0, 0x405), ZYDIS_DEFINITION(0x0, 0x406) },
    { ZYDIS_DEFINITION(0x0, 0x40C), ZYDIS_DEFINITION(0x0, 0x407), ZYDIS_DEFINITION(0x0, 0x408) },
    { ZYDIS_DEFINITION(0x0, 0x40D), ZYDIS_DEFINITION(0x0, 0x409), ZYDIS_DEFINITION(0x0, 0x40A) },
    { ZYDIS_DEFINITION(0x0, 0xAE), ZYDIS_DEFINITION(0x0, 0x14F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4ED) },
    { ZYDIS_DEFINITION(0x0, 0x14E), ZYDIS_DEFINITION(0x0, 0xAF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_REX_W, 0x4EE) },
    { ZYDIS_DEFINITION(0x0, 0x5CB), ZYDIS_DEFINITION(0x0, 0x5CD), ZYDIS_DEFINITION(0x0, 0x5CD) },
    { ZYDIS_DEFINITION(0x0, 0x5CB), ZYDIS_DEFINITION(0x0, 0x5CC), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x0, 0x521), ZYDIS_DEFINITION(0x0, 0x523), ZYDIS_DEFINITION(0x0, 0x523) },
    { ZYDIS_DEFINITION(0x0, 0x521), ZYDIS_DEFINITION(0x0, 0x522), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x0, 0x383), ZYDIS_DEFINITION(0x0, 0x371), ZYDIS_DEFINITION(0x0, 0x37C) },
    { ZYDIS_DEFINITION(0x0, 0x384), ZYDIS_DEFINITION(0x0, 0x372), ZYDIS_DEFINITION(0x0, 0x37D) },
    { ZYDIS_DEFINITION(0x0, 0x385), ZYDIS_DEFINITION(0x0, 0x373), ZYDIS_DEFINITION(0x0, 0x37E) },
    { ZYDIS_DEFINITION(0x0, 0x102), ZYDIS_DEFINITION(0x0, 0xF8), ZYDIS_DEFINITION(0x0, 0xFD) },
    { ZYDIS_DEFINITION(0x0, 0x103), ZYDIS_DEFINITION(0x0, 0xF9), ZYDIS_DEFINITION(0x0, 0xFE) },
    { ZYDIS_DEFINITION(0x0, 0x104), ZYDIS_DEFINITION(0x0, 0xFA), ZYDIS_DEFINITION(0x0, 0xFF) },
    { ZYDIS_DEFINITION(0x0, 0x6DB), ZYDIS_DEFINITION(0x0, 0x6D5), ZYDIS_DEFINITION(0x0, 0x6D8) },
    { ZYDIS_DEFINITION(0x0, 0x6DC), ZYDIS_DEFINITION(0x0, 0x6D6), ZYDIS_DEFINITION(0x0, 0x6D9) },
    { ZYDIS_DEFINITION(0x0, 0x6DD), ZYDIS_DEFINITION(0x0, 0x6D7), ZYDIS_DEFINITION(0x0, 0x6DA) },
    { ZYDIS_DEFINITION(0x0, 0x2DB), ZYDIS_DEFINITION(0x0, 0x2D5), ZYDIS_DEFINITION(0x0, 0x2D8) },
    { ZYDIS_DEFINITION(0x0, 0x2DC), ZYDIS_DEFINITION(0x0, 0x2D6), ZYDIS_DEFINITION(0x0, 0x2D9) },
    { ZYDIS_DEFINITION(0x0, 0x2DD), ZYDIS_DEFINITION(0x0, 0x2D7), ZYDIS_DEFINITION(0x0, 0x2DA) },
    { ZYDIS_DEFINITION(0x0, 0x653), ZYDIS_DEFINITION(0x0, 0x64D), ZYDIS_DEFINITION(0x0, 0x650) },
    { ZYDIS_DEFINITION(0x0, 0x654), ZYDIS_DEFINITION(0x0, 0x64E), ZYDIS_DEFINITION(0x0, 0x651) },
    { ZYDIS_DEFINITION(0x0, 0x655), ZYDIS_DEFINITION(0x0, 0x64F), ZYDIS_DEFINITION(0x0, 0x652) },
    { ZYDIS_DEFINITION(0x0, 0x25D), ZYDIS_DEFINITION(0x0, 0x25E), ZYDIS_DEFINITION(0x0, 0x25F) },
    { ZYDIS_DEFINITION(0x1, 0x1CA), ZYDIS_DEFINITION(0x1, 0x1CB), ZYDIS_DEFINITION(0x1, 0x1CB) },
    { ZYDIS_DEFINITION(0x1, 0x1DD), ZYDIS_DEFINITION(0x1, 0x1DE), ZYDIS_DEFINITION(0x1, 0x1DE) },
    { ZYDIS_DEFINITION(0x1, 0x1E6), ZYDIS_DEFINITION(0x1, 0x1E7), ZYDIS_DEFINITION(0x1, 0x1E7) },
    { ZYDIS_DEFINITION(0x1, 0x1DA), ZYDIS_DEFINITION(0x1, 0x1DB), ZYDIS_DEFINITION(0x1, 0x1DB) },
    { ZYDIS_DEFINITION(0x3, 0x233), ZYDIS_DEFINITION(0x3, 0x234), ZYDIS_DEFINITION(0x3, 0x234) },
    { ZYDIS_DEFINITION(0x3, 0x3FD), ZYDIS_DEFINITION(0x3, 0x3FE), ZYDIS_DEFINITION(0x3, 0x3FE) },
    { ZYDIS_DEFINITION(0x0, 0x236), ZYDIS_DEFINITION(0x0, 0x237), ZYDIS_DEFINITION(0x0, 0x237) },
    { ZYDIS_DEFINITION(0x0, 0x400), ZYDIS_DEFINITION(0x0, 0x401), ZYDIS_DEFINITION(0x0, 0x401) }
};

const ZydisDecoderTreeNode FILTERS_ADDRESS_SIZE[][3] =
{
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x81), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x86), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x77), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x7F), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x8B), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x89), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x83), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x7B), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1E7) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1E8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1E8) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1E9) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1EA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1EA) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1EB) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1EC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1EC) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1ED) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1EE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1EE) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x20B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x20B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x20C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x20C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x20D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x20D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x20E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x20E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x20F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x20F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x210), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x210) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x211), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x211) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x212), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x212) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x24F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x24F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x250), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x250) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x251), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x251) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x252), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x252) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x253), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x253) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x254), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x254) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x255), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x255) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x256), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x256) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x257), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x257) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x258), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x258) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x259), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x259) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x25A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x25A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x25B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x25B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x25C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x25C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x25D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x25D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x25E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x25E) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x46E), ZYDIS_DEFINITION(0x1, 0x46E) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x470), ZYDIS_DEFINITION(0x1, 0x470) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x46F), ZYDIS_DEFINITION(0x1, 0x46F) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x471), ZYDIS_DEFINITION(0x1, 0x471) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x472), ZYDIS_DEFINITION(0x1, 0x472) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x474), ZYDIS_DEFINITION(0x1, 0x474) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x473), ZYDIS_DEFINITION(0x1, 0x473) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x475), ZYDIS_DEFINITION(0x1, 0x475) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2BB), ZYDIS_DEFINITION(0x1, 0x2BB) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2B9), ZYDIS_DEFINITION(0x1, 0x2B9) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2BC), ZYDIS_DEFINITION(0x1, 0x2BC) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2BA), ZYDIS_DEFINITION(0x1, 0x2BA) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2BF), ZYDIS_DEFINITION(0x1, 0x2BF) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2BD), ZYDIS_DEFINITION(0x1, 0x2BD) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2C0), ZYDIS_DEFINITION(0x1, 0x2C0) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2BE), ZYDIS_DEFINITION(0x1, 0x2BE) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x8, 0x26B), ZYDIS_DEFINITION(0x8, 0x2B2) },
    { ZYDIS_DEFINITION(0x8, 0x26A), ZYDIS_DEFINITION(0x8, 0x26C), ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_VECTOR_LENGTH[][3] =
{
    { ZYDIS_DEFINITION(0x1, 0x6CF), ZYDIS_DEFINITION(0x1, 0x6D0), ZYDIS_DEFINITION(0x1, 0x6D1) },
    { ZYDIS_DEFINITION(0x1, 0x6D2), ZYDIS_DEFINITION(0x1, 0x6D3), ZYDIS_DEFINITION(0x1, 0x6D4) },
    { ZYDIS_DEFINITION(0x1, 0x6D5), ZYDIS_DEFINITION(0x1, 0x6D6), ZYDIS_DEFINITION(0x1, 0x6D7) },
    { ZYDIS_DEFINITION(0x1, 0x6D8), ZYDIS_DEFINITION(0x1, 0x6D9), ZYDIS_DEFINITION(0x1, 0x6DA) },
    { ZYDIS_DEFINITION(0x1, 0x68D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x695), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x696), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0xE2A), ZYDIS_DEFINITION(0x1, 0xE2B), ZYDIS_DEFINITION(0x1, 0xE2C) },
    { ZYDIS_DEFINITION(0x1, 0xE2D), ZYDIS_DEFINITION(0x1, 0xE2E), ZYDIS_DEFINITION(0x1, 0xE2F) },
    { ZYDIS_DEFINITION(0x1, 0xE1E), ZYDIS_DEFINITION(0x1, 0xE1F), ZYDIS_DEFINITION(0x1, 0xE20) },
    { ZYDIS_DEFINITION(0x1, 0xE21), ZYDIS_DEFINITION(0x1, 0xE22), ZYDIS_DEFINITION(0x1, 0xE23) },
    { ZYDIS_DEFINITION(0x1, 0x692), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x690), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x691), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x62B), ZYDIS_DEFINITION(0x1, 0x62C), ZYDIS_DEFINITION(0x1, 0x62D) },
    { ZYDIS_DEFINITION(0x1, 0x62E), ZYDIS_DEFINITION(0x1, 0x62F), ZYDIS_DEFINITION(0x1, 0x630) },
    { ZYDIS_DEFINITION(0x1, 0x631), ZYDIS_DEFINITION(0x1, 0x632), ZYDIS_DEFINITION(0x1, 0x633) },
    { ZYDIS_DEFINITION(0x1, 0x634), ZYDIS_DEFINITION(0x1, 0x635), ZYDIS_DEFINITION(0x1, 0x636) },
    { ZYDIS_DEFINITION(0x1, 0x6A0), ZYDIS_DEFINITION(0x1, 0x6A1), ZYDIS_DEFINITION(0x1, 0x6A2) },
    { ZYDIS_DEFINITION(0x1, 0xDE2), ZYDIS_DEFINITION(0x1, 0xDE3), ZYDIS_DEFINITION(0x1, 0xDE4) },
    { ZYDIS_DEFINITION(0x1, 0xDE5), ZYDIS_DEFINITION(0x1, 0xDE6), ZYDIS_DEFINITION(0x1, 0xDE7) },
    { ZYDIS_DEFINITION(0x1, 0x58), ZYDIS_DEFINITION(0x1, 0x59), ZYDIS_DEFINITION(0x1, 0x5A) },
    { ZYDIS_DEFINITION(0x1, 0x5B), ZYDIS_DEFINITION(0x1, 0x5C), ZYDIS_DEFINITION(0x1, 0x5D) },
    { ZYDIS_DEFINITION(0x1, 0x4C), ZYDIS_DEFINITION(0x1, 0x4D), ZYDIS_DEFINITION(0x1, 0x4E) },
    { ZYDIS_DEFINITION(0x1, 0x4F), ZYDIS_DEFINITION(0x1, 0x50), ZYDIS_DEFINITION(0x1, 0x51) },
    { ZYDIS_DEFINITION(0x1, 0x703), ZYDIS_DEFINITION(0x1, 0x704), ZYDIS_DEFINITION(0x1, 0x705) },
    { ZYDIS_DEFINITION(0x1, 0x706), ZYDIS_DEFINITION(0x1, 0x707), ZYDIS_DEFINITION(0x1, 0x708) },
    { ZYDIS_DEFINITION(0x1, 0xE36), ZYDIS_DEFINITION(0x1, 0xE37), ZYDIS_DEFINITION(0x1, 0xE38) },
    { ZYDIS_DEFINITION(0x1, 0xE39), ZYDIS_DEFINITION(0x1, 0xE3A), ZYDIS_DEFINITION(0x1, 0xE3B) },
    { ZYDIS_DEFINITION(0x1, 0x13), ZYDIS_DEFINITION(0x1, 0x14), ZYDIS_DEFINITION(0x1, 0x15) },
    { ZYDIS_DEFINITION(0x1, 0x16), ZYDIS_DEFINITION(0x1, 0x17), ZYDIS_DEFINITION(0x1, 0x18) },
    { ZYDIS_DEFINITION(0x1, 0x6EE), ZYDIS_DEFINITION(0x1, 0x6EF), ZYDIS_DEFINITION(0x1, 0x6F0) },
    { ZYDIS_DEFINITION(0x1, 0x6F1), ZYDIS_DEFINITION(0x1, 0x6F2), ZYDIS_DEFINITION(0x1, 0x6F3) },
    { ZYDIS_DEFINITION(0x1, 0x14F), ZYDIS_DEFINITION(0x1, 0x150), ZYDIS_DEFINITION(0x1, 0x151) },
    { ZYDIS_DEFINITION(0x1, 0x152), ZYDIS_DEFINITION(0x1, 0x153), ZYDIS_DEFINITION(0x1, 0x154) },
    { ZYDIS_DEFINITION(0x1, 0xCC), ZYDIS_DEFINITION(0x1, 0xCD), ZYDIS_DEFINITION(0x1, 0xCE) },
    { ZYDIS_DEFINITION(0x1, 0x187), ZYDIS_DEFINITION(0x1, 0x188), ZYDIS_DEFINITION(0x1, 0x189) },
    { ZYDIS_DEFINITION(0x1, 0xCF), ZYDIS_DEFINITION(0x1, 0xD0), ZYDIS_DEFINITION(0x1, 0xD1) },
    { ZYDIS_DEFINITION(0x1, 0x18A), ZYDIS_DEFINITION(0x1, 0x18B), ZYDIS_DEFINITION(0x1, 0x18C) },
    { ZYDIS_DEFINITION(0x1, 0xE00), ZYDIS_DEFINITION(0x1, 0xE01), ZYDIS_DEFINITION(0x1, 0xE02) },
    { ZYDIS_DEFINITION(0x1, 0xE03), ZYDIS_DEFINITION(0x1, 0xE04), ZYDIS_DEFINITION(0x1, 0xE05) },
    { ZYDIS_DEFINITION(0x1, 0x610), ZYDIS_DEFINITION(0x1, 0x611), ZYDIS_DEFINITION(0x1, 0x612) },
    { ZYDIS_DEFINITION(0x1, 0x613), ZYDIS_DEFINITION(0x1, 0x614), ZYDIS_DEFINITION(0x1, 0x615) },
    { ZYDIS_DEFINITION(0x1, 0x2EC), ZYDIS_DEFINITION(0x1, 0x2ED), ZYDIS_DEFINITION(0x1, 0x2EE) },
    { ZYDIS_DEFINITION(0x1, 0x2EF), ZYDIS_DEFINITION(0x1, 0x2F0), ZYDIS_DEFINITION(0x1, 0x2F1) },
    { ZYDIS_DEFINITION(0x1, 0x5F2), ZYDIS_DEFINITION(0x1, 0x5F3), ZYDIS_DEFINITION(0x1, 0x5F4) },
    { ZYDIS_DEFINITION(0x1, 0x5F5), ZYDIS_DEFINITION(0x1, 0x5F6), ZYDIS_DEFINITION(0x1, 0x5F7) },
    { ZYDIS_DEFINITION(0x1, 0x243), ZYDIS_DEFINITION(0x1, 0x244), ZYDIS_DEFINITION(0x1, 0x245) },
    { ZYDIS_DEFINITION(0x1, 0x1FD), ZYDIS_DEFINITION(0x1, 0x1FE), ZYDIS_DEFINITION(0x1, 0x1FF) },
    { ZYDIS_DEFINITION(0x1, 0x246), ZYDIS_DEFINITION(0x1, 0x247), ZYDIS_DEFINITION(0x1, 0x248) },
    { ZYDIS_DEFINITION(0x1, 0x200), ZYDIS_DEFINITION(0x1, 0x201), ZYDIS_DEFINITION(0x1, 0x202) },
    { ZYDIS_DEFINITION(0x1, 0x16B), ZYDIS_DEFINITION(0x1, 0x16C), ZYDIS_DEFINITION(0x1, 0x16D) },
    { ZYDIS_DEFINITION(0x1, 0xFB), ZYDIS_DEFINITION(0x1, 0xFC), ZYDIS_DEFINITION(0x1, 0xFD) },
    { ZYDIS_DEFINITION(0x1, 0x16E), ZYDIS_DEFINITION(0x1, 0x16F), ZYDIS_DEFINITION(0x1, 0x170) },
    { ZYDIS_DEFINITION(0x1, 0xFE), ZYDIS_DEFINITION(0x1, 0xFF), ZYDIS_DEFINITION(0x1, 0x100) },
    { ZYDIS_DEFINITION(0xB, 0x99), ZYDIS_DEFINITION(0xB, 0x9A), ZYDIS_DEFINITION(0xB, 0x9B) },
    { ZYDIS_DEFINITION(0xB, 0x9C), ZYDIS_DEFINITION(0xB, 0x9D), ZYDIS_DEFINITION(0xB, 0x9E) },
    { ZYDIS_DEFINITION(0xB, 0xDCD), ZYDIS_DEFINITION(0xB, 0xDCE), ZYDIS_DEFINITION(0xB, 0xDCF) },
    { ZYDIS_DEFINITION(0xB, 0xDD0), ZYDIS_DEFINITION(0xB, 0xDD1), ZYDIS_DEFINITION(0xB, 0xDD2) },
    { ZYDIS_DEFINITION(0xB, 0xD4B), ZYDIS_DEFINITION(0xB, 0xD4C), ZYDIS_DEFINITION(0xB, 0xD4D) },
    { ZYDIS_DEFINITION(0xB, 0xD4E), ZYDIS_DEFINITION(0xB, 0xD4F), ZYDIS_DEFINITION(0xB, 0xD50) },
    { ZYDIS_DEFINITION(0xB, 0x5A1), ZYDIS_DEFINITION(0xB, 0x5A2), ZYDIS_DEFINITION(0xB, 0x5A3) },
    { ZYDIS_DEFINITION(0xB, 0x5A4), ZYDIS_DEFINITION(0xB, 0x5A5), ZYDIS_DEFINITION(0xB, 0x5A6) },
    { ZYDIS_DEFINITION(0xB, 0xD2D), ZYDIS_DEFINITION(0xB, 0xD2E), ZYDIS_DEFINITION(0xB, 0xD2F) },
    { ZYDIS_DEFINITION(0xB, 0xD30), ZYDIS_DEFINITION(0xB, 0xD31), ZYDIS_DEFINITION(0xB, 0xD32) },
    { ZYDIS_DEFINITION(0xB, 0x555), ZYDIS_DEFINITION(0xB, 0x556), ZYDIS_DEFINITION(0xB, 0x557) },
    { ZYDIS_DEFINITION(0xB, 0x558), ZYDIS_DEFINITION(0xB, 0x559), ZYDIS_DEFINITION(0xB, 0x55A) },
    { ZYDIS_DEFINITION(0xB, 0x92), ZYDIS_DEFINITION(0xB, 0x93), ZYDIS_DEFINITION(0xB, 0x94) },
    { ZYDIS_DEFINITION(0xB, 0x95), ZYDIS_DEFINITION(0xB, 0x96), ZYDIS_DEFINITION(0xB, 0x97) },
    { ZYDIS_DEFINITION(0x1, 0xDDB), ZYDIS_DEFINITION(0x1, 0xDDC), ZYDIS_DEFINITION(0x1, 0xDDD) },
    { ZYDIS_DEFINITION(0x1, 0xDDE), ZYDIS_DEFINITION(0x1, 0xDDF), ZYDIS_DEFINITION(0x1, 0xDE0) },
    { ZYDIS_DEFINITION(0x1, 0xC), ZYDIS_DEFINITION(0x1, 0xD), ZYDIS_DEFINITION(0x1, 0xE) },
    { ZYDIS_DEFINITION(0x1, 0xF), ZYDIS_DEFINITION(0x1, 0x10), ZYDIS_DEFINITION(0x1, 0x11) },
    { ZYDIS_DEFINITION(0x1, 0x6E7), ZYDIS_DEFINITION(0x1, 0x6E8), ZYDIS_DEFINITION(0x1, 0x6E9) },
    { ZYDIS_DEFINITION(0x1, 0x6EA), ZYDIS_DEFINITION(0x1, 0x6EB), ZYDIS_DEFINITION(0x1, 0x6EC) },
    { ZYDIS_DEFINITION(0x1, 0x110), ZYDIS_DEFINITION(0x1, 0x111), ZYDIS_DEFINITION(0x1, 0x112) },
    { ZYDIS_DEFINITION(0x1, 0x113), ZYDIS_DEFINITION(0x1, 0x114), ZYDIS_DEFINITION(0x1, 0x115) },
    { ZYDIS_DEFINITION(0x1, 0xC5), ZYDIS_DEFINITION(0x1, 0xC6), ZYDIS_DEFINITION(0x1, 0xC7) },
    { ZYDIS_DEFINITION(0x1, 0x180), ZYDIS_DEFINITION(0x1, 0x181), ZYDIS_DEFINITION(0x1, 0x182) },
    { ZYDIS_DEFINITION(0x1, 0xC8), ZYDIS_DEFINITION(0x1, 0xC9), ZYDIS_DEFINITION(0x1, 0xCA) },
    { ZYDIS_DEFINITION(0x1, 0x183), ZYDIS_DEFINITION(0x1, 0x184), ZYDIS_DEFINITION(0x1, 0x185) },
    { ZYDIS_DEFINITION(0x1, 0xDF9), ZYDIS_DEFINITION(0x1, 0xDFA), ZYDIS_DEFINITION(0x1, 0xDFB) },
    { ZYDIS_DEFINITION(0x1, 0xDFC), ZYDIS_DEFINITION(0x1, 0xDFD), ZYDIS_DEFINITION(0x1, 0xDFE) },
    { ZYDIS_DEFINITION(0x1, 0x609), ZYDIS_DEFINITION(0x1, 0x60A), ZYDIS_DEFINITION(0x1, 0x60B) },
    { ZYDIS_DEFINITION(0x1, 0x60C), ZYDIS_DEFINITION(0x1, 0x60D), ZYDIS_DEFINITION(0x1, 0x60E) },
    { ZYDIS_DEFINITION(0x1, 0x2E5), ZYDIS_DEFINITION(0x1, 0x2E6), ZYDIS_DEFINITION(0x1, 0x2E7) },
    { ZYDIS_DEFINITION(0x1, 0x2E8), ZYDIS_DEFINITION(0x1, 0x2E9), ZYDIS_DEFINITION(0x1, 0x2EA) },
    { ZYDIS_DEFINITION(0x1, 0x5EB), ZYDIS_DEFINITION(0x1, 0x5EC), ZYDIS_DEFINITION(0x1, 0x5ED) },
    { ZYDIS_DEFINITION(0x1, 0x5EE), ZYDIS_DEFINITION(0x1, 0x5EF), ZYDIS_DEFINITION(0x1, 0x5F0) },
    { ZYDIS_DEFINITION(0x1, 0x219), ZYDIS_DEFINITION(0x1, 0x21A), ZYDIS_DEFINITION(0x1, 0x21B) },
    { ZYDIS_DEFINITION(0x1, 0x21C), ZYDIS_DEFINITION(0x1, 0x21D), ZYDIS_DEFINITION(0x1, 0x21E) },
    { ZYDIS_DEFINITION(0x1, 0x12C), ZYDIS_DEFINITION(0x1, 0x12D), ZYDIS_DEFINITION(0x1, 0x12E) },
    { ZYDIS_DEFINITION(0x1, 0x12F), ZYDIS_DEFINITION(0x1, 0x130), ZYDIS_DEFINITION(0x1, 0x131) },
    { ZYDIS_DEFINITION(0x1, 0x227), ZYDIS_DEFINITION(0x1, 0x228), ZYDIS_DEFINITION(0x1, 0x229) },
    { ZYDIS_DEFINITION(0x1, 0x22A), ZYDIS_DEFINITION(0x1, 0x22B), ZYDIS_DEFINITION(0x1, 0x22C) },
    { ZYDIS_DEFINITION(0x1, 0x13A), ZYDIS_DEFINITION(0x1, 0x13B), ZYDIS_DEFINITION(0x1, 0x13C) },
    { ZYDIS_DEFINITION(0x1, 0x13D), ZYDIS_DEFINITION(0x1, 0x13E), ZYDIS_DEFINITION(0x1, 0x13F) },
    { ZYDIS_DEFINITION(0x1, 0x6C3), ZYDIS_DEFINITION(0x1, 0x6C4), ZYDIS_DEFINITION(0x1, 0x6C5) },
    { ZYDIS_DEFINITION(0x1, 0x6C6), ZYDIS_DEFINITION(0x1, 0x6C7), ZYDIS_DEFINITION(0x1, 0x6C8) },
    { ZYDIS_DEFINITION(0x1, 0x6C9), ZYDIS_DEFINITION(0x1, 0x6CA), ZYDIS_DEFINITION(0x1, 0x6CB) },
    { ZYDIS_DEFINITION(0x1, 0x6CC), ZYDIS_DEFINITION(0x1, 0x6CD), ZYDIS_DEFINITION(0x1, 0x6CE) },
    { ZYDIS_DEFINITION(0x1, 0x693), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x694), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0xE24), ZYDIS_DEFINITION(0x1, 0xE25), ZYDIS_DEFINITION(0x1, 0xE26) },
    { ZYDIS_DEFINITION(0x1, 0xE27), ZYDIS_DEFINITION(0x1, 0xE28), ZYDIS_DEFINITION(0x1, 0xE29) },
    { ZYDIS_DEFINITION(0x1, 0xE18), ZYDIS_DEFINITION(0x1, 0xE19), ZYDIS_DEFINITION(0x1, 0xE1A) },
    { ZYDIS_DEFINITION(0x1, 0xE1B), ZYDIS_DEFINITION(0x1, 0xE1C), ZYDIS_DEFINITION(0x1, 0xE1D) },
    { ZYDIS_DEFINITION(0x1, 0x68E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x68F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x61F), ZYDIS_DEFINITION(0x1, 0x620), ZYDIS_DEFINITION(0x1, 0x621) },
    { ZYDIS_DEFINITION(0x1, 0x622), ZYDIS_DEFINITION(0x1, 0x623), ZYDIS_DEFINITION(0x1, 0x624) },
    { ZYDIS_DEFINITION(0x1, 0x625), ZYDIS_DEFINITION(0x1, 0x626), ZYDIS_DEFINITION(0x1, 0x627) },
    { ZYDIS_DEFINITION(0x1, 0x628), ZYDIS_DEFINITION(0x1, 0x629), ZYDIS_DEFINITION(0x1, 0x62A) },
    { ZYDIS_DEFINITION(0x1, 0x69D), ZYDIS_DEFINITION(0x1, 0x69E), ZYDIS_DEFINITION(0x1, 0x69F) },
    { ZYDIS_DEFINITION(0x1, 0xDD4), ZYDIS_DEFINITION(0x1, 0xDD5), ZYDIS_DEFINITION(0x1, 0xDD6) },
    { ZYDIS_DEFINITION(0x1, 0xDD7), ZYDIS_DEFINITION(0x1, 0xDD8), ZYDIS_DEFINITION(0x1, 0xDD9) },
    { ZYDIS_DEFINITION(0x1, 0x52), ZYDIS_DEFINITION(0x1, 0x53), ZYDIS_DEFINITION(0x1, 0x54) },
    { ZYDIS_DEFINITION(0x1, 0x55), ZYDIS_DEFINITION(0x1, 0x56), ZYDIS_DEFINITION(0x1, 0x57) },
    { ZYDIS_DEFINITION(0x1, 0x46), ZYDIS_DEFINITION(0x1, 0x47), ZYDIS_DEFINITION(0x1, 0x48) },
    { ZYDIS_DEFINITION(0x1, 0x49), ZYDIS_DEFINITION(0x1, 0x4A), ZYDIS_DEFINITION(0x1, 0x4B) },
    { ZYDIS_DEFINITION(0x1, 0x6FD), ZYDIS_DEFINITION(0x1, 0x6FE), ZYDIS_DEFINITION(0x1, 0x6FF) },
    { ZYDIS_DEFINITION(0x1, 0x700), ZYDIS_DEFINITION(0x1, 0x701), ZYDIS_DEFINITION(0x1, 0x702) },
    { ZYDIS_DEFINITION(0x1, 0xE30), ZYDIS_DEFINITION(0x1, 0xE31), ZYDIS_DEFINITION(0x1, 0xE32) },
    { ZYDIS_DEFINITION(0x1, 0xE33), ZYDIS_DEFINITION(0x1, 0xE34), ZYDIS_DEFINITION(0x1, 0xE35) },
    { ZYDIS_DEFINITION(0x1, 0x5), ZYDIS_DEFINITION(0x1, 0x6), ZYDIS_DEFINITION(0x1, 0x7) },
    { ZYDIS_DEFINITION(0x1, 0x8), ZYDIS_DEFINITION(0x1, 0x9), ZYDIS_DEFINITION(0x1, 0xA) },
    { ZYDIS_DEFINITION(0x1, 0x6E0), ZYDIS_DEFINITION(0x1, 0x6E1), ZYDIS_DEFINITION(0x1, 0x6E2) },
    { ZYDIS_DEFINITION(0x1, 0x6E3), ZYDIS_DEFINITION(0x1, 0x6E4), ZYDIS_DEFINITION(0x1, 0x6E5) },
    { ZYDIS_DEFINITION(0x1, 0xED), ZYDIS_DEFINITION(0x1, 0xEE), ZYDIS_DEFINITION(0x1, 0xEF) },
    { ZYDIS_DEFINITION(0x1, 0xF0), ZYDIS_DEFINITION(0x1, 0xF1), ZYDIS_DEFINITION(0x1, 0xF2) },
    { ZYDIS_DEFINITION(0x1, 0x148), ZYDIS_DEFINITION(0x1, 0x149), ZYDIS_DEFINITION(0x1, 0x14A) },
    { ZYDIS_DEFINITION(0x1, 0x14B), ZYDIS_DEFINITION(0x1, 0x14C), ZYDIS_DEFINITION(0x1, 0x14D) },
    { ZYDIS_DEFINITION(0x1, 0xDF2), ZYDIS_DEFINITION(0x1, 0xDF3), ZYDIS_DEFINITION(0x1, 0xDF4) },
    { ZYDIS_DEFINITION(0x1, 0xDF5), ZYDIS_DEFINITION(0x1, 0xDF6), ZYDIS_DEFINITION(0x1, 0xDF7) },
    { ZYDIS_DEFINITION(0x1, 0x602), ZYDIS_DEFINITION(0x1, 0x603), ZYDIS_DEFINITION(0x1, 0x604) },
    { ZYDIS_DEFINITION(0x1, 0x605), ZYDIS_DEFINITION(0x1, 0x606), ZYDIS_DEFINITION(0x1, 0x607) },
    { ZYDIS_DEFINITION(0x1, 0x2DE), ZYDIS_DEFINITION(0x1, 0x2DF), ZYDIS_DEFINITION(0x1, 0x2E0) },
    { ZYDIS_DEFINITION(0x1, 0x2E1), ZYDIS_DEFINITION(0x1, 0x2E2), ZYDIS_DEFINITION(0x1, 0x2E3) },
    { ZYDIS_DEFINITION(0x1, 0x5E4), ZYDIS_DEFINITION(0x1, 0x5E5), ZYDIS_DEFINITION(0x1, 0x5E6) },
    { ZYDIS_DEFINITION(0x1, 0x5E7), ZYDIS_DEFINITION(0x1, 0x5E8), ZYDIS_DEFINITION(0x1, 0x5E9) },
    { ZYDIS_DEFINITION(0x1, 0xCC9), ZYDIS_DEFINITION(0x1, 0xCCA), ZYDIS_DEFINITION(0x1, 0xCCB) },
    { ZYDIS_DEFINITION(0x1, 0xCCC), ZYDIS_DEFINITION(0x1, 0xCCD), ZYDIS_DEFINITION(0x1, 0xCCE) },
    { ZYDIS_DEFINITION(0x1, 0xCDB), ZYDIS_DEFINITION(0x1, 0xCDC), ZYDIS_DEFINITION(0x1, 0xCDD) },
    { ZYDIS_DEFINITION(0x1, 0xCDE), ZYDIS_DEFINITION(0x1, 0xCDF), ZYDIS_DEFINITION(0x1, 0xCE0) },
    { ZYDIS_DEFINITION(0x1, 0xCCF), ZYDIS_DEFINITION(0x1, 0xCD0), ZYDIS_DEFINITION(0x1, 0xCD1) },
    { ZYDIS_DEFINITION(0x1, 0xCD2), ZYDIS_DEFINITION(0x1, 0xCD3), ZYDIS_DEFINITION(0x1, 0xCD4) },
    { ZYDIS_DEFINITION(0x1, 0x735), ZYDIS_DEFINITION(0x1, 0x736), ZYDIS_DEFINITION(0x1, 0x737) },
    { ZYDIS_DEFINITION(0x1, 0x738), ZYDIS_DEFINITION(0x1, 0x739), ZYDIS_DEFINITION(0x1, 0x73A) },
    { ZYDIS_DEFINITION(0x1, 0x810), ZYDIS_DEFINITION(0x1, 0x811), ZYDIS_DEFINITION(0x1, 0x812) },
    { ZYDIS_DEFINITION(0x1, 0x813), ZYDIS_DEFINITION(0x1, 0x814), ZYDIS_DEFINITION(0x1, 0x815) },
    { ZYDIS_DEFINITION(0x1, 0x822), ZYDIS_DEFINITION(0x1, 0x823), ZYDIS_DEFINITION(0x1, 0x824) },
    { ZYDIS_DEFINITION(0x1, 0x825), ZYDIS_DEFINITION(0x1, 0x826), ZYDIS_DEFINITION(0x1, 0x827) },
    { ZYDIS_DEFINITION(0x1, 0x816), ZYDIS_DEFINITION(0x1, 0x817), ZYDIS_DEFINITION(0x1, 0x818) },
    { ZYDIS_DEFINITION(0x1, 0x819), ZYDIS_DEFINITION(0x1, 0x81A), ZYDIS_DEFINITION(0x1, 0x81B) },
    { ZYDIS_DEFINITION(0x1, 0x741), ZYDIS_DEFINITION(0x1, 0x742), ZYDIS_DEFINITION(0x1, 0x743) },
    { ZYDIS_DEFINITION(0x1, 0x744), ZYDIS_DEFINITION(0x1, 0x745), ZYDIS_DEFINITION(0x1, 0x746) },
    { ZYDIS_DEFINITION(0x1, 0xCB1), ZYDIS_DEFINITION(0x1, 0xCB2), ZYDIS_DEFINITION(0x1, 0xCB3) },
    { ZYDIS_DEFINITION(0x1, 0xCB4), ZYDIS_DEFINITION(0x1, 0xCB5), ZYDIS_DEFINITION(0x1, 0xCB6) },
    { ZYDIS_DEFINITION(0x1, 0xCC3), ZYDIS_DEFINITION(0x1, 0xCC4), ZYDIS_DEFINITION(0x1, 0xCC5) },
    { ZYDIS_DEFINITION(0x1, 0xCC6), ZYDIS_DEFINITION(0x1, 0xCC7), ZYDIS_DEFINITION(0x1, 0xCC8) },
    { ZYDIS_DEFINITION(0x1, 0xCB7), ZYDIS_DEFINITION(0x1, 0xCB8), ZYDIS_DEFINITION(0x1, 0xCB9) },
    { ZYDIS_DEFINITION(0x1, 0xCBA), ZYDIS_DEFINITION(0x1, 0xCBB), ZYDIS_DEFINITION(0x1, 0xCBC) },
    { ZYDIS_DEFINITION(0x1, 0x72F), ZYDIS_DEFINITION(0x1, 0x730), ZYDIS_DEFINITION(0x1, 0x731) },
    { ZYDIS_DEFINITION(0x1, 0x732), ZYDIS_DEFINITION(0x1, 0x733), ZYDIS_DEFINITION(0x1, 0x734) },
    { ZYDIS_DEFINITION(0x1, 0xCD5), ZYDIS_DEFINITION(0x1, 0xCD6), ZYDIS_DEFINITION(0x1, 0xCD7) },
    { ZYDIS_DEFINITION(0x1, 0xCD8), ZYDIS_DEFINITION(0x1, 0xCD9), ZYDIS_DEFINITION(0x1, 0xCDA) },
    { ZYDIS_DEFINITION(0x1, 0xCBD), ZYDIS_DEFINITION(0x1, 0xCBE), ZYDIS_DEFINITION(0x1, 0xCBF) },
    { ZYDIS_DEFINITION(0x1, 0xCC0), ZYDIS_DEFINITION(0x1, 0xCC1), ZYDIS_DEFINITION(0x1, 0xCC2) },
    { ZYDIS_DEFINITION(0x1, 0x637), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6A3), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x639), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x638), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6A4), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x63A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x645), ZYDIS_DEFINITION(0x1, 0x646), ZYDIS_DEFINITION(0x1, 0x647) },
    { ZYDIS_DEFINITION(0x1, 0x651), ZYDIS_DEFINITION(0x1, 0x652), ZYDIS_DEFINITION(0x1, 0x653) },
    { ZYDIS_DEFINITION(0x1, 0x648), ZYDIS_DEFINITION(0x1, 0x649), ZYDIS_DEFINITION(0x1, 0x64A) },
    { ZYDIS_DEFINITION(0x1, 0x654), ZYDIS_DEFINITION(0x1, 0x655), ZYDIS_DEFINITION(0x1, 0x656) },
    { ZYDIS_DEFINITION(0xB, 0xB85), ZYDIS_DEFINITION(0xB, 0xB86), ZYDIS_DEFINITION(0xB, 0xB87) },
    { ZYDIS_DEFINITION(0xB, 0xB88), ZYDIS_DEFINITION(0xB, 0xB89), ZYDIS_DEFINITION(0xB, 0xB8A) },
    { ZYDIS_DEFINITION(0xB, 0xC39), ZYDIS_DEFINITION(0xB, 0xC3A), ZYDIS_DEFINITION(0xB, 0xC3B) },
    { ZYDIS_DEFINITION(0xB, 0xBFD), ZYDIS_DEFINITION(0xB, 0xBFE), ZYDIS_DEFINITION(0xB, 0xBFF) },
    { ZYDIS_DEFINITION(0xB, 0xBC7), ZYDIS_DEFINITION(0xB, 0xBC8), ZYDIS_DEFINITION(0xB, 0xBC9) },
    { ZYDIS_DEFINITION(0xB, 0xC3C), ZYDIS_DEFINITION(0xB, 0xC3D), ZYDIS_DEFINITION(0xB, 0xC3E) },
    { ZYDIS_DEFINITION(0xB, 0xC00), ZYDIS_DEFINITION(0xB, 0xC01), ZYDIS_DEFINITION(0xB, 0xC02) },
    { ZYDIS_DEFINITION(0xB, 0xBCA), ZYDIS_DEFINITION(0xB, 0xBCB), ZYDIS_DEFINITION(0xB, 0xBCC) },
    { ZYDIS_DEFINITION(0xB, 0xB07), ZYDIS_DEFINITION(0xB, 0xB08), ZYDIS_DEFINITION(0xB, 0xB09) },
    { ZYDIS_DEFINITION(0xB, 0xB0D), ZYDIS_DEFINITION(0xB, 0xB0E), ZYDIS_DEFINITION(0xB, 0xB0F) },
    { ZYDIS_DEFINITION(0xB, 0xAEF), ZYDIS_DEFINITION(0xB, 0xAF0), ZYDIS_DEFINITION(0xB, 0xAF1) },
    { ZYDIS_DEFINITION(0xB, 0xAF5), ZYDIS_DEFINITION(0xB, 0xAF6), ZYDIS_DEFINITION(0xB, 0xAF7) },
    { ZYDIS_DEFINITION(0xB, 0xC09), ZYDIS_DEFINITION(0xB, 0xC0A), ZYDIS_DEFINITION(0xB, 0xC0B) },
    { ZYDIS_DEFINITION(0xB, 0xBD3), ZYDIS_DEFINITION(0xB, 0xBD4), ZYDIS_DEFINITION(0xB, 0xBD5) },
    { ZYDIS_DEFINITION(0xB, 0xBDF), ZYDIS_DEFINITION(0xB, 0xBE0), ZYDIS_DEFINITION(0xB, 0xBE1) },
    { ZYDIS_DEFINITION(0xB, 0xB97), ZYDIS_DEFINITION(0xB, 0xB98), ZYDIS_DEFINITION(0xB, 0xB99) },
    { ZYDIS_DEFINITION(0xB, 0xB0A), ZYDIS_DEFINITION(0xB, 0xB0B), ZYDIS_DEFINITION(0xB, 0xB0C) },
    { ZYDIS_DEFINITION(0xB, 0xB10), ZYDIS_DEFINITION(0xB, 0xB11), ZYDIS_DEFINITION(0xB, 0xB12) },
    { ZYDIS_DEFINITION(0xB, 0xAF2), ZYDIS_DEFINITION(0xB, 0xAF3), ZYDIS_DEFINITION(0xB, 0xAF4) },
    { ZYDIS_DEFINITION(0xB, 0xAF8), ZYDIS_DEFINITION(0xB, 0xAF9), ZYDIS_DEFINITION(0xB, 0xAFA) },
    { ZYDIS_DEFINITION(0xB, 0xC0C), ZYDIS_DEFINITION(0xB, 0xC0D), ZYDIS_DEFINITION(0xB, 0xC0E) },
    { ZYDIS_DEFINITION(0xB, 0xBD6), ZYDIS_DEFINITION(0xB, 0xBD7), ZYDIS_DEFINITION(0xB, 0xBD8) },
    { ZYDIS_DEFINITION(0xB, 0xBE2), ZYDIS_DEFINITION(0xB, 0xBE3), ZYDIS_DEFINITION(0xB, 0xBE4) },
    { ZYDIS_DEFINITION(0xB, 0xB9A), ZYDIS_DEFINITION(0xB, 0xB9B), ZYDIS_DEFINITION(0xB, 0xB9C) },
    { ZYDIS_DEFINITION(0xB, 0xC1B), ZYDIS_DEFINITION(0xB, 0xC1C), ZYDIS_DEFINITION(0xB, 0xC1D) },
    { ZYDIS_DEFINITION(0xB, 0xC15), ZYDIS_DEFINITION(0xB, 0xC16), ZYDIS_DEFINITION(0xB, 0xC17) },
    { ZYDIS_DEFINITION(0xB, 0xBA9), ZYDIS_DEFINITION(0xB, 0xBAA), ZYDIS_DEFINITION(0xB, 0xBAB) },
    { ZYDIS_DEFINITION(0xB, 0xBA3), ZYDIS_DEFINITION(0xB, 0xBA4), ZYDIS_DEFINITION(0xB, 0xBA5) },
    { ZYDIS_DEFINITION(0xB, 0xC1E), ZYDIS_DEFINITION(0xB, 0xC1F), ZYDIS_DEFINITION(0xB, 0xC20) },
    { ZYDIS_DEFINITION(0xB, 0xC18), ZYDIS_DEFINITION(0xB, 0xC19), ZYDIS_DEFINITION(0xB, 0xC1A) },
    { ZYDIS_DEFINITION(0xB, 0xBAC), ZYDIS_DEFINITION(0xB, 0xBAD), ZYDIS_DEFINITION(0xB, 0xBAE) },
    { ZYDIS_DEFINITION(0xB, 0xBA6), ZYDIS_DEFINITION(0xB, 0xBA7), ZYDIS_DEFINITION(0xB, 0xBA8) },
    { ZYDIS_DEFINITION(0x1, 0x7F8), ZYDIS_DEFINITION(0x1, 0x7F9), ZYDIS_DEFINITION(0x1, 0x7FA) },
    { ZYDIS_DEFINITION(0x1, 0x7FB), ZYDIS_DEFINITION(0x1, 0x7FC), ZYDIS_DEFINITION(0x1, 0x7FD) },
    { ZYDIS_DEFINITION(0x1, 0x80A), ZYDIS_DEFINITION(0x1, 0x80B), ZYDIS_DEFINITION(0x1, 0x80C) },
    { ZYDIS_DEFINITION(0x1, 0x80D), ZYDIS_DEFINITION(0x1, 0x80E), ZYDIS_DEFINITION(0x1, 0x80F) },
    { ZYDIS_DEFINITION(0x1, 0x7FE), ZYDIS_DEFINITION(0x1, 0x7FF), ZYDIS_DEFINITION(0x1, 0x800) },
    { ZYDIS_DEFINITION(0x1, 0x801), ZYDIS_DEFINITION(0x1, 0x802), ZYDIS_DEFINITION(0x1, 0x803) },
    { ZYDIS_DEFINITION(0x1, 0x24A), ZYDIS_DEFINITION(0x1, 0x24B), ZYDIS_DEFINITION(0x1, 0x24C) },
    { ZYDIS_DEFINITION(0x1, 0x204), ZYDIS_DEFINITION(0x1, 0x205), ZYDIS_DEFINITION(0x1, 0x206) },
    { ZYDIS_DEFINITION(0x1, 0x24D), ZYDIS_DEFINITION(0x1, 0x24E), ZYDIS_DEFINITION(0x1, 0x24F) },
    { ZYDIS_DEFINITION(0x1, 0x207), ZYDIS_DEFINITION(0x1, 0x208), ZYDIS_DEFINITION(0x1, 0x209) },
    { ZYDIS_DEFINITION(0x1, 0x172), ZYDIS_DEFINITION(0x1, 0x173), ZYDIS_DEFINITION(0x1, 0x174) },
    { ZYDIS_DEFINITION(0x1, 0x102), ZYDIS_DEFINITION(0x1, 0x103), ZYDIS_DEFINITION(0x1, 0x104) },
    { ZYDIS_DEFINITION(0x1, 0x175), ZYDIS_DEFINITION(0x1, 0x176), ZYDIS_DEFINITION(0x1, 0x177) },
    { ZYDIS_DEFINITION(0x1, 0x105), ZYDIS_DEFINITION(0x1, 0x106), ZYDIS_DEFINITION(0x1, 0x107) },
    { ZYDIS_DEFINITION(0x1, 0x23C), ZYDIS_DEFINITION(0x1, 0x23D), ZYDIS_DEFINITION(0x1, 0x23E) },
    { ZYDIS_DEFINITION(0x1, 0x1F6), ZYDIS_DEFINITION(0x1, 0x1F7), ZYDIS_DEFINITION(0x1, 0x1F8) },
    { ZYDIS_DEFINITION(0x1, 0x23F), ZYDIS_DEFINITION(0x1, 0x240), ZYDIS_DEFINITION(0x1, 0x241) },
    { ZYDIS_DEFINITION(0x1, 0x1F9), ZYDIS_DEFINITION(0x1, 0x1FA), ZYDIS_DEFINITION(0x1, 0x1FB) },
    { ZYDIS_DEFINITION(0x1, 0x164), ZYDIS_DEFINITION(0x1, 0x165), ZYDIS_DEFINITION(0x1, 0x166) },
    { ZYDIS_DEFINITION(0x1, 0xF4), ZYDIS_DEFINITION(0x1, 0xF5), ZYDIS_DEFINITION(0x1, 0xF6) },
    { ZYDIS_DEFINITION(0x1, 0x167), ZYDIS_DEFINITION(0x1, 0x168), ZYDIS_DEFINITION(0x1, 0x169) },
    { ZYDIS_DEFINITION(0x1, 0xF7), ZYDIS_DEFINITION(0x1, 0xF8), ZYDIS_DEFINITION(0x1, 0xF9) },
    { ZYDIS_DEFINITION(0x1, 0x63B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6A5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x63D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x63C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6A6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x63E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x64B), ZYDIS_DEFINITION(0x1, 0x64C), ZYDIS_DEFINITION(0x1, 0x64D) },
    { ZYDIS_DEFINITION(0x1, 0x657), ZYDIS_DEFINITION(0x1, 0x658), ZYDIS_DEFINITION(0x1, 0x659) },
    { ZYDIS_DEFINITION(0x1, 0x64E), ZYDIS_DEFINITION(0x1, 0x64F), ZYDIS_DEFINITION(0x1, 0x650) },
    { ZYDIS_DEFINITION(0x1, 0x65A), ZYDIS_DEFINITION(0x1, 0x65B), ZYDIS_DEFINITION(0x1, 0x65C) },
    { ZYDIS_DEFINITION(0xB, 0x8B), ZYDIS_DEFINITION(0xB, 0x8C), ZYDIS_DEFINITION(0xB, 0x8D) },
    { ZYDIS_DEFINITION(0xB, 0x8E), ZYDIS_DEFINITION(0xB, 0x8F), ZYDIS_DEFINITION(0xB, 0x90) },
    { ZYDIS_DEFINITION(0xB, 0x943), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x944), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x92C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0xDC7), ZYDIS_DEFINITION(0xB, 0xDC8), ZYDIS_DEFINITION(0xB, 0xDC9) },
    { ZYDIS_DEFINITION(0xB, 0xDCA), ZYDIS_DEFINITION(0xB, 0xDCB), ZYDIS_DEFINITION(0xB, 0xDCC) },
    { ZYDIS_DEFINITION(0x1, 0xC3F), ZYDIS_DEFINITION(0x1, 0xC40), ZYDIS_DEFINITION(0x1, 0xC41) },
    { ZYDIS_DEFINITION(0x1, 0xC42), ZYDIS_DEFINITION(0x1, 0xC43), ZYDIS_DEFINITION(0x1, 0xC44) },
    { ZYDIS_DEFINITION(0x1, 0xC0F), ZYDIS_DEFINITION(0x1, 0xC10), ZYDIS_DEFINITION(0x1, 0xC11) },
    { ZYDIS_DEFINITION(0x1, 0xC12), ZYDIS_DEFINITION(0x1, 0xC13), ZYDIS_DEFINITION(0x1, 0xC14) },
    { ZYDIS_DEFINITION(0x1, 0xC21), ZYDIS_DEFINITION(0x1, 0xC22), ZYDIS_DEFINITION(0x1, 0xC23) },
    { ZYDIS_DEFINITION(0x1, 0xC24), ZYDIS_DEFINITION(0x1, 0xC25), ZYDIS_DEFINITION(0x1, 0xC26) },
    { ZYDIS_DEFINITION(0x1, 0x753), ZYDIS_DEFINITION(0x1, 0x754), ZYDIS_DEFINITION(0x1, 0x755) },
    { ZYDIS_DEFINITION(0x1, 0x756), ZYDIS_DEFINITION(0x1, 0x757), ZYDIS_DEFINITION(0x1, 0x758) },
    { ZYDIS_DEFINITION(0x1, 0xAB9), ZYDIS_DEFINITION(0x1, 0xABA), ZYDIS_DEFINITION(0x1, 0xABB) },
    { ZYDIS_DEFINITION(0x1, 0xABC), ZYDIS_DEFINITION(0x1, 0xABD), ZYDIS_DEFINITION(0x1, 0xABE) },
    { ZYDIS_DEFINITION(0x1, 0x6A9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6AA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0xC63), ZYDIS_DEFINITION(0x1, 0xC64), ZYDIS_DEFINITION(0x1, 0xC65) },
    { ZYDIS_DEFINITION(0x1, 0xC66), ZYDIS_DEFINITION(0x1, 0xC67), ZYDIS_DEFINITION(0x1, 0xC68) },
    { ZYDIS_DEFINITION(0x1, 0xC69), ZYDIS_DEFINITION(0x1, 0xC6A), ZYDIS_DEFINITION(0x1, 0xC6B) },
    { ZYDIS_DEFINITION(0x1, 0xC6C), ZYDIS_DEFINITION(0x1, 0xC6D), ZYDIS_DEFINITION(0x1, 0xC6E) },
    { ZYDIS_DEFINITION(0x1, 0x9B1), ZYDIS_DEFINITION(0x1, 0x9B2), ZYDIS_DEFINITION(0x1, 0x9B3) },
    { ZYDIS_DEFINITION(0x1, 0x9B4), ZYDIS_DEFINITION(0x1, 0x9B5), ZYDIS_DEFINITION(0x1, 0x9B6) },
    { ZYDIS_DEFINITION(0x1, 0x77D), ZYDIS_DEFINITION(0x1, 0x77E), ZYDIS_DEFINITION(0x1, 0x77F) },
    { ZYDIS_DEFINITION(0x1, 0x78F), ZYDIS_DEFINITION(0x1, 0x790), ZYDIS_DEFINITION(0x1, 0x791) },
    { ZYDIS_DEFINITION(0x1, 0x780), ZYDIS_DEFINITION(0x1, 0x781), ZYDIS_DEFINITION(0x1, 0x782) },
    { ZYDIS_DEFINITION(0x1, 0x792), ZYDIS_DEFINITION(0x1, 0x793), ZYDIS_DEFINITION(0x1, 0x794) },
    { ZYDIS_DEFINITION(0x1, 0x765), ZYDIS_DEFINITION(0x1, 0x766), ZYDIS_DEFINITION(0x1, 0x767) },
    { ZYDIS_DEFINITION(0x1, 0x768), ZYDIS_DEFINITION(0x1, 0x769), ZYDIS_DEFINITION(0x1, 0x76A) },
    { ZYDIS_DEFINITION(0x1, 0x76B), ZYDIS_DEFINITION(0x1, 0x76C), ZYDIS_DEFINITION(0x1, 0x76D) },
    { ZYDIS_DEFINITION(0x1, 0x76E), ZYDIS_DEFINITION(0x1, 0x76F), ZYDIS_DEFINITION(0x1, 0x770) },
    { ZYDIS_DEFINITION(0x1, 0x981), ZYDIS_DEFINITION(0x1, 0x982), ZYDIS_DEFINITION(0x1, 0x983) },
    { ZYDIS_DEFINITION(0x1, 0x984), ZYDIS_DEFINITION(0x1, 0x985), ZYDIS_DEFINITION(0x1, 0x986) },
    { ZYDIS_DEFINITION(0x1, 0x783), ZYDIS_DEFINITION(0x1, 0x784), ZYDIS_DEFINITION(0x1, 0x785) },
    { ZYDIS_DEFINITION(0x1, 0x789), ZYDIS_DEFINITION(0x1, 0x78A), ZYDIS_DEFINITION(0x1, 0x78B) },
    { ZYDIS_DEFINITION(0x1, 0x786), ZYDIS_DEFINITION(0x1, 0x787), ZYDIS_DEFINITION(0x1, 0x788) },
    { ZYDIS_DEFINITION(0x1, 0x78C), ZYDIS_DEFINITION(0x1, 0x78D), ZYDIS_DEFINITION(0x1, 0x78E) },
    { ZYDIS_DEFINITION(0x1, 0x795), ZYDIS_DEFINITION(0x1, 0x796), ZYDIS_DEFINITION(0x1, 0x797) },
    { ZYDIS_DEFINITION(0x1, 0x798), ZYDIS_DEFINITION(0x1, 0x799), ZYDIS_DEFINITION(0x1, 0x79A) },
    { ZYDIS_DEFINITION(0x1, 0xC03), ZYDIS_DEFINITION(0x1, 0xC04), ZYDIS_DEFINITION(0x1, 0xC05) },
    { ZYDIS_DEFINITION(0x1, 0xC06), ZYDIS_DEFINITION(0x1, 0xC07), ZYDIS_DEFINITION(0x1, 0xC08) },
    { ZYDIS_DEFINITION(0x1, 0xBD9), ZYDIS_DEFINITION(0x1, 0xBDA), ZYDIS_DEFINITION(0x1, 0xBDB) },
    { ZYDIS_DEFINITION(0x1, 0xBE5), ZYDIS_DEFINITION(0x1, 0xBE6), ZYDIS_DEFINITION(0x1, 0xBE7) },
    { ZYDIS_DEFINITION(0x1, 0xBDC), ZYDIS_DEFINITION(0x1, 0xBDD), ZYDIS_DEFINITION(0x1, 0xBDE) },
    { ZYDIS_DEFINITION(0x1, 0xBE8), ZYDIS_DEFINITION(0x1, 0xBE9), ZYDIS_DEFINITION(0x1, 0xBEA) },
    { ZYDIS_DEFINITION(0x1, 0x79B), ZYDIS_DEFINITION(0x1, 0x79C), ZYDIS_DEFINITION(0x1, 0x79D) },
    { ZYDIS_DEFINITION(0x1, 0x79E), ZYDIS_DEFINITION(0x1, 0x79F), ZYDIS_DEFINITION(0x1, 0x7A0) },
    { ZYDIS_DEFINITION(0x1, 0xAA1), ZYDIS_DEFINITION(0x1, 0xAA2), ZYDIS_DEFINITION(0x1, 0xAA3) },
    { ZYDIS_DEFINITION(0x1, 0xAA4), ZYDIS_DEFINITION(0x1, 0xAA5), ZYDIS_DEFINITION(0x1, 0xAA6) },
    { ZYDIS_DEFINITION(0x1, 0xAA7), ZYDIS_DEFINITION(0x1, 0xAA8), ZYDIS_DEFINITION(0x1, 0xAA9) },
    { ZYDIS_DEFINITION(0x1, 0xAAA), ZYDIS_DEFINITION(0x1, 0xAAB), ZYDIS_DEFINITION(0x1, 0xAAC) },
    { ZYDIS_DEFINITION(0x1, 0x1EF), ZYDIS_DEFINITION(0x1, 0x1F0), ZYDIS_DEFINITION(0x1, 0x1F1) },
    { ZYDIS_DEFINITION(0x1, 0x1F2), ZYDIS_DEFINITION(0x1, 0x1F3), ZYDIS_DEFINITION(0x1, 0x1F4) },
    { ZYDIS_DEFINITION(0x1, 0x697), ZYDIS_DEFINITION(0x1, 0x698), ZYDIS_DEFINITION(0x1, 0x699) },
    { ZYDIS_DEFINITION(0x1, 0xC57), ZYDIS_DEFINITION(0x1, 0xC58), ZYDIS_DEFINITION(0x1, 0xC59) },
    { ZYDIS_DEFINITION(0x1, 0xC5A), ZYDIS_DEFINITION(0x1, 0xC5B), ZYDIS_DEFINITION(0x1, 0xC5C) },
    { ZYDIS_DEFINITION(0x1, 0xC5D), ZYDIS_DEFINITION(0x1, 0xC5E), ZYDIS_DEFINITION(0x1, 0xC5F) },
    { ZYDIS_DEFINITION(0x1, 0xC60), ZYDIS_DEFINITION(0x1, 0xC61), ZYDIS_DEFINITION(0x1, 0xC62) },
    { ZYDIS_DEFINITION(0x1, 0x9AB), ZYDIS_DEFINITION(0x1, 0x9AC), ZYDIS_DEFINITION(0x1, 0x9AD) },
    { ZYDIS_DEFINITION(0x1, 0x9AE), ZYDIS_DEFINITION(0x1, 0x9AF), ZYDIS_DEFINITION(0x1, 0x9B0) },
    { ZYDIS_DEFINITION(0x1, 0xAE3), ZYDIS_DEFINITION(0x1, 0xAE4), ZYDIS_DEFINITION(0x1, 0xAE5) },
    { ZYDIS_DEFINITION(0x1, 0xAE9), ZYDIS_DEFINITION(0x1, 0xAEA), ZYDIS_DEFINITION(0x1, 0xAEB) },
    { ZYDIS_DEFINITION(0x1, 0xAE6), ZYDIS_DEFINITION(0x1, 0xAE7), ZYDIS_DEFINITION(0x1, 0xAE8) },
    { ZYDIS_DEFINITION(0x1, 0xAEC), ZYDIS_DEFINITION(0x1, 0xAED), ZYDIS_DEFINITION(0x1, 0xAEE) },
    { ZYDIS_DEFINITION(0x1, 0x759), ZYDIS_DEFINITION(0x1, 0x75A), ZYDIS_DEFINITION(0x1, 0x75B) },
    { ZYDIS_DEFINITION(0x1, 0x75C), ZYDIS_DEFINITION(0x1, 0x75D), ZYDIS_DEFINITION(0x1, 0x75E) },
    { ZYDIS_DEFINITION(0x1, 0x75F), ZYDIS_DEFINITION(0x1, 0x760), ZYDIS_DEFINITION(0x1, 0x761) },
    { ZYDIS_DEFINITION(0x1, 0x762), ZYDIS_DEFINITION(0x1, 0x763), ZYDIS_DEFINITION(0x1, 0x764) },
    { ZYDIS_DEFINITION(0x1, 0x97B), ZYDIS_DEFINITION(0x1, 0x97C), ZYDIS_DEFINITION(0x1, 0x97D) },
    { ZYDIS_DEFINITION(0x1, 0x97E), ZYDIS_DEFINITION(0x1, 0x97F), ZYDIS_DEFINITION(0x1, 0x980) },
    { ZYDIS_DEFINITION(0x1, 0xCE1), ZYDIS_DEFINITION(0x1, 0xCE2), ZYDIS_DEFINITION(0x1, 0xCE3) },
    { ZYDIS_DEFINITION(0x1, 0xCE7), ZYDIS_DEFINITION(0x1, 0xCE8), ZYDIS_DEFINITION(0x1, 0xCE9) },
    { ZYDIS_DEFINITION(0x1, 0xCE4), ZYDIS_DEFINITION(0x1, 0xCE5), ZYDIS_DEFINITION(0x1, 0xCE6) },
    { ZYDIS_DEFINITION(0x1, 0xCEA), ZYDIS_DEFINITION(0x1, 0xCEB), ZYDIS_DEFINITION(0x1, 0xCEC) },
    { ZYDIS_DEFINITION(0x1, 0xBCD), ZYDIS_DEFINITION(0x1, 0xBCE), ZYDIS_DEFINITION(0x1, 0xBCF) },
    { ZYDIS_DEFINITION(0x1, 0xBD0), ZYDIS_DEFINITION(0x1, 0xBD1), ZYDIS_DEFINITION(0x1, 0xBD2) },
    { ZYDIS_DEFINITION(0x1, 0xB9D), ZYDIS_DEFINITION(0x1, 0xB9E), ZYDIS_DEFINITION(0x1, 0xB9F) },
    { ZYDIS_DEFINITION(0x1, 0xBA0), ZYDIS_DEFINITION(0x1, 0xBA1), ZYDIS_DEFINITION(0x1, 0xBA2) },
    { ZYDIS_DEFINITION(0x1, 0xBAF), ZYDIS_DEFINITION(0x1, 0xBB0), ZYDIS_DEFINITION(0x1, 0xBB1) },
    { ZYDIS_DEFINITION(0x1, 0xBB2), ZYDIS_DEFINITION(0x1, 0xBB3), ZYDIS_DEFINITION(0x1, 0xBB4) },
    { ZYDIS_DEFINITION(0x1, 0xAC5), ZYDIS_DEFINITION(0x1, 0xAC6), ZYDIS_DEFINITION(0x1, 0xAC7) },
    { ZYDIS_DEFINITION(0x1, 0xAC8), ZYDIS_DEFINITION(0x1, 0xAC9), ZYDIS_DEFINITION(0x1, 0xACA) },
    { ZYDIS_DEFINITION(0x1, 0x963), ZYDIS_DEFINITION(0x1, 0x964), ZYDIS_DEFINITION(0x1, 0x965) },
    { ZYDIS_DEFINITION(0x1, 0x966), ZYDIS_DEFINITION(0x1, 0x967), ZYDIS_DEFINITION(0x1, 0x968) },
    { ZYDIS_DEFINITION(0x1, 0xB1F), ZYDIS_DEFINITION(0x1, 0xB20), ZYDIS_DEFINITION(0x1, 0xB21) },
    { ZYDIS_DEFINITION(0x1, 0xB22), ZYDIS_DEFINITION(0x1, 0xB23), ZYDIS_DEFINITION(0x1, 0xB24) },
    { ZYDIS_DEFINITION(0x1, 0xC45), ZYDIS_DEFINITION(0x1, 0xC46), ZYDIS_DEFINITION(0x1, 0xC47) },
    { ZYDIS_DEFINITION(0x1, 0xC48), ZYDIS_DEFINITION(0x1, 0xC49), ZYDIS_DEFINITION(0x1, 0xC4A) },
    { ZYDIS_DEFINITION(0x1, 0xC6F), ZYDIS_DEFINITION(0x1, 0xC70), ZYDIS_DEFINITION(0x1, 0xC71) },
    { ZYDIS_DEFINITION(0x1, 0xC72), ZYDIS_DEFINITION(0x1, 0xC73), ZYDIS_DEFINITION(0x1, 0xC74) },
    { ZYDIS_DEFINITION(0x1, 0xC4B), ZYDIS_DEFINITION(0x1, 0xC4C), ZYDIS_DEFINITION(0x1, 0xC4D) },
    { ZYDIS_DEFINITION(0x1, 0xC4E), ZYDIS_DEFINITION(0x1, 0xC4F), ZYDIS_DEFINITION(0x1, 0xC50) },
    { ZYDIS_DEFINITION(0x1, 0xC51), ZYDIS_DEFINITION(0x1, 0xC52), ZYDIS_DEFINITION(0x1, 0xC53) },
    { ZYDIS_DEFINITION(0x1, 0xC54), ZYDIS_DEFINITION(0x1, 0xC55), ZYDIS_DEFINITION(0x1, 0xC56) },
    { ZYDIS_DEFINITION(0x1, 0x747), ZYDIS_DEFINITION(0x1, 0x748), ZYDIS_DEFINITION(0x1, 0x749) },
    { ZYDIS_DEFINITION(0x1, 0x74A), ZYDIS_DEFINITION(0x1, 0x74B), ZYDIS_DEFINITION(0x1, 0x74C) },
    { ZYDIS_DEFINITION(0x1, 0x771), ZYDIS_DEFINITION(0x1, 0x772), ZYDIS_DEFINITION(0x1, 0x773) },
    { ZYDIS_DEFINITION(0x1, 0x774), ZYDIS_DEFINITION(0x1, 0x775), ZYDIS_DEFINITION(0x1, 0x776) },
    { ZYDIS_DEFINITION(0x1, 0x74D), ZYDIS_DEFINITION(0x1, 0x74E), ZYDIS_DEFINITION(0x1, 0x74F) },
    { ZYDIS_DEFINITION(0x1, 0x750), ZYDIS_DEFINITION(0x1, 0x751), ZYDIS_DEFINITION(0x1, 0x752) },
    { ZYDIS_DEFINITION(0x1, 0xB79), ZYDIS_DEFINITION(0x1, 0xB7A), ZYDIS_DEFINITION(0x1, 0xB7B) },
    { ZYDIS_DEFINITION(0x1, 0xB7C), ZYDIS_DEFINITION(0x1, 0xB7D), ZYDIS_DEFINITION(0x1, 0xB7E) },
    { ZYDIS_DEFINITION(0x1, 0x95D), ZYDIS_DEFINITION(0x1, 0x95E), ZYDIS_DEFINITION(0x1, 0x95F) },
    { ZYDIS_DEFINITION(0x1, 0x960), ZYDIS_DEFINITION(0x1, 0x961), ZYDIS_DEFINITION(0x1, 0x962) },
    { ZYDIS_DEFINITION(0x1, 0xA9B), ZYDIS_DEFINITION(0x1, 0xA9C), ZYDIS_DEFINITION(0x1, 0xA9D) },
    { ZYDIS_DEFINITION(0x1, 0xA9E), ZYDIS_DEFINITION(0x1, 0xA9F), ZYDIS_DEFINITION(0x1, 0xAA0) },
    { ZYDIS_DEFINITION(0x1, 0x8C2), ZYDIS_DEFINITION(0x1, 0x8C3), ZYDIS_DEFINITION(0x1, 0x8C4) },
    { ZYDIS_DEFINITION(0x1, 0x8C5), ZYDIS_DEFINITION(0x1, 0x8C6), ZYDIS_DEFINITION(0x1, 0x8C7) },
    { ZYDIS_DEFINITION(0x1, 0x8B6), ZYDIS_DEFINITION(0x1, 0x8B7), ZYDIS_DEFINITION(0x1, 0x8B8) },
    { ZYDIS_DEFINITION(0x1, 0x8B9), ZYDIS_DEFINITION(0x1, 0x8BA), ZYDIS_DEFINITION(0x1, 0x8BB) },
    { ZYDIS_DEFINITION(0x1, 0xC33), ZYDIS_DEFINITION(0x1, 0xC34), ZYDIS_DEFINITION(0x1, 0xC35) },
    { ZYDIS_DEFINITION(0x1, 0xC36), ZYDIS_DEFINITION(0x1, 0xC37), ZYDIS_DEFINITION(0x1, 0xC38) },
    { ZYDIS_DEFINITION(0x1, 0xBF7), ZYDIS_DEFINITION(0x1, 0xBF8), ZYDIS_DEFINITION(0x1, 0xBF9) },
    { ZYDIS_DEFINITION(0x1, 0xBFA), ZYDIS_DEFINITION(0x1, 0xBFB), ZYDIS_DEFINITION(0x1, 0xBFC) },
    { ZYDIS_DEFINITION(0x1, 0xBC1), ZYDIS_DEFINITION(0x1, 0xBC2), ZYDIS_DEFINITION(0x1, 0xBC3) },
    { ZYDIS_DEFINITION(0x1, 0xBC4), ZYDIS_DEFINITION(0x1, 0xBC5), ZYDIS_DEFINITION(0x1, 0xBC6) },
    { ZYDIS_DEFINITION(0x1, 0x117), ZYDIS_DEFINITION(0x1, 0x118), ZYDIS_DEFINITION(0x1, 0x119) },
    { ZYDIS_DEFINITION(0x1, 0x11A), ZYDIS_DEFINITION(0x1, 0x11B), ZYDIS_DEFINITION(0x1, 0x11C) },
    { ZYDIS_DEFINITION(0x1, 0xB13), ZYDIS_DEFINITION(0x1, 0xB14), ZYDIS_DEFINITION(0x1, 0xB15) },
    { ZYDIS_DEFINITION(0x1, 0xB19), ZYDIS_DEFINITION(0x1, 0xB1A), ZYDIS_DEFINITION(0x1, 0xB1B) },
    { ZYDIS_DEFINITION(0x1, 0xB16), ZYDIS_DEFINITION(0x1, 0xB17), ZYDIS_DEFINITION(0x1, 0xB18) },
    { ZYDIS_DEFINITION(0x1, 0xB1C), ZYDIS_DEFINITION(0x1, 0xB1D), ZYDIS_DEFINITION(0x1, 0xB1E) },
    { ZYDIS_DEFINITION(0x1, 0xAFB), ZYDIS_DEFINITION(0x1, 0xAFC), ZYDIS_DEFINITION(0x1, 0xAFD) },
    { ZYDIS_DEFINITION(0x1, 0xB01), ZYDIS_DEFINITION(0x1, 0xB02), ZYDIS_DEFINITION(0x1, 0xB03) },
    { ZYDIS_DEFINITION(0x1, 0xAFE), ZYDIS_DEFINITION(0x1, 0xAFF), ZYDIS_DEFINITION(0x1, 0xB00) },
    { ZYDIS_DEFINITION(0x1, 0xB04), ZYDIS_DEFINITION(0x1, 0xB05), ZYDIS_DEFINITION(0x1, 0xB06) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x8D6), ZYDIS_DEFINITION(0x1, 0x8D7) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x8CE), ZYDIS_DEFINITION(0x1, 0x8CF) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x8D8), ZYDIS_DEFINITION(0x1, 0x8D9) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x8D0), ZYDIS_DEFINITION(0x1, 0x8D1) },
    { ZYDIS_DEFINITION(0x1, 0x84), ZYDIS_DEFINITION(0x1, 0x85), ZYDIS_DEFINITION(0x1, 0x86) },
    { ZYDIS_DEFINITION(0x1, 0x87), ZYDIS_DEFINITION(0x1, 0x88), ZYDIS_DEFINITION(0x1, 0x89) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x6A), ZYDIS_DEFINITION(0x1, 0x6B) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x80), ZYDIS_DEFINITION(0x1, 0x81) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x6C), ZYDIS_DEFINITION(0x1, 0x6D) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x82), ZYDIS_DEFINITION(0x1, 0x83) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x6E), ZYDIS_DEFINITION(0x1, 0x6F) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x71), ZYDIS_DEFINITION(0x1, 0x72) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x70) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x73) },
    { ZYDIS_DEFINITION(0x1, 0x717), ZYDIS_DEFINITION(0x1, 0x718), ZYDIS_DEFINITION(0x1, 0x719) },
    { ZYDIS_DEFINITION(0x1, 0x71A), ZYDIS_DEFINITION(0x1, 0x71B), ZYDIS_DEFINITION(0x1, 0x71C) },
    { ZYDIS_DEFINITION(0x1, 0x729), ZYDIS_DEFINITION(0x1, 0x72A), ZYDIS_DEFINITION(0x1, 0x72B) },
    { ZYDIS_DEFINITION(0x1, 0x72C), ZYDIS_DEFINITION(0x1, 0x72D), ZYDIS_DEFINITION(0x1, 0x72E) },
    { ZYDIS_DEFINITION(0x1, 0x71D), ZYDIS_DEFINITION(0x1, 0x71E), ZYDIS_DEFINITION(0x1, 0x71F) },
    { ZYDIS_DEFINITION(0x1, 0x720), ZYDIS_DEFINITION(0x1, 0x721), ZYDIS_DEFINITION(0x1, 0x722) },
    { ZYDIS_DEFINITION(0x1, 0x723), ZYDIS_DEFINITION(0x1, 0x724), ZYDIS_DEFINITION(0x1, 0x725) },
    { ZYDIS_DEFINITION(0x1, 0x726), ZYDIS_DEFINITION(0x1, 0x727), ZYDIS_DEFINITION(0x1, 0x728) },
    { ZYDIS_DEFINITION(0x1, 0xA2C), ZYDIS_DEFINITION(0x1, 0xA2D), ZYDIS_DEFINITION(0x1, 0xA2E) },
    { ZYDIS_DEFINITION(0x1, 0xA2F), ZYDIS_DEFINITION(0x1, 0xA30), ZYDIS_DEFINITION(0x1, 0xA31) },
    { ZYDIS_DEFINITION(0x1, 0xA20), ZYDIS_DEFINITION(0x1, 0xA21), ZYDIS_DEFINITION(0x1, 0xA22) },
    { ZYDIS_DEFINITION(0x1, 0xA23), ZYDIS_DEFINITION(0x1, 0xA24), ZYDIS_DEFINITION(0x1, 0xA25) },
    { ZYDIS_DEFINITION(0x1, 0xA26), ZYDIS_DEFINITION(0x1, 0xA27), ZYDIS_DEFINITION(0x1, 0xA28) },
    { ZYDIS_DEFINITION(0x1, 0xA29), ZYDIS_DEFINITION(0x1, 0xA2A), ZYDIS_DEFINITION(0x1, 0xA2B) },
    { ZYDIS_DEFINITION(0x1, 0xA38), ZYDIS_DEFINITION(0x1, 0xA39), ZYDIS_DEFINITION(0x1, 0xA3A) },
    { ZYDIS_DEFINITION(0x1, 0xA3B), ZYDIS_DEFINITION(0x1, 0xA3C), ZYDIS_DEFINITION(0x1, 0xA3D) },
    { ZYDIS_DEFINITION(0x1, 0xA3E), ZYDIS_DEFINITION(0x1, 0xA3F), ZYDIS_DEFINITION(0x1, 0xA40) },
    { ZYDIS_DEFINITION(0x1, 0xA41), ZYDIS_DEFINITION(0x1, 0xA42), ZYDIS_DEFINITION(0x1, 0xA43) },
    { ZYDIS_DEFINITION(0x1, 0xA32), ZYDIS_DEFINITION(0x1, 0xA33), ZYDIS_DEFINITION(0x1, 0xA34) },
    { ZYDIS_DEFINITION(0x1, 0xA35), ZYDIS_DEFINITION(0x1, 0xA36), ZYDIS_DEFINITION(0x1, 0xA37) },
    { ZYDIS_DEFINITION(0x1, 0xC81), ZYDIS_DEFINITION(0x1, 0xC82), ZYDIS_DEFINITION(0x1, 0xC83) },
    { ZYDIS_DEFINITION(0x1, 0xC93), ZYDIS_DEFINITION(0x1, 0xC94), ZYDIS_DEFINITION(0x1, 0xC95) },
    { ZYDIS_DEFINITION(0x1, 0xC84), ZYDIS_DEFINITION(0x1, 0xC85), ZYDIS_DEFINITION(0x1, 0xC86) },
    { ZYDIS_DEFINITION(0x1, 0xC96), ZYDIS_DEFINITION(0x1, 0xC97), ZYDIS_DEFINITION(0x1, 0xC98) },
    { ZYDIS_DEFINITION(0x1, 0xC87), ZYDIS_DEFINITION(0x1, 0xC88), ZYDIS_DEFINITION(0x1, 0xC89) },
    { ZYDIS_DEFINITION(0x1, 0xC8D), ZYDIS_DEFINITION(0x1, 0xC8E), ZYDIS_DEFINITION(0x1, 0xC8F) },
    { ZYDIS_DEFINITION(0x1, 0xC8A), ZYDIS_DEFINITION(0x1, 0xC8B), ZYDIS_DEFINITION(0x1, 0xC8C) },
    { ZYDIS_DEFINITION(0x1, 0xC90), ZYDIS_DEFINITION(0x1, 0xC91), ZYDIS_DEFINITION(0x1, 0xC92) },
    { ZYDIS_DEFINITION(0x1, 0xA95), ZYDIS_DEFINITION(0x1, 0xA96), ZYDIS_DEFINITION(0x1, 0xA97) },
    { ZYDIS_DEFINITION(0x1, 0xA98), ZYDIS_DEFINITION(0x1, 0xA99), ZYDIS_DEFINITION(0x1, 0xA9A) },
    { ZYDIS_DEFINITION(0x1, 0x804), ZYDIS_DEFINITION(0x1, 0x805), ZYDIS_DEFINITION(0x1, 0x806) },
    { ZYDIS_DEFINITION(0x1, 0x807), ZYDIS_DEFINITION(0x1, 0x808), ZYDIS_DEFINITION(0x1, 0x809) },
    { ZYDIS_DEFINITION(0x1, 0x69A), ZYDIS_DEFINITION(0x1, 0x69B), ZYDIS_DEFINITION(0x1, 0x69C) },
    { ZYDIS_DEFINITION(0x1, 0x73B), ZYDIS_DEFINITION(0x1, 0x73C), ZYDIS_DEFINITION(0x1, 0x73D) },
    { ZYDIS_DEFINITION(0x1, 0x73E), ZYDIS_DEFINITION(0x1, 0x73F), ZYDIS_DEFINITION(0x1, 0x740) },
    { ZYDIS_DEFINITION(0x1, 0xD94), ZYDIS_DEFINITION(0x1, 0xD95), ZYDIS_DEFINITION(0x1, 0xD96) },
    { ZYDIS_DEFINITION(0x1, 0xD86), ZYDIS_DEFINITION(0x1, 0xD87), ZYDIS_DEFINITION(0x1, 0xD88) },
    { ZYDIS_DEFINITION(0x1, 0xD97), ZYDIS_DEFINITION(0x1, 0xD98), ZYDIS_DEFINITION(0x1, 0xD99) },
    { ZYDIS_DEFINITION(0x1, 0xD89), ZYDIS_DEFINITION(0x1, 0xD8A), ZYDIS_DEFINITION(0x1, 0xD8B) },
    { ZYDIS_DEFINITION(0x1, 0xA7D), ZYDIS_DEFINITION(0x1, 0xA7E), ZYDIS_DEFINITION(0x1, 0xA7F) },
    { ZYDIS_DEFINITION(0x1, 0xA80), ZYDIS_DEFINITION(0x1, 0xA81), ZYDIS_DEFINITION(0x1, 0xA82) },
    { ZYDIS_DEFINITION(0x1, 0xA71), ZYDIS_DEFINITION(0x1, 0xA72), ZYDIS_DEFINITION(0x1, 0xA73) },
    { ZYDIS_DEFINITION(0x1, 0xA74), ZYDIS_DEFINITION(0x1, 0xA75), ZYDIS_DEFINITION(0x1, 0xA76) },
    { ZYDIS_DEFINITION(0x1, 0xA77), ZYDIS_DEFINITION(0x1, 0xA78), ZYDIS_DEFINITION(0x1, 0xA79) },
    { ZYDIS_DEFINITION(0x1, 0xA7A), ZYDIS_DEFINITION(0x1, 0xA7B), ZYDIS_DEFINITION(0x1, 0xA7C) },
    { ZYDIS_DEFINITION(0x1, 0xA89), ZYDIS_DEFINITION(0x1, 0xA8A), ZYDIS_DEFINITION(0x1, 0xA8B) },
    { ZYDIS_DEFINITION(0x1, 0xA8C), ZYDIS_DEFINITION(0x1, 0xA8D), ZYDIS_DEFINITION(0x1, 0xA8E) },
    { ZYDIS_DEFINITION(0x1, 0xA8F), ZYDIS_DEFINITION(0x1, 0xA90), ZYDIS_DEFINITION(0x1, 0xA91) },
    { ZYDIS_DEFINITION(0x1, 0xA92), ZYDIS_DEFINITION(0x1, 0xA93), ZYDIS_DEFINITION(0x1, 0xA94) },
    { ZYDIS_DEFINITION(0x1, 0xA83), ZYDIS_DEFINITION(0x1, 0xA84), ZYDIS_DEFINITION(0x1, 0xA85) },
    { ZYDIS_DEFINITION(0x1, 0xA86), ZYDIS_DEFINITION(0x1, 0xA87), ZYDIS_DEFINITION(0x1, 0xA88) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x88E), ZYDIS_DEFINITION(0x1, 0x88F) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x8DA), ZYDIS_DEFINITION(0x1, 0x8DB) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x890), ZYDIS_DEFINITION(0x1, 0x891) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x8DC), ZYDIS_DEFINITION(0x1, 0x8DD) },
    { ZYDIS_DEFINITION(0x1, 0x81C), ZYDIS_DEFINITION(0x1, 0x81D), ZYDIS_DEFINITION(0x1, 0x81E) },
    { ZYDIS_DEFINITION(0x1, 0x81F), ZYDIS_DEFINITION(0x1, 0x820), ZYDIS_DEFINITION(0x1, 0x821) },
    { ZYDIS_DEFINITION(0x1, 0x999), ZYDIS_DEFINITION(0x1, 0x99A), ZYDIS_DEFINITION(0x1, 0x99B) },
    { ZYDIS_DEFINITION(0x1, 0x99C), ZYDIS_DEFINITION(0x1, 0x99D), ZYDIS_DEFINITION(0x1, 0x99E) },
    { ZYDIS_DEFINITION(0x1, 0x99F), ZYDIS_DEFINITION(0x1, 0x9A0), ZYDIS_DEFINITION(0x1, 0x9A1) },
    { ZYDIS_DEFINITION(0x1, 0x9A5), ZYDIS_DEFINITION(0x1, 0x9A6), ZYDIS_DEFINITION(0x1, 0x9A7) },
    { ZYDIS_DEFINITION(0x1, 0x9A2), ZYDIS_DEFINITION(0x1, 0x9A3), ZYDIS_DEFINITION(0x1, 0x9A4) },
    { ZYDIS_DEFINITION(0x1, 0x9A8), ZYDIS_DEFINITION(0x1, 0x9A9), ZYDIS_DEFINITION(0x1, 0x9AA) },
    { ZYDIS_DEFINITION(0x1, 0x9C3), ZYDIS_DEFINITION(0x1, 0x9C4), ZYDIS_DEFINITION(0x1, 0x9C5) },
    { ZYDIS_DEFINITION(0x1, 0x9C6), ZYDIS_DEFINITION(0x1, 0x9C7), ZYDIS_DEFINITION(0x1, 0x9C8) },
    { ZYDIS_DEFINITION(0x1, 0x9B7), ZYDIS_DEFINITION(0x1, 0x9B8), ZYDIS_DEFINITION(0x1, 0x9B9) },
    { ZYDIS_DEFINITION(0x1, 0x9BD), ZYDIS_DEFINITION(0x1, 0x9BE), ZYDIS_DEFINITION(0x1, 0x9BF) },
    { ZYDIS_DEFINITION(0x1, 0x9BA), ZYDIS_DEFINITION(0x1, 0x9BB), ZYDIS_DEFINITION(0x1, 0x9BC) },
    { ZYDIS_DEFINITION(0x1, 0x9C0), ZYDIS_DEFINITION(0x1, 0x9C1), ZYDIS_DEFINITION(0x1, 0x9C2) },
    { ZYDIS_DEFINITION(0x1, 0x969), ZYDIS_DEFINITION(0x1, 0x96A), ZYDIS_DEFINITION(0x1, 0x96B) },
    { ZYDIS_DEFINITION(0x1, 0x96C), ZYDIS_DEFINITION(0x1, 0x96D), ZYDIS_DEFINITION(0x1, 0x96E) },
    { ZYDIS_DEFINITION(0x1, 0x96F), ZYDIS_DEFINITION(0x1, 0x970), ZYDIS_DEFINITION(0x1, 0x971) },
    { ZYDIS_DEFINITION(0x1, 0x975), ZYDIS_DEFINITION(0x1, 0x976), ZYDIS_DEFINITION(0x1, 0x977) },
    { ZYDIS_DEFINITION(0x1, 0x972), ZYDIS_DEFINITION(0x1, 0x973), ZYDIS_DEFINITION(0x1, 0x974) },
    { ZYDIS_DEFINITION(0x1, 0x978), ZYDIS_DEFINITION(0x1, 0x979), ZYDIS_DEFINITION(0x1, 0x97A) },
    { ZYDIS_DEFINITION(0x1, 0x993), ZYDIS_DEFINITION(0x1, 0x994), ZYDIS_DEFINITION(0x1, 0x995) },
    { ZYDIS_DEFINITION(0x1, 0x996), ZYDIS_DEFINITION(0x1, 0x997), ZYDIS_DEFINITION(0x1, 0x998) },
    { ZYDIS_DEFINITION(0x1, 0x987), ZYDIS_DEFINITION(0x1, 0x988), ZYDIS_DEFINITION(0x1, 0x989) },
    { ZYDIS_DEFINITION(0x1, 0x98D), ZYDIS_DEFINITION(0x1, 0x98E), ZYDIS_DEFINITION(0x1, 0x98F) },
    { ZYDIS_DEFINITION(0x1, 0x98A), ZYDIS_DEFINITION(0x1, 0x98B), ZYDIS_DEFINITION(0x1, 0x98C) },
    { ZYDIS_DEFINITION(0x1, 0x990), ZYDIS_DEFINITION(0x1, 0x991), ZYDIS_DEFINITION(0x1, 0x992) },
    { ZYDIS_DEFINITION(0x1, 0xAAD), ZYDIS_DEFINITION(0x1, 0xAAE), ZYDIS_DEFINITION(0x1, 0xAAF) },
    { ZYDIS_DEFINITION(0x1, 0xAB3), ZYDIS_DEFINITION(0x1, 0xAB4), ZYDIS_DEFINITION(0x1, 0xAB5) },
    { ZYDIS_DEFINITION(0x1, 0xAB0), ZYDIS_DEFINITION(0x1, 0xAB1), ZYDIS_DEFINITION(0x1, 0xAB2) },
    { ZYDIS_DEFINITION(0x1, 0xAB6), ZYDIS_DEFINITION(0x1, 0xAB7), ZYDIS_DEFINITION(0x1, 0xAB8) },
    { ZYDIS_DEFINITION(0x1, 0x58A), ZYDIS_DEFINITION(0x1, 0x58B), ZYDIS_DEFINITION(0x1, 0x58C) },
    { ZYDIS_DEFINITION(0x1, 0x57C), ZYDIS_DEFINITION(0x1, 0x57D), ZYDIS_DEFINITION(0x1, 0x57E) },
    { ZYDIS_DEFINITION(0x1, 0x58D), ZYDIS_DEFINITION(0x1, 0x58E), ZYDIS_DEFINITION(0x1, 0x58F) },
    { ZYDIS_DEFINITION(0x1, 0x57F), ZYDIS_DEFINITION(0x1, 0x580), ZYDIS_DEFINITION(0x1, 0x581) },
    { ZYDIS_DEFINITION(0x1, 0x945), ZYDIS_DEFINITION(0x1, 0x946), ZYDIS_DEFINITION(0x1, 0x947) },
    { ZYDIS_DEFINITION(0x1, 0x94B), ZYDIS_DEFINITION(0x1, 0x94C), ZYDIS_DEFINITION(0x1, 0x94D) },
    { ZYDIS_DEFINITION(0x1, 0x948), ZYDIS_DEFINITION(0x1, 0x949), ZYDIS_DEFINITION(0x1, 0x94A) },
    { ZYDIS_DEFINITION(0x1, 0x94E), ZYDIS_DEFINITION(0x1, 0x94F), ZYDIS_DEFINITION(0x1, 0x950) },
    { ZYDIS_DEFINITION(0x1, 0xC27), ZYDIS_DEFINITION(0x1, 0xC28), ZYDIS_DEFINITION(0x1, 0xC29) },
    { ZYDIS_DEFINITION(0x1, 0xC2D), ZYDIS_DEFINITION(0x1, 0xC2E), ZYDIS_DEFINITION(0x1, 0xC2F) },
    { ZYDIS_DEFINITION(0x1, 0xC2A), ZYDIS_DEFINITION(0x1, 0xC2B), ZYDIS_DEFINITION(0x1, 0xC2C) },
    { ZYDIS_DEFINITION(0x1, 0xC30), ZYDIS_DEFINITION(0x1, 0xC31), ZYDIS_DEFINITION(0x1, 0xC32) },
    { ZYDIS_DEFINITION(0x1, 0xBEB), ZYDIS_DEFINITION(0x1, 0xBEC), ZYDIS_DEFINITION(0x1, 0xBED) },
    { ZYDIS_DEFINITION(0x1, 0xBF1), ZYDIS_DEFINITION(0x1, 0xBF2), ZYDIS_DEFINITION(0x1, 0xBF3) },
    { ZYDIS_DEFINITION(0x1, 0xBEE), ZYDIS_DEFINITION(0x1, 0xBEF), ZYDIS_DEFINITION(0x1, 0xBF0) },
    { ZYDIS_DEFINITION(0x1, 0xBF4), ZYDIS_DEFINITION(0x1, 0xBF5), ZYDIS_DEFINITION(0x1, 0xBF6) },
    { ZYDIS_DEFINITION(0x1, 0xBB5), ZYDIS_DEFINITION(0x1, 0xBB6), ZYDIS_DEFINITION(0x1, 0xBB7) },
    { ZYDIS_DEFINITION(0x1, 0xBBB), ZYDIS_DEFINITION(0x1, 0xBBC), ZYDIS_DEFINITION(0x1, 0xBBD) },
    { ZYDIS_DEFINITION(0x1, 0xBB8), ZYDIS_DEFINITION(0x1, 0xBB9), ZYDIS_DEFINITION(0x1, 0xBBA) },
    { ZYDIS_DEFINITION(0x1, 0xBBE), ZYDIS_DEFINITION(0x1, 0xBBF), ZYDIS_DEFINITION(0x1, 0xBC0) },
    { ZYDIS_DEFINITION(0x1, 0xD07), ZYDIS_DEFINITION(0x1, 0xD08), ZYDIS_DEFINITION(0x1, 0xD09) },
    { ZYDIS_DEFINITION(0x1, 0xD01), ZYDIS_DEFINITION(0x1, 0xD02), ZYDIS_DEFINITION(0x1, 0xD03) },
    { ZYDIS_DEFINITION(0x1, 0xD0A), ZYDIS_DEFINITION(0x1, 0xD0B), ZYDIS_DEFINITION(0x1, 0xD0C) },
    { ZYDIS_DEFINITION(0x1, 0xD04), ZYDIS_DEFINITION(0x1, 0xD05), ZYDIS_DEFINITION(0x1, 0xD06) },
    { ZYDIS_DEFINITION(0x1, 0xD67), ZYDIS_DEFINITION(0x1, 0xD68), ZYDIS_DEFINITION(0x1, 0xD69) },
    { ZYDIS_DEFINITION(0x1, 0xD61), ZYDIS_DEFINITION(0x1, 0xD62), ZYDIS_DEFINITION(0x1, 0xD63) },
    { ZYDIS_DEFINITION(0x1, 0xD6A), ZYDIS_DEFINITION(0x1, 0xD6B), ZYDIS_DEFINITION(0x1, 0xD6C) },
    { ZYDIS_DEFINITION(0x1, 0xD64), ZYDIS_DEFINITION(0x1, 0xD65), ZYDIS_DEFINITION(0x1, 0xD66) },
    { ZYDIS_DEFINITION(0x1, 0x870), ZYDIS_DEFINITION(0x1, 0x871), ZYDIS_DEFINITION(0x1, 0x872) },
    { ZYDIS_DEFINITION(0x1, 0x873), ZYDIS_DEFINITION(0x1, 0x874), ZYDIS_DEFINITION(0x1, 0x875) },
    { ZYDIS_DEFINITION(0x1, 0x876), ZYDIS_DEFINITION(0x1, 0x877), ZYDIS_DEFINITION(0x1, 0x878) },
    { ZYDIS_DEFINITION(0x1, 0x879), ZYDIS_DEFINITION(0x1, 0x87A), ZYDIS_DEFINITION(0x1, 0x87B) },
    { ZYDIS_DEFINITION(0x1, 0x87C), ZYDIS_DEFINITION(0x1, 0x87D), ZYDIS_DEFINITION(0x1, 0x87E) },
    { ZYDIS_DEFINITION(0x1, 0x87F), ZYDIS_DEFINITION(0x1, 0x880), ZYDIS_DEFINITION(0x1, 0x881) },
    { ZYDIS_DEFINITION(0x1, 0x882), ZYDIS_DEFINITION(0x1, 0x883), ZYDIS_DEFINITION(0x1, 0x884) },
    { ZYDIS_DEFINITION(0x1, 0x885), ZYDIS_DEFINITION(0x1, 0x886), ZYDIS_DEFINITION(0x1, 0x887) },
    { ZYDIS_DEFINITION(0x1, 0xACB), ZYDIS_DEFINITION(0x1, 0xACC), ZYDIS_DEFINITION(0x1, 0xACD) },
    { ZYDIS_DEFINITION(0x1, 0xADD), ZYDIS_DEFINITION(0x1, 0xADE), ZYDIS_DEFINITION(0x1, 0xADF) },
    { ZYDIS_DEFINITION(0x1, 0xACE), ZYDIS_DEFINITION(0x1, 0xACF), ZYDIS_DEFINITION(0x1, 0xAD0) },
    { ZYDIS_DEFINITION(0x1, 0xAE0), ZYDIS_DEFINITION(0x1, 0xAE1), ZYDIS_DEFINITION(0x1, 0xAE2) },
    { ZYDIS_DEFINITION(0x1, 0xAD1), ZYDIS_DEFINITION(0x1, 0xAD2), ZYDIS_DEFINITION(0x1, 0xAD3) },
    { ZYDIS_DEFINITION(0x1, 0xAD7), ZYDIS_DEFINITION(0x1, 0xAD8), ZYDIS_DEFINITION(0x1, 0xAD9) },
    { ZYDIS_DEFINITION(0x1, 0xAD4), ZYDIS_DEFINITION(0x1, 0xAD5), ZYDIS_DEFINITION(0x1, 0xAD6) },
    { ZYDIS_DEFINITION(0x1, 0xADA), ZYDIS_DEFINITION(0x1, 0xADB), ZYDIS_DEFINITION(0x1, 0xADC) },
    { ZYDIS_DEFINITION(0x1, 0x7C2), ZYDIS_DEFINITION(0x1, 0x7C3), ZYDIS_DEFINITION(0x1, 0x7C4) },
    { ZYDIS_DEFINITION(0x1, 0x7C5), ZYDIS_DEFINITION(0x1, 0x7C6), ZYDIS_DEFINITION(0x1, 0x7C7) },
    { ZYDIS_DEFINITION(0x1, 0x74), ZYDIS_DEFINITION(0x1, 0x75), ZYDIS_DEFINITION(0x1, 0x76) },
    { ZYDIS_DEFINITION(0x1, 0x7D4), ZYDIS_DEFINITION(0x1, 0x7D5), ZYDIS_DEFINITION(0x1, 0x7D6) },
    { ZYDIS_DEFINITION(0x1, 0x77), ZYDIS_DEFINITION(0x1, 0x78), ZYDIS_DEFINITION(0x1, 0x79) },
    { ZYDIS_DEFINITION(0x1, 0x7D7), ZYDIS_DEFINITION(0x1, 0x7D8), ZYDIS_DEFINITION(0x1, 0x7D9) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x7A), ZYDIS_DEFINITION(0x1, 0x7B) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x7D), ZYDIS_DEFINITION(0x1, 0x7E) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x7C) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x7F) },
    { ZYDIS_DEFINITION(0x1, 0x90C), ZYDIS_DEFINITION(0x1, 0x90D), ZYDIS_DEFINITION(0x1, 0x90E) },
    { ZYDIS_DEFINITION(0x1, 0x91E), ZYDIS_DEFINITION(0x1, 0x91F), ZYDIS_DEFINITION(0x1, 0x920) },
    { ZYDIS_DEFINITION(0x1, 0x90F), ZYDIS_DEFINITION(0x1, 0x910), ZYDIS_DEFINITION(0x1, 0x911) },
    { ZYDIS_DEFINITION(0x1, 0x921), ZYDIS_DEFINITION(0x1, 0x922), ZYDIS_DEFINITION(0x1, 0x923) },
    { ZYDIS_DEFINITION(0x1, 0x84C), ZYDIS_DEFINITION(0x1, 0x84D), ZYDIS_DEFINITION(0x1, 0x84E) },
    { ZYDIS_DEFINITION(0x1, 0x85E), ZYDIS_DEFINITION(0x1, 0x85F), ZYDIS_DEFINITION(0x1, 0x860) },
    { ZYDIS_DEFINITION(0x1, 0x84F), ZYDIS_DEFINITION(0x1, 0x850), ZYDIS_DEFINITION(0x1, 0x851) },
    { ZYDIS_DEFINITION(0x1, 0x861), ZYDIS_DEFINITION(0x1, 0x862), ZYDIS_DEFINITION(0x1, 0x863) },
    { ZYDIS_DEFINITION(0x1, 0x7A7), ZYDIS_DEFINITION(0x1, 0x7A8), ZYDIS_DEFINITION(0x1, 0x7A9) },
    { ZYDIS_DEFINITION(0x1, 0x7AD), ZYDIS_DEFINITION(0x1, 0x7AE), ZYDIS_DEFINITION(0x1, 0x7AF) },
    { ZYDIS_DEFINITION(0x1, 0x7AA), ZYDIS_DEFINITION(0x1, 0x7AB), ZYDIS_DEFINITION(0x1, 0x7AC) },
    { ZYDIS_DEFINITION(0x1, 0x7B0), ZYDIS_DEFINITION(0x1, 0x7B1), ZYDIS_DEFINITION(0x1, 0x7B2) },
    { ZYDIS_DEFINITION(0x1, 0x64), ZYDIS_DEFINITION(0x1, 0x65), ZYDIS_DEFINITION(0x1, 0x66) },
    { ZYDIS_DEFINITION(0x1, 0x5E), ZYDIS_DEFINITION(0x1, 0x5F), ZYDIS_DEFINITION(0x1, 0x60) },
    { ZYDIS_DEFINITION(0x1, 0x67), ZYDIS_DEFINITION(0x1, 0x68), ZYDIS_DEFINITION(0x1, 0x69) },
    { ZYDIS_DEFINITION(0x1, 0x61), ZYDIS_DEFINITION(0x1, 0x62), ZYDIS_DEFINITION(0x1, 0x63) },
    { ZYDIS_DEFINITION(0x1, 0x7A1), ZYDIS_DEFINITION(0x1, 0x7A2), ZYDIS_DEFINITION(0x1, 0x7A3) },
    { ZYDIS_DEFINITION(0x1, 0x7B3), ZYDIS_DEFINITION(0x1, 0x7B4), ZYDIS_DEFINITION(0x1, 0x7B5) },
    { ZYDIS_DEFINITION(0x1, 0x7A4), ZYDIS_DEFINITION(0x1, 0x7A5), ZYDIS_DEFINITION(0x1, 0x7A6) },
    { ZYDIS_DEFINITION(0x1, 0x7B6), ZYDIS_DEFINITION(0x1, 0x7B7), ZYDIS_DEFINITION(0x1, 0x7B8) },
    { ZYDIS_DEFINITION(0x1, 0xB49), ZYDIS_DEFINITION(0x1, 0xB4A), ZYDIS_DEFINITION(0x1, 0xB4B) },
    { ZYDIS_DEFINITION(0x1, 0xB4C), ZYDIS_DEFINITION(0x1, 0xB4D), ZYDIS_DEFINITION(0x1, 0xB4E) },
    { ZYDIS_DEFINITION(0x1, 0xB3D), ZYDIS_DEFINITION(0x1, 0xB3E), ZYDIS_DEFINITION(0x1, 0xB3F) },
    { ZYDIS_DEFINITION(0x1, 0xB43), ZYDIS_DEFINITION(0x1, 0xB44), ZYDIS_DEFINITION(0x1, 0xB45) },
    { ZYDIS_DEFINITION(0x1, 0xB40), ZYDIS_DEFINITION(0x1, 0xB41), ZYDIS_DEFINITION(0x1, 0xB42) },
    { ZYDIS_DEFINITION(0x1, 0xB46), ZYDIS_DEFINITION(0x1, 0xB47), ZYDIS_DEFINITION(0x1, 0xB48) },
    { ZYDIS_DEFINITION(0x1, 0xB6D), ZYDIS_DEFINITION(0x1, 0xB6E), ZYDIS_DEFINITION(0x1, 0xB6F) },
    { ZYDIS_DEFINITION(0x1, 0xB70), ZYDIS_DEFINITION(0x1, 0xB71), ZYDIS_DEFINITION(0x1, 0xB72) },
    { ZYDIS_DEFINITION(0x1, 0xB61), ZYDIS_DEFINITION(0x1, 0xB62), ZYDIS_DEFINITION(0x1, 0xB63) },
    { ZYDIS_DEFINITION(0x1, 0xB67), ZYDIS_DEFINITION(0x1, 0xB68), ZYDIS_DEFINITION(0x1, 0xB69) },
    { ZYDIS_DEFINITION(0x1, 0xB64), ZYDIS_DEFINITION(0x1, 0xB65), ZYDIS_DEFINITION(0x1, 0xB66) },
    { ZYDIS_DEFINITION(0x1, 0xB6A), ZYDIS_DEFINITION(0x1, 0xB6B), ZYDIS_DEFINITION(0x1, 0xB6C) },
    { ZYDIS_DEFINITION(0x1, 0x892), ZYDIS_DEFINITION(0x1, 0x893), ZYDIS_DEFINITION(0x1, 0x894) },
    { ZYDIS_DEFINITION(0x1, 0x8B0), ZYDIS_DEFINITION(0x1, 0x8B1), ZYDIS_DEFINITION(0x1, 0x8B2) },
    { ZYDIS_DEFINITION(0x1, 0x895), ZYDIS_DEFINITION(0x1, 0x896), ZYDIS_DEFINITION(0x1, 0x897) },
    { ZYDIS_DEFINITION(0x1, 0x8B3), ZYDIS_DEFINITION(0x1, 0x8B4), ZYDIS_DEFINITION(0x1, 0x8B5) },
    { ZYDIS_DEFINITION(0x1, 0x898), ZYDIS_DEFINITION(0x1, 0x899), ZYDIS_DEFINITION(0x1, 0x89A) },
    { ZYDIS_DEFINITION(0x1, 0x8AA), ZYDIS_DEFINITION(0x1, 0x8AB), ZYDIS_DEFINITION(0x1, 0x8AC) },
    { ZYDIS_DEFINITION(0x1, 0x89B), ZYDIS_DEFINITION(0x1, 0x89C), ZYDIS_DEFINITION(0x1, 0x89D) },
    { ZYDIS_DEFINITION(0x1, 0x8AD), ZYDIS_DEFINITION(0x1, 0x8AE), ZYDIS_DEFINITION(0x1, 0x8AF) },
    { ZYDIS_DEFINITION(0x1, 0x8A4), ZYDIS_DEFINITION(0x1, 0x8A5), ZYDIS_DEFINITION(0x1, 0x8A6) },
    { ZYDIS_DEFINITION(0x1, 0x89E), ZYDIS_DEFINITION(0x1, 0x89F), ZYDIS_DEFINITION(0x1, 0x8A0) },
    { ZYDIS_DEFINITION(0x1, 0x8A7), ZYDIS_DEFINITION(0x1, 0x8A8), ZYDIS_DEFINITION(0x1, 0x8A9) },
    { ZYDIS_DEFINITION(0x1, 0x8A1), ZYDIS_DEFINITION(0x1, 0x8A2), ZYDIS_DEFINITION(0x1, 0x8A3) },
    { ZYDIS_DEFINITION(0x1, 0x7B9), ZYDIS_DEFINITION(0x1, 0x7BA), ZYDIS_DEFINITION(0x1, 0x7BB) },
    { ZYDIS_DEFINITION(0x1, 0x7BC), ZYDIS_DEFINITION(0x1, 0x7BD), ZYDIS_DEFINITION(0x1, 0x7BE) },
    { ZYDIS_DEFINITION(0x1, 0x7DD), ZYDIS_DEFINITION(0x1, 0x7DE), ZYDIS_DEFINITION(0x1, 0x7DF) },
    { ZYDIS_DEFINITION(0x1, 0x7E0), ZYDIS_DEFINITION(0x1, 0x7E1), ZYDIS_DEFINITION(0x1, 0x7E2) },
    { ZYDIS_DEFINITION(0x1, 0x7BF), ZYDIS_DEFINITION(0x1, 0x7C0), ZYDIS_DEFINITION(0x1, 0x7C1) },
    { ZYDIS_DEFINITION(0x1, 0x7E3), ZYDIS_DEFINITION(0x1, 0x7E4), ZYDIS_DEFINITION(0x1, 0x7E5) },
    { ZYDIS_DEFINITION(0x1, 0x7C8), ZYDIS_DEFINITION(0x1, 0x7C9), ZYDIS_DEFINITION(0x1, 0x7CA) },
    { ZYDIS_DEFINITION(0x1, 0x7DA), ZYDIS_DEFINITION(0x1, 0x7DB), ZYDIS_DEFINITION(0x1, 0x7DC) },
    { ZYDIS_DEFINITION(0x1, 0x7CB), ZYDIS_DEFINITION(0x1, 0x7CC), ZYDIS_DEFINITION(0x1, 0x7CD) },
    { ZYDIS_DEFINITION(0x1, 0x8E2), ZYDIS_DEFINITION(0x1, 0x8E3), ZYDIS_DEFINITION(0x1, 0x8E4) },
    { ZYDIS_DEFINITION(0x1, 0x900), ZYDIS_DEFINITION(0x1, 0x901), ZYDIS_DEFINITION(0x1, 0x902) },
    { ZYDIS_DEFINITION(0x1, 0x8E5), ZYDIS_DEFINITION(0x1, 0x8E6), ZYDIS_DEFINITION(0x1, 0x8E7) },
    { ZYDIS_DEFINITION(0x1, 0x903), ZYDIS_DEFINITION(0x1, 0x904), ZYDIS_DEFINITION(0x1, 0x905) },
    { ZYDIS_DEFINITION(0x1, 0x8E8), ZYDIS_DEFINITION(0x1, 0x8E9), ZYDIS_DEFINITION(0x1, 0x8EA) },
    { ZYDIS_DEFINITION(0x1, 0x8FA), ZYDIS_DEFINITION(0x1, 0x8FB), ZYDIS_DEFINITION(0x1, 0x8FC) },
    { ZYDIS_DEFINITION(0x1, 0x8EB), ZYDIS_DEFINITION(0x1, 0x8EC), ZYDIS_DEFINITION(0x1, 0x8ED) },
    { ZYDIS_DEFINITION(0x1, 0x8FD), ZYDIS_DEFINITION(0x1, 0x8FE), ZYDIS_DEFINITION(0x1, 0x8FF) },
    { ZYDIS_DEFINITION(0x1, 0x8F4), ZYDIS_DEFINITION(0x1, 0x8F5), ZYDIS_DEFINITION(0x1, 0x8F6) },
    { ZYDIS_DEFINITION(0x1, 0x8EE), ZYDIS_DEFINITION(0x1, 0x8EF), ZYDIS_DEFINITION(0x1, 0x8F0) },
    { ZYDIS_DEFINITION(0x1, 0x8F7), ZYDIS_DEFINITION(0x1, 0x8F8), ZYDIS_DEFINITION(0x1, 0x8F9) },
    { ZYDIS_DEFINITION(0x1, 0x8F1), ZYDIS_DEFINITION(0x1, 0x8F2), ZYDIS_DEFINITION(0x1, 0x8F3) },
    { ZYDIS_DEFINITION(0x1, 0xABF), ZYDIS_DEFINITION(0x1, 0xAC0), ZYDIS_DEFINITION(0x1, 0xAC1) },
    { ZYDIS_DEFINITION(0x1, 0xAC2), ZYDIS_DEFINITION(0x1, 0xAC3), ZYDIS_DEFINITION(0x1, 0xAC4) },
    { ZYDIS_DEFINITION(0x1, 0x30D), ZYDIS_DEFINITION(0x1, 0x30E), ZYDIS_DEFINITION(0x1, 0x30F) },
    { ZYDIS_DEFINITION(0x1, 0x307), ZYDIS_DEFINITION(0x1, 0x308), ZYDIS_DEFINITION(0x1, 0x309) },
    { ZYDIS_DEFINITION(0x1, 0x310), ZYDIS_DEFINITION(0x1, 0x311), ZYDIS_DEFINITION(0x1, 0x312) },
    { ZYDIS_DEFINITION(0x1, 0x30A), ZYDIS_DEFINITION(0x1, 0x30B), ZYDIS_DEFINITION(0x1, 0x30C) },
    { ZYDIS_DEFINITION(0x1, 0x912), ZYDIS_DEFINITION(0x1, 0x913), ZYDIS_DEFINITION(0x1, 0x914) },
    { ZYDIS_DEFINITION(0x1, 0x918), ZYDIS_DEFINITION(0x1, 0x919), ZYDIS_DEFINITION(0x1, 0x91A) },
    { ZYDIS_DEFINITION(0x1, 0x915), ZYDIS_DEFINITION(0x1, 0x916), ZYDIS_DEFINITION(0x1, 0x917) },
    { ZYDIS_DEFINITION(0x1, 0x91B), ZYDIS_DEFINITION(0x1, 0x91C), ZYDIS_DEFINITION(0x1, 0x91D) },
    { ZYDIS_DEFINITION(0x1, 0xB7), ZYDIS_DEFINITION(0x1, 0xB8), ZYDIS_DEFINITION(0x1, 0xB9) },
    { ZYDIS_DEFINITION(0x1, 0xB1), ZYDIS_DEFINITION(0x1, 0xB2), ZYDIS_DEFINITION(0x1, 0xB3) },
    { ZYDIS_DEFINITION(0x1, 0xBA), ZYDIS_DEFINITION(0x1, 0xBB), ZYDIS_DEFINITION(0x1, 0xBC) },
    { ZYDIS_DEFINITION(0x1, 0xB4), ZYDIS_DEFINITION(0x1, 0xB5), ZYDIS_DEFINITION(0x1, 0xB6) },
    { ZYDIS_DEFINITION(0x1, 0x852), ZYDIS_DEFINITION(0x1, 0x853), ZYDIS_DEFINITION(0x1, 0x854) },
    { ZYDIS_DEFINITION(0x1, 0x858), ZYDIS_DEFINITION(0x1, 0x859), ZYDIS_DEFINITION(0x1, 0x85A) },
    { ZYDIS_DEFINITION(0x1, 0x855), ZYDIS_DEFINITION(0x1, 0x856), ZYDIS_DEFINITION(0x1, 0x857) },
    { ZYDIS_DEFINITION(0x1, 0x85B), ZYDIS_DEFINITION(0x1, 0x85C), ZYDIS_DEFINITION(0x1, 0x85D) },
    { ZYDIS_DEFINITION(0x1, 0x888), ZYDIS_DEFINITION(0x1, 0x889), ZYDIS_DEFINITION(0x1, 0x88A) },
    { ZYDIS_DEFINITION(0x1, 0x906), ZYDIS_DEFINITION(0x1, 0x907), ZYDIS_DEFINITION(0x1, 0x908) },
    { ZYDIS_DEFINITION(0x1, 0x88B), ZYDIS_DEFINITION(0x1, 0x88C), ZYDIS_DEFINITION(0x1, 0x88D) },
    { ZYDIS_DEFINITION(0x1, 0x909), ZYDIS_DEFINITION(0x1, 0x90A), ZYDIS_DEFINITION(0x1, 0x90B) },
    { ZYDIS_DEFINITION(0x1, 0xB7F), ZYDIS_DEFINITION(0x1, 0xB80), ZYDIS_DEFINITION(0x1, 0xB81) },
    { ZYDIS_DEFINITION(0x1, 0xB82), ZYDIS_DEFINITION(0x1, 0xB83), ZYDIS_DEFINITION(0x1, 0xB84) },
    { ZYDIS_DEFINITION(0x1, 0x92F), ZYDIS_DEFINITION(0x1, 0x930), ZYDIS_DEFINITION(0x1, 0x931) },
    { ZYDIS_DEFINITION(0x1, 0x932), ZYDIS_DEFINITION(0x1, 0x933), ZYDIS_DEFINITION(0x1, 0x934) },
    { ZYDIS_DEFINITION(0x1, 0x935), ZYDIS_DEFINITION(0x1, 0x936), ZYDIS_DEFINITION(0x1, 0x937) },
    { ZYDIS_DEFINITION(0x1, 0x938), ZYDIS_DEFINITION(0x1, 0x939), ZYDIS_DEFINITION(0x1, 0x93A) },
    { ZYDIS_DEFINITION(0x1, 0x56A), ZYDIS_DEFINITION(0x1, 0x56B), ZYDIS_DEFINITION(0x1, 0x56C) },
    { ZYDIS_DEFINITION(0x1, 0x567), ZYDIS_DEFINITION(0x1, 0x568), ZYDIS_DEFINITION(0x1, 0x569) },
    { ZYDIS_DEFINITION(0x1, 0x578), ZYDIS_DEFINITION(0x1, 0x579), ZYDIS_DEFINITION(0x1, 0x57A) },
    { ZYDIS_DEFINITION(0x1, 0x575), ZYDIS_DEFINITION(0x1, 0x576), ZYDIS_DEFINITION(0x1, 0x577) },
    { ZYDIS_DEFINITION(0x1, 0x3C8), ZYDIS_DEFINITION(0x1, 0x3C9), ZYDIS_DEFINITION(0x1, 0x3CA) },
    { ZYDIS_DEFINITION(0x1, 0x3BA), ZYDIS_DEFINITION(0x1, 0x3BB), ZYDIS_DEFINITION(0x1, 0x3BC) },
    { ZYDIS_DEFINITION(0x1, 0x3CB), ZYDIS_DEFINITION(0x1, 0x3CC), ZYDIS_DEFINITION(0x1, 0x3CD) },
    { ZYDIS_DEFINITION(0x1, 0x3BD), ZYDIS_DEFINITION(0x1, 0x3BE), ZYDIS_DEFINITION(0x1, 0x3BF) },
    { ZYDIS_DEFINITION(0x1, 0x461), ZYDIS_DEFINITION(0x1, 0x462), ZYDIS_DEFINITION(0x1, 0x463) },
    { ZYDIS_DEFINITION(0x1, 0x453), ZYDIS_DEFINITION(0x1, 0x454), ZYDIS_DEFINITION(0x1, 0x455) },
    { ZYDIS_DEFINITION(0x1, 0x464), ZYDIS_DEFINITION(0x1, 0x465), ZYDIS_DEFINITION(0x1, 0x466) },
    { ZYDIS_DEFINITION(0x1, 0x456), ZYDIS_DEFINITION(0x1, 0x457), ZYDIS_DEFINITION(0x1, 0x458) },
    { ZYDIS_DEFINITION(0x1, 0x364), ZYDIS_DEFINITION(0x1, 0x365), ZYDIS_DEFINITION(0x1, 0x366) },
    { ZYDIS_DEFINITION(0x1, 0x356), ZYDIS_DEFINITION(0x1, 0x357), ZYDIS_DEFINITION(0x1, 0x358) },
    { ZYDIS_DEFINITION(0x1, 0x367), ZYDIS_DEFINITION(0x1, 0x368), ZYDIS_DEFINITION(0x1, 0x369) },
    { ZYDIS_DEFINITION(0x1, 0x359), ZYDIS_DEFINITION(0x1, 0x35A), ZYDIS_DEFINITION(0x1, 0x35B) },
    { ZYDIS_DEFINITION(0x1, 0x407), ZYDIS_DEFINITION(0x1, 0x408), ZYDIS_DEFINITION(0x1, 0x409) },
    { ZYDIS_DEFINITION(0x1, 0x3F9), ZYDIS_DEFINITION(0x1, 0x3FA), ZYDIS_DEFINITION(0x1, 0x3FB) },
    { ZYDIS_DEFINITION(0x1, 0x40A), ZYDIS_DEFINITION(0x1, 0x40B), ZYDIS_DEFINITION(0x1, 0x40C) },
    { ZYDIS_DEFINITION(0x1, 0x3FC), ZYDIS_DEFINITION(0x1, 0x3FD), ZYDIS_DEFINITION(0x1, 0x3FE) },
    { ZYDIS_DEFINITION(0x1, 0x4AA), ZYDIS_DEFINITION(0x1, 0x4AB), ZYDIS_DEFINITION(0x1, 0x4AC) },
    { ZYDIS_DEFINITION(0x1, 0x49C), ZYDIS_DEFINITION(0x1, 0x49D), ZYDIS_DEFINITION(0x1, 0x49E) },
    { ZYDIS_DEFINITION(0x1, 0x4AD), ZYDIS_DEFINITION(0x1, 0x4AE), ZYDIS_DEFINITION(0x1, 0x4AF) },
    { ZYDIS_DEFINITION(0x1, 0x49F), ZYDIS_DEFINITION(0x1, 0x4A0), ZYDIS_DEFINITION(0x1, 0x4A1) },
    { ZYDIS_DEFINITION(0x1, 0x504), ZYDIS_DEFINITION(0x1, 0x505), ZYDIS_DEFINITION(0x1, 0x506) },
    { ZYDIS_DEFINITION(0x1, 0x4F6), ZYDIS_DEFINITION(0x1, 0x4F7), ZYDIS_DEFINITION(0x1, 0x4F8) },
    { ZYDIS_DEFINITION(0x1, 0x507), ZYDIS_DEFINITION(0x1, 0x508), ZYDIS_DEFINITION(0x1, 0x509) },
    { ZYDIS_DEFINITION(0x1, 0x4F9), ZYDIS_DEFINITION(0x1, 0x4FA), ZYDIS_DEFINITION(0x1, 0x4FB) },
    { ZYDIS_DEFINITION(0x1, 0xB25), ZYDIS_DEFINITION(0x1, 0xB26), ZYDIS_DEFINITION(0x1, 0xB27) },
    { ZYDIS_DEFINITION(0x1, 0xB28), ZYDIS_DEFINITION(0x1, 0xB29), ZYDIS_DEFINITION(0x1, 0xB2A) },
    { ZYDIS_DEFINITION(0x1, 0xB2B), ZYDIS_DEFINITION(0x1, 0xB2C), ZYDIS_DEFINITION(0x1, 0xB2D) },
    { ZYDIS_DEFINITION(0x1, 0xB2E), ZYDIS_DEFINITION(0x1, 0xB2F), ZYDIS_DEFINITION(0x1, 0xB30) },
    { ZYDIS_DEFINITION(0x1, 0xDA6), ZYDIS_DEFINITION(0x1, 0xDA7), ZYDIS_DEFINITION(0x1, 0xDA8) },
    { ZYDIS_DEFINITION(0x1, 0xDA3), ZYDIS_DEFINITION(0x1, 0xDA4), ZYDIS_DEFINITION(0x1, 0xDA5) },
    { ZYDIS_DEFINITION(0x1, 0xDB4), ZYDIS_DEFINITION(0x1, 0xDB5), ZYDIS_DEFINITION(0x1, 0xDB6) },
    { ZYDIS_DEFINITION(0x1, 0xDB1), ZYDIS_DEFINITION(0x1, 0xDB2), ZYDIS_DEFINITION(0x1, 0xDB3) },
    { ZYDIS_DEFINITION(0x1, 0x3DD), ZYDIS_DEFINITION(0x1, 0x3DE), ZYDIS_DEFINITION(0x1, 0x3DF) },
    { ZYDIS_DEFINITION(0x1, 0x3CF), ZYDIS_DEFINITION(0x1, 0x3D0), ZYDIS_DEFINITION(0x1, 0x3D1) },
    { ZYDIS_DEFINITION(0x1, 0x3E0), ZYDIS_DEFINITION(0x1, 0x3E1), ZYDIS_DEFINITION(0x1, 0x3E2) },
    { ZYDIS_DEFINITION(0x1, 0x3D2), ZYDIS_DEFINITION(0x1, 0x3D3), ZYDIS_DEFINITION(0x1, 0x3D4) },
    { ZYDIS_DEFINITION(0x1, 0x476), ZYDIS_DEFINITION(0x1, 0x477), ZYDIS_DEFINITION(0x1, 0x478) },
    { ZYDIS_DEFINITION(0x1, 0x468), ZYDIS_DEFINITION(0x1, 0x469), ZYDIS_DEFINITION(0x1, 0x46A) },
    { ZYDIS_DEFINITION(0x1, 0x479), ZYDIS_DEFINITION(0x1, 0x47A), ZYDIS_DEFINITION(0x1, 0x47B) },
    { ZYDIS_DEFINITION(0x1, 0x46B), ZYDIS_DEFINITION(0x1, 0x46C), ZYDIS_DEFINITION(0x1, 0x46D) },
    { ZYDIS_DEFINITION(0x1, 0x382), ZYDIS_DEFINITION(0x1, 0x383), ZYDIS_DEFINITION(0x1, 0x384) },
    { ZYDIS_DEFINITION(0x1, 0x374), ZYDIS_DEFINITION(0x1, 0x375), ZYDIS_DEFINITION(0x1, 0x376) },
    { ZYDIS_DEFINITION(0x1, 0x385), ZYDIS_DEFINITION(0x1, 0x386), ZYDIS_DEFINITION(0x1, 0x387) },
    { ZYDIS_DEFINITION(0x1, 0x377), ZYDIS_DEFINITION(0x1, 0x378), ZYDIS_DEFINITION(0x1, 0x379) },
    { ZYDIS_DEFINITION(0x1, 0x425), ZYDIS_DEFINITION(0x1, 0x426), ZYDIS_DEFINITION(0x1, 0x427) },
    { ZYDIS_DEFINITION(0x1, 0x417), ZYDIS_DEFINITION(0x1, 0x418), ZYDIS_DEFINITION(0x1, 0x419) },
    { ZYDIS_DEFINITION(0x1, 0x428), ZYDIS_DEFINITION(0x1, 0x429), ZYDIS_DEFINITION(0x1, 0x42A) },
    { ZYDIS_DEFINITION(0x1, 0x41A), ZYDIS_DEFINITION(0x1, 0x41B), ZYDIS_DEFINITION(0x1, 0x41C) },
    { ZYDIS_DEFINITION(0x1, 0x4C8), ZYDIS_DEFINITION(0x1, 0x4C9), ZYDIS_DEFINITION(0x1, 0x4CA) },
    { ZYDIS_DEFINITION(0x1, 0x4BA), ZYDIS_DEFINITION(0x1, 0x4BB), ZYDIS_DEFINITION(0x1, 0x4BC) },
    { ZYDIS_DEFINITION(0x1, 0x4CB), ZYDIS_DEFINITION(0x1, 0x4CC), ZYDIS_DEFINITION(0x1, 0x4CD) },
    { ZYDIS_DEFINITION(0x1, 0x4BD), ZYDIS_DEFINITION(0x1, 0x4BE), ZYDIS_DEFINITION(0x1, 0x4BF) },
    { ZYDIS_DEFINITION(0x1, 0x522), ZYDIS_DEFINITION(0x1, 0x523), ZYDIS_DEFINITION(0x1, 0x524) },
    { ZYDIS_DEFINITION(0x1, 0x514), ZYDIS_DEFINITION(0x1, 0x515), ZYDIS_DEFINITION(0x1, 0x516) },
    { ZYDIS_DEFINITION(0x1, 0x525), ZYDIS_DEFINITION(0x1, 0x526), ZYDIS_DEFINITION(0x1, 0x527) },
    { ZYDIS_DEFINITION(0x1, 0x517), ZYDIS_DEFINITION(0x1, 0x518), ZYDIS_DEFINITION(0x1, 0x519) },
    { ZYDIS_DEFINITION(0x1, 0x957), ZYDIS_DEFINITION(0x1, 0x958), ZYDIS_DEFINITION(0x1, 0x959) },
    { ZYDIS_DEFINITION(0x1, 0x95A), ZYDIS_DEFINITION(0x1, 0x95B), ZYDIS_DEFINITION(0x1, 0x95C) },
    { ZYDIS_DEFINITION(0x1, 0x951), ZYDIS_DEFINITION(0x1, 0x952), ZYDIS_DEFINITION(0x1, 0x953) },
    { ZYDIS_DEFINITION(0x1, 0x954), ZYDIS_DEFINITION(0x1, 0x955), ZYDIS_DEFINITION(0x1, 0x956) },
    { ZYDIS_DEFINITION(0x1, 0x3F2), ZYDIS_DEFINITION(0x1, 0x3F3), ZYDIS_DEFINITION(0x1, 0x3F4) },
    { ZYDIS_DEFINITION(0x1, 0x3E4), ZYDIS_DEFINITION(0x1, 0x3E5), ZYDIS_DEFINITION(0x1, 0x3E6) },
    { ZYDIS_DEFINITION(0x1, 0x3F5), ZYDIS_DEFINITION(0x1, 0x3F6), ZYDIS_DEFINITION(0x1, 0x3F7) },
    { ZYDIS_DEFINITION(0x1, 0x3E7), ZYDIS_DEFINITION(0x1, 0x3E8), ZYDIS_DEFINITION(0x1, 0x3E9) },
    { ZYDIS_DEFINITION(0x1, 0x48B), ZYDIS_DEFINITION(0x1, 0x48C), ZYDIS_DEFINITION(0x1, 0x48D) },
    { ZYDIS_DEFINITION(0x1, 0x47D), ZYDIS_DEFINITION(0x1, 0x47E), ZYDIS_DEFINITION(0x1, 0x47F) },
    { ZYDIS_DEFINITION(0x1, 0x48E), ZYDIS_DEFINITION(0x1, 0x48F), ZYDIS_DEFINITION(0x1, 0x490) },
    { ZYDIS_DEFINITION(0x1, 0x480), ZYDIS_DEFINITION(0x1, 0x481), ZYDIS_DEFINITION(0x1, 0x482) },
    { ZYDIS_DEFINITION(0x1, 0x3A0), ZYDIS_DEFINITION(0x1, 0x3A1), ZYDIS_DEFINITION(0x1, 0x3A2) },
    { ZYDIS_DEFINITION(0x1, 0x392), ZYDIS_DEFINITION(0x1, 0x393), ZYDIS_DEFINITION(0x1, 0x394) },
    { ZYDIS_DEFINITION(0x1, 0x3A3), ZYDIS_DEFINITION(0x1, 0x3A4), ZYDIS_DEFINITION(0x1, 0x3A5) },
    { ZYDIS_DEFINITION(0x1, 0x395), ZYDIS_DEFINITION(0x1, 0x396), ZYDIS_DEFINITION(0x1, 0x397) },
    { ZYDIS_DEFINITION(0x1, 0x443), ZYDIS_DEFINITION(0x1, 0x444), ZYDIS_DEFINITION(0x1, 0x445) },
    { ZYDIS_DEFINITION(0x1, 0x435), ZYDIS_DEFINITION(0x1, 0x436), ZYDIS_DEFINITION(0x1, 0x437) },
    { ZYDIS_DEFINITION(0x1, 0x446), ZYDIS_DEFINITION(0x1, 0x447), ZYDIS_DEFINITION(0x1, 0x448) },
    { ZYDIS_DEFINITION(0x1, 0x438), ZYDIS_DEFINITION(0x1, 0x439), ZYDIS_DEFINITION(0x1, 0x43A) },
    { ZYDIS_DEFINITION(0x1, 0x4E6), ZYDIS_DEFINITION(0x1, 0x4E7), ZYDIS_DEFINITION(0x1, 0x4E8) },
    { ZYDIS_DEFINITION(0x1, 0x4D8), ZYDIS_DEFINITION(0x1, 0x4D9), ZYDIS_DEFINITION(0x1, 0x4DA) },
    { ZYDIS_DEFINITION(0x1, 0x4E9), ZYDIS_DEFINITION(0x1, 0x4EA), ZYDIS_DEFINITION(0x1, 0x4EB) },
    { ZYDIS_DEFINITION(0x1, 0x4DB), ZYDIS_DEFINITION(0x1, 0x4DC), ZYDIS_DEFINITION(0x1, 0x4DD) },
    { ZYDIS_DEFINITION(0x1, 0x540), ZYDIS_DEFINITION(0x1, 0x541), ZYDIS_DEFINITION(0x1, 0x542) },
    { ZYDIS_DEFINITION(0x1, 0x532), ZYDIS_DEFINITION(0x1, 0x533), ZYDIS_DEFINITION(0x1, 0x534) },
    { ZYDIS_DEFINITION(0x1, 0x543), ZYDIS_DEFINITION(0x1, 0x544), ZYDIS_DEFINITION(0x1, 0x545) },
    { ZYDIS_DEFINITION(0x1, 0x535), ZYDIS_DEFINITION(0x1, 0x536), ZYDIS_DEFINITION(0x1, 0x537) },
    { ZYDIS_DEFINITION(0x1, 0x864), ZYDIS_DEFINITION(0x1, 0x865), ZYDIS_DEFINITION(0x1, 0x866) },
    { ZYDIS_DEFINITION(0x1, 0x86A), ZYDIS_DEFINITION(0x1, 0x86B), ZYDIS_DEFINITION(0x1, 0x86C) },
    { ZYDIS_DEFINITION(0x1, 0x867), ZYDIS_DEFINITION(0x1, 0x868), ZYDIS_DEFINITION(0x1, 0x869) },
    { ZYDIS_DEFINITION(0x1, 0x86D), ZYDIS_DEFINITION(0x1, 0x86E), ZYDIS_DEFINITION(0x1, 0x86F) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x56E) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x56D) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x572) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x571) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xDAA) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xDA9) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xDAE) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xDAD) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x570) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x56F) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x574) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x573) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xDAC) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xDAB) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xDB0) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xDAF) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x305) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x302) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x306) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x303) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xD15) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xD12) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xD16) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xD13) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xD75) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xD72) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xD76) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0xD73) },
    { ZYDIS_DEFINITION(0x1, 0x5C3), ZYDIS_DEFINITION(0x1, 0x5C4), ZYDIS_DEFINITION(0x1, 0x5C5) },
    { ZYDIS_DEFINITION(0x1, 0x5C6), ZYDIS_DEFINITION(0x1, 0x5C7), ZYDIS_DEFINITION(0x1, 0x5C8) },
    { ZYDIS_DEFINITION(0x1, 0x2E), ZYDIS_DEFINITION(0x1, 0x2F), ZYDIS_DEFINITION(0x1, 0x30) },
    { ZYDIS_DEFINITION(0x1, 0x31), ZYDIS_DEFINITION(0x1, 0x32), ZYDIS_DEFINITION(0x1, 0x33) },
    { ZYDIS_DEFINITION(0x1, 0x34), ZYDIS_DEFINITION(0x1, 0x35), ZYDIS_DEFINITION(0x1, 0x36) },
    { ZYDIS_DEFINITION(0x1, 0x37), ZYDIS_DEFINITION(0x1, 0x38), ZYDIS_DEFINITION(0x1, 0x39) },
    { ZYDIS_DEFINITION(0x1, 0x22), ZYDIS_DEFINITION(0x1, 0x23), ZYDIS_DEFINITION(0x1, 0x24) },
    { ZYDIS_DEFINITION(0x1, 0x25), ZYDIS_DEFINITION(0x1, 0x26), ZYDIS_DEFINITION(0x1, 0x27) },
    { ZYDIS_DEFINITION(0x1, 0x28), ZYDIS_DEFINITION(0x1, 0x29), ZYDIS_DEFINITION(0x1, 0x2A) },
    { ZYDIS_DEFINITION(0x1, 0x2B), ZYDIS_DEFINITION(0x1, 0x2C), ZYDIS_DEFINITION(0x1, 0x2D) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x8DE), ZYDIS_DEFINITION(0xB, 0x8DF) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x8E0), ZYDIS_DEFINITION(0xB, 0x8E1) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x8D2), ZYDIS_DEFINITION(0xB, 0x8D3) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x8D4), ZYDIS_DEFINITION(0xB, 0x8D5) },
    { ZYDIS_DEFINITION(0xB, 0x3A), ZYDIS_DEFINITION(0xB, 0x3B), ZYDIS_DEFINITION(0xB, 0x3C) },
    { ZYDIS_DEFINITION(0xB, 0x40), ZYDIS_DEFINITION(0xB, 0x41), ZYDIS_DEFINITION(0xB, 0x42) },
    { ZYDIS_DEFINITION(0xB, 0x3D), ZYDIS_DEFINITION(0xB, 0x3E), ZYDIS_DEFINITION(0xB, 0x3F) },
    { ZYDIS_DEFINITION(0xB, 0x43), ZYDIS_DEFINITION(0xB, 0x44), ZYDIS_DEFINITION(0xB, 0x45) },
    { ZYDIS_DEFINITION(0xB, 0x8C8), ZYDIS_DEFINITION(0xB, 0x8C9), ZYDIS_DEFINITION(0xB, 0x8CA) },
    { ZYDIS_DEFINITION(0xB, 0x8CB), ZYDIS_DEFINITION(0xB, 0x8CC), ZYDIS_DEFINITION(0xB, 0x8CD) },
    { ZYDIS_DEFINITION(0xB, 0x8BC), ZYDIS_DEFINITION(0xB, 0x8BD), ZYDIS_DEFINITION(0xB, 0x8BE) },
    { ZYDIS_DEFINITION(0xB, 0x8BF), ZYDIS_DEFINITION(0xB, 0x8C0), ZYDIS_DEFINITION(0xB, 0x8C1) },
    { ZYDIS_DEFINITION(0xB, 0xD52), ZYDIS_DEFINITION(0xB, 0xD53), ZYDIS_DEFINITION(0xB, 0xD54) },
    { ZYDIS_DEFINITION(0xB, 0xD55), ZYDIS_DEFINITION(0xB, 0xD56), ZYDIS_DEFINITION(0xB, 0xD57) },
    { ZYDIS_DEFINITION(0xB, 0xD44), ZYDIS_DEFINITION(0xB, 0xD45), ZYDIS_DEFINITION(0xB, 0xD46) },
    { ZYDIS_DEFINITION(0xB, 0xD47), ZYDIS_DEFINITION(0xB, 0xD48), ZYDIS_DEFINITION(0xB, 0xD49) },
    { ZYDIS_DEFINITION(0xB, 0x777), ZYDIS_DEFINITION(0xB, 0x778), ZYDIS_DEFINITION(0xB, 0x779) },
    { ZYDIS_DEFINITION(0xB, 0x77A), ZYDIS_DEFINITION(0xB, 0x77B), ZYDIS_DEFINITION(0xB, 0x77C) },
    { ZYDIS_DEFINITION(0xB, 0x924), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x925), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x92D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x92E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x926), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x92A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x928), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x927), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x92B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x929), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x32B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x32C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5C9), ZYDIS_DEFINITION(0xB, 0x5CA) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5CF), ZYDIS_DEFINITION(0xB, 0x5D0) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5CB), ZYDIS_DEFINITION(0xB, 0x5CC) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5D1), ZYDIS_DEFINITION(0xB, 0x5D2) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x313), ZYDIS_DEFINITION(0xB, 0x314) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x319), ZYDIS_DEFINITION(0xB, 0x31A) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x315), ZYDIS_DEFINITION(0xB, 0x316) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x31B), ZYDIS_DEFINITION(0xB, 0x31C) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5CD) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5D3) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5CE) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5D4) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x317) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x31D) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x318) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x31E) },
    { ZYDIS_DEFINITION(0xB, 0x156), ZYDIS_DEFINITION(0xB, 0x157), ZYDIS_DEFINITION(0xB, 0x158) },
    { ZYDIS_DEFINITION(0xB, 0x159), ZYDIS_DEFINITION(0xB, 0x15A), ZYDIS_DEFINITION(0xB, 0x15B) },
    { ZYDIS_DEFINITION(0xB, 0x834), ZYDIS_DEFINITION(0xB, 0x835), ZYDIS_DEFINITION(0xB, 0x836) },
    { ZYDIS_DEFINITION(0xB, 0x83A), ZYDIS_DEFINITION(0xB, 0x83B), ZYDIS_DEFINITION(0xB, 0x83C) },
    { ZYDIS_DEFINITION(0xB, 0x837), ZYDIS_DEFINITION(0xB, 0x838), ZYDIS_DEFINITION(0xB, 0x839) },
    { ZYDIS_DEFINITION(0xB, 0x83D), ZYDIS_DEFINITION(0xB, 0x83E), ZYDIS_DEFINITION(0xB, 0x83F) },
    { ZYDIS_DEFINITION(0xB, 0x7F2), ZYDIS_DEFINITION(0xB, 0x7F3), ZYDIS_DEFINITION(0xB, 0x7F4) },
    { ZYDIS_DEFINITION(0xB, 0x828), ZYDIS_DEFINITION(0xB, 0x829), ZYDIS_DEFINITION(0xB, 0x82A) },
    { ZYDIS_DEFINITION(0xB, 0x7F5), ZYDIS_DEFINITION(0xB, 0x7F6), ZYDIS_DEFINITION(0xB, 0x7F7) },
    { ZYDIS_DEFINITION(0xB, 0x82B), ZYDIS_DEFINITION(0xB, 0x82C), ZYDIS_DEFINITION(0xB, 0x82D) },
    { ZYDIS_DEFINITION(0xB, 0x93B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x93C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5E1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x5E2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x93D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x941), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x93F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x93E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x942), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0xB, 0x940), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xDB7), ZYDIS_DEFINITION(0xB, 0xDB8) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xDBB), ZYDIS_DEFINITION(0xB, 0xDBC) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xDB9), ZYDIS_DEFINITION(0xB, 0xDBA) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xDBD), ZYDIS_DEFINITION(0xB, 0xDBE) },
    { ZYDIS_DEFINITION(0xB, 0xC75), ZYDIS_DEFINITION(0xB, 0xC76), ZYDIS_DEFINITION(0xB, 0xC77) },
    { ZYDIS_DEFINITION(0xB, 0xC7B), ZYDIS_DEFINITION(0xB, 0xC7C), ZYDIS_DEFINITION(0xB, 0xC7D) },
    { ZYDIS_DEFINITION(0xB, 0xC78), ZYDIS_DEFINITION(0xB, 0xC79), ZYDIS_DEFINITION(0xB, 0xC7A) },
    { ZYDIS_DEFINITION(0xB, 0xC7E), ZYDIS_DEFINITION(0xB, 0xC7F), ZYDIS_DEFINITION(0xB, 0xC80) },
    { ZYDIS_DEFINITION(0xB, 0x5A8), ZYDIS_DEFINITION(0xB, 0x5A9), ZYDIS_DEFINITION(0xB, 0x5AA) },
    { ZYDIS_DEFINITION(0xB, 0x59A), ZYDIS_DEFINITION(0xB, 0x59B), ZYDIS_DEFINITION(0xB, 0x59C) },
    { ZYDIS_DEFINITION(0xB, 0x5AB), ZYDIS_DEFINITION(0xB, 0x5AC), ZYDIS_DEFINITION(0xB, 0x5AD) },
    { ZYDIS_DEFINITION(0xB, 0x59D), ZYDIS_DEFINITION(0xB, 0x59E), ZYDIS_DEFINITION(0xB, 0x59F) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5D5), ZYDIS_DEFINITION(0xB, 0x5D6) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5DB), ZYDIS_DEFINITION(0xB, 0x5DC) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5D7), ZYDIS_DEFINITION(0xB, 0x5D8) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5DD), ZYDIS_DEFINITION(0xB, 0x5DE) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x31F), ZYDIS_DEFINITION(0xB, 0x320) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x325), ZYDIS_DEFINITION(0xB, 0x326) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x321), ZYDIS_DEFINITION(0xB, 0x322) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x327), ZYDIS_DEFINITION(0xB, 0x328) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5D9) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5DF) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5DA) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x5E0) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x323) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x329) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x324) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0x32A) },
    { ZYDIS_DEFINITION(0xB, 0x82E), ZYDIS_DEFINITION(0xB, 0x82F), ZYDIS_DEFINITION(0xB, 0x830) },
    { ZYDIS_DEFINITION(0xB, 0x840), ZYDIS_DEFINITION(0xB, 0x841), ZYDIS_DEFINITION(0xB, 0x842) },
    { ZYDIS_DEFINITION(0xB, 0x831), ZYDIS_DEFINITION(0xB, 0x832), ZYDIS_DEFINITION(0xB, 0x833) },
    { ZYDIS_DEFINITION(0xB, 0x843), ZYDIS_DEFINITION(0xB, 0x844), ZYDIS_DEFINITION(0xB, 0x845) },
    { ZYDIS_DEFINITION(0xB, 0x7EC), ZYDIS_DEFINITION(0xB, 0x7ED), ZYDIS_DEFINITION(0xB, 0x7EE) },
    { ZYDIS_DEFINITION(0xB, 0x846), ZYDIS_DEFINITION(0xB, 0x847), ZYDIS_DEFINITION(0xB, 0x848) },
    { ZYDIS_DEFINITION(0xB, 0x7EF), ZYDIS_DEFINITION(0xB, 0x7F0), ZYDIS_DEFINITION(0xB, 0x7F1) },
    { ZYDIS_DEFINITION(0xB, 0x849), ZYDIS_DEFINITION(0xB, 0x84A), ZYDIS_DEFINITION(0xB, 0x84B) },
    { ZYDIS_DEFINITION(0xB, 0x2D7), ZYDIS_DEFINITION(0xB, 0x2D8), ZYDIS_DEFINITION(0xB, 0x2D9) },
    { ZYDIS_DEFINITION(0xB, 0x2DA), ZYDIS_DEFINITION(0xB, 0x2DB), ZYDIS_DEFINITION(0xB, 0x2DC) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xDBF), ZYDIS_DEFINITION(0xB, 0xDC0) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xDC3), ZYDIS_DEFINITION(0xB, 0xDC4) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xDC1), ZYDIS_DEFINITION(0xB, 0xDC2) },
    { ZYDIS_INVALID, ZYDIS_DEFINITION(0xB, 0xDC5), ZYDIS_DEFINITION(0xB, 0xDC6) },
    { ZYDIS_DEFINITION(0xB, 0x7E6), ZYDIS_DEFINITION(0xB, 0x7E7), ZYDIS_DEFINITION(0xB, 0x7E8) },
    { ZYDIS_DEFINITION(0xB, 0x7E9), ZYDIS_DEFINITION(0xB, 0x7EA), ZYDIS_DEFINITION(0xB, 0x7EB) },
    { ZYDIS_DEFINITION(0xB, 0xCF5), ZYDIS_DEFINITION(0xB, 0xCF6), ZYDIS_DEFINITION(0xB, 0xCF7) },
    { ZYDIS_DEFINITION(0xB, 0xCEE), ZYDIS_DEFINITION(0xB, 0xCEF), ZYDIS_DEFINITION(0xB, 0xCF0) },
    { ZYDIS_DEFINITION(0xB, 0xCF8), ZYDIS_DEFINITION(0xB, 0xCF9), ZYDIS_DEFINITION(0xB, 0xCFA) },
    { ZYDIS_DEFINITION(0xB, 0xCF1), ZYDIS_DEFINITION(0xB, 0xCF2), ZYDIS_DEFINITION(0xB, 0xCF3) },
    { ZYDIS_DEFINITION(0xB, 0x349), ZYDIS_DEFINITION(0xB, 0x34A), ZYDIS_DEFINITION(0xB, 0x34B) },
    { ZYDIS_DEFINITION(0xB, 0x342), ZYDIS_DEFINITION(0xB, 0x343), ZYDIS_DEFINITION(0xB, 0x344) },
    { ZYDIS_DEFINITION(0xB, 0x34C), ZYDIS_DEFINITION(0xB, 0x34D), ZYDIS_DEFINITION(0xB, 0x34E) },
    { ZYDIS_DEFINITION(0xB, 0x345), ZYDIS_DEFINITION(0xB, 0x346), ZYDIS_DEFINITION(0xB, 0x347) },
    { ZYDIS_DEFINITION(0xB, 0xD34), ZYDIS_DEFINITION(0xB, 0xD35), ZYDIS_DEFINITION(0xB, 0xD36) },
    { ZYDIS_DEFINITION(0xB, 0xD26), ZYDIS_DEFINITION(0xB, 0xD27), ZYDIS_DEFINITION(0xB, 0xD28) },
    { ZYDIS_DEFINITION(0xB, 0xD37), ZYDIS_DEFINITION(0xB, 0xD38), ZYDIS_DEFINITION(0xB, 0xD39) },
    { ZYDIS_DEFINITION(0xB, 0xD29), ZYDIS_DEFINITION(0xB, 0xD2A), ZYDIS_DEFINITION(0xB, 0xD2B) },
    { ZYDIS_DEFINITION(0xB, 0x55B), ZYDIS_DEFINITION(0xB, 0x55C), ZYDIS_DEFINITION(0xB, 0x55D) },
    { ZYDIS_DEFINITION(0xB, 0x54F), ZYDIS_DEFINITION(0xB, 0x550), ZYDIS_DEFINITION(0xB, 0x551) },
    { ZYDIS_DEFINITION(0xB, 0x55E), ZYDIS_DEFINITION(0xB, 0x55F), ZYDIS_DEFINITION(0xB, 0x560) },
    { ZYDIS_DEFINITION(0xB, 0x552), ZYDIS_DEFINITION(0xB, 0x553), ZYDIS_DEFINITION(0xB, 0x554) },
    { ZYDIS_DEFINITION(0xB, 0xB4F), ZYDIS_DEFINITION(0xB, 0xB50), ZYDIS_DEFINITION(0xB, 0xB51) },
    { ZYDIS_DEFINITION(0xB, 0xB52), ZYDIS_DEFINITION(0xB, 0xB53), ZYDIS_DEFINITION(0xB, 0xB54) },
    { ZYDIS_DEFINITION(0xB, 0xB31), ZYDIS_DEFINITION(0xB, 0xB32), ZYDIS_DEFINITION(0xB, 0xB33) },
    { ZYDIS_DEFINITION(0xB, 0xB37), ZYDIS_DEFINITION(0xB, 0xB38), ZYDIS_DEFINITION(0xB, 0xB39) },
    { ZYDIS_DEFINITION(0xB, 0xB34), ZYDIS_DEFINITION(0xB, 0xB35), ZYDIS_DEFINITION(0xB, 0xB36) },
    { ZYDIS_DEFINITION(0xB, 0xB3A), ZYDIS_DEFINITION(0xB, 0xB3B), ZYDIS_DEFINITION(0xB, 0xB3C) },
    { ZYDIS_DEFINITION(0xB, 0xB73), ZYDIS_DEFINITION(0xB, 0xB74), ZYDIS_DEFINITION(0xB, 0xB75) },
    { ZYDIS_DEFINITION(0xB, 0xB76), ZYDIS_DEFINITION(0xB, 0xB77), ZYDIS_DEFINITION(0xB, 0xB78) },
    { ZYDIS_DEFINITION(0xB, 0xB55), ZYDIS_DEFINITION(0xB, 0xB56), ZYDIS_DEFINITION(0xB, 0xB57) },
    { ZYDIS_DEFINITION(0xB, 0xB5B), ZYDIS_DEFINITION(0xB, 0xB5C), ZYDIS_DEFINITION(0xB, 0xB5D) },
    { ZYDIS_DEFINITION(0xB, 0xB58), ZYDIS_DEFINITION(0xB, 0xB59), ZYDIS_DEFINITION(0xB, 0xB5A) },
    { ZYDIS_DEFINITION(0xB, 0xB5E), ZYDIS_DEFINITION(0xB, 0xB5F), ZYDIS_DEFINITION(0xB, 0xB60) },
    { ZYDIS_DEFINITION(0xB, 0x5BD), ZYDIS_DEFINITION(0xB, 0x5BE), ZYDIS_DEFINITION(0xB, 0x5BF) },
    { ZYDIS_DEFINITION(0xB, 0x5C0), ZYDIS_DEFINITION(0xB, 0x5C1), ZYDIS_DEFINITION(0xB, 0x5C2) },
    { ZYDIS_DEFINITION(0xB, 0x5B7), ZYDIS_DEFINITION(0xB, 0x5B8), ZYDIS_DEFINITION(0xB, 0x5B9) },
    { ZYDIS_DEFINITION(0xB, 0x5BA), ZYDIS_DEFINITION(0xB, 0x5BB), ZYDIS_DEFINITION(0xB, 0x5BC) },
    { ZYDIS_DEFINITION(0x1, 0x15D), ZYDIS_DEFINITION(0x1, 0x15E), ZYDIS_DEFINITION(0x1, 0x15F) },
    { ZYDIS_DEFINITION(0x1, 0x160), ZYDIS_DEFINITION(0x1, 0x161), ZYDIS_DEFINITION(0x1, 0x162) },
    { ZYDIS_DEFINITION(0x1, 0xE6), ZYDIS_DEFINITION(0x1, 0xE7), ZYDIS_DEFINITION(0x1, 0xE8) },
    { ZYDIS_DEFINITION(0x1, 0xE9), ZYDIS_DEFINITION(0x1, 0xEA), ZYDIS_DEFINITION(0x1, 0xEB) },
    { ZYDIS_DEFINITION(0x1, 0x109), ZYDIS_DEFINITION(0x1, 0x10A), ZYDIS_DEFINITION(0x1, 0x10B) },
    { ZYDIS_DEFINITION(0x1, 0x10C), ZYDIS_DEFINITION(0x1, 0x10D), ZYDIS_DEFINITION(0x1, 0x10E) },
    { ZYDIS_DEFINITION(0x1, 0x6DB), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6DC), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x220), ZYDIS_DEFINITION(0x1, 0x221), ZYDIS_DEFINITION(0x1, 0x222) },
    { ZYDIS_DEFINITION(0x1, 0x223), ZYDIS_DEFINITION(0x1, 0x224), ZYDIS_DEFINITION(0x1, 0x225) },
    { ZYDIS_DEFINITION(0x1, 0x133), ZYDIS_DEFINITION(0x1, 0x134), ZYDIS_DEFINITION(0x1, 0x135) },
    { ZYDIS_DEFINITION(0x1, 0x136), ZYDIS_DEFINITION(0x1, 0x137), ZYDIS_DEFINITION(0x1, 0x138) },
    { ZYDIS_DEFINITION(0x1, 0x212), ZYDIS_DEFINITION(0x1, 0x213), ZYDIS_DEFINITION(0x1, 0x214) },
    { ZYDIS_DEFINITION(0x1, 0x215), ZYDIS_DEFINITION(0x1, 0x216), ZYDIS_DEFINITION(0x1, 0x217) },
    { ZYDIS_DEFINITION(0x1, 0x125), ZYDIS_DEFINITION(0x1, 0x126), ZYDIS_DEFINITION(0x1, 0x127) },
    { ZYDIS_DEFINITION(0x1, 0x128), ZYDIS_DEFINITION(0x1, 0x129), ZYDIS_DEFINITION(0x1, 0x12A) },
    { ZYDIS_DEFINITION(0x1, 0x22E), ZYDIS_DEFINITION(0x1, 0x22F), ZYDIS_DEFINITION(0x1, 0x230) },
    { ZYDIS_DEFINITION(0x1, 0x231), ZYDIS_DEFINITION(0x1, 0x232), ZYDIS_DEFINITION(0x1, 0x233) },
    { ZYDIS_DEFINITION(0x1, 0x141), ZYDIS_DEFINITION(0x1, 0x142), ZYDIS_DEFINITION(0x1, 0x143) },
    { ZYDIS_DEFINITION(0x1, 0x144), ZYDIS_DEFINITION(0x1, 0x145), ZYDIS_DEFINITION(0x1, 0x146) },
    { ZYDIS_DEFINITION(0x1, 0x6DD), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6DE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x11E), ZYDIS_DEFINITION(0x1, 0x11F), ZYDIS_DEFINITION(0x1, 0x120) },
    { ZYDIS_DEFINITION(0x1, 0x121), ZYDIS_DEFINITION(0x1, 0x122), ZYDIS_DEFINITION(0x1, 0x123) },
    { ZYDIS_DEFINITION(0x1, 0xD8D), ZYDIS_DEFINITION(0x1, 0xD8E), ZYDIS_DEFINITION(0x1, 0xD8F) },
    { ZYDIS_DEFINITION(0x1, 0xD90), ZYDIS_DEFINITION(0x1, 0xD91), ZYDIS_DEFINITION(0x1, 0xD92) },
    { ZYDIS_DEFINITION(0x1, 0x583), ZYDIS_DEFINITION(0x1, 0x584), ZYDIS_DEFINITION(0x1, 0x585) },
    { ZYDIS_DEFINITION(0x1, 0x586), ZYDIS_DEFINITION(0x1, 0x587), ZYDIS_DEFINITION(0x1, 0x588) },
    { ZYDIS_DEFINITION(0x1, 0xD1D), ZYDIS_DEFINITION(0x1, 0xD1E), ZYDIS_DEFINITION(0x1, 0xD1F) },
    { ZYDIS_DEFINITION(0x1, 0xD20), ZYDIS_DEFINITION(0x1, 0xD21), ZYDIS_DEFINITION(0x1, 0xD22) },
    { ZYDIS_DEFINITION(0x1, 0xD7D), ZYDIS_DEFINITION(0x1, 0xD7E), ZYDIS_DEFINITION(0x1, 0xD7F) },
    { ZYDIS_DEFINITION(0x1, 0xD80), ZYDIS_DEFINITION(0x1, 0xD81), ZYDIS_DEFINITION(0x1, 0xD82) },
    { ZYDIS_DEFINITION(0x1, 0x3C1), ZYDIS_DEFINITION(0x1, 0x3C2), ZYDIS_DEFINITION(0x1, 0x3C3) },
    { ZYDIS_DEFINITION(0x1, 0x3C4), ZYDIS_DEFINITION(0x1, 0x3C5), ZYDIS_DEFINITION(0x1, 0x3C6) },
    { ZYDIS_DEFINITION(0x1, 0x45A), ZYDIS_DEFINITION(0x1, 0x45B), ZYDIS_DEFINITION(0x1, 0x45C) },
    { ZYDIS_DEFINITION(0x1, 0x45D), ZYDIS_DEFINITION(0x1, 0x45E), ZYDIS_DEFINITION(0x1, 0x45F) },
    { ZYDIS_DEFINITION(0x1, 0x35D), ZYDIS_DEFINITION(0x1, 0x35E), ZYDIS_DEFINITION(0x1, 0x35F) },
    { ZYDIS_DEFINITION(0x1, 0x360), ZYDIS_DEFINITION(0x1, 0x361), ZYDIS_DEFINITION(0x1, 0x362) },
    { ZYDIS_DEFINITION(0x1, 0x400), ZYDIS_DEFINITION(0x1, 0x401), ZYDIS_DEFINITION(0x1, 0x402) },
    { ZYDIS_DEFINITION(0x1, 0x403), ZYDIS_DEFINITION(0x1, 0x404), ZYDIS_DEFINITION(0x1, 0x405) },
    { ZYDIS_DEFINITION(0x1, 0x4A3), ZYDIS_DEFINITION(0x1, 0x4A4), ZYDIS_DEFINITION(0x1, 0x4A5) },
    { ZYDIS_DEFINITION(0x1, 0x4A6), ZYDIS_DEFINITION(0x1, 0x4A7), ZYDIS_DEFINITION(0x1, 0x4A8) },
    { ZYDIS_DEFINITION(0x1, 0x4FD), ZYDIS_DEFINITION(0x1, 0x4FE), ZYDIS_DEFINITION(0x1, 0x4FF) },
    { ZYDIS_DEFINITION(0x1, 0x500), ZYDIS_DEFINITION(0x1, 0x501), ZYDIS_DEFINITION(0x1, 0x502) },
    { ZYDIS_DEFINITION(0x1, 0x3D6), ZYDIS_DEFINITION(0x1, 0x3D7), ZYDIS_DEFINITION(0x1, 0x3D8) },
    { ZYDIS_DEFINITION(0x1, 0x3D9), ZYDIS_DEFINITION(0x1, 0x3DA), ZYDIS_DEFINITION(0x1, 0x3DB) },
    { ZYDIS_DEFINITION(0x1, 0x46F), ZYDIS_DEFINITION(0x1, 0x470), ZYDIS_DEFINITION(0x1, 0x471) },
    { ZYDIS_DEFINITION(0x1, 0x472), ZYDIS_DEFINITION(0x1, 0x473), ZYDIS_DEFINITION(0x1, 0x474) },
    { ZYDIS_DEFINITION(0x1, 0x37B), ZYDIS_DEFINITION(0x1, 0x37C), ZYDIS_DEFINITION(0x1, 0x37D) },
    { ZYDIS_DEFINITION(0x1, 0x37E), ZYDIS_DEFINITION(0x1, 0x37F), ZYDIS_DEFINITION(0x1, 0x380) },
    { ZYDIS_DEFINITION(0x1, 0x41E), ZYDIS_DEFINITION(0x1, 0x41F), ZYDIS_DEFINITION(0x1, 0x420) },
    { ZYDIS_DEFINITION(0x1, 0x421), ZYDIS_DEFINITION(0x1, 0x422), ZYDIS_DEFINITION(0x1, 0x423) },
    { ZYDIS_DEFINITION(0x1, 0x4C1), ZYDIS_DEFINITION(0x1, 0x4C2), ZYDIS_DEFINITION(0x1, 0x4C3) },
    { ZYDIS_DEFINITION(0x1, 0x4C4), ZYDIS_DEFINITION(0x1, 0x4C5), ZYDIS_DEFINITION(0x1, 0x4C6) },
    { ZYDIS_DEFINITION(0x1, 0x51B), ZYDIS_DEFINITION(0x1, 0x51C), ZYDIS_DEFINITION(0x1, 0x51D) },
    { ZYDIS_DEFINITION(0x1, 0x51E), ZYDIS_DEFINITION(0x1, 0x51F), ZYDIS_DEFINITION(0x1, 0x520) },
    { ZYDIS_DEFINITION(0x1, 0x3EB), ZYDIS_DEFINITION(0x1, 0x3EC), ZYDIS_DEFINITION(0x1, 0x3ED) },
    { ZYDIS_DEFINITION(0x1, 0x3EE), ZYDIS_DEFINITION(0x1, 0x3EF), ZYDIS_DEFINITION(0x1, 0x3F0) },
    { ZYDIS_DEFINITION(0x1, 0x484), ZYDIS_DEFINITION(0x1, 0x485), ZYDIS_DEFINITION(0x1, 0x486) },
    { ZYDIS_DEFINITION(0x1, 0x487), ZYDIS_DEFINITION(0x1, 0x488), ZYDIS_DEFINITION(0x1, 0x489) },
    { ZYDIS_DEFINITION(0x1, 0x399), ZYDIS_DEFINITION(0x1, 0x39A), ZYDIS_DEFINITION(0x1, 0x39B) },
    { ZYDIS_DEFINITION(0x1, 0x39C), ZYDIS_DEFINITION(0x1, 0x39D), ZYDIS_DEFINITION(0x1, 0x39E) },
    { ZYDIS_DEFINITION(0x1, 0x43C), ZYDIS_DEFINITION(0x1, 0x43D), ZYDIS_DEFINITION(0x1, 0x43E) },
    { ZYDIS_DEFINITION(0x1, 0x43F), ZYDIS_DEFINITION(0x1, 0x440), ZYDIS_DEFINITION(0x1, 0x441) },
    { ZYDIS_DEFINITION(0x1, 0x4DF), ZYDIS_DEFINITION(0x1, 0x4E0), ZYDIS_DEFINITION(0x1, 0x4E1) },
    { ZYDIS_DEFINITION(0x1, 0x4E2), ZYDIS_DEFINITION(0x1, 0x4E3), ZYDIS_DEFINITION(0x1, 0x4E4) },
    { ZYDIS_DEFINITION(0x1, 0x539), ZYDIS_DEFINITION(0x1, 0x53A), ZYDIS_DEFINITION(0x1, 0x53B) },
    { ZYDIS_DEFINITION(0x1, 0x53C), ZYDIS_DEFINITION(0x1, 0x53D), ZYDIS_DEFINITION(0x1, 0x53E) },
    { ZYDIS_DEFINITION(0x1, 0x6B9), ZYDIS_DEFINITION(0x1, 0x6BA), ZYDIS_DEFINITION(0x1, 0x6BB) },
    { ZYDIS_DEFINITION(0x1, 0x6BC), ZYDIS_DEFINITION(0x1, 0x6BD), ZYDIS_DEFINITION(0x1, 0x6BE) },
    { ZYDIS_DEFINITION(0x1, 0x6B3), ZYDIS_DEFINITION(0x1, 0x6B4), ZYDIS_DEFINITION(0x1, 0x6B5) },
    { ZYDIS_DEFINITION(0x1, 0x6B6), ZYDIS_DEFINITION(0x1, 0x6B7), ZYDIS_DEFINITION(0x1, 0x6B8) },
    { ZYDIS_DEFINITION(0x1, 0x235), ZYDIS_DEFINITION(0x1, 0x236), ZYDIS_DEFINITION(0x1, 0x237) },
    { ZYDIS_DEFINITION(0x1, 0x238), ZYDIS_DEFINITION(0x1, 0x239), ZYDIS_DEFINITION(0x1, 0x23A) },
    { ZYDIS_DEFINITION(0x1, 0x669), ZYDIS_DEFINITION(0x1, 0x66A), ZYDIS_DEFINITION(0x1, 0x66B) },
    { ZYDIS_DEFINITION(0x1, 0x675), ZYDIS_DEFINITION(0x1, 0x676), ZYDIS_DEFINITION(0x1, 0x677) },
    { ZYDIS_DEFINITION(0x1, 0x66C), ZYDIS_DEFINITION(0x1, 0x66D), ZYDIS_DEFINITION(0x1, 0x66E) },
    { ZYDIS_DEFINITION(0x1, 0x678), ZYDIS_DEFINITION(0x1, 0x679), ZYDIS_DEFINITION(0x1, 0x67A) },
    { ZYDIS_DEFINITION(0xB, 0xB8B), ZYDIS_DEFINITION(0xB, 0xB8C), ZYDIS_DEFINITION(0xB, 0xB8D) },
    { ZYDIS_DEFINITION(0xB, 0xB8E), ZYDIS_DEFINITION(0xB, 0xB8F), ZYDIS_DEFINITION(0xB, 0xB90) },
    { ZYDIS_DEFINITION(0x1, 0x287), ZYDIS_DEFINITION(0x1, 0x288), ZYDIS_DEFINITION(0x1, 0x289) },
    { ZYDIS_DEFINITION(0x1, 0x29C), ZYDIS_DEFINITION(0x1, 0x29D), ZYDIS_DEFINITION(0x1, 0x29E) },
    { ZYDIS_DEFINITION(0x1, 0x28A), ZYDIS_DEFINITION(0x1, 0x28B), ZYDIS_DEFINITION(0x1, 0x28C) },
    { ZYDIS_DEFINITION(0x1, 0x29F), ZYDIS_DEFINITION(0x1, 0x2A0), ZYDIS_DEFINITION(0x1, 0x2A1) },
    { ZYDIS_DEFINITION(0x1, 0x6A7), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x6A8), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x66F), ZYDIS_DEFINITION(0x1, 0x670), ZYDIS_DEFINITION(0x1, 0x671) },
    { ZYDIS_DEFINITION(0x1, 0x67B), ZYDIS_DEFINITION(0x1, 0x67C), ZYDIS_DEFINITION(0x1, 0x67D) },
    { ZYDIS_DEFINITION(0x1, 0x672), ZYDIS_DEFINITION(0x1, 0x673), ZYDIS_DEFINITION(0x1, 0x674) },
    { ZYDIS_DEFINITION(0x1, 0x67E), ZYDIS_DEFINITION(0x1, 0x67F), ZYDIS_DEFINITION(0x1, 0x680) },
    { ZYDIS_DEFINITION(0x1, 0xBE), ZYDIS_DEFINITION(0x1, 0xBF), ZYDIS_DEFINITION(0x1, 0xC0) },
    { ZYDIS_DEFINITION(0x1, 0x179), ZYDIS_DEFINITION(0x1, 0x17A), ZYDIS_DEFINITION(0x1, 0x17B) },
    { ZYDIS_DEFINITION(0x1, 0xC1), ZYDIS_DEFINITION(0x1, 0xC2), ZYDIS_DEFINITION(0x1, 0xC3) },
    { ZYDIS_DEFINITION(0x1, 0x17C), ZYDIS_DEFINITION(0x1, 0x17D), ZYDIS_DEFINITION(0x1, 0x17E) },
    { ZYDIS_DEFINITION(0x1, 0xA62), ZYDIS_DEFINITION(0x1, 0xA63), ZYDIS_DEFINITION(0x1, 0xA64) },
    { ZYDIS_DEFINITION(0x1, 0xA65), ZYDIS_DEFINITION(0x1, 0xA66), ZYDIS_DEFINITION(0x1, 0xA67) },
    { ZYDIS_DEFINITION(0x1, 0xA44), ZYDIS_DEFINITION(0x1, 0xA45), ZYDIS_DEFINITION(0x1, 0xA46) },
    { ZYDIS_DEFINITION(0x1, 0xA47), ZYDIS_DEFINITION(0x1, 0xA48), ZYDIS_DEFINITION(0x1, 0xA49) },
    { ZYDIS_DEFINITION(0x1, 0xA50), ZYDIS_DEFINITION(0x1, 0xA51), ZYDIS_DEFINITION(0x1, 0xA52) },
    { ZYDIS_DEFINITION(0x1, 0xA53), ZYDIS_DEFINITION(0x1, 0xA54), ZYDIS_DEFINITION(0x1, 0xA55) },
    { ZYDIS_DEFINITION(0x1, 0xA4A), ZYDIS_DEFINITION(0x1, 0xA4B), ZYDIS_DEFINITION(0x1, 0xA4C) },
    { ZYDIS_DEFINITION(0x1, 0xA4D), ZYDIS_DEFINITION(0x1, 0xA4E), ZYDIS_DEFINITION(0x1, 0xA4F) },
    { ZYDIS_DEFINITION(0x1, 0xA5C), ZYDIS_DEFINITION(0x1, 0xA5D), ZYDIS_DEFINITION(0x1, 0xA5E) },
    { ZYDIS_DEFINITION(0x1, 0xA5F), ZYDIS_DEFINITION(0x1, 0xA60), ZYDIS_DEFINITION(0x1, 0xA61) },
    { ZYDIS_DEFINITION(0x1, 0xA56), ZYDIS_DEFINITION(0x1, 0xA57), ZYDIS_DEFINITION(0x1, 0xA58) },
    { ZYDIS_DEFINITION(0x1, 0xA59), ZYDIS_DEFINITION(0x1, 0xA5A), ZYDIS_DEFINITION(0x1, 0xA5B) },
    { ZYDIS_DEFINITION(0x1, 0xA1A), ZYDIS_DEFINITION(0x1, 0xA1B), ZYDIS_DEFINITION(0x1, 0xA1C) },
    { ZYDIS_DEFINITION(0x1, 0xA1D), ZYDIS_DEFINITION(0x1, 0xA1E), ZYDIS_DEFINITION(0x1, 0xA1F) },
    { ZYDIS_DEFINITION(0x1, 0x9FC), ZYDIS_DEFINITION(0x1, 0x9FD), ZYDIS_DEFINITION(0x1, 0x9FE) },
    { ZYDIS_DEFINITION(0x1, 0x9FF), ZYDIS_DEFINITION(0x1, 0xA00), ZYDIS_DEFINITION(0x1, 0xA01) },
    { ZYDIS_DEFINITION(0x1, 0xA08), ZYDIS_DEFINITION(0x1, 0xA09), ZYDIS_DEFINITION(0x1, 0xA0A) },
    { ZYDIS_DEFINITION(0x1, 0xA0B), ZYDIS_DEFINITION(0x1, 0xA0C), ZYDIS_DEFINITION(0x1, 0xA0D) },
    { ZYDIS_DEFINITION(0x1, 0xA02), ZYDIS_DEFINITION(0x1, 0xA03), ZYDIS_DEFINITION(0x1, 0xA04) },
    { ZYDIS_DEFINITION(0x1, 0xA05), ZYDIS_DEFINITION(0x1, 0xA06), ZYDIS_DEFINITION(0x1, 0xA07) },
    { ZYDIS_DEFINITION(0x1, 0xA14), ZYDIS_DEFINITION(0x1, 0xA15), ZYDIS_DEFINITION(0x1, 0xA16) },
    { ZYDIS_DEFINITION(0x1, 0xA17), ZYDIS_DEFINITION(0x1, 0xA18), ZYDIS_DEFINITION(0x1, 0xA19) },
    { ZYDIS_DEFINITION(0x1, 0xA0E), ZYDIS_DEFINITION(0x1, 0xA0F), ZYDIS_DEFINITION(0x1, 0xA10) },
    { ZYDIS_DEFINITION(0x1, 0xA11), ZYDIS_DEFINITION(0x1, 0xA12), ZYDIS_DEFINITION(0x1, 0xA13) },
    { ZYDIS_DEFINITION(0x1, 0xC99), ZYDIS_DEFINITION(0x1, 0xC9A), ZYDIS_DEFINITION(0x1, 0xC9B) },
    { ZYDIS_DEFINITION(0x1, 0xCAB), ZYDIS_DEFINITION(0x1, 0xCAC), ZYDIS_DEFINITION(0x1, 0xCAD) },
    { ZYDIS_DEFINITION(0x1, 0xC9C), ZYDIS_DEFINITION(0x1, 0xC9D), ZYDIS_DEFINITION(0x1, 0xC9E) },
    { ZYDIS_DEFINITION(0x1, 0xCAE), ZYDIS_DEFINITION(0x1, 0xCAF), ZYDIS_DEFINITION(0x1, 0xCB0) },
    { ZYDIS_DEFINITION(0x1, 0xC9F), ZYDIS_DEFINITION(0x1, 0xCA0), ZYDIS_DEFINITION(0x1, 0xCA1) },
    { ZYDIS_DEFINITION(0x1, 0xCA5), ZYDIS_DEFINITION(0x1, 0xCA6), ZYDIS_DEFINITION(0x1, 0xCA7) },
    { ZYDIS_DEFINITION(0x1, 0xCA2), ZYDIS_DEFINITION(0x1, 0xCA3), ZYDIS_DEFINITION(0x1, 0xCA4) },
    { ZYDIS_DEFINITION(0x1, 0xCA8), ZYDIS_DEFINITION(0x1, 0xCA9), ZYDIS_DEFINITION(0x1, 0xCAA) },
    { ZYDIS_DEFINITION(0x1, 0x9DB), ZYDIS_DEFINITION(0x1, 0x9DC), ZYDIS_DEFINITION(0x1, 0x9DD) },
    { ZYDIS_DEFINITION(0x1, 0x9E4), ZYDIS_DEFINITION(0x1, 0x9E5), ZYDIS_DEFINITION(0x1, 0x9E6) },
    { ZYDIS_DEFINITION(0x1, 0x9C9), ZYDIS_DEFINITION(0x1, 0x9CA), ZYDIS_DEFINITION(0x1, 0x9CB) },
    { ZYDIS_DEFINITION(0x1, 0xA68), ZYDIS_DEFINITION(0x1, 0xA69), ZYDIS_DEFINITION(0x1, 0xA6A) },
    { ZYDIS_DEFINITION(0x1, 0x7CE), ZYDIS_DEFINITION(0x1, 0x7CF), ZYDIS_DEFINITION(0x1, 0x7D0) },
    { ZYDIS_DEFINITION(0x1, 0xA6B), ZYDIS_DEFINITION(0x1, 0xA6C), ZYDIS_DEFINITION(0x1, 0xA6D) },
    { ZYDIS_DEFINITION(0x1, 0xA6E), ZYDIS_DEFINITION(0x1, 0xA6F), ZYDIS_DEFINITION(0x1, 0xA70) },
    { ZYDIS_DEFINITION(0x1, 0x9CF), ZYDIS_DEFINITION(0x1, 0x9D0), ZYDIS_DEFINITION(0x1, 0x9D1) },
    { ZYDIS_DEFINITION(0x1, 0x9D2), ZYDIS_DEFINITION(0x1, 0x9D3), ZYDIS_DEFINITION(0x1, 0x9D4) },
    { ZYDIS_DEFINITION(0x1, 0x9EA), ZYDIS_DEFINITION(0x1, 0x9EB), ZYDIS_DEFINITION(0x1, 0x9EC) },
    { ZYDIS_DEFINITION(0x1, 0x9ED), ZYDIS_DEFINITION(0x1, 0x9EE), ZYDIS_DEFINITION(0x1, 0x9EF) },
    { ZYDIS_DEFINITION(0x1, 0x9D5), ZYDIS_DEFINITION(0x1, 0x9D6), ZYDIS_DEFINITION(0x1, 0x9D7) },
    { ZYDIS_DEFINITION(0x1, 0x9D8), ZYDIS_DEFINITION(0x1, 0x9D9), ZYDIS_DEFINITION(0x1, 0x9DA) },
    { ZYDIS_DEFINITION(0x1, 0x9F6), ZYDIS_DEFINITION(0x1, 0x9F7), ZYDIS_DEFINITION(0x1, 0x9F8) },
    { ZYDIS_DEFINITION(0x1, 0x9F9), ZYDIS_DEFINITION(0x1, 0x9FA), ZYDIS_DEFINITION(0x1, 0x9FB) },
    { ZYDIS_DEFINITION(0x1, 0x9F0), ZYDIS_DEFINITION(0x1, 0x9F1), ZYDIS_DEFINITION(0x1, 0x9F2) },
    { ZYDIS_DEFINITION(0x1, 0x9F3), ZYDIS_DEFINITION(0x1, 0x9F4), ZYDIS_DEFINITION(0x1, 0x9F5) },
    { ZYDIS_DEFINITION(0x1, 0x9DE), ZYDIS_DEFINITION(0x1, 0x9DF), ZYDIS_DEFINITION(0x1, 0x9E0) },
    { ZYDIS_DEFINITION(0x1, 0x9E1), ZYDIS_DEFINITION(0x1, 0x9E2), ZYDIS_DEFINITION(0x1, 0x9E3) },
    { ZYDIS_DEFINITION(0x1, 0x9CC), ZYDIS_DEFINITION(0x1, 0x9CD), ZYDIS_DEFINITION(0x1, 0x9CE) },
    { ZYDIS_DEFINITION(0x1, 0x9E7), ZYDIS_DEFINITION(0x1, 0x9E8), ZYDIS_DEFINITION(0x1, 0x9E9) },
    { ZYDIS_DEFINITION(0x1, 0x7D1), ZYDIS_DEFINITION(0x1, 0x7D2), ZYDIS_DEFINITION(0x1, 0x7D3) },
    { ZYDIS_DEFINITION(0x1, 0x2FB), ZYDIS_DEFINITION(0x1, 0x2FC), ZYDIS_DEFINITION(0x1, 0x2FD) },
    { ZYDIS_DEFINITION(0x1, 0x2FE), ZYDIS_DEFINITION(0x1, 0x2FF), ZYDIS_DEFINITION(0x1, 0x300) },
    { ZYDIS_DEFINITION(0x1, 0xD8), ZYDIS_DEFINITION(0x1, 0xD9), ZYDIS_DEFINITION(0x1, 0xDA) },
    { ZYDIS_DEFINITION(0x1, 0xDB), ZYDIS_DEFINITION(0x1, 0xDC), ZYDIS_DEFINITION(0x1, 0xDD) },
    { ZYDIS_DEFINITION(0x1, 0x20B), ZYDIS_DEFINITION(0x1, 0x20C), ZYDIS_DEFINITION(0x1, 0x20D) },
    { ZYDIS_DEFINITION(0x1, 0x20E), ZYDIS_DEFINITION(0x1, 0x20F), ZYDIS_DEFINITION(0x1, 0x210) },
    { ZYDIS_DEFINITION(0x1, 0x2D1), ZYDIS_DEFINITION(0x1, 0x2D2), ZYDIS_DEFINITION(0x1, 0x2D3) },
    { ZYDIS_DEFINITION(0x1, 0x2D4), ZYDIS_DEFINITION(0x1, 0x2D5), ZYDIS_DEFINITION(0x1, 0x2D6) },
    { ZYDIS_DEFINITION(0x1, 0x3B0), ZYDIS_DEFINITION(0x1, 0x3B1), ZYDIS_DEFINITION(0x1, 0x3B2) },
    { ZYDIS_DEFINITION(0x1, 0x3B3), ZYDIS_DEFINITION(0x1, 0x3B4), ZYDIS_DEFINITION(0x1, 0x3B5) },
    { ZYDIS_DEFINITION(0x1, 0x492), ZYDIS_DEFINITION(0x1, 0x493), ZYDIS_DEFINITION(0x1, 0x494) },
    { ZYDIS_DEFINITION(0x1, 0x495), ZYDIS_DEFINITION(0x1, 0x496), ZYDIS_DEFINITION(0x1, 0x497) },
    { ZYDIS_DEFINITION(0x1, 0x63F), ZYDIS_DEFINITION(0x1, 0x640), ZYDIS_DEFINITION(0x1, 0x641) },
    { ZYDIS_DEFINITION(0x1, 0x642), ZYDIS_DEFINITION(0x1, 0x643), ZYDIS_DEFINITION(0x1, 0x644) },
    { ZYDIS_DEFINITION(0x1, 0x681), ZYDIS_DEFINITION(0x1, 0x682), ZYDIS_DEFINITION(0x1, 0x683) },
    { ZYDIS_DEFINITION(0x1, 0x65D), ZYDIS_DEFINITION(0x1, 0x65E), ZYDIS_DEFINITION(0x1, 0x65F) },
    { ZYDIS_DEFINITION(0x1, 0x684), ZYDIS_DEFINITION(0x1, 0x685), ZYDIS_DEFINITION(0x1, 0x686) },
    { ZYDIS_DEFINITION(0x1, 0x660), ZYDIS_DEFINITION(0x1, 0x661), ZYDIS_DEFINITION(0x1, 0x662) },
    { ZYDIS_DEFINITION(0xB, 0xB91), ZYDIS_DEFINITION(0xB, 0xB92), ZYDIS_DEFINITION(0xB, 0xB93) },
    { ZYDIS_DEFINITION(0xB, 0xB94), ZYDIS_DEFINITION(0xB, 0xB95), ZYDIS_DEFINITION(0xB, 0xB96) },
    { ZYDIS_DEFINITION(0x1, 0x295), ZYDIS_DEFINITION(0x1, 0x296), ZYDIS_DEFINITION(0x1, 0x297) },
    { ZYDIS_DEFINITION(0x1, 0x2AA), ZYDIS_DEFINITION(0x1, 0x2AB), ZYDIS_DEFINITION(0x1, 0x2AC) },
    { ZYDIS_DEFINITION(0x1, 0x298), ZYDIS_DEFINITION(0x1, 0x299), ZYDIS_DEFINITION(0x1, 0x29A) },
    { ZYDIS_DEFINITION(0x1, 0x2AD), ZYDIS_DEFINITION(0x1, 0x2AE), ZYDIS_DEFINITION(0x1, 0x2AF) },
    { ZYDIS_DEFINITION(0x1, 0x687), ZYDIS_DEFINITION(0x1, 0x688), ZYDIS_DEFINITION(0x1, 0x689) },
    { ZYDIS_DEFINITION(0x1, 0x663), ZYDIS_DEFINITION(0x1, 0x664), ZYDIS_DEFINITION(0x1, 0x665) },
    { ZYDIS_DEFINITION(0x1, 0x68A), ZYDIS_DEFINITION(0x1, 0x68B), ZYDIS_DEFINITION(0x1, 0x68C) },
    { ZYDIS_DEFINITION(0x1, 0x666), ZYDIS_DEFINITION(0x1, 0x667), ZYDIS_DEFINITION(0x1, 0x668) },
    { ZYDIS_DEFINITION(0x1, 0xDF), ZYDIS_DEFINITION(0x1, 0xE0), ZYDIS_DEFINITION(0x1, 0xE1) },
    { ZYDIS_DEFINITION(0x1, 0xE2), ZYDIS_DEFINITION(0x1, 0xE3), ZYDIS_DEFINITION(0x1, 0xE4) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x715) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x716) },
    { ZYDIS_DEFINITION(0x1, 0x709), ZYDIS_DEFINITION(0x1, 0x70A), ZYDIS_DEFINITION(0x1, 0x70B) },
    { ZYDIS_DEFINITION(0x1, 0x70F), ZYDIS_DEFINITION(0x1, 0x710), ZYDIS_DEFINITION(0x1, 0x711) },
    { ZYDIS_DEFINITION(0x1, 0x70C), ZYDIS_DEFINITION(0x1, 0x70D), ZYDIS_DEFINITION(0x1, 0x70E) },
    { ZYDIS_DEFINITION(0x1, 0x712), ZYDIS_DEFINITION(0x1, 0x713), ZYDIS_DEFINITION(0x1, 0x714) },
    { ZYDIS_DEFINITION(0x1, 0xD2), ZYDIS_DEFINITION(0x1, 0xD3), ZYDIS_DEFINITION(0x1, 0xD4) },
    { ZYDIS_DEFINITION(0x1, 0xD5), ZYDIS_DEFINITION(0x1, 0xD6), ZYDIS_DEFINITION(0x1, 0xD7) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x0) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x2) },
    { ZYDIS_DEFINITION(0x1, 0x28E), ZYDIS_DEFINITION(0x1, 0x28F), ZYDIS_DEFINITION(0x1, 0x290) },
    { ZYDIS_DEFINITION(0x1, 0x2A3), ZYDIS_DEFINITION(0x1, 0x2A4), ZYDIS_DEFINITION(0x1, 0x2A5) },
    { ZYDIS_DEFINITION(0x1, 0x291), ZYDIS_DEFINITION(0x1, 0x292), ZYDIS_DEFINITION(0x1, 0x293) },
    { ZYDIS_DEFINITION(0x1, 0x2A6), ZYDIS_DEFINITION(0x1, 0x2A7), ZYDIS_DEFINITION(0x1, 0x2A8) },
    { ZYDIS_DEFINITION(0x1, 0x2CA), ZYDIS_DEFINITION(0x1, 0x2CB), ZYDIS_DEFINITION(0x1, 0x2CC) },
    { ZYDIS_DEFINITION(0x1, 0x2CD), ZYDIS_DEFINITION(0x1, 0x2CE), ZYDIS_DEFINITION(0x1, 0x2CF) },
    { ZYDIS_DEFINITION(0x1, 0x32E), ZYDIS_DEFINITION(0x1, 0x32F), ZYDIS_DEFINITION(0x1, 0x330) },
    { ZYDIS_DEFINITION(0x1, 0x331), ZYDIS_DEFINITION(0x1, 0x332), ZYDIS_DEFINITION(0x1, 0x333) },
    { ZYDIS_DEFINITION(0x1, 0x338), ZYDIS_DEFINITION(0x1, 0x339), ZYDIS_DEFINITION(0x1, 0x33A) },
    { ZYDIS_DEFINITION(0x1, 0x33B), ZYDIS_DEFINITION(0x1, 0x33C), ZYDIS_DEFINITION(0x1, 0x33D) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x143) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x13C) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x13D) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x13E) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x142) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x13F) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x140) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x141) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x1) },
    { ZYDIS_INVALID, ZYDIS_INVALID, ZYDIS_DEFINITION(0x1, 0x0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3EE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3EF), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F0), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F3), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F4), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F7), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3F9), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3FA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3FB), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3FC), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3FD), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3FE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x3FF), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x400), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x401), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x402), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x403), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x404), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x405), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x406), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x407), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x408), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x409), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x40A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x40B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x40C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x40D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x40E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x40F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x410), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x411), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x412), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x413), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x414), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x415), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x416), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x417), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x418), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x419), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x41A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x41B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x41C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x41D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x41E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x41F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x420), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x421), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x422), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x423), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x424), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x425), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x426), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x427), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x428), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x429), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x42A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x42B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x42C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x42D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x42E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x42F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x430), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x431), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x432), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x433), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x434), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x435), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x436), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x437), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x43B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x43C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x43D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x43E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x43F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x440), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x441), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x442), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x443), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x444), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x445), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x446), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD3), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD4), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD7), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD8), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xD9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x44F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x450), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x451), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x452), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x453), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x454), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xDA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x458), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xDB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xDC), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xDD), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xDE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x45F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xDF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x461), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xE0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x463), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xE1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xE2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x466), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x467), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x468), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x469), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x46A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x46B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x46C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x46D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x46E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x46F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x470), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x471), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x472), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x473), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x474), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x475), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x476), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x477), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x478), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x479), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x47A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x47B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x47C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x47D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x47E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x47F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x480), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x481), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x482), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x483), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x484), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x485), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x486), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x487), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x0, 0x642), ZYDIS_DEFINITION(0x0, 0x641), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xE5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x48A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xE6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xE7), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xE8), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xE9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xEA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x493), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x494), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x495), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x496), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x497), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x498), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x499), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xEB), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xEC), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xED), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xEE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xEF), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xF0), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xF1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xF2), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xF3), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xF4), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4A7), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xF5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4AA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4AC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4AE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4AF), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B0), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4BA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4BC), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4BF), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C1), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C2), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C3), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C4), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C5), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4C9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4CA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4CB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4CC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4CD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4CE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4CF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4D9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4DA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4DC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4DD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4DE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4EA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4EC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4EE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4F9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4FA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4FB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4FC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4FD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x4FE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xF6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x501), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x502), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x503), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x504), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x505), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x506), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x507), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x508), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x509), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x50A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x50B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x50C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x50D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x50E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x50F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x510), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x511), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x512), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x513), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x514), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x515), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x516), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x517), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x518), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x519), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x51A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x51B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x51C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x51D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x51E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x51F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x520), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x521), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x522), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xF7), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x525), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x526), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x527), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x528), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x529), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x52A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x52B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x52C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x52D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x52E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x52F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x530), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x531), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x532), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x533), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x534), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x535), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x536), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x537), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x538), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x539), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x53A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x53B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x53C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x53D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x53E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x53F), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x540), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x541), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x542), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x543), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x544), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x545), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x546), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x547), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x548), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x549), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x54A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x54B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x54C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x54D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x54E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x54F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x550), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x551), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x552), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x553), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x554), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x555), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x556), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x557), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x558), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x559), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x55A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x55B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x55C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x55D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x55E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x55F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x560), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x561), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x562), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x563), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x564), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x565), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x566), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x567), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x568), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x569), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x56A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x56B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x56C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x56D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x56E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x56F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x570), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x571), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x572), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x573), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x574), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x575), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x576), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x577), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x578), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x579), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x57A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x57B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x57C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x57D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x57E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x57F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x580), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x581), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x582), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x583), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x584), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x585), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x586), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x587), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x588), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x589), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x58A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x58B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x58C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x58D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x58E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x58F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x590), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x591), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x592), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x593), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x594), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x595), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x596), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x597), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x598), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x599), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x59A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x59B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x59C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x59D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x59E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x59F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5AA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5AC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5AE), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5AF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B3), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B4), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5B9), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5BA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5BB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5BC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5BD), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5BE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5BF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C3), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5C9), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5CA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5CB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5CC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5CD), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5CE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5CF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D3), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5D9), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5DA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5DB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5DD), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5DF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E3), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5EA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5EC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5ED), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5EE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5F9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5FA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5FB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5FC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5FD), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5FE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x5FF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xF8), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xF9), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x602), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x603), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x604), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x605), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x606), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x607), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x608), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x609), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x60A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x60B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x60C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x60D), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x60E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xFA), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x610), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x611), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x612), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x613), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x614), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x615), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x616), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x617), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x618), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x619), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x61A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x61B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x61C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x61D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x61E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x61F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x620), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x621), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x622), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x623), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x624), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x625), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x627), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x628), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x62A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x62B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x62D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x62E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x630), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x631), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x632), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x633), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x634), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x635), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x637), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x638), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x63A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x63B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x63D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x63E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x640), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x641), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x642), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x643), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x644), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x645), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x647), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x648), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x64A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x64B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x64D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x64E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x650), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x651), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x652), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x653), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x654), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x655), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x656), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x657), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x658), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x659), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x65A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xFB), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x65D), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x65E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x65F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x660), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x661), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x662), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x663), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x664), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x665), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x666), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x667), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x668), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x669), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x66C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x66D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x66E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x66F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x670), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x671), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x672), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x673), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x674), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x675), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xFC), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x678), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x679), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x67A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x67B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x67C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x67D), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x67E), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xFD), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x681), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x682), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x683), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x684), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x685), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x686), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xFE), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x688), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x689), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x68A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x68B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x68C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x68D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x68E), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x68F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x690), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x691), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x692), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x693), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x694), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x695), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x696), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x697), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x698), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x699), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x69A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x69B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x69C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x69D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x69E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x69F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0xFF), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A4), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A5), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A6), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6AA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6AE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6AF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6BA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6BC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6BF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C3), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6C9), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6D7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DD), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6DF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E0), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x103), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x104), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x105), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x106), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x107), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6E9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6EA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x108), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x109), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x10A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x10B), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x10C), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x6F5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x704), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x705), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x706), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x707), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x708), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x709), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x110), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x111), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x112), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x113), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x114), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x712), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x713), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x714), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x715), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x716), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODRM_MOD_COMPACT, 0x717), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x115), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x116), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x117), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x118), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x119), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x11A), ZYDIS_INVALID, ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x11B), ZYDIS_INVALID, ZYDIS_INVALID }
};

const ZydisDecoderTreeNode FILTERS_REX_W[][2] =
{
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_CET, 0x0), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_CET, 0x1) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_CET, 0x2), ZYDIS_INVALID },
    { ZYDIS_DEFINITION(0x1, 0x134), ZYDIS_DEFINITION(0x1, 0x135) },
    { ZYDIS_DEFINITION(0x1, 0x130), ZYDIS_DEFINITION(0x1, 0x131) },
    { ZYDIS_DEFINITION(0x1, 0x136), ZYDIS_DEFINITION(0x1, 0x137) },
    { ZYDIS_DEFINITION(0x1, 0x132), ZYDIS_DEFINITION(0x1, 0x133) },
    { ZYDIS_DEFINITION(0x1, 0x14A), ZYDIS_DEFINITION(0x1, 0x14B) },
    { ZYDIS_DEFINITION(0x1, 0x146), ZYDIS_DEFINITION(0x1, 0x147) },
    { ZYDIS_DEFINITION(0x1, 0x14C), ZYDIS_DEFINITION(0x1, 0x14D) },
    { ZYDIS_DEFINITION(0x1, 0x148), ZYDIS_DEFINITION(0x1, 0x149) },
    { ZYDIS_DEFINITION(0x1, 0x13A), ZYDIS_DEFINITION(0x1, 0x13B) },
    { ZYDIS_DEFINITION(0x1, 0x12A), ZYDIS_DEFINITION(0x1, 0x12B) },
    { ZYDIS_DEFINITION(0x1, 0x13C), ZYDIS_DEFINITION(0x1, 0x13D) },
    { ZYDIS_DEFINITION(0x1, 0x12C), ZYDIS_DEFINITION(0x1, 0x12D) },
    { ZYDIS_DEFINITION(0x1, 0x74E), ZYDIS_DEFINITION(0x1, 0x74F) },
    { ZYDIS_DEFINITION(0x1, 0x16), ZYDIS_DEFINITION(0x1, 0x17) },
    { ZYDIS_DEFINITION(0x1, 0x38), ZYDIS_DEFINITION(0x1, 0x39) },
    { ZYDIS_DEFINITION(0x1, 0x74C), ZYDIS_DEFINITION(0x1, 0x74D) },
    { ZYDIS_DEFINITION(0x1, 0x18), ZYDIS_DEFINITION(0x1, 0x19) },
    { ZYDIS_DEFINITION(0x1, 0x3A), ZYDIS_DEFINITION(0x1, 0x3B) },
    { ZYDIS_DEFINITION(0x1, 0x33D), ZYDIS_DEFINITION(0x1, 0x33E) },
    { ZYDIS_DEFINITION(0xB, 0x48F), ZYDIS_DEFINITION(0xB, 0x491) },
    { ZYDIS_DEFINITION(0xB, 0x490), ZYDIS_DEFINITION(0xB, 0x492) },
    { ZYDIS_DEFINITION(0xB, 0x4B3), ZYDIS_DEFINITION(0xB, 0x4B5) },
    { ZYDIS_DEFINITION(0xB, 0x4B4), ZYDIS_DEFINITION(0xB, 0x4B6) },
    { ZYDIS_DEFINITION(0xB, 0x475), ZYDIS_DEFINITION(0xB, 0x476) },
    { ZYDIS_DEFINITION(0xB, 0x477), ZYDIS_DEFINITION(0xB, 0x478) },
    { ZYDIS_DEFINITION(0xB, 0x471), ZYDIS_DEFINITION(0xB, 0x472) },
    { ZYDIS_DEFINITION(0xB, 0x473), ZYDIS_DEFINITION(0xB, 0x474) },
    { ZYDIS_DEFINITION(0x1, 0x329), ZYDIS_DEFINITION(0x1, 0x35D) },
    { ZYDIS_DEFINITION(0x1, 0x32D), ZYDIS_DEFINITION(0x1, 0x35F) },
    { ZYDIS_DEFINITION(0x1, 0x32A), ZYDIS_DEFINITION(0x1, 0x35E) },
    { ZYDIS_DEFINITION(0x1, 0x32E), ZYDIS_DEFINITION(0x1, 0x360) },
    { ZYDIS_DEFINITION(0x1, 0x331), ZYDIS_DEFINITION(0x1, 0x363) },
    { ZYDIS_DEFINITION(0x1, 0x335), ZYDIS_DEFINITION(0x1, 0x365) },
    { ZYDIS_DEFINITION(0x1, 0x332), ZYDIS_DEFINITION(0x1, 0x364) },
    { ZYDIS_DEFINITION(0x1, 0x336), ZYDIS_DEFINITION(0x1, 0x366) },
    { ZYDIS_DEFINITION(0x1, 0x23D), ZYDIS_DEFINITION(0x1, 0x23E) },
    { ZYDIS_DEFINITION(0x1, 0x20E), ZYDIS_DEFINITION(0x1, 0x20F) },
    { ZYDIS_DEFINITION(0x1, 0x20C), ZYDIS_DEFINITION(0x1, 0x20D) },
    { ZYDIS_DEFINITION(0x1, 0x77F), ZYDIS_DEFINITION(0x1, 0x780) },
    { ZYDIS_DEFINITION(0x1, 0x77B), ZYDIS_DEFINITION(0x1, 0x77C) },
    { ZYDIS_DEFINITION(0x1, 0x783), ZYDIS_DEFINITION(0x1, 0x784) },
    { ZYDIS_DEFINITION(0x1, 0x10A), ZYDIS_DEFINITION(0x1, 0x109) },
    { ZYDIS_DEFINITION(0x1, 0x77D), ZYDIS_DEFINITION(0x1, 0x77E) },
    { ZYDIS_DEFINITION(0x1, 0x781), ZYDIS_DEFINITION(0x1, 0x782) },
    { ZYDIS_DEFINITION(0x1, 0x785), ZYDIS_DEFINITION(0x1, 0x786) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x9), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x11), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x12), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x13), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x14), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x15), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x14), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x16), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x16), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x17), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x18), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x18), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x19), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x20), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x22), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x25), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x26) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x28), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x20), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x2A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x21), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x2C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x22), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x2E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x23), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x24) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x31), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x32) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x25), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x26) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x35), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x36) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x27), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x38), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x28), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x3A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x29), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x3C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x3E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x2F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x40), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x30), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x31), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x32), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x42), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x33), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x34), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x35), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x44), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x36), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x37), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x38), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x39), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x46), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x48), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x3F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x40), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x41) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x4F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x50) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x42), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x52), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x43), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x54), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x44), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x56), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x45), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x58), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x46), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x47), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x48), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x5E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x49), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x60), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x4A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x4B), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x4C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x4D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x4E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x4F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x50) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x51) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x52) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x68) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x53) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x6A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x54) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x55) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x56) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x57) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x58) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x59) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x5A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x5B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x5C) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x5D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x5E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x5F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x73) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x60) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x75) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x61) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x77) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x62) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x79) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x63) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x7B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x64) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x7D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x65) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x7F) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x66) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x81) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x67), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x83), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x68) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x85) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x69) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x87) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x6A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x89) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x6B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x8B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x70), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x91), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x77), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x99), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x7E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xA1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x7F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xA3), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x80) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xA5) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x81) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xA7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x82), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x71) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x85), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x72) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x88), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x89) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x8A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x8B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x8C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xB3), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x93), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x94) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x95), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x96) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x97), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x98), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x99) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x9A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xC2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xC3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xC4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xC5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xC6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xC7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xC8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xC9), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x9B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x9D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xCE) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xD0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA5), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xD7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xDA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xDB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA8), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xA9) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xDE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xDF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xAA), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xAB) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xE2), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xE3) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xAC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xAD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xE6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xE7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xAE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x73) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x74) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB4), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB5) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB7) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xB8) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xF3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xBC) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0xF8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xBF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC0), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC1) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC2) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x100) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC6) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xC7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xCE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xCF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x10D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x10E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xD7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x117), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x118) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xDC), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xDD) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xDE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xDF) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE6) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x128) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xE7), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xEE), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xEF) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x132), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x133) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF6), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xF7) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x13C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x13D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xFA), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xFB), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xFC) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xFD) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0xFE) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x145) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x107), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x14F), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x108) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x151) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x10D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x157), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x114), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x15F), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x115) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x161) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x116) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x117) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x118) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x119) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x11A) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x11B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x11C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x11D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x11E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x11F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x16C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x16D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x120), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x121) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x170), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x171) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x122), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x123) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x174), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x175) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x124), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x125), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x126), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x127) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x128), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x129) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x12A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x12B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x12C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x12D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x132), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x185), ZYDIS_INVALID },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x133) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x187) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x13E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x13F), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x140), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x141) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x142), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x143) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x144), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x145) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x19A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x19B) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x146) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x19D) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x147) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x19F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x148), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x149), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1A2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x14A), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x14B) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1A6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x14C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x14D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x14E), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x14F) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x15A), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x15B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x15C), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x15D) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1B6) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x15E) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1B8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x161), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x162) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1BE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x165), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x166) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1C3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1C4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x169), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x16A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1C9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1CA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x16D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x16E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1CF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1D0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x16F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x170) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1D3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1D4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x171), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x172) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1D7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1D8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x173), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x174) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x175), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x176) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x177), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x178) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1DB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1DC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x179), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x17A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1DF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1E0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x17B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x17C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1E3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1E4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x17D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x17E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1E7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1E8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x17F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x180) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1EB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1EC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x181), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x182) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x183), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x184) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x185), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x186) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1EF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1F0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x187), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x188) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x189), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x18A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x18B), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1F2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x18C), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1F4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x18D), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1F6), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x18E), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1F8), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x18F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x190) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x191), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x192) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x193), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x194) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x1FF), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x200) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x195), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x196), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x197), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x198) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x199), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x19A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x19B), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x19C) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x19D), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x19E) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x19F), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1A0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1A1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1A2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1A3), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1A4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1A5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1A6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1A7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1A8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x215), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x216) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1A9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1AA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x219), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x21A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1AB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1AC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1AD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1AE) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1AF) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1B0) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1B1), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1B2) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x223), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x224) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1B3) },
    { ZYDIS_INVALID, ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1B4) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1B5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1B6) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x229), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x22A) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1B7), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1B8) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1B9), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1BA) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1BB), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1BC) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x231), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x232) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1BD), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1BE) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x235), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_VECTOR_LENGTH, 0x236) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1BF), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1C0), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1C1), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1C2), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1C3), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1C4), ZYDIS_INVALID },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0x1C5), ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_MODE_COMPACT, 0x75) },
    { ZYDIS_FILTER(ZYDIS_NODETYPE_FILTER_EVEX_B, 0