/*
 * Copyright (c) 2022 Winsider Seminars & Solutions, Inc.  All rights reserved.
 *
 * This file is part of System Informer.
 *
 * Authors:
 *
 *     dmex    2023
 *
 */

#ifndef __dia3_h__
#define __dia3_h__

// 5e1d8e93-ef43-415b-93a7-fec353c296bd
static IID IID_IDiaSession2 = { 0x5e1d8e93, 0xef43, 0x415b, { 0x93, 0xa7, 0xfe, 0xc3, 0x53, 0xc2, 0x96, 0xbd } };
// 52585014-e2b6-49fe-aa72-3a1e178682ee
static IID IID_IDiaSession3 = { 0x52585014, 0xe2b6, 0x49fe, { 0xaa, 0x72, 0x3a, 0x1e, 0x17, 0x86, 0x82, 0xee } };
// 7d0415e0-bbc2-4df7-a587-912c66affc7d
static IID IID_IDiaSession4 = { 0x7d0415e0, 0xbbc2, 0x4df7, { 0xa5, 0x87, 0x91, 0x2c, 0x66, 0xaf, 0xfc, 0x7d } };
// 29d22842-a8ef-44c8-aec5-c5b16f33d383
static IID IID_IDiaSession5 = { 0x29d22842, 0xa8ef, 0x44c8, { 0xae, 0xc5, 0xc5, 0xb1, 0x6f, 0x33, 0xd3, 0x83 } };
// 9eaa6087-0890-4cfa-837e-cd0049971c14
static IID IID_IDiaSession6 = { 0x9eaa6087, 0x0890, 0x4cfa, { 0x83, 0x7e, 0xcd, 0x00, 0x49, 0x97, 0x1c, 0x14 } };
// 7a1b3dba-85e6-456c-9c6c-2e3e849ffd55
static IID IID_IDiaSession7 = { 0x7a1b3dba, 0x85e6, 0x456c, { 0x9c, 0x6c, 0x2e, 0x3e, 0x84, 0x9f, 0xfd, 0x55 } };
// fc9e7a50-9e9f-4b93-b66e-d74162f5a6ae
static IID IID_IDiaSession8 = { 0xfc9e7a50, 0x9e9f, 0x4b93, { 0xb6, 0x6e, 0xd7, 0x41, 0x62, 0xf5, 0xa6, 0xae } };
// 32d67474-d601-4d2d-a876-60388fdec8e7
static IID IID_IDiaSession9 = { 0x32d67474, 0xd601, 0x4d2d, { 0xa8, 0x76, 0x60, 0x38, 0x8f, 0xde, 0xc8, 0xe7 } };
// cf137e16-4d98-4eef-bd42-1723e6f34244
static IID IID_IDiaSession10 = { 0xcf137e16, 0x4d98, 0x4eef, { 0xbd, 0x42, 0x17, 0x23, 0xe6, 0xf3, 0x42, 0x44 } };
// 348368d5-5646-4b63-9f42-667fbfba05e0
static IID IID_IDiaSession11 = { 0x348368d5, 0x5646, 0x4b63, { 0x9f, 0x42, 0x66, 0x7f, 0xbf, 0xba, 0x05, 0xe0 } };
// f1d64018-2689-47d1-bf69-4c356621f251
static IID IID_IDiaSession12 = { 0xf1d64018, 0x2689, 0x47d1, { 0xbf, 0x69, 0x4c, 0x35, 0x66, 0x21, 0xf2, 0x51 } };
// 3e4e801d-a634-4659-9fdf-0bb464859ee8
static IID IID_IDiaSession13 = { 0x3e4e801d, 0xa634, 0x4659, { 0x9f, 0xdf, 0x0b, 0xb4, 0x64, 0x85, 0x9e, 0xe8 } };

// 6D31CB3B-EDD4-4C3E-AB44-12B9F7A3828E
static IID IID_IDiaDataSource2 = { 0x6D31CB3B, 0xEDD4, 0x4C3E, { 0xAB, 0x44, 0x12, 0xB9, 0xF7, 0xA3, 0x82, 0x8E } };
// 65A23C15-BAB3-45DA-8639-F06DE86B9EA8
static IID IID_IDiaDataSource3 = { 0x65A23C15, 0xBAB3, 0x45DA, { 0x86, 0x39, 0xF0, 0x6D, 0xE8, 0x6B, 0x9E, 0xA8 } };
// 27b468a6-229c-4248-8f5e-f326e7c62ba4
static IID IID_IDiaDataSource4 = { 0x27b468a6, 0x229c, 0x4248, { 0x8f, 0x5e, 0xf3, 0x26, 0xe7, 0xc6, 0x2b, 0xa4 } };
// 6f9a508c-04a0-4c6f-8c61-8b964702311b
static IID IID_IDiaDataSource5 = { 0x6f9a508c, 0x04a0, 0x4c6f, { 0x8c, 0x61, 0x8b, 0x96, 0x47, 0x02, 0x31, 0x1b } };
// cef240fe-c71c-4219-a876-a1b6b24f3820
static IID IID_IDiaDataSource6 = { 0xcef240fe, 0xc71c, 0x4219, { 0xa8, 0x76, 0xa1, 0xb6, 0xb2, 0x4f, 0x38, 0x20 } };
// 26289ca7-7e2e-4f8b-b4af-ca3630d48834
static IID IID_IDiaDataSource7 = { 0x26289ca7, 0x7e2e, 0x4f8b, { 0xb4, 0xaf, 0xca, 0x36, 0x30, 0xd4, 0x88, 0x34 } };
// d808f8d0-0f8d-4ca7-8a05-8963f7d5f9f1
static IID IID_IDiaDataSource8 = { 0xd808f8d0, 0x0f8d, 0x4ca7, { 0x8a, 0x05, 0x89, 0x63, 0xf7, 0xd5, 0xf9, 0xf1 } };
// d555708b-4eee-45f5-8311-e18217d28b13
static IID IID_IDiaDataSource9 = { 0x65A23C15, 0xBAB3, 0x45DA, { 0x86, 0x39, 0xF0, 0x6D, 0xE8, 0x6B, 0x9E, 0xA8 } };
// 5c7e382a-93b4-4677-a6b5-cc28c3accb96
static IID IID_IDiaDataSource10 = { 0x5c7e382a, 0x93b4, 0x4677, { 0xa6, 0xb5, 0xcc, 0x28, 0xc3, 0xac, 0xcb, 0x96 } };

// A71F214B-9118-42EB-AAB3-F7F51D3BA445
static IID IID_IDiaEnumXfgTypeHashes = { 0xA71F214B, 0x9118, 0x42EB, { 0xAA, 0xB3, 0xF7, 0xF5, 0x1D, 0x3B, 0xA4, 0x45 } };
// 35C76D38-227B-4CFB-8E81-EE853557F4C0
static IID IID_IDiaXfgTypeHash = { 0x35C76D38, 0x227B, 0x4CFB, { 0x8E, 0x81, 0xEE, 0x85, 0x35, 0x57, 0xF4, 0xC0 } };

#undef INTERFACE
#define INTERFACE IDiaDataSource2
DECLARE_INTERFACE_IID(IDiaDataSource2, IDiaDataSource)
{
    BEGIN_INTERFACE

    // IUnknown
    STDMETHOD(QueryInterface)(THIS, REFIID riid, PVOID *ppvObject) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    // IDiaDataSource2

    STDMETHOD(getRawPDBPtr)(THIS,
        _Out_ PVOID PdbBaseAddress
        ) PURE;

    STDMETHOD(loadDataFromRawPDBPtr)(THIS,
        _In_ PVOID PdbBaseAddress
        ) PURE;

    END_INTERFACE
};

#undef INTERFACE
#define INTERFACE IDiaDataSource3
DECLARE_INTERFACE_IID(IDiaDataSource3, IDiaDataSource2)
{
    BEGIN_INTERFACE

    // IUnknown
    STDMETHOD(QueryInterface)(THIS, REFIID riid, PVOID *ppvObject) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    // IDiaDataSource3

    STDMETHOD(getStreamSize)(THIS,
        _In_ PWSTR StreamName,
        _Out_ PULONG StreamSize
        ) PURE;

    STDMETHOD(getStreamRawData)(THIS,
        _In_ PWSTR StreamName,
        _In_ ULONG BytesToRead,
        _Out_ PBYTE StreamData
        ) PURE;

    END_INTERFACE
};

#undef INTERFACE
#define INTERFACE IDiaDataSource10
DECLARE_INTERFACE_IID(IDiaDataSource10, IUnknown)
{
    BEGIN_INTERFACE

    // IUnknown
    STDMETHOD(QueryInterface)(THIS, REFIID riid, PVOID *ppvObject) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    // IDiaDataSource

    STDMETHOD(get_lastError)(THIS,
        _Out_ BSTR* pRetVal);

    STDMETHOD(loadDataFromPdb)(THIS,
        _In_ LPCOLESTR pdbPath);

    STDMETHOD(loadAndValidateDataFromPdb)(THIS,
        _In_ LPCOLESTR pdbPath,
        _In_ GUID* pcsig70,
        _In_ DWORD sig,
        _In_ DWORD age);

    STDMETHOD(loadDataForExe)(THIS,
        _In_ LPCOLESTR executable,
        _In_ LPCOLESTR searchPath,
        _In_ IUnknown* pCallback);

    STDMETHOD(loadDataFromIStream)(THIS,
        _In_ IStream * pIStream);

    STDMETHOD(openSession)(THIS,
        _Out_ IDiaSession** ppSession);

    STDMETHOD(loadDataFromCodeViewInfo)(THIS,
        _In_ LPCOLESTR executable,
        _In_ LPCOLESTR searchPath,
        _In_ DWORD cbCvInfo,
        _In_ BYTE* pbCvInfo,
        _In_ IUnknown* pCallback);

    STDMETHOD(loadDataFromMiscInfo)(THIS,
        _In_ LPCOLESTR executable,
        _In_ LPCOLESTR searchPath,
        _In_ DWORD timeStampExe,
        _In_ DWORD timeStampDbg,
        _In_ DWORD sizeOfExe,
        _In_ DWORD cbMiscInfo,
        _In_ BYTE* pbMiscInfo,
        _In_ IUnknown* pCallback);

    // IDiaDataSource2

    STDMETHOD(getRawPDBPtr)(THIS,
        _Out_ PVOID PdbBaseAddress
        ) PURE;

    STDMETHOD(loadDataFromRawPDBPtr)(THIS,
        _In_ PVOID PdbBaseAddress
        ) PURE;

    // IDiaDataSource3

    STDMETHOD(getStreamSize)(THIS,
        _In_ PWSTR StreamName,
        _Out_ PULONG StreamSize
        ) PURE;

    STDMETHOD(getStreamRawData)(THIS,
        _In_ PWSTR StreamName,
        _In_ ULONG BytesToRead,
        _Out_ PBYTE StreamData
        ) PURE;

    // TODO
    STDMETHOD(loadDataFromPdbEx)(THIS, USHORT const* pdbPath, INT) PURE;
    STDMETHOD(loadAndValidateDataFromPdbEx)(THIS, USHORT const* pdbPath, PGUID, ULONG, ULONG, INT) PURE;
    STDMETHOD(loadDataForExeEx)(THIS, USHORT const*, USHORT const*, IUnknown* Object, INT) PURE;
    STDMETHOD(loadDataFromIStreamEx)(THIS, IStream*, INT) PURE;
    STDMETHOD(NotUsedQueryInterface)(THIS, REFIID riid, PVOID* ppvObject) PURE;
    STDMETHOD(setPfnMiniPDBErrorCallback2)(THIS, PVOID, long (*)(PVOID, ULONG, USHORT const* const, USHORT const* const)) PURE;
    STDMETHOD(setPfnMiniPDBNHBuildStatusCallback)(THIS, PVOID, INT(*)(PVOID, ULONG)) PURE;
    STDMETHOD(loadDataFromPdbEx2)(THIS, USHORT const*, INT, INT) PURE;
    STDMETHOD(loadAndValidateDataFromPdbEx2)(THIS, USHORT const*, PGUID, ULONG, ULONG, INT, INT) PURE;
    STDMETHOD(loadDataForExeEx2)(THIS, USHORT const*, USHORT const*, IUnknown*, INT, INT) PURE;
    STDMETHOD(loadDataFromIStreamEx2)(THIS, IStream*, INT, INT) PURE;
    STDMETHOD(loadDataFromCodeViewInfoEx)(THIS, USHORT const*, USHORT const*, ULONG, PBYTE, IUnknown*, INT) PURE;
    STDMETHOD(VSDebuggerPreloadPDBDone)(THIS) PURE;
    STDMETHOD(loadDataForExeEx3)(THIS, USHORT const*, USHORT const*, IUnknown*, INT, INT, INT) PURE;
    STDMETHOD(usePdb)(THIS, PVOID) PURE;
    STDMETHOD(loadDataFromCodeViewInfoHelper)(THIS, USHORT const*, USHORT const*, ULONG, PBYTE, IUnknown*, char const*) PURE;

    END_INTERFACE
};

#undef INTERFACE
#define INTERFACE IDiaXfgTypeHash
DECLARE_INTERFACE_IID(IDiaXfgTypeHash, IUnknown)
{
    BEGIN_INTERFACE

    // IUnknown
    STDMETHOD(QueryInterface)(THIS, REFIID riid, PVOID *ppvObject) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    // IDiaXfgTypeHash
    STDMETHOD(get_TypeHash)(THIS, __RPC__out PULONG64 TypeHash) PURE;
    STDMETHOD(get_TypeSignature)(THIS, __RPC__out IDiaSymbol** TypeSymbol) PURE;
    STDMETHOD(get_HasVirtualInformation)(THIS, __RPC__out PBOOL Virtual) PURE;
    STDMETHOD(get_BaseClassName)(THIS, __RPC__out PWSTR *BaseClassName) PURE;
    STDMETHOD(get_MethodName)(THIS, __RPC__out PWSTR *MethodName) PURE;

    END_INTERFACE
};

#ifdef COBJMACROS
#define IDiaXfgTypeHash_QueryInterface(This,riid,ppvObject) \
    ((This)->lpVtbl->QueryInterface(This,riid,ppvObject))
#define IDiaXfgTypeHash_AddRef(This) \
    ((This)->lpVtbl->AddRef(This))
#define IDiaXfgTypeHash_Release(This) \
    ((This)->lpVtbl->Release(This))
#define IDiaXfgTypeHash_get_TypeHash(This, Hash) \
    ((This)->lpVtbl->get_TypeHash(This, Hash))
#define IDiaXfgTypeHash_get_TypeSignature(This, Symbol) \
    ((This)->lpVtbl->get_TypeSignature(This, Symbol))
#define IDiaXfgTypeHash_get_HasVirtualInformation(This, Virtual) \
    ((This)->lpVtbl->get_HasVirtualInformation(This, Virtual))
#define IDiaXfgTypeHash_get_BaseClassName(This, BaseClassName) \
    ((This)->lpVtbl->get_BaseClassName(This, BaseClassName))
#define IDiaXfgTypeHash_get_MethodName(This, MethodName) \
    ((This)->lpVtbl->get_MethodName(This, MethodName))
#endif

#undef INTERFACE
#define INTERFACE IDiaEnumXfgTypeHashes
DECLARE_INTERFACE_IID(IDiaEnumXfgTypeHashes, IUnknown)
{
    BEGIN_INTERFACE

    // IUnknown
    STDMETHOD(QueryInterface)(THIS, REFIID riid, PVOID *ppvObject) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    // IDiaEnumXfgTypeHashes
    STDMETHOD(get_Count)(THIS, __RPC__out PULONG Count) PURE;
    STDMETHOD(Next)(THIS, __RPC__in ULONG celt, __RPC__out_ecount_part(celt, *pceltFetched) IDiaXfgTypeHash **TypeHashes, __RPC__out PULONG pceltFetched) PURE;
    STDMETHOD(Reset)(THIS) PURE;

    END_INTERFACE
};

#ifdef COBJMACROS
#define IDiaEnumXfgTypeHashes_QueryInterface(This,riid,ppvObject) \
    ((This)->lpVtbl->QueryInterface(This,riid,ppvObject))
#define IDiaEnumXfgTypeHashes_AddRef(This) \
    ((This)->lpVtbl->AddRef(This))
#define IDiaEnumXfgTypeHashes_Release(This) \
    ((This)->lpVtbl->Release(This))
#define IDiaEnumXfgTypeHashes_get_Count(This, Count) \
    ((This)->lpVtbl->get_Count(This, Count))
#define IDiaEnumXfgTypeHashes_Next(This, celt, hashes, count) \
    ((This)->lpVtbl->Next(This, celt, hashes, count))
#define IDiaEnumXfgTypeHashes_Reset(This) \
    ((This)->lpVtbl->Reset(This))
#endif

#undef INTERFACE
#define INTERFACE IDiaSession13
DECLARE_INTERFACE_IID(IDiaSession13, IUnknown)
{
    BEGIN_INTERFACE

    // IUnknown
    STDMETHOD(QueryInterface)(THIS, REFIID riid, PVOID *ppvObject) PURE;
    STDMETHOD_(ULONG, AddRef)(THIS) PURE;
    STDMETHOD_(ULONG, Release)(THIS) PURE;

    // IDiaSession

    STDMETHOD(get_loadAddress)(THIS,
        _Out_ ULONGLONG* pRetVal);

    STDMETHOD(put_loadAddress)(THIS,
        _In_ ULONGLONG NewVal);

    STDMETHOD(get_globalScope)(THIS,
        _Out_ IDiaSymbol **pRetVal);

    STDMETHOD(getEnumTables)(THIS,
        _Out_ IDiaEnumTables **ppEnumTables);

    STDMETHOD(getSymbolsByAddr)(THIS,
        _Out_ IDiaEnumSymbolsByAddr **ppEnumbyAddr);

    STDMETHOD(findChildren)(THIS,
        _In_ IDiaSymbol* parent,
        _In_ enum SymTagEnum symtag,
        _In_ LPCOLESTR name,
        _In_ DWORD compareFlags,
        _Out_ IDiaEnumSymbols **ppResult);

    STDMETHOD(findChildrenEx)(THIS,
        _In_ IDiaSymbol* parent,
        _In_ enum SymTagEnum symtag,
        _In_ LPCOLESTR name,
        _In_ DWORD compareFlags,
        _Out_ IDiaEnumSymbols **ppResult);

    STDMETHOD(findChildrenExByAddr)(THIS,
        _In_ IDiaSymbol* parent,
        _In_ enum SymTagEnum symtag,
        _In_ LPCOLESTR name,
        _In_ DWORD compareFlags,
        _In_ DWORD isect,
        _In_ DWORD offset,
        _Out_ IDiaEnumSymbols * *ppResult);

    STDMETHOD(findChildrenExByVA)(THIS,
        _In_ IDiaSymbol* parent,
        _In_ enum SymTagEnum symtag,
        _In_ LPCOLESTR name,
        _In_ DWORD compareFlags,
        _In_ ULONGLONG va,
        _Out_ IDiaEnumSymbols **ppResult);

    STDMETHOD(findChildrenExByRVA)(THIS,
        _In_ IDiaSymbol* parent,
        _In_ enum SymTagEnum symtag,
        _In_ LPCOLESTR name,
        _In_ DWORD compareFlags,
        _In_ DWORD rva,
        _Out_ IDiaEnumSymbols **ppResult);

    STDMETHOD(findSymbolByAddr)(THIS,
        _In_ DWORD isect,
        _In_ DWORD offset,
        _In_ enum SymTagEnum symtag,
        _Out_ IDiaSymbol **ppSymbol);

    STDMETHOD(findSymbolByRVA)(THIS,
        _In_ DWORD rva,
        _In_ enum SymTagEnum symtag,
        _Out_ IDiaSymbol * *ppSymbol);

    STDMETHOD(findSymbolByVA)(THIS,
        /* [in] */ ULONGLONG va,
        /* [in] */ enum SymTagEnum symtag,
        _Out_ IDiaSymbol **ppSymbol);

    STDMETHOD(findSymbolByToken)(THIS,
        /* [in] */ ULONG token,
        /* [in] */ enum SymTagEnum symtag,
        _Out_ IDiaSymbol **ppSymbol);

    STDMETHOD(symsAreEquiv)(THIS,
        /* [in] */ IDiaSymbol* symbolA,
        /* [in] */ IDiaSymbol* symbolB);

    STDMETHOD(symbolById)(THIS,
        /* [in] */ DWORD id,
        _Out_ IDiaSymbol **ppSymbol);

    STDMETHOD(findSymbolByRVAEx)(THIS,
        /* [in] */ DWORD rva,
        /* [in] */ enum SymTagEnum symtag,
        _Out_ IDiaSymbol **ppSymbol,
        _Out_ long* displacement);

    STDMETHOD(findSymbolByVAEx)(THIS,
        /* [in] */ ULONGLONG va,
        /* [in] */ enum SymTagEnum symtag,
        /* [out] */ IDiaSymbol **ppSymbol,
        /* [out] */ long* displacement);

    STDMETHOD(findFile)(THIS,
        /* [in] */ IDiaSymbol* pCompiland,
        /* [in] */ LPCOLESTR name,
        /* [in] */ DWORD compareFlags,
        /* [out] */ IDiaEnumSourceFiles **ppResult);

    STDMETHOD(findFileById)(THIS,
        /* [in] */ DWORD uniqueId,
        /* [out] */ IDiaSourceFile **ppResult);

    STDMETHOD(findLines)(THIS,
        /* [in] */ IDiaSymbol* compiland,
        /* [in] */ IDiaSourceFile* file,
        /* [out] */ IDiaEnumLineNumbers **ppResult);

    STDMETHOD(findLinesByAddr)(THIS,
        /* [in] */ DWORD seg,
        /* [in] */ DWORD offset,
        /* [in] */ DWORD length,
        /* [out] */ IDiaEnumLineNumbers **ppResult);

    STDMETHOD(findLinesByRVA)(THIS,
        /* [in] */ DWORD rva,
        /* [in] */ DWORD length,
        /* [out] */ IDiaEnumLineNumbers **ppResult);

    STDMETHOD(findLinesByVA)(THIS,
        /* [in] */ ULONGLONG va,
        /* [in] */ DWORD length,
        /* [out] */ IDiaEnumLineNumbers **ppResult);

    STDMETHOD(findLinesByLinenum)(THIS,
        /* [in] */ IDiaSymbol* compiland,
        /* [in] */ IDiaSourceFile* file,
        /* [in] */ DWORD linenum,
        /* [in] */ DWORD column,
        /* [out] */ IDiaEnumLineNumbers **ppResult);

    STDMETHOD(findInjectedSource)(THIS,
        /* [in] */ LPCOLESTR srcFile,
        /* [out] */ IDiaEnumInjectedSources **ppResult);

    STDMETHOD(getEnumDebugStreams)(THIS,
        /* [out] */ IDiaEnumDebugStreams **ppEnumDebugStreams);

    STDMETHOD(findInlineFramesByAddr)(
        IDiaSession * This,
        /* [in] */ IDiaSymbol * parent,
        /* [in] */ DWORD isect,
        /* [in] */ DWORD offset,
        /* [out] */ IDiaEnumSymbols * *ppResult);

    STDMETHOD(findInlineFramesByRVA)(
        IDiaSession * This,
        /* [in] */ IDiaSymbol * parent,
        /* [in] */ DWORD rva,
        /* [out] */ IDiaEnumSymbols * *ppResult);

    STDMETHOD(findInlineFramesByVA)(
        IDiaSession * This,
        /* [in] */ IDiaSymbol * parent,
        /* [in] */ ULONGLONG va,
        /* [out] */ IDiaEnumSymbols * *ppResult);

    STDMETHOD(findInlineeLines)(
        IDiaSession * This,
        /* [in] */ IDiaSymbol * parent,
        /* [out] */ IDiaEnumLineNumbers * *ppResult);

    STDMETHOD(findInlineeLinesByAddr)(
        IDiaSession * This,
        /* [in] */ IDiaSymbol * parent,
        /* [in] */ DWORD isect,
        /* [in] */ DWORD offset,
        /* [in] */ DWORD length,
        /* [out] */ IDiaEnumLineNumbers * *ppResult);

    STDMETHOD(findInlineeLinesByRVA)(
        IDiaSession * This,
        /* [in] */ IDiaSymbol * parent,
        /* [in] */ DWORD rva,
        /* [in] */ DWORD length,
        /* [out] */ IDiaEnumLineNumbers * *ppResult);

    STDMETHOD(findInlineeLinesByVA)(
        IDiaSession * This,
        /* [in] */ IDiaSymbol * parent,
        /* [in] */ ULONGLONG va,
        /* [in] */ DWORD length,
        /* [out] */ IDiaEnumLineNumbers * *ppResult);

    STDMETHOD(findInlineeLinesByLinenum)(
        IDiaSession * This,
        /* [in] */ IDiaSymbol * compiland,
        /* [in] */ IDiaSourceFile * file,
        /* [in] */ DWORD linenum,
        /* [in] */ DWORD column,
        /* [out] */ IDiaEnumLineNumbers * *ppResult);

    STDMETHOD(findInlineesByName)(
        IDiaSession * This,
        /* [in] */ LPCOLESTR name,
        /* [in] */ DWORD option,
        /* [out] */ IDiaEnumSymbols * *ppResult);

    STDMETHOD(findAcceleratorInlineeLinesByLinenum)(
        IDiaSession * This,
        /* [in] */ IDiaSymbol * parent,
        /* [in] */ IDiaSourceFile * file,
        /* [in] */ DWORD linenum,
        /* [in] */ DWORD column,
        /* [out] */ IDiaEnumLineNumbers * *ppResult);

    STDMETHOD(findSymbolsForAcceleratorPointerTag)(
        IDiaSession * This,
        /* [in] */ IDiaSymbol * parent,
        /* [in] */ DWORD tagValue,
        /* [out] */ IDiaEnumSymbols * *ppResult);

    STDMETHOD(findSymbolsByRVAForAcceleratorPointerTag)(
        IDiaSession * This,
        /* [in] */ IDiaSymbol * parent,
        /* [in] */ DWORD tagValue,
        /* [in] */ DWORD rva,
        /* [out] */ IDiaEnumSymbols * *ppResult);

    STDMETHOD(findAcceleratorInlineesByName)(
        IDiaSession * This,
        /* [in] */ LPCOLESTR name,
        /* [in] */ DWORD option,
        /* [out] */ IDiaEnumSymbols * *ppResult);

    STDMETHOD(addressForVA)(
        IDiaSession * This,
        /* [in] */ ULONGLONG va,
        /* [out] */ DWORD * pISect,
        /* [out] */ DWORD * pOffset);

    STDMETHOD(addressForRVA)(
        IDiaSession * This,
        /* [in] */ DWORD rva,
        /* [out] */ DWORD * pISect,
        /* [out] */ DWORD * pOffset);

    STDMETHOD(findILOffsetsByAddr)(
        IDiaSession * This,
        /* [in] */ DWORD isect,
        /* [in] */ DWORD offset,
        /* [in] */ DWORD length,
        /* [out] */ IDiaEnumLineNumbers * *ppResult);

    STDMETHOD(findILOffsetsByRVA)(
        IDiaSession * This,
        /* [in] */ DWORD rva,
        /* [in] */ DWORD length,
        /* [out] */ IDiaEnumLineNumbers * *ppResult);

    STDMETHOD(findILOffsetsByVA)(
        IDiaSession * This,
        /* [in] */ ULONGLONG va,
        /* [in] */ DWORD length,
        /* [out] */ IDiaEnumLineNumbers * *ppResult);

    STDMETHOD(findInputAssemblyFiles)(
        IDiaSession * This,
        /* [out] */ IDiaEnumInputAssemblyFiles * *ppResult);

    STDMETHOD(findInputAssembly)(
        IDiaSession * This,
        /* [in] */ DWORD index,
        /* [out] */ IDiaInputAssemblyFile * *ppResult);

    STDMETHOD(findInputAssemblyById)(
        IDiaSession * This,
        /* [in] */ DWORD uniqueId,
        /* [out] */ IDiaInputAssemblyFile * *ppResult);

    STDMETHOD(getFuncMDTokenMapSize)(
        IDiaSession * This,
        /* [out] */ DWORD * pcb);

    STDMETHOD(getFuncMDTokenMap)(THIS,
        /* [in] */ DWORD cb,
        /* [out] */ DWORD * pcb,
        /* [size_is][out] */ BYTE * pb);

    STDMETHOD(getTypeMDTokenMapSize)(THIS,
        /* [out] */ DWORD * pcb);

    STDMETHOD(getTypeMDTokenMap)(THIS,
        /* [in] */ DWORD cb,
        /* [out] */ DWORD * pcb,
        /* [size_is][out] */ BYTE * pb);

    STDMETHOD(getNumberOfFunctionFragments_VA)(THIS,
        /* [in] */ ULONGLONG vaFunc,
        /* [in] */ DWORD cbFunc,
        /* [out] */ DWORD * pNumFragments);

    STDMETHOD(getNumberOfFunctionFragments_RVA)(THIS,
        /* [in] */ DWORD rvaFunc,
        /* [in] */ DWORD cbFunc,
        /* [out] */ DWORD * pNumFragments);

    STDMETHOD(getFunctionFragments_VA)(THIS,
        /* [in] */ ULONGLONG vaFunc,
        /* [in] */ DWORD cbFunc,
        /* [in] */ DWORD cFragments,
        /* [size_is][out] */ ULONGLONG * pVaFragment,
        /* [size_is][out] */ DWORD * pLenFragment);

    STDMETHOD(getFunctionFragments_RVA)(THIS,
        /* [in] */ DWORD rvaFunc,
        /* [in] */ DWORD cbFunc,
        /* [in] */ DWORD cFragments,
        /* [size_is][out] */ DWORD * pRvaFragment,
        /* [size_is][out] */ DWORD * pLenFragment);

    STDMETHOD(getExports)(THIS,
        /* [out] */ IDiaEnumSymbols * *ppResult);

    STDMETHOD(getHeapAllocationSites)(THIS,
        /* [out] */ IDiaEnumSymbols * *ppResult);

    STDMETHOD(findInputAssemblyFile)(THIS,
        /* [in] */ IDiaSymbol * pSymbol,
        /* [out] */ IDiaInputAssemblyFile * *ppResult);

    // TODO
    // CDiaSession::addPublicSymbol(ushort const*,ulong,ulong,ulong,ulong,ulong,IDiaSymbol*,IDiaSymbol**)
    // CDiaSession::addStaticSymbol(ushort const*,ulong,ulong,ulong,ulong,ulong,IDiaSymbol*)
    // CDiaSession::findSectionAddressByCrc(ulong,ulong,ulong,ulong,IDiaSymbol *,ulong *,ulong*,ulong *)
    // CDiaSession::findThunkSymbol(IDiaSymbol *,IDiaSymbol**)
    // CDiaSession::makeThunkSymbol(ulong,ulong,IDiaSymbol**)
    // CDiaSession::mergeObjPDB(IDiaSymbol*)
    // CDiaSession::commitObjPDBMerge(IDiaSymbol*)
    // CDiaSession::cancelObjPDBMerge(IDiaSymbol*)
    // CDiaSession::getLinkInfo(uchar *,ulong*,ulong*,ulong *,ulong *,ulong *)
    // CDiaSession::isMiniPDB(int *)
    // CDiaSession::prepareEnCRebuild(IDiaSymbol *)
    // CDiaSession::dispose(void)
    // CDiaSession::getRawSymbolsFromMiniPDB(ulong,ulong,ulong *,uchar * *)
    // CDiaSession::getRawTypesFromMiniPDB(ulong,ulong *,uchar * *)
    // CDiaSession::getPdbMappingsForMiniPDB(ulong *,ushort * *,ushort * *)
    // CDiaSession::disposeObjForMiniPDB(ulong)
    // CDiaSession::EnablePrefetching(void)
    // CDiaSession::isPCTModuleFromMiniPDB(ulong,int*)
    // CDiaSession::EnableMemoryMappedFileIO(void)
    // CDiaSession::VSDebuggerPreloadPDBDone(void)
    // CDiaSession::isLinkerGeneratedModuleInMiniPDB(ulong,int*)
    // CDiaSession::getInlineeMDTokenMapSize(ulong*)
    // CDiaSession::getInlineeMDTokenMap(ulong,ulong*,uchar*)
    // CDiaSession::isPortablePDB(int*)
    // CDiaSession::getSourceLinkInfo(IDiaSymbol*,IDiaEnumSourceLink**)

    STDMETHOD(addPublicSymbol)(THIS);
    STDMETHOD(addStaticSymbol)(THIS);
    STDMETHOD(findSectionAddressByCrc)(THIS);
    STDMETHOD(findThunkSymbol)(THIS);
    STDMETHOD(makeThunkSymbol)(THIS);
    STDMETHOD(mergeObjPDB)(THIS);
    STDMETHOD(commitObjPDBMerge)(THIS);
    STDMETHOD(cancelObjPDBMerge)(THIS);
    STDMETHOD(getLinkInfo)(THIS);
    STDMETHOD(isMiniPDB)(THIS);
    STDMETHOD(prepareEnCRebuild)(THIS);
    STDMETHOD(dispose)(THIS);
    STDMETHOD(getRawSymbolsFromMiniPDB)(THIS);
    STDMETHOD(getRawTypesFromMiniPDB)(THIS);
    STDMETHOD(getPdbMappingsForMiniPDB)(THIS);
    STDMETHOD(disposeObjForMiniPDB)(THIS);
    STDMETHOD(EnablePrefetching)(THIS);
    STDMETHOD(isPCTModuleFromMiniPDB)(THIS);
    STDMETHOD(EnableMemoryMappedFileIO)(THIS);
    STDMETHOD(VSDebuggerPreloadPDBDone)(THIS);
    STDMETHOD(isLinkerGeneratedModuleInMiniPDB)(THIS);
    STDMETHOD(getInlineeMDTokenMapSize)(THIS);
    STDMETHOD(getInlineeMDTokenMap)(THIS);
    STDMETHOD(isPortablePDB)(THIS);
    STDMETHOD(getSourceLinkInfo)(THIS);

    // CDiaSession::getEnumXfgTypeHashes(IDiaEnumXfgTypeHashes**)
    // CDiaSession::getXfgTypeHash(unsigned __int64,IDiaEnumXfgTypeHashes**)

    STDMETHOD(getEnumXfgTypeHashes)(THIS, IDiaEnumXfgTypeHashes**);
    STDMETHOD(getXfgTypeHash)(THIS, ULONG64, IDiaEnumXfgTypeHashes**);

    // CDiaSession::findChildrenHelper(IDiaSymbol *,SymTagEnum,ushort const *,ulong,ulong,bool,bool,IDiaEnumSymbols * *)
    // CDiaSession::findLinesByLinenumHelper(bool,IDiaSymbol *,IDiaSourceFile *,ulong,ulong,IDiaEnumLineNumbers * *)
    // CDiaSession::findSymbolsForAcceleratorPointerTagHelper(IDiaSymbol *,ulong,ulong,bool,IDiaEnumSymbols * *)
    // CDiaSession::getMDTokenMapHelper(CDiaSession::MDTokenMapKind,ulong,ulong *,uchar *)
    // CDiaSession::getMDTokenMapHelper2(ulong,CDiaSession::MDTokenMapKind,ulong,ulong *,uchar *)
    // CDiaSession::getMDTokenRemapHelper(CDiaSession::MDTokenMapKind,ulong,ulong *,uchar *)
    // CDiaSession::getFunctionFragmentsHelper(ulong,ulong,ulong,ulong *,ulong *,ulong *)
    STDMETHOD(findChildrenHelper)(THIS);
    STDMETHOD(findLinesByLinenumHelper)(THIS);
    STDMETHOD(findSymbolsForAcceleratorPointerTagHelper)(THIS);
    STDMETHOD(getMDTokenMapHelper)(THIS);
    STDMETHOD(getMDTokenMapHelper2)(THIS);
    STDMETHOD(getMDTokenRemapHelper)(THIS);
    STDMETHOD(getFunctionFragmentsHelper)(THIS);

    END_INTERFACE
};

#endif
