/*
 * Copyright (c) 2022 Winsider Seminars & Solutions, Inc.  All rights reserved.
 *
 * This file is part of System Informer.
 *
 * Authors:
 *
 *     dmex    2015-2024
 *     TETYYS  2015-2016
 *
 */

#include "nettools.h"

CONST RESOLVED_PORT ResolvedPortsTable[] =
{
    { SREF(L"1ci-smcs"), 3091 }, { SREF(L"2ping"), 15998 }, { SREF(L"3com-amp3"), 629 }, { SREF(L"3com-net-mgmt"), 2391 },
    { SREF(L"3com-njack-1"), 5264 }, { SREF(L"3com-njack-2"), 5265 }, { SREF(L"3Com-nsd"), 1742 }, { SREF(L"3com-tsmux"), 106 },
    { SREF(L"3com-webview"), 2339 }, { SREF(L"3comfaxrpc"), 3446 }, { SREF(L"3comnetman"), 1181 }, { SREF(L"3d-nfsd"), 2323 },
    { SREF(L"3ds-lm"), 1538 }, { SREF(L"3exmp"), 5221 }, { SREF(L"3gpp-cbsp"), 48049 }, { SREF(L"3l-l1"), 1511 },
    { SREF(L"3link"), 15363 }, { SREF(L"3m-image-lm"), 1550 }, { SREF(L"3par-evts"), 5781 }, { SREF(L"3par-mgmt"), 5782 },
    { SREF(L"3par-mgmt-ssSREF(L"), 5783 }, { SREF(L"3par-rcopy"), 5785 }, { SREF(L"4-tieropmcli"), 2934 }, { SREF(L"4-tieropmgw"), 2933 },
    { SREF(L"4talk"), 3284 }, { SREF(L"6a44"), 1027 }, { SREF(L"802-11-iapp"), 3517 }, { SREF(L"914c-g"), 211 },
    { SREF(L"9pfs"), 564 }, { SREF(L"a1-bs"), 5603 }, { SREF(L"a1-msc"), 5602 }, { SREF(L"a13-an"), 3125 },
    { SREF(L"a14"), 3597 }, { SREF(L"a15"), 3598 }, { SREF(L"a16-an-an"), 4598 }, { SREF(L"a17-an-an"), 4599 },
    { SREF(L"a21-an-1xbs"), 4597 }, { SREF(L"a25-fap-fgw"), 4502 }, { SREF(L"a26-fap-fgw"), 4726 }, { SREF(L"a27-ran-ran"), 28119 },
    { SREF(L"a3-sdunode"), 5604 }, { SREF(L"a4-sdunode"), 5605 }, { SREF(L"aairnet-1"), 3618 }, { SREF(L"aairnet-2"), 3619 },
    { SREF(L"aal-lm"), 1469 }, { SREF(L"aamp"), 3939 }, { SREF(L"aap"), 2878 }, { SREF(L"aas"), 1601 },
    { SREF(L"abacus-remote"), 2894 }, { SREF(L"abarsd"), 8402 }, { SREF(L"abatemgr"), 3655 }, { SREF(L"abatjss"), 3656 },
    { SREF(L"abb-escp"), 6316 }, { SREF(L"abbaccuray"), 1546 }, { SREF(L"abbs"), 4885 }, { SREF(L"abcsoftware"), 3996 },
    { SREF(L"abcvoice-port"), 3781 }, { SREF(L"about"), 2019 }, { SREF(L"abr-api"), 1954 }, { SREF(L"abr-secure"), 1955 },
    { SREF(L"ac-cluster"), 18463 }, { SREF(L"ac-tech"), 2796 }, { SREF(L"acap"), 674 }, { SREF(L"acas"), 62 },
    { SREF(L"acc-raid"), 2800 }, { SREF(L"acceSREF(L"), 4108 }, { SREF(L"accelenet"), 1182 }, { SREF(L"accelenet-data"), 1182 },
    { SREF(L"accessbuilder"), 888 }, { SREF(L"accessnetwork"), 699 }, { SREF(L"accord-mgc"), 1205 }, { SREF(L"acctopus-cc"), 6868 },
    { SREF(L"acctopus-st"), 6868 }, { SREF(L"accu-lmgr"), 7781 }, { SREF(L"accuracer"), 12007 }, { SREF(L"accuracer-dbms"), 12008 },
    { SREF(L"acd-pm"), 8793 }, { SREF(L"ace-client"), 2334 }, { SREF(L"ace-proxy"), 2335 }, { SREF(L"ace-server"), 2475 },
    { SREF(L"ace-svr-prop"), 2476 }, { SREF(L"aci"), 187 }, { SREF(L"acis,9953,tcp"), 9953 }, { SREF(L"acis,9953,udp"), 9953 },
    { SREF(L"acl-manager"), 4013 }, { SREF(L"acmaint-dbd"), 774 }, { SREF(L"acmaint_dbd"), 774 }, { SREF(L"acmaint_transd"), 775 },
    { SREF(L"acme"), 9216 }, { SREF(L"acms"), 3980 }, { SREF(L"acmsoda"), 6969 }, { SREF(L"acnet"), 6801 },
    { SREF(L"acp"), 599 }, { SREF(L"acp-conduit"), 3823 }, { SREF(L"acp-discovery"), 3822 }, { SREF(L"acp-policy"), 3824 },
    { SREF(L"acp-port"), 2071 }, { SREF(L"acp-proto"), 4046 }, { SREF(L"acplt"), 7509 }, { SREF(L"acptsys"), 2149 },
    { SREF(L"acr-nema"), 104 }, { SREF(L"acter"), 4671 }, { SREF(L"actifio-c2c"), 5103 }, { SREF(L"actifioudsagent"), 5106 },
    { SREF(L"active-net"), 3322 }, { SREF(L"active-net"), 3324 }, { SREF(L"active-net"), 3325 }, { SREF(L"activememory"), 2859 },
    { SREF(L"activesync"), 1034 }, { SREF(L"actnet"), 5411 }, { SREF(L"ada-cip"), 2085 }, { SREF(L"adap"), 6350 },
    { SREF(L"adapt-sna"), 1365 }, { SREF(L"adaptecmgr"), 2521 }, { SREF(L"adcp"), 7508 }, { SREF(L"adi-gxp-srvprt"), 6769 },
    { SREF(L"admind"), 3279 }, { SREF(L"admind"), 8403 }, { SREF(L"admins-lms"), 2692 }, { SREF(L"adobeserver-1"), 1102 },
    { SREF(L"adobeserver-2"), 1103 }, { SREF(L"adobeserver-3"), 3703 }, { SREF(L"adobeserver-4"), 3704 }, { SREF(L"adobeserver-5"), 3705 },
    { SREF(L"adrep"), 3954 }, { SREF(L"ads"), 2550 }, { SREF(L"ads-c"), 5913 }, { SREF(L"adtech-test"), 3357 },
    { SREF(L"adtempusclient"), 3760 }, { SREF(L"advant-lm"), 2295 }, { SREF(L"adws"), 9389 }, { SREF(L"aed-512"), 149 },
    { SREF(L"aegate"), 4549 }, { SREF(L"aequus"), 23456 }, { SREF(L"aequus-alt"), 23457 }, { SREF(L"aero"), 8060 },
    { SREF(L"aeroflight-ads"), 1218 }, { SREF(L"aeroflight-ret"), 1219 }, { SREF(L"aes-discovery"), 3224 }, { SREF(L"aes-x170"), 7107 },
    { SREF(L"aesop"), 8202 }, { SREF(L"af"), 1411 }, { SREF(L"afesc-mc"), 6628 }, { SREF(L"affiliate"), 6579 },
    { SREF(L"afore-vdp-disc"), 4362 }, { SREF(L"afpovertcp"), 548 }, { SREF(L"afrog"), 1042 }, { SREF(L"afs"), 1483 },
    { SREF(L"afs3-bos"), 7007 }, { SREF(L"afs3-callback"), 7001 }, { SREF(L"afs3-errors"), 7006 }, { SREF(L"afs3-fileserver"), 7000 },
    { SREF(L"afs3-kaserver"), 7004 }, { SREF(L"afs3-prserver"), 7002 }, { SREF(L"afs3-rmtsys"), 7009 }, { SREF(L"afs3-update"), 7008 },
    { SREF(L"afs3-vlserver"), 7003 }, { SREF(L"afs3-volser"), 7005 }, { SREF(L"aftmux"), 3917 }, { SREF(L"agcat"), 3915 },
    { SREF(L"agentsease-db"), 3997 }, { SREF(L"agentview"), 2331 }, { SREF(L"agentx"), 705 }, { SREF(L"agpolicy"), 38203 },
    { SREF(L"agps-port"), 3425 }, { SREF(L"agri-gateway"), 3026 }, { SREF(L"agriserver"), 3021 }, { SREF(L"agslb"), 4149 },
    { SREF(L"ah-esp-encap"), 2070 }, { SREF(L"ahsp"), 4333 }, { SREF(L"aiagent"), 7738 }, { SREF(L"aibkup"), 4071 },
    { SREF(L"aic-np"), 2785 }, { SREF(L"aic-oncrpc"), 2786 }, { SREF(L"aicc-cmi"), 3316 }, { SREF(L"ailith"), 17555 },
    { SREF(L"aimpp-hello"), 2846 }, { SREF(L"aimpp-port-req"), 2847 }, { SREF(L"aipn-auth"), 3833 }, { SREF(L"aipn-reg"), 4113 },
    { SREF(L"aironetddp"), 2887 }, { SREF(L"airs"), 1481 }, { SREF(L"airshot"), 3975 }, { SREF(L"airsync"), 2175 },
    { SREF(L"aises"), 2783 }, { SREF(L"aja-ntv4-disc"), 4804 }, { SREF(L"aker-cdp"), 2473 }, { SREF(L"alaris-disc"), 3613 },
    { SREF(L"alarm"), 2740 }, { SREF(L"alarm-clock-c"), 2668 }, { SREF(L"alarm-clock-s"), 2667 }, { SREF(L"alchemy"), 3234 },
    { SREF(L"alesquery"), 5074 }, { SREF(L"alfin"), 16003 }, { SREF(L"alias"), 1187 }, { SREF(L"alljoyn"), 9956 },
    { SREF(L"alljoyn-mcm"), 9955 }, { SREF(L"alljoyn-stm"), 9955 }, { SREF(L"allpeers"), 36001 }, { SREF(L"allstorcns"), 2901 },
    { SREF(L"almobile-system"), 9209 }, { SREF(L"alpes"), 463 }, { SREF(L"alpha-sms"), 1849 }, { SREF(L"alphatech-lm"), 1653 },
    { SREF(L"alta-ana-lm"), 1346 }, { SREF(L"altalink"), 1845 }, { SREF(L"altav-remmgt"), 2456 }, { SREF(L"altav-tunneSREF(L"), 3265 },
    { SREF(L"altbsdp"), 7799 }, { SREF(L"altcp"), 4165 }, { SREF(L"altova-lm"), 35355 }, { SREF(L"altova-lm-disc"), 35355 },
    { SREF(L"altovacentraSREF(L"), 4689 }, { SREF(L"altserviceboot"), 4011 }, { SREF(L"amahi-anywhere"), 4563 }, { SREF(L"amanda"), 10080 },
    { SREF(L"amberon"), 8301 }, { SREF(L"ambit-lm"), 6831 }, { SREF(L"amc"), 5506 }, { SREF(L"amcs"), 8766 },
    { SREF(L"amdsched"), 1931 }, { SREF(L"amicon-fpsu-ra"), 30003 }, { SREF(L"amicon-fpsu-s"), 30004 }, { SREF(L"amiganetfs"), 2100 },
    { SREF(L"aminet"), 2639 }, { SREF(L"amp"), 3811 }, { SREF(L"ampify"), 8040 }, { SREF(L"ampl-lic"), 5195 },
    { SREF(L"ampl-tableproxy"), 5196 }, { SREF(L"ampr-info"), 1535 }, { SREF(L"ampr-inter"), 1536 }, { SREF(L"ampr-rcmd"), 459 },
    { SREF(L"amqp"), 5672 }, { SREF(L"amqps"), 5671 }, { SREF(L"ams"), 1037 }, { SREF(L"amt"), 2268 },
    { SREF(L"amt-blc-port"), 2848 }, { SREF(L"amt-cnf-prot"), 3054 }, { SREF(L"amt-esd-prot"), 1082 }, { SREF(L"amt-redir-tcp"), 16994 },
    { SREF(L"amt-redir-tls"), 16995 }, { SREF(L"amt-soap-http"), 16992 }, { SREF(L"amt-soap-https"), 16993 }, { SREF(L"amx-axbnet"), 1320 },
    { SREF(L"amx-icsp"), 1319 }, { SREF(L"amx-rms"), 3839 }, { SREF(L"amx-webadmin"), 2929 }, { SREF(L"amx-weblinx"), 2930 },
    { SREF(L"an-pcp"), 3846 }, { SREF(L"an-signaling"), 4936 }, { SREF(L"and-lm"), 2646 }, { SREF(L"anet"), 212 },
    { SREF(L"anet-b"), 3338 }, { SREF(L"anet-h"), 3341 }, { SREF(L"anet-SREF(L"), 3339 }, { SREF(L"anet-m"), 3340 },
    { SREF(L"anoto-rendezv"), 3715 }, { SREF(L"ans-console"), 3440 }, { SREF(L"ansanotify"), 116 }, { SREF(L"ansatrader"), 124 },
    { SREF(L"ansoft-lm-1"), 1083 }, { SREF(L"ansoft-lm-2"), 1084 }, { SREF(L"answersoft-lm"), 1781 }, { SREF(L"ansys-lm"), 1800 },
    { SREF(L"ansysli"), 2325 }, { SREF(L"ansyslmd"), 1055 }, { SREF(L"anthony-data"), 1206 }, { SREF(L"antidotemgrsvr"), 2247 },
    { SREF(L"aocp"), 2712 }, { SREF(L"aodv"), 654 }, { SREF(L"aoSREF(L"), 5190 }, { SREF(L"aol-1"), 5191 },
    { SREF(L"aol-2"), 5192 }, { SREF(L"aol-3"), 5193 }, { SREF(L"ap"), 47806 }, { SREF(L"apani1"), 9160 },
    { SREF(L"apani2"), 9161 }, { SREF(L"apani3"), 9162 }, { SREF(L"apani4"), 9163 }, { SREF(L"apani5"), 9164 },
    { SREF(L"apc-2160"), 2160 }, { SREF(L"apc-2161"), 2161 }, { SREF(L"apc-2260"), 2260 }, { SREF(L"apc-3052"), 3052 },
    { SREF(L"apc-3506"), 3506 }, { SREF(L"apc-5454"), 5454 }, { SREF(L"apc-5455"), 5455 }, { SREF(L"apc-5456"), 5456 },
    { SREF(L"apc-6547"), 6547 }, { SREF(L"apc-6548"), 6548 }, { SREF(L"apc-6549"), 6549 }, { SREF(L"apc-7845"), 7845 },
    { SREF(L"apc-7846"), 7846 }, { SREF(L"apc-9950"), 9950 }, { SREF(L"apc-9951"), 9951 }, { SREF(L"apc-9952"), 9952 },
    { SREF(L"apc-necmp"), 18888 }, { SREF(L"apcupsd"), 3551 }, { SREF(L"apdap"), 3948 }, { SREF(L"apertus-ldp"), 539 },
    { SREF(L"apex-edge"), 913 }, { SREF(L"apex-mesh"), 912 }, { SREF(L"aplx"), 1134 }, { SREF(L"apm-link"), 32483 },
    { SREF(L"apocd"), 3809 }, { SREF(L"apogeex-port"), 3184 }, { SREF(L"apollo-admin"), 8122 }, { SREF(L"apollo-cc"), 2754 },
    { SREF(L"apollo-data"), 8121 }, { SREF(L"apollo-gms"), 2759 }, { SREF(L"apollo-relay"), 10252 }, { SREF(L"apollo-status"), 2758 },
    { SREF(L"apparenet-as"), 3238 }, { SREF(L"apparenet-tps"), 3237 }, { SREF(L"apparenet-ts"), 3236 }, { SREF(L"apparenet-ui"), 3239 },
    { SREF(L"appiq-mgmt"), 4674 }, { SREF(L"Apple Remote Desktop (Net Assistant)"), 3283 }, { SREF(L"apple-licman"), 1381 }, { SREF(L"apple-sasSREF(L"), 3659 },
    { SREF(L"apple-vpns-rp"), 4112 }, { SREF(L"appleqtc"), 458 }, { SREF(L"appleqtcsrvr"), 545 }, { SREF(L"appleugcontroSREF(L"), 2336 },
    { SREF(L"appliance-cfg"), 2898 }, { SREF(L"applix"), 999 }, { SREF(L"applus"), 2037 }, { SREF(L"applusservice"), 4087 },
    { SREF(L"appman-server"), 3312 }, { SREF(L"appserv-http"), 4848 }, { SREF(L"appserv-https"), 4849 }, { SREF(L"appss-lm"), 3879 },
    { SREF(L"appswitch-emp"), 2616 }, { SREF(L"appworxsrv"), 2136 }, { SREF(L"apri-lm"), 1447 }, { SREF(L"aprigo-cs"), 5086 },
    { SREF(L"apsolab-coSREF(L"), 5470 }, { SREF(L"apsolab-cols"), 5471 }, { SREF(L"apsolab-data"), 5475 }, { SREF(L"apsolab-rpc"), 5474 },
    { SREF(L"apsolab-tag"), 5472 }, { SREF(L"apsolab-tags"), 5473 }, { SREF(L"apw-registry"), 3758 }, { SREF(L"apwi-disc"), 4394 },
    { SREF(L"apwi-imserver"), 4391 }, { SREF(L"apwi-rxserver"), 4392 }, { SREF(L"apwi-rxspooler"), 4393 }, { SREF(L"apx500api-1"), 2264 },
    { SREF(L"apx500api-2"), 2265 }, { SREF(L"arbortext-lm"), 1557 }, { SREF(L"arcisdms"), 262 }, { SREF(L"arcp"), 7070 },
    { SREF(L"arcpd"), 3513 }, { SREF(L"ardt"), 1826 }, { SREF(L"ardus-cntSREF(L"), 1116 }, { SREF(L"ardus-mtrns"), 1117 },
    { SREF(L"ardus-trns"), 1115 }, { SREF(L"ardusmuSREF(L"), 1835 }, { SREF(L"ardusuni"), 1834 }, { SREF(L"areaguard-neo"), 23546 },
    { SREF(L"arena-server"), 11321 }, { SREF(L"arepa-cas"), 3030 }, { SREF(L"arepa-raft"), 3025 }, { SREF(L"argis-ds"), 2582 },
    { SREF(L"argis-te"), 2581 }, { SREF(L"aria"), 2624 }, { SREF(L"ariel1"), 419 }, { SREF(L"ariel2"), 421 },
    { SREF(L"ariel3"), 422 }, { SREF(L"aries-kfinder"), 7570 }, { SREF(L"ariliamulti"), 3140 }, { SREF(L"arkivio"), 3426 },
    { SREF(L"armadp"), 1913 }, { SREF(L"armagetronad"), 4534 }, { SREF(L"armcenterhttp"), 9294 }, { SREF(L"armcenterhttps"), 9295 },
    { SREF(L"armi-server"), 3174 }, { SREF(L"armtechdaemon"), 9292 }, { SREF(L"arns"), 384 }, { SREF(L"array-manager"), 3726 },
    { SREF(L"ars-master"), 3176 }, { SREF(L"ars-vista"), 27782 }, { SREF(L"artifact-msg"), 3518 }, { SREF(L"aruba-server"), 7166 },
    { SREF(L"as-debug"), 4026 }, { SREF(L"as-servermap"), 449 }, { SREF(L"asa"), 386 }, { SREF(L"asam"), 3451 },
    { SREF(L"asap-sctp"), 3863 }, { SREF(L"asap-sctp-tls"), 3864 }, { SREF(L"asap-tcp"), 3863 }, { SREF(L"asap-tcp-tls"), 3864 },
    { SREF(L"asap-udp"), 3863 }, { SREF(L"asc-slmd"), 4448 }, { SREF(L"asci-vaSREF(L"), 1560 }, { SREF(L"ascomalarm"), 4077 },
    { SREF(L"asctrl-agent"), 5155 }, { SREF(L"asdis"), 2192 }, { SREF(L"asf-rmcp"), 623 }, { SREF(L"asf-secure-rmcp"), 664 },
    { SREF(L"asgcypresstcps"), 11489 }, { SREF(L"asgenf"), 5727 }, { SREF(L"asi"), 1827 }, { SREF(L"asia"), 626 },
    { SREF(L"asihpi"), 44600 }, { SREF(L"asip-webadmin"), 311 }, { SREF(L"asipregistry"), 687 }, { SREF(L"asmp"), 45000 },
    { SREF(L"asmp-mon"), 45000 }, { SREF(L"asmps"), 45001 }, { SREF(L"asnaacceler8db"), 5042 }, { SREF(L"asoki-sma"), 3087 },
    { SREF(L"aspcoordination"), 7235 }, { SREF(L"aspeclmd"), 1544 }, { SREF(L"aspen-services"), 1749 }, { SREF(L"aspentec-lm"), 6142 },
    { SREF(L"asprovatalk"), 1079 }, { SREF(L"asr"), 7800 }, { SREF(L"assoc-disc"), 24850 }, { SREF(L"assuria-ins"), 4704 },
    { SREF(L"assuria-slm"), 4119 }, { SREF(L"assyst-dr"), 4485 }, { SREF(L"astergate"), 9106 }, { SREF(L"astergate-disc"), 9106 },
    { SREF(L"astergatefax"), 9107 }, { SREF(L"asterix"), 8600 }, { SREF(L"astrolink"), 27876 }, { SREF(L"astromed-main"), 2864 },
    { SREF(L"at-3"), 203 }, { SREF(L"at-5"), 205 }, { SREF(L"at-7"), 207 }, { SREF(L"at-8"), 208 },
    { SREF(L"at-echo"), 204 }, { SREF(L"at-nbp"), 202 }, { SREF(L"at-rtmp"), 201 }, { SREF(L"at-zis"), 206 },
    { SREF(L"atc-appserver"), 1171 }, { SREF(L"atc-lm"), 1170 }, { SREF(L"atex-elmd"), 1385 }, { SREF(L"athand-mmp"), 20999 },
    { SREF(L"ati-ip-to-ncpe"), 3965 }, { SREF(L"atlinks"), 4154 }, { SREF(L"atm-uhas"), 11367 }, { SREF(L"atm-zip-office"), 1520 },
    { SREF(L"atmp"), 5150 }, { SREF(L"atmtcp"), 2812 }, { SREF(L"ats"), 2201 }, { SREF(L"atsc-mh-ssc"), 4937 },
    { SREF(L"att-mt-sms"), 5586 }, { SREF(L"attachmate-g32"), 2317 }, { SREF(L"attachmate-s2s"), 2419 }, { SREF(L"attachmate-uts"), 2304 },
    { SREF(L"atuSREF(L"), 7543 }, { SREF(L"audio-activmaiSREF(L"), 1397 }, { SREF(L"audiojuggler"), 3643 }, { SREF(L"audit"), 182 },
    { SREF(L"audit-transfer"), 1146 }, { SREF(L"auditd"), 48 }, { SREF(L"aura"), 2066 }, { SREF(L"auriga-router"), 5680 },
    { SREF(L"auris"), 2772 }, { SREF(L"aurora"), 9084 }, { SREF(L"aurora-balaena"), 33123 }, { SREF(L"aurora-cmgr"), 364 },
    { SREF(L"aurp"), 387 }, { SREF(L"auth"), 113 }, { SREF(L"authentx"), 5067 }, { SREF(L"autobuild"), 5115 },
    { SREF(L"autocueds"), 3437 }, { SREF(L"autocuelog"), 3104 }, { SREF(L"autocuesmi"), 3103 }, { SREF(L"autocuetime"), 3104 },
    { SREF(L"autodesk-lm"), 1422 }, { SREF(L"autodesk-nlm"), 2080 }, { SREF(L"autonoc"), 1140 }, { SREF(L"autopac"), 4685 },
    { SREF(L"autotrac-acp"), 31020 }, { SREF(L"av-emb-config"), 2050 }, { SREF(L"availant-mgr"), 1122 }, { SREF(L"avantageb2b"), 2131 },
    { SREF(L"avanti-cdp"), 4065 }, { SREF(L"avauthsrvprtcSREF(L"), 2068 }, { SREF(L"avdecc"), 17221 }, { SREF(L"avenue"), 2134 },
    { SREF(L"avenyo"), 2992 }, { SREF(L"avian"), 486 }, { SREF(L"avinstalldisc"), 3502 }, { SREF(L"aviva-sna"), 2238 },
    { SREF(L"avocent-adsap"), 3871 }, { SREF(L"avocent-proxy"), 1078 }, { SREF(L"avsecuremgmt"), 3211 }, { SREF(L"avt-profile-1"), 5004 },
    { SREF(L"avt-profile-2"), 5005 }, { SREF(L"avtp"), 17220 }, { SREF(L"awacs-ice"), 4488 }, { SREF(L"awg-proxy"), 3277 },
    { SREF(L"aws-brf"), 22800 }, { SREF(L"axis-wimp-port"), 10260 }, { SREF(L"axon-lm"), 1548 }, { SREF(L"axon-tunneSREF(L"), 16665 },
    { SREF(L"ayiya"), 5072 }, { SREF(L"azeti"), 4192 }, { SREF(L"azeti-bd"), 4192 }, { SREF(L"aztec"), 3512 },
    { SREF(L"b-novative-ls"), 1896 }, { SREF(L"b2-license"), 2204 }, { SREF(L"b2-runtime"), 2203 }, { SREF(L"b2n"), 1179 },
    { SREF(L"babeSREF(L"), 6696 }, { SREF(L"backburner"), 2635 }, { SREF(L"backroomnet"), 3387 }, { SREF(L"backup-express"), 6123 },
    { SREF(L"backupedge"), 3946 }, { SREF(L"bacnet"), 47808 }, { SREF(L"bacula-dir"), 9101 }, { SREF(L"bacula-fd"), 9102 },
    { SREF(L"bacula-sd"), 9103 }, { SREF(L"badm-priv"), 6505 }, { SREF(L"badm-pub"), 6506 }, { SREF(L"bandwiz-system"), 1929 },
    { SREF(L"banyan-net"), 2708 }, { SREF(L"banyan-rpc"), 567 }, { SREF(L"banyan-vip"), 573 }, { SREF(L"barracuda-bbs"), 5120 },
    { SREF(L"base"), 5429 }, { SREF(L"batman"), 4305 }, { SREF(L"bb"), 1984 }, { SREF(L"bbars"), 3327 },
    { SREF(L"bbn-mmc"), 1347 }, { SREF(L"bbn-mmx"), 1348 }, { SREF(L"bccp"), 4175 }, { SREF(L"bcinameservice"), 3415 },
    { SREF(L"bcs"), 4677 }, { SREF(L"bcs-broker"), 1704 }, { SREF(L"bcs-lmserver"), 1951 }, { SREF(L"bcslogc"), 13216 },
    { SREF(L"bctp"), 8999 }, { SREF(L"bctp-server"), 10107 }, { SREF(L"bdir-priv"), 6507 }, { SREF(L"bdir-pub"), 6508 },
    { SREF(L"bdir_pub"), 6508 }, { SREF(L"bdp"), 581 }, { SREF(L"beacon-port"), 3124 }, { SREF(L"beacon-port-2"), 4426 },
    { SREF(L"bears-01"), 2852 }, { SREF(L"bears-02"), 3146 }, { SREF(L"beeyond"), 2414 }, { SREF(L"beeyond-media"), 1943 },
    { SREF(L"beorSREF(L"), 5633 }, { SREF(L"berknet"), 2005 }, { SREF(L"BESApi"), 3408 }, { SREF(L"beserver-msg-q"), 3527 },
    { SREF(L"bess"), 3960 }, { SREF(L"bex-webadmin"), 6122 }, { SREF(L"bex-xr"), 15660 }, { SREF(L"beyond-remote"), 5424 },
    { SREF(L"bf-game"), 25954 }, { SREF(L"bf-master"), 25955 }, { SREF(L"bfd-controSREF(L"), 3784 }, { SREF(L"bfd-echo"), 3785 },
    { SREF(L"bfd-lag"), 6784 }, { SREF(L"bfd-multi-ctSREF(L"), 4784 }, { SREF(L"bflckmgr"), 3966 }, { SREF(L"bftp"), 152 },
    { SREF(L"bgmp"), 264 }, { SREF(L"bgp"), 179 }, { SREF(L"bgs-nsi"), 482 }, { SREF(L"bh611"), 354 },
    { SREF(L"bhevent"), 357 }, { SREF(L"bhfhs"), 248 }, { SREF(L"bhmds"), 310 }, { SREF(L"bhoedap4"), 352 },
    { SREF(L"bhoetty"), 351 }, { SREF(L"biap-mp"), 1962 }, { SREF(L"biff"), 512 }, { SREF(L"biimenu"), 18000 },
    { SREF(L"bilobit"), 24577 }, { SREF(L"bilobit-update"), 24577 }, { SREF(L"bim-pem"), 3783 }, { SREF(L"binderysupport"), 2302 },
    { SREF(L"bingbang"), 29999 }, { SREF(L"binkp"), 24554 }, { SREF(L"bintec-admin"), 2107 }, { SREF(L"bintec-capi"), 2662 },
    { SREF(L"bintec-tapi"), 2663 }, { SREF(L"biolink-auth"), 3411 }, { SREF(L"bioserver"), 6946 }, { SREF(L"biotic"), 5087 },
    { SREF(L"bip"), 4376 }, { SREF(L"bis-sync"), 5585 }, { SREF(L"bis-web"), 5584 }, { SREF(L"bitforestsrv"), 5068 },
    { SREF(L"bitspeer"), 2178 }, { SREF(L"bl-idm"), 142 }, { SREF(L"blackboard"), 2032 }, { SREF(L"blackjack"), 1025 },
    { SREF(L"blaze"), 1150 }, { SREF(L"blizwow"), 3724 }, { SREF(L"blockade"), 2911 }, { SREF(L"blockade-bpsp"), 2574 },
    { SREF(L"blocks"), 10288 }, { SREF(L"blp1"), 8194 }, { SREF(L"blp2"), 8195 }, { SREF(L"blp3"), 8292 },
    { SREF(L"blp4"), 8294 }, { SREF(L"blp5"), 48129 }, { SREF(L"blueberry-lm"), 1432 }, { SREF(L"bluectrlproxy"), 2277 },
    { SREF(L"bluelance"), 2877 }, { SREF(L"blwnkl-port"), 2625 }, { SREF(L"bmap"), 3421 }, { SREF(L"bmc-ar"), 2494 },
    { SREF(L"bmc-ctd-ldap"), 6301 }, { SREF(L"bmc-data-colSREF(L"), 3695 }, { SREF(L"bmc-ea"), 3683 }, { SREF(L"bmc-gms"), 10129 },
    { SREF(L"bmc-grx"), 6300 }, { SREF(L"bmc-jmx-port"), 3604 }, { SREF(L"bmc-messaging"), 2059 }, { SREF(L"bmc-net-adm"), 1769 },
    { SREF(L"bmc-net-svc"), 1770 }, { SREF(L"bmc-onekey"), 3561 }, { SREF(L"bmc-patroldb"), 1313 }, { SREF(L"bmc-perf-agent"), 6767 },
    { SREF(L"bmc-perf-mgrd"), 6768 }, { SREF(L"bmc-perf-sd"), 10128 }, { SREF(L"bmc-reporting"), 4568 }, { SREF(L"bmcpatrolagent"), 3181 },
    { SREF(L"bmcpatrolrnvu"), 3182 }, { SREF(L"bmdss"), 13823 }, { SREF(L"bmpp"), 632 }, { SREF(L"bnet"), 415 },
    { SREF(L"bnetfile"), 1120 }, { SREF(L"bnetgame"), 1119 }, { SREF(L"bngsync"), 10439 }, { SREF(L"bnt-manager"), 3344 },
    { SREF(L"board-roar"), 9700 }, { SREF(L"board-voip"), 9750 }, { SREF(L"boe-cachesvr"), 6403 }, { SREF(L"boe-cms"), 6400 },
    { SREF(L"boe-eventsrv"), 6402 }, { SREF(L"boe-filesvr"), 6404 }, { SREF(L"boe-pagesvr"), 6405 }, { SREF(L"boe-processsvr"), 6406 },
    { SREF(L"boe-resssvr1"), 6407 }, { SREF(L"boe-resssvr2"), 6408 }, { SREF(L"boe-resssvr3"), 6409 }, { SREF(L"boe-resssvr4"), 6410 },
    { SREF(L"boe-was"), 6401 }, { SREF(L"boinc-client"), 1043 }, { SREF(L"boks"), 6500 }, { SREF(L"boks-clntd"), 6503 },
    { SREF(L"boks-servc"), 6501 }, { SREF(L"boks-servm"), 6502 }, { SREF(L"boldsoft-lm"), 2961 }, { SREF(L"bones"), 4914 },
    { SREF(L"boomerang"), 1304 }, { SREF(L"boosterware"), 2913 }, { SREF(L"bootclient"), 2017 }, { SREF(L"bootpc"), 68 },
    { SREF(L"bootps"), 67 }, { SREF(L"bootserver"), 2016 }, { SREF(L"borland-dsj"), 707 }, { SREF(L"boscap"), 2990 },
    { SREF(L"bounzza"), 2218 }, { SREF(L"boxbackupstore"), 4186 }, { SREF(L"boxp"), 9380 }, { SREF(L"bpcd"), 13782 },
    { SREF(L"bpcp-polSREF(L"), 2844 }, { SREF(L"bpcp-trap"), 2845 }, { SREF(L"bpdbm"), 13721 }, { SREF(L"bpjava-msvc"), 13722 },
    { SREF(L"bpmd"), 3593 }, { SREF(L"bprd"), 13720 }, { SREF(L"br-channeSREF(L"), 5425 }, { SREF(L"brain"), 2169 },
    { SREF(L"brcd"), 1323 }, { SREF(L"brcm-comm-port"), 3188 }, { SREF(L"brdptc"), 2155 }, { SREF(L"bre"), 4096 },
    { SREF(L"brf-gw"), 22951 }, { SREF(L"bridgecontroSREF(L"), 1073 }, { SREF(L"brightcore"), 5682 }, { SREF(L"brlp-0"), 4101 },
    { SREF(L"brlp-1"), 4102 }, { SREF(L"brlp-2"), 4103 }, { SREF(L"brlp-3"), 4104 }, { SREF(L"broker-service"), 3014 },
    { SREF(L"brp"), 3043 }, { SREF(L"bruce"), 2619 }, { SREF(L"brutus"), 2003 }, { SREF(L"brvread"), 1054 },
    { SREF(L"bsfserver-zn"), 5320 }, { SREF(L"bsfsvr-zn-ssSREF(L"), 5321 }, { SREF(L"bspne-pcc"), 1252 }, { SREF(L"bsquare-voip"), 1071 },
    { SREF(L"btpp2audctr1"), 2536 }, { SREF(L"btpp2sectrans"), 2444 }, { SREF(L"btprjctrSREF(L"), 2803 }, { SREF(L"btrieve"), 3351 },
    { SREF(L"bts-appserver"), 1961 }, { SREF(L"bts-x73"), 3681 }, { SREF(L"buddy-draw"), 1854 }, { SREF(L"bues-service"), 2446 },
    { SREF(L"bullant-rap"), 2965 }, { SREF(L"bullant-srap"), 2964 }, { SREF(L"busboy"), 998 }, { SREF(L"buschtrommeSREF(L"), 4747 },
    { SREF(L"business"), 3107 }, { SREF(L"busycaSREF(L"), 4990 }, { SREF(L"bv-agent"), 3993 }, { SREF(L"bv-ds"), 3992 },
    { SREF(L"bv-is"), 3990 }, { SREF(L"bv-queryengine"), 3989 }, { SREF(L"bv-smcsrv"), 3991 }, { SREF(L"bvcdaemon-port"), 3626 },
    { SREF(L"bvcontroSREF(L"), 1236 }, { SREF(L"bveapi"), 10880 }, { SREF(L"bvtsonar"), 1149 }, { SREF(L"bxp"), 4027 },
    { SREF(L"bytex"), 1375 }, { SREF(L"bzflag"), 5154 }, { SREF(L"bzr"), 4155 }, { SREF(L"c-h-it-port"), 3778 },
    { SREF(L"c1222-acse"), 1153 }, { SREF(L"c3"), 2472 }, { SREF(L"ca-1"), 5064 }, { SREF(L"ca-2"), 5065 },
    { SREF(L"ca-audit-da"), 8025 }, { SREF(L"ca-audit-ds"), 8026 }, { SREF(L"ca-idms"), 3709 }, { SREF(L"ca-web-update"), 14414 },
    { SREF(L"caaclang2"), 5249 }, { SREF(L"caacws"), 5248 }, { SREF(L"cab-protocoSREF(L"), 595 }, { SREF(L"cableport-ax"), 282 },
    { SREF(L"cabsm-comm"), 7161 }, { SREF(L"caci-lm"), 1554 }, { SREF(L"cacsambroker"), 7163 }, { SREF(L"cadabra-lm"), 1563 },
    { SREF(L"cadencecontroSREF(L"), 2318 }, { SREF(L"cadis-1"), 1441 }, { SREF(L"cadis-2"), 1442 }, { SREF(L"cadkey-licman"), 1399 },
    { SREF(L"cadkey-tablet"), 1400 }, { SREF(L"cadlock"), 770 }, { SREF(L"cadlock2"), 1000 }, { SREF(L"cadsi-lm"), 1387 },
    { SREF(L"cadview-3d"), 649 }, { SREF(L"caerpc"), 42510 }, { SREF(L"caevms"), 5251 }, { SREF(L"caicci"), 1721 },
    { SREF(L"caiccipc"), 1202 }, { SREF(L"caids-sensor"), 1192 }, { SREF(L"CAIlic"), 216 }, { SREF(L"caistoragemgr"), 7162 },
    { SREF(L"cajo-discovery"), 1198 }, { SREF(L"caSREF(L"), 588 }, { SREF(L"caldsoft-backup"), 22537 }, { SREF(L"call-logging"), 2552 },
    { SREF(L"call-sig-trans"), 2517 }, { SREF(L"caller9"), 2906 }, { SREF(L"calltrax"), 3675 }, { SREF(L"callwaveiam"), 9283 },
    { SREF(L"camac"), 3545 }, { SREF(L"cambertx-lm"), 1734 }, { SREF(L"camp"), 4450 }, { SREF(L"can-dch"), 1919 },
    { SREF(L"can-ferret"), 1920 }, { SREF(L"can-ferret-ssSREF(L"), 3661 }, { SREF(L"can-nds"), 1918 }, { SREF(L"can-nds-ssSREF(L"), 3660 },
    { SREF(L"canditv"), 24676 }, { SREF(L"candp"), 42508 }, { SREF(L"candrp"), 42509 }, { SREF(L"canex-watch"), 3583 },
    { SREF(L"canit_store"), 6568 }, { SREF(L"canocentral0"), 1871 }, { SREF(L"canocentral1"), 1872 }, { SREF(L"canon-bjnp1"), 8611 },
    { SREF(L"canon-bjnp2"), 8612 }, { SREF(L"canon-bjnp3"), 8613 }, { SREF(L"canon-bjnp4"), 8614 }, { SREF(L"canon-capt"), 3756 },
    { SREF(L"canon-cpp-disc"), 8609 }, { SREF(L"canon-mfnp"), 8610 }, { SREF(L"canto-roboflow"), 8998 }, { SREF(L"cap"), 1026 },
    { SREF(L"capfast-lmd"), 1756 }, { SREF(L"capioverlan"), 1147 }, { SREF(L"capmux"), 4728 }, { SREF(L"caps-lm"), 3290 },
    { SREF(L"capwap-controSREF(L"), 5246 }, { SREF(L"capwap-data"), 5247 }, { SREF(L"car"), 5090 }, { SREF(L"cardax"), 1072 },
    { SREF(L"cardbox"), 3105 }, { SREF(L"cardbox-http"), 3106 }, { SREF(L"carrius-rshelSREF(L"), 1197 }, { SREF(L"cart-o-rama"), 3292 },
    { SREF(L"cartographerxmp"), 5270 }, { SREF(L"cas"), 2418 }, { SREF(L"cas-mapi"), 3682 }, { SREF(L"casanswmgmt"), 3669 },
    { SREF(L"casp"), 1130 }, { SREF(L"caspssSREF(L"), 1131 }, { SREF(L"casrmagent"), 7167 }, { SREF(L"castorproxy"), 3450 },
    { SREF(L"catalyst"), 2836 }, { SREF(L"catchpole"), 1185 }, { SREF(L"caupc-remote"), 2122 }, { SREF(L"cautcpd"), 3061 },
    { SREF(L"cawas"), 12168 }, { SREF(L"cba8"), 9593 }, { SREF(L"cbos-ip-port"), 3750 }, { SREF(L"cbserver"), 3388 },
    { SREF(L"cbt"), 7777 }, { SREF(L"cc-tracking"), 4870 }, { SREF(L"ccag-pib"), 7169 }, { SREF(L"ccm-port"), 3575 },
    { SREF(L"ccmad"), 3114 }, { SREF(L"ccmaiSREF(L"), 3264 }, { SREF(L"ccmcomm"), 3505 }, { SREF(L"ccmrmi"), 3154 },
    { SREF(L"ccnx"), 9695 }, { SREF(L"ccowcmr"), 2116 }, { SREF(L"ccp"), 3947 }, { SREF(L"ccs-software"), 2734 },
    { SREF(L"ccss-qmm"), 4969 }, { SREF(L"ccss-qsm"), 4970 }, { SREF(L"cctv-port"), 3559 }, { SREF(L"ccu-comm-1"), 4053 },
    { SREF(L"ccu-comm-2"), 4054 }, { SREF(L"ccu-comm-3"), 4055 }, { SREF(L"cd3o-protocoSREF(L"), 3616 }, { SREF(L"cdbroker"), 3376 },
    { SREF(L"cdc"), 223 }, { SREF(L"cddbp"), 888 }, { SREF(L"cddbp-alt"), 8880 }, { SREF(L"cdfunc"), 2045 },
    { SREF(L"cdid"), 3315 }, { SREF(L"cdl-server"), 3056 }, { SREF(L"cdn"), 2412 }, { SREF(L"cds"), 4115 },
    { SREF(L"cecsvc"), 2571 }, { SREF(L"cedros-fds"), 4140 }, { SREF(L"cefd-vmp"), 10023 }, { SREF(L"celatalk"), 3485 },
    { SREF(L"centerline"), 3987 }, { SREF(L"centra"), 1709 }, { SREF(L"cequint-cityid"), 4074 }, { SREF(L"cera-bcm"), 1794 },
    { SREF(L"cernsysmgmtagt"), 3830 }, { SREF(L"cert-initiator"), 1639 }, { SREF(L"cert-responder"), 1640 }, { SREF(L"cesdcdman"), 2921 },
    { SREF(L"cesdcdtrn"), 2922 }, { SREF(L"cesdinv"), 2856 }, { SREF(L"cfdptkt"), 120 }, { SREF(L"cfengine"), 5308 },
    { SREF(L"cfs"), 7546 }, { SREF(L"cft-0"), 1761 }, { SREF(L"cft-1"), 1762 }, { SREF(L"cft-2"), 1763 },
    { SREF(L"cft-3"), 1764 }, { SREF(L"cft-4"), 1765 }, { SREF(L"cft-5"), 1766 }, { SREF(L"cft-6"), 1767 },
    { SREF(L"cft-7"), 1768 }, { SREF(L"cfw"), 7563 }, { SREF(L"cgi-starapi"), 3893 }, { SREF(L"cgms"), 3003 },
    { SREF(L"cgn-config"), 2183 }, { SREF(L"cgn-stat"), 2182 }, { SREF(L"chargen"), 19 }, { SREF(L"charsetmgr"), 3903 },
    { SREF(L"checkoutdb"), 5505 }, { SREF(L"checkpoint-rtm"), 18241 }, { SREF(L"checksum"), 1386 }, { SREF(L"chevinservices"), 3349 },
    { SREF(L"childkey-ctrSREF(L"), 1892 }, { SREF(L"childkey-notif"), 1891 }, { SREF(L"chimera-hwm"), 4009 }, { SREF(L"chip-lm"), 1572 },
    { SREF(L"chipper"), 17219 }, { SREF(L"chmd"), 3099 }, { SREF(L"choiceview-agt"), 4314 }, { SREF(L"choiceview-clt"), 4316 },
    { SREF(L"chromagrafx"), 1373 }, { SREF(L"chshelSREF(L"), 562 }, { SREF(L"ci3-software-1"), 1301 }, { SREF(L"ci3-software-2"), 1302 },
    { SREF(L"cichild-lm"), 1523 }, { SREF(L"cichlid"), 1377 }, { SREF(L"cifs"), 3020 }, { SREF(L"cim-rs"), 5993 },
    { SREF(L"cimple"), 10125 }, { SREF(L"cimplex"), 673 }, { SREF(L"cimtrak"), 3749 }, { SREF(L"cindycollab"), 3770 },
    { SREF(L"cinegrfx-elmd"), 2891 }, { SREF(L"cinegrfx-lm"), 1743 }, { SREF(L"ciphire-data"), 3887 }, { SREF(L"ciphire-serv"), 3888 },
    { SREF(L"circle-x"), 2931 }, { SREF(L"cis"), 22305 }, { SREF(L"cis-secure"), 22343 }, { SREF(L"cisco-avp"), 8470 },
    { SREF(L"cisco-fna"), 130 }, { SREF(L"cisco-ipsla"), 1167 }, { SREF(L"cisco-net-mgmt"), 1741 }, { SREF(L"cisco-redu"), 5786 },
    { SREF(L"cisco-sccp"), 2000 }, { SREF(L"cisco-snat"), 15555 }, { SREF(L"cisco-sys"), 132 }, { SREF(L"cisco-tdp"), 711 },
    { SREF(L"cisco-tna"), 131 }, { SREF(L"cisco-vpath-tun"), 6633 }, { SREF(L"cisco-wafs"), 4050 }, { SREF(L"ciscocsdb"), 43441 },
    { SREF(L"citadeSREF(L"), 504 }, { SREF(L"citrix-rtmp"), 2897 }, { SREF(L"citrixadmin"), 2513 }, { SREF(L"citrixima"), 2512 },
    { SREF(L"citriximaclient"), 2598 }, { SREF(L"citrixupp"), 7228 }, { SREF(L"citrixuppg"), 7229 }, { SREF(L"citynSREF(L"), 1729 },
    { SREF(L"citysearch"), 3974 }, { SREF(L"cl-1"), 172 }, { SREF(L"cl-db-attach"), 4135 }, { SREF(L"cl-db-remote"), 4137 },
    { SREF(L"cl-db-request"), 4136 }, { SREF(L"cl/1"), 172 }, { SREF(L"clariion-evr01"), 6389 }, { SREF(L"classic"), 9087 },
    { SREF(L"cleanerliverc"), 3481 }, { SREF(L"clearcase"), 371 }, { SREF(L"clearvisn"), 2052 }, { SREF(L"clever-ctrace"), 6687 },
    { SREF(L"clever-tcpip"), 6688 }, { SREF(L"cleverdetect"), 6690 }, { SREF(L"client-ctrSREF(L"), 3730 }, { SREF(L"client-wakeup"), 9694 },
    { SREF(L"cloanto-lm"), 3397 }, { SREF(L"cloanto-net-1"), 356 }, { SREF(L"close-combat"), 1944 }, { SREF(L"cloudsignaling"), 7550 },
    { SREF(L"clp"), 2567 }, { SREF(L"cluster-disc"), 3374 }, { SREF(L"clusterxSREF(L"), 18243 }, { SREF(L"clutild"), 7174 },
    { SREF(L"clvm-cfg"), 1476 }, { SREF(L"cm"), 5910 }, { SREF(L"cma"), 1050 }, { SREF(L"cmadmin"), 2617 },
    { SREF(L"cmc-port"), 3576 }, { SREF(L"cmip-agent"), 164 }, { SREF(L"cmip-man"), 163 }, { SREF(L"cmmdriver"), 1294 },
    { SREF(L"cmtp-av"), 8501 }, { SREF(L"cmtp-mgt"), 8501 }, { SREF(L"cnap"), 7262 }, { SREF(L"cnckadserver"), 7168 },
    { SREF(L"cncp"), 4785 }, { SREF(L"cnhrp"), 1757 }, { SREF(L"cnrp"), 2757 }, { SREF(L"cnrprotocoSREF(L"), 1096 },
    { SREF(L"cns-srv-port"), 2976 }, { SREF(L"coap"), 5683 }, { SREF(L"coaps"), 5684 }, { SREF(L"coauthor"), 1529 },
    { SREF(L"codaauth2"), 370 }, { SREF(L"codasrv"), 2432 }, { SREF(L"codasrv-se"), 2433 }, { SREF(L"codemeter"), 22350 },
    { SREF(L"codemeter-cmwan"), 22351 }, { SREF(L"codima-rtp"), 2415 }, { SREF(L"cogitate"), 3039 }, { SREF(L"cognex-dataman"), 44444 },
    { SREF(L"cognex-insight"), 1069 }, { SREF(L"cognima"), 3779 }, { SREF(L"cogsys-lm"), 3377 }, { SREF(L"coherence"), 7574 },
    { SREF(L"coherence-disc"), 7574 }, { SREF(L"collaber"), 7689 }, { SREF(L"collaborator"), 622 }, { SREF(L"colubris"), 3490 },
    { SREF(L"com-bardac-dw"), 48556 }, { SREF(L"combox-web-acc"), 2534 }, { SREF(L"comcam"), 2108 }, { SREF(L"comcam-io"), 3605 },
    { SREF(L"commandport"), 3416 }, { SREF(L"commerce"), 542 }, { SREF(L"commlinx-avSREF(L"), 1190 }, { SREF(L"commonspace"), 1592 },
    { SREF(L"commplex-link"), 5001 }, { SREF(L"commplex-main"), 5000 }, { SREF(L"commtact-http"), 20002 }, { SREF(L"commtact-https"), 20003 },
    { SREF(L"community"), 2459 }, { SREF(L"comotionback"), 2262 }, { SREF(L"comotionmaster"), 2261 }, { SREF(L"compaq-evm"), 619 },
    { SREF(L"compaq-https"), 2381 }, { SREF(L"compaq-scp"), 2766 }, { SREF(L"compaq-wcp"), 2555 }, { SREF(L"composit-server"), 2417 },
    { SREF(L"compressnet"), 2 }, { SREF(L"compressnet"), 3 }, { SREF(L"compx-lockview"), 4308 }, { SREF(L"comsat"), 512 },
    { SREF(L"comscm"), 437 }, { SREF(L"con"), 759 }, { SREF(L"conclave-cpp"), 2491 }, { SREF(L"concomp1"), 1802 },
    { SREF(L"concurrent-lm"), 1648 }, { SREF(L"condor"), 9618 }, { SREF(L"conductor"), 6970 }, { SREF(L"conductor-mpx"), 6970 },
    { SREF(L"conf"), 2008 }, { SREF(L"conference"), 531 }, { SREF(L"conferencetalk"), 1713 }, { SREF(L"config-port"), 3577 },
    { SREF(L"confluent"), 1484 }, { SREF(L"connect"), 2137 }, { SREF(L"connect-client"), 3441 }, { SREF(L"connect-server"), 3442 },
    { SREF(L"connected"), 16384 }, { SREF(L"connection"), 2607 }, { SREF(L"connendp"), 693 }, { SREF(L"connlcli"), 1358 },
    { SREF(L"conspiracy"), 4692 }, { SREF(L"consul-insight"), 5992 }, { SREF(L"contamac-icm"), 4846 }, { SREF(L"contclientms"), 4665 },
    { SREF(L"contentserver"), 3365 }, { SREF(L"contentserver"), 454 }, { SREF(L"continuus"), 5412 }, { SREF(L"controlone-con"), 7551 },
    { SREF(L"coord-svr"), 2565 }, { SREF(L"cops"), 3288 }, { SREF(L"cops-tls"), 3183 }, { SREF(L"copy"), 8445 },
    { SREF(L"copy-disc"), 8445 }, { SREF(L"copycat"), 9093 }, { SREF(L"corba-iiop"), 683 }, { SREF(L"corba-iiop-ssSREF(L"), 684 },
    { SREF(L"corbaloc"), 2809 }, { SREF(L"corel-vncadmin"), 2654 }, { SREF(L"corelccam"), 4300 }, { SREF(L"corelvideo"), 1566 },
    { SREF(L"corerjd"), 284 }, { SREF(L"cosir"), 10321 }, { SREF(L"cosmocalSREF(L"), 2324 }, { SREF(L"couchdb"), 5984 },
    { SREF(L"courier"), 530 }, { SREF(L"covia"), 64 }, { SREF(L"cp-cluster"), 8116 }, { SREF(L"cp-spxdpy"), 4378 },
    { SREF(L"cp-spxrpts"), 5079 }, { SREF(L"cp-spxsvr"), 4377 }, { SREF(L"cpdi-pidas-cm"), 3609 }, { SREF(L"cpdlc"), 5911 },
    { SREF(L"cplscrambler-aSREF(L"), 1088 }, { SREF(L"cplscrambler-in"), 1087 }, { SREF(L"cplscrambler-lg"), 1086 }, { SREF(L"cppdp"), 4051 },
    { SREF(L"cpq-tasksmart"), 3201 }, { SREF(L"cpq-wbem"), 2301 }, { SREF(L"cpqrpm-agent"), 3256 }, { SREF(L"cpqrpm-server"), 3257 },
    { SREF(L"cps"), 14250 }, { SREF(L"cpscomm"), 5194 }, { SREF(L"cpsp"), 17222 }, { SREF(L"cpudpencap"), 2746 },
    { SREF(L"cqg-netlan"), 2823 }, { SREF(L"cqg-netlan-1"), 2824 }, { SREF(L"cr-websystems"), 2314 }, { SREF(L"creativepartnr"), 3366 },
    { SREF(L"creativepartnr"), 455 }, { SREF(L"creativeserver"), 3364 }, { SREF(L"creativeserver"), 453 }, { SREF(L"cresco-controSREF(L"), 38002 },
    { SREF(L"crescoctrl-disc"), 38002 }, { SREF(L"crestron-cip"), 41794 }, { SREF(L"crestron-cips"), 41796 }, { SREF(L"crestron-ctp"), 41795 },
    { SREF(L"crestron-ctps"), 41797 }, { SREF(L"crinis-hb"), 3818 }, { SREF(L"crip"), 6253 }, { SREF(L"crmsbits"), 2422 },
    { SREF(L"crs"), 507 }, { SREF(L"cruise-config"), 8378 }, { SREF(L"cruise-diags"), 8379 }, { SREF(L"cruise-enum"), 8376 },
    { SREF(L"cruise-swroute"), 8377 }, { SREF(L"cruise-update"), 8380 }, { SREF(L"crusecontroSREF(L"), 5231 }, { SREF(L"cryptoadmin"), 624 },
    { SREF(L"cs-auth-svr"), 3113 }, { SREF(L"cs-live"), 2129 }, { SREF(L"cs-remote-db"), 3630 }, { SREF(L"cs-services"), 3631 },
    { SREF(L"csbphonemaster"), 1724 }, { SREF(L"csc-proxy"), 4187 }, { SREF(L"csccfirewalSREF(L"), 40843 }, { SREF(L"csccredir"), 40842 },
    { SREF(L"cscp"), 40841 }, { SREF(L"csd-mgmt-port"), 3071 }, { SREF(L"csd-monitor"), 3072 }, { SREF(L"csdm"), 1468 },
    { SREF(L"csdm"), 1472 }, { SREF(L"csdmbase"), 1467 }, { SREF(L"csdmbase"), 1471 }, { SREF(L"csedaemon"), 5232 },
    { SREF(L"csi-lfap"), 3145 }, { SREF(L"csi-sgwp"), 348 }, { SREF(L"cslg"), 24754 }, { SREF(L"cslistener"), 9000 },
    { SREF(L"csms"), 3399 }, { SREF(L"csms2"), 3400 }, { SREF(L"csnet-ns"), 105 }, { SREF(L"csnotify"), 2955 },
    { SREF(L"cso"), 105 }, { SREF(L"csoauth"), 7847 }, { SREF(L"csoft-plusclnt"), 2699 }, { SREF(L"csoft-prev"), 3271 },
    { SREF(L"csoft1"), 1837 }, { SREF(L"csoftragent"), 3004 }, { SREF(L"cspclmulti"), 2890 }, { SREF(L"cspmlockmgr"), 1272 },
    { SREF(L"cspmulti"), 2807 }, { SREF(L"cspuni"), 2806 }, { SREF(L"csregagent"), 3022 }, { SREF(L"csrpc"), 5063 },
    { SREF(L"cssc"), 5637 }, { SREF(L"cssp"), 4078 }, { SREF(L"cst-port"), 3742 }, { SREF(L"csvr"), 3417 },
    { SREF(L"csvr-proxy"), 3190 }, { SREF(L"csvr-sslproxy"), 3191 }, { SREF(L"ct2nmcs"), 7023 }, { SREF(L"ctcd"), 1851 },
    { SREF(L"ctdb"), 4379 }, { SREF(L"ctdhercules"), 3773 }, { SREF(L"ctdp"), 7022 }, { SREF(L"ctechlicensing"), 9346 },
    { SREF(L"ctf"), 84 }, { SREF(L"cti-redwood"), 2563 }, { SREF(L"ctiprogramload"), 4452 }, { SREF(L"ctisystemmsg"), 4451 },
    { SREF(L"ctlptc"), 2153 }, { SREF(L"ctp"), 3772 }, { SREF(L"ctp-state"), 4047 }, { SREF(L"ctsd"), 5137 },
    { SREF(L"ctt-broker"), 1932 }, { SREF(L"ctx-bridge"), 3127 }, { SREF(L"ctxlic"), 7279 }, { SREF(L"ctxs-vpp"), 4980 },
    { SREF(L"cuelink"), 5271 }, { SREF(L"cuelink-disc"), 5271 }, { SREF(L"cuillamartin"), 1356 }, { SREF(L"cumulus"), 9287 },
    { SREF(L"cumulus-admin"), 8954 }, { SREF(L"cuseeme"), 7648 }, { SREF(L"custix"), 528 }, { SREF(L"cvc"), 1495 },
    { SREF(L"cvc-hostd"), 442 }, { SREF(L"cvd"), 8400 }, { SREF(L"cvmmon"), 2300 }, { SREF(L"cvmon"), 1686 },
    { SREF(L"cvspserver"), 2401 }, { SREF(L"cvsup"), 5999 }, { SREF(L"cwmp"), 7547 }, { SREF(L"cxtp"), 5091 },
    { SREF(L"cxws"), 4673 }, { SREF(L"cyaserv"), 2584 }, { SREF(L"cybercash"), 551 }, { SREF(L"cyborg-systems"), 9888 },
    { SREF(L"cybro-a-bus"), 8442 }, { SREF(L"cyc"), 3645 }, { SREF(L"cycleserv"), 763 }, { SREF(L"cycleserv2"), 772 },
    { SREF(L"cylink-c"), 5420 }, { SREF(L"cymtec-port"), 1898 }, { SREF(L"cypress"), 2015 }, { SREF(L"cypress-stat"), 2017 },
    { SREF(L"cytel-lm"), 3297 }, { SREF(L"d-cinema-csp"), 4170 }, { SREF(L"d-cinema-rrp"), 1173 }, { SREF(L"d-data"), 4301 },
    { SREF(L"d-data-controSREF(L"), 4302 }, { SREF(L"d-fence"), 8555 }, { SREF(L"d-s-n"), 8086 }, { SREF(L"d2000kerneSREF(L"), 3119 },
    { SREF(L"d2000webserver"), 3120 }, { SREF(L"d2dconfig"), 9387 }, { SREF(L"d2ddatatrans"), 9388 }, { SREF(L"d2k-datamover1"), 2297 },
    { SREF(L"d2k-datamover2"), 2298 }, { SREF(L"d2k-tapestry1"), 3393 }, { SREF(L"d2k-tapestry2"), 3394 }, { SREF(L"d3winosfi"), 3458 },
    { SREF(L"daap"), 3689 }, { SREF(L"dab-sti-c"), 1076 }, { SREF(L"dai-shelSREF(L"), 45824 }, { SREF(L"daishi"), 2870 },
    { SREF(L"dali-port"), 5777 }, { SREF(L"damewaremobgtwy"), 6130 }, { SREF(L"dandv-tester"), 3889 }, { SREF(L"danf-ak2"), 1041 },
    { SREF(L"daqstream"), 7411 }, { SREF(L"darcorp-lm"), 1679 }, { SREF(L"dashpas-port"), 3498 }, { SREF(L"dasp"), 439 },
    { SREF(L"data-insurance"), 2764 }, { SREF(L"data-port"), 3578 }, { SREF(L"datacaptor"), 1857 }, { SREF(L"datalens"), 2229 },
    { SREF(L"datascaler-ctSREF(L"), 6625 }, { SREF(L"datascaler-db"), 6624 }, { SREF(L"datasurfsrv"), 461 }, { SREF(L"datasurfsrvsec"), 462 },
    { SREF(L"datex-asn"), 355 }, { SREF(L"datusorb"), 3282 }, { SREF(L"davsrc"), 9800 }, { SREF(L"davsrcs"), 9802 },
    { SREF(L"dawn"), 1908 }, { SREF(L"dayliteserver"), 6113 }, { SREF(L"daylitetouch"), 6117 }, { SREF(L"daytime"), 13 },
    { SREF(L"db-lsp"), 17500 }, { SREF(L"db-lsp-disc"), 17500 }, { SREF(L"dbabble"), 8132 }, { SREF(L"dbase"), 217 },
    { SREF(L"dbbrowse"), 47557 }, { SREF(L"dbcontrol-agent"), 3938 }, { SREF(L"dbcontrol-oms"), 1158 }, { SREF(L"dbdb"), 6104 },
    { SREF(L"dberegister"), 1479 }, { SREF(L"dbisamserver1"), 12005 }, { SREF(L"dbisamserver2"), 12006 }, { SREF(L"dbm"), 2345 },
    { SREF(L"dbref"), 2365 }, { SREF(L"dbreporter"), 1379 }, { SREF(L"dbsa-lm"), 1407 }, { SREF(L"dbstar"), 1415 },
    { SREF(L"dbsyncarbiter"), 4953 }, { SREF(L"dc"), 2001 }, { SREF(L"dca"), 1456 }, { SREF(L"dcap"), 22125 },
    { SREF(L"dccm"), 5679 }, { SREF(L"dccp-udp"), 6511 }, { SREF(L"dcp"), 93 }, { SREF(L"dcs"), 1367 },
    { SREF(L"dcs-config"), 3988 }, { SREF(L"dcsl-backup"), 11202 }, { SREF(L"dcsoftware"), 3793 }, { SREF(L"dctp"), 675 },
    { SREF(L"dcutility"), 1044 }, { SREF(L"dddp"), 9131 }, { SREF(L"ddgn"), 4167 }, { SREF(L"ddi-tcp-1"), 8888 },
    { SREF(L"ddi-tcp-2"), 8889 }, { SREF(L"ddi-tcp-3"), 8890 }, { SREF(L"ddi-tcp-4"), 8891 }, { SREF(L"ddi-tcp-5"), 8892 },
    { SREF(L"ddi-tcp-6"), 8893 }, { SREF(L"ddi-tcp-7"), 8894 }, { SREF(L"ddi-udp-1"), 8888 }, { SREF(L"ddi-udp-2"), 8889 },
    { SREF(L"ddi-udp-3"), 8890 }, { SREF(L"ddi-udp-4"), 8891 }, { SREF(L"ddi-udp-5"), 8892 }, { SREF(L"ddi-udp-6"), 8893 },
    { SREF(L"ddi-udp-7"), 8894 }, { SREF(L"ddm-dfm"), 447 }, { SREF(L"ddm-rdb"), 446 }, { SREF(L"ddm-ssSREF(L"), 448 },
    { SREF(L"ddns-v3"), 2164 }, { SREF(L"ddrepSREF(L"), 4126 }, { SREF(L"ddt"), 1052 }, { SREF(L"de-cache-query"), 1255 },
    { SREF(L"de-noc"), 1254 }, { SREF(L"de-server"), 1256 }, { SREF(L"de-spot"), 2753 }, { SREF(L"dec-dlm"), 625 },
    { SREF(L"dec-mbadmin"), 1655 }, { SREF(L"dec-mbadmin-h"), 1656 }, { SREF(L"dec-notes"), 3333 }, { SREF(L"decap"), 403 },
    { SREF(L"decauth"), 316 }, { SREF(L"decbsrv"), 579 }, { SREF(L"decladebug"), 410 }, { SREF(L"dectalk"), 2007 },
    { SREF(L"decvms-sysmgt"), 441 }, { SREF(L"dei-icda"), 618 }, { SREF(L"delibo"), 2562 }, { SREF(L"dell-eql-asm"), 7569 },
    { SREF(L"dell-rm-port"), 3668 }, { SREF(L"dellpwrappks"), 1266 }, { SREF(L"dellwebadmin-1"), 1278 }, { SREF(L"dellwebadmin-2"), 1279 },
    { SREF(L"delos-dms"), 3714 }, { SREF(L"delta-mcp"), 1324 }, { SREF(L"denali-server"), 3444 }, { SREF(L"deos"), 76 },
    { SREF(L"deploymentmap"), 4570 }, { SREF(L"derby-repli"), 4851 }, { SREF(L"descent3"), 2092 }, { SREF(L"deskshare"), 1702 },
    { SREF(L"desktop-dna"), 2763 }, { SREF(L"deskview"), 3298 }, { SREF(L"devbasic"), 5426 }, { SREF(L"device"), 801 },
    { SREF(L"device2"), 2030 }, { SREF(L"devshr-nts"), 552 }, { SREF(L"dey-keyneg"), 8750 }, { SREF(L"dey-sapi"), 4330 },
    { SREF(L"dfn"), 1133 }, { SREF(L"dfoxserver"), 2960 }, { SREF(L"dfserver"), 21554 }, { SREF(L"dgi-serv"), 33333 },
    { SREF(L"dgpf-exchg"), 6785 }, { SREF(L"dhanalakshmi"), 34567 }, { SREF(L"dhcp-failover"), 647 }, { SREF(L"dhcp-failover2"), 847 },
    { SREF(L"dhcpv6-client"), 546 }, { SREF(L"dhcpv6-server"), 547 }, { SREF(L"dhct-alerts"), 4676 }, { SREF(L"dhct-status"), 4675 },
    { SREF(L"dhe"), 3252 }, { SREF(L"di-ase"), 3046 }, { SREF(L"di-drm"), 2226 }, { SREF(L"di-msg"), 2227 },
    { SREF(L"di-traceware"), 3041 }, { SREF(L"diagmond"), 1508 }, { SREF(L"diagnose-proc"), 6072 }, { SREF(L"dialog-port"), 2098 },
    { SREF(L"dialogic-elmd"), 1945 }, { SREF(L"dialpad-voice1"), 2860 }, { SREF(L"dialpad-voice2"), 2861 }, { SREF(L"diameter"), 3868 },
    { SREF(L"diameters"), 5868 }, { SREF(L"diamondport"), 33331 }, { SREF(L"dic-aida"), 1941 }, { SREF(L"dicom"), 11112 },
    { SREF(L"dicom-iscSREF(L"), 2761 }, { SREF(L"dicom-tls"), 2762 }, { SREF(L"dict"), 2628 }, { SREF(L"dict-lookup"), 2289 },
    { SREF(L"dif-port"), 2251 }, { SREF(L"digiman"), 2362 }, { SREF(L"digital-notary"), 1335 }, { SREF(L"digital-vrc"), 466 },
    { SREF(L"digivote"), 3223 }, { SREF(L"direcpc-dlSREF(L"), 1844 }, { SREF(L"direcpc-si"), 2464 }, { SREF(L"direcpc-video"), 1825 },
    { SREF(L"direct"), 242 }, { SREF(L"directnet"), 3447 }, { SREF(L"directplay"), 2234 }, { SREF(L"directplay8"), 6073 },
    { SREF(L"directplaysrvr"), 47624 }, { SREF(L"directv-catlg"), 3337 }, { SREF(L"directv-soft"), 3335 }, { SREF(L"directv-tick"), 3336 },
    { SREF(L"directv-web"), 3334 }, { SREF(L"directvdata"), 3287 }, { SREF(L"dirgis"), 2496 }, { SREF(L"discard"), 9 },
    { SREF(L"disclose"), 667 }, { SREF(L"discovery-port"), 1925 }, { SREF(L"discp-client"), 2601 }, { SREF(L"discp-server"), 2602 },
    { SREF(L"display"), 7236 }, { SREF(L"dist-upgrade"), 3624 }, { SREF(L"distcc"), 3632 }, { SREF(L"distinct"), 9999 },
    { SREF(L"distinct32"), 9998 }, { SREF(L"dixie"), 96 }, { SREF(L"dj-ice"), 5419 }, { SREF(L"dj-ilm"), 3362 },
    { SREF(L"dka"), 1263 }, { SREF(L"dkmessenger"), 1177 }, { SREF(L"dl-agent"), 3876 }, { SREF(L"dlip"), 7201 },
    { SREF(L"dlms-cosem"), 4059 }, { SREF(L"dlpx-sp"), 8415 }, { SREF(L"dls"), 197 }, { SREF(L"dls"), 2047 },
    { SREF(L"dls-mon"), 198 }, { SREF(L"dls-monitor"), 2048 }, { SREF(L"dlsrap"), 1973 }, { SREF(L"dlsrpn"), 2065 },
    { SREF(L"dlswpn"), 2067 }, { SREF(L"dmaf-caster"), 3574 }, { SREF(L"dmaf-server"), 3574 }, { SREF(L"dmdocbroker"), 1489 },
    { SREF(L"DMExpress"), 32636 }, { SREF(L"dmidi"), 1199 }, { SREF(L"dmod-workspace"), 3199 }, { SREF(L"dmp"), 5031 },
    { SREF(L"dmt"), 7683 }, { SREF(L"dn6-nlm-aud"), 195 }, { SREF(L"dn6-smm-red"), 196 }, { SREF(L"dna"), 2287 },
    { SREF(L"dna-cmSREF(L"), 436 }, { SREF(L"dnap"), 1172 }, { SREF(L"dnc-port"), 3448 }, { SREF(L"dnox"), 4022 },
    { SREF(L"dnp"), 20000 }, { SREF(L"dnp-sec"), 19999 }, { SREF(L"dns-llq"), 5352 }, { SREF(L"dns2go"), 1227 },
    { SREF(L"dnsix"), 90 }, { SREF(L"dnx"), 3998 }, { SREF(L"doc-server"), 7165 }, { SREF(L"doc1lm"), 3161 },
    { SREF(L"docent"), 2151 }, { SREF(L"doceri-ctSREF(L"), 7019 }, { SREF(L"doceri-view"), 7019 }, { SREF(L"docker"), 2375 },
    { SREF(L"docker-s"), 2376 }, { SREF(L"docstor"), 1488 }, { SREF(L"documentum"), 10002 }, { SREF(L"documentum_s"), 10003 },
    { SREF(L"dof-dps-mc-sec"), 5567 }, { SREF(L"dof-eps"), 3567 }, { SREF(L"dof-tunneSREF(L"), 8567 }, { SREF(L"dof-tunnel-sec"), 3568 },
    { SREF(L"doglms"), 6088 }, { SREF(L"doglms-notify"), 6088 }, { SREF(L"doip-data"), 13400 }, { SREF(L"doip-disc"), 13400 },
    { SREF(L"domain"), 53 }, { SREF(L"domaintime"), 9909 }, { SREF(L"domiq"), 44544 }, { SREF(L"donnyworld"), 1821 },
    { SREF(L"doom"), 666 }, { SREF(L"dossier"), 1175 }, { SREF(L"down"), 2022 }, { SREF(L"downtools"), 5245 },
    { SREF(L"downtools-disc"), 5245 }, { SREF(L"dpap"), 8770 }, { SREF(L"dpcp"), 4099 }, { SREF(L"dpi-proxy"), 1795 },
    { SREF(L"dpkeyserv"), 1780 }, { SREF(L"dpm"), 5718 }, { SREF(L"dpm-acm"), 6075 }, { SREF(L"dpm-agent"), 5719 },
    { SREF(L"dproxy"), 1296 }, { SREF(L"dpserve"), 7020 }, { SREF(L"dpserveadmin"), 7021 }, { SREF(L"dpsi"), 315 },
    { SREF(L"dragonfly"), 8913 }, { SREF(L"drip"), 3949 }, { SREF(L"driveappserver"), 1930 }, { SREF(L"drizzle"), 4427 },
    { SREF(L"drm-production"), 7171 }, { SREF(L"drmsfsd"), 4098 }, { SREF(L"drmsmc"), 1878 }, { SREF(L"drp"), 1974 },
    { SREF(L"drwcs"), 2193 }, { SREF(L"ds-admin"), 4404 }, { SREF(L"ds-clnt"), 4402 }, { SREF(L"ds-maiSREF(L"), 4405 },
    { SREF(L"ds-slp"), 4406 }, { SREF(L"ds-srv"), 4400 }, { SREF(L"ds-srvr"), 4401 }, { SREF(L"ds-user"), 4403 },
    { SREF(L"dsatp"), 2111 }, { SREF(L"dsc"), 3390 }, { SREF(L"dsdn"), 1292 }, { SREF(L"dserver"), 4309 },
    { SREF(L"dsETOS"), 378 }, { SREF(L"dsf"), 555 }, { SREF(L"dsfgw"), 438 }, { SREF(L"dslremote-mgmt"), 2420 },
    { SREF(L"dsm-scm-target"), 9987 }, { SREF(L"dsmcc-ccp"), 13822 }, { SREF(L"dsmcc-config"), 13818 }, { SREF(L"dsmcc-download"), 13821 },
    { SREF(L"dsmcc-passthru"), 13820 }, { SREF(L"dsmcc-session"), 13819 }, { SREF(L"dsmeter-iatc"), 4060 }, { SREF(L"dsmipv6"), 4191 },
    { SREF(L"dsom-server"), 3053 }, { SREF(L"dsp"), 33 }, { SREF(L"dsp3270"), 246 }, { SREF(L"dssiapi"), 1265 },
    { SREF(L"dsx-agent"), 3685 }, { SREF(L"dsx-monitor"), 31685 }, { SREF(L"dt-mgmtsvc"), 6325 }, { SREF(L"dt-vra"), 6326 },
    { SREF(L"dta-systems"), 13929 }, { SREF(L"dtag-ste-sb"), 352 }, { SREF(L"dtk"), 365 }, { SREF(L"dtn-bundle"), 4556 },
    { SREF(L"dtn1"), 2445 }, { SREF(L"dtp"), 3663 }, { SREF(L"dtp-dia"), 3489 }, { SREF(L"dtp-net"), 8732 },
    { SREF(L"dtpt"), 5721 }, { SREF(L"dts"), 2594 }, { SREF(L"dtserver-port"), 4028 }, { SREF(L"dtspcd"), 6112 },
    { SREF(L"dtv-chan-req"), 2253 }, { SREF(L"dvapps"), 3831 }, { SREF(L"dvbservdsc"), 3937 }, { SREF(L"dvcprov-port"), 3776 },
    { SREF(L"dvl-activemaiSREF(L"), 1396 }, { SREF(L"dvr-esm"), 2804 }, { SREF(L"dvt-data"), 3247 }, { SREF(L"dvt-system"), 3246 },
    { SREF(L"dwf"), 1450 }, { SREF(L"dwmsgserver"), 3228 }, { SREF(L"dwnmshttp"), 3227 }, { SREF(L"dwr"), 644 },
    { SREF(L"dx-instrument"), 1325 }, { SREF(L"dxadmind"), 1958 }, { SREF(L"dxmessagebase1"), 2874 }, { SREF(L"dxmessagebase2"), 2875 },
    { SREF(L"dxspider"), 8873 }, { SREF(L"dyn-site"), 3932 }, { SREF(L"dyna-access"), 3310 }, { SREF(L"dyna-lm"), 3395 },
    { SREF(L"dynamic3d"), 2150 }, { SREF(L"dynamid"), 9002 }, { SREF(L"dyniplookup"), 3295 }, { SREF(L"dzdaemon"), 3866 },
    { SREF(L"dzoglserver"), 3867 }, { SREF(L"e-builder"), 4121 }, { SREF(L"e-design-net"), 6702 }, { SREF(L"e-design-web"), 6703 },
    { SREF(L"e-dpnet"), 2036 }, { SREF(L"e-mdu"), 3727 }, { SREF(L"e-net"), 3286 }, { SREF(L"e-woa"), 3728 },
    { SREF(L"e3consultants"), 3157 }, { SREF(L"ea"), 17729 }, { SREF(L"ea1"), 1791 }, { SREF(L"eapsp"), 2291 },
    { SREF(L"easSREF(L"), 3693 }, { SREF(L"easy-soft-mux"), 2168 }, { SREF(L"easyengine"), 22222 }, { SREF(L"eba"), 45678 },
    { SREF(L"ebinsite"), 2651 }, { SREF(L"echo"), 7 }, { SREF(L"echonet"), 3610 }, { SREF(L"ecmp"), 6160 },
    { SREF(L"ecmp-data"), 6160 }, { SREF(L"ecmport"), 3524 }, { SREF(L"ecnp"), 2858 }, { SREF(L"ecolor-imager"), 3263 },
    { SREF(L"ecomm"), 3477 }, { SREF(L"ecovisiong6-1"), 2896 }, { SREF(L"ecp"), 3134 }, { SREF(L"ecsqdmn"), 1882 },
    { SREF(L"ecwcfg"), 2263 }, { SREF(L"edb-server1"), 1635 }, { SREF(L"edb-server2"), 3711 }, { SREF(L"edbsrvr"), 12010 },
    { SREF(L"editbench"), 1350 }, { SREF(L"edix"), 3123 }, { SREF(L"edm-adm-notify"), 3463 }, { SREF(L"edm-manager"), 3460 },
    { SREF(L"edm-mgr-cntrSREF(L"), 3465 }, { SREF(L"edm-mgr-sync"), 3464 }, { SREF(L"edm-stager"), 3461 }, { SREF(L"edm-std-notify"), 3462 },
    { SREF(L"edtools"), 1142 }, { SREF(L"eenet"), 5234 }, { SREF(L"efb-aci"), 6159 }, { SREF(L"efcp"), 3671 },
    { SREF(L"efi-lm"), 3392 }, { SREF(L"efi-mg"), 2224 }, { SREF(L"efidiningport"), 2553 }, { SREF(L"eforward"), 2181 },
    { SREF(L"efr"), 5618 }, { SREF(L"efs"), 520 }, { SREF(L"eftp"), 37601 }, { SREF(L"egptlm"), 3328 },
    { SREF(L"egs"), 1926 }, { SREF(L"ehome-ms"), 2228 }, { SREF(L"ehp-backup"), 3638 }, { SREF(L"ehs"), 4535 },
    { SREF(L"ehs-ssSREF(L"), 4536 }, { SREF(L"ehtp"), 1295 }, { SREF(L"eicon-server"), 1438 }, { SREF(L"eicon-slp"), 1440 },
    { SREF(L"eicon-x25"), 1439 }, { SREF(L"eims-admin"), 4199 }, { SREF(L"eis"), 3982 }, { SREF(L"eisp"), 3983 },
    { SREF(L"eisport"), 3525 }, { SREF(L"elad"), 1893 }, { SREF(L"elan"), 1378 }, { SREF(L"elanlm"), 4346 },
    { SREF(L"elatelink"), 2124 }, { SREF(L"elcn"), 7101 }, { SREF(L"elcsd"), 704 }, { SREF(L"elektron-admin"), 5398 },
    { SREF(L"elfiq-repSREF(L"), 1148 }, { SREF(L"eli"), 2087 }, { SREF(L"elipse-rec"), 6515 }, { SREF(L"ellpack"), 2025 },
    { SREF(L"elm-momentum"), 1914 }, { SREF(L"elpro-tunneSREF(L"), 4370 }, { SREF(L"els"), 1315 }, { SREF(L"elvin-client"), 2917 },
    { SREF(L"elvin-server"), 2916 }, { SREF(L"elxmgmt"), 23333 }, { SREF(L"em7-secom"), 7700 }, { SREF(L"ema-sent-lm"), 2526 },
    { SREF(L"emb-proj-cmd"), 5116 }, { SREF(L"embl-ndt"), 394 }, { SREF(L"embrace-dp-c"), 3198 }, { SREF(L"embrace-dp-s"), 3197 },
    { SREF(L"emc-gateway"), 1273 }, { SREF(L"emc-pp-mgmtsvc"), 9083 }, { SREF(L"emc-vcas-tcp"), 13218 }, { SREF(L"emc-vcas-udp"), 13218 },
    { SREF(L"emc-xsw-dcache"), 11723 }, { SREF(L"emc-xsw-dconfig"), 11623 }, { SREF(L"emcads"), 3945 }, { SREF(L"emce"), 2004 },
    { SREF(L"emcrmirccd"), 10004 }, { SREF(L"emcrmird"), 10005 }, { SREF(L"emcsymapiport"), 2707 }, { SREF(L"emfis-cntSREF(L"), 141 },
    { SREF(L"emfis-data"), 140 }, { SREF(L"emgmsg"), 6656 }, { SREF(L"emp-server1"), 6321 }, { SREF(L"emp-server2"), 6322 },
    { SREF(L"emperion"), 1282 }, { SREF(L"empire-empuma"), 1691 }, { SREF(L"empowerid"), 7080 }, { SREF(L"emprise-lls"), 3585 },
    { SREF(L"emprise-lsc"), 3586 }, { SREF(L"ems"), 4664 }, { SREF(L"emsd-port"), 1928 }, { SREF(L"emwavemsg"), 20480 },
    { SREF(L"emwin"), 2211 }, { SREF(L"encore"), 1740 }, { SREF(L"encrypted-admin"), 1138 }, { SREF(L"encrypted-llrp"), 5085 },
    { SREF(L"enfs"), 5233 }, { SREF(L"enSREF(L"), 1804 }, { SREF(L"enl-name"), 1805 }, { SREF(L"enpc"), 3289 },
    { SREF(L"enpp"), 2968 }, { SREF(L"enrp"), 9901 }, { SREF(L"enrp-sctp"), 9901 }, { SREF(L"enrp-sctp-tls"), 9902 },
    { SREF(L"ent-engine"), 3665 }, { SREF(L"entexthigh"), 12002 }, { SREF(L"entextlow"), 12004 }, { SREF(L"entextmed"), 12003 },
    { SREF(L"entextnetwk"), 12001 }, { SREF(L"entextxid"), 12000 }, { SREF(L"entp"), 1865 }, { SREF(L"entrust-aaas"), 680 },
    { SREF(L"entrust-aams"), 681 }, { SREF(L"entrust-ash"), 710 }, { SREF(L"entrust-kmsh"), 709 }, { SREF(L"entrust-sps"), 640 },
    { SREF(L"entrusttime"), 309 }, { SREF(L"eor-game"), 8149 }, { SREF(L"eoss"), 1210 }, { SREF(L"ep-nsp"), 3621 },
    { SREF(L"ep-pcp"), 3620 }, { SREF(L"epc"), 1267 }, { SREF(L"epicon"), 2912 }, { SREF(L"epl-slp"), 3819 },
    { SREF(L"epmap"), 135 }, { SREF(L"epmd"), 4369 }, { SREF(L"epncdp2"), 3259 }, { SREF(L"epnsdp"), 2051 },
    { SREF(L"eportcomm"), 4666 }, { SREF(L"eportcommdata"), 4669 }, { SREF(L"epp"), 3044 }, { SREF(L"epp"), 700 },
    { SREF(L"eppc"), 3031 }, { SREF(L"ept-machine"), 3628 }, { SREF(L"eq-office-4940"), 4940 }, { SREF(L"eq-office-4941"), 4941 },
    { SREF(L"eq-office-4942"), 4942 }, { SREF(L"eq3-config"), 43439 }, { SREF(L"eq3-update"), 43439 }, { SREF(L"equationbuilder"), 1351 },
    { SREF(L"ergolight"), 2109 }, { SREF(L"eristwoguns"), 2650 }, { SREF(L"erp-scale"), 5135 }, { SREF(L"erpc"), 121 },
    { SREF(L"erunbook-agent"), 9616 }, { SREF(L"erunbook-server"), 9617 }, { SREF(L"es-elmd"), 1822 }, { SREF(L"esbroker"), 1342 },
    { SREF(L"Escale (Newton Dock)"), 3679 }, { SREF(L"escp-ip"), 621 }, { SREF(L"escvpnet"), 3629 }, { SREF(L"eserver-pap"), 3666 },
    { SREF(L"esimport"), 3564 }, { SREF(L"esinstalSREF(L"), 5599 }, { SREF(L"esip"), 2950 }, { SREF(L"esl-lm"), 1455 },
    { SREF(L"esmagent"), 5601 }, { SREF(L"esmmanager"), 5600 }, { SREF(L"esnm-zoning"), 4023 }, { SREF(L"esp-encap"), 2797 },
    { SREF(L"esp-lm"), 3383 }, { SREF(L"espeech"), 8416 }, { SREF(L"espeech-rtp"), 8417 }, { SREF(L"esps-portaSREF(L"), 2867 },
    { SREF(L"esri-sde"), 5151 }, { SREF(L"esro-emsdp"), 642 }, { SREF(L"esro-gen"), 259 }, { SREF(L"essbase"), 1423 },
    { SREF(L"essp"), 2969 }, { SREF(L"essweb-gw"), 1772 }, { SREF(L"estamp"), 1982 }, { SREF(L"etb4j"), 16309 },
    { SREF(L"etc-controSREF(L"), 6107 }, { SREF(L"etcd-client"), 2379 }, { SREF(L"etcd-server"), 2380 }, { SREF(L"etebac5"), 1216 },
    { SREF(L"etftp"), 1818 }, { SREF(L"ethercat"), 34980 }, { SREF(L"EtherNet-IP-1"), 2222 }, { SREF(L"EtherNet-IP-2"), 44818 },
    { SREF(L"ethoscan"), 6935 }, { SREF(L"etlservicemgr"), 9001 }, { SREF(L"etp"), 1798 }, { SREF(L"ets"), 1569 },
    { SREF(L"eudora-set"), 592 }, { SREF(L"ev-services"), 5114 }, { SREF(L"evb-elm"), 1504 }, { SREF(L"event-listener"), 3017 },
    { SREF(L"event-port"), 2069 }, { SREF(L"everydayrc"), 2782 }, { SREF(L"evm"), 1139 }, { SREF(L"evtp"), 2834 },
    { SREF(L"evtp-data"), 2835 }, { SREF(L"ew-disc-cmd"), 43440 }, { SREF(L"ew-mgmt"), 43440 }, { SREF(L"ewalSREF(L"), 1328 },
    { SREF(L"ewcappsrv"), 1876 }, { SREF(L"ewctsp"), 6066 }, { SREF(L"ewdgs"), 4092 }, { SREF(L"ewinstaller"), 4091 },
    { SREF(L"ewnn"), 2674 }, { SREF(L"exapt-lmgr"), 3759 }, { SREF(L"exasoftport1"), 3920 }, { SREF(L"exbit-escp"), 1316 },
    { SREF(L"exce"), 2769 }, { SREF(L"excerpt"), 5400 }, { SREF(L"excerpts"), 5401 }, { SREF(L"excw"), 1271 },
    { SREF(L"exec"), 512 }, { SREF(L"exlm-agent"), 3002 }, { SREF(L"exoconfig"), 26487 }, { SREF(L"exoline-tcp"), 26486 },
    { SREF(L"exoline-udp"), 26486 }, { SREF(L"exonet"), 26489 }, { SREF(L"exp1"), 1021 }, { SREF(L"exp2"), 1022 },
    { SREF(L"expresspay"), 2755 }, { SREF(L"extensis"), 2666 }, { SREF(L"eye2eye"), 1948 }, { SREF(L"eyelink"), 589 },
    { SREF(L"eyetv"), 2170 }, { SREF(L"ezmeeting"), 26261 }, { SREF(L"ezmeeting-2"), 10101 }, { SREF(L"ezmessagesrv"), 4085 },
    { SREF(L"ezproxy"), 26260 }, { SREF(L"ezproxy-2"), 10102 }, { SREF(L"ezrelay"), 10103 }, { SREF(L"f5-globalsite"), 2792 },
    { SREF(L"f5-iquery"), 4353 }, { SREF(L"fac-restore"), 5582 }, { SREF(L"facelink"), 1915 }, { SREF(L"facilityview"), 1561 },
    { SREF(L"facsys-ntp"), 2514 }, { SREF(L"facsys-router"), 2515 }, { SREF(L"fagordnc"), 3873 }, { SREF(L"fairview"), 38202 },
    { SREF(L"famdc"), 10081 }, { SREF(L"farenet"), 5557 }, { SREF(L"fast-rem-serv"), 2495 }, { SREF(L"fastlynx"), 2689 },
    { SREF(L"fatpipe"), 3353 }, { SREF(L"fatserv"), 347 }, { SREF(L"faxcomservice"), 6417 }, { SREF(L"faximum"), 7437 },
    { SREF(L"faxportwinport"), 1620 }, { SREF(L"faxstfx-port"), 3684 }, { SREF(L"fazzt-admin"), 4039 }, { SREF(L"fazzt-ptp"), 4038 },
    { SREF(L"fc-cli"), 1371 }, { SREF(L"fc-faultnotify"), 2819 }, { SREF(L"fc-ser"), 1372 }, { SREF(L"fcip-port"), 3225 },
    { SREF(L"fcis"), 4727 }, { SREF(L"fcis-disc"), 4727 }, { SREF(L"fcmsys"), 2344 }, { SREF(L"fcopy-server"), 5745 },
    { SREF(L"fcopys-server"), 5746 }, { SREF(L"fcp"), 510 }, { SREF(L"fcp-addr-srvr1"), 5500 }, { SREF(L"fcp-addr-srvr2"), 5501 },
    { SREF(L"fcp-cics-gw1"), 5504 }, { SREF(L"fcp-srvr-inst1"), 5502 }, { SREF(L"fcp-srvr-inst2"), 5503 }, { SREF(L"fcp-udp"), 810 },
    { SREF(L"fdt-rcatp"), 4320 }, { SREF(L"fdtracks"), 5579 }, { SREF(L"febooti-aw"), 36524 }, { SREF(L"feitianrockey"), 3152 },
    { SREF(L"femis"), 1776 }, { SREF(L"ferrari-foam"), 3216 }, { SREF(L"ff-annunc"), 1089 }, { SREF(L"ff-fms"), 1090 },
    { SREF(L"ff-lr-port"), 3622 }, { SREF(L"ff-sm"), 1091 }, { SREF(L"ffserver"), 3825 }, { SREF(L"fg-fps"), 3293 },
    { SREF(L"fg-gip"), 3294 }, { SREF(L"fg-sysupdate"), 6550 }, { SREF(L"fhc"), 1499 }, { SREF(L"fhsp"), 1807 },
    { SREF(L"fibotrader-com"), 6715 }, { SREF(L"filecast"), 3401 }, { SREF(L"filemq"), 5670 }, { SREF(L"filenet-cm"), 32773 },
    { SREF(L"filenet-nch"), 32770 }, { SREF(L"filenet-obrok"), 32777 }, { SREF(L"filenet-pa"), 32772 }, { SREF(L"filenet-pch"), 32775 },
    { SREF(L"filenet-peior"), 32776 }, { SREF(L"filenet-powsrm"), 32767 }, { SREF(L"filenet-re"), 32774 }, { SREF(L"filenet-rmi"), 32771 },
    { SREF(L"filenet-rpc"), 32769 }, { SREF(L"filenet-tms"), 32768 }, { SREF(L"filesphere"), 24242 }, { SREF(L"filex-lport"), 1887 },
    { SREF(L"find"), 24922 }, { SREF(L"findviatv"), 3350 }, { SREF(L"finger"), 79 }, { SREF(L"finisar"), 4682 },
    { SREF(L"finle-lm"), 1784 }, { SREF(L"fintrx"), 3787 }, { SREF(L"fio-cmgmt"), 9051 }, { SREF(L"fiorano-msgsvc"), 1856 },
    { SREF(L"fiorano-rtrsvc"), 1855 }, { SREF(L"firefox"), 1689 }, { SREF(L"firemonrcc"), 3192 }, { SREF(L"firepower"), 2615 },
    { SREF(L"first-defense"), 1232 }, { SREF(L"firstcall42"), 2673 }, { SREF(L"fis"), 5912 }, { SREF(L"fisa-svc"), 7018 },
    { SREF(L"fiveacross"), 1193 }, { SREF(L"fj-hdnet"), 1717 }, { SREF(L"fjappmgrbulk"), 2510 }, { SREF(L"fjcp"), 3648 },
    { SREF(L"fjdmimgr"), 9374 }, { SREF(L"fjdocdist"), 1848 }, { SREF(L"fjhpjp"), 3067 }, { SREF(L"fjicl-tep-a"), 1901 },
    { SREF(L"fjicl-tep-b"), 1902 }, { SREF(L"fjicl-tep-c"), 1904 }, { SREF(L"fjinvmgr"), 9396 }, { SREF(L"fjippol-cnsSREF(L"), 2749 },
    { SREF(L"fjippol-polsvr"), 2748 }, { SREF(L"fjippol-port1"), 2750 }, { SREF(L"fjippol-port2"), 2751 }, { SREF(L"fjippol-swrly"), 2747 },
    { SREF(L"fjitsuappmgr"), 2425 }, { SREF(L"fjmpcm"), 2975 }, { SREF(L"fjmpjps"), 1873 }, { SREF(L"fjmpss"), 2509 },
    { SREF(L"fjsv-gssagt"), 3035 }, { SREF(L"fjsvmpor"), 2946 }, { SREF(L"fjswapsnp"), 1874 }, { SREF(L"fksp-audit"), 3729 },
    { SREF(L"flamenco-proxy"), 3210 }, { SREF(L"flashfiler"), 24677 }, { SREF(L"flashmsg"), 2884 }, { SREF(L"flcrs"), 5638 },
    { SREF(L"flex-lm"), 27000 }, { SREF(L"flex-lm"), 27001 }, { SREF(L"flex-lm"), 27002 }, { SREF(L"flex-lm"), 27003 },
    { SREF(L"flex-lm"), 27004 }, { SREF(L"flex-lm"), 27005 }, { SREF(L"flex-lm"), 27006 }, { SREF(L"flex-lm"), 27007 },
    { SREF(L"flex-lm"), 27008 }, { SREF(L"flex-lm"), 27009 }, { SREF(L"flexlm"), 744 }, { SREF(L"flirtmitmir"), 3840 },
    { SREF(L"fln-spx"), 221 }, { SREF(L"florence"), 1228 }, { SREF(L"flr-agent"), 4901 }, { SREF(L"flukeserver"), 2359 },
    { SREF(L"fly"), 4396 }, { SREF(L"fmp"), 4745 }, { SREF(L"fmpro-fdaSREF(L"), 2399 }, { SREF(L"fmpro-internaSREF(L"), 5003 },
    { SREF(L"fmpro-v6"), 5013 }, { SREF(L"fmsas"), 16000 }, { SREF(L"fmsascon"), 16001 }, { SREF(L"fmtp"), 8500 },
    { SREF(L"fmwp"), 5015 }, { SREF(L"fnet-remote-ui"), 1174 }, { SREF(L"fodms"), 7200 }, { SREF(L"foliocorp"), 2242 },
    { SREF(L"font-service"), 7100 }, { SREF(L"foresyte-clear"), 5407 }, { SREF(L"foresyte-sec"), 5408 }, { SREF(L"fortisphere-vm"), 4084 },
    { SREF(L"fotogcad"), 3878 }, { SREF(L"found"), 4411 }, { SREF(L"fpitp"), 1045 }, { SREF(L"fpo-fns"), 1066 },
    { SREF(L"fprams"), 4122 }, { SREF(L"frc-hp"), 6704 }, { SREF(L"frc-lp"), 6706 }, { SREF(L"frc-mp"), 6705 },
    { SREF(L"frcs"), 4915 }, { SREF(L"freeciv"), 5556 }, { SREF(L"freezexservice"), 7726 }, { SREF(L"fronet"), 4130 },
    { SREF(L"fryeserv"), 2788 }, { SREF(L"fs-agent"), 8042 }, { SREF(L"fs-mgmt"), 8044 }, { SREF(L"fs-qos"), 41111 },
    { SREF(L"fs-rh-srv"), 3488 }, { SREF(L"fs-server"), 8043 }, { SREF(L"fsc-port"), 9217 }, { SREF(L"fse"), 7394 },
    { SREF(L"fsportmap"), 4349 }, { SREF(L"fsr"), 7164 }, { SREF(L"ft-role"), 2429 }, { SREF(L"ftnmtp"), 8502 },
    { SREF(L"ftp"), 21 }, { SREF(L"ftp-agent"), 574 }, { SREF(L"ftp-data"), 20 }, { SREF(L"ftps"), 990 },
    { SREF(L"ftps-data"), 989 }, { SREF(L"ftranhc"), 1105 }, { SREF(L"ftrapid-1"), 1746 }, { SREF(L"ftrapid-2"), 1747 },
    { SREF(L"ftsrv"), 1359 }, { SREF(L"ftsync"), 4086 }, { SREF(L"fujitsu-dev"), 747 }, { SREF(L"fujitsu-dtc"), 1513 },
    { SREF(L"fujitsu-dtcns"), 1514 }, { SREF(L"fujitsu-mmpdc"), 1657 }, { SREF(L"fujitsu-neat"), 3382 }, { SREF(L"funk-dialout"), 2909 },
    { SREF(L"funk-license"), 1787 }, { SREF(L"funk-logger"), 1786 }, { SREF(L"funkproxy"), 1505 }, { SREF(L"fuscript"), 1144 },
    { SREF(L"futrix"), 2358 }, { SREF(L"fxaengine-net"), 3402 }, { SREF(L"fxp"), 2849 }, { SREF(L"fxp"), 286 },
    { SREF(L"fxuptp"), 19539 }, { SREF(L"fyre-messanger"), 2731 }, { SREF(L"g-talk"), 2421 }, { SREF(L"g2tag"), 4110 },
    { SREF(L"g5m"), 2732 }, { SREF(L"gacp"), 190 }, { SREF(L"gadgetgate1way"), 2677 }, { SREF(L"gadgetgate2way"), 2678 },
    { SREF(L"gadugadu"), 8074 }, { SREF(L"gaia"), 4340 }, { SREF(L"galaxy-network"), 5235 }, { SREF(L"galaxy-server"), 3051 },
    { SREF(L"galaxy4d"), 8881 }, { SREF(L"galaxy7-data"), 38201 }, { SREF(L"galileo"), 3519 }, { SREF(L"galileolog"), 3520 },
    { SREF(L"gamegen1"), 1738 }, { SREF(L"gamelobby"), 2914 }, { SREF(L"gamesmith-port"), 31765 }, { SREF(L"gammafetchsvr"), 1859 },
    { SREF(L"gandalf-lm"), 1421 }, { SREF(L"gap"), 10800 }, { SREF(L"garcon"), 999 }, { SREF(L"gat-lmd"), 1708 },
    { SREF(L"gbjd816"), 2626 }, { SREF(L"gbmt-stars"), 3912 }, { SREF(L"gbs-smp"), 3762 }, { SREF(L"gbs-stp"), 3484 },
    { SREF(L"gc-config"), 3436 }, { SREF(L"gcm-app"), 14145 }, { SREF(L"gcmonitor"), 2660 }, { SREF(L"gcsp"), 3429 },
    { SREF(L"gdbremote"), 2159 }, { SREF(L"gdoi"), 848 }, { SREF(L"gdomap"), 538 }, { SREF(L"gdp-port"), 1997 },
    { SREF(L"gdrive-sync"), 37483 }, { SREF(L"gds-adppiw-db"), 4550 }, { SREF(L"gds-db"), 3050 }, { SREF(L"gearman"), 4730 },
    { SREF(L"gemini-lm"), 1590 }, { SREF(L"geneous"), 3381 }, { SREF(L"generalsync"), 7962 }, { SREF(L"geneve"), 6081 },
    { SREF(L"genie"), 402 }, { SREF(L"genie-lm"), 1453 }, { SREF(L"genisar-port"), 3475 }, { SREF(L"geniuslm"), 3005 },
    { SREF(L"genrad-mux"), 176 }, { SREF(L"genstat"), 7283 }, { SREF(L"geognosis"), 4326 }, { SREF(L"geognosisman"), 4325 },
    { SREF(L"geolocate"), 3108 }, { SREF(L"gerhcs"), 4985 }, { SREF(L"gf"), 3530 }, { SREF(L"ggf-ncp"), 678 },
    { SREF(L"ggz"), 5688 }, { SREF(L"ghvpn"), 12009 }, { SREF(L"giga-pocket"), 3862 }, { SREF(L"gilatskysurfer"), 3013 },
    { SREF(L"ginad"), 634 }, { SREF(L"giop"), 2481 }, { SREF(L"giop-ssSREF(L"), 2482 }, { SREF(L"gist"), 270 },
    { SREF(L"git"), 9418 }, { SREF(L"glbp"), 3222 }, { SREF(L"gld"), 6267 }, { SREF(L"glishd"), 2833 },
    { SREF(L"global-cd-port"), 3229 }, { SREF(L"global-dtserv"), 1774 }, { SREF(L"global-wlink"), 1909 }, { SREF(L"globe"), 2002 },
    { SREF(L"globecast-id"), 6109 }, { SREF(L"globmsgsvc"), 2519 }, { SREF(L"glogger"), 2033 }, { SREF(L"glrpc"), 9080 },
    { SREF(L"gmmp"), 4183 }, { SREF(L"gmrupdateserv"), 1070 }, { SREF(L"gntp"), 23053 }, { SREF(L"gnunet"), 2086 },
    { SREF(L"gnutella-rtr"), 6347 }, { SREF(L"gnutella-svc"), 6346 }, { SREF(L"go-login"), 491 }, { SREF(L"goahead-fldup"), 3057 },
    { SREF(L"gog-multiplayer"), 5687 }, { SREF(L"goldleaf-licman"), 1401 }, { SREF(L"golem"), 9005 }, { SREF(L"gopher"), 70 },
    { SREF(L"gotodevice"), 2217 }, { SREF(L"gpfs"), 1191 }, { SREF(L"gppitnp"), 103 }, { SREF(L"gprs-cube"), 3751 },
    { SREF(L"gprs-data"), 3386 }, { SREF(L"gprs-sig"), 3386 }, { SREF(L"gpsd"), 2947 }, { SREF(L"gradecam"), 5117 },
    { SREF(L"graphics"), 41 }, { SREF(L"grcmp"), 9122 }, { SREF(L"grcp"), 9123 }, { SREF(L"grf-port"), 3757 },
    { SREF(L"grid"), 6268 }, { SREF(L"grid-alt"), 6269 }, { SREF(L"gridgen-elmd"), 1542 }, { SREF(L"griffin"), 2458 },
    { SREF(L"gris"), 2135 }, { SREF(L"groove"), 2492 }, { SREF(L"groove-dpp"), 1211 }, { SREF(L"groupwise"), 1677 },
    { SREF(L"grubd"), 3136 }, { SREF(L"gsakmp"), 3761 }, { SREF(L"gsi"), 1850 }, { SREF(L"gsidcap"), 22128 },
    { SREF(L"gsiftp"), 2811 }, { SREF(L"gsigatekeeper"), 2119 }, { SREF(L"gsmp-ancp"), 6068 }, { SREF(L"gsms"), 16002 },
    { SREF(L"gsmtap"), 4729 }, { SREF(L"gss-http"), 488 }, { SREF(L"gss-xlicen"), 128 }, { SREF(L"gt-proxy"), 9889 },
    { SREF(L"gtaua"), 2186 }, { SREF(L"gte-samp"), 2643 }, { SREF(L"gtegsc-lm"), 1452 }, { SREF(L"gtp-controSREF(L"), 2123 },
    { SREF(L"gtp-user"), 2152 }, { SREF(L"gtrack-ne"), 3592 }, { SREF(L"gtrack-server"), 3591 }, { SREF(L"gue"), 6080 },
    { SREF(L"guibase"), 9321 }, { SREF(L"guttersnex"), 35356 }, { SREF(L"gv-pf"), 18262 }, { SREF(L"gv-us"), 1369 },
    { SREF(L"gvcp"), 3956 }, { SREF(L"gw"), 3010 }, { SREF(L"gw-asv"), 4842 }, { SREF(L"gw-call-port"), 3745 },
    { SREF(L"gw-log"), 4844 }, { SREF(L"gwen-sonya"), 2778 }, { SREF(L"gwha"), 1383 }, { SREF(L"gxs-data-port"), 2073 },
    { SREF(L"gxtelmd"), 2356 }, { SREF(L"h2250-annex-g"), 2099 }, { SREF(L"h248-binary"), 2945 }, { SREF(L"h263-video"), 2979 },
    { SREF(L"h2gf-w-2m"), 3179 }, { SREF(L"h323callsigalt"), 11720 }, { SREF(L"h323gatedisc"), 1718 }, { SREF(L"h323gatestat"), 1719 },
    { SREF(L"h323hostcalSREF(L"), 1720 }, { SREF(L"h323hostcallsc"), 1300 }, { SREF(L"ha-cluster"), 694 }, { SREF(L"hacl-cfg"), 5302 },
    { SREF(L"hacl-gs"), 5301 }, { SREF(L"hacl-hb"), 5300 }, { SREF(L"hacl-locaSREF(L"), 5304 }, { SREF(L"hacl-monitor"), 3542 },
    { SREF(L"hacl-polSREF(L"), 5315 }, { SREF(L"hacl-probe"), 5303 }, { SREF(L"hacl-qs"), 1238 }, { SREF(L"hacl-test"), 5305 },
    { SREF(L"hagel-dump"), 3036 }, { SREF(L"haipe-discover"), 3623 }, { SREF(L"haipe-otnk"), 3769 }, { SREF(L"hao"), 2245 },
    { SREF(L"hap"), 661 }, { SREF(L"harp"), 1816 }, { SREF(L"hart-ip"), 5094 }, { SREF(L"hassle"), 375 },
    { SREF(L"hawk"), 7630 }, { SREF(L"hb-engine"), 1703 }, { SREF(L"hbci"), 3000 }, { SREF(L"hcp-wismar"), 686 },
    { SREF(L"hdap"), 263 }, { SREF(L"hde-lcesrvr-1"), 14936 }, { SREF(L"hde-lcesrvr-2"), 14937 }, { SREF(L"hdl-srv"), 2641 },
    { SREF(L"health-polling"), 1161 }, { SREF(L"health-trap"), 1162 }, { SREF(L"healthd"), 1281 }, { SREF(L"heartbeat"), 3740 },
    { SREF(L"heathview"), 35000 }, { SREF(L"hecmtl-db"), 1551 }, { SREF(L"helix"), 10860 }, { SREF(L"hello"), 1789 },
    { SREF(L"hello-port"), 652 }, { SREF(L"hems"), 151 }, { SREF(L"here-lm"), 1409 }, { SREF(L"hermes"), 1248 },
    { SREF(L"herodotus-net"), 3921 }, { SREF(L"hexarc"), 7397 }, { SREF(L"hfcs"), 4900 }, { SREF(L"hfcs-manager"), 4999 },
    { SREF(L"hhb-gateway"), 1136 }, { SREF(L"hhb-handheld"), 4148 }, { SREF(L"hicp"), 3250 }, { SREF(L"hid"), 24322 },
    { SREF(L"high-criteria"), 2467 }, { SREF(L"hillrserv"), 4117 }, { SREF(L"hinp"), 9954 }, { SREF(L"hip-nat-t"), 10500 },
    { SREF(L"hiperscan-id"), 8293 }, { SREF(L"hippad"), 2988 }, { SREF(L"hiq"), 1410 }, { SREF(L"hislip"), 4880 },
    { SREF(L"hivep"), 12172 }, { SREF(L"hivestor"), 4884 }, { SREF(L"hkp"), 11371 }, { SREF(L"hks-lm"), 1722 },
    { SREF(L"hl7"), 2575 }, { SREF(L"hlibmgr"), 3634 }, { SREF(L"hlserver"), 3047 }, { SREF(L"hmmp-ind"), 612 },
    { SREF(L"hmmp-op"), 613 }, { SREF(L"hnm"), 6791 }, { SREF(L"hnmp"), 6790 }, { SREF(L"homeportal-web"), 3941 },
    { SREF(L"homesteadglory"), 2597 }, { SREF(L"honyaku"), 2744 }, { SREF(L"hostname"), 101 }, { SREF(L"hotu-chat"), 3449 },
    { SREF(L"houdini-lm"), 1715 }, { SREF(L"houston"), 4041 }, { SREF(L"hp-3000-telnet"), 2564 }, { SREF(L"hp-alarm-mgr"), 383 },
    { SREF(L"hp-clic"), 3384 }, { SREF(L"hp-collector"), 381 }, { SREF(L"hp-dataprotect"), 3612 }, { SREF(L"hp-device-disc"), 3329 },
    { SREF(L"hp-hcip"), 1782 }, { SREF(L"hp-hcip-gwy"), 1803 }, { SREF(L"hp-managed-node"), 382 }, { SREF(L"hp-nnm-data"), 2690 },
    { SREF(L"hp-pdl-datastr"), 9100 }, { SREF(L"hp-pxpib"), 3101 }, { SREF(L"hp-rda"), 2371 }, { SREF(L"hp-san-mgmt"), 3037 },
    { SREF(L"hp-sca"), 19411 }, { SREF(L"hp-sci"), 1299 }, { SREF(L"hp-sco"), 19410 }, { SREF(L"hp-server"), 5225 },
    { SREF(L"hp-sessmon"), 19412 }, { SREF(L"hp-status"), 5226 }, { SREF(L"hp-webadmin"), 1188 }, { SREF(L"hp-webqosdb"), 1877 },
    { SREF(L"hpbladems"), 5316 }, { SREF(L"hpdevms"), 5317 }, { SREF(L"hpidsadmin"), 2984 }, { SREF(L"hpidsagent"), 2985 },
    { SREF(L"hpiod"), 2208 }, { SREF(L"hpocbus"), 2206 }, { SREF(L"hpoms-ci-lstn"), 5403 }, { SREF(L"hpoms-dps-lstn"), 5404 },
    { SREF(L"hpppssvr"), 2448 }, { SREF(L"hppronetman"), 3908 }, { SREF(L"hpss-ndapi"), 1217 }, { SREF(L"hpssd"), 2207 },
    { SREF(L"hpssmgmt"), 4484 }, { SREF(L"hpstgmgr"), 2600 }, { SREF(L"hpstgmgr2"), 2715 }, { SREF(L"hpvirtctrSREF(L"), 5224 },
    { SREF(L"hpvirtgrp"), 5223 }, { SREF(L"hpvmmagent"), 1125 }, { SREF(L"hpvmmcontroSREF(L"), 1124 }, { SREF(L"hpvmmdata"), 1126 },
    { SREF(L"hpvroom"), 5228 }, { SREF(L"hrd-ncs"), 6324 }, { SREF(L"hrd-ns-disc"), 6324 }, { SREF(L"hri-port"), 3439 },
    { SREF(L"hrpd-ith-at-an"), 4592 }, { SREF(L"hs-port"), 2570 }, { SREF(L"hsl-storm"), 2113 }, { SREF(L"hsrp"), 1985 },
    { SREF(L"hsrpv6"), 2029 }, { SREF(L"htcp"), 4827 }, { SREF(L"htrust"), 5628 }, { SREF(L"http"), 80 },
    { SREF(L"http-alt"), 591 }, { SREF(L"http-alt"), 8008 }, { SREF(L"http-alt"), 8080 }, { SREF(L"http-mgmt"), 280 },
    { SREF(L"http-rpc-epmap"), 593 }, { SREF(L"http-wmap"), 8990 }, { SREF(L"https"), 443 }, { SREF(L"https-wmap"), 8991 },
    { SREF(L"httpx"), 4180 }, { SREF(L"htuilsrv"), 5023 }, { SREF(L"hub-open-net"), 8313 }, { SREF(L"hughes-ap"), 5105 },
    { SREF(L"husky"), 1310 }, { SREF(L"hybrid"), 1424 }, { SREF(L"hybrid-pop"), 473 }, { SREF(L"hydap"), 15000 },
    { SREF(L"hydra"), 2374 }, { SREF(L"hylafax"), 4559 }, { SREF(L"hyper-g"), 418 }, { SREF(L"hypercube-lm"), 1577 },
    { SREF(L"hyperip"), 3919 }, { SREF(L"hyperscsi-port"), 5674 }, { SREF(L"hyperwave-isp"), 692 }, { SREF(L"i-net-2000-npr"), 5069 },
    { SREF(L"i-zipqd"), 13160 }, { SREF(L"i3-sessionmgr"), 3952 }, { SREF(L"iadt"), 4169 }, { SREF(L"iadt-disc"), 4169 },
    { SREF(L"iadt-tls"), 9614 }, { SREF(L"iafdbase"), 480 }, { SREF(L"iafserver"), 479 }, { SREF(L"ianywhere-dbns"), 3968 },
    { SREF(L"iapp"), 2313 }, { SREF(L"ias-admind"), 2141 }, { SREF(L"ias-auth"), 2139 }, { SREF(L"ias-neighbor"), 4596 },
    { SREF(L"ias-paging"), 4595 }, { SREF(L"ias-reg"), 2140 }, { SREF(L"ias-session"), 4594 }, { SREF(L"iascontroSREF(L"), 1157 },
    { SREF(L"iascontrol-oms"), 1156 }, { SREF(L"iasd"), 432 }, { SREF(L"iatp-highpri"), 6998 }, { SREF(L"iatp-normalpri"), 6999 },
    { SREF(L"iax"), 4569 }, { SREF(L"ibar"), 5784 }, { SREF(L"iberiagames"), 1726 }, { SREF(L"ibm-abtact"), 1586 },
    { SREF(L"ibm-app"), 385 }, { SREF(L"ibm-cics"), 1435 }, { SREF(L"ibm-db2"), 523 }, { SREF(L"ibm-dial-out"), 3267 },
    { SREF(L"ibm-diradm"), 3538 }, { SREF(L"ibm-diradm-ssSREF(L"), 3539 }, { SREF(L"ibm-dt-2"), 1792 }, { SREF(L"ibm-mgr"), 3801 },
    { SREF(L"ibm-mqseries"), 1414 }, { SREF(L"ibm-mqseries2"), 1881 }, { SREF(L"ibm-pps"), 1376 }, { SREF(L"ibm-res"), 1405 },
    { SREF(L"ibm-rsyscon"), 9085 }, { SREF(L"ibm-ssd"), 1260 }, { SREF(L"ibm-wrless-lan"), 1461 }, { SREF(L"ibm3494"), 3494 },
    { SREF(L"ibp"), 2572 }, { SREF(L"ibprotocoSREF(L"), 6714 }, { SREF(L"ibridge-data"), 2275 }, { SREF(L"ibridge-mgmt"), 2276 },
    { SREF(L"ibus"), 8733 }, { SREF(L"ica"), 1494 }, { SREF(L"icabrowser"), 1604 }, { SREF(L"icad-eSREF(L"), 425 },
    { SREF(L"icap"), 1344 }, { SREF(L"iccrushmore"), 6850 }, { SREF(L"ice-location"), 4061 }, { SREF(L"ice-router"), 4063 },
    { SREF(L"ice-slocation"), 4062 }, { SREF(L"ice-srouter"), 4064 }, { SREF(L"iceedcp-rx"), 31949 }, { SREF(L"iceedcp-tx"), 31948 },
    { SREF(L"icg-bridge"), 2063 }, { SREF(L"icg-iprelay"), 2064 }, { SREF(L"icg-swp"), 2062 }, { SREF(L"ici"), 2200 },
    { SREF(L"icl-twobase1"), 25000 }, { SREF(L"icl-twobase10"), 25009 }, { SREF(L"icl-twobase2"), 25001 }, { SREF(L"icl-twobase3"), 25002 },
    { SREF(L"icl-twobase4"), 25003 }, { SREF(L"icl-twobase5"), 25004 }, { SREF(L"icl-twobase6"), 25005 }, { SREF(L"icl-twobase7"), 25006 },
    { SREF(L"icl-twobase8"), 25007 }, { SREF(L"icl-twobase9"), 25008 }, { SREF(L"iclcnet-locate"), 886 }, { SREF(L"iclcnet-svinfo"), 887 },
    { SREF(L"iclid"), 18242 }, { SREF(L"iclpv-dm"), 1389 }, { SREF(L"iclpv-nlc"), 1394 }, { SREF(L"iclpv-nls"), 1393 },
    { SREF(L"iclpv-pm"), 1392 }, { SREF(L"iclpv-sas"), 1391 }, { SREF(L"iclpv-sc"), 1390 }, { SREF(L"iclpv-wsm"), 1395 },
    { SREF(L"icmpd"), 5813 }, { SREF(L"icms"), 4486 }, { SREF(L"icon-discover"), 2799 }, { SREF(L"iconp"), 3972 },
    { SREF(L"iconstructsrv"), 6077 }, { SREF(L"icp"), 1112 }, { SREF(L"icpp"), 14142 }, { SREF(L"icpv2"), 3130 },
    { SREF(L"ics"), 5639 }, { SREF(L"icshostsvc"), 4553 }, { SREF(L"icslap"), 2869 }, { SREF(L"ida-discover1"), 5741 },
    { SREF(L"ida-discover2"), 5742 }, { SREF(L"idac"), 3881 }, { SREF(L"idcp"), 2326 }, { SREF(L"ideafarm-door"), 902 },
    { SREF(L"ideafarm-panic"), 903 }, { SREF(L"ideesrv"), 2337 }, { SREF(L"iden-ralp"), 1725 }, { SREF(L"ident"), 113 },
    { SREF(L"identify"), 2987 }, { SREF(L"idfp"), 549 }, { SREF(L"idig-mux"), 4152 }, { SREF(L"idmaps"), 1884 },
    { SREF(L"idmgratm"), 32896 }, { SREF(L"idonix-metanet"), 2112 }, { SREF(L"idotdist"), 2590 }, { SREF(L"idp"), 4067 },
    { SREF(L"idp-infotrieve"), 2966 }, { SREF(L"idps"), 3797 }, { SREF(L"idrs"), 2995 }, { SREF(L"idtp"), 25604 },
    { SREF(L"idware-router"), 2079 }, { SREF(L"idxp"), 603 }, { SREF(L"iec-104"), 2404 }, { SREF(L"iec-104-sec"), 19998 },
    { SREF(L"iee-qfx"), 1284 }, { SREF(L"ieee-mih"), 4551 }, { SREF(L"ieee-mms"), 651 }, { SREF(L"ieee-mms-ssSREF(L"), 695 },
    { SREF(L"ies-lm"), 1443 }, { SREF(L"ifcp-port"), 3420 }, { SREF(L"ife-icorp"), 5165 }, { SREF(L"ifor-protocoSREF(L"), 1515 },
    { SREF(L"ifsf-hb-port"), 3486 }, { SREF(L"ifsp"), 4744 }, { SREF(L"igcp"), 2801 }, { SREF(L"igi-lm"), 1404 },
    { SREF(L"igmpv3lite"), 465 }, { SREF(L"igo-incognito"), 4100 }, { SREF(L"igrid"), 19000 }, { SREF(L"igrs"), 3880 },
    { SREF(L"ii-admin"), 3006 }, { SREF(L"iims"), 4800 }, { SREF(L"iiop"), 535 }, { SREF(L"iiw-port"), 3186 },
    { SREF(L"ild"), 24321 }, { SREF(L"ilSREF(L"), 1611 }, { SREF(L"ilss"), 4802 }, { SREF(L"imagepump"), 27345 },
    { SREF(L"imagequery"), 2239 }, { SREF(L"imap"), 143 }, { SREF(L"imap3"), 220 }, { SREF(L"imaps"), 993 },
    { SREF(L"imdocsvc"), 2637 }, { SREF(L"imgames"), 1077 }, { SREF(L"imink"), 8615 }, { SREF(L"imip"), 11319 },
    { SREF(L"imip-channels"), 11320 }, { SREF(L"immedianet-bcn"), 3657 }, { SREF(L"imoguia-port"), 3907 }, { SREF(L"impera"), 1710 },
    { SREF(L"imprs"), 3164 }, { SREF(L"imqbrokerd"), 7676 }, { SREF(L"imqstomp"), 7672 }, { SREF(L"imqstomps"), 7673 },
    { SREF(L"imqtunneSREF(L"), 7675 }, { SREF(L"imqtunnels"), 7674 }, { SREF(L"imsldoc"), 2035 }, { SREF(L"imsp"), 406 },
    { SREF(L"imtc-map"), 2202 }, { SREF(L"imtc-mcs"), 1503 }, { SREF(L"imyx"), 1143 }, { SREF(L"inbusiness"), 244 },
    { SREF(L"incognitorv"), 3139 }, { SREF(L"incp"), 2932 }, { SREF(L"index-net"), 2970 }, { SREF(L"index-pc-wb"), 2127 },
    { SREF(L"indi"), 7624 }, { SREF(L"indigo-server"), 1176 }, { SREF(L"indigo-vbcp"), 8131 }, { SREF(L"indigo-vrmi"), 8130 },
    { SREF(L"indura"), 3156 }, { SREF(L"indx-dds"), 2454 }, { SREF(L"indy"), 5963 }, { SREF(L"infi-async"), 8067 },
    { SREF(L"infiniswitchcSREF(L"), 3602 }, { SREF(L"influence"), 3345 }, { SREF(L"infobright"), 5029 }, { SREF(L"infocrypt"), 2233 },
    { SREF(L"infoexch"), 3667 }, { SREF(L"infolibria"), 2319 }, { SREF(L"infoman"), 1451 }, { SREF(L"infomover"), 2854 },
    { SREF(L"informatik-lm"), 1428 }, { SREF(L"informer"), 3856 }, { SREF(L"infoseek"), 414 }, { SREF(L"infotos"), 18881 },
    { SREF(L"infowave"), 2082 }, { SREF(L"ingres-net"), 134 }, { SREF(L"ingreslock"), 1524 }, { SREF(L"ininmessaging"), 5597 },
    { SREF(L"iniserve-port"), 3560 }, { SREF(L"initlsmsad"), 2793 }, { SREF(L"innosys"), 1412 }, { SREF(L"innosys-acSREF(L"), 1413 },
    { SREF(L"inova-ip-disco"), 2716 }, { SREF(L"inovaport1"), 23000 }, { SREF(L"inovaport2"), 23001 }, { SREF(L"inovaport3"), 23002 },
    { SREF(L"inovaport4"), 23003 }, { SREF(L"inovaport5"), 23004 }, { SREF(L"inovaport6"), 23005 }, { SREF(L"insis"), 9215 },
    { SREF(L"insitu-conf"), 1490 }, { SREF(L"inspect"), 1602 }, { SREF(L"inst-discovery"), 4878 }, { SREF(L"instantia"), 1240 },
    { SREF(L"instl-bootc"), 1068 }, { SREF(L"instl-boots"), 1067 }, { SREF(L"int-rcv-cntrSREF(L"), 3603 }, { SREF(L"intecom-ps1"), 5056 },
    { SREF(L"intecom-ps2"), 5057 }, { SREF(L"intecourier"), 495 }, { SREF(L"integra-sme"), 484 }, { SREF(L"integraSREF(L"), 3459 },
    { SREF(L"integrius-stp"), 17234 }, { SREF(L"intel-rci"), 24386 }, { SREF(L"intel-rci-mp"), 16991 }, { SREF(L"intellistor-lm"), 1539 },
    { SREF(L"intelsync"), 3692 }, { SREF(L"intel_rci"), 24386 }, { SREF(L"interact"), 4052 }, { SREF(L"interactionweb"), 3508 },
    { SREF(L"interbase"), 2041 }, { SREF(L"interhdl-elmd"), 1454 }, { SREF(L"interintelli"), 2633 }, { SREF(L"intermapper"), 8181 },
    { SREF(L"interpathpaneSREF(L"), 2652 }, { SREF(L"intersan"), 1331 }, { SREF(L"interserver"), 3060 }, { SREF(L"intersys-cache"), 1972 },
    { SREF(L"interwise"), 7778 }, { SREF(L"interworld"), 3548 }, { SREF(L"intraintra"), 3202 }, { SREF(L"intrastar"), 1907 },
    { SREF(L"intrepid-ssSREF(L"), 11751 }, { SREF(L"intrinsa"), 503 }, { SREF(L"intu-ec-client"), 8021 }, { SREF(L"intu-ec-svcdisc"), 8020 },
    { SREF(L"intuitive-edge"), 1355 }, { SREF(L"intv"), 1585 }, { SREF(L"invision"), 1641 }, { SREF(L"invision-ag"), 45054 },
    { SREF(L"invokator"), 2006 }, { SREF(L"io-dist-data"), 5728 }, { SREF(L"io-dist-group"), 5728 }, { SREF(L"ioc-sea-lm"), 1579 },
    { SREF(L"ionixnetmon"), 7410 }, { SREF(L"iop"), 2055 }, { SREF(L"ip-blf"), 2088 }, { SREF(L"ip-provision"), 43190 },
    { SREF(L"ip-qsig"), 4029 }, { SREF(L"ipass"), 2549 }, { SREF(L"ipcd"), 576 }, { SREF(L"ipcd3"), 1209 },
    { SREF(L"ipcore"), 2215 }, { SREF(L"ipcs-command"), 3743 }, { SREF(L"ipcserver"), 600 }, { SREF(L"ipdcesgbs"), 9214 },
    { SREF(L"ipdd"), 578 }, { SREF(L"ipdr-sp"), 4737 }, { SREF(L"ipdtp-port"), 20202 }, { SREF(L"ipether232port"), 3497 },
    { SREF(L"ipfix"), 4739 }, { SREF(L"ipfixs"), 4740 }, { SREF(L"ipfltbcst"), 4068 }, { SREF(L"iph-policy-adm"), 2963 },
    { SREF(L"iph-policy-cli"), 2962 }, { SREF(L"iposplanet"), 7031 }, { SREF(L"ipp"), 631 }, { SREF(L"ipr-dglt"), 3678 },
    { SREF(L"ipsec-nat-t"), 4500 }, { SREF(L"ipsendmsg"), 1992 }, { SREF(L"ipt-anri-anri"), 4593 }, { SREF(L"ipulse-ics"), 20222 },
    { SREF(L"ipx"), 213 }, { SREF(L"iqnet-port"), 3804 }, { SREF(L"iqobject"), 48619 }, { SREF(L"iqrm"), 10117 },
    { SREF(L"iqserver"), 2527 }, { SREF(L"ique"), 18769 }, { SREF(L"iracinghelper"), 32034 }, { SREF(L"iRAPP"), 4073 },
    { SREF(L"irc"), 194 }, { SREF(L"irc-serv"), 529 }, { SREF(L"ircs-u"), 6697 }, { SREF(L"ircu"), 6665 },
    { SREF(L"ircu"), 6666 }, { SREF(L"ircu"), 6667 }, { SREF(L"ircu"), 6668 }, { SREF(L"ircu"), 6669 },
    { SREF(L"irdg-post"), 2632 }, { SREF(L"irdmi"), 8000 }, { SREF(L"irdmi2"), 7999 }, { SREF(L"iris-beep"), 702 },
    { SREF(L"iris-lwz"), 715 }, { SREF(L"iris-xpc"), 713 }, { SREF(L"iris-xpcs"), 714 }, { SREF(L"irisa"), 11000 },
    { SREF(L"ironmaiSREF(L"), 3206 }, { SREF(L"ironstorm"), 3504 }, { SREF(L"irp"), 4604 }, { SREF(L"irtrans"), 21000 },
    { SREF(L"is99c"), 379 }, { SREF(L"is99s"), 380 }, { SREF(L"isakmp"), 500 }, { SREF(L"isbconference1"), 1244 },
    { SREF(L"isbconference2"), 1245 }, { SREF(L"iscape"), 5047 }, { SREF(L"ischat"), 1336 }, { SREF(L"iscsi"), 860 },
    { SREF(L"iscsi-target"), 3260 }, { SREF(L"isdc"), 1636 }, { SREF(L"isdd"), 8148 }, { SREF(L"isg-uda-server"), 2551 },
    { SREF(L"isi-gSREF(L"), 55 }, { SREF(L"isi-irp"), 3226 }, { SREF(L"isis"), 2042 }, { SREF(L"isis-am"), 1642 },
    { SREF(L"isis-ambc"), 1643 }, { SREF(L"isis-bcast"), 2043 }, { SREF(L"islc"), 1637 }, { SREF(L"ismaeasdaqlive"), 1949 },
    { SREF(L"ismaeasdaqtest"), 1950 }, { SREF(L"ismc"), 1638 }, { SREF(L"ismserver"), 9500 }, { SREF(L"isnetserv"), 48128 },
    { SREF(L"isns"), 3205 }, { SREF(L"iso-ilSREF(L"), 499 }, { SREF(L"iso-ip"), 147 }, { SREF(L"iso-tp0"), 146 },
    { SREF(L"iso-tp0s"), 3782 }, { SREF(L"iso-tsap"), 102 }, { SREF(L"iso-tsap-c2"), 399 }, { SREF(L"isode-dua"), 17007 },
    { SREF(L"isoft-p2p"), 3501 }, { SREF(L"isoipsigport-1"), 1106 }, { SREF(L"isoipsigport-2"), 1107 }, { SREF(L"isomair"), 3589 },
    { SREF(L"ispipes"), 2853 }, { SREF(L"ispmmgr"), 3775 }, { SREF(L"isrp-port"), 3788 }, { SREF(L"iss-mgmt-ssSREF(L"), 3995 },
    { SREF(L"issd"), 1600 }, { SREF(L"isysg-lm"), 1609 }, { SREF(L"ita-agent"), 5051 }, { SREF(L"ita-manager"), 5052 },
    { SREF(L"itach"), 8184 }, { SREF(L"itactionserver1"), 7280 }, { SREF(L"itactionserver2"), 7281 }, { SREF(L"italk"), 12345 },
    { SREF(L"itap-ddtp"), 10100 }, { SREF(L"itelserverport"), 3719 }, { SREF(L"item"), 3848 }, { SREF(L"itinternet"), 2691 },
    { SREF(L"itm-lm"), 2828 }, { SREF(L"itm-mccs"), 3084 }, { SREF(L"itm-mcell-s"), 828 }, { SREF(L"itm-mcell-u"), 1828 },
    { SREF(L"ito-e-gui"), 2531 }, { SREF(L"itose"), 4348 }, { SREF(L"itscomm-ns"), 1573 }, { SREF(L"itu-bicc-stc"), 3097 },
    { SREF(L"itv-controSREF(L"), 3899 }, { SREF(L"itwo-server"), 4410 }, { SREF(L"iua"), 9900 }, { SREF(L"iuhsctpassoc"), 29169 },
    { SREF(L"ivcollector"), 1275 }, { SREF(L"ivecon-port"), 3258 }, { SREF(L"ivocalize"), 5049 }, { SREF(L"ivs-database"), 38000 },
    { SREF(L"ivs-insertion"), 38001 }, { SREF(L"ivs-video"), 2232 }, { SREF(L"ivsd"), 2241 }, { SREF(L"iw-mmogame"), 3596 },
    { SREF(L"iwb-whiteboard"), 2982 }, { SREF(L"iwec"), 4801 }, { SREF(L"iwg1"), 7071 }, { SREF(L"iwlistener"), 2866 },
    { SREF(L"iwserver"), 2166 }, { SREF(L"izm"), 4109 }, { SREF(L"j-ac"), 4107 }, { SREF(L"j-lan-p"), 2808 },
    { SREF(L"j-link"), 19020 }, { SREF(L"jacobus-lm"), 1578 }, { SREF(L"jaleosnd"), 1623 }, { SREF(L"jamlink"), 8091 },
    { SREF(L"jamserverport"), 3627 }, { SREF(L"janus-disc"), 7181 }, { SREF(L"jargon"), 148 }, { SREF(L"jaugsremotec-1"), 3472 },
    { SREF(L"jaugsremotec-2"), 3473 }, { SREF(L"jaus"), 3794 }, { SREF(L"jaxer-manager"), 4328 }, { SREF(L"jaxer-web"), 4327 },
    { SREF(L"jaxflow"), 5229 }, { SREF(L"jaxflow-data"), 5230 }, { SREF(L"jboss-iiop"), 3528 }, { SREF(L"jboss-iiop-ssSREF(L"), 3529 },
    { SREF(L"jbroker"), 2506 }, { SREF(L"jcp"), 19541 }, { SREF(L"jdatastore"), 2508 }, { SREF(L"jdl-dbkitchen"), 3086 },
    { SREF(L"jdmn-port"), 4030 }, { SREF(L"jdp-disc"), 7095 }, { SREF(L"jediserver"), 2406 }, { SREF(L"jeol-nsddp-1"), 6241 },
    { SREF(L"jeol-nsddp-2"), 6242 }, { SREF(L"jeol-nsddp-3"), 6243 }, { SREF(L"jeol-nsddp-4"), 6244 }, { SREF(L"jeol-nsdtp-1"), 6241 },
    { SREF(L"jeol-nsdtp-2"), 6242 }, { SREF(L"jeol-nsdtp-3"), 6243 }, { SREF(L"jeol-nsdtp-4"), 6244 }, { SREF(L"jerand-lm"), 1810 },
    { SREF(L"jesmsjc"), 27442 }, { SREF(L"jetcmeserver"), 1936 }, { SREF(L"jetform"), 1706 }, { SREF(L"jetformpreview"), 2097 },
    { SREF(L"jetstream"), 6901 }, { SREF(L"jibe-eb"), 3777 }, { SREF(L"jini-discovery"), 4160 }, { SREF(L"jlicelmd"), 1567 },
    { SREF(L"jmact3"), 6961 }, { SREF(L"jmact5"), 2957 }, { SREF(L"jmact6"), 2958 }, { SREF(L"jmb-cds1"), 8900 },
    { SREF(L"jmb-cds2"), 8901 }, { SREF(L"jmevt2"), 6962 }, { SREF(L"jmq-daemon-1"), 3214 }, { SREF(L"jmq-daemon-2"), 3215 },
    { SREF(L"jms"), 5673 }, { SREF(L"joaJewelSuite"), 6583 }, { SREF(L"joltid"), 3531 }, { SREF(L"jomamqmonitor"), 4114 },
    { SREF(L"joost"), 4166 }, { SREF(L"journee"), 3042 }, { SREF(L"jpegmpeg"), 3155 }, { SREF(L"jprinter"), 5309 },
    { SREF(L"jps"), 2205 }, { SREF(L"jsteSREF(L"), 1064 }, { SREF(L"jt400"), 3470 }, { SREF(L"jt400-ssSREF(L"), 3471 },
    { SREF(L"jtag-server"), 1309 }, { SREF(L"jute"), 5883 }, { SREF(L"juxml-port"), 3642 }, { SREF(L"jvclient"), 1940 },
    { SREF(L"jvl-mactalk"), 47100 }, { SREF(L"jvserver"), 1939 }, { SREF(L"jwalkserver"), 1289 }, { SREF(L"jwclient"), 1938 },
    { SREF(L"jwpc"), 16020 }, { SREF(L"jwpc-bin"), 16021 }, { SREF(L"jwserver"), 1937 }, { SREF(L"k-block"), 287 },
    { SREF(L"k3software-cli"), 26263 }, { SREF(L"k3software-svr"), 26262 }, { SREF(L"ka0wuc"), 2822 }, { SREF(L"kali"), 2213 },
    { SREF(L"kana"), 2656 }, { SREF(L"kar2ouche"), 4661 }, { SREF(L"kastenchasepad"), 2918 }, { SREF(L"kastenxpipe"), 36865 },
    { SREF(L"kazaa"), 1214 }, { SREF(L"kca-service"), 9878 }, { SREF(L"kdm"), 2115 }, { SREF(L"kdnet"), 5364 },
    { SREF(L"kentrox-prot"), 2502 }, { SREF(L"kerberos"), 88 }, { SREF(L"kerberos-adm"), 749 }, { SREF(L"kerberos-iv"), 750 },
    { SREF(L"kermit"), 1649 }, { SREF(L"keyserver"), 584 }, { SREF(L"keyshadow"), 19315 }, { SREF(L"keysrvr"), 19283 },
    { SREF(L"kfserver"), 5343 }, { SREF(L"kftp"), 6621 }, { SREF(L"kftp-data"), 6620 }, { SREF(L"kfxaclicensing"), 3581 },
    { SREF(L"kingdomsonline"), 30260 }, { SREF(L"kingfisher"), 4058 }, { SREF(L"kink"), 910 }, { SREF(L"kiosk"), 1061 },
    { SREF(L"kis"), 186 }, { SREF(L"kitim"), 35354 }, { SREF(L"kjtsiteserver"), 1339 }, { SREF(L"klio"), 7697 },
    { SREF(L"klogin"), 543 }, { SREF(L"kme-trap-port"), 2081 }, { SREF(L"kmip"), 5696 }, { SREF(L"kmscontroSREF(L"), 1773 },
    { SREF(L"knet-cmp"), 157 }, { SREF(L"kofax-svr"), 2424 }, { SREF(L"konshus-lm"), 2294 }, { SREF(L"konspire2b"), 6085 },
    { SREF(L"kopek-httphead"), 27504 }, { SREF(L"kpasswd"), 464 }, { SREF(L"kpdp"), 5253 }, { SREF(L"kpn-icw"), 3699 },
    { SREF(L"krb524"), 4444 }, { SREF(L"krb5gatekeeper"), 1318 }, { SREF(L"kryptolan"), 398 }, { SREF(L"kshelSREF(L"), 544 },
    { SREF(L"ksysguard"), 3112 }, { SREF(L"ktelnet"), 6623 }, { SREF(L"kti-icad-srvr"), 6701 }, { SREF(L"ktickets-rest"), 4331 },
    { SREF(L"kv-agent"), 3361 }, { SREF(L"kv-server"), 3360 }, { SREF(L"kvm-via-ip"), 1132 }, { SREF(L"kwdb-commn"), 1127 },
    { SREF(L"kwtc"), 4566 }, { SREF(L"kyoceranetdev"), 1063 }, { SREF(L"kz-migr"), 8102 }, { SREF(L"l-acoustics"), 4432 },
    { SREF(L"l2c-controSREF(L"), 4371 }, { SREF(L"l2c-data"), 4372 }, { SREF(L"l2c-disc"), 4371 }, { SREF(L"l2f"), 1701 },
    { SREF(L"l2tp"), 1701 }, { SREF(L"l3-exprt"), 2840 }, { SREF(L"l3-hawk"), 2842 }, { SREF(L"l3-hbmon"), 2370 },
    { SREF(L"l3-ranger"), 2841 }, { SREF(L"l3t-at-an"), 4591 }, { SREF(L"l5nas-parchan"), 9747 }, { SREF(L"labrat"), 2560 },
    { SREF(L"laes-bf"), 9536 }, { SREF(L"lam"), 2040 }, { SREF(L"lan900-remote"), 2395 }, { SREF(L"landmarks"), 3969 },
    { SREF(L"lanmessenger"), 2372 }, { SREF(L"lanner-lm"), 4547 }, { SREF(L"lanrevagent"), 3970 }, { SREF(L"lanrevserver"), 3971 },
    { SREF(L"lanschooSREF(L"), 11796 }, { SREF(L"lanschool-mpt"), 11796 }, { SREF(L"lanserver"), 637 }, { SREF(L"lansource"), 1485 },
    { SREF(L"lansurveyor"), 4347 }, { SREF(L"lansurveyorxmSREF(L"), 3815 }, { SREF(L"lanyon-lantern"), 1682 }, { SREF(L"laplink"), 1547 },
    { SREF(L"launchbird-lm"), 3739 }, { SREF(L"lavenir-lm"), 3373 }, { SREF(L"lazy-ptop"), 7099 }, { SREF(L"lbc-controSREF(L"), 2780 },
    { SREF(L"lbc-measure"), 2815 }, { SREF(L"lbc-sync"), 2779 }, { SREF(L"lbc-watchdog"), 2816 }, { SREF(L"lbf"), 2466 },
    { SREF(L"lbm"), 2465 }, { SREF(L"lcm-server"), 7365 }, { SREF(L"lcs-ap"), 9082 }, { SREF(L"ldap"), 389 },
    { SREF(L"ldap-admin"), 3407 }, { SREF(L"ldaps"), 636 }, { SREF(L"ldgateway"), 9592 }, { SREF(L"ldoms-mgmt"), 6482 },
    { SREF(L"ldoms-migr"), 8101 }, { SREF(L"ldp"), 646 }, { SREF(L"lds-distrib"), 6543 }, { SREF(L"lds-dump"), 6544 },
    { SREF(L"ldss"), 6087 }, { SREF(L"ldxp"), 4042 }, { SREF(L"lecroy-vicp"), 1861 }, { SREF(L"leecoposserver"), 2212 },
    { SREF(L"legent-1"), 373 }, { SREF(L"legent-2"), 374 }, { SREF(L"leoip"), 1886 }, { SREF(L"lhtp"), 1983 },
    { SREF(L"liberty-lm"), 1496 }, { SREF(L"licensedaemon"), 1986 }, { SREF(L"LiebDevMgmt-A"), 3029 }, { SREF(L"LiebDevMgmt-C"), 3027 },
    { SREF(L"LiebDevMgmt-DM"), 3028 }, { SREF(L"light"), 4670 }, { SREF(L"limnerpressure"), 8191 }, { SREF(L"link"), 245 },
    { SREF(L"linkname"), 1903 }, { SREF(L"linktest"), 3746 }, { SREF(L"linktest-s"), 3747 }, { SREF(L"linogridengine"), 12300 },
    { SREF(L"linx"), 1361 }, { SREF(L"lionhead"), 2611 }, { SREF(L"lipsinc"), 1968 }, { SREF(L"lipsinc1"), 1969 },
    { SREF(L"lisp-cons"), 4342 }, { SREF(L"lisp-controSREF(L"), 4342 }, { SREF(L"lisp-data"), 4341 }, { SREF(L"lispworks-orb"), 3672 },
    { SREF(L"listcrt-port"), 3913 }, { SREF(L"listcrt-port-2"), 3914 }, { SREF(L"listmgr-port"), 3767 }, { SREF(L"livelan"), 1555 },
    { SREF(L"livestats"), 2795 }, { SREF(L"ljk-login"), 472 }, { SREF(L"lkcmserver"), 3278 }, { SREF(L"llm-csv"), 2814 },
    { SREF(L"llm-pass"), 2813 }, { SREF(L"llmnr"), 5355 }, { SREF(L"llrp"), 5084 }, { SREF(L"llsurfup-http"), 1183 },
    { SREF(L"llsurfup-https"), 1184 }, { SREF(L"lm-dta"), 8206 }, { SREF(L"lm-instmgr"), 8205 }, { SREF(L"lm-mon"), 31620 },
    { SREF(L"lm-perfworks"), 8204 }, { SREF(L"lm-sserver"), 8207 }, { SREF(L"lm-webwatcher"), 8208 }, { SREF(L"lm-x"), 6200 },
    { SREF(L"lmcs"), 4877 }, { SREF(L"lmdp"), 2623 }, { SREF(L"lmp"), 701 }, { SREF(L"lms"), 4056 },
    { SREF(L"lmsocialserver"), 1111 }, { SREF(L"lnvalarm"), 2282 }, { SREF(L"lnvconsole"), 2281 }, { SREF(L"lnvmailmon"), 2285 },
    { SREF(L"lnvmaps"), 2284 }, { SREF(L"lnvpoller"), 2280 }, { SREF(L"lnvstatus"), 2283 }, { SREF(L"loadav"), 750 },
    { SREF(L"loaprobe"), 1634 }, { SREF(L"localinfosrvr"), 1487 }, { SREF(L"lockstep"), 2125 }, { SREF(L"locus-con"), 127 },
    { SREF(L"locus-disc"), 5058 }, { SREF(L"locus-map"), 125 }, { SREF(L"lofr-lm"), 1752 }, { SREF(L"logcabin"), 5254 },
    { SREF(L"login"), 513 }, { SREF(L"lonewolf-lm"), 6146 }, { SREF(L"lontalk-norm"), 1628 }, { SREF(L"lontalk-urgnt"), 1629 },
    { SREF(L"lonworks"), 2540 }, { SREF(L"lonworks2"), 2541 }, { SREF(L"lorica-in"), 4080 }, { SREF(L"lorica-in-sec"), 4081 },
    { SREF(L"lorica-out"), 4082 }, { SREF(L"lorica-out-sec"), 4083 }, { SREF(L"lot105-ds-upd"), 2053 }, { SREF(L"lotusmtap"), 3007 },
    { SREF(L"lotusnote"), 1352 }, { SREF(L"lpar2rrd"), 8162 }, { SREF(L"lpcp"), 1298 }, { SREF(L"lpdg"), 10805 },
    { SREF(L"lpsrecommender"), 2620 }, { SREF(L"lrp"), 2090 }, { SREF(L"lrs-paging"), 3700 }, { SREF(L"ls3"), 3069 },
    { SREF(L"ls3bcast"), 3068 }, { SREF(L"lsdp"), 11430 }, { SREF(L"lsi-bobcat"), 5574 }, { SREF(L"lsi-raid-mgmt"), 2463 },
    { SREF(L"lsp-ping"), 3503 }, { SREF(L"lstp"), 2559 }, { SREF(L"ltctcp"), 3487 }, { SREF(L"ltcudp"), 3487 },
    { SREF(L"ltp"), 4044 }, { SREF(L"ltp-deepspace"), 1113 }, { SREF(L"lumimgrd"), 4741 }, { SREF(L"lupa"), 1212 },
    { SREF(L"lutap"), 4912 }, { SREF(L"lutcp"), 4913 }, { SREF(L"lv-auth"), 2147 }, { SREF(L"lv-ffx"), 2144 },
    { SREF(L"lv-frontpaneSREF(L"), 3079 }, { SREF(L"lv-jc"), 2143 }, { SREF(L"lv-not"), 2146 }, { SREF(L"lv-pici"), 2145 },
    { SREF(L"lvision-lm"), 6471 }, { SREF(L"lxi-evntsvc"), 5044 }, { SREF(L"lyskom"), 4894 }, { SREF(L"m-wnn"), 3732 },
    { SREF(L"m2ap"), 36443 }, { SREF(L"m2mservices"), 8383 }, { SREF(L"m2pa"), 3565 }, { SREF(L"m2ua"), 2904 },
    { SREF(L"m3ap"), 36444 }, { SREF(L"m3da"), 44900 }, { SREF(L"m3da-disc"), 44900 }, { SREF(L"m3ua"), 2905 },
    { SREF(L"m4-network-as"), 4345 }, { SREF(L"mac-srvr-admin"), 660 }, { SREF(L"macbak"), 4181 }, { SREF(L"macon-tcp"), 456 },
    { SREF(L"macon-udp"), 456 }, { SREF(L"macromedia-fcs"), 1935 }, { SREF(L"madcap"), 2535 }, { SREF(L"madge-ltd"), 2453 },
    { SREF(L"magaya-network"), 3691 }, { SREF(L"magbind"), 3194 }, { SREF(L"magenta-logic"), 313 }, { SREF(L"magiccontroSREF(L"), 4902 },
    { SREF(L"magicnotes"), 3023 }, { SREF(L"magicom"), 2243 }, { SREF(L"magpie"), 5092 }, { SREF(L"mailbox"), 2004 },
    { SREF(L"mailbox-lm"), 505 }, { SREF(L"mailprox"), 3936 }, { SREF(L"mailq"), 174 }, { SREF(L"maincontroSREF(L"), 2516 },
    { SREF(L"mainsoft-lm"), 1593 }, { SREF(L"maitrd"), 997 }, { SREF(L"manage-exec"), 2342 }, { SREF(L"manet"), 269 },
    { SREF(L"manyone-http"), 8910 }, { SREF(L"manyone-xmSREF(L"), 8911 }, { SREF(L"mao"), 2908 }, { SREF(L"mapper-mapethd"), 3985 },
    { SREF(L"mapper-nodemgr"), 3984 }, { SREF(L"mapper-ws-ethd"), 3986 }, { SREF(L"mapx"), 36700 }, { SREF(L"marcam-lm"), 1444 },
    { SREF(L"markem-dcp"), 3836 }, { SREF(L"martalk"), 7073 }, { SREF(L"masc"), 2587 }, { SREF(L"masqdialer"), 224 },
    { SREF(L"matahari"), 49000 }, { SREF(L"matip-type-a"), 350 }, { SREF(L"matip-type-b"), 351 }, { SREF(L"matrix-vnet"), 4360 },
    { SREF(L"max"), 6074 }, { SREF(L"maxim-asics"), 3276 }, { SREF(L"MaxumSP"), 4179 }, { SREF(L"maytagshuffle"), 2591 },
    { SREF(L"mbap"), 502 }, { SREF(L"mbap-s"), 802 }, { SREF(L"mbg-ctrSREF(L"), 3569 }, { SREF(L"mbl-battd"), 4153 },
    { SREF(L"mbus"), 47000 }, { SREF(L"mc-appserver"), 8763 }, { SREF(L"mc-brk-srv"), 3180 }, { SREF(L"mc-client"), 1180 },
    { SREF(L"mc-comm"), 9632 }, { SREF(L"mc-gt-srv"), 2180 }, { SREF(L"mc2studios"), 1899 }, { SREF(L"mc3ss"), 3521 },
    { SREF(L"mcagent"), 1820 }, { SREF(L"mccwebsvr-port"), 3570 }, { SREF(L"mcer-port"), 6510 }, { SREF(L"mcftp"), 6622 },
    { SREF(L"mcidas"), 112 }, { SREF(L"mck-ivpip"), 2698 }, { SREF(L"mcns-sec"), 638 }, { SREF(L"mcns-tel-ret"), 3311 },
    { SREF(L"mcntp"), 5418 }, { SREF(L"mcp"), 4458 }, { SREF(L"mcp-port"), 3558 }, { SREF(L"mcreport"), 8003 },
    { SREF(L"mcs-calypsoicf"), 3330 }, { SREF(L"mcs-fastmaiSREF(L"), 3302 }, { SREF(L"mcs-mailsvr"), 3332 }, { SREF(L"mcs-messaging"), 3331 },
    { SREF(L"mctet-gateway"), 3116 }, { SREF(L"mctet-jserv"), 3117 }, { SREF(L"mctet-master"), 3115 }, { SREF(L"mctfeed"), 5598 },
    { SREF(L"mctp"), 1100 }, { SREF(L"md-cg-http"), 2688 }, { SREF(L"mdap-port"), 3235 }, { SREF(L"mdbs-daemon"), 800 },
    { SREF(L"mdc-portmapper"), 685 }, { SREF(L"mdm"), 7871 }, { SREF(L"mdns"), 5353 }, { SREF(L"mdnsresponder"), 5354 },
    { SREF(L"mdqs"), 666 }, { SREF(L"mdtp"), 3232 }, { SREF(L"mecomm"), 668 }, { SREF(L"med-ci"), 24005 },
    { SREF(L"med-fsp-rx"), 24001 }, { SREF(L"med-fsp-tx"), 24002 }, { SREF(L"med-ltp"), 24000 }, { SREF(L"med-net-svc"), 24006 },
    { SREF(L"med-ovw"), 24004 }, { SREF(L"med-supp"), 24003 }, { SREF(L"medevolve"), 13930 }, { SREF(L"media-agent"), 2789 },
    { SREF(L"mediabox"), 46999 }, { SREF(L"mediacntrlnfsd"), 2363 }, { SREF(L"mediaspace"), 3594 }, { SREF(L"mediat"), 5157 },
    { SREF(L"mediavault-gui"), 3673 }, { SREF(L"medimageportaSREF(L"), 7720 }, { SREF(L"megaco-h248"), 2944 }, { SREF(L"megardsvr-port"), 3571 },
    { SREF(L"megaregsvrport"), 3572 }, { SREF(L"memcache"), 11211 }, { SREF(L"menandmice-dns"), 1337 }, { SREF(L"menandmice-lpm"), 1231 },
    { SREF(L"menandmice-mon"), 4552 }, { SREF(L"menandmice-noh"), 4151 }, { SREF(L"menandmice-upg"), 4603 }, { SREF(L"mentaclient"), 2117 },
    { SREF(L"mentaserver"), 2118 }, { SREF(L"mercantile"), 3398 }, { SREF(L"mercury-disc"), 9596 }, { SREF(L"meregister"), 669 },
    { SREF(L"mesavistaco"), 1249 }, { SREF(L"messageasap"), 6070 }, { SREF(L"messageservice"), 2311 }, { SREF(L"meta-corp"), 6141 },
    { SREF(L"meta5"), 393 }, { SREF(L"metaagent"), 1897 }, { SREF(L"metaconsole"), 2850 }, { SREF(L"metaedit-mu"), 6360 },
    { SREF(L"metaedit-se"), 6370 }, { SREF(L"metaedit-ws"), 6390 }, { SREF(L"metagram"), 99 }, { SREF(L"metalbend"), 7172 },
    { SREF(L"metasage"), 1207 }, { SREF(L"metastorm"), 2511 }, { SREF(L"metasys"), 11001 }, { SREF(L"metatude-mds"), 6382 },
    { SREF(L"meter"), 570 }, { SREF(L"meter"), 571 }, { SREF(L"metricadbc"), 2622 }, { SREF(L"metrics-pas"), 1824 },
    { SREF(L"mevent"), 7900 }, { SREF(L"mfcoboSREF(L"), 86 }, { SREF(L"mfserver"), 2266 }, { SREF(L"mftp"), 349 },
    { SREF(L"mftp"), 5402 }, { SREF(L"mgcp-callagent"), 2727 }, { SREF(L"mgcp-gateway"), 2427 }, { SREF(L"mgcs-mfp-port"), 6509 },
    { SREF(L"mgemanagement"), 4680 }, { SREF(L"mgesupervision"), 4679 }, { SREF(L"mgxswitch"), 3070 }, { SREF(L"miami-bcast"), 6083 },
    { SREF(L"mib-streaming"), 2292 }, { SREF(L"mice"), 5022 }, { SREF(L"micom-pfs"), 490 }, { SREF(L"microcom-sbp"), 1680 },
    { SREF(L"micromuse-lm"), 1534 }, { SREF(L"micromuse-ncps"), 7979 }, { SREF(L"micromuse-ncpw"), 9600 }, { SREF(L"microsan"), 20001 },
    { SREF(L"microsoft-ds"), 445 }, { SREF(L"microtalon-com"), 7014 }, { SREF(L"microtalon-dis"), 7013 }, { SREF(L"midnight-tech"), 3008 },
    { SREF(L"mikey"), 2269 }, { SREF(L"mil-2045-47001"), 1581 }, { SREF(L"miles-apart"), 2621 }, { SREF(L"mimer"), 1360 },
    { SREF(L"mindarray-ca"), 9445 }, { SREF(L"mindfilesys"), 7391 }, { SREF(L"mindprint"), 8033 }, { SREF(L"minger"), 4069 },
    { SREF(L"mini-sqSREF(L"), 1114 }, { SREF(L"minilock"), 3798 }, { SREF(L"minipay"), 2105 }, { SREF(L"minivend"), 7786 },
    { SREF(L"minotaur-sa"), 5136 }, { SREF(L"mipv6tls"), 7872 }, { SREF(L"mira"), 3454 }, { SREF(L"miroconnect"), 1532 },
    { SREF(L"mirrtex"), 4310 }, { SREF(L"mit-dov"), 91 }, { SREF(L"mit-ml-dev"), 83 }, { SREF(L"mit-ml-dev"), 85 },
    { SREF(L"miteksys-lm"), 1482 }, { SREF(L"miva-mqs"), 1277 }, { SREF(L"mkm-discovery"), 3837 }, { SREF(L"ml-svnet"), 4171 },
    { SREF(L"mle"), 19788 }, { SREF(L"mloadd"), 1427 }, { SREF(L"mlsn"), 32801 }, { SREF(L"mma-discovery"), 4173 },
    { SREF(L"mmacomm"), 4667 }, { SREF(L"mmaeds"), 4668 }, { SREF(L"mmcaSREF(L"), 2272 }, { SREF(L"mmcals"), 2271 },
    { SREF(L"mmcc"), 5050 }, { SREF(L"mmpft"), 1815 }, { SREF(L"mnet-discovery"), 5237 }, { SREF(L"mngsuite"), 9535 },
    { SREF(L"mni-prot-rout"), 3764 }, { SREF(L"mnp-exchange"), 2197 }, { SREF(L"mns-maiSREF(L"), 2593 }, { SREF(L"mobile-file-dSREF(L"), 2926 },
    { SREF(L"mobile-p2p"), 4688 }, { SREF(L"mobileanalyzer"), 7869 }, { SREF(L"mobileip-agent"), 434 }, { SREF(L"mobilip-mn"), 435 },
    { SREF(L"MobilitySrv"), 6997 }, { SREF(L"mobrien-chat"), 2031 }, { SREF(L"moldflow-lm"), 1576 }, { SREF(L"molly"), 1374 },
    { SREF(L"mon"), 2583 }, { SREF(L"mon"), 9255 }, { SREF(L"mondex"), 471 }, { SREF(L"monetra"), 8665 },
    { SREF(L"monetra-admin"), 8666 }, { SREF(L"monitor"), 561 }, { SREF(L"monkeycom"), 9898 }, { SREF(L"monp"), 3445 },
    { SREF(L"montage-lm"), 6147 }, { SREF(L"mortgageware"), 367 }, { SREF(L"MOS-aux"), 10542 }, { SREF(L"MOS-lower"), 10540 },
    { SREF(L"MOS-soap"), 10543 }, { SREF(L"MOS-soap-opt"), 10544 }, { SREF(L"MOS-upper"), 10541 }, { SREF(L"mosaicsyssvc1"), 1235 },
    { SREF(L"mosaixcc"), 2561 }, { SREF(L"moshebeeri"), 2627 }, { SREF(L"mountd"), 20048 }, { SREF(L"movaz-ssc"), 5252 },
    { SREF(L"moy-corp"), 2488 }, { SREF(L"mpc-lifenet"), 1213 }, { SREF(L"mpfoncSREF(L"), 2579 }, { SREF(L"mpfwsas"), 2952 },
    { SREF(L"mphlpdmc"), 9344 }, { SREF(L"mpidcagt"), 9397 }, { SREF(L"mpidcmgr"), 9343 }, { SREF(L"mpl-gprs-port"), 3924 },
    { SREF(L"mpls-pm"), 6634 }, { SREF(L"mpls-udp"), 6635 }, { SREF(L"mpls-udp-dtls"), 6636 }, { SREF(L"mpm"), 45 },
    { SREF(L"mpm-flags"), 44 }, { SREF(L"mpm-snd"), 46 }, { SREF(L"mpnjsc"), 1952 }, { SREF(L"mpnjsocSREF(L"), 2685 },
    { SREF(L"mpnjsomb"), 2681 }, { SREF(L"mpnjsomg"), 2686 }, { SREF(L"mpnjsosv"), 2684 }, { SREF(L"mpp"), 218 },
    { SREF(L"mppolicy-mgr"), 5969 }, { SREF(L"mppolicy-v5"), 5968 }, { SREF(L"mps-raft"), 1700 }, { SREF(L"mpshrsv"), 1261 },
    { SREF(L"mpsserver"), 6106 }, { SREF(L"mpsysrmsvr"), 3358 }, { SREF(L"mptn"), 397 }, { SREF(L"mqe-agent"), 3958 },
    { SREF(L"mqe-broker"), 3957 }, { SREF(L"mqtt"), 1883 }, { SREF(L"mrip"), 4986 }, { SREF(L"mrm"), 679 },
    { SREF(L"mrssrendezvous"), 7392 }, { SREF(L"ms-alerter"), 5359 }, { SREF(L"ms-cluster-net"), 3343 }, { SREF(L"ms-ilm"), 5725 },
    { SREF(L"ms-ilm-sts"), 5726 }, { SREF(L"ms-la"), 3535 }, { SREF(L"ms-licensing"), 5720 }, { SREF(L"ms-olap1"), 2393 },
    { SREF(L"ms-olap2"), 2394 }, { SREF(L"ms-olap3"), 2382 }, { SREF(L"ms-olap4"), 2383 }, { SREF(L"ms-rome"), 569 },
    { SREF(L"ms-rule-engine"), 3132 }, { SREF(L"ms-s-sideshow"), 5361 }, { SREF(L"ms-shuttle"), 568 }, { SREF(L"ms-sideshow"), 5360 },
    { SREF(L"ms-smlbiz"), 5356 }, { SREF(L"ms-sna-base"), 1478 }, { SREF(L"ms-sna-server"), 1477 }, { SREF(L"ms-sql-m"), 1434 },
    { SREF(L"ms-sql-s"), 1433 }, { SREF(L"ms-streaming"), 1755 }, { SREF(L"ms-theater"), 2460 }, { SREF(L"ms-v-worlds"), 2525 },
    { SREF(L"ms-wbt-server"), 3389 }, { SREF(L"msdfsr"), 5722 }, { SREF(L"msdp"), 639 }, { SREF(L"msdts1"), 3882 },
    { SREF(L"msexch-routing"), 691 }, { SREF(L"msfrs"), 4554 }, { SREF(L"msft-dpm-cert"), 6076 }, { SREF(L"msft-gc"), 3268 },
    { SREF(L"msft-gc-ssSREF(L"), 3269 }, { SREF(L"msfw-array"), 2174 }, { SREF(L"msfw-controSREF(L"), 3847 }, { SREF(L"msfw-replica"), 2173 },
    { SREF(L"msfw-s-storage"), 2172 }, { SREF(L"msfw-storage"), 2171 }, { SREF(L"msg-auth"), 31 }, { SREF(L"msg-icp"), 29 },
    { SREF(L"msgclnt"), 8786 }, { SREF(L"msgsrvr"), 8787 }, { SREF(L"msgsys"), 9594 }, { SREF(L"mshnet"), 1989 },
    { SREF(L"mshvlm"), 6600 }, { SREF(L"msi-cps-rm"), 8675 }, { SREF(L"msi-cps-rm-disc"), 8675 }, { SREF(L"msi-selectplay"), 2871 },
    { SREF(L"msiccp"), 1731 }, { SREF(L"msims"), 1582 }, { SREF(L"msl-lmd"), 1464 }, { SREF(L"msmq"), 1801 },
    { SREF(L"msnp"), 1863 }, { SREF(L"msolap-ptp2"), 2725 }, { SREF(L"msp"), 18 }, { SREF(L"msp"), 2438 },
    { SREF(L"msp-os"), 4686 }, { SREF(L"msr-plugin-port"), 3931 }, { SREF(L"msrp"), 2855 }, { SREF(L"msss"), 7742 },
    { SREF(L"mstmg-sstp"), 6601 }, { SREF(L"msync"), 2072 }, { SREF(L"mt-scaleserver"), 2305 }, { SREF(L"mtcevrunqman"), 4558 },
    { SREF(L"mtcevrunqss"), 4557 }, { SREF(L"mti-tcs-comm"), 2469 }, { SREF(L"mtl8000-matrix"), 8115 }, { SREF(L"mtn"), 4691 },
    { SREF(L"mtp"), 1911 }, { SREF(L"mtport-regist"), 2791 }, { SREF(L"mtportmon"), 7421 }, { SREF(L"mtqp"), 1038 },
    { SREF(L"mtrgtrans"), 19398 }, { SREF(L"mtsserver"), 4602 }, { SREF(L"multicast-ping"), 9903 }, { SREF(L"multiling-http"), 777 },
    { SREF(L"multip-msg"), 3733 }, { SREF(L"multiplex"), 171 }, { SREF(L"mumps"), 188 }, { SREF(L"munin"), 4949 },
    { SREF(L"mupdate"), 3905 }, { SREF(L"murray"), 1123 }, { SREF(L"murx"), 2743 }, { SREF(L"muse"), 6888 },
    { SREF(L"musiconline"), 1806 }, { SREF(L"must-backplane"), 3515 }, { SREF(L"must-p2p"), 3514 }, { SREF(L"mvel-lm"), 1574 },
    { SREF(L"mvs-capacity"), 10007 }, { SREF(L"mvx-lm"), 1510 }, { SREF(L"mxi"), 8005 }, { SREF(L"mxit"), 9119 },
    { SREF(L"mxodbc-connect"), 6632 }, { SREF(L"mxomss"), 1141 }, { SREF(L"mxxrlogin"), 1035 }, { SREF(L"myblast"), 3795 },
    { SREF(L"mylex-mapd"), 467 }, { SREF(L"mylxamport"), 2981 }, { SREF(L"mynahautostart"), 2388 }, { SREF(L"myq-termlink"), 11108 },
    { SREF(L"myrtle"), 1831 }, { SREF(L"mysqSREF(L"), 3306 }, { SREF(L"mysql-cluster"), 1186 }, { SREF(L"mysql-cm-agent"), 1862 },
    { SREF(L"mysql-im"), 2273 }, { SREF(L"mysql-proxy"), 6446 }, { SREF(L"mzap"), 2106 }, { SREF(L"mzca-action"), 7282 },
    { SREF(L"mzca-alert"), 7282 }, { SREF(L"n1-fwp"), 4446 }, { SREF(L"n1-rmgmt"), 4447 }, { SREF(L"n2h2server"), 9285 },
    { SREF(L"n2nremote"), 1685 }, { SREF(L"n2receive"), 9286 }, { SREF(L"na-er-tip"), 3725 }, { SREF(L"na-localise"), 5062 },
    { SREF(L"naap"), 1340 }, { SREF(L"nacagent"), 4407 }, { SREF(L"nacnSREF(L"), 4361 }, { SREF(L"name"), 42 },
    { SREF(L"namemunge"), 3950 }, { SREF(L"nameserver"), 42 }, { SREF(L"namp"), 167 }, { SREF(L"nani"), 2236 },
    { SREF(L"nas"), 991 }, { SREF(L"nas-metering"), 2286 }, { SREF(L"nasmanager"), 1960 }, { SREF(L"natdataservice"), 3927 },
    { SREF(L"nati-dstp"), 3015 }, { SREF(L"nati-logos"), 2343 }, { SREF(L"nati-svrloc"), 3580 }, { SREF(L"nati-vi-server"), 3363 },
    { SREF(L"nattyserver"), 3753 }, { SREF(L"natuslink"), 2895 }, { SREF(L"nav-data"), 6317 }, { SREF(L"nav-data-cmd"), 6317 },
    { SREF(L"nav-port"), 3859 }, { SREF(L"navbuddy"), 1288 }, { SREF(L"navegaweb-port"), 3159 }, { SREF(L"navisphere"), 2162 },
    { SREF(L"navisphere-sec"), 2163 }, { SREF(L"nbd"), 10809 }, { SREF(L"nbdb"), 13785 }, { SREF(L"nbt-pc"), 5133 },
    { SREF(L"nbt-woSREF(L"), 6133 }, { SREF(L"nburn-id"), 20034 }, { SREF(L"nburn_id"), 20034 }, { SREF(L"nbx-au"), 2094 },
    { SREF(L"nbx-cc"), 2093 }, { SREF(L"nbx-dir"), 2096 }, { SREF(L"nbx-ser"), 2095 }, { SREF(L"ncacn-ip-tcp"), 3062 },
    { SREF(L"ncadg-ip-udp"), 3063 }, { SREF(L"ncconfig"), 1888 }, { SREF(L"ncdloadbalance"), 2683 }, { SREF(L"ncdmirroring"), 2706 },
    { SREF(L"nced"), 404 }, { SREF(L"ncSREF(L"), 2397 }, { SREF(L"ncld"), 405 }, { SREF(L"ncp"), 524 },
    { SREF(L"ncpm-ft"), 1744 }, { SREF(L"ncpm-hip"), 1683 }, { SREF(L"ncpm-pm"), 1591 }, { SREF(L"ncr-ccSREF(L"), 2528 },
    { SREF(L"ncu-1"), 3195 }, { SREF(L"ncu-2"), 3196 }, { SREF(L"ncube-lm"), 1521 }, { SREF(L"ncxcp"), 5681 },
    { SREF(L"ndl-aas"), 3128 }, { SREF(L"ndl-ahp-svc"), 6064 }, { SREF(L"ndl-als"), 3431 }, { SREF(L"ndl-aps"), 3096 },
    { SREF(L"ndl-tcp-ois-gw"), 2738 }, { SREF(L"ndm-agent-port"), 43189 }, { SREF(L"ndm-requester"), 1363 }, { SREF(L"ndm-server"), 1364 },
    { SREF(L"ndmp"), 10000 }, { SREF(L"ndmps"), 30000 }, { SREF(L"ndn"), 6363 }, { SREF(L"ndnp"), 2883 },
    { SREF(L"nds-sso"), 3024 }, { SREF(L"ndsauth"), 353 }, { SREF(L"ndsconnect"), 3890 }, { SREF(L"ndsp"), 2881 },
    { SREF(L"ndtp"), 2882 }, { SREF(L"nec-raidplus"), 2730 }, { SREF(L"neckar"), 37475 }, { SREF(L"necp"), 3262 },
    { SREF(L"nei-management"), 3886 }, { SREF(L"neo4j"), 7474 }, { SREF(L"neod1"), 1047 }, { SREF(L"neod2"), 1048 },
    { SREF(L"neoiface"), 1285 }, { SREF(L"neon24x7"), 3213 }, { SREF(L"nerv"), 1222 }, { SREF(L"nesh-broker"), 3507 },
    { SREF(L"nessus"), 1241 }, { SREF(L"nest-protocoSREF(L"), 489 }, { SREF(L"net-device"), 4350 }, { SREF(L"net-projection"), 5363 },
    { SREF(L"net-steward"), 2128 }, { SREF(L"net2display"), 9086 }, { SREF(L"net8-cman"), 1830 }, { SREF(L"netadmin"), 2450 },
    { SREF(L"netagent"), 5771 }, { SREF(L"netangeSREF(L"), 2442 }, { SREF(L"netapp-icdata"), 11105 }, { SREF(L"netapp-icmgmt"), 11104 },
    { SREF(L"netapp-sync"), 10006 }, { SREF(L"netarx"), 1040 }, { SREF(L"netaspi"), 2902 }, { SREF(L"netattachsdmp"), 3066 },
    { SREF(L"netbill-auth"), 1615 }, { SREF(L"netbill-cred"), 1614 }, { SREF(L"netbill-keyrep"), 1613 }, { SREF(L"netbill-prod"), 1616 },
    { SREF(L"netbill-trans"), 1612 }, { SREF(L"netbios-dgm"), 138 }, { SREF(L"netbios-ns"), 137 }, { SREF(L"netbios-ssn"), 139 },
    { SREF(L"netblox"), 4441 }, { SREF(L"netbookmark"), 3131 }, { SREF(L"netboot-pxe"), 3928 }, { SREF(L"netcabinet-com"), 4409 },
    { SREF(L"netcelera"), 3701 }, { SREF(L"netchat"), 2451 }, { SREF(L"netcheque"), 4008 }, { SREF(L"netclip"), 2971 },
    { SREF(L"netcomm1"), 1676 }, { SREF(L"netcomm2"), 1676 }, { SREF(L"netconf-beep"), 831 }, { SREF(L"netconf-ssh"), 830 },
    { SREF(L"netconf-tls"), 6513 }, { SREF(L"netconfsoapbeep"), 833 }, { SREF(L"netconfsoaphttp"), 832 }, { SREF(L"netcp"), 395 },
    { SREF(L"netdb-export"), 1329 }, { SREF(L"neteh"), 3828 }, { SREF(L"neteh-ext"), 3829 }, { SREF(L"netgw"), 741 },
    { SREF(L"netinfo-locaSREF(L"), 1033 }, { SREF(L"netiq"), 2220 }, { SREF(L"netiq-endpoint"), 10113 }, { SREF(L"netiq-endpt"), 10115 },
    { SREF(L"netiq-mc"), 2735 }, { SREF(L"netiq-ncap"), 2219 }, { SREF(L"netiq-qcheck"), 10114 }, { SREF(L"netiq-voipa"), 10116 },
    { SREF(L"netlabs-lm"), 1406 }, { SREF(L"netmagic"), 1196 }, { SREF(L"netmap-lm"), 1493 }, { SREF(L"netmSREF(L"), 2288 },
    { SREF(L"netmo-default"), 6841 }, { SREF(L"netmo-http"), 6842 }, { SREF(L"netmon"), 2606 }, { SREF(L"netmount"), 2061 },
    { SREF(L"netmpi"), 3827 }, { SREF(L"netnews"), 532 }, { SREF(L"neto-dcs"), 3814 }, { SREF(L"neto-wol-server"), 3812 },
    { SREF(L"netobjects1"), 2485 }, { SREF(L"netobjects2"), 2486 }, { SREF(L"netop-rc"), 1970 }, { SREF(L"netop-schooSREF(L"), 1971 },
    { SREF(L"netopia-vo1"), 1839 }, { SREF(L"netopia-vo2"), 1840 }, { SREF(L"netopia-vo3"), 1841 }, { SREF(L"netopia-vo4"), 1842 },
    { SREF(L"netopia-vo5"), 1843 }, { SREF(L"netops-broker"), 5465 }, { SREF(L"netperf"), 12865 }, { SREF(L"netplan"), 2983 },
    { SREF(L"netplay-port1"), 3640 }, { SREF(L"netplay-port2"), 3641 }, { SREF(L"netport-id"), 3129 }, { SREF(L"netrcs"), 742 },
    { SREF(L"netrek"), 2592 }, { SREF(L"netrisk"), 1799 }, { SREF(L"netrix-sftm"), 2328 }, { SREF(L"netrjs-1"), 71 },
    { SREF(L"netrjs-2"), 72 }, { SREF(L"netrjs-3"), 73 }, { SREF(L"netrjs-4"), 74 }, { SREF(L"netrockey6"), 4425 },
    { SREF(L"netsc-dev"), 155 }, { SREF(L"netsc-prod"), 154 }, { SREF(L"netscript"), 4118 }, { SREF(L"netserialext1"), 16360 },
    { SREF(L"netserialext2"), 16361 }, { SREF(L"netserialext3"), 16367 }, { SREF(L"netserialext4"), 16368 }, { SREF(L"netspeak-acd"), 21848 },
    { SREF(L"netspeak-cps"), 21849 }, { SREF(L"netspeak-cs"), 21847 }, { SREF(L"netspeak-is"), 21846 }, { SREF(L"netsteward"), 2810 },
    { SREF(L"netsupport"), 5405 }, { SREF(L"netsupport2"), 5421 }, { SREF(L"nettest"), 4138 }, { SREF(L"nettgain-nms"), 1879 },
    { SREF(L"netuitive"), 1286 }, { SREF(L"netview-aix-1"), 1661 }, { SREF(L"netview-aix-10"), 1670 }, { SREF(L"netview-aix-11"), 1671 },
    { SREF(L"netview-aix-12"), 1672 }, { SREF(L"netview-aix-2"), 1662 }, { SREF(L"netview-aix-3"), 1663 }, { SREF(L"netview-aix-4"), 1664 },
    { SREF(L"netview-aix-5"), 1665 }, { SREF(L"netview-aix-6"), 1666 }, { SREF(L"netview-aix-7"), 1667 }, { SREF(L"netview-aix-8"), 1668 },
    { SREF(L"netview-aix-9"), 1669 }, { SREF(L"netviewdm1"), 729 }, { SREF(L"netviewdm2"), 730 }, { SREF(L"netviewdm3"), 731 },
    { SREF(L"netwalSREF(L"), 533 }, { SREF(L"netware-csp"), 1366 }, { SREF(L"netware-ip"), 396 }, { SREF(L"netwatcher-db"), 3204 },
    { SREF(L"netwatcher-mon"), 3203 }, { SREF(L"netwave-ap-mgmt"), 2411 }, { SREF(L"netwkpathengine"), 3209 }, { SREF(L"networklens"), 3409 },
    { SREF(L"networklenss"), 3410 }, { SREF(L"netx-agent"), 2586 }, { SREF(L"netx-server"), 2585 }, { SREF(L"netxms-agent"), 4700 },
    { SREF(L"netxms-mgmt"), 4701 }, { SREF(L"netxms-sync"), 4702 }, { SREF(L"neveroffline"), 2614 }, { SREF(L"new-rwho"), 550 },
    { SREF(L"newbay-snc-mc"), 16900 }, { SREF(L"newgenpay"), 3165 }, { SREF(L"newheights"), 2114 }, { SREF(L"newlixconfig"), 2076 },
    { SREF(L"newlixengine"), 2075 }, { SREF(L"newlixreg"), 2671 }, { SREF(L"newoak"), 4001 }, { SREF(L"news"), 2009 },
    { SREF(L"newwavesearch"), 2058 }, { SREF(L"nexentamv"), 8457 }, { SREF(L"nexgen"), 6627 }, { SREF(L"nexstorindltd"), 2360 },
    { SREF(L"nextstep"), 178 }, { SREF(L"nexus-portaSREF(L"), 4021 }, { SREF(L"nfa"), 1155 }, { SREF(L"nfoldman"), 7393 },
    { SREF(L"nfs"), 2049 }, { SREF(L"nfsd-keepalive"), 1110 }, { SREF(L"nfsrdma"), 20049 }, { SREF(L"ng-umds"), 1690 },
    { SREF(L"nhci"), 3842 }, { SREF(L"nhserver"), 2672 }, { SREF(L"ni-ftp"), 47 }, { SREF(L"ni-maiSREF(L"), 61 },
    { SREF(L"ni-visa-remote"), 3537 }, { SREF(L"nicelink"), 1095 }, { SREF(L"nicetec-mgmt"), 2557 }, { SREF(L"nicetec-nmsvc"), 2556 },
    { SREF(L"nicname"), 43 }, { SREF(L"nifty-hmi"), 4134 }, { SREF(L"nilinkanalyst"), 25902 }, { SREF(L"nim"), 1058 },
    { SREF(L"nim-vdrshelSREF(L"), 6420 }, { SREF(L"nim-wan"), 6421 }, { SREF(L"nimaux"), 3902 }, { SREF(L"nimbusdb"), 48004 },
    { SREF(L"nimbusdbctrSREF(L"), 48005 }, { SREF(L"nimcontroller"), 48000 }, { SREF(L"nimgtw"), 48003 }, { SREF(L"nimhub"), 48002 },
    { SREF(L"nimreg"), 1059 }, { SREF(L"nimrod-agent"), 1617 }, { SREF(L"nimsh"), 3901 }, { SREF(L"nimspooler"), 48001 },
    { SREF(L"ninaf"), 5627 }, { SREF(L"niobserver"), 25901 }, { SREF(L"nip"), 376 }, { SREF(L"niprobe"), 25903 },
    { SREF(L"nirp"), 4043 }, { SREF(L"nitrogen"), 7725 }, { SREF(L"njenet-ssSREF(L"), 2252 }, { SREF(L"nkd"), 1650 },
    { SREF(L"nlg-data"), 5299 }, { SREF(L"nlogin"), 758 }, { SREF(L"nls-tSREF(L"), 7549 }, { SREF(L"nm-asses-admin"), 3150 },
    { SREF(L"nm-assessor"), 3151 }, { SREF(L"nm-game-admin"), 3148 }, { SREF(L"nm-game-server"), 3149 }, { SREF(L"nmap"), 689 },
    { SREF(L"nmasoverip"), 1242 }, { SREF(L"nmc-disc"), 10810 }, { SREF(L"nmea-0183"), 10110 }, { SREF(L"nmea-onenet"), 10111 },
    { SREF(L"nmmp"), 3649 }, { SREF(L"nms"), 1429 }, { SREF(L"nms-dpnss"), 2503 }, { SREF(L"nms-topo-serv"), 1486 },
    { SREF(L"nmsd"), 1239 }, { SREF(L"nmsigport"), 2817 }, { SREF(L"nmsigport"), 2839 }, { SREF(L"nmsp"), 1790 },
    { SREF(L"nmsp"), 537 }, { SREF(L"nmsserver"), 2244 }, { SREF(L"nnp"), 3780 }, { SREF(L"nnsp"), 433 },
    { SREF(L"nntp"), 119 }, { SREF(L"nntps"), 563 }, { SREF(L"noaaport"), 2210 }, { SREF(L"noadmin"), 1921 },
    { SREF(L"noagent"), 1917 }, { SREF(L"nod-client"), 8981 }, { SREF(L"nod-provider"), 8980 }, { SREF(L"noit-transport"), 43191 },
    { SREF(L"nokia-ann-ch1"), 3405 }, { SREF(L"nokia-ann-ch2"), 3406 }, { SREF(L"nomad"), 5209 }, { SREF(L"nomdb"), 13786 },
    { SREF(L"norton-lambert"), 2338 }, { SREF(L"notateit"), 4803 }, { SREF(L"notateit-disc"), 4803 }, { SREF(L"noteit"), 4663 },
    { SREF(L"noteshare"), 8474 }, { SREF(L"noteza"), 5215 }, { SREF(L"notezilla-lan"), 21010 }, { SREF(L"notify"), 773 },
    { SREF(L"notify-srvr"), 3016 }, { SREF(L"novar-alarm"), 23401 }, { SREF(L"novar-dbase"), 23400 }, { SREF(L"novar-globaSREF(L"), 23402 },
    { SREF(L"novastorbakcup"), 308 }, { SREF(L"novation"), 1322 }, { SREF(L"novell-ipx-cmd"), 2645 }, { SREF(L"novell-lu6-2"), 1416 },
    { SREF(L"novell-zen"), 2544 }, { SREF(L"nowcontact"), 3167 }, { SREF(L"npdbgmngr"), 2293 }, { SREF(L"npds-tracker"), 3680 },
    { SREF(L"npep-messaging"), 2868 }, { SREF(L"npmp"), 8450 }, { SREF(L"npmp-gui"), 611 }, { SREF(L"npmp-locaSREF(L"), 610 },
    { SREF(L"npmp-trap"), 609 }, { SREF(L"npp"), 4045 }, { SREF(L"npp"), 92 }, { SREF(L"nppmp"), 3476 },
    { SREF(L"npqes-test"), 4703 }, { SREF(L"npsp"), 4088 }, { SREF(L"nqs"), 607 }, { SREF(L"nrcabq-lm"), 1458 },
    { SREF(L"ns"), 760 }, { SREF(L"ns-cfg-server"), 3266 }, { SREF(L"ns-server"), 5415 }, { SREF(L"nsc-ccs"), 2604 },
    { SREF(L"nsc-posa"), 2605 }, { SREF(L"nsdeepfreezectSREF(L"), 7724 }, { SREF(L"nsesrvr"), 9988 }, { SREF(L"nsiiops"), 261 },
    { SREF(L"nsjtp-ctrSREF(L"), 1687 }, { SREF(L"nsjtp-data"), 1688 }, { SREF(L"nsp"), 5012 }, { SREF(L"nsrmp"), 359 },
    { SREF(L"nsrp"), 7170 }, { SREF(L"nss"), 4159 }, { SREF(L"nss-routing"), 159 }, { SREF(L"nssagentmgr"), 4454 },
    { SREF(L"nssalertmgr"), 4453 }, { SREF(L"nssocketport"), 3522 }, { SREF(L"nsstp"), 1036 }, { SREF(L"nst"), 4687 },
    { SREF(L"nsw-fe"), 27 }, { SREF(L"nsws"), 3049 }, { SREF(L"nta-ds"), 7544 }, { SREF(L"nta-us"), 7545 },
    { SREF(L"ntalk"), 518 }, { SREF(L"ntp"), 123 }, { SREF(L"ntz-p2p-storage"), 6778 }, { SREF(L"ntz-tracker"), 6777 },
    { SREF(L"nuauth"), 4129 }, { SREF(L"nucleus"), 1463 }, { SREF(L"nucleus-sand"), 1201 }, { SREF(L"nufw"), 4128 },
    { SREF(L"nupaper-ss"), 12121 }, { SREF(L"nut"), 3493 }, { SREF(L"nuts-bootp"), 4133 }, { SREF(L"nuts-dem"), 4132 },
    { SREF(L"nuxsSREF(L"), 5991 }, { SREF(L"nv-video"), 4444 }, { SREF(L"nvc"), 8711 }, { SREF(L"nvcnet"), 3999 },
    { SREF(L"nvd"), 2184 }, { SREF(L"nvd"), 2329 }, { SREF(L"nvmsgd"), 3519 }, { SREF(L"nw-license"), 3697 },
    { SREF(L"nxlmd"), 28000 }, { SREF(L"o2server-port"), 1894 }, { SREF(L"oa-system"), 8022 }, { SREF(L"obex"), 650 },
    { SREF(L"objcalSREF(L"), 94 }, { SREF(L"objective-dbc"), 1388 }, { SREF(L"objectmanager"), 2038 }, { SREF(L"obrpd"), 1092 },
    { SREF(L"observium-agent"), 36602 }, { SREF(L"oc-lm"), 1448 }, { SREF(L"ocbinder"), 183 }, { SREF(L"oce-snmp-trap"), 2697 },
    { SREF(L"oceansoft-lm"), 1466 }, { SREF(L"ocs-amu"), 429 }, { SREF(L"ocs-cmu"), 428 }, { SREF(L"ocserver"), 184 },
    { SREF(L"octopus"), 10008 }, { SREF(L"octopustentacle"), 10933 }, { SREF(L"odbcpathway"), 9628 }, { SREF(L"odette-ftp"), 3305 },
    { SREF(L"odette-ftps"), 6619 }, { SREF(L"odeumservlink"), 3523 }, { SREF(L"odi-port"), 3187 }, { SREF(L"odmr"), 366 },
    { SREF(L"odn-castraq"), 2498 }, { SREF(L"odnsp"), 9966 }, { SREF(L"odsi"), 1308 }, { SREF(L"oem-agent"), 3872 },
    { SREF(L"oemcacao-jmxmp"), 11172 }, { SREF(L"oemcacao-rmi"), 11174 }, { SREF(L"oemcacao-websvc"), 11175 }, { SREF(L"office-tools"), 7789 },
    { SREF(L"officelink2000"), 3320 }, { SREF(L"ofsd"), 2322 }, { SREF(L"ogs-client"), 9007 }, { SREF(L"ogs-server"), 9008 },
    { SREF(L"ohimsrv"), 506 }, { SREF(L"ohmtrigger"), 4732 }, { SREF(L"ohsc"), 18186 }, { SREF(L"oi-2000"), 2364 },
    { SREF(L"oidocsvc"), 4142 }, { SREF(L"oidsr"), 4143 }, { SREF(L"oirtgsvc"), 4141 }, { SREF(L"olhost"), 2661 },
    { SREF(L"olsr"), 698 }, { SREF(L"olsv"), 1160 }, { SREF(L"oma-dcdocbs"), 7278 }, { SREF(L"oma-ilp"), 7276 },
    { SREF(L"oma-ilp-s"), 7277 }, { SREF(L"oma-mlp"), 9210 }, { SREF(L"oma-mlp-s"), 9211 }, { SREF(L"oma-rlp"), 7273 },
    { SREF(L"oma-rlp-s"), 7274 }, { SREF(L"oma-ulp"), 7275 }, { SREF(L"omabcastltkm"), 4359 }, { SREF(L"omasgport"), 4090 },
    { SREF(L"omginitialrefs"), 900 }, { SREF(L"omhs"), 5723 }, { SREF(L"omnilink-port"), 3904 }, { SREF(L"omnisky"), 2056 },
    { SREF(L"omnivision"), 1135 }, { SREF(L"omnivisionesx"), 4395 }, { SREF(L"oms"), 4662 }, { SREF(L"oms-nonsecure"), 5102 },
    { SREF(L"omscontact"), 4161 }, { SREF(L"omsdk"), 5724 }, { SREF(L"omserv"), 764 }, { SREF(L"omstopology"), 4162 },
    { SREF(L"omviagent"), 4429 }, { SREF(L"omviserver"), 4428 }, { SREF(L"onbase-dds"), 2185 }, { SREF(L"onehome-help"), 2199 },
    { SREF(L"onehome-remote"), 2198 }, { SREF(L"onep-tls"), 15002 }, { SREF(L"onesaf"), 3244 }, { SREF(L"onmux"), 417 },
    { SREF(L"onpsocket"), 5014 }, { SREF(L"onscreen"), 5080 }, { SREF(L"ontime"), 1622 }, { SREF(L"ontobroker"), 2267 },
    { SREF(L"oob-ws-http"), 623 }, { SREF(L"oob-ws-https"), 664 }, { SREF(L"op-probe"), 7030 }, { SREF(L"opalis-rbt-ipc"), 5314 },
    { SREF(L"opalis-rdv"), 536 }, { SREF(L"opalis-robot"), 314 }, { SREF(L"opc-job-start"), 423 }, { SREF(L"opc-job-track"), 424 },
    { SREF(L"opcon-xps"), 3100 }, { SREF(L"opcua-tcp"), 4840 }, { SREF(L"opcua-tls"), 4843 }, { SREF(L"opcua-udp"), 4840 },
    { SREF(L"opencm"), 3434 }, { SREF(L"opencore"), 4089 }, { SREF(L"opendeploy"), 20014 }, { SREF(L"openflow"), 6653 },
    { SREF(L"openhpid"), 4743 }, { SREF(L"openmaiSREF(L"), 5729 }, { SREF(L"openmailg"), 5755 }, { SREF(L"openmailns"), 5766 },
    { SREF(L"openmailpxy"), 5768 }, { SREF(L"openmath"), 1473 }, { SREF(L"opennSREF(L"), 1258 }, { SREF(L"opennl-voice"), 1259 },
    { SREF(L"openport"), 260 }, { SREF(L"openqueue"), 8764 }, { SREF(L"openremote-ctrSREF(L"), 8688 }, { SREF(L"openstack-id"), 35357 },
    { SREF(L"opentable"), 2368 }, { SREF(L"opentrac"), 3855 }, { SREF(L"openvms-sysipc"), 557 }, { SREF(L"openvpn"), 1194 },
    { SREF(L"openwebnet"), 20005 }, { SREF(L"opequus-server"), 2400 }, { SREF(L"opi-sock"), 7429 }, { SREF(L"opnet-smp"), 3433 },
    { SREF(L"opsec-cvp"), 18181 }, { SREF(L"opsec-ela"), 18187 }, { SREF(L"opsec-lea"), 18184 }, { SREF(L"opsec-omi"), 18185 },
    { SREF(L"opsec-sam"), 18183 }, { SREF(L"opsec-uaa"), 19191 }, { SREF(L"opsec-ufp"), 18182 }, { SREF(L"opsession-clnt"), 3303 },
    { SREF(L"opsession-prxy"), 3307 }, { SREF(L"opsession-srvr"), 3304 }, { SREF(L"opsmgr"), 1270 }, { SREF(L"opsview-envoy"), 4125 },
    { SREF(L"opswagent"), 3976 }, { SREF(L"opswmanager"), 3977 }, { SREF(L"optech-port1-lm"), 2237 }, { SREF(L"optika-emedia"), 1829 },
    { SREF(L"optilogic"), 2435 }, { SREF(L"optima-vnet"), 1051 }, { SREF(L"optiwave-lm"), 2524 }, { SREF(L"optocontroSREF(L"), 22001 },
    { SREF(L"optohost002"), 22002 }, { SREF(L"optohost003"), 22003 }, { SREF(L"optohost004"), 22004 }, { SREF(L"optohost004"), 22005 },
    { SREF(L"opus-services"), 3718 }, { SREF(L"ora-lm"), 1446 }, { SREF(L"ora-oap"), 5575 }, { SREF(L"oracle"), 2005 },
    { SREF(L"oracle-em1"), 1748 }, { SREF(L"oracle-em2"), 1754 }, { SREF(L"oracle-ms-ens"), 8997 }, { SREF(L"oracle-oms"), 1159 },
    { SREF(L"oracle-vp1"), 1809 }, { SREF(L"oracle-vp2"), 1808 }, { SREF(L"oracleas-https"), 7443 }, { SREF(L"oraclenames"), 1575 },
    { SREF(L"oraclenet8cman"), 1630 }, { SREF(L"orasrv"), 1525 }, { SREF(L"orbiter"), 2398 }, { SREF(L"orbix-cfg-ssSREF(L"), 3078 },
    { SREF(L"orbix-config"), 3076 }, { SREF(L"orbix-loc-ssSREF(L"), 3077 }, { SREF(L"orbix-locator"), 3075 }, { SREF(L"orbixd"), 1570 },
    { SREF(L"orbplus-iiop"), 1597 }, { SREF(L"ordinox-dbase"), 3355 }, { SREF(L"ordinox-server"), 3274 }, { SREF(L"origo-native"), 3001 },
    { SREF(L"origo-sync"), 11103 }, { SREF(L"orion"), 2407 }, { SREF(L"orion-rmi-reg"), 2413 }, { SREF(L"ortec-disc"), 40853 },
    { SREF(L"os-licman"), 1384 }, { SREF(L"osaut"), 6679 }, { SREF(L"osb-sd"), 400 }, { SREF(L"osdcp"), 3432 },
    { SREF(L"osm-appsrvr"), 9990 }, { SREF(L"osm-oev"), 9991 }, { SREF(L"osmosis-aeea"), 3034 }, { SREF(L"osp"), 5045 },
    { SREF(L"ospf-lite"), 8899 }, { SREF(L"osu-nms"), 192 }, { SREF(L"otlp"), 6951 }, { SREF(L"otmp"), 29167 },
    { SREF(L"otp"), 9390 }, { SREF(L"otpatch"), 2936 }, { SREF(L"ott"), 2428 }, { SREF(L"ottp"), 2951 },
    { SREF(L"otv"), 8472 }, { SREF(L"outlaws"), 5310 }, { SREF(L"ov-nnm-websrv"), 3443 }, { SREF(L"ovalarmsrv"), 2953 },
    { SREF(L"ovalarmsrv-cmd"), 2954 }, { SREF(L"ovbus"), 7501 }, { SREF(L"oveadmgr"), 7427 }, { SREF(L"ovhpas"), 7510 },
    { SREF(L"ovladmgr"), 7428 }, { SREF(L"ovobs"), 30999 }, { SREF(L"ovrimosdbman"), 2956 }, { SREF(L"ovsam-d-agent"), 3870 },
    { SREF(L"ovsam-mgmt"), 3869 }, { SREF(L"ovsdb"), 6640 }, { SREF(L"ovsessionmgr"), 2389 }, { SREF(L"ovtopmd"), 2532 },
    { SREF(L"ovwdb"), 2447 }, { SREF(L"owamp-controSREF(L"), 861 }, { SREF(L"owms"), 7878 }, { SREF(L"owserver"), 4304 },
    { SREF(L"p-net-locaSREF(L"), 34378 }, { SREF(L"p-net-remote"), 34379 }, { SREF(L"p25cai"), 6082 }, { SREF(L"p2pcommunity"), 3955 },
    { SREF(L"p2pgroup"), 3587 }, { SREF(L"p2pq"), 1981 }, { SREF(L"p4p-portaSREF(L"), 6671 }, { SREF(L"p6ssmc"), 4311 },
    { SREF(L"pace-licensed"), 31400 }, { SREF(L"pacerforum"), 1480 }, { SREF(L"pacmand"), 1307 }, { SREF(L"pacom"), 3435 },
    { SREF(L"padl2sim"), 5236 }, { SREF(L"pads"), 7237 }, { SREF(L"pafec-lm"), 7511 }, { SREF(L"paging-port"), 3771 },
    { SREF(L"pago-services1"), 30001 }, { SREF(L"pago-services2"), 30002 }, { SREF(L"palace-1"), 9992 }, { SREF(L"palace-2"), 9993 },
    { SREF(L"palace-3"), 9994 }, { SREF(L"palace-4"), 9995 }, { SREF(L"palace-5"), 9996 }, { SREF(L"palace-6"), 9997 },
    { SREF(L"palcom-disc"), 6657 }, { SREF(L"pammratc"), 1632 }, { SREF(L"pammrpc"), 1633 }, { SREF(L"pana"), 716 },
    { SREF(L"panagolin-ident"), 9021 }, { SREF(L"panasas"), 3095 }, { SREF(L"pando-pub"), 7680 }, { SREF(L"pando-sec"), 8276 },
    { SREF(L"pangolin-laser"), 3348 }, { SREF(L"paradym-31port"), 1864 }, { SREF(L"paragent"), 9022 }, { SREF(L"paralleSREF(L"), 4989 },
    { SREF(L"park-agent"), 5431 }, { SREF(L"parliant"), 4681 }, { SREF(L"parsec-game"), 6582 }, { SREF(L"parsec-master"), 6580 },
    { SREF(L"parsec-peer"), 6581 }, { SREF(L"partimage"), 4025 }, { SREF(L"passgo"), 511 }, { SREF(L"passgo-tivoli"), 627 },
    { SREF(L"password-chg"), 586 }, { SREF(L"passwrd-policy"), 1333 }, { SREF(L"patroSREF(L"), 8160 }, { SREF(L"patrol-colSREF(L"), 6162 },
    { SREF(L"patrol-ism"), 6161 }, { SREF(L"patrol-mq-gm"), 2664 }, { SREF(L"patrol-mq-nm"), 2665 }, { SREF(L"patrol-snmp"), 8161 },
    { SREF(L"patrolview"), 4097 }, { SREF(L"pawserv"), 345 }, { SREF(L"pay-per-view"), 1564 }, { SREF(L"paycash-online"), 8128 },
    { SREF(L"paycash-wbp"), 8129 }, { SREF(L"payrouter"), 1246 }, { SREF(L"pc-mta-addrmap"), 2246 }, { SREF(L"pc-telecommute"), 2299 },
    { SREF(L"pcanywheredata"), 5631 }, { SREF(L"pcanywherestat"), 5632 }, { SREF(L"pcc-image-port"), 3892 }, { SREF(L"pcc-mfp"), 2256 },
    { SREF(L"pcep"), 4189 }, { SREF(L"pcia-rxp-b"), 1332 }, { SREF(L"pciarray"), 1552 }, { SREF(L"pcihreq"), 3085 },
    { SREF(L"pcle-infex"), 3189 }, { SREF(L"pclemultimedia"), 2558 }, { SREF(L"pcmail-srv"), 158 }, { SREF(L"pcmk-remote"), 3121 },
    { SREF(L"pcoip"), 4172 }, { SREF(L"pcoip-mgmt"), 5172 }, { SREF(L"pconnectmgr"), 1562 }, { SREF(L"pcp"), 5351 },
    { SREF(L"pcp-multicast"), 5350 }, { SREF(L"pcptcpservice"), 4182 }, { SREF(L"pcs-pcw"), 2566 }, { SREF(L"pcs-sf-ui-man"), 6655 },
    { SREF(L"pcsync-http"), 8444 }, { SREF(L"pcsync-https"), 8443 }, { SREF(L"pctrader"), 3048 }, { SREF(L"pcttunnelSREF(L"), 2274 },
    { SREF(L"pd-admin"), 9597 }, { SREF(L"pda-data"), 3253 }, { SREF(L"pda-gate"), 4012 }, { SREF(L"pda-sys"), 3254 },
    { SREF(L"pdap"), 344 }, { SREF(L"pdap-np"), 1526 }, { SREF(L"pdb"), 3033 }, { SREF(L"pdefmns"), 16311 },
    { SREF(L"pdl-datastream"), 9100 }, { SREF(L"pdnet"), 2843 }, { SREF(L"pdp"), 1675 }, { SREF(L"pdps"), 1314 },
    { SREF(L"pdrncs"), 3299 }, { SREF(L"pds"), 9595 }, { SREF(L"pdtp"), 6086 }, { SREF(L"pduncs"), 16310 },
    { SREF(L"pe-mike"), 1305 }, { SREF(L"pearldoc-xact"), 1980 }, { SREF(L"peerbook-port"), 3135 }, { SREF(L"peerwire"), 9104 },
    { SREF(L"pegasus"), 9278 }, { SREF(L"pegasus-ctSREF(L"), 9279 }, { SREF(L"pegboard"), 1357 }, { SREF(L"pehelp"), 2307 },
    { SREF(L"pentbox-sim"), 6817 }, { SREF(L"peocolSREF(L"), 9631 }, { SREF(L"peoctlr"), 9630 }, { SREF(L"peport"), 1449 },
    { SREF(L"perf-port"), 1995 }, { SREF(L"perfd"), 5227 }, { SREF(L"perimlan"), 4075 }, { SREF(L"periscope"), 1230 },
    { SREF(L"permabit-cs"), 5312 }, { SREF(L"perrla"), 4313 }, { SREF(L"persona"), 1916 }, { SREF(L"personal-agent"), 5555 },
    { SREF(L"personal-link"), 281 }, { SREF(L"personalos-001"), 3557 }, { SREF(L"personneSREF(L"), 3109 }, { SREF(L"pftp"), 662 },
    { SREF(L"pfu-prcallback"), 3208 }, { SREF(L"pgbouncer"), 6432 }, { SREF(L"pgps"), 9280 }, { SREF(L"ph"), 481 },
    { SREF(L"pharmasoft"), 1779 }, { SREF(L"pharos"), 4443 }, { SREF(L"philips-vc"), 583 }, { SREF(L"phoenix-rpc"), 3347 },
    { SREF(L"phonebook"), 767 }, { SREF(L"phonex-port"), 3177 }, { SREF(L"photuris"), 468 }, { SREF(L"phrelay"), 4868 },
    { SREF(L"phrelaydbg"), 4869 }, { SREF(L"piccolo"), 2787 }, { SREF(L"pichat"), 9009 }, { SREF(L"picknfs"), 1598 },
    { SREF(L"picodbc"), 1603 }, { SREF(L"pictrography"), 1280 }, { SREF(L"pim-port"), 8471 }, { SREF(L"pim-rp-disc"), 496 },
    { SREF(L"ping-pong"), 3010 }, { SREF(L"pinghgSREF(L"), 4306 }, { SREF(L"pip"), 1321 }, { SREF(L"pip"), 321 },
    { SREF(L"pipe-server"), 2010 }, { SREF(L"pipes"), 1465 }, { SREF(L"pipe_server"), 2010 }, { SREF(L"piranha1"), 4600 },
    { SREF(L"piranha2"), 4601 }, { SREF(L"pirp"), 553 }, { SREF(L"pit-vpn"), 2865 }, { SREF(L"pixelpusher"), 5078 },
    { SREF(L"pjlink"), 4352 }, { SREF(L"pk"), 5272 }, { SREF(L"pk-electronics"), 2634 }, { SREF(L"pkagent"), 3118 },
    { SREF(L"pkix-3-ca-ra"), 829 }, { SREF(L"pkix-cmc"), 5318 }, { SREF(L"pkix-timestamp"), 318 }, { SREF(L"pkt-krb-ipsec"), 1293 },
    { SREF(L"pktcable-cops"), 2126 }, { SREF(L"pktcablemmcops"), 3918 }, { SREF(L"plato"), 3285 }, { SREF(L"plato-lm"), 1819 },
    { SREF(L"playsta2-app"), 4658 }, { SREF(L"playsta2-lob"), 4659 }, { SREF(L"plbserve-port"), 3933 }, { SREF(L"plcy-net-svcs"), 4351 },
    { SREF(L"plethora"), 3480 }, { SREF(L"plgproxy"), 2790 }, { SREF(L"pluribus"), 3469 }, { SREF(L"plysrv-http"), 6770 },
    { SREF(L"plysrv-https"), 6771 }, { SREF(L"pm-cmdsvr"), 5112 }, { SREF(L"pmas"), 4066 }, { SREF(L"pmcd"), 44321 },
    { SREF(L"pmcdproxy"), 44322 }, { SREF(L"pmcp"), 3821 }, { SREF(L"pmcs"), 6355 }, { SREF(L"pmd"), 7431 },
    { SREF(L"pmdfmgt"), 7633 }, { SREF(L"pmdmgr"), 7426 }, { SREF(L"pmip6-cntSREF(L"), 5436 }, { SREF(L"pmip6-data"), 5437 },
    { SREF(L"pmsm-webrctSREF(L"), 2972 }, { SREF(L"pmwebapi"), 44323 }, { SREF(L"pn-requester"), 2717 }, { SREF(L"pn-requester2"), 2718 },
    { SREF(L"pnaconsult-lm"), 2937 }, { SREF(L"pnbs"), 6124 }, { SREF(L"pnbscada"), 3875 }, { SREF(L"pnet-conn"), 7797 },
    { SREF(L"pnet-enc"), 7798 }, { SREF(L"pnrp-port"), 3540 }, { SREF(L"pns"), 2487 }, { SREF(L"polestar"), 1060 },
    { SREF(L"policyserver"), 3055 }, { SREF(L"pop2"), 109 }, { SREF(L"pop3"), 110 }, { SREF(L"pop3s"), 995 },
    { SREF(L"popup-reminders"), 7787 }, { SREF(L"portgate-auth"), 3710 }, { SREF(L"postgresqSREF(L"), 5432 }, { SREF(L"pov-ray"), 494 },
    { SREF(L"PowerAlert-nsa"), 4150 }, { SREF(L"powerburst"), 485 }, { SREF(L"powerclientcsf"), 2443 }, { SREF(L"powerexchange"), 2480 },
    { SREF(L"powergemplus"), 2899 }, { SREF(L"powerguardian"), 1777 }, { SREF(L"poweronnud"), 3168 }, { SREF(L"powerschooSREF(L"), 5071 },
    { SREF(L"powwow-client"), 13223 }, { SREF(L"powwow-server"), 13224 }, { SREF(L"ppactivation"), 5134 }, { SREF(L"ppcontroSREF(L"), 2505 },
    { SREF(L"ppsms"), 3967 }, { SREF(L"ppsuitemsg"), 5863 }, { SREF(L"pptconference"), 1711 }, { SREF(L"pptp"), 1723 },
    { SREF(L"pq-lic-mgmt"), 2687 }, { SREF(L"pqsflows"), 9640 }, { SREF(L"pqsp"), 28001 }, { SREF(L"pra-elmd"), 1587 },
    { SREF(L"prat"), 1264 }, { SREF(L"prchat-server"), 4456 }, { SREF(L"prchat-user"), 4455 }, { SREF(L"precise-comm"), 5630 },
    { SREF(L"precise-i3"), 3607 }, { SREF(L"precise-sft"), 2315 }, { SREF(L"precise-vip"), 2924 }, { SREF(L"predatar-comms"), 1753 },
    { SREF(L"prelude"), 4690 }, { SREF(L"presence"), 5298 }, { SREF(L"presonus-ucnet"), 47809 }, { SREF(L"press"), 3582 },
    { SREF(L"prex-tcp"), 4487 }, { SREF(L"prgp"), 7747 }, { SREF(L"primaserver"), 6105 }, { SREF(L"print-srv"), 170 },
    { SREF(L"printer"), 515 }, { SREF(L"printer-agent"), 3396 }, { SREF(L"printercare-cc"), 6716 }, { SREF(L"printopia"), 10631 },
    { SREF(L"priority-e-com"), 2618 }, { SREF(L"prism-deploy"), 3133 }, { SREF(L"prismiq-plugin"), 3650 }, { SREF(L"privateark"), 1858 },
    { SREF(L"privatechat"), 1735 }, { SREF(L"privatewire"), 4449 }, { SREF(L"privilege"), 2588 }, { SREF(L"privoxy"), 8118 },
    { SREF(L"prizma"), 2039 }, { SREF(L"prm-nm"), 409 }, { SREF(L"prm-nm-np"), 1403 }, { SREF(L"prm-sm"), 408 },
    { SREF(L"prm-sm-np"), 1402 }, { SREF(L"prnrequest"), 3910 }, { SREF(L"prnstatus"), 3911 }, { SREF(L"pro-ed"), 8032 },
    { SREF(L"proactivate"), 24678 }, { SREF(L"proactivesrvr"), 2722 }, { SREF(L"proaxess"), 3961 }, { SREF(L"procos-lm"), 3248 },
    { SREF(L"prodigy-intrnet"), 1778 }, { SREF(L"productinfo"), 1283 }, { SREF(L"profile"), 136 }, { SREF(L"profilemac"), 4749 },
    { SREF(L"profinet-cm"), 34964 }, { SREF(L"profinet-rt"), 34962 }, { SREF(L"profinet-rtm"), 34963 }, { SREF(L"progistics"), 3973 },
    { SREF(L"programmar"), 15999 }, { SREF(L"prolink"), 1678 }, { SREF(L"proofd"), 1093 }, { SREF(L"propel-msgsys"), 1268 },
    { SREF(L"proremote"), 8183 }, { SREF(L"proshare-mc-1"), 1673 }, { SREF(L"proshare-mc-2"), 1674 }, { SREF(L"proshare1"), 1459 },
    { SREF(L"proshare2"), 1460 }, { SREF(L"proshareaudio"), 5713 }, { SREF(L"prosharedata"), 5715 }, { SREF(L"prosharenotify"), 5717 },
    { SREF(L"prosharerequest"), 5716 }, { SREF(L"prosharevideo"), 5714 }, { SREF(L"prospero"), 191 }, { SREF(L"prospero-np"), 1525 },
    { SREF(L"proxim"), 1732 }, { SREF(L"proxima-lm"), 1445 }, { SREF(L"proxy-gateway"), 2303 }, { SREF(L"prp"), 2091 },
    { SREF(L"prRegister"), 4457 }, { SREF(L"prsvp"), 3455 }, { SREF(L"ps-ams"), 3658 }, { SREF(L"psbserver"), 2350 },
    { SREF(L"pscl-mgt"), 4312 }, { SREF(L"pscribe"), 6163 }, { SREF(L"pscupd"), 3453 }, { SREF(L"psdbserver"), 2355 },
    { SREF(L"pserver"), 3662 }, { SREF(L"psi-ptt"), 4374 }, { SREF(L"pslicser"), 4168 }, { SREF(L"pslserver"), 2352 },
    { SREF(L"psmond"), 1788 }, { SREF(L"psprserver"), 2354 }, { SREF(L"pspserver"), 2353 }, { SREF(L"psrserver"), 2351 },
    { SREF(L"pss"), 7880 }, { SREF(L"pssc"), 645 }, { SREF(L"pt-tls"), 271 }, { SREF(L"pt2-discover"), 1101 },
    { SREF(L"ptcnameservice"), 597 }, { SREF(L"ptk-alink"), 3089 }, { SREF(L"ptp"), 15740 }, { SREF(L"ptp-event"), 319 },
    { SREF(L"ptp-generaSREF(L"), 320 }, { SREF(L"publiqare-sync"), 4329 }, { SREF(L"pulsonixnls"), 6140 }, { SREF(L"pump"), 751 },
    { SREF(L"puparp"), 998 }, { SREF(L"puppet"), 8140 }, { SREF(L"puprouter"), 999 }, { SREF(L"purenoise"), 663 },
    { SREF(L"purityrpc"), 8117 }, { SREF(L"pushns"), 7997 }, { SREF(L"pvaccess"), 5075 }, { SREF(L"pvsw"), 2520 },
    { SREF(L"pvsw-inet"), 2441 }, { SREF(L"pvuniwien"), 1081 }, { SREF(L"pvxpluscs"), 4093 }, { SREF(L"pvxplusio"), 4193 },
    { SREF(L"pwdgen"), 129 }, { SREF(L"pwdis"), 3735 }, { SREF(L"pwgippfax"), 3951 }, { SREF(L"pwgpsi"), 3800 },
    { SREF(L"pwgwims"), 4951 }, { SREF(L"pwrsevent"), 2694 }, { SREF(L"pxc-epmap"), 2434 }, { SREF(L"pxc-ntfy"), 3009 },
    { SREF(L"pxc-pin"), 4005 }, { SREF(L"pxc-roid"), 4004 }, { SREF(L"pxc-sapxom"), 2680 }, { SREF(L"pxc-splr"), 4007 },
    { SREF(L"pxc-splr-ft"), 4003 }, { SREF(L"pxc-spvr"), 4006 }, { SREF(L"pxc-spvr-ft"), 4002 }, { SREF(L"pyrrho"), 5433 },
    { SREF(L"q3ade"), 7794 }, { SREF(L"q55-pcc"), 1253 }, { SREF(L"qadmifevent"), 2462 }, { SREF(L"qadmifoper"), 2461 },
    { SREF(L"qb-db-server"), 10160 }, { SREF(L"qbdb"), 8019 }, { SREF(L"qbikgdp"), 368 }, { SREF(L"qcp"), 5082 },
    { SREF(L"qdb2service"), 45825 }, { SREF(L"qencp"), 2120 }, { SREF(L"qfp"), 5083 }, { SREF(L"qft"), 189 },
    { SREF(L"qftest-lookup"), 3543 }, { SREF(L"qip-audup"), 2765 }, { SREF(L"qip-login"), 2366 }, { SREF(L"qip-msgd"), 2468 },
    { SREF(L"qip-qdhcp"), 2490 }, { SREF(L"qke-llc-v3"), 2523 }, { SREF(L"qmqp"), 628 }, { SREF(L"qmtp"), 209 },
    { SREF(L"qmtps"), 6209 }, { SREF(L"qmvideo"), 5689 }, { SREF(L"qnts-orb"), 1262 }, { SREF(L"qnxnetman"), 3385 },
    { SREF(L"qo-secure"), 7913 }, { SREF(L"qotd"), 17 }, { SREF(L"qotps"), 2724 }, { SREF(L"qpasa-agent"), 2612 },
    { SREF(L"qptlmd"), 10055 }, { SREF(L"qrh"), 752 }, { SREF(L"qsm-gui"), 1165 }, { SREF(L"qsm-proxy"), 1164 },
    { SREF(L"qsm-remote"), 1166 }, { SREF(L"qsnet-assist"), 4356 }, { SREF(L"qsnet-cond"), 4357 }, { SREF(L"qsnet-nucSREF(L"), 4358 },
    { SREF(L"qsnet-trans"), 4354 }, { SREF(L"qsnet-workst"), 4355 }, { SREF(L"qsoft"), 3059 }, { SREF(L"qt-serveradmin"), 1220 },
    { SREF(L"qtms-bootstrap"), 3850 }, { SREF(L"qtp"), 2935 }, { SREF(L"quaddb"), 2497 }, { SREF(L"quailnet"), 5464 },
    { SREF(L"quake"), 26000 }, { SREF(L"quantastor"), 8153 }, { SREF(L"quartus-tcSREF(L"), 2589 }, { SREF(L"quasar-server"), 3599 },
    { SREF(L"qubes"), 1341 }, { SREF(L"quest-agent"), 3843 }, { SREF(L"quest-data-hub"), 3566 }, { SREF(L"quest-disc"), 7040 },
    { SREF(L"quest-vista"), 7980 }, { SREF(L"questdb2-lnchr"), 5677 }, { SREF(L"questnotify"), 3554 }, { SREF(L"queueadm"), 2230 },
    { SREF(L"quickbooksrds"), 3790 }, { SREF(L"quicksuite"), 2900 }, { SREF(L"quosa"), 4841 }, { SREF(L"quotad"), 762 },
    { SREF(L"qvr"), 5028 }, { SREF(L"qwave"), 2177 }, { SREF(L"raadmin"), 5676 }, { SREF(L"racf"), 18136 },
    { SREF(L"radan-http"), 8088 }, { SREF(L"radclientport"), 3178 }, { SREF(L"radec-corp"), 5430 }, { SREF(L"radio"), 1595 },
    { SREF(L"radio-bc"), 1596 }, { SREF(L"radio-sm"), 1596 }, { SREF(L"radius"), 1812 }, { SREF(L"radius-acct"), 1813 },
    { SREF(L"radius-dynauth"), 3799 }, { SREF(L"radix"), 2872 }, { SREF(L"radmin-port"), 4899 }, { SREF(L"radmind"), 6222 },
    { SREF(L"radpdf"), 18104 }, { SREF(L"rads"), 12302 }, { SREF(L"radsec"), 2083 }, { SREF(L"radware-rpm"), 2188 },
    { SREF(L"radware-rpm-s"), 2189 }, { SREF(L"radwiz-nms-srv"), 2736 }, { SREF(L"raid-ac"), 2012 }, { SREF(L"raid-am"), 2007 },
    { SREF(L"raid-am"), 2013 }, { SREF(L"raid-cc"), 2011 }, { SREF(L"raid-cd"), 2006 }, { SREF(L"raid-cd"), 2013 },
    { SREF(L"raid-cs"), 2015 }, { SREF(L"raid-sf"), 2014 }, { SREF(L"railgun-webaccSREF(L"), 2408 }, { SREF(L"ramp"), 7227 },
    { SREF(L"rancher"), 9345 }, { SREF(L"rap"), 256 }, { SREF(L"rap"), 38 }, { SREF(L"rap-ip"), 3813 },
    { SREF(L"rap-listen"), 1531 }, { SREF(L"rap-service"), 1530 }, { SREF(L"rapi"), 2176 }, { SREF(L"rapidbase"), 1953 },
    { SREF(L"rapidmq-center"), 3093 }, { SREF(L"rapidmq-reg"), 3094 }, { SREF(L"rapido-ip"), 2457 }, { SREF(L"raqmon-pdu"), 7744 },
    { SREF(L"rasadv"), 9753 }, { SREF(L"ratio-adp"), 1108 }, { SREF(L"ratSREF(L"), 2449 }, { SREF(L"ravehd"), 4037 },
    { SREF(L"raven-rdp"), 3533 }, { SREF(L"raven-rmp"), 3532 }, { SREF(L"raventbs"), 2713 }, { SREF(L"raventdm"), 2714 },
    { SREF(L"raw-seriaSREF(L"), 2167 }, { SREF(L"raxa-mgmt"), 6099 }, { SREF(L"razor"), 3555 }, { SREF(L"rbakcup1"), 2773 },
    { SREF(L"rbakcup2"), 2774 }, { SREF(L"rblcheckd"), 3768 }, { SREF(L"rbr-debug"), 44553 }, { SREF(L"rbr-discovery"), 3553 },
    { SREF(L"rbsystem"), 5693 }, { SREF(L"rbt-smc"), 7870 }, { SREF(L"rbt-wanopt"), 7810 }, { SREF(L"rcc-host"), 2332 },
    { SREF(L"rcip-itu"), 2225 }, { SREF(L"rcp"), 469 }, { SREF(L"rcst"), 3467 }, { SREF(L"rcts"), 2258 },
    { SREF(L"rda"), 630 }, { SREF(L"rdb-dbs-disp"), 1571 }, { SREF(L"rdc-wh-eos"), 3142 }, { SREF(L"rdgs"), 16385 },
    { SREF(L"rdlap"), 2321 }, { SREF(L"rdm-tfs"), 21553 }, { SREF(L"rdmnet-ctrSREF(L"), 5569 }, { SREF(L"rdmnet-device"), 5569 },
    { SREF(L"rdrmshc"), 1075 }, { SREF(L"rds"), 1540 }, { SREF(L"rds-ib"), 18634 }, { SREF(L"rds-ip"), 18635 },
    { SREF(L"rds2"), 1541 }, { SREF(L"re-conn-proto"), 1306 }, { SREF(L"re-mail-ck"), 50 }, { SREF(L"re101"), 1343 },
    { SREF(L"reachout"), 43188 }, { SREF(L"realm-rusd"), 688 }, { SREF(L"realsecure"), 2998 }, { SREF(L"reboSREF(L"), 2997 },
    { SREF(L"recipe"), 2240 }, { SREF(L"recvr-rc"), 43000 }, { SREF(L"recvr-rc-disc"), 43000 }, { SREF(L"redis"), 6379 },
    { SREF(L"redstone-cpss"), 2928 }, { SREF(L"redstorm-diag"), 2349 }, { SREF(L"redstorm-find"), 2347 }, { SREF(L"redstorm-info"), 2348 },
    { SREF(L"redstorm-join"), 2346 }, { SREF(L"redwood-chat"), 3032 }, { SREF(L"reftek"), 2543 }, { SREF(L"registrar"), 1712 },
    { SREF(L"relief"), 1353 }, { SREF(L"rellpack"), 2018 }, { SREF(L"reload-config"), 6084 }, { SREF(L"remcap"), 4731 },
    { SREF(L"remctSREF(L"), 4373 }, { SREF(L"remographlm"), 2373 }, { SREF(L"remote-as"), 1053 }, { SREF(L"remote-collab"), 2250 },
    { SREF(L"remote-kis"), 185 }, { SREF(L"remote-winsock"), 1745 }, { SREF(L"remotedeploy"), 3789 }, { SREF(L"remotefs"), 556 },
    { SREF(L"remoteware-cSREF(L"), 3000 }, { SREF(L"remoteware-srv"), 3002 }, { SREF(L"remoteware-un"), 2999 }, { SREF(L"repcmd"), 641 },
    { SREF(L"repliweb"), 2837 }, { SREF(L"repscmd"), 653 }, { SREF(L"repsvc"), 6320 }, { SREF(L"res"), 1942 },
    { SREF(L"res-sap"), 3163 }, { SREF(L"resacommunity"), 1154 }, { SREF(L"rescap"), 283 }, { SREF(L"resorcs"), 4733 },
    { SREF(L"resource-mgr"), 3019 }, { SREF(L"responselogic"), 2886 }, { SREF(L"responsenet"), 3045 }, { SREF(L"retp"), 32811 },
    { SREF(L"retrospect"), 497 }, { SREF(L"rets"), 6103 }, { SREF(L"rets-ssSREF(L"), 12109 }, { SREF(L"reversion"), 5842 },
    { SREF(L"rexecj"), 8230 }, { SREF(L"rfa"), 4672 }, { SREF(L"rfb"), 5900 }, { SREF(L"rfe"), 5002 },
    { SREF(L"rfid-rp1"), 4684 }, { SREF(L"rfile"), 750 }, { SREF(L"rfio"), 3147 }, { SREF(L"rfmp"), 2249 },
    { SREF(L"rfx-lm"), 1497 }, { SREF(L"rgtp"), 1431 }, { SREF(L"rhp-iibp"), 1912 }, { SREF(L"rib-slm"), 3296 },
    { SREF(L"ricardo-lm"), 1522 }, { SREF(L"ricardo-lm"), 6148 }, { SREF(L"rich-cp"), 2057 }, { SREF(L"rid"), 4590 },
    { SREF(L"ridgeway1"), 2776 }, { SREF(L"ridgeway2"), 2777 }, { SREF(L"rimf-ps"), 2209 }, { SREF(L"rimsSREF(L"), 2044 },
    { SREF(L"ripng"), 521 }, { SREF(L"ris"), 180 }, { SREF(L"ris-cm"), 748 }, { SREF(L"rise"), 7473 },
    { SREF(L"rjcdb-vcards"), 9208 }, { SREF(L"rje"), 5 }, { SREF(L"rkb-oscs"), 1817 }, { SREF(L"rlm"), 5053 },
    { SREF(L"rlm-admin"), 5054 }, { SREF(L"rlm-disc"), 5053 }, { SREF(L"rlp"), 39 }, { SREF(L"rlzdbase"), 635 },
    { SREF(L"rmc"), 657 }, { SREF(L"rmiactivation"), 1098 }, { SREF(L"rmiaux"), 10990 }, { SREF(L"rmiregistry"), 1099 },
    { SREF(L"rmlnk"), 2818 }, { SREF(L"rmonitor"), 560 }, { SREF(L"rmonitor-secure"), 5145 }, { SREF(L"rmopagt"), 2959 },
    { SREF(L"rmpp"), 1121 }, { SREF(L"rmt"), 411 }, { SREF(L"rmtserver"), 2416 }, { SREF(L"rna"), 25471 },
    { SREF(L"rnm"), 3844 }, { SREF(L"rnmap"), 3418 }, { SREF(L"rnrp"), 2423 }, { SREF(L"robcad-lm"), 1509 },
    { SREF(L"robix"), 9599 }, { SREF(L"roboeda"), 2920 }, { SREF(L"roboer"), 2919 }, { SREF(L"robotraconteur"), 48653 },
    { SREF(L"roce"), 4791 }, { SREF(L"rockwell-csp1"), 2221 }, { SREF(L"rockwell-csp2"), 2223 }, { SREF(L"rocraiSREF(L"), 8051 },
    { SREF(L"roketz"), 1730 }, { SREF(L"rootd"), 1094 }, { SREF(L"routematch"), 1287 }, { SREF(L"router"), 520 },
    { SREF(L"roverlog"), 3677 }, { SREF(L"rp-reputation"), 6568 }, { SREF(L"rpasswd"), 774 }, { SREF(L"rpc2portmap"), 369 },
    { SREF(L"rpi"), 2214 }, { SREF(L"rpki-rtr"), 323 }, { SREF(L"rpki-rtr-tls"), 324 }, { SREF(L"rprt"), 3064 },
    { SREF(L"rrac"), 5678 }, { SREF(L"rrdp"), 5313 }, { SREF(L"rrh"), 753 }, { SREF(L"rrifmm"), 1696 },
    { SREF(L"rrilwm"), 1695 }, { SREF(L"rrimwm"), 1694 }, { SREF(L"rrirtr"), 1693 }, { SREF(L"rrisat"), 1697 },
    { SREF(L"rrp"), 648 }, { SREF(L"rs-pias"), 13217 }, { SREF(L"rs-rmi"), 3736 }, { SREF(L"rs-status"), 45002 },
    { SREF(L"rsap"), 1647 }, { SREF(L"rsc-robot"), 1793 }, { SREF(L"rscd"), 5750 }, { SREF(L"rscs"), 10201 },
    { SREF(L"rsf-1"), 1195 }, { SREF(L"rsh-spx"), 222 }, { SREF(L"rsip"), 4555 }, { SREF(L"rsisysaccess"), 2752 },
    { SREF(L"rsms"), 10201 }, { SREF(L"rsmtp"), 2390 }, { SREF(L"rsom"), 2889 }, { SREF(L"rsqlserver"), 4430 },
    { SREF(L"rsvd"), 168 }, { SREF(L"rsvp-encap-1"), 1698 },
    { SREF(L"rsvp-encap-2"), 1699 },
    { SREF(L"rsvp-tunneSREF(L"), 363 },
    { SREF(L"rsync"), 873 }, { SREF(L"rt-classmanager"), 35004 }, { SREF(L"rt-devicemapper"), 35003 }, { SREF(L"rt-event"), 3706 },
    { SREF(L"rt-event-s"), 3707 }, { SREF(L"rt-helper"), 35006 }, { SREF(L"rt-labtracker"), 35005 }, { SREF(L"rt-sound"), 35002 },
    { SREF(L"rt-viewer"), 35001 }, { SREF(L"rtc-pm-port"), 3891 }, { SREF(L"rtcm-sc104"), 2101 }, { SREF(L"rtelnet"), 107 },
    { SREF(L"rtip"), 771 }, { SREF(L"rtmp-port"), 3500 }, { SREF(L"rtnt-1"), 3137 }, { SREF(L"rtnt-2"), 3138 },
    { SREF(L"rtps-dd-mt"), 7402 }, { SREF(L"rtps-dd-ut"), 7401 }, { SREF(L"rtps-discovery"), 7400 }, { SREF(L"rtraceroute"), 3765 },
    { SREF(L"rtsclient"), 2501 }, { SREF(L"rtsp"), 554 }, { SREF(L"rtsp-alt"), 8554 }, { SREF(L"rtsps"), 322 },
    { SREF(L"rtsserv"), 2500 }, { SREF(L"rugameonline"), 5156 }, { SREF(L"rusb-sys-port"), 3422 }, { SREF(L"rushd"), 696 },
    { SREF(L"rvs-isdn-dcp"), 2578 }, { SREF(L"rwhois"), 4321 }, { SREF(L"rwp"), 30100 }, { SREF(L"rxapi"), 10010 },
    { SREF(L"rxe"), 761 }, { SREF(L"rxmon"), 1311 }, { SREF(L"s-bfd"), 7784 }, { SREF(L"s-net"), 166 },
    { SREF(L"s-openmaiSREF(L"), 5767 }, { SREF(L"s1-controSREF(L"), 36412 }, { SREF(L"s102"), 23272 }, { SREF(L"s3db"), 2278 },
    { SREF(L"s8-client-port"), 3153 }, { SREF(L"sa-msg-port"), 1646 }, { SREF(L"sabams"), 2760 }, { SREF(L"sabarsd"), 8401 },
    { SREF(L"sabp-signaSREF(L"), 3452 }, { SREF(L"sac"), 8097 }, { SREF(L"sacred"), 1118 }, { SREF(L"safetynetp"), 40000 },
    { SREF(L"saft"), 487 }, { SREF(L"sage-best-com1"), 14033 }, { SREF(L"sage-best-com2"), 14034 }, { SREF(L"sagectlpaneSREF(L"), 3698 },
    { SREF(L"sagxtsds"), 4952 }, { SREF(L"sah-lm"), 3291 }, { SREF(L"sai-sentlm"), 2640 }, { SREF(L"sais"), 1426 },
    { SREF(L"saiscm"), 1501 }, { SREF(L"saiseh"), 1644 }, { SREF(L"saism"), 1436 }, { SREF(L"salient-dtasrv"), 5409 },
    { SREF(L"salient-mux"), 5422 }, { SREF(L"salient-usrmgr"), 5410 }, { SREF(L"samd"), 3275 }, { SREF(L"samsung-disc"), 30832 },
    { SREF(L"samsung-unidex"), 4010 }, { SREF(L"sanavigator"), 4033 }, { SREF(L"sane-port"), 6566 }, { SREF(L"sanity"), 643 },
    { SREF(L"santak-ups"), 3038 }, { SREF(L"santools"), 4079 }, { SREF(L"saphostctrSREF(L"), 1128 }, { SREF(L"saphostctrls"), 1129 },
    { SREF(L"sapv1"), 9875 }, { SREF(L"saratoga"), 7542 }, { SREF(L"saris"), 4442 }, { SREF(L"sas-remote-hlp"), 3755 },
    { SREF(L"sasg"), 3744 }, { SREF(L"sasggprs"), 3964 }, { SREF(L"sasp"), 3860 }, { SREF(L"satvid-datalnk"), 3367 },
    { SREF(L"satvid-datalnk"), 3368 }, { SREF(L"satvid-datalnk"), 3369 }, { SREF(L"satvid-datalnk"), 3370 }, { SREF(L"satvid-datalnk"), 3371 },
    { SREF(L"sauterdongle"), 25576 }, { SREF(L"savant"), 3391 }, { SREF(L"sbackup"), 5163 }, { SREF(L"sbcap"), 29168 },
    { SREF(L"sbi-agent"), 3962 }, { SREF(L"sbSREF(L"), 1039 }, { SREF(L"sbook"), 1349 }, { SREF(L"scan-change"), 2719 },
    { SREF(L"scanstat-1"), 1215 }, { SREF(L"scc-security"), 582 }, { SREF(L"sccip-media"), 3499 }, { SREF(L"sceanics"), 5435 },
    { SREF(L"scenccs"), 7129 }, { SREF(L"scenidm"), 7128 }, { SREF(L"scientia-sdb"), 1811 }, { SREF(L"scientia-ssdb"), 2121 },
    { SREF(L"scinet"), 7708 }, { SREF(L"scintilla"), 19007 }, { SREF(L"scipticslsrvr"), 2577 }, { SREF(L"sco-aip"), 5307 },
    { SREF(L"sco-dtmgr"), 617 }, { SREF(L"sco-inetmgr"), 615 }, { SREF(L"sco-peer-tta"), 5427 }, { SREF(L"sco-sysmgr"), 616 },
    { SREF(L"sco-websrvrmg3"), 598 }, { SREF(L"sco-websrvrmgr"), 620 }, { SREF(L"scohelp"), 457 }, { SREF(L"scoi2odialog"), 360 },
    { SREF(L"scoSREF(L"), 1200 }, { SREF(L"scoremgr"), 2034 }, { SREF(L"scotty-disc"), 14002 }, { SREF(L"scotty-ft"), 14000 },
    { SREF(L"scp"), 3820 }, { SREF(L"scp-config"), 10001 }, { SREF(L"scpi-raw"), 5025 }, { SREF(L"scpi-telnet"), 5024 },
    { SREF(L"scrabble"), 2026 }, { SREF(L"screencast"), 1368 }, { SREF(L"scriptview"), 7741 }, { SREF(L"scscp"), 26133 },
    { SREF(L"scservp"), 3637 }, { SREF(L"scte104"), 5167 }, { SREF(L"scte30"), 5168 }, { SREF(L"sctp-tunneling"), 9899 },
    { SREF(L"scup"), 6315 }, { SREF(L"scup-disc"), 6315 }, { SREF(L"scx-proxy"), 470 }, { SREF(L"sd"), 9876 },
    { SREF(L"sd-capacity"), 2384 }, { SREF(L"sd-data"), 2385 }, { SREF(L"sd-elmd"), 1681 }, { SREF(L"sd-request"), 2384 },
    { SREF(L"sdbproxy"), 3562 }, { SREF(L"sdclient"), 2310 }, { SREF(L"sddp"), 1163 }, { SREF(L"sde-discovery"), 5152 },
    { SREF(L"sdfunc"), 2046 }, { SREF(L"sdhelp"), 2308 }, { SREF(L"sdl-ets"), 5081 }, { SREF(L"sdmmp"), 5573 },
    { SREF(L"sdnskmp"), 558 }, { SREF(L"sdo"), 3635 }, { SREF(L"sdo-ssh"), 3897 }, { SREF(L"sdo-tls"), 3896 },
    { SREF(L"sdp-id-port"), 3242 }, { SREF(L"sdp-portmapper"), 3935 }, { SREF(L"sdproxy"), 1297 }, { SREF(L"sdr"), 9010 },
    { SREF(L"sds"), 5059 }, { SREF(L"sds-admin"), 2705 }, { SREF(L"sdsc-lm"), 1537 }, { SREF(L"sdserver"), 2309 },
    { SREF(L"sdt"), 5568 }, { SREF(L"sdt-lmd"), 3319 }, { SREF(L"sdtvwcam"), 24666 }, { SREF(L"seagull-ais"), 1208 },
    { SREF(L"seagulllms"), 1291 }, { SREF(L"seaodbc"), 2471 }, { SREF(L"search"), 2010 }, { SREF(L"search-agent"), 1234 },
    { SREF(L"seaview"), 3143 }, { SREF(L"sec-ntb-clnt"), 32635 }, { SREF(L"sec-pc2fax-srv"), 9402 }, { SREF(L"sec-t4net-clt"), 9401 },
    { SREF(L"sec-t4net-srv"), 9400 }, { SREF(L"seclayer-tcp"), 3495 }, { SREF(L"seclayer-tls"), 3496 }, { SREF(L"secrmmsafecopya"), 38865 },
    { SREF(L"secure-cfg-svr"), 3978 }, { SREF(L"secure-mqtt"), 8883 }, { SREF(L"secure-ts"), 9318 }, { SREF(L"securitychase"), 5399 },
    { SREF(L"seispoc"), 2254 }, { SREF(L"semantix"), 361 }, { SREF(L"semaphore"), 3255 }, { SREF(L"send"), 169 },
    { SREF(L"senip"), 3898 }, { SREF(L"senomix01"), 8052 }, { SREF(L"senomix02"), 8053 }, { SREF(L"senomix03"), 8054 },
    { SREF(L"senomix04"), 8055 }, { SREF(L"senomix05"), 8056 }, { SREF(L"senomix06"), 8057 }, { SREF(L"senomix07"), 8058 },
    { SREF(L"senomix08"), 8059 }, { SREF(L"sent-lm"), 2316 }, { SREF(L"sentineSREF(L"), 3588 }, { SREF(L"sentinel-ent"), 3712 },
    { SREF(L"sentinel-lm"), 5093 }, { SREF(L"sentinelsrm"), 1947 }, { SREF(L"sentlm-srv2srv"), 5099 }, { SREF(L"sep"), 2089 },
    { SREF(L"seraph"), 4076 }, { SREF(L"sercomm-scadmin"), 6108 }, { SREF(L"sercomm-wlink"), 2235 }, { SREF(L"serialgateway"), 1243 },
    { SREF(L"server-find"), 8351 }, { SREF(L"servergraph"), 1251 }, { SREF(L"serverstart"), 9213 }, { SREF(L"serverview-as"), 3169 },
    { SREF(L"serverview-asn"), 3170 }, { SREF(L"serverview-gf"), 3171 }, { SREF(L"serverview-icc"), 3173 }, { SREF(L"serverview-rm"), 3172 },
    { SREF(L"serverviewdbms"), 9212 }, { SREF(L"serverwsd2"), 5362 }, { SREF(L"servexec"), 2021 }, { SREF(L"service-ctrSREF(L"), 2367 },
    { SREF(L"servicemeter"), 2603 }, { SREF(L"servicetags"), 6481 }, { SREF(L"servistaitsm"), 3636 }, { SREF(L"servserv"), 2011 },
    { SREF(L"servstat"), 633 }, { SREF(L"sesi-lm"), 1714 }, { SREF(L"set"), 257 }, { SREF(L"sf-lm"), 4546 },
    { SREF(L"sflm"), 3162 }, { SREF(L"sflow"), 6343 }, { SREF(L"sfm-db-server"), 5636 }, { SREF(L"sfmsso"), 5635 },
    { SREF(L"sfs-config"), 452 }, { SREF(L"sfs-smp-net"), 451 }, { SREF(L"sftdst-port"), 3230 }, { SREF(L"sftp"), 115 },
    { SREF(L"sftsrv"), 1303 }, { SREF(L"sftu"), 3326 }, { SREF(L"sg-lm"), 1659 }, { SREF(L"sgcip"), 16950 },
    { SREF(L"sgcp"), 440 }, { SREF(L"sge-execd"), 6445 }, { SREF(L"sge-qmaster"), 6444 }, { SREF(L"sgi-arrayd"), 5434 },
    { SREF(L"sgi-dmfmgr"), 11109 }, { SREF(L"sgi-esphttp"), 5554 }, { SREF(L"sgi-eventmond"), 5553 }, { SREF(L"sgi-lk"), 11106 },
    { SREF(L"sgi-soap"), 11110 }, { SREF(L"sgi-storman"), 1178 }, { SREF(L"sgmp"), 153 }, { SREF(L"sgmp-traps"), 160 },
    { SREF(L"sgsap"), 29118 }, { SREF(L"shadowserver"), 2027 }, { SREF(L"shadowstream"), 4366 }, { SREF(L"shaperai"), 43210 },
    { SREF(L"shaperai-disc"), 43210 }, { SREF(L"shareapp"), 3595 }, { SREF(L"sharp-server"), 3617 }, { SREF(L"shelSREF(L"), 514 },
    { SREF(L"shilp"), 2049 }, { SREF(L"shiprush-d-ch"), 5841 }, { SREF(L"shiprush-db-svr"), 3841 }, { SREF(L"shiva-confsrvr"), 1651 },
    { SREF(L"shivadiscovery"), 1502 }, { SREF(L"shivahose"), 1549 }, { SREF(L"shivasound"), 1549 }, { SREF(L"shockwave"), 1626 },
    { SREF(L"shockwave2"), 1257 }, { SREF(L"shofar"), 4105 }, { SREF(L"shrewd-controSREF(L"), 22335 }, { SREF(L"shrewd-stream"), 22335 },
    { SREF(L"shrinkwrap"), 358 }, { SREF(L"sia-ctrl-plane"), 4787 }, { SREF(L"siam"), 498 }, { SREF(L"sicct"), 4742 },
    { SREF(L"sicct-sdp"), 4742 }, { SREF(L"siebel-ns"), 2320 }, { SREF(L"siemensgsm"), 28240 }, { SREF(L"sieve"), 4190 },
    { SREF(L"sift-uft"), 608 }, { SREF(L"sightline"), 1645 }, { SREF(L"sigma-port"), 3614 }, { SREF(L"signacert-agent"), 5032 },
    { SREF(L"signaSREF(L"), 2974 }, { SREF(L"signet-ctf"), 2733 }, { SREF(L"siipat"), 1733 }, { SREF(L"silc"), 706 },
    { SREF(L"silhouette"), 7500 }, { SREF(L"silkmeter"), 5461 }, { SREF(L"silkp1"), 2829 }, { SREF(L"silkp2"), 2830 },
    { SREF(L"silkp3"), 2831 }, { SREF(L"silkp4"), 2832 }, { SREF(L"silverpeakcomm"), 4164 }, { SREF(L"silverpeakpeer"), 4163 },
    { SREF(L"silverplatter"), 416 }, { SREF(L"sim-controSREF(L"), 3110 }, { SREF(L"simba-cs"), 1543 }, { SREF(L"simbaexpress"), 1583 },
    { SREF(L"simbaservices"), 1599 }, { SREF(L"simco"), 7626 }, { SREF(L"simctlp"), 2857 }, { SREF(L"simon"), 4753 },
    { SREF(L"simon-disc"), 4753 }, { SREF(L"simp-alSREF(L"), 1959 }, { SREF(L"simple-push"), 3687 }, { SREF(L"simple-push-s"), 3688 },
    { SREF(L"simple-tx-rx"), 2257 }, { SREF(L"simplement-tie"), 2756 }, { SREF(L"simplifymedia"), 8087 }, { SREF(L"simslink"), 2676 },
    { SREF(L"sip"), 5060 }, { SREF(L"sips"), 5061 }, { SREF(L"sis-emt"), 2545 }, { SREF(L"sitaradir"), 2631 },
    { SREF(L"sitaramgmt"), 2630 }, { SREF(L"sitaraserver"), 2629 }, { SREF(L"sitewatch"), 3792 }, { SREF(L"sitewatch-s"), 3766 },
    { SREF(L"six-degrees"), 3611 }, { SREF(L"sixchat"), 4605 }, { SREF(L"sixnetudr"), 1658 }, { SREF(L"sixtrak"), 1594 },
    { SREF(L"sixxsconfig"), 3874 }, { SREF(L"skip-cert-recv"), 6455 }, { SREF(L"skip-cert-send"), 6456 }, { SREF(L"skip-mc-gikreq"), 1660 },
    { SREF(L"skronk"), 460 }, { SREF(L"sky-transport"), 3556 }, { SREF(L"skytelnet"), 1618 }, { SREF(L"slc-ctrlrloops"), 2827 },
    { SREF(L"slc-systemlog"), 2826 }, { SREF(L"slim-devices"), 3483 }, { SREF(L"slingshot"), 1705 }, { SREF(L"slinkysearch"), 1225 },
    { SREF(L"slinterbase"), 3065 }, { SREF(L"slm-api"), 1606 }, { SREF(L"slp"), 1605 }, { SREF(L"slp-notify"), 1847 },
    { SREF(L"slscc"), 4408 }, { SREF(L"slslavemon"), 3102 }, { SREF(L"slush"), 1966 }, { SREF(L"sm-disc"), 4174 },
    { SREF(L"sm-pas-1"), 2938 }, { SREF(L"sm-pas-2"), 2939 }, { SREF(L"sm-pas-3"), 2940 }, { SREF(L"sm-pas-4"), 2941 },
    { SREF(L"sm-pas-5"), 2942 }, { SREF(L"sma-spw"), 9522 }, { SREF(L"smaclmgr"), 4660 }, { SREF(L"smakynet"), 122 },
    { SREF(L"smap"), 3731 }, { SREF(L"smar-se-port1"), 4987 }, { SREF(L"smar-se-port2"), 4988 }, { SREF(L"smart-diagnose"), 2721 },
    { SREF(L"smart-instalSREF(L"), 4786 }, { SREF(L"smart-lm"), 1608 }, { SREF(L"smartcard-port"), 3516 }, { SREF(L"smartcard-tls"), 4116 },
    { SREF(L"smartpackets"), 3218 }, { SREF(L"smartsdp"), 426 }, { SREF(L"smauth-port"), 3929 }, { SREF(L"smbdirect"), 5445 },
    { SREF(L"smc-admin"), 6787 }, { SREF(L"smc-http"), 6788 }, { SREF(L"smc-https"), 6789 }, { SREF(L"smc-jmx"), 6786 },
    { SREF(L"smcluster"), 4174 }, { SREF(L"smile"), 3670 }, { SREF(L"smip"), 7734 }, { SREF(L"smntubootstrap"), 2613 },
    { SREF(L"smpnameres"), 901 }, { SREF(L"smpp"), 2775 }, { SREF(L"smpppd"), 3185 }, { SREF(L"smpte"), 420 },
    { SREF(L"sms-chat"), 2703 }, { SREF(L"sms-rcinfo"), 2701 }, { SREF(L"sms-remctrSREF(L"), 2704 }, { SREF(L"sms-xfer"), 2702 },
    { SREF(L"smsd"), 596 }, { SREF(L"smsp"), 413 }, { SREF(L"smsqp"), 11201 }, { SREF(L"smtp"), 25 },
    { SREF(L"smux"), 199 }, { SREF(L"smwan"), 3979 }, { SREF(L"sna-cs"), 1553 }, { SREF(L"snac"), 3536 },
    { SREF(L"snagas"), 108 }, { SREF(L"snap"), 4752 }, { SREF(L"snapd"), 2599 }, { SREF(L"snapenetio"), 22000 },
    { SREF(L"snapp"), 2333 }, { SREF(L"snare"), 509 }, { SREF(L"snaresecure"), 1684 }, { SREF(L"sncp"), 7560 },
    { SREF(L"snifferclient"), 2452 }, { SREF(L"snifferdata"), 2892 }, { SREF(L"snifferserver"), 2533 }, { SREF(L"snip-slave"), 33656 },
    { SREF(L"snmp"), 161 }, { SREF(L"snmp-tcp-port"), 1993 }, { SREF(L"snmpdtls"), 10161 }, { SREF(L"snmpdtls-trap"), 10162 },
    { SREF(L"snmpssh"), 5161 }, { SREF(L"snmpssh-trap"), 5162 }, { SREF(L"snmptls"), 10161 }, { SREF(L"snmptls-trap"), 10162 },
    { SREF(L"snmptrap"), 162 }, { SREF(L"snpp"), 444 }, { SREF(L"sns-admin"), 2658 }, { SREF(L"sns-agent"), 5417 },
    { SREF(L"sns-channels"), 3380 }, { SREF(L"sns-dispatcher"), 2657 }, { SREF(L"sns-gateway"), 5416 }, { SREF(L"sns-protocoSREF(L"), 2409 },
    { SREF(L"sns-query"), 2659 }, { SREF(L"sns-quote"), 1967 }, { SREF(L"snss"), 11171 }, { SREF(L"sntlkeyssrvr"), 9450 },
    { SREF(L"sntp-heartbeat"), 580 }, { SREF(L"soagateway"), 5250 }, { SREF(L"soap-beep"), 605 }, { SREF(L"soap-http"), 7627 },
    { SREF(L"socalia"), 5100 }, { SREF(L"social-alarm"), 5146 }, { SREF(L"socks"), 1080 }, { SREF(L"socorfs"), 3379 },
    { SREF(L"socp-c"), 4882 }, { SREF(L"socp-t"), 4881 }, { SREF(L"softaudit"), 3419 }, { SREF(L"softcm"), 6110 },
    { SREF(L"softdataphone"), 1621 }, { SREF(L"softpc"), 215 }, { SREF(L"softrack-meter"), 3884 }, { SREF(L"solaris-audit"), 16162 },
    { SREF(L"solera-epmap"), 2132 }, { SREF(L"solera-lpn"), 4738 }, { SREF(L"solid-e-engine"), 1964 }, { SREF(L"solid-mux"), 1029 },
    { SREF(L"solve"), 2636 }, { SREF(L"sonar"), 572 }, { SREF(L"sonardata"), 2863 }, { SREF(L"soniqsync"), 3803 },
    { SREF(L"sonus"), 2653 }, { SREF(L"sonus-logging"), 2290 }, { SREF(L"sonuscallsig"), 2569 }, { SREF(L"sophia-lm"), 1408 },
    { SREF(L"sops"), 3944 }, { SREF(L"sor-update"), 3922 }, { SREF(L"sos"), 3838 }, { SREF(L"sossd-agent"), 7982 },
    { SREF(L"sossd-collect"), 7981 }, { SREF(L"sossd-disc"), 7982 }, { SREF(L"sossecollector"), 3166 }, { SREF(L"soundsvirtuaSREF(L"), 17185 },
    { SREF(L"spamtrap"), 2568 }, { SREF(L"spandataport"), 3193 }, { SREF(L"spc"), 6111 }, { SREF(L"spcsdlobby"), 2888 },
    { SREF(L"spdp"), 5794 }, { SREF(L"spdy"), 6121 }, { SREF(L"spearway"), 2440 }, { SREF(L"spectardata"), 3834 },
    { SREF(L"spectardb"), 3835 }, { SREF(L"spectraport"), 3851 }, { SREF(L"speedtrace"), 33334 }, { SREF(L"speedtrace-disc"), 33334 },
    { SREF(L"sphinxapi"), 9312 }, { SREF(L"sphinxqSREF(L"), 9306 }, { SREF(L"spice"), 1923 }, { SREF(L"spike"), 4683 },
    { SREF(L"spiral-admin"), 3438 }, { SREF(L"splitlock"), 3606 }, { SREF(L"splitlock-gw"), 3647 }, { SREF(L"spmp"), 656 },
    { SREF(L"spock"), 2507 }, { SREF(L"spocp"), 4751 }, { SREF(L"spramsca"), 5769 }, { SREF(L"spramsd"), 5770 },
    { SREF(L"spremotetablet"), 46998 }, { SREF(L"sps-tunneSREF(L"), 2876 }, { SREF(L"spsc"), 478 }, { SREF(L"spss"), 5443 },
    { SREF(L"spss-lm"), 1759 }, { SREF(L"spt-automation"), 5814 }, { SREF(L"sptx"), 40404 }, { SREF(L"spugna"), 3807 },
    { SREF(L"spw-dialer"), 3796 }, { SREF(L"spw-dnspreload"), 3849 }, { SREF(L"spytechphone"), 8192 }, { SREF(L"sqdr"), 2728 },
    { SREF(L"sql-net"), 150 }, { SREF(L"sql-net"), 66 }, { SREF(L"sqlexec"), 9088 }, { SREF(L"sqlexec-ssSREF(L"), 9089 },
    { SREF(L"sqlserv"), 118 }, { SREF(L"sqlsrv"), 156 }, { SREF(L"src"), 200 }, { SREF(L"srcp"), 4303 },
    { SREF(L"srdp"), 3942 }, { SREF(L"srmp"), 193 }, { SREF(L"srp-feedback"), 2737 }, { SREF(L"srssend"), 362 },
    { SREF(L"sruth"), 38800 }, { SREF(L"srvc-registry"), 3018 }, { SREF(L"ss-idi"), 20013 }, { SREF(L"ss-idi-disc"), 20012 },
    { SREF(L"ss7ns"), 477 }, { SREF(L"ssad"), 4750 }, { SREF(L"ssc-agent"), 2967 }, { SREF(L"sscan"), 3853 },
    { SREF(L"ssdispatch"), 3430 }, { SREF(L"ssdp"), 1900 }, { SREF(L"ssdtp"), 6071 }, { SREF(L"sse-app-config"), 3852 },
    { SREF(L"ssh"), 22 }, { SREF(L"ssh-mgmt"), 17235 }, { SREF(L"sshelSREF(L"), 614 }, { SREF(L"sslp"), 1750 },
    { SREF(L"ssm-cssps"), 2478 }, { SREF(L"ssm-cvs"), 2477 }, { SREF(L"ssm-els"), 2479 }, { SREF(L"ssmc"), 2187 },
    { SREF(L"ssmd"), 2187 }, { SREF(L"ssmpp"), 3550 }, { SREF(L"sso-controSREF(L"), 2711 }, { SREF(L"sso-service"), 2710 },
    { SREF(L"ssowatch"), 3644 }, { SREF(L"ssp"), 3249 }, { SREF(L"ssp-client"), 7801 }, { SREF(L"ssqSREF(L"), 3352 },
    { SREF(L"ssr-servermgr"), 45966 }, { SREF(L"ssrip"), 3318 }, { SREF(L"ssslic-mgr"), 1203 }, { SREF(L"ssslog-mgr"), 1204 },
    { SREF(L"sst"), 266 }, { SREF(L"sstp-1"), 7743 }, { SREF(L"sstp-2"), 9801 }, { SREF(L"sstsys-lm"), 1692 },
    { SREF(L"stanag-5066"), 5066 }, { SREF(L"starbot"), 2838 }, { SREF(L"starfish"), 3981 }, { SREF(L"stargatealerts"), 1654 },
    { SREF(L"starquiz-port"), 3526 }, { SREF(L"stars"), 4131 }, { SREF(L"starschooSREF(L"), 2270 }, { SREF(L"start-network"), 3615 },
    { SREF(L"startron"), 1057 }, { SREF(L"stat-cc"), 4158 }, { SREF(L"stat-results"), 4156 }, { SREF(L"stat-scanner"), 4157 },
    { SREF(L"statsci1-lm"), 6144 }, { SREF(L"statsci2-lm"), 6145 }, { SREF(L"statsrv"), 133 }, { SREF(L"statusd"), 5414 },
    { SREF(L"stdptc"), 2154 }, { SREF(L"ste-smsc"), 1836 }, { SREF(L"stgxfws"), 1226 }, { SREF(L"sti-envision"), 1312 },
    { SREF(L"stm-pproc"), 3080 }, { SREF(L"stmf"), 501 }, { SREF(L"stone-design-1"), 1492 }, { SREF(L"stonefalls"), 2986 },
    { SREF(L"storman"), 4178 }, { SREF(L"storview"), 9293 }, { SREF(L"streamcomm-ds"), 9612 }, { SREF(L"street-stream"), 1736 },
    { SREF(L"streetperfect"), 1330 }, { SREF(L"streettalk"), 566 }, { SREF(L"streletz"), 6344 }, { SREF(L"stresstester"), 5397 },
    { SREF(L"strexec-d"), 5026 }, { SREF(L"strexec-s"), 5027 }, { SREF(L"stryker-com"), 3854 }, { SREF(L"stss"), 3090 },
    { SREF(L"stt"), 1607 }, { SREF(L"sttunneSREF(L"), 7471 }, { SREF(L"stun"), 3478 }, { SREF(L"stun-behavior"), 3478 },
    { SREF(L"stun-behaviors"), 5349 }, { SREF(L"stun-p1"), 1990 }, { SREF(L"stun-p2"), 1991 }, { SREF(L"stun-p3"), 1992 },
    { SREF(L"stun-port"), 1994 }, { SREF(L"stuns"), 5349 }, { SREF(L"stvp"), 3158 }, { SREF(L"stx"), 527 },
    { SREF(L"su-mit-tg"), 89 }, { SREF(L"sua"), 14001 }, { SREF(L"submission"), 587 }, { SREF(L"submit"), 773 },
    { SREF(L"submitserver"), 2028 }, { SREF(L"subntbcst-tftp"), 247 }, { SREF(L"sugp"), 1905 }, { SREF(L"suitcase"), 2903 },
    { SREF(L"suitjd"), 3354 }, { SREF(L"sum"), 6551 }, { SREF(L"sun-as-iiops"), 3708 }, { SREF(L"sun-as-iiops-ca"), 3808 },
    { SREF(L"sun-as-jmxrmi"), 8686 }, { SREF(L"sun-as-jpda"), 9191 }, { SREF(L"sun-as-nodeagt"), 4850 }, { SREF(L"sun-dr"), 665 },
    { SREF(L"sun-lm"), 7588 }, { SREF(L"sun-mc-grp"), 5306 }, { SREF(L"sun-sea-port"), 16161 }, { SREF(L"sun-sr-admin"), 6489 },
    { SREF(L"sun-sr-http"), 6480 }, { SREF(L"sun-sr-https"), 6443 }, { SREF(L"sun-sr-iiop"), 6485 }, { SREF(L"sun-sr-iiop-aut"), 6487 },
    { SREF(L"sun-sr-iiops"), 6486 }, { SREF(L"sun-sr-jms"), 6484 }, { SREF(L"sun-sr-jmx"), 6488 }, { SREF(L"sun-user-https"), 7677 },
    { SREF(L"suncacao-csa"), 11164 }, { SREF(L"suncacao-jmxmp"), 11162 }, { SREF(L"suncacao-rmi"), 11163 }, { SREF(L"suncacao-snmp"), 11161 },
    { SREF(L"suncacao-websvc"), 11165 }, { SREF(L"sunclustergeo"), 2084 }, { SREF(L"sunclustermgr"), 1097 }, { SREF(L"sunfm-port"), 3934 },
    { SREF(L"sunlps-http"), 3816 }, { SREF(L"sunproxyadmin"), 8081 }, { SREF(L"sunrpc"), 111 }, { SREF(L"sunscalar-dns"), 1870 },
    { SREF(L"sunscalar-svc"), 1860 }, { SREF(L"SunVTS-RMI"), 6483 }, { SREF(L"sunwebadmin"), 8800 }, { SREF(L"sunwebadmins"), 8989 },
    { SREF(L"supdup"), 95 }, { SREF(L"supercelSREF(L"), 7967 }, { SREF(L"supermon"), 2709 }, { SREF(L"sur-meas"), 243 },
    { SREF(L"surebox"), 5453 }, { SREF(L"surf"), 1010 }, { SREF(L"surfcontrolcpa"), 3909 }, { SREF(L"surfpass"), 5030 },
    { SREF(L"surveyinst"), 3212 }, { SREF(L"suucp"), 4031 }, { SREF(L"svbackup"), 8405 }, { SREF(L"svcloud"), 8404 },
    { SREF(L"svdrp"), 6419 }, { SREF(L"svdrp-disc"), 6419 }, { SREF(L"svn"), 3690 }, { SREF(L"svnet"), 3413 },
    { SREF(L"svnetworks"), 2973 }, { SREF(L"svrloc"), 427 }, { SREF(L"svs-omagent"), 1625 }, { SREF(L"sw-orion"), 17777 },
    { SREF(L"swa-1"), 9023 }, { SREF(L"swa-2"), 9024 }, { SREF(L"swa-3"), 9025 }, { SREF(L"swa-4"), 9026 },
    { SREF(L"swdtp"), 10104 }, { SREF(L"swdtp-sv"), 10009 }, { SREF(L"sweetware-apps"), 1221 }, { SREF(L"swift-rvf"), 97 },
    { SREF(L"swiftnet"), 1751 }, { SREF(L"swismgr1"), 6963 }, { SREF(L"swismgr2"), 6964 }, { SREF(L"swispoSREF(L"), 6966 },
    { SREF(L"swistrap"), 6965 }, { SREF(L"swldy-sias"), 1250 }, { SREF(L"swr-port"), 3491 }, { SREF(L"swrmi"), 1866 },
    { SREF(L"swtp-port1"), 9281 }, { SREF(L"swtp-port2"), 9282 }, { SREF(L"swx"), 7300 }, { SREF(L"swx"), 7301 },
    { SREF(L"swx"), 7302 }, { SREF(L"swx"), 7303 }, { SREF(L"swx"), 7304 }, { SREF(L"swx"), 7305 },
    { SREF(L"swx"), 7306 }, { SREF(L"swx"), 7307 }, { SREF(L"swx"), 7308 }, { SREF(L"swx"), 7309 },
    { SREF(L"swx"), 7310 }, { SREF(L"swx"), 7311 }, { SREF(L"swx"), 7312 }, { SREF(L"swx"), 7313 },
    { SREF(L"swx"), 7314 }, { SREF(L"swx"), 7315 }, { SREF(L"swx"), 7316 }, { SREF(L"swx"), 7317 },
    { SREF(L"swx"), 7318 }, { SREF(L"swx"), 7319 }, { SREF(L"swx"), 7320 }, { SREF(L"swx"), 7321 },
    { SREF(L"swx"), 7322 }, { SREF(L"swx"), 7323 }, { SREF(L"swx"), 7324 }, { SREF(L"swx"), 7325 },
    { SREF(L"swx"), 7326 }, { SREF(L"swx"), 7327 }, { SREF(L"swx"), 7328 }, { SREF(L"swx"), 7329 },
    { SREF(L"swx"), 7330 }, { SREF(L"swx"), 7331 }, { SREF(L"swx"), 7332 }, { SREF(L"swx"), 7333 },
    { SREF(L"swx"), 7334 }, { SREF(L"swx"), 7335 }, { SREF(L"swx"), 7336 }, { SREF(L"swx"), 7337 },
    { SREF(L"swx"), 7338 }, { SREF(L"swx"), 7339 }, { SREF(L"swx"), 7340 }, { SREF(L"swx"), 7341 },
    { SREF(L"swx"), 7342 }, { SREF(L"swx"), 7343 }, { SREF(L"swx"), 7344 }, { SREF(L"swx"), 7345 },
    { SREF(L"swx"), 7346 }, { SREF(L"swx"), 7347 }, { SREF(L"swx"), 7348 }, { SREF(L"swx"), 7349 },
    { SREF(L"swx"), 7350 }, { SREF(L"swx"), 7351 }, { SREF(L"swx"), 7352 }, { SREF(L"swx"), 7353 },
    { SREF(L"swx"), 7354 }, { SREF(L"swx"), 7355 }, { SREF(L"swx"), 7356 }, { SREF(L"swx"), 7357 },
    { SREF(L"swx"), 7358 }, { SREF(L"swx"), 7359 }, { SREF(L"swx-gate"), 4538 }, { SREF(L"swxadmin"), 5043 },
    { SREF(L"sxmp"), 3273 }, { SREF(L"sxuptp"), 19540 }, { SREF(L"syam-agent"), 3894 }, { SREF(L"syam-smc"), 3895 },
    { SREF(L"syam-webserver"), 3930 }, { SREF(L"sybase-sqlany"), 1498 }, { SREF(L"sybaseanywhere"), 2638 }, { SREF(L"sybasedbsynch"), 2439 },
    { SREF(L"sybasesrvmon"), 4950 }, { SREF(L"sychrond"), 3723 }, { SREF(L"symantec-sfdb"), 5629 }, { SREF(L"symantec-sim"), 3547 },
    { SREF(L"symb-sb-port"), 3923 }, { SREF(L"symplex"), 1507 }, { SREF(L"synapse"), 2880 }, { SREF(L"synapse-nhttp"), 8280 },
    { SREF(L"synapse-nhttps"), 8243 }, { SREF(L"synapsis-edge"), 5008 }, { SREF(L"sync-em7"), 7707 }, { SREF(L"synchromesh"), 4548 },
    { SREF(L"synchronet-db"), 6100 }, { SREF(L"synchronet-rtc"), 6101 }, { SREF(L"synchronet-upd"), 6102 }, { SREF(L"synchronite"), 4106 },
    { SREF(L"syncserver"), 2647 }, { SREF(L"syncserverssSREF(L"), 2679 }, { SREF(L"synctest"), 45045 }, { SREF(L"synel-data"), 3734 },
    { SREF(L"synoptics-trap"), 412 }, { SREF(L"synotics-broker"), 392 }, { SREF(L"synotics-relay"), 391 }, { SREF(L"sype-transport"), 9911 },
    { SREF(L"syscomlan"), 1065 }, { SREF(L"syserverremote"), 6418 }, { SREF(L"sysinfo-sp"), 11967 }, { SREF(L"syslog"), 514 },
    { SREF(L"syslog-conn"), 601 }, { SREF(L"syslog-tls"), 6514 }, { SREF(L"sysopt"), 3281 }, { SREF(L"sysorb"), 3241 },
    { SREF(L"sysrqd"), 4094 }, { SREF(L"sysscanner"), 3251 }, { SREF(L"systat"), 11 }, { SREF(L"system-monitor"), 2609 },
    { SREF(L"systemics-sox"), 5406 }, { SREF(L"t1-e1-over-ip"), 3175 }, { SREF(L"t128-gateway"), 1627 }, { SREF(L"t1distproc"), 1274 },
    { SREF(L"t1distproc60"), 32249 }, { SREF(L"t2-brm"), 7933 }, { SREF(L"t2-drm"), 7932 }, { SREF(L"t5-straton"), 11173 },
    { SREF(L"tabula"), 1437 }, { SREF(L"tacacs"), 49 }, { SREF(L"tacacs-ds"), 65 }, { SREF(L"tacnews"), 98 },
    { SREF(L"tacticalauth"), 2392 }, { SREF(L"taep-as-svc"), 5111 }, { SREF(L"tag-pm"), 5073 }, { SREF(L"tag-ups-1"), 3573 },
    { SREF(L"taiclock"), 4014 }, { SREF(L"tal-pod"), 6149 }, { SREF(L"talarian-mcast1"), 4015 }, { SREF(L"talarian-mcast2"), 4016 },
    { SREF(L"talarian-mcast3"), 4017 }, { SREF(L"talarian-mcast4"), 4018 }, { SREF(L"talarian-mcast5"), 4019 }, { SREF(L"talarian-mqs"), 2493 },
    { SREF(L"talarian-tcp"), 5101 }, { SREF(L"talarian-udp"), 5101 }, { SREF(L"taligent-lm"), 1475 }, { SREF(L"talikaserver"), 22763 },
    { SREF(L"talk"), 517 }, { SREF(L"talnet"), 1838 }, { SREF(L"talon-disc"), 7011 }, { SREF(L"talon-engine"), 7012 },
    { SREF(L"talon-webserver"), 7015 }, { SREF(L"tambora"), 9020 }, { SREF(L"tams"), 2726 }, { SREF(L"tapestry"), 1922 },
    { SREF(L"tapeware"), 3817 }, { SREF(L"tappi-boxnet"), 2306 }, { SREF(L"tarantella"), 3144 }, { SREF(L"targus-getdata"), 5200 },
    { SREF(L"targus-getdata1"), 5201 }, { SREF(L"targus-getdata2"), 5202 }, { SREF(L"targus-getdata3"), 5203 }, { SREF(L"tarp"), 6442 },
    { SREF(L"taserver"), 3552 }, { SREF(L"taskman-port"), 2470 }, { SREF(L"taskmaster2000"), 2402 }, { SREF(L"taskmaster2000"), 2403 },
    { SREF(L"tasp-net"), 25900 }, { SREF(L"taurus-wh"), 1610 }, { SREF(L"tbrpf"), 712 }, { SREF(L"tcc-http"), 24680 },
    { SREF(L"tcim-controSREF(L"), 2729 }, { SREF(L"tclprodebugger"), 2576 }, { SREF(L"tcoaddressbook"), 1977 }, { SREF(L"tcoflashagent"), 1975 },
    { SREF(L"tcoregagent"), 1976 }, { SREF(L"tcp-id-port"), 1999 }, { SREF(L"tcpdataserver"), 3805 }, { SREF(L"tcpmux"), 1 },
    { SREF(L"tcpnethaspsrv"), 475 }, { SREF(L"td-postman"), 1049 }, { SREF(L"td-replica"), 268 }, { SREF(L"td-service"), 267 },
    { SREF(L"tdaccess"), 2910 }, { SREF(L"tdmoip"), 2142 }, { SREF(L"tdp-suite"), 1814 }, { SREF(L"teamcoherence"), 9222 },
    { SREF(L"tec5-sdctp"), 9668 }, { SREF(L"teedtap"), 559 }, { SREF(L"tekpls"), 1946 }, { SREF(L"telaconsole"), 5428 },
    { SREF(L"telefinder"), 1474 }, { SREF(L"telelpathattack"), 5011 }, { SREF(L"telelpathstart"), 5010 }, { SREF(L"teleniumdaemon"), 2060 },
    { SREF(L"telesis-licman"), 1380 }, { SREF(L"telindus"), 1728 }, { SREF(L"telSREF(L"), 754 }, { SREF(L"tellumat-nms"), 3549 },
    { SREF(L"telnet"), 23 }, { SREF(L"telnetcpcd"), 3696 }, { SREF(L"telnets"), 992 }, { SREF(L"telops-lmd"), 7491 },
    { SREF(L"tempest-port"), 11600 }, { SREF(L"tempo"), 526 }, { SREF(L"tenfold"), 658 }, { SREF(L"tentacle"), 41121 },
    { SREF(L"terabase/icq"), 4000 }, { SREF(L"teradataordbms"), 8002 }, { SREF(L"teredo"), 3544 }, { SREF(L"terminaldb"), 2008 },
    { SREF(L"terminaldb"), 2018 }, { SREF(L"tesla-sys-msg"), 7631 }, { SREF(L"tetrinet"), 31457 }, { SREF(L"texai"), 5048 },
    { SREF(L"texar"), 333 }, { SREF(L"tftp"), 69 }, { SREF(L"tftp-mcast"), 1758 }, { SREF(L"tftps"), 3713 },
    { SREF(L"tgcconnect"), 4146 }, { SREF(L"tgp"), 1223 }, { SREF(L"thermo-calc"), 6201 }, { SREF(L"theta-lm"), 2296 },
    { SREF(L"thrp"), 3963 }, { SREF(L"thrtx"), 4139 }, { SREF(L"tht-treasure"), 1832 }, { SREF(L"ticf-1"), 492 },
    { SREF(L"ticf-2"), 493 }, { SREF(L"tick-port"), 3200 }, { SREF(L"tidp"), 7548 }, { SREF(L"tig"), 3943 },
    { SREF(L"tigv2"), 4124 }, { SREF(L"timbuktu"), 407 }, { SREF(L"timbuktu-srv1"), 1417 }, { SREF(L"timbuktu-srv2"), 1418 },
    { SREF(L"timbuktu-srv3"), 1419 }, { SREF(L"timbuktu-srv4"), 1420 }, { SREF(L"time"), 37 }, { SREF(L"timed"), 525 },
    { SREF(L"timeflies"), 1362 }, { SREF(L"timelot"), 3243 }, { SREF(L"timestenbroker"), 3754 }, { SREF(L"tinc"), 655 },
    { SREF(L"tinymessage"), 5104 }, { SREF(L"tip-app-server"), 3160 }, { SREF(L"tip2"), 3372 }, { SREF(L"tipc"), 6118 },
    { SREF(L"tivoconnect"), 2190 }, { SREF(L"tivoli-npm"), 1965 }, { SREF(L"tksocket"), 2915 }, { SREF(L"tl-ipcproxy"), 4176 },
    { SREF(L"tl1"), 2361 }, { SREF(L"tl1-lv"), 3081 }, { SREF(L"tl1-raw"), 3082 }, { SREF(L"tl1-raw-ssSREF(L"), 6251 },
    { SREF(L"tl1-ssh"), 6252 }, { SREF(L"tl1-telnet"), 3083 }, { SREF(L"tlisrv"), 1527 }, { SREF(L"tmesis-upshot"), 2798 },
    { SREF(L"tmi"), 8300 }, { SREF(L"tmo-icon-sync"), 5583 }, { SREF(L"tmophl7mts"), 20046 }, { SREF(L"tmosms0"), 5580 },
    { SREF(L"tmosms1"), 5581 }, { SREF(L"tn-timing"), 2739 }, { SREF(L"tn-tl-fd1"), 476 }, { SREF(L"tn-tl-fd2"), 1584 },
    { SREF(L"tn-tl-r1"), 1580 }, { SREF(L"tn-tl-r2"), 1580 }, { SREF(L"tn-tl-w1"), 474 }, { SREF(L"tn-tl-w2"), 474 },
    { SREF(L"tnETOS"), 377 }, { SREF(L"tnmpv2"), 3686 }, { SREF(L"tnos-dp"), 7902 }, { SREF(L"tnos-dps"), 7903 },
    { SREF(L"tnos-sp"), 7901 }, { SREF(L"tnp"), 8321 }, { SREF(L"tnp-discover"), 8320 }, { SREF(L"tnp1-port"), 4024 },
    { SREF(L"tns-adv"), 3309 }, { SREF(L"tns-cmSREF(L"), 590 }, { SREF(L"tns-server"), 3308 }, { SREF(L"toad"), 2669 },
    { SREF(L"toad-bi-appsrvr"), 8066 }, { SREF(L"tolfab"), 20167 }, { SREF(L"tolteces"), 4375 }, { SREF(L"tomato-springs"), 3040 },
    { SREF(L"tonidods"), 24465 }, { SREF(L"topflow"), 2885 }, { SREF(L"topflow-ssSREF(L"), 3885 }, { SREF(L"topovista-data"), 3906 },
    { SREF(L"topx"), 2436 }, { SREF(L"toruxserver"), 5153 }, { SREF(L"touchnetplus"), 2158 }, { SREF(L"tpcsrvr"), 2078 },
    { SREF(L"tpdu"), 1430 }, { SREF(L"tpip"), 594 }, { SREF(L"tpmd"), 1906 }, { SREF(L"tqdata"), 2700 },
    { SREF(L"tr-rsrb-p1"), 1987 }, { SREF(L"tr-rsrb-p2"), 1988 }, { SREF(L"tr-rsrb-p3"), 1989 }, { SREF(L"tr-rsrb-port"), 1996 },
    { SREF(L"traceroute"), 33434 }, { SREF(L"track"), 20670 }, { SREF(L"tragic"), 2642 }, { SREF(L"traingpsdata"), 9277 },
    { SREF(L"tram"), 4567 }, { SREF(L"transact"), 1869 }, { SREF(L"transmit-port"), 5282 }, { SREF(L"trap"), 4020 },
    { SREF(L"trap-daemon"), 3600 }, { SREF(L"trap-port"), 3857 }, { SREF(L"trap-port-mom"), 3858 }, { SREF(L"traversaSREF(L"), 4678 },
    { SREF(L"travsoft-ipx-t"), 2644 }, { SREF(L"trc-netpolSREF(L"), 2405 }, { SREF(L"treehopper"), 3959 }, { SREF(L"trendchip-dcp"), 3608 },
    { SREF(L"tributary"), 2580 }, { SREF(L"trident-data"), 7727 }, { SREF(L"trim"), 1137 }, { SREF(L"trim-event"), 4322 },
    { SREF(L"trim-ice"), 4323 }, { SREF(L"triomotion"), 3240 }, { SREF(L"trip"), 6069 }, { SREF(L"tripe"), 4070 },
    { SREF(L"tripwire"), 1169 }, { SREF(L"triquest-lm"), 1588 }, { SREF(L"trisoap"), 10200 }, { SREF(L"trispen-sra"), 9555 },
    { SREF(L"tritium-can"), 4876 }, { SREF(L"trivnet1"), 8200 }, { SREF(L"trivnet2"), 8201 }, { SREF(L"trnsprntproxy"), 3346 },
    { SREF(L"troff"), 2014 }, { SREF(L"trp"), 2156 }, { SREF(L"truckstar"), 4725 }, { SREF(L"truecm"), 8804 },
    { SREF(L"trusted-web"), 3011 }, { SREF(L"trustestablish"), 2573 }, { SREF(L"tsa"), 6689 }, { SREF(L"tsaf"), 12753 },
    { SREF(L"tsb"), 2741 }, { SREF(L"tsb2"), 2742 }, { SREF(L"tscchat"), 2330 }, { SREF(L"tsdos390"), 1237 },
    { SREF(L"tserver"), 450 }, { SREF(L"tsilb"), 2489 }, { SREF(L"tsp"), 3653 }, { SREF(L"tsrmagt"), 2077 },
    { SREF(L"tsspmap"), 1568 }, { SREF(L"ttat3lb"), 3579 }, { SREF(L"ttc"), 2483 }, { SREF(L"ttc-etap"), 2675 },
    { SREF(L"ttc-etap-ds"), 2978 }, { SREF(L"ttc-etap-ns"), 2977 }, { SREF(L"ttc-ssSREF(L"), 2484 }, { SREF(L"ttcmremotectrSREF(L"), 3468 },
    { SREF(L"ttg-protocoSREF(L"), 2862 }, { SREF(L"ttl-publisher"), 5462 }, { SREF(L"ttlpriceproxy"), 5463 }, { SREF(L"ttnrepository"), 2943 },
    { SREF(L"ttntspauto"), 3474 }, { SREF(L"ttyinfo"), 2012 }, { SREF(L"tunalyzer"), 5748 }, { SREF(L"tunatic"), 5747 },
    { SREF(L"tungsten-http"), 9762 }, { SREF(L"tungsten-https"), 9443 }, { SREF(L"tunneSREF(L"), 604 }, { SREF(L"tunstall-lwp"), 5197 },
    { SREF(L"tunstall-pnc"), 1846 }, { SREF(L"turbonote-1"), 39681 }, { SREF(L"turbonote-2"), 34249 }, { SREF(L"turn"), 3478 },
    { SREF(L"turns"), 5349 }, { SREF(L"tvbus"), 2191 }, { SREF(L"tvdumtray-port"), 3492 }, { SREF(L"tve-announce"), 2670 },
    { SREF(L"tvnetworkvideo"), 3791 }, { SREF(L"tvpm"), 21800 }, { SREF(L"tw-auth-key"), 27999 }, { SREF(L"twamp-controSREF(L"), 862 },
    { SREF(L"twcss"), 3428 }, { SREF(L"twds"), 8937 }, { SREF(L"twrpc"), 3479 }, { SREF(L"twsdss"), 3012 },
    { SREF(L"u-dbap"), 3584 }, { SREF(L"ua-secureagent"), 19194 }, { SREF(L"uaac"), 145 }, { SREF(L"uacs"), 2768 },
    { SREF(L"uadtc"), 2767 }, { SREF(L"uaiact"), 1470 }, { SREF(L"uarps"), 219 }, { SREF(L"ub-dns-controSREF(L"), 8953 },
    { SREF(L"ubroker"), 7887 }, { SREF(L"ubxd"), 4034 }, { SREF(L"ucentric-ds"), 2879 }, { SREF(L"ucontroSREF(L"), 13894 },
    { SREF(L"udp-sr-port"), 1624 }, { SREF(L"udpradio"), 1833 }, { SREF(L"udrawgraph"), 2542 }, { SREF(L"udrive"), 1867 },
    { SREF(L"udt-os"), 1382 },
    { SREF(L"udt-os"), 3900 }, { SREF(L"uec"), 8778 }, { SREF(L"ufastro-instr"), 3720 }, { SREF(L"ufmp"), 6306 },
    { SREF(L"uis"), 390 }, { SREF(L"ulistproc"), 372 }, { SREF(L"ulp"), 522 }, { SREF(L"ulpnet"), 483 },
    { SREF(L"ultimad"), 1737 }, { SREF(L"ultrabac"), 1910 }, { SREF(L"ultraseek-http"), 8765 }, { SREF(L"ultrex"), 1327 },
    { SREF(L"uma"), 144 }, { SREF(L"uma"), 1797 }, { SREF(L"umm-port"), 3098 }, { SREF(L"ums"), 2248 },
    { SREF(L"umsp"), 2110 }, { SREF(L"unbind-cluster"), 2138 }, { SREF(L"undo-lm"), 5281 }, { SREF(L"unet"), 1189 },
    { SREF(L"unglue"), 2655 }, { SREF(L"unicalSREF(L"), 4343 }, { SREF(L"unicontroSREF(L"), 2437 }, { SREF(L"unicontroSREF(L"), 2499 },
    { SREF(L"unidata-ldm"), 388 }, { SREF(L"unieng"), 5730 }, { SREF(L"unify"), 181 }, { SREF(L"unify-adapter"), 1889 },
    { SREF(L"unify-debug"), 4867 }, { SREF(L"unifyadmin"), 2696 }, { SREF(L"unihub-server"), 2357 }, { SREF(L"unikeypro"), 4127 },
    { SREF(L"unimobilectrSREF(L"), 2927 }, { SREF(L"uniport"), 9629 }, { SREF(L"unisqSREF(L"), 1978 }, { SREF(L"unisql-java"), 1979 },
    { SREF(L"unisys-eportaSREF(L"), 37654 }, { SREF(L"unisys-lm"), 1823 }, { SREF(L"unitary"), 126 }, { SREF(L"unite"), 3217 },
    { SREF(L"univ-appserver"), 1233 }, { SREF(L"universe-suite"), 4184 }, { SREF(L"univision"), 2820 }, { SREF(L"unix-status"), 1957 },
    { SREF(L"unizensus"), 1151 }, { SREF(L"unot"), 5055 }, { SREF(L"uohost"), 3314 }, { SREF(L"uorb"), 3313 },
    { SREF(L"upgrade"), 2537 }, { SREF(L"upnotifyp"), 4445 }, { SREF(L"upnotifyps"), 3356 }, { SREF(L"ups"), 401 },
    { SREF(L"ups-engine"), 3664 }, { SREF(L"ups-onlinet"), 7010 }, { SREF(L"upsnotifyprot"), 2648 }, { SREF(L"upstriggervsw"), 3786 },
    { SREF(L"urbisnet"), 2745 }, { SREF(L"urd"), 465 }, { SREF(L"urld-port"), 3534 }, { SREF(L"urm"), 606 },
    { SREF(L"us-cli"), 8082 }, { SREF(L"us-gv"), 1370 }, { SREF(L"us-srv"), 8083 }, { SREF(L"user-manager"), 3272 },
    { SREF(L"usicontentpush"), 7998 }, { SREF(L"utcd"), 1506 }, { SREF(L"utime"), 519 }, { SREF(L"utmpcd"), 431 },
    { SREF(L"utmpsd"), 430 }, { SREF(L"utsftp"), 2529 }, { SREF(L"uucp"), 540 }, { SREF(L"uucp-path"), 117 },
    { SREF(L"uucp-rlogin"), 541 }, { SREF(L"uuidgen"), 697 }, { SREF(L"v-one-spp"), 3845 }, { SREF(L"v2g-secc"), 15118 },
    { SREF(L"v5ua"), 5675 }, { SREF(L"va-pacbase"), 3676 }, { SREF(L"vacdsm-app"), 671 }, { SREF(L"vacdsm-sws"), 670 },
    { SREF(L"vad"), 14154 }, { SREF(L"valisys-lm"), 1457 }, { SREF(L"vantronix-mgmt"), 8034 }, { SREF(L"vaprtm"), 3654 },
    { SREF(L"varadero-0"), 4837 }, { SREF(L"varadero-1"), 4838 }, { SREF(L"varadero-2"), 4839 }, { SREF(L"vat"), 3456 },
    { SREF(L"vat-controSREF(L"), 3457 }, { SREF(L"vatata"), 4188 }, { SREF(L"vatp"), 690 }, { SREF(L"vaultbase"), 1771 },
    { SREF(L"vce"), 11111 }, { SREF(L"vchat"), 1168 }, { SREF(L"vcmp"), 2426 }, { SREF(L"vcnet-link-v10"), 2554 },
    { SREF(L"vcom-tunneSREF(L"), 8001 }, { SREF(L"vcrp"), 3073 }, { SREF(L"vcs-app"), 14141 }, { SREF(L"vcscmd"), 14150 },
    { SREF(L"vdab"), 1775 }, { SREF(L"vdmplay"), 1707 }, { SREF(L"vemmi"), 575 }, { SREF(L"venus"), 2430 },
    { SREF(L"venus-se"), 2431 }, { SREF(L"veracity"), 1062 }, { SREF(L"vergencecm"), 2771 }, { SREF(L"verismart"), 3270 },
    { SREF(L"veritas-pbx"), 1556 }, { SREF(L"veritas-tcp1"), 2802 }, { SREF(L"veritas-ucSREF(L"), 2148 }, { SREF(L"veritas-udp1"), 2802 },
    { SREF(L"veritas-vis1"), 2993 }, { SREF(L"veritas-vis2"), 2994 }, { SREF(L"veronica"), 2770 }, { SREF(L"versa-tek"), 2610 },
    { SREF(L"versatalk"), 3738 }, { SREF(L"versiera"), 9050 }, { SREF(L"vestasdlp"), 17184 }, { SREF(L"vettcp"), 78 },
    { SREF(L"vfbp"), 6678 }, { SREF(L"vfbp-disc"), 6678 }, { SREF(L"vfmobile"), 5646 }, { SREF(L"vfo"), 1056 },
    { SREF(L"vhd"), 3802 }, { SREF(L"vid"), 769 }, { SREF(L"video-activmaiSREF(L"), 1398 }, { SREF(L"videobeans"), 3058 },
    { SREF(L"videotex"), 516 }, { SREF(L"videte-cipc"), 1927 }, { SREF(L"vidigo"), 3231 }, { SREF(L"vids-avtp"), 1853 },
    { SREF(L"vieo-fe"), 3245 }, { SREF(L"vinainstalSREF(L"), 4344 }, { SREF(L"vipera"), 12012 }, { SREF(L"vipera-ssSREF(L"), 12013 },
    { SREF(L"vipremoteagent"), 3752 }, { SREF(L"virprot-lm"), 7121 }, { SREF(L"virtual-places"), 1533 }, { SREF(L"virtual-time"), 1852 },
    { SREF(L"virtualtape"), 2386 }, { SREF(L"virtualuser"), 5423 }, { SREF(L"visd"), 9284 }, { SREF(L"visicron-vs"), 4307 },
    { SREF(L"visinet-gui"), 3601 }, { SREF(L"vision-elmd"), 6673 }, { SREF(L"vision-server"), 6672 }, { SREF(L"visionpyramid"), 1247 },
    { SREF(L"visitview"), 1631 }, { SREF(L"vista-4gSREF(L"), 24249 }, { SREF(L"vistium-share"), 1545 }, { SREF(L"vitalanalysis"), 2474 },
    { SREF(L"viziblebrowser"), 1868 }, { SREF(L"vlsi-lm"), 1500 }, { SREF(L"vmnet"), 175 }, { SREF(L"vmodem"), 3141 },
    { SREF(L"vmpwscs"), 214 }, { SREF(L"vmrdp"), 2179 }, { SREF(L"vmsvc"), 7024 }, { SREF(L"vmsvc-2"), 7025 },
    { SREF(L"vSphere-fdm"), 8182 }, { SREF(L"vnas"), 577 }, { SREF(L"vnetd"), 13724 }, { SREF(L"vns-tp"), 7802 },
    { SREF(L"vnsstr"), 3321 }, { SREF(L"vnwk-prapi"), 2538 }, { SREF(L"vnyx"), 8699 }, { SREF(L"vocaltec-admin"), 1796 },
    { SREF(L"vocaltec-gold"), 6670 }, { SREF(L"vocaltec-hos"), 25793 }, { SREF(L"vocaltec-phone"), 22555 }, { SREF(L"vocaltec-wconf"), 22555 },
    { SREF(L"vofr-gateway"), 21590 }, { SREF(L"voispeed-port"), 3541 }, { SREF(L"volley"), 3625 }, { SREF(L"vop"), 4433 },
    { SREF(L"vopied"), 13783 }, { SREF(L"voxelstorm"), 28200 }, { SREF(L"vp2p"), 8473 }, { SREF(L"vpa"), 5164 },
    { SREF(L"vpa-disc"), 5164 }, { SREF(L"vpac"), 1517 }, { SREF(L"vpad"), 1516 }, { SREF(L"vpjp"), 1345 },
    { SREF(L"vpm-udp"), 5046 }, { SREF(L"vpnz"), 1224 }, { SREF(L"vpp"), 677 }, { SREF(L"vpps-qua"), 672 },
    { SREF(L"vpps-via"), 676 }, { SREF(L"vpsipport"), 2649 }, { SREF(L"vpvc"), 1519 }, { SREF(L"vpvd"), 1518 },
    { SREF(L"vqp"), 1589 }, { SREF(L"vrace"), 9300 }, { SREF(L"vrcommerce"), 2530 }, { SREF(L"vrml-multi-use"), 4200 },
    { SREF(L"vrml-multi-use"), 4201 }, { SREF(L"vrml-multi-use"), 4202 }, { SREF(L"vrml-multi-use"), 4203 }, { SREF(L"vrml-multi-use"), 4204 },
    { SREF(L"vrml-multi-use"), 4205 }, { SREF(L"vrml-multi-use"), 4206 }, { SREF(L"vrml-multi-use"), 4207 }, { SREF(L"vrml-multi-use"), 4208 },
    { SREF(L"vrml-multi-use"), 4209 }, { SREF(L"vrml-multi-use"), 4210 }, { SREF(L"vrml-multi-use"), 4211 }, { SREF(L"vrml-multi-use"), 4212 },
    { SREF(L"vrml-multi-use"), 4213 }, { SREF(L"vrml-multi-use"), 4214 }, { SREF(L"vrml-multi-use"), 4215 }, { SREF(L"vrml-multi-use"), 4216 },
    { SREF(L"vrml-multi-use"), 4217 }, { SREF(L"vrml-multi-use"), 4218 }, { SREF(L"vrml-multi-use"), 4219 }, { SREF(L"vrml-multi-use"), 4220 },
    { SREF(L"vrml-multi-use"), 4221 }, { SREF(L"vrml-multi-use"), 4222 }, { SREF(L"vrml-multi-use"), 4223 }, { SREF(L"vrml-multi-use"), 4224 },
    { SREF(L"vrml-multi-use"), 4225 }, { SREF(L"vrml-multi-use"), 4226 }, { SREF(L"vrml-multi-use"), 4227 }, { SREF(L"vrml-multi-use"), 4228 },
    { SREF(L"vrml-multi-use"), 4229 }, { SREF(L"vrml-multi-use"), 4230 }, { SREF(L"vrml-multi-use"), 4231 }, { SREF(L"vrml-multi-use"), 4232 },
    { SREF(L"vrml-multi-use"), 4233 }, { SREF(L"vrml-multi-use"), 4234 }, { SREF(L"vrml-multi-use"), 4235 }, { SREF(L"vrml-multi-use"), 4236 },
    { SREF(L"vrml-multi-use"), 4237 }, { SREF(L"vrml-multi-use"), 4238 }, { SREF(L"vrml-multi-use"), 4239 }, { SREF(L"vrml-multi-use"), 4240 },
    { SREF(L"vrml-multi-use"), 4241 }, { SREF(L"vrml-multi-use"), 4242 }, { SREF(L"vrml-multi-use"), 4243 }, { SREF(L"vrml-multi-use"), 4244 },
    { SREF(L"vrml-multi-use"), 4245 }, { SREF(L"vrml-multi-use"), 4246 }, { SREF(L"vrml-multi-use"), 4247 }, { SREF(L"vrml-multi-use"), 4248 },
    { SREF(L"vrml-multi-use"), 4249 }, { SREF(L"vrml-multi-use"), 4250 }, { SREF(L"vrml-multi-use"), 4251 }, { SREF(L"vrml-multi-use"), 4252 },
    { SREF(L"vrml-multi-use"), 4253 }, { SREF(L"vrml-multi-use"), 4254 }, { SREF(L"vrml-multi-use"), 4255 }, { SREF(L"vrml-multi-use"), 4256 },
    { SREF(L"vrml-multi-use"), 4257 }, { SREF(L"vrml-multi-use"), 4258 }, { SREF(L"vrml-multi-use"), 4259 }, { SREF(L"vrml-multi-use"), 4260 },
    { SREF(L"vrml-multi-use"), 4261 }, { SREF(L"vrml-multi-use"), 4262 }, { SREF(L"vrml-multi-use"), 4263 }, { SREF(L"vrml-multi-use"), 4264 },
    { SREF(L"vrml-multi-use"), 4265 }, { SREF(L"vrml-multi-use"), 4266 }, { SREF(L"vrml-multi-use"), 4267 }, { SREF(L"vrml-multi-use"), 4268 },
    { SREF(L"vrml-multi-use"), 4269 }, { SREF(L"vrml-multi-use"), 4270 }, { SREF(L"vrml-multi-use"), 4271 }, { SREF(L"vrml-multi-use"), 4272 },
    { SREF(L"vrml-multi-use"), 4273 }, { SREF(L"vrml-multi-use"), 4274 }, { SREF(L"vrml-multi-use"), 4275 }, { SREF(L"vrml-multi-use"), 4276 },
    { SREF(L"vrml-multi-use"), 4277 }, { SREF(L"vrml-multi-use"), 4278 }, { SREF(L"vrml-multi-use"), 4279 }, { SREF(L"vrml-multi-use"), 4280 },
    { SREF(L"vrml-multi-use"), 4281 }, { SREF(L"vrml-multi-use"), 4282 }, { SREF(L"vrml-multi-use"), 4283 }, { SREF(L"vrml-multi-use"), 4284 },
    { SREF(L"vrml-multi-use"), 4285 }, { SREF(L"vrml-multi-use"), 4286 }, { SREF(L"vrml-multi-use"), 4287 }, { SREF(L"vrml-multi-use"), 4288 },
    { SREF(L"vrml-multi-use"), 4289 }, { SREF(L"vrml-multi-use"), 4290 }, { SREF(L"vrml-multi-use"), 4291 }, { SREF(L"vrml-multi-use"), 4292 },
    { SREF(L"vrml-multi-use"), 4293 }, { SREF(L"vrml-multi-use"), 4294 }, { SREF(L"vrml-multi-use"), 4295 }, { SREF(L"vrml-multi-use"), 4296 },
    { SREF(L"vrml-multi-use"), 4297 }, { SREF(L"vrml-multi-use"), 4298 }, { SREF(L"vrml-multi-use"), 4299 }, { SREF(L"vrpn"), 3883 },
    { SREF(L"vrt"), 4991 }, { SREF(L"vrtl-vmf-ds"), 1956 }, { SREF(L"vrtl-vmf-sa"), 2074 }, { SREF(L"vrtp"), 2255 },
    { SREF(L"vrts-at-port"), 2821 }, { SREF(L"vrts-auth-port"), 4032 }, { SREF(L"vrts-ipcserver"), 1317 }, { SREF(L"vrts-registry"), 2410 },
    { SREF(L"vrts-tdd"), 14149 }, { SREF(L"vrtstrapserver"), 1885 }, { SREF(L"vrxpservman"), 4147 }, { SREF(L"vs-server"), 3280 },
    { SREF(L"vsaiport"), 3317 }, { SREF(L"vsamredirector"), 2387 }, { SREF(L"vsat-controSREF(L"), 1880 }, { SREF(L"vscp"), 9598 },
    { SREF(L"vseconnector"), 2893 }, { SREF(L"vsi-omega"), 7566 }, { SREF(L"vsiadmin"), 2539 }, { SREF(L"vsinet"), 996 },
    { SREF(L"vsixmSREF(L"), 2996 }, { SREF(L"vslmp"), 312 }, { SREF(L"vsnm-agent"), 3375 }, { SREF(L"vspread"), 2695 },
    { SREF(L"vstat"), 7779 }, { SREF(L"vt-ssSREF(L"), 3509 }, { SREF(L"vtp"), 16666 }, { SREF(L"vtr-emulator"), 3122 },
    { SREF(L"vts-rpc"), 5780 }, { SREF(L"vtsas"), 5070 }, { SREF(L"vtu-comms"), 2216 }, { SREF(L"vulture"), 3482 },
    { SREF(L"vvr-controSREF(L"), 4145 }, { SREF(L"vvr-data"), 8199 }, { SREF(L"vx-auth-port"), 3207 }, { SREF(L"vxcrnbuport"), 3652 },
    { SREF(L"vxlan"), 4789 }, { SREF(L"vxlan-gpe"), 4790 }, { SREF(L"vytalvaultbrtp"), 2546 }, { SREF(L"vytalvaultpipe"), 2548 },
    { SREF(L"vytalvaultvsmp"), 2547 }, { SREF(L"waascluster"), 5787 }, { SREF(L"wacp"), 3633 }, { SREF(L"wafs"), 4049 },
    { SREF(L"wag-service"), 2608 }, { SREF(L"wago-io-system"), 2455 }, { SREF(L"wago-service"), 6626 }, { SREF(L"wanscaler"), 2312 },
    { SREF(L"wap-push"), 2948 }, { SREF(L"wap-push-http"), 4035 }, { SREF(L"wap-push-https"), 4036 }, { SREF(L"wap-pushsecure"), 2949 },
    { SREF(L"wap-vcaSREF(L"), 9205 }, { SREF(L"wap-vcal-s"), 9207 }, { SREF(L"wap-vcard"), 9204 }, { SREF(L"wap-vcard-s"), 9206 },
    { SREF(L"wap-wsp"), 9200 }, { SREF(L"wap-wsp-s"), 9202 }, { SREF(L"wap-wsp-wtp"), 9201 }, { SREF(L"wap-wsp-wtp-s"), 9203 },
    { SREF(L"warehouse"), 12322 }, { SREF(L"warehouse-sss"), 12321 }, { SREF(L"warmspotMgmt"), 1074 }, { SREF(L"warmux"), 3826 },
    { SREF(L"watchdoc"), 5744 }, { SREF(L"watchdoc-pod"), 5743 }, { SREF(L"watchdog-nt"), 2723 }, { SREF(L"watchme-7272"), 7272 },
    { SREF(L"watcomdebug"), 3563 }, { SREF(L"watershed-lm"), 6143 }, { SREF(L"watilapp"), 1269 }, { SREF(L"wbem-exp-https"), 5990 },
    { SREF(L"wbem-http"), 5988 }, { SREF(L"wbem-https"), 5989 }, { SREF(L"wbem-rmi"), 5987 }, { SREF(L"wcbackup"), 8912 },
    { SREF(L"wcpp"), 4185 }, { SREF(L"wcr-remlib"), 4845 }, { SREF(L"weandsf"), 48050 }, { SREF(L"weave"), 11095 },
    { SREF(L"web2host"), 1559 }, { SREF(L"webaccess"), 1739 }, { SREF(L"webadmstart"), 1110 }, { SREF(L"webdata"), 3748 },
    { SREF(L"webemshttp"), 2851 }, { SREF(L"weblogin"), 2054 }, { SREF(L"webmachine"), 1963 }, { SREF(L"webmail-2"), 3511 },
    { SREF(L"webmethods-b2b"), 2907 }, { SREF(L"webobjects"), 1085 }, { SREF(L"webphone"), 21845 }, { SREF(L"websm"), 9090 },
    { SREF(L"websphere-snmp"), 3427 }, { SREF(L"webster"), 765 }, { SREF(L"webtie"), 3342 }, { SREF(L"webyast"), 4984 },
    { SREF(L"wello"), 4177 }, { SREF(L"westec-connect"), 5566 }, { SREF(L"westell-stats"), 1875 }, { SREF(L"wfc"), 4847 },
    { SREF(L"wfm"), 4057 }, { SREF(L"wfremotertm"), 1046 }, { SREF(L"wg-netforce"), 3359 }, { SREF(L"wherehoo"), 5859 },
    { SREF(L"whisker"), 3233 }, { SREF(L"who"), 513 }, { SREF(L"whoami"), 565 }, { SREF(L"whois++"), 63 },
    { SREF(L"whoispp"), 63 }, { SREF(L"whosells"), 2781 }, { SREF(L"whosockami"), 2009 }, { SREF(L"whosockami"), 2019 },
    { SREF(L"wibukey"), 22347 }, { SREF(L"wiegand"), 4390 }, { SREF(L"wifree"), 11208 }, { SREF(L"wilkenlistener"), 1890 },
    { SREF(L"willy"), 2518 }, { SREF(L"wimaxasncp"), 2231 }, { SREF(L"wimd"), 2980 }, { SREF(L"wimsic"), 1326 },
    { SREF(L"windb"), 2522 }, { SREF(L"winddlb"), 1565 }, { SREF(L"winddx"), 1727 }, { SREF(L"windlm"), 1785 },
    { SREF(L"windream"), 534 }, { SREF(L"winfs"), 5009 }, { SREF(L"wininstall-ipc"), 3674 }, { SREF(L"winjaserver"), 1290 },
    { SREF(L"winpcs"), 5166 }, { SREF(L"winpharaoh"), 6065 }, { SREF(L"winpoplanmess"), 1152 }, { SREF(L"winport"), 3926 },
    { SREF(L"winqedit"), 7395 }, { SREF(L"winrm"), 47001 }, { SREF(L"wins"), 1512 }, { SREF(L"winshadow"), 3261 },
    { SREF(L"winshadow-hd"), 3861 }, { SREF(L"wip-port"), 3414 }, { SREF(L"wired"), 4871 }, { SREF(L"wizard"), 2001 },
    { SREF(L"wkars"), 2720 }, { SREF(L"wkstn-mon"), 2991 }, { SREF(L"wlanauth"), 3810 }, { SREF(L"wlbs"), 2504 },
    { SREF(L"wlcp"), 36411 }, { SREF(L"wmc-log-svc"), 1338 }, { SREF(L"wmedistribution"), 11998 }, { SREF(L"wmereceiving"), 11997 },
    { SREF(L"wmereporting"), 11999 }, { SREF(L"wmlserver"), 4883 }, { SREF(L"wms-messenger"), 3219 }, { SREF(L"wnn6"), 22273 },
    { SREF(L"wnn6-ds"), 26208 }, { SREF(L"workflow"), 3466 }, { SREF(L"world-lm"), 1462 }, { SREF(L"worldfusion1"), 2595 },
    { SREF(L"worldfusion2"), 2596 }, { SREF(L"worldscores"), 4545 }, { SREF(L"wpages"), 776 }, { SREF(L"wpgs"), 780 },
    { SREF(L"writesrv"), 1334 }, { SREF(L"wrs-registry"), 2340 }, { SREF(L"wrspice"), 6114 }, { SREF(L"ws-discovery"), 3702 },
    { SREF(L"wsdapi"), 5357 }, { SREF(L"wsdapi-s"), 5358 }, { SREF(L"wsdl-event"), 4879 }, { SREF(L"wsicopy"), 3378 },
    { SREF(L"wsm-server"), 5006 }, { SREF(L"wsm-server-ssSREF(L"), 5007 }, { SREF(L"wsman"), 5985 }, { SREF(L"wsmans"), 5986 },
    { SREF(L"wsmlb"), 3806 }, { SREF(L"wso2esb-console"), 9444 }, { SREF(L"wspipe"), 4431 }, { SREF(L"wssauthsvc"), 4537 },
    { SREF(L"wsscomfrmwk"), 6602 }, { SREF(L"wsynch"), 3111 }, { SREF(L"wta-wsp-s"), 2805 }, { SREF(L"wta-wsp-wtp-s"), 2923 },
    { SREF(L"wusage"), 2396 }, { SREF(L"wv-csp-sms"), 3590 }, { SREF(L"wv-csp-sms-cir"), 3716 }, { SREF(L"wv-csp-udp-cir"), 3717 },
    { SREF(L"wwiotalk"), 5413 }, { SREF(L"www"), 80 }, { SREF(L"www-dev"), 2784 }, { SREF(L"www-http"), 80 },
    { SREF(L"www-ldap-gw"), 1760 }, { SREF(L"wxbrief"), 4368 }, { SREF(L"wysdma"), 3741 }, { SREF(L"wysdmc"), 3916 },
    { SREF(L"x-bone-api"), 2165 }, { SREF(L"x-bone-ctSREF(L"), 265 }, { SREF(L"x11"), 6001 }, { SREF(L"x11"), 6002 },
    { SREF(L"x11"), 6003 }, { SREF(L"x11"), 6004 }, { SREF(L"x11"), 6005 }, { SREF(L"x11"), 6006 },
    { SREF(L"x11"), 6007 }, { SREF(L"x11"), 6008 }, { SREF(L"x11"), 6009 }, { SREF(L"x11"), 6010 },
    { SREF(L"x11"), 6011 }, { SREF(L"x11"), 6012 }, { SREF(L"x11"), 6013 }, { SREF(L"x11"), 6014 },
    { SREF(L"x11"), 6015 }, { SREF(L"x11"), 6016 }, { SREF(L"x11"), 6017 }, { SREF(L"x11"), 6018 },
    { SREF(L"x11"), 6019 }, { SREF(L"x11"), 6020 }, { SREF(L"x11"), 6021 }, { SREF(L"x11"), 6022 },
    { SREF(L"x11"), 6023 }, { SREF(L"x11"), 6024 }, { SREF(L"x11"), 6025 }, { SREF(L"x11"), 6026 },
    { SREF(L"x11"), 6027 }, { SREF(L"x11"), 6028 }, { SREF(L"x11"), 6029 }, { SREF(L"x11"), 6030 },
    { SREF(L"x11"), 6031 }, { SREF(L"x11"), 6032 }, { SREF(L"x11"), 6033 }, { SREF(L"x11"), 6034 },
    { SREF(L"x11"), 6035 }, { SREF(L"x11"), 6036 }, { SREF(L"x11"), 6037 }, { SREF(L"x11"), 6038 },
    { SREF(L"x11"), 6039 }, { SREF(L"x11"), 6040 }, { SREF(L"x11"), 6041 }, { SREF(L"x11"), 6042 },
    { SREF(L"x11"), 6043 }, { SREF(L"x11"), 6044 }, { SREF(L"x11"), 6045 }, { SREF(L"x11"), 6046 },
    { SREF(L"x11"), 6047 }, { SREF(L"x11"), 6048 }, { SREF(L"x11"), 6049 }, { SREF(L"x11"), 6050 },
    { SREF(L"x11"), 6060 }, { SREF(L"x11"), 6061 }, { SREF(L"x11"), 6062 }, { SREF(L"x11"), 6063 },
    { SREF(L"x2-controSREF(L"), 36422 }, { SREF(L"x25-svc-port"), 1998 }, { SREF(L"x2e-disc"), 11877 }, { SREF(L"x500ms"), 5757 },
    { SREF(L"x9-icue"), 1145 }, { SREF(L"xaapi"), 1934 }, { SREF(L"xact-backup"), 911 }, { SREF(L"xadmin"), 9105 },
    { SREF(L"xandros-cms"), 4389 }, { SREF(L"xap-ha"), 3639 }, { SREF(L"xbox"), 3074 }, { SREF(L"xdas"), 7629 },
    { SREF(L"xdmcp"), 177 }, { SREF(L"xds"), 2130 }, { SREF(L"xdsxdm"), 6558 }, { SREF(L"xdtp"), 3088 },
    { SREF(L"xecp-node"), 3940 }, { SREF(L"xfer"), 82 }, { SREF(L"xfr"), 682 }, { SREF(L"xgrid"), 4111 },
    { SREF(L"xic"), 6115 }, { SREF(L"xiip"), 1924 }, { SREF(L"xingcsm"), 2327 }, { SREF(L"xingmpeg"), 1558 },
    { SREF(L"xinuexpansion1"), 2021 }, { SREF(L"xinuexpansion2"), 2022 }, { SREF(L"xinuexpansion3"), 2023 }, { SREF(L"xinuexpansion4"), 2024 },
    { SREF(L"xinupageserver"), 2020 }, { SREF(L"xiostatus"), 2341 }, { SREF(L"xkotodrcp"), 5344 }, { SREF(L"xmapi"), 1933 },
    { SREF(L"xmcp"), 4788 }, { SREF(L"xmlblaster"), 3412 }, { SREF(L"xmlink-connect"), 3953 }, { SREF(L"XmlIpcRegSvc"), 9092 },
    { SREF(L"xmlrpc-beep"), 602 }, { SREF(L"xmltec-xmlmaiSREF(L"), 9091 }, { SREF(L"xmms2"), 9667 }, { SREF(L"xmpcr-interface"), 3877 },
    { SREF(L"xmpp-bosh"), 5280 }, { SREF(L"xmpp-client"), 5222 }, { SREF(L"xmpp-server"), 5269 }, { SREF(L"xmpv7"), 7430 },
    { SREF(L"xmquery"), 2279 }, { SREF(L"xmsg"), 1716 }, { SREF(L"xnds"), 2157 }, { SREF(L"xnm-clear-text"), 3221 },
    { SREF(L"xnm-ssSREF(L"), 3220 }, { SREF(L"xnmp"), 1652 }, { SREF(L"xns-auth"), 56 }, { SREF(L"xns-ch"), 54 },
    { SREF(L"xns-courier"), 165 }, { SREF(L"xns-maiSREF(L"), 58 }, { SREF(L"xns-time"), 52 }, { SREF(L"xo-wave"), 3763 },
    { SREF(L"xoms"), 16619 }, { SREF(L"xoraya"), 11876 }, { SREF(L"xpaneSREF(L"), 3737 }, { SREF(L"xpilot"), 15345 },
    { SREF(L"xpSREF(L"), 3865 }, { SREF(L"xprint-server"), 8100 }, { SREF(L"xprtld"), 5634 }, { SREF(L"xqosd"), 31416 },
    { SREF(L"xribs"), 2025 }, { SREF(L"xrSREF(L"), 1104 }, { SREF(L"xrpc-registry"), 3651 }, { SREF(L"xs-openstorage"), 1619 },
    { SREF(L"xserveraid"), 3722 }, { SREF(L"XSIP-network"), 1354 }, { SREF(L"xsmsvc"), 6936 }, { SREF(L"xss-port"), 3510 },
    { SREF(L"xss-srv-port"), 3646 }, { SREF(L"xsync"), 3721 }, { SREF(L"xtgui"), 4095 }, { SREF(L"xtlserv"), 6116 },
    { SREF(L"xtreamx"), 5793 }, { SREF(L"xtrm"), 3423 }, { SREF(L"xtrms"), 3424 }, { SREF(L"xvttp"), 508 },
    { SREF(L"xxnetserver"), 3832 }, { SREF(L"xybrid-cloud"), 9925 }, { SREF(L"xybrid-rt"), 9978 }, { SREF(L"xyplex-mux"), 173 },
    { SREF(L"yawn"), 31029 }, { SREF(L"yo-main"), 4040 }, { SREF(L"z-wave"), 4123 }, { SREF(L"z-wave-s"), 44123 },
    { SREF(L"z39-50"), 210 }, { SREF(L"zabbix-agent"), 10050 }, { SREF(L"zabbix-trapper"), 10051 }, { SREF(L"zannet"), 317 }, { SREF(L"zarkov"), 2989 },
    { SREF(L"zen-pawn"), 7628 }, { SREF(L"zenginkyo-1"), 5020 }, { SREF(L"zenginkyo-2"), 5021 }, { SREF(L"zented"), 1229 },
    { SREF(L"zep"), 17754 }, { SREF(L"zephyr-clt"), 2103 }, { SREF(L"zephyr-hm"), 2104 }, { SREF(L"zephyr-srv"), 2102 },
    { SREF(L"zicom"), 3774 }, { SREF(L"zieto-sock"), 4072 }, { SREF(L"zigbee-ip"), 17755 }, { SREF(L"zigbee-ips"), 17756 },
    { SREF(L"zion-lm"), 1425 }, { SREF(L"zmp"), 3925 }, { SREF(L"zoomcp"), 9666 }, { SREF(L"zre-disc"), 5670 },
    { SREF(L"zsecure"), 7173 }, { SREF(L"zserv"), 346 }, { SREF(L"zymed-zpp"), 2133 }
};

_Success_(return)
BOOLEAN LookupPortServiceName(
    _In_ ULONG Port,
    _Out_ PPH_STRINGREF* ServiceName
    )
{
    static PPH_HASHTABLE PortServiceHashtable = NULL;

    if (!PortServiceHashtable)
    {
        PortServiceHashtable = PhCreateSimpleHashtable(RTL_NUMBER_OF(ResolvedPortsTable));

        for (UINT i = 0; i < RTL_NUMBER_OF(ResolvedPortsTable); i++)
        {
            PhAddItemSimpleHashtable(PortServiceHashtable, UlongToPtr(ResolvedPortsTable[i].Port), ResolvedPortsTable[i].Name);
        }
    }

    if (PortServiceHashtable)
    {
        PPH_STRINGREF name;

        if (name = PhFindItemSimpleHashtable2(PortServiceHashtable, UlongToPtr(Port)))
        {
            *ServiceName = name;
            return TRUE;
        }
    }

    return FALSE;
}
