/*
 * Copyright (c) 2022 Winsider Seminars & Solutions, Inc.  All rights reserved.
 *
 * This file is part of System Informer.
 *
 * Authors:
 *
 *     dmex    2016-2022
 *
 */

#ifndef EFI_GUIDS_H
#define EFI_GUIDS_H

struct _EFI_GUID_TABLE
{
    PCWSTR Name;
    const GUID Guid;
} const table[] =
{
    // dmex: 77fa9abd-0359-4d32-bd60-28f4e78f784b
    { L"EFI_WINNT_OS", { 0x77fa9abd, 0x0359, 0x4d32, { 0xbd, 0x60, 0x28, 0xf4, 0xe7, 0x8f, 0x78, 0x4b } } },
    // dmex: ba57e015-65b3-4c3c-b274-659192f699e3
    { L"EFI_WINNT_WHEA", { 0xba57e015, 0x65b3, 0x4c3c, { 0xb2, 0x74, 0x65, 0x91, 0x92, 0xf6, 0x99, 0xe3 } } },
    // dmex: 1801FBE3-AEF7-42A8-B1CD-FC4AFAE14716
    { L"EFI_TESTING_GUID", { 0x1801FBE3, 0xAEF7, 0x42A8, { 0xB1, 0xCD, 0xFC, 0x4A, 0xFA, 0xE1, 0x47, 0x16 } } },
    // dmex: D2E0B9C9-9860-42CF-B360-F906D5E0077A
    { L"EFI_SURFACE_GUID", { 0xD2E0B9C9, 0x9860, 0x42CF, { 0xB3, 0x60, 0xF9, 0x06, 0xD5, 0xE0, 0x07, 0x7A } } },

    // https://raw.githubusercontent.com/mazzoo/efiguid/master/efi_guid_list.h
    { L"ACOUSTIC_SETUP_PROTOCOL_GUID",                                        { 0xc1d7859d, 0x5719, 0x46c3, { 0xa2, 0x98, 0xd0, 0x71, 0xe3, 0x02, 0x64, 0xd1 } } },
    { L"ADD_BOOT_OPTION_GUID",                                                { 0x19d96d3f, 0x6a6a, 0x47d2, { 0xb1, 0x95, 0x7b, 0x24, 0x32, 0xda, 0x3b, 0xe2 } } },
    { L"ADVANCED_FORM_SET_GUID",                                              { 0xe14f04fa, 0x8706, 0x4353, { 0x92, 0xf2, 0x9c, 0x24, 0x24, 0x74, 0x6f, 0x9f } } },
    { L"AHCI_BUS_INIT_PROTOCOL_GUID",                                         { 0xb2fa4764, 0x3b6e, 0x43d3, { 0x91, 0xdf, 0x87, 0xd1, 0x5a, 0x3e, 0x56, 0x68 } } },
    { L"AHCI_SMM_PROTOCOL_GUID",                                              { 0xb2fa5764, 0x3b6e, 0x43d3, { 0x91, 0xdf, 0x87, 0xd1, 0x5a, 0x3e, 0x56, 0x68 } } },
    { L"AMI_APTIO_SIG_OWNER_GUID",                                            { 0x26dc4851, 0x195f, 0x4ae1, { 0x9a, 0x19, 0xfb, 0xf8, 0x83, 0xbb, 0xb3, 0x5e } } },
    { L"AMI_BBS_DEVICE_PATH_GUID",                                            { 0x1db184ae, 0x81f5, 0x4e72, { 0x85, 0x44, 0x2b, 0xab, 0x0c, 0x2c, 0xac, 0x5c } } },
    { L"AMI_BEFORE_CPU_RC_PROTOCOL_GUID",                                     { 0x1d26adc3, 0xb011, 0xee2c, { 0x21, 0x77, 0x89, 0xbb, 0xaa, 0xcc, 0x33, 0x92 } } },
    { L"AMI_BIOSPPI_FLAGS_MANAGEMENT_GUID",                                   { 0xe9008d70, 0x2a4e, 0x47ea, { 0x8e, 0xc4, 0x72, 0xe2, 0x57, 0x67, 0xe5, 0xef } } },
    { L"AMI_BOARD_INFO_PROTOCOL_GUID",                                        { 0x0273146c, 0x96c4, 0x45a1, { 0xa7, 0xaf, 0x78, 0xe0, 0x52, 0x4a, 0x0a, 0xe2 } } },
    { L"AMI_BOARD_INFO_SECTION_GUID",                                         { 0xe6f4f8f7, 0x4992, 0x47b2, { 0x83, 0x02, 0x85, 0x08, 0x74, 0x5e, 0x4a, 0x23 } } },
    { L"AMI_CALLBACK_GUID",                                                   { 0x9cf0f18e, 0x7c7d, 0x49de, { 0xb5, 0xaa, 0xbb, 0xba, 0xd6, 0xb2, 0x10, 0x07 } } },
    { L"AMI_CAPSULE_HOB_GUID",                                                { 0xbf66fdf7, 0xf64c, 0x4b11, { 0x8a, 0xb7, 0xf8, 0x43, 0xaa, 0x2a, 0x8b, 0xea } } },
    { L"AMI_CCID_IO_PROTOCOL_GUID",                                           { 0xb167c2f5, 0xe26a, 0x4dff, { 0x8e, 0x1c, 0x08, 0x07, 0xc7, 0xf0, 0x2a, 0x88 } } },
    { L"AMI_CCID_PRESENCE_GUID",                                              { 0x5fdee00d, 0xda40, 0x405a, { 0xb9, 0x2e, 0xcf, 0x4a, 0x80, 0xea, 0x8f, 0x76 } } },
    { L"AMI_CMOS_BAD_FLAG_HOB_GUID",                                          { 0xb098f766, 0xb17a, 0x4005, { 0x83, 0x09, 0xeb, 0x23, 0xf1, 0x44, 0x8c, 0x15 } } },
    { L"AMI_CPUID_CKSUM_HOB_GUID",                                            { 0xd4ca32b1, 0xb1f2, 0x4ff3, { 0xb4, 0x75, 0x66, 0xe7, 0xb8, 0x19, 0x2a, 0x3b } } },
    { L"AMI_CPU_INFO_2_PROTOCOL_GUID",                                        { 0xac9cf0a8, 0xe551, 0x4be2, { 0xad, 0x0a, 0xe1, 0xb5, 0x64, 0xee, 0xa2, 0x73 } } },
    { L"AMI_CSM_DRIVER_STARTED_GUID",                                         { 0x3ea824d1, 0x81e3, 0x4ff5, { 0xbd, 0x43, 0xbb, 0x9c, 0x65, 0xdf, 0x7c, 0x46 } } },
    { L"AMICSM_PCIBUSNUM_XLAT_PROTOCOL_GUID",                                 { 0xcb5c54c0, 0x230d, 0x43db, { 0x92, 0x2c, 0x24, 0xd3, 0x4f, 0x8c, 0x91, 0x5c } } },
    { L"AMI_CSM_THUNK_PROTOCOL_GUID",                                         { 0x2362ea9c, 0x84e5, 0x4dff, { 0x83, 0xbc, 0xb5, 0xac, 0xec, 0xb5, 0x7c, 0xbb } } },
    { L"AMI_DDDT_PRESENT_FLAG_HOB_GUID",                                      { 0x4e7af417, 0xc200, 0x400a, { 0x9d, 0x18, 0x86, 0x5a, 0xda, 0xd3, 0x08, 0x96 } } },
    { L"AMI_DEBUGGER_CPU_PROTOCOL_GUID",                                      { 0xab21acc3, 0xba33, 0xee2c, { 0x66, 0xbc, 0x12, 0x56, 0x77, 0x11, 0x1a, 0xb2 } } },
    { L"AMI_DEBUGPORT_HOB_GUID",                                              { 0xe894b313, 0x54ca, 0x4bb2, { 0x8c, 0xdd, 0x85, 0x1e, 0x8a, 0xc9, 0x02, 0x7c } } },
    { L"AMI_DEVICE_NAME_DEVICE_PATH_GUID",                                    { 0x2d6447ef, 0x3bc9, 0x41a0, { 0xac, 0x19, 0x4d, 0x51, 0xd0, 0x1b, 0x4c, 0xe6 } } },
    { L"AMI_DIGITAL_SIGNATURE_PROTOCOL_GUID",                                 { 0x5f87ba17, 0x957d, 0x433d, { 0x9e, 0x15, 0xc0, 0xe7, 0xc8, 0x79, 0x88, 0x99 } } },
    { L"AMI_DIMM_SPD_DATA_HOB_GUID",                                          { 0xd4ca32b3, 0xb1fe, 0x4ff7, { 0xb0, 0x73, 0x60, 0xed, 0xbb, 0x16, 0x22, 0x33 } } },
    { L"AMI_EARLY_BIST_PPI_GUID",                                             { 0xa7e2ce72, 0xdc32, 0x4bc0, { 0x9e, 0x35, 0xfe, 0xb3, 0x0a, 0xe5, 0xcc, 0x47 } } },
    { L"AMI_EFIKEYCODE_PROTOCOL_GUID",                                        { 0x0adfb62d, 0xff74, 0x484c, { 0x89, 0x44, 0xf8, 0x5c, 0x4b, 0xea, 0x87, 0xa8 } } },
    { L"AMI_FAST_BOOT_PROTOCOL_GUID",                                         { 0x3496a19a, 0x2e99, 0x41ba, { 0x83, 0x3e, 0x0f, 0xde, 0x2e, 0xbf, 0x2a, 0x55 } } },
    { L"AMI_FW_RECOVERY_CAPSULE_GUID",                                        { 0x5e794317, 0xa07e, 0x45df, { 0x94, 0xbb, 0x1c, 0x99, 0x7d, 0x62, 0x32, 0xca } } },
    { L"AMI_HECI_SMM_GUID",                                                   { 0xfc9a50c1, 0x8b3d, 0x40d0, { 0x99, 0x12, 0x6e, 0x26, 0xd7, 0x89, 0x6c, 0xba } } },
    { L"AMI_INTERNAL_FACTORY_TDC_TDP_HOB_GUID",                               { 0x982d8c6f, 0xf6f6, 0x4135, { 0xa3, 0x09, 0xa4, 0x59, 0x3e, 0xa5, 0x64, 0x17 } } },
    { L"AMI_INTERNAL_UCODE_HOB_GUID",                                         { 0x94567c6f, 0xf7a9, 0x4229, { 0x13, 0x30, 0xfe, 0x11, 0xcc, 0xab, 0x3a, 0x11 } } },
    { L"AMI_INT_SMM_COMM_PROTOCOL_GUID",                                      { 0xb27dab38, 0x9814, 0x4e06, { 0xa5, 0xa2, 0x65, 0xae, 0x9a, 0x14, 0x25, 0x8f } } },
    { L"AMI_IRQ_DMA_MASK_VARIABLE_GUID",                                      { 0xfc8be767, 0x89f1, 0x4d6e, { 0x80, 0x99, 0x6f, 0x02, 0x1e, 0xbc, 0x87, 0xcc } } },
    { L"AMI_ISO9660_MEDIA_GUID",                                              { 0xba7c46d1, 0x9c5e, 0x4fc8, { 0x94, 0x3d, 0x1a, 0x49, 0x1f, 0x23, 0xfe, 0x01 } } },
    { L"AMI_LOAD_CSM_GUID",                                                   { 0x16287ba4, 0x5b9d, 0x4d98, { 0x91, 0x9f, 0x7b, 0x7b, 0x78, 0xcb, 0x2b, 0xe0 } } },
    { L"AMI_MASKED_DEVICE_PATH_GUID",                                         { 0x99e275e7, 0x75a0, 0x4b37, { 0xa2, 0xe6, 0xc5, 0x38, 0x5e, 0x6c, 0x00, 0xcb } } },
    { L"AMI_MEASURE_PCIOPROM_GUID",                                           { 0xb3dae700, 0x2a77, 0x4ea4, { 0xaf, 0x79, 0x32, 0x97, 0xb4, 0x84, 0xbe, 0x61 } } },
    { L"AMI_MEDIA_DEVICE_PATH_GUID",                                          { 0x5023b95c, 0xdb26, 0x429b, { 0xa6, 0x48, 0xbd, 0x47, 0x66, 0x4c, 0x80, 0x12 } } },
    { L"AMI_MEMORY_ERROR_REPORT_PPI_GUID",                                    { 0x85226559, 0x0def, 0x48d8, { 0xa8, 0xc9, 0xb7, 0x46, 0xd6, 0xa4, 0xdf, 0x01 } } },
    { L"AMI_MRC_INFO_HOB_GUID",                                               { 0xa6351a87, 0x2965, 0x4718, { 0x88, 0xc7, 0x0b, 0x5b, 0x5a, 0xc0, 0xb5, 0xe4 } } },
    { L"AMI_NB_MRC_INFO_GUID",                                                { 0x6737934b, 0xa27e, 0x4c05, { 0xad, 0x5b, 0x6a, 0xb8, 0x62, 0x73, 0x68, 0x0b } } },
    { L"AMI_NVRAM_SPD_MAP_GUID",                                              { 0x717fc150, 0xabd9, 0x4614, { 0x80, 0x15, 0x0b, 0x33, 0x23, 0xea, 0xb9, 0x5c } } },
    { L"AMI_OPROM_POLICY_PROTOCOL_GUID",                                      { 0x542d6248, 0x4198, 0x4960, { 0x9f, 0x59, 0x23, 0x84, 0x64, 0x6d, 0x63, 0xb4 } } },
    { L"AMI_OS_PPI_CONFIRMATION_OVERRIDE_GUID",                               { 0x5f171f5f, 0x8385, 0x4086, { 0xa6, 0x9b, 0x1f, 0xcf, 0x06, 0xae, 0x4a, 0x3d } } },
    { L"AMI_PB_KEY_RSA2048_GUID",                                             { 0x04627b9b, 0x385e, 0x4744, { 0x90, 0x21, 0xe6, 0x63, 0x19, 0xf2, 0x03, 0x94 } } },
    { L"AMI_PCI_BUS_EXT_PROTOCOL_GUID",                                       { 0xf42a009d, 0x977f, 0x4f08, { 0x94, 0x40, 0xbc, 0xa5, 0xa3, 0xbe, 0xd9, 0xaf } } },
    { L"AMI_PEI_AFTER_MRC_GUID",                                              { 0x64c96700, 0x6b4c, 0x480c, { 0xa3, 0xe1, 0xb8, 0xbd, 0xe8, 0xf6, 0x02, 0xb2 } } },
    { L"AMI_PEI_CPUINIT_POLICY_PPI_GUID",                                     { 0xf824ccbb, 0xd8e0, 0x4522, { 0x8a, 0xa8, 0x65, 0xf0, 0x4b, 0x46, 0x3d, 0xb5 } } },
    { L"AMI_PEI_END_MEMORY_DETECT_GUID",                                      { 0x9f58e424, 0xb96b, 0x45a5, { 0xad, 0xdc, 0xd2, 0xfe, 0x39, 0x4a, 0x99, 0xd9 } } },
    { L"AMI_PEI_END_OF_MRC_GUID",                                             { 0x633194be, 0x1697, 0x11e1, { 0xb5, 0xf0, 0x2c, 0xb2, 0x48, 0x24, 0x01, 0x9b } } },
    { L"AMI_PEIM_HOB_GUID",                                                   { 0xf4491ba4, 0x7672, 0x486f, { 0xb4, 0xd7, 0x99, 0x89, 0x9d, 0x22, 0xda, 0x57 } } },
    { L"AMI_PEIM_LOAD_HOB_GUID",                                              { 0xec9c36fd, 0x1642, 0x4b84, { 0x91, 0xfa, 0x91, 0x9c, 0x2d, 0x06, 0x6f, 0xb4 } } },
    { L"AMI_PEI_MRC_DEFAULT_GUID",                                            { 0xe813e116, 0xc099, 0x4d21, { 0x9c, 0x34, 0xa5, 0x52, 0xd5, 0xe9, 0xa5, 0xd0 } } },
    { L"AMI_PEI_NB_CPU_ONLY_RESET_PPI_GUID",                                  { 0x1f0f049e, 0x3a68, 0x4c97, { 0x86, 0x5a, 0xbc, 0x5e, 0xed, 0x79, 0x20, 0xe7 } } },
    { L"AMI_PEI_NB_CUSTOM_PPI_GUID",                                          { 0x584cc99f, 0x4be8, 0x43d1, { 0xa4, 0x5a, 0x93, 0x3d, 0xc3, 0x94, 0x79, 0xfc } } },
    { L"AMI_PEI_NBINIT_POLICY_PPI_GUID",                                      { 0x9ce4d938, 0x9c87, 0x41d0, { 0x9e, 0x55, 0x34, 0x92, 0x3f, 0xaf, 0x8b, 0x4f } } },
    { L"AMI_PEI_PCI_TABLE_INIT_PPI_GUID",                                     { 0x97f91e78, 0xea12, 0x4ea6, { 0xb7, 0xb3, 0x7b, 0x06, 0x78, 0xc2, 0x86, 0x73 } } },
    { L"AMI_PEI_SB_CUSTOM_PPI_GUID",                                          { 0x38965bb5, 0x8097, 0x40f5, { 0xb7, 0x42, 0x8c, 0xc1, 0x4a, 0x64, 0x9b, 0x64 } } },
    { L"AMI_PEI_SBINIT_POLICY_PPI_GUID",                                      { 0x95e8152b, 0x1b98, 0x4f11, { 0x8a, 0x77, 0xdb, 0x26, 0x58, 0x3e, 0xbc, 0x42 } } },
    { L"AMI_PEI_SB_OEM_PLATFORM_POLICY_OVERRIDE_PPI_GUID",                    { 0x61187967, 0x9a77, 0x419d, { 0xaa, 0xea, 0x64, 0xdd, 0x56, 0x19, 0x08, 0x15 } } },
    { L"AMI_PEI_SET_NB_SUBID_PPI_GUID",                                       { 0x584cc99f, 0x4be8, 0x43d1, { 0xa4, 0x5a, 0x93, 0x3d, 0xc3, 0x94, 0x79, 0xfc } } },
    { L"AMI_PERF_TUNE_DATA_HOB_GUID",                                         { 0x4d6c0496, 0x8de4, 0x4af2, { 0x9a, 0x2e, 0x9b, 0xe5, 0xb9, 0x15, 0x6a, 0xc5 } } },
    { L"AMI_PLL_OVER_VOTAGE_FLAG_HOB_GUID",                                   { 0x181e874d, 0xc089, 0x4c99, { 0x8e, 0xc2, 0x6d, 0x67, 0x61, 0x34, 0x82, 0x20 } } },
    { L"AMI_POST_MANAGER_PROTOCOL_GUID",                                      { 0x8a91b1e1, 0x56c7, 0x4adc, { 0xab, 0xeb, 0x1c, 0x2c, 0xa1, 0x72, 0x9e, 0xff } } },
    { L"AMI_RECOVERY_IMAGE_HOB_GUID",                                         { 0xdac3cb98, 0x2295, 0x412e, { 0x82, 0x6d, 0xfd, 0xee, 0xa3, 0x20, 0xcf, 0x31 } } },
    { L"AMI_RESET_TYPE_HOB_GUID",                                             { 0x39e8cda1, 0x6a35, 0x4cdd, { 0xa9, 0x02, 0xd1, 0xa7, 0x95, 0xf7, 0x03, 0x80 } } },
    { L"AMI_RESET_TYPE_VARIABLE_GUID",                                        { 0x308dd02c, 0x092b, 0x4123, { 0xa2, 0xaf, 0x3e, 0xf4, 0x44, 0x0a, 0x6b, 0x4a } } },
    { L"AMI_ROM_LAYOUT_HOB_GUID",                                             { 0xd7642443, 0x87b7, 0x4832, { 0x96, 0x07, 0x0e, 0x1e, 0xa8, 0x1c, 0x1d, 0x86 } } },
    { L"AMI_SB_SMI_PROTOCOL_GUID",                                            { 0x589bc616, 0xbb4f, 0x47ed, { 0x92, 0xf7, 0x93, 0x39, 0x3c, 0x69, 0x7e, 0x25 } } },
    { L"AMI_SETUP_NVRAM_UPDATE_GUID",                                         { 0xd84beff0, 0x159a, 0x4b60, { 0x9a, 0xb9, 0xac, 0x5c, 0x47, 0x4b, 0xd3, 0xb1 } } },
    { L"AMI_SMBIOS_CPU_INFO_PROTOCOL_GUID",                                   { 0x3d6cdb0a, 0x5b1f, 0x43a3, { 0xa4, 0x3b, 0x44, 0x12, 0x67, 0xf9, 0xda, 0xb5 } } },
    { L"AMI_SMBIOS_MEMORY_INFO_HOB_GUID",                                     { 0x7d6b8734, 0xb754, 0x443f, { 0xb5, 0x88, 0x77, 0x43, 0x84, 0x3a, 0xd3, 0xf1 } } },
    { L"AMI_SMBUS_HOB_GUID",                                                  { 0x017cb4b7, 0xb80c, 0x4040, { 0xb6, 0xc8, 0xea, 0x98, 0x2b, 0xbb, 0x25, 0xb7 } } },
    { L"AMI_SMBUS_SMM_PROTOCOL_GUID",                                         { 0x72e40094, 0x2ee1, 0x497a, { 0x8f, 0x33, 0x4c, 0x93, 0x4a, 0x9e, 0x9c, 0x0c } } },
    { L"AMI_SMM_DIGITAL_SIGNATURE_PROTOCOL_GUID",                             { 0x91abc830, 0x16fc, 0x4d9e, { 0xa1, 0x89, 0x5f, 0xc8, 0xbb, 0x41, 0x14, 0x02 } } },
    { L"AMI_SMM_INFO_PROTOCOL_GUID",                                          { 0xeb5198eb, 0xe7f5, 0x45a1, { 0x9c, 0xcb, 0xe5, 0x33, 0x64, 0xbb, 0x49, 0x92 } } },
    { L"AMI_STANDARD_DEFAULTS_VARIABLE_GUID",                                 { 0x4599d26f, 0x1a11, 0x49b8, { 0xb9, 0x1f, 0x85, 0x87, 0x45, 0xcf, 0xf8, 0x24 } } },
    { L"AMI_STATUS_CODE_CPU_BIST_DATA_GUID",                                  { 0xcd541d77, 0x6699, 0x4b36, { 0xa3, 0x1e, 0x1a, 0xa4, 0xc5, 0xd5, 0xb9, 0x46 } } },
    { L"AMI_TCG_CONFIRMATION_FLAGS_GUID",                                     { 0x7d3dceee, 0xcbce, 0x4ea7, { 0x87, 0x09, 0x6e, 0x55, 0x2f, 0x1e, 0xdb, 0xde } } },
    { L"AMI_TCG_EFI_OS_VARIABLE_GUID",                                        { 0xa8a2093b, 0xfefa, 0x43c1, { 0x8e, 0x62, 0xce, 0x52, 0x68, 0x47, 0x26, 0x5e } } },
    { L"AMI_TCG_PERM_FLAGS_GUID",                                             { 0x2325f2fc, 0x5683, 0x4648, { 0x97, 0xc4, 0x9a, 0x52, 0x0d, 0xfb, 0xe3, 0x25 } } },
    { L"AMI_TCG_PLATFORM_PPI_AFTER_MEM_GUID",                                 { 0x890c2cef, 0x43c8, 0x4209, { 0xa7, 0x8d, 0xae, 0x14, 0xaa, 0x17, 0x98, 0xb4 } } },
    { L"AMI_TCG_PLATFORM_PPI_BEFORE_MEM_GUID",                                { 0xc1e6791d, 0xf35b, 0x43ef, { 0x92, 0x0a, 0xbe, 0x06, 0xba, 0x7f, 0x86, 0xa1 } } },
    { L"AMI_TCG_PLATFORM_PPI_GUID",                                           { 0x05687f4a, 0x3ca7, 0x4d19, { 0x9b, 0xc5, 0xe1, 0x80, 0xce, 0xa3, 0x56, 0x9f } } },
    { L"AMI_TCG_PLATFORM_PROTOCOL_GUID",                                      { 0x320bdc39, 0x3fa0, 0x4ba9, { 0xbf, 0x2d, 0xb3, 0x3f, 0x72, 0xba, 0x9c, 0xa1 } } },
    { L"AMI_TCG_RESETVAR_HOB_GUID",                                           { 0xa8a2093b, 0xfefa, 0x43c1, { 0x8e, 0x62, 0xce, 0x52, 0x68, 0x47, 0x26, 0x5e } } },
    { L"AMITSE_ADMIN_PASSWORD_VALID_GUID",                                    { 0x541d5a75, 0x95ee, 0x43c7, { 0x9e, 0x5d, 0x23, 0x94, 0xdc, 0x48, 0x62, 0x49 } } },
    { L"AMITSE_AFTER_FIRST_BOOT_OPTION_GUID",                                 { 0xc48d651c, 0x9d0e, 0x4ce7, { 0xad, 0x39, 0xed, 0xd1, 0xab, 0x83, 0x6b, 0x30 } } },
    { L"AMITSE_BOOT_ORDER_CHANGE_GUID",                                       { 0x1b6bc809, 0xc986, 0x4937, { 0x93, 0x4f, 0x1e, 0xa5, 0x86, 0x22, 0xfe, 0x50 } } },
    { L"AMITSE_DRIVER_HEALTH_CTRL_GUID",                                      { 0x58279c2d, 0xfb19, 0x466e, { 0xb4, 0x2e, 0xcd, 0x43, 0x70, 0x16, 0xdc, 0x25 } } },
    { L"AMITSE_DRIVER_HEALTH_ENB_GUID",                                       { 0x0885f288, 0x418c, 0x4be1, { 0xa6, 0xaf, 0x8b, 0xad, 0x61, 0xda, 0x08, 0xfe } } },
    { L"AMITSE_DRIVER_HEALTH_GUID",                                           { 0x7459a7d4, 0x6533, 0x4480, { 0xbb, 0xa7, 0x79, 0xe2, 0x5a, 0x44, 0x43, 0xc9 } } },
    { L"AMITSE_EVENT_BEFORE_BOOT_GUID",                                       { 0x3677770f, 0xefb2, 0x43b2, { 0xb8, 0xae, 0xb3, 0x02, 0xe9, 0x60, 0x48, 0x82 } } },
    { L"AMITSE_INVALID_PASSWORD_GUID",                                        { 0xd69240c0, 0xdd40, 0x4f2d, { 0x98, 0x63, 0x48, 0x48, 0xda, 0x6e, 0x61, 0x5f } } },
    { L"AMITSE_NVRAM_UPDATE_GUID",                                            { 0xd84beff0, 0x159a, 0x4b60, { 0x9a, 0xb9, 0xac, 0x5c, 0x47, 0x4b, 0xd3, 0xb1 } } },
    { L"AMITSE_PASSWORD_PROMPT_ENTER_GUID",                                   { 0x073e7e01, 0x2611, 0x4e85, { 0xb8, 0x96, 0xa3, 0xb6, 0x76, 0x7c, 0xba, 0x00 } } },
    { L"AMITSE_PASSWORD_PROMPT_EXIT_GUID",                                    { 0xb9b038b0, 0xe2b6, 0x4aab, { 0x94, 0x35, 0x41, 0x65, 0xec, 0xfe, 0xd0, 0x32 } } },
    { L"AMITSE_SETUP_ENTER_GUID",                                             { 0x71202eee, 0x5f53, 0x40d9, { 0xab, 0x3d, 0x9e, 0x0c, 0x26, 0xd9, 0x66, 0x57 } } },
    { L"AMITSESETUP_GUID",                                                    { 0xc811fa38, 0x42c8, 0x4579, { 0xa9, 0xbb, 0x60, 0xe9, 0x4e, 0xdd, 0xfb, 0x34 } } },
    { L"AMITSE_USER_PASSWORD_VALID_GUID",                                     { 0xab1404ca, 0x4801, 0x4208, { 0x98, 0xbf, 0x30, 0xd5, 0x21, 0xda, 0xd4, 0xd3 } } },
    { L"AMI_USB_SMM_PROTOCOL_GUID",                                           { 0x3ef7500e, 0xcf55, 0x474f, { 0x8e, 0x7e, 0x00, 0x9e, 0x0e, 0xac, 0xec, 0xd2 } } },
    { L"AMT_FORCE_PUSH_PET_HOB_GUID",                                         { 0x4efa0db6, 0x26dc, 0x4bb1, { 0xa7, 0x6f, 0x14, 0xbc, 0x63, 0x0c, 0x7b, 0x3c } } },
    { L"AMT_FORCE_PUSH_PET_POLICY_GUID",                                      { 0xacc8e1e4, 0x9f9f, 0x4e40, { 0xa5, 0x7e, 0xf9, 0x9e, 0x52, 0xf3, 0x4c, 0xa5 } } },
    { L"AMT_FORCE_PUSH_PET_VARIABLE_GUID",                                    { 0xd7ac94af, 0xa498, 0x45ec, { 0xbf, 0xa2, 0xa5, 0x6e, 0x95, 0x34, 0x61, 0x8b } } },
    { L"AMT_INT16_CSM_GUID",                                                  { 0x6046e678, 0x24ef, 0x4005, { 0xba, 0x39, 0xbd, 0xa1, 0x1f, 0x6d, 0x55, 0x5d } } },
    { L"AMT_READY_TO_BOOT_PROTOCOL_GUID",                                     { 0x40b09b5a, 0xf0ef, 0x4627, { 0x93, 0xd5, 0x27, 0xf0, 0x4b, 0x75, 0x4d, 0x05 } } },
    { L"AOAC_EC_WAKEUP_CUSTOM_PPI_GUID",                                      { 0x82627acf, 0xd92d, 0x416d, { 0x8a, 0x6f, 0x78, 0x3c, 0xac, 0xd9, 0x12, 0x23 } } },
    { L"AOAC_FFS_TABLE_STORAGE_GUID",                                         { 0xfb045db2, 0x598e, 0x485a, { 0xba, 0x30, 0x5d, 0x7b, 0x1b, 0x1b, 0xd5, 0x4d } } },
    { L"APTIO_FW_CAPSULE_GUID",                                               { 0x4a3ca68b, 0x7723, 0x48fb, { 0x80, 0x3d, 0x57, 0x8c, 0xc1, 0xfe, 0xc4, 0x4d } } },
    { L"APTIO_HII_PROTOCOL_GUID",                                             { 0xea816d2c, 0xcee5, 0x4f02, { 0x99, 0xb5, 0xd3, 0x90, 0x5c, 0xbb, 0xd0, 0x77 } } },
    { L"ARM_GLOBAL_VARIABLE_PPI_GUID",                                        { 0xab1c1816, 0xd542, 0x4e6f, { 0x9b, 0x1e, 0x8e, 0xcd, 0x92, 0x53, 0xe2, 0xe7 } } },
    { L"ARM_HOB_GLOBAL_VARIABLE_GUID",                                        { 0xc3253c90, 0xa24f, 0x4599, { 0xa6, 0x64, 0x1f, 0x88, 0x13, 0x77, 0x8f, 0xc9 } } },
    { L"ARM_MP_CORE_INFO_GUID",                                               { 0xa4ee0728, 0xe5d7, 0x4ac5, { 0xb2, 0x1e, 0x65, 0x8e, 0xd8, 0x57, 0xe8, 0x34 } } },
    { L"ARM_MP_CORE_INFO_PPI_GUID",                                           { 0x6847cc74, 0xe9ec, 0x4f8f, { 0xa2, 0x9d, 0xab, 0x44, 0xe7, 0x54, 0xa8, 0xfc } } },
    { L"AUTHVAR_MAILBOX_VARIABLE_GUID",                                       { 0x532b6532, 0x6499, 0x428d, { 0xac, 0xb1, 0xf6, 0xf7, 0x79, 0xc9, 0x4d, 0xf9 } } },
    { L"BDS_ALL_DRIVERS_CONNECTED_PROTOCOL_GUID",                             { 0xdbc9fd21, 0xfad8, 0x45b0, { 0x9e, 0x78, 0x27, 0x15, 0x88, 0x67, 0xcc, 0x93 } } },
    { L"BDS_CONNECT_DRIVERS_PROTOCOL_GUID",                                   { 0x3aa83745, 0x9454, 0x4f7a, { 0xa7, 0xc0, 0x90, 0xdb, 0xd0, 0x2f, 0xab, 0x8e } } },
    { L"BDS_LIB_STRING_PACKAGE_GUID",                                         { 0x3b4d9b23, 0x95ac, 0x44f6, { 0x9f, 0xcd, 0x0e, 0x95, 0x94, 0x58, 0x6c, 0x72 } } },
    { L"BLOCK_DEVICE_RECOVERY_CAPSULE_GUID",                                  { 0x0ba8263c, 0xa8bd, 0x4aad, { 0xb4, 0x02, 0x6a, 0x6a, 0xf2, 0xf7, 0xe7, 0x7d } } },
    { L"BLOCKIO_VENDOR_GUID",                                                 { 0xcf31fac5, 0xc24e, 0x11d2, { 0x85, 0xf3, 0x00, 0xa0, 0xc9, 0x3e, 0xc9, 0x3b } } },
    { L"BLOCK_MMIO_PROTOCOL_GUID",                                            { 0x6b558ce3, 0x69e5, 0x4c67, { 0xa6, 0x34, 0xf7, 0xfe, 0x72, 0xad, 0xbe, 0x84 } } },
    { L"BOOT_FLOW_VARIABLE_GUID",                                             { 0xef152fb4, 0x7b2f, 0x427d, { 0xbd, 0xb4, 0x7e, 0x0a, 0x05, 0x82, 0x6e, 0x64 } } },
    { L"BOOT_FORM_SET_GUID",                                                  { 0x8b33ffe0, 0xd71c, 0x4f82, { 0x9c, 0xeb, 0xc9, 0x70, 0x58, 0xc1, 0x3f, 0x8e } } },
    { L"BOOT_MAINT_FORMSET_GUID",                                             { 0x642237c7, 0x35d4, 0x472d, { 0x83, 0x65, 0x12, 0xe0, 0xcc, 0xf2, 0x7a, 0x22 } } },
    { L"BOOT_MANAGER_FORMSET_GUID",                                           { 0x847bc3fe, 0xb974, 0x446d, { 0x94, 0x49, 0x5a, 0xd5, 0x41, 0x2e, 0x99, 0x3b } } },
    { L"BOOT_MANAGER_GUID",                                                   { 0xb4909cf3, 0x7b93, 0x4751, { 0x9b, 0xd8, 0x5b, 0xa8, 0x22, 0x0b, 0x9b, 0xb2 } } },
    { L"BOOT_NOW_COUNT_GUID",                                                 { 0x052e6eb0, 0xf240, 0x42c5, { 0x83, 0x09, 0x45, 0x87, 0x45, 0x45, 0xc6, 0xb4 } } },
    { L"BOOT_OBJECT_AUTHORIZATION_PARMSET_GUID",                              { 0xedd35e31, 0x07b9, 0x11d2, { 0x83, 0xa3, 0x00, 0xa0, 0xc9, 0x1f, 0xad, 0xcf } } },
    { L"CHIPSET_FORM_SET_GUID",                                               { 0xadfe34c8, 0x9ae1, 0x4f8f, { 0xbe, 0x13, 0xcf, 0x96, 0xa2, 0xcb, 0x2c, 0x5b } } },
    { L"CMOS_MANAGER_HOB_GUID",                                               { 0xd5367802, 0xb873, 0x4c0f, { 0xb5, 0x44, 0x31, 0xb7, 0xcc, 0xf5, 0xc5, 0x55 } } },
    { L"CONNECT_CONIN_EVENT_GUID",                                            { 0xdb4e8151, 0x57ed, 0x4bed, { 0x88, 0x33, 0x67, 0x51, 0xb5, 0xd1, 0xa8, 0xd7 } } },
    { L"CONSOLE_IN_DEVICES_STARTED_PROTOCOL_GUID",                            { 0x2df1e051, 0x906d, 0x4eff, { 0x86, 0x9d, 0x24, 0xe6, 0x53, 0x78, 0xfb, 0x9e } } },
    { L"CONSOLE_OUT_DEVICES_STARTED_PROTOCOL_GUID",                           { 0xef9a3971, 0xc1a0, 0x4a93, { 0xbd, 0x40, 0x5a, 0xa1, 0x65, 0xf2, 0xdc, 0x3a } } },
    { L"CPU_MICROCODE_FILE_GUID",                                             { 0x17088572, 0x377f, 0x44ef, { 0x8f, 0x4e, 0xb0, 0x9f, 0xff, 0x46, 0xa0, 0x70 } } },
    { L"CPU_WAKE_UP_BUFFER_VARIABLE_GUID",                                    { 0xdf665292, 0x79d7, 0x40e2, { 0xba, 0x51, 0xf7, 0xd4, 0x94, 0x62, 0x81, 0x85 } } },
    { L"CSM_VIDEO_POLICY_PROTOCOL_GUID",                                      { 0x3a4e4376, 0x4871, 0x4b0e, { 0xa0, 0x2f, 0xed, 0x36, 0xf2, 0xae, 0xcd, 0x00 } } },
    { L"DCA_HOB_GUID",                                                        { 0x6865c455, 0x8626, 0x40d8, { 0x90, 0xf4, 0xa6, 0x94, 0x60, 0xa4, 0xab, 0x5a } } },
    { L"DEBUGGER_TERMINAL_VAR_GUID",                                          { 0x97ca1a5b, 0xb760, 0x4d1f, { 0xa5, 0x4b, 0xd1, 0x90, 0x92, 0x03, 0x2c, 0x90 } } },
    { L"DEFINE_GUID_AcpiPlatformPeiBin_GUID",                                 { 0x333bb2a3, 0x4f20, 0x4c8b, { 0xac, 0x38, 0x06, 0x72, 0xd7, 0x43, 0x15, 0xf8 } } },
    { L"DEFINE_GUID_AcpiPlatformSmiBin_GUID",                                 { 0xdfd8d5cc, 0x5aed, 0x4820, { 0xa2, 0xb6, 0x5c, 0x55, 0xe4, 0xe6, 0x40, 0xef } } },
    { L"DEFINE_GUID_CRBDXEBin_GUID",                                          { 0x16271fca, 0x55d9, 0x4a33, { 0x93, 0xfc, 0x5a, 0x3e, 0xb1, 0x28, 0xde, 0xb6 } } },
    { L"DEFINE_GUID_CRBPEIBin_GUID",                                          { 0x0d1ed2f7, 0xe92b, 0x4562, { 0x92, 0xdd, 0x5c, 0x82, 0xec, 0x91, 0x7e, 0xae } } },
    { L"DEFINE_GUID_CRBSMIBin_GUID",                                          { 0x221f1d4f, 0x034c, 0x4bea, { 0xb2, 0xbb, 0xb7, 0xa9, 0x67, 0x2b, 0x06, 0xd7 } } },
    { L"DEFINE_GUID_NBDXEBin_GUID",                                           { 0xe4ecd0b2, 0xe277, 0x4f2b, { 0xbe, 0xcb, 0xe4, 0xd7, 0x5c, 0x9a, 0x81, 0x2e } } },
    { L"DEFINE_GUID_NBPEIBin_GUID",                                           { 0x79aa6086, 0x035a, 0x4ad9, { 0xa8, 0x9a, 0xa6, 0xd5, 0xaa, 0x27, 0xf0, 0xe2 } } },
    { L"DEFINE_GUID_OEMDXEBin_GUID",                                          { 0xbfe205c9, 0x5b17, 0x4f8f, { 0x93, 0x75, 0x89, 0x61, 0x4a, 0xf8, 0xe1, 0x99 } } },
    { L"DEFINE_GUID_OEMPEIBin_GUID",                                          { 0x6e59df06, 0x62d3, 0x40b0, { 0x82, 0xb5, 0x17, 0x5c, 0xf8, 0x4a, 0x94, 0xe4 } } },
    { L"DEFINE_GUID_SBDXEBin_GUID",                                           { 0xb7d19491, 0xe55a, 0x470d, { 0x85, 0x08, 0x85, 0xa5, 0xdf, 0xa4, 0x19, 0x74 } } },
    { L"DEFINE_GUID_SBPEIBin_GUID",                                           { 0xc1fbd624, 0x27ea, 0x40d1, { 0xaa, 0x48, 0x94, 0xc3, 0xdc, 0x5c, 0x7e, 0x0d } } },
    { L"DEFINE_GUID_SBRunBin_GUID",                                           { 0xe23f86e1, 0x056e, 0x4888, { 0xb6, 0x85, 0xcf, 0xcd, 0x67, 0xc1, 0x79, 0xd4 } } },
    { L"DEL_BOOT_OPTION_GUID",                                                { 0xf6c73719, 0xf34c, 0x479c, { 0xb3, 0x2f, 0x27, 0x7f, 0xcb, 0xbc, 0xfe, 0x4f } } },
    { L"DEVICE_MANAGER_FORMSET_GUID",                                         { 0x3ebfa8e6, 0x511d, 0x4b5b, { 0xa9, 0x5f, 0xfb, 0x38, 0x26, 0x0f, 0x1c, 0x27 } } },
    { L"DIMM_TS_INFO_GUID",                                                   { 0xce673a28, 0x800d, 0x4b4a, { 0x83, 0x16, 0x26, 0x61, 0xf9, 0xb3, 0xd9, 0xc6 } } },
    { L"DRIVER_HEALTH_FORMSET_GUID",                                          { 0xf76e0a70, 0xb5ed, 0x4c38, { 0xac, 0x9a, 0xe5, 0xf5, 0x4b, 0xf1, 0x6e, 0x34 } } },
    { L"DRIVER_SAMPLE_FORMSET_GUID",                                          { 0xa04a27f4, 0xdf00, 0x4d42, { 0xb5, 0x52, 0x39, 0x51, 0x13, 0x02, 0x11, 0x3d } } },
    { L"DRIVER_SAMPLE_INVENTORY_GUID",                                        { 0xb3f56470, 0x6141, 0x4621, { 0x8f, 0x19, 0x70, 0x4e, 0x57, 0x7a, 0xa9, 0xe8 } } },
    { L"DUET_CONSOLEOUT_CONFIG_GUID",                                         { 0xed150714, 0xdf30, 0x407d, { 0xb2, 0x4a, 0x4b, 0x74, 0x2f, 0xd5, 0xce, 0xa2 } } },
    { L"DXE_CORE_FILE_NAME_GUID",                                             { 0xd6a2cb7f, 0x6a18, 0x4e2f, { 0xb4, 0x3b, 0x99, 0x20, 0xa7, 0x33, 0x70, 0x0a } } },
    { L"DXE_CPU_CACHE_PROTOCOL_GUID",                                         { 0x5c6fa2c9, 0x9768, 0x45f6, { 0x8e, 0x64, 0x5a, 0xec, 0xca, 0xda, 0xb4, 0x81 } } },
    { L"DXE_CPU_INFO_PROTOCOL_GUID",                                          { 0xe223cf65, 0xf6ce, 0x4122, { 0xb3, 0xaf, 0x4b, 0xd1, 0x8a, 0xff, 0x40, 0xa1 } } },
    { L"DXE_CPU_PLATFORM_POLICY_PROTOCOL_GUID",                               { 0xbd26cdc9, 0xa092, 0x462a, { 0x87, 0x7a, 0x5a, 0xb6, 0xad, 0xce, 0x48, 0x12 } } },
    { L"DXE_ENHANCED_SPEEDSTEP_PROTOCOL_GUID",                                { 0x00e98021, 0xf4fe, 0x46cc, { 0xab, 0x2d, 0x89, 0x4c, 0x37, 0x3a, 0xfa, 0x01 } } },
    { L"DXE_PCH_PLATFORM_POLICY_PROTOCOL_GUID",                               { 0xe0a31dbe, 0xf20e, 0x4e2a, { 0x9f, 0x2b, 0x9f, 0x02, 0xa2, 0x7d, 0x3d, 0x69 } } },
    { L"DXE_PLATFORM_AMT_POLICY_GUID",                                        { 0xb2ab115e, 0xc8b6, 0x4036, { 0xbf, 0x31, 0xe7, 0x4b, 0xd8, 0x92, 0x6c, 0xce } } },
    { L"DXE_PLATFORM_ME_POLICY_GUID",                                         { 0xf8bff014, 0x18fb, 0x4ef9, { 0xb1, 0x0c, 0xae, 0x22, 0x73, 0x8d, 0xbe, 0xed } } },
    { L"DXE_PLATFORM_SA_POLICY_GUID",                                         { 0xcd2333d7, 0x6a0a, 0x4c76, { 0x83, 0x50, 0x24, 0x0a, 0xda, 0x36, 0xa2, 0xc7 } } },
    { L"DXE_PLATFORM_SG_POLICY_GUID",                                         { 0x6199dc36, 0xe114, 0x4e0d, { 0x80, 0x99, 0x99, 0xa0, 0xbd, 0x80, 0xa9, 0x71 } } },
    { L"DXE_PLATFORM_TDT_POLICY_GUID",                                        { 0x20daf0fc, 0x5548, 0x44dc, { 0xa4, 0x2a, 0x60, 0xea, 0xf0, 0xa2, 0x2e, 0x47 } } },
    { L"DXE_SERVICES_TABLE_GUID",                                             { 0x05ad34ba, 0x6f02, 0x4214, { 0x95, 0x2e, 0x4d, 0xa0, 0x39, 0x8e, 0x2b, 0xb9 } } },
    { L"DXE_TXT_POLICY_PROTOCOL_GUID",                                        { 0x43f66ffd, 0xb288, 0x4139, { 0xba, 0xd5, 0xb8, 0x98, 0x03, 0xe7, 0x30, 0xa2 } } },
    { L"DYNAMIC_PAGE_COUNT_GUID",                                             { 0xb63bf800, 0xf267, 0x4f55, { 0x92, 0x17, 0xe9, 0x7f, 0xb3, 0xb6, 0x98, 0x46 } } },
    { L"EBL_ADD_COMMAND_PROTOCOL_GUID",                                       { 0xaeda2428, 0x9a22, 0x4637, { 0x9b, 0x21, 0x54, 0x5e, 0x28, 0xfb, 0xb8, 0x29 } } },
    { L"ECP_PEI_PCI_CFG_PPI_GUID",                                            { 0xb0ee53d4, 0xa049, 0x4a79, { 0xb2, 0xff, 0x19, 0xd9, 0xfa, 0xef, 0xaa, 0x94 } } },
    { L"EDKII_FAULT_TOLERANT_WRITE_GUID",                                     { 0x1d3e9cb8, 0x43af, 0x490b, { 0x83, 0x0a, 0x35, 0x16, 0xaa, 0x53, 0x20, 0x47 } } },
    { L"EDKII_FORM_BROWSER_EXTENSION2_PROTOCOL_GUID",                         { 0xa770c357, 0xb693, 0x4e6d, { 0xa6, 0xcf, 0xd2, 0x1c, 0x72, 0x8e, 0x55, 0x0b } } },
    { L"EDKII_FORM_DISPLAY_ENGINE_PROTOCOL_GUID",                             { 0x9bbe29e9, 0xfda1, 0x41ec, { 0xad, 0x52, 0x45, 0x22, 0x13, 0x74, 0x2d, 0x2e } } },
    { L"EDKII_VARIABLE_LOCK_PROTOCOL_GUID",                                   { 0xcd3d0a05, 0x9e24, 0x437c, { 0xa8, 0x91, 0x1e, 0xe0, 0x53, 0xdb, 0x76, 0x38 } } },
    { L"EDKII_WORKING_BLOCK_SIGNATURE_GUID",                                  { 0x9e58292b, 0x7c68, 0x497d, { 0xa0, 0xce, 0x65, 0x00, 0xfd, 0x9f, 0x1b, 0x95 } } },
    { L"EFI_ABSOLUTE_POINTER_PROTOCOL_GUID",                                  { 0x8d59d32b, 0xc655, 0x4ae9, { 0x9b, 0x15, 0xf2, 0x59, 0x04, 0x99, 0x2a, 0x43 } } },
    { L"EFI_ACPI_20_TABLE_GUID",                                              { 0x8868e871, 0xe4f1, 0x11d3, { 0xbc, 0x22, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_ACPI_DESCRIPTION_GUID",                                           { 0x3c699197, 0x093c, 0x4c69, { 0xb0, 0x6b, 0x12, 0x8a, 0xe3, 0x48, 0x1d, 0xc9 } } },
    { L"EFI_ACPI_S3_CONTEXT_GUID",                                            { 0x0ef98d3a, 0x3e33, 0x497a, { 0xa4, 0x01, 0x77, 0xbe, 0x3e, 0xb7, 0x4f, 0x38 } } },
    { L"EFI_ACPI_S3_SAVE_GUID",                                               { 0x125f2de1, 0xfb85, 0x440c, { 0xa5, 0x4c, 0x4d, 0x99, 0x35, 0x8a, 0x8d, 0x38 } } },
    { L"EFI_ACPI_SDT_PROTOCOL_GUID",                                          { 0xeb97088e, 0xcfdf, 0x49c6, { 0xbe, 0x4b, 0xd9, 0x06, 0xa5, 0xb2, 0x0e, 0x86 } } },
    { L"EFI_ACPI_SUPPORT_GUID",                                               { 0xdbff9d55, 0x89b7, 0x46da, { 0xbd, 0xdf, 0x67, 0x7d, 0x3d, 0xc0, 0x24, 0x1d } } },
    { L"EFI_ACPI_TABLE_GUID",                                                 { 0x8868e871, 0xe4f1, 0x11d3, { 0xbc, 0x22, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_ACPI_TABLE_GUID",                                                 { 0xeb9d2d30, 0x2d88, 0x11d3, { 0x9a, 0x16, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_ACPI_TABLE_PROTOCOL_GUID",                                        { 0xffe06bdd, 0x6107, 0x46a6, { 0x7b, 0xb2, 0x5a, 0x9c, 0x7e, 0xc5, 0x27, 0x5c } } },
    { L"EFI_ACPI_TABLE_STORAGE_GUID",                                         { 0x7e374e25, 0x8e01, 0x4fee, { 0x87, 0xf2, 0x39, 0x0c, 0x23, 0xc6, 0x06, 0xcd } } },
    { L"EFI_ACPI_VARIABLE_COMPATIBILITY_GUID",                                { 0xc020489e, 0x6db2, 0x4ef2, { 0x9a, 0xa5, 0xca, 0x06, 0xfc, 0x11, 0xd3, 0x6a } } },
    { L"EFI_ACPI_VARIABLE_GUID",                                              { 0xaf9ffd67, 0xec10, 0x488a, { 0x9d, 0xfc, 0x6c, 0xbf, 0x5e, 0xe2, 0x2c, 0x2e } } },
    { L"EFI_ACTIVE_BIOS_PROTOCOL_GUID",                                       { 0xebbe2d1b, 0x1647, 0x4bda, { 0xab, 0x9a, 0x78, 0x63, 0xe3, 0x96, 0xd4, 0x1a } } },
    { L"EFI_ACTIVE_MANAGEMENT_PROTOCOL_GUID",                                 { 0x8555fd40, 0x140b, 0x4f3c, { 0x90, 0x5e, 0x3b, 0xf3, 0x78, 0xa0, 0x99, 0xfa } } },
    { L"EFI_AHCI_INT13_INIT_PROTOCOL_GUID",                                   { 0x67820532, 0x7613, 0x4dd3, { 0x9e, 0xd7, 0x3d, 0x9b, 0xe3, 0xa7, 0xda, 0x63 } } },
    { L"EFI_ALERT_STANDARD_FORMAT_PROTOCOL_GUID",                             { 0xcc93a70b, 0xec27, 0x49c5, { 0x8b, 0x34, 0x13, 0x93, 0x1e, 0xfe, 0xd6, 0xe2 } } },
    { L"EFI_ALTERNATE_FV_BLOCK_GUID",                                         { 0xf496922d, 0x172f, 0x4bbc, { 0xa1, 0xeb, 0x0e, 0xeb, 0x94, 0x9c, 0x34, 0x86 } } },
    { L"EFI_AMI_LEGACYBOOT_PROTOCOL_GUID",                                    { 0x120d28aa, 0x6630, 0x46f0, { 0x81, 0x57, 0xc0, 0xad, 0xc2, 0x38, 0x3b, 0xf5 } } },
    { L"EFI_APRIORI_GUID",                                                    { 0xfc510ee7, 0xffdc, 0x11d4, { 0xbd, 0x41, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_ARP_PROTOCOL_GUID",                                               { 0xf4b427bb, 0xba21, 0x4f16, { 0xbc, 0x4e, 0x43, 0xe4, 0x16, 0xab, 0x61, 0x9c } } },
    { L"EFI_ARP_SERVICE_BINDING_PROTOCOL_GUID",                               { 0xf44c00ee, 0x1f2c, 0x4a00, { 0xaa, 0x09, 0x1c, 0x9f, 0x3e, 0x08, 0x00, 0xa3 } } },
    { L"EFI_ATA_PASS_THRU_PROTOCOL_GUID",                                     { 0x1d3de7f0, 0x0807, 0x424f, { 0xaa, 0x69, 0x11, 0xa5, 0x4e, 0x19, 0xa4, 0x6f } } },
    { L"EFI_AUTHENTICATED_VARIABLE_GUID",                                     { 0xaaf32c78, 0x947b, 0x439a, { 0xa1, 0x80, 0x2e, 0x14, 0x4e, 0xc3, 0x77, 0x92 } } },
    { L"EFI_AUTHENTICATION_CHAP_LOCAL_GUID",                                  { 0xc280c73e, 0x15ca, 0x11da, { 0xb0, 0xca, 0x00, 0x10, 0x83, 0xff, 0xca, 0x4d } } },
    { L"EFI_AUTHENTICATION_CHAP_RADIUS_GUID",                                 { 0xd6062b50, 0x15ca, 0x11da, { 0x92, 0x19, 0x00, 0x10, 0x83, 0xff, 0xca, 0x4d } } },
    { L"EFI_AUTHENTICATION_INFO_PROTOCOL_GUID",                               { 0x7671d9d0, 0x53db, 0x4173, { 0xaa, 0x69, 0x23, 0x27, 0xf2, 0x1f, 0x0b, 0xc7 } } },
    { L"EFI_AUTHORIZATION_PROTOCOL_GUID",                                     { 0x995188b1, 0x9f96, 0x11d4, { 0x87, 0xae, 0x00, 0x06, 0x29, 0x2e, 0x8a, 0x3b } } },
    { L"EFI_BDAT_ACCESS_GUID",                                                { 0xb979746a, 0x8c1f, 0x4a2b, { 0x97, 0xe4, 0x78, 0xe9, 0x3a, 0x71, 0xa7, 0x0a } } },
    { L"EFI_BDS_ARCH_PROTOCOL_GUID",                                          { 0x665e3ff6, 0x46cc, 0x11d4, { 0x9a, 0x38, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_BIS_PROTOCOL_GUID",                                               { 0x0b64aab0, 0x5429, 0x11d4, { 0x98, 0x16, 0x00, 0xa0, 0xc9, 0x1f, 0xad, 0xcf } } },
    { L"EFI_BLOCK_IO2_PROTOCOL_GUID",                                         { 0xa77b2472, 0xe282, 0x4e9f, { 0xa2, 0x45, 0xc2, 0xc0, 0xe2, 0x7b, 0xbc, 0xc1 } } },
    { L"EFI_BLOCK_IO_PROTOCOL_GUID",                                          { 0x964e5b21, 0x6459, 0x11d2, { 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_BOOT_LOGO_PROTOCOL_GUID",                                         { 0xcdea2bd3, 0xfc25, 0x4c1c, { 0xb9, 0x7c, 0xb3, 0x11, 0x86, 0x06, 0x49, 0x90 } } },
    { L"EFI_BOOT_SCRIPT_EXECUTOR_CONTEXT_GUID",                               { 0x79cb58c4, 0xac51, 0x442f, { 0xaf, 0xd7, 0x98, 0xe4, 0x7d, 0x2e, 0x99, 0x08 } } },
    { L"EFI_BOOT_SCRIPT_EXECUTOR_VARIABLE_GUID",                              { 0x3079818c, 0x46d4, 0x4a73, { 0xae, 0xf3, 0xe3, 0xe4, 0x6c, 0xf1, 0xee, 0xdb } } },
    { L"EFI_BOOT_SCRIPT_SAVE_PROTOCOL_GUID",                                  { 0x470e1529, 0xb79e, 0x4e32, { 0xa0, 0xfe, 0x6a, 0x15, 0x6d, 0x29, 0xf9, 0xb2 } } },
    { L"EFI_BOOT_STATE_VARIABLE_GUID",                                        { 0x60b5e939, 0x0fcf, 0x4227, { 0xba, 0x83, 0x6b, 0xbe, 0xd4, 0x5b, 0xc0, 0xe3 } } },
    { L"EFI_BUS_SPECIFIC_DRIVER_OVERRIDE_PROTOCOL_GUID",                      { 0x3bc1b285, 0x8a15, 0x4a82, { 0xaa, 0xbf, 0x4d, 0x7d, 0x13, 0xfb, 0x32, 0x65 } } },
    { L"EFI_CACHE_INSTALL_PPI_GUID",                                          { 0xbb628ae0, 0xcd4f, 0x49fe, { 0x8d, 0x60, 0x63, 0x18, 0x6f, 0xd1, 0xe0, 0x5b } } },
    { L"EFI_CACHE_SUBCLASS_GUID",                                             { 0x7f0013a7, 0xdc79, 0x4b22, { 0x80, 0x99, 0x11, 0xf7, 0x5f, 0xdc, 0x82, 0x9d } } },
    { L"EFI_CAPSULE_AMI_GUID",                                                { 0xfac2efad, 0x8511, 0x4e34, { 0x9c, 0xae, 0x16, 0xa2, 0x57, 0xba, 0x94, 0x88 } } },
    { L"EFI_CAPSULE_ARCH_PROTOCOL_GUID",                                      { 0x5053697e, 0x2cbc, 0x4819, { 0x90, 0xd9, 0x05, 0x80, 0xde, 0xee, 0x57, 0x54 } } },
    { L"EFI_CAPSULE_GUID",                                                    { 0x3b6686bd, 0x0d76, 0x4030, { 0xb7, 0x0e, 0xb5, 0x51, 0x9e, 0x2f, 0xc5, 0xa0 } } },
    { L"EFI_CAPSULE_INFO_GUID",                                               { 0x8b34eac7, 0x2690, 0x460b, { 0x8b, 0xa5, 0xd5, 0xcf, 0x32, 0x83, 0x17, 0x35 } } },
    { L"EFI_CAPSULE_VENDOR_GUID",                                             { 0x711c703f, 0xc285, 0x4b10, { 0xa3, 0xb0, 0x36, 0xec, 0xbd, 0x3c, 0x8b, 0xe2 } } },
    { L"EFI_CERT_RSA2048_GUID",                                               { 0x3c5766e8, 0x269c, 0x4e34, { 0xaa, 0x14, 0xed, 0x77, 0x6e, 0x85, 0xb3, 0xb6 } } },
    { L"EFI_CERT_RSA2048_SHA1_GUID",                                          { 0x67f8444f, 0x8743, 0x48f1, { 0xa3, 0x28, 0x1e, 0xaa, 0xb8, 0x73, 0x60, 0x80 } } },
    { L"EFI_CERT_RSA2048_SHA256_GUID",                                        { 0xe2b36190, 0x879b, 0x4a3d, { 0xad, 0x8d, 0xf2, 0xe7, 0xbb, 0xa3, 0x27, 0x84 } } },
    { L"EFI_CERT_SHA1_GUID",                                                  { 0x826ca512, 0xcf10, 0x4ac9, { 0xb1, 0x87, 0xbe, 0x01, 0x49, 0x66, 0x31, 0xbd } } },
    { L"EFI_CERT_SHA224_GUID",                                                { 0x0b6e5233, 0xa65c, 0x44c9, { 0x94, 0x07, 0xd9, 0xab, 0x83, 0xbf, 0xc8, 0xbd } } },
    { L"EFI_CERT_SHA256_GUID",                                                { 0xc1c41626, 0x504c, 0x4092, { 0xac, 0xa9, 0x41, 0xf9, 0x36, 0x93, 0x43, 0x28 } } },
    { L"EFI_CERT_SHA384_GUID",                                                { 0xff3e5307, 0x9fd0, 0x48c9, { 0x85, 0xf1, 0x8a, 0xd5, 0x6c, 0x70, 0x1e, 0x01 } } },
    { L"EFI_CERT_SHA512_GUID",                                                { 0x093e0fae, 0xa6c4, 0x4f50, { 0x9f, 0x1b, 0xd4, 0x1e, 0x2b, 0x89, 0xc1, 0x9a } } },
    { L"EFI_CERT_TYPE_PKCS7_GUID",                                            { 0x4aafd29d, 0x68df, 0x49ee, { 0x8a, 0xa9, 0x34, 0x7d, 0x37, 0x56, 0x65, 0xa7 } } },
    { L"EFI_CERT_TYPE_RSA2048_SHA256_GUID",                                   { 0xa7717414, 0xc616, 0x4977, { 0x94, 0x20, 0x84, 0x47, 0x12, 0xa7, 0x35, 0xbf } } },
    { L"EFI_CERT_X509_GUID",                                                  { 0xa5c059a1, 0x94e4, 0x4aa7, { 0x87, 0xb5, 0xab, 0x15, 0x5c, 0x2b, 0xf0, 0x72 } } },
    { L"EFI_CLP_PROTOCOL_GUID",                                               { 0xcbbee336, 0x2682, 0x4cd6, { 0x81, 0x8b, 0x0a, 0x0d, 0x96, 0x7e, 0x5a, 0x67 } } },
    { L"EFI_CMOS_DATA_HOB_INSTALLED_GUID",                                    { 0x5a6a93f4, 0x2907, 0x4a34, { 0xbd, 0x11, 0x6c, 0xa8, 0xa0, 0x95, 0x9e, 0x09 } } },
    { L"EFI_COMPATIBLE_MEMORY_TESTED_PROTOCOL_GUID",                          { 0x64c475ef, 0x344b, 0x492c, { 0x93, 0xad, 0xab, 0x9e, 0xb4, 0x39, 0x50, 0x04 } } },
    { L"EFI_COMPONENT_NAME2_PROTOCOL_GUID",                                   { 0x6a7a5cff, 0xe8d9, 0x4f70, { 0xba, 0xda, 0x75, 0xab, 0x30, 0x25, 0xce, 0x14 } } },
    { L"EFI_COMPONENT_NAME_PROTOCOL_GUID",                                    { 0x107a772c, 0xd5e1, 0x11d4, { 0x9a, 0x46, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_CONFIG_FILE_NAME_GUID",                                           { 0x98b8d59b, 0xe8ba, 0x48ee, { 0x98, 0xdd, 0xc2, 0x95, 0x39, 0x2f, 0x1e, 0xdb } } },
    { L"EFI_CONSOLE_CONTROL_PROTOCOL_GUID",                                   { 0xf42f7782, 0x012e, 0x4c12, { 0x99, 0x56, 0x49, 0xf9, 0x43, 0x04, 0xf7, 0x21 } } },
    { L"EFI_CONSOLE_IN_DEVICE_GUID",                                          { 0xd3b36f2b, 0xd551, 0x11d4, { 0x9a, 0x46, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_CONSOLE_LOCK_GUID",                                               { 0x368cda0d, 0xcf31, 0x4b9b, { 0x8c, 0xf6, 0xe7, 0xd1, 0xbf, 0xff, 0x15, 0x7e } } },
    { L"EFI_CONSOLE_OUT_DEVICE_GUID",                                         { 0xd3b36f2c, 0xd551, 0x11d4, { 0x9a, 0x46, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_CPU_ARCH_PROTOCOL_GUID",                                          { 0x26baccb1, 0x6f42, 0x11d4, { 0xbc, 0xe7, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_CPU_IO2_PROTOCOL_GUID",                                           { 0xad61f191, 0xae5f, 0x4c0e, { 0xb9, 0xfa, 0xe8, 0x69, 0xd2, 0x88, 0xc6, 0x4f } } },
    { L"EFI_CPU_IO2_PROTOCOL_GUID",                                           { 0xb0732526, 0x38c8, 0x4b40, { 0x88, 0x77, 0x61, 0xc7, 0xb0, 0x6a, 0xac, 0x45 } } },
    { L"EFI_CPU_IO_PROTOCOL_GUID",                                            { 0xb0732526, 0x38c8, 0x4b40, { 0x88, 0x77, 0x61, 0xc7, 0xb0, 0x6a, 0xac, 0x45 } } },
    { L"EFI_CPU_TYPE_FRU_GUID",                                               { 0xf064c91f, 0x188c, 0x4f56, { 0xb7, 0xfd, 0x30, 0xa9, 0xb8, 0x6a, 0x29, 0xf3 } } },
    { L"EFI_CRC32_GUIDED_SECTION_EXTRACTION_GUID",                            { 0xfc1bcdb0, 0x7d31, 0x49aa, { 0x93, 0x6a, 0xa4, 0x60, 0x0d, 0x9d, 0xd0, 0x83 } } },
    { L"EFI_CRC32_GUIDED_SECTION_EXTRACTION_PROTOCOL_GUID",                   { 0xfc1bcdb0, 0x7d31, 0x49aa, { 0x93, 0x6a, 0xa4, 0x60, 0x0d, 0x9d, 0xd0, 0x83 } } },
    { L"EFI_CUSTOMIZED_DECOMPRESS_PROTOCOL_GUID",                             { 0x9a44198e, 0xa4a2, 0x44e6, { 0x8a, 0x1f, 0x39, 0xbe, 0xfd, 0xac, 0x89, 0x6f } } },
    { L"EFI_DATA_HUB_PROTOCOL_GUID",                                          { 0xae80d021, 0x618e, 0x11d4, { 0xbc, 0xd7, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_DATA_HUB_STATUS_CODE_RECORD_GUID",                                { 0xd083e94c, 0x6560, 0x42e4, { 0xb6, 0xd4, 0x2d, 0xf7, 0x5a, 0xdf, 0x6a, 0x2a } } },
    { L"EFI_DEBUG_AGENT_GUID",                                                { 0x865a5a9b, 0xb85d, 0x474c, { 0x84, 0x55, 0x65, 0xd1, 0xbe, 0x84, 0x4b, 0xe2 } } },
    { L"EFI_DEBUG_ASSERT_PROTOCOL_GUID",                                      { 0xbe499c92, 0x7d4b, 0x11d4, { 0xbc, 0xee, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_DEBUG_IMAGE_INFO_TABLE_GUID",                                     { 0x49152e77, 0x1ada, 0x4764, { 0xb7, 0xa2, 0x7a, 0xfe, 0xfe, 0xd9, 0x5e, 0x8b } } },
    { L"EFI_DEBUG_MASK_PPI_GUID",                                             { 0x3bd930fd, 0xf823, 0x4948, { 0x86, 0x91, 0x98, 0xe6, 0xfe, 0x36, 0xac, 0xe2 } } },
    { L"EFI_DEBUG_MASK_PROTOCOL_GUID",                                        { 0x4c8a2451, 0xc207, 0x405b, { 0x96, 0x94, 0x99, 0xea, 0x13, 0x25, 0x13, 0x41 } } },
    { L"EFI_DEBUGPORT_PROTOCOL_GUID",                                         { 0xeba4e8d2, 0x3858, 0x41ec, { 0xa2, 0x81, 0x26, 0x47, 0xba, 0x96, 0x60, 0xd0 } } },
    { L"EFI_DEBUG_SERIAL_IO_PROTOCOL_GUID",                                   { 0xe683dc4f, 0x09ed, 0x4f22, { 0x86, 0x6b, 0x8e, 0x40, 0x46, 0x94, 0x7c, 0x6c } } },
    { L"EFI_DEBUG_SUPPORT_PERIODIC_CALLBACK_PROTOCOL_GUID",                   { 0x9546e07c, 0x2cbb, 0x4c88, { 0x98, 0x6c, 0xcd, 0x34, 0x10, 0x86, 0xf0, 0x44 } } },
    { L"EFI_DEBUG_SUPPORT_PROTOCOL_GUID",                                     { 0x2755590c, 0x6f3c, 0x42fa, { 0x9e, 0xa4, 0xa3, 0xba, 0x54, 0x3c, 0xda, 0x25 } } },
    { L"EFI_DECOMPRESS_PROTOCOL_GUID",                                        { 0xd8117cfe, 0x94a6, 0x11d4, { 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_DEFAULT_BMP_LOGO_GUID",                                           { 0x7bb28b99, 0x61bb, 0x11d5, { 0x9a, 0x5d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_DEFERRED_IMAGE_LOAD_PROTOCOL_GUID",                               { 0x15853d7c, 0x3ddf, 0x43e0, { 0xa1, 0xcb, 0xeb, 0xf8, 0x5b, 0x8f, 0x87, 0x2c } } },
    { L"EFI_DEVICE_IO_PROTOCOL_GUID",                                         { 0xaf6ac311, 0x84c3, 0x11d2, { 0x8e, 0x3c, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_DEVICE_PATH_FROM_TEXT_PROTOCOL_GUID",                             { 0x05c99a21, 0xc70f, 0x4ad2, { 0x8a, 0x5f, 0x35, 0xdf, 0x33, 0x43, 0xf5, 0x1e } } },
    { L"EFI_DEVICE_PATH_PROTOCOL_GUID",                                       { 0x09576e91, 0x6d3f, 0x11d2, { 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_DEVICE_PATH_TO_TEXT_PROTOCOL_GUID",                               { 0x8b843e20, 0x8132, 0x4852, { 0x90, 0xcc, 0x55, 0x1a, 0x4e, 0x4a, 0x7f, 0x1c } } },
    { L"EFI_DEVICE_PATH_UTILITIES_PROTOCOL_GUID",                             { 0x0379be4e, 0xd706, 0x437d, { 0xb0, 0x37, 0xed, 0xb8, 0x2f, 0xb7, 0x72, 0xa4 } } },
    { L"EFI_DHCP4_PROTOCOL_GUID",                                             { 0x8a219718, 0x4ef5, 0x4761, { 0x91, 0xc8, 0xc0, 0xf0, 0x4b, 0xda, 0x9e, 0x56 } } },
    { L"EFI_DHCP4_SERVICE_BINDING_PROTOCOL_GUID",                             { 0x9d9a39d8, 0xbd42, 0x4a73, { 0xa4, 0xd5, 0x8e, 0xe9, 0x4b, 0xe1, 0x13, 0x80 } } },
    { L"EFI_DHCP6_PROTOCOL_GUID",                                             { 0x87c8bad7, 0x0595, 0x4053, { 0x82, 0x97, 0xde, 0xde, 0x39, 0x5f, 0x5d, 0x5b } } },
    { L"EFI_DHCP6_SERVICE_BINDING_PROTOCOL_GUID",                             { 0x9fb9a8a1, 0x2f4a, 0x43a6, { 0x88, 0x9c, 0xd0, 0xf7, 0xb6, 0xc4, 0x7a, 0xd5 } } },
    { L"EFI_DISK_INFO_AHCI_INTERFACE_GUID",                                   { 0x9e498932, 0x4abc, 0x45af, { 0xa3, 0x4d, 0x02, 0x47, 0x78, 0x7b, 0xe7, 0xc6 } } },
    { L"EFI_DISK_INFO_IDE_INTERFACE_GUID",                                    { 0x5e948fe3, 0x26d3, 0x42b5, { 0xaf, 0x17, 0x61, 0x02, 0x87, 0x18, 0x8d, 0xec } } },
    { L"EFI_DISK_INFO_NVME_INTERFACE_GUID",                                   { 0x3ab14680, 0x5d3f, 0x4a4d, { 0xbc, 0xdc, 0xcc, 0x38, 0x00, 0x18, 0xc7, 0xf7 } } },
    { L"EFI_DISK_INFO_PROTOCOL_GUID",                                         { 0xd432a67f, 0x14dc, 0x484b, { 0xb3, 0xbb, 0x3f, 0x02, 0x91, 0x84, 0x93, 0x27 } } },
    { L"EFI_DISK_INFO_SCSI_INTERFACE_GUID",                                   { 0x08f74baa, 0xea36, 0x41d9, { 0x95, 0x21, 0x21, 0xa7, 0x0f, 0x87, 0x80, 0xbc } } },
    { L"EFI_DISK_INFO_USB_INTERFACE_GUID",                                    { 0xcb871572, 0xc11a, 0x47b5, { 0xb4, 0x92, 0x67, 0x5e, 0xaf, 0xa7, 0x77, 0x27 } } },
    { L"EFI_DISK_IO2_PROTOCOL_GUID",                                          { 0x151c8eae, 0x7f2c, 0x472c, { 0x9e, 0x54, 0x98, 0x28, 0x19, 0x4f, 0x6a, 0x88 } } },
    { L"EFI_DISK_IO_PROTOCOL_GUID",                                           { 0xce345171, 0xba0b, 0x11d2, { 0x8e, 0x4f, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_DMI_FORMAT_FRU_GUID",                                             { 0x67ef7a73, 0x2594, 0x4a5e, { 0x93, 0x0a, 0xe1, 0x66, 0xfa, 0xbc, 0xd2, 0xc8 } } },
    { L"EFI_DPC_PROTOCOL_GUID",                                               { 0x480f8ae9, 0x0c46, 0x4aa9, { 0xbc, 0x89, 0xdb, 0x9f, 0xba, 0x61, 0x98, 0x06 } } },
    { L"EFI_DRIVER_BINDING_PROTOCOL_GUID",                                    { 0x18a031ab, 0xb443, 0x4d1a, { 0xa5, 0xc0, 0x0c, 0x09, 0x26, 0x1e, 0x9f, 0x71 } } },
    { L"EFI_DRIVER_CONFIGURATION2_PROTOCOL_GUID",                             { 0xbfd7dc1d, 0x24f1, 0x40d9, { 0x82, 0xe7, 0x2e, 0x09, 0xbb, 0x6b, 0x4e, 0xbe } } },
    { L"EFI_DRIVER_CONFIGURATION_PROTOCOL_GUID",                              { 0x107a772b, 0xd5e1, 0x11d4, { 0x9a, 0x46, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_DRIVER_DIAGNOSTICS2_PROTOCOL_GUID",                               { 0x4d330321, 0x025f, 0x4aac, { 0x90, 0xd8, 0x5e, 0xd9, 0x00, 0x17, 0x3b, 0x63 } } },
    { L"EFI_DRIVER_DIAGNOSTICS_PROTOCOL_GUID",                                { 0x0784924f, 0xe296, 0x11d4, { 0x9a, 0x49, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_DRIVER_DIAGNOSTICS_PROTOCOL_GUID",                                { 0x4d330321, 0x025f, 0x4aac, { 0x90, 0xd8, 0x5e, 0xd9, 0x00, 0x17, 0x3b, 0x63 } } },
    { L"EFI_DRIVER_FAMILY_OVERRIDE_PROTOCOL_GUID",                            { 0xb1ee129e, 0xda36, 0x4181, { 0x91, 0xf8, 0x04, 0xa4, 0x92, 0x37, 0x66, 0xa7 } } },
    { L"EFI_DRIVER_HEALTH_PROTOCOL_GUID",                                     { 0x2a534210, 0x9280, 0x41d8, { 0xae, 0x79, 0xca, 0xda, 0x01, 0xa2, 0xb1, 0x27 } } },
    { L"EFI_DRIVER_SUPPORTED_EFI_VERSION_PROTOCOL_GUID",                      { 0x5c198761, 0x16a8, 0x4e69, { 0x97, 0x2c, 0x89, 0xd6, 0x79, 0x54, 0xf8, 0x1d } } },
    { L"EFI_DXE_CMOS_ACCESS_GUID",                                            { 0x9851740c, 0x22e0, 0x440d, { 0x90, 0x90, 0xef, 0x2d, 0x71, 0xc2, 0x51, 0xc9 } } },
    { L"EFI_DXE_IPL_PPI_GUID",                                                { 0x0ae8ce5d, 0xe448, 0x4437, { 0xa8, 0xd7, 0xeb, 0xf5, 0xf1, 0x94, 0xf7, 0x31 } } },
    { L"EFI_DXE_SERVICES_TABLE_GUID",                                         { 0x05ad34ba, 0x6f02, 0x4214, { 0x95, 0x2e, 0x4d, 0xa0, 0x39, 0x8e, 0x2b, 0xb9 } } },
    { L"EFI_DXE_SMM_READY_TO_LOCK_PROTOCOL_GUID",                             { 0x60ff8964, 0xe906, 0x41d0, { 0xaf, 0xed, 0xf2, 0x41, 0xe9, 0x74, 0xe0, 0x8e } } },
    { L"EFI_EAP_MANAGEMENT_PROTOCOL_GUID",                                    { 0xbb62e663, 0x625d, 0x40b2, { 0xa0, 0x88, 0xbb, 0xe8, 0x36, 0x23, 0xa2, 0x45 } } },
    { L"EFI_EAP_PROTOCOL_GUID",                                               { 0x5d9f96db, 0xe731, 0x4caa, { 0xa0, 0x0d, 0x72, 0xe1, 0x87, 0xcd, 0x77, 0x62 } } },
    { L"EFI_EBC_INTERPRETER_PROTOCOL_GUID",                                   { 0x13ac6dd1, 0x73d0, 0x11d4, { 0xb0, 0x6b, 0x00, 0xaa, 0x00, 0xbd, 0x6d, 0xe7 } } },
    { L"EFI_EBC_SIMPLE_DEBUGGER_PROTOCOL_GUID",                               { 0x2a72d11e, 0x7376, 0x40f6, { 0x9c, 0x68, 0x23, 0xfa, 0x2f, 0xe3, 0x63, 0xf1 } } },
    { L"EFI_EBC_VM_TEST_PROTOCOL_GUID",                                       { 0xaaeaccfd, 0xf27b, 0x4c17, { 0xb6, 0x10, 0x75, 0xca, 0x1f, 0x2d, 0xfb, 0x52 } } },
    { L"EFI_EDID_ACTIVE_PROTOCOL_GUID",                                       { 0xbd8c1056, 0x9f36, 0x44ec, { 0x92, 0xa8, 0xa6, 0x33, 0x7f, 0x81, 0x79, 0x86 } } },
    { L"EFI_EDID_DISCOVERED_PROTOCOL_GUID",                                   { 0x1c0c34f6, 0xd380, 0x41fa, { 0xa0, 0x49, 0x8a, 0xd0, 0x6c, 0x1a, 0x66, 0xaa } } },
    { L"EFI_EDID_OVERRIDE_PROTOCOL_GUID",                                     { 0x48ecb431, 0xfb72, 0x45c0, { 0xa9, 0x22, 0xf4, 0x58, 0xfe, 0x04, 0x0b, 0xd5 } } },
    { L"EFI_EMUL6064KBDINPUT_PROTOCOL_GUID",                                  { 0x62ceef5a, 0x1d7c, 0x4943, { 0x9b, 0x3a, 0x95, 0xe2, 0x49, 0x4c, 0x89, 0x90 } } },
    { L"EFI_EMUL6064MSINPUT_PROTOCOL_GUID",                                   { 0x7578b307, 0xb25b, 0x44f9, { 0x89, 0x2e, 0x20, 0x9b, 0x0e, 0x39, 0x93, 0xc6 } } },
    { L"EFI_EMUL6064TRAP_PROTOCOL_GUID",                                      { 0x6ea0f71c, 0x614a, 0x437e, { 0x8f, 0x49, 0x24, 0x3a, 0xd4, 0xe8, 0x32, 0x68 } } },
    { L"EFI_EMU_PHYSICAL_DISK_GUID",                                          { 0xf2ba331a, 0x8985, 0x11db, { 0xa4, 0x06, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35 } } },
    { L"EFI_EMU_SYSTEM_CONFIG_GUID",                                          { 0x9c4fb516, 0x3a1e, 0xd847, { 0xa1, 0xa1, 0x70, 0x58, 0xb6, 0x98, 0x67, 0x32 } } },
    { L"EFI_EMU_VIRTUAL_DISK_GUID",                                           { 0xf2ba331a, 0x8985, 0x11db, { 0xa4, 0x06, 0x00, 0x40, 0xd0, 0x2b, 0x18, 0x35 } } },
    { L"EFI_END_OF_DXE_EVENT_GROUP_GUID",                                     { 0x02ce967a, 0xdd7e, 0x4ffc, { 0x9e, 0xe7, 0x81, 0x0c, 0xf0, 0x47, 0x08, 0x80 } } },
    { L"EFI_ERROR_SECTION_DIRECTED_IO_DMAR_GUID",                             { 0x71761d37, 0x32b2, 0x45cd, { 0xa7, 0xd0, 0xb0, 0xfe, 0xdd, 0x93, 0xe8, 0xcf } } },
    { L"EFI_ERROR_SECTION_DMAR_GENERIC_GUID",                                 { 0x5b51fef7, 0xc79d, 0x4434, { 0x8f, 0x1b, 0xaa, 0x62, 0xde, 0x3e, 0x2c, 0x64 } } },
    { L"EFI_ERROR_SECTION_FW_ERROR_RECORD_GUID",                              { 0x81212a96, 0x09ed, 0x4996, { 0x94, 0x71, 0x8d, 0x72, 0x9c, 0x8e, 0x69, 0xed } } },
    { L"EFI_ERROR_SECTION_IOMMU_DMAR_GUID",                                   { 0x036f84e1, 0x7f37, 0x428c, { 0xa7, 0x9e, 0x57, 0x5f, 0xdf, 0xaa, 0x84, 0xec } } },
    { L"EFI_ERROR_SECTION_PCI_DEVICE_GUID",                                   { 0xeb5e4685, 0xca66, 0x4769, { 0xb6, 0xa2, 0x26, 0x06, 0x8b, 0x00, 0x13, 0x26 } } },
    { L"EFI_ERROR_SECTION_PCIE_GUID",                                         { 0xd995e954, 0xbbc1, 0x430f, { 0xad, 0x91, 0xb4, 0x4d, 0xcb, 0x3c, 0x6f, 0x35 } } },
    { L"EFI_ERROR_SECTION_PCI_PCIX_BUS_GUID",                                 { 0xc5753963, 0x3b84, 0x4095, { 0xbf, 0x78, 0xed, 0xda, 0xd3, 0xf9, 0xc9, 0xdd } } },
    { L"EFI_ERROR_SECTION_PLATFORM_MEMORY_GUID",                              { 0xa5bc1114, 0x6f64, 0x4ede, { 0xb8, 0x63, 0x3e, 0x83, 0xed, 0x7c, 0x83, 0xb1 } } },
    { L"EFI_ERROR_SECTION_PROCESSOR_GENERIC_GUID",                            { 0x9876ccad, 0x47b4, 0x4bdb, { 0xb6, 0x5e, 0x16, 0xf1, 0x93, 0xc4, 0xf3, 0xdb } } },
    { L"EFI_ERROR_SECTION_PROCESSOR_SPECIFIC_GUID",                           { 0xdc3ea0b0, 0xa144, 0x4797, { 0xb9, 0x5b, 0x53, 0xfa, 0x24, 0x2b, 0x6e, 0x1d } } },
    { L"EFI_EVENT_GROUP_DXE_DISPATCH_GUID",                                   { 0x7081e22f, 0xcac6, 0x4053, { 0x94, 0x68, 0x67, 0x57, 0x82, 0xcf, 0x88, 0xe5 } } },
    { L"EFI_EVENT_LEGACY_BOOT_GUID",                                          { 0x2a571201, 0x4966, 0x47f6, { 0x8b, 0x86, 0xf3, 0x1e, 0x41, 0xf3, 0x2f, 0x10 } } },
    { L"EFI_EVENT_NOTIFICATION_TYEP_BOOT_GUID",                               { 0x3d61a466, 0xab40, 0x409a, { 0xa6, 0x98, 0xf3, 0x62, 0xd4, 0x64, 0xb3, 0x8f } } },
    { L"EFI_EVENT_NOTIFICATION_TYEP_CMC_GUID",                                { 0x2dce8bb1, 0xbdd7, 0x450e, { 0xb9, 0xad, 0x9c, 0xf4, 0xeb, 0xd4, 0xf8, 0x90 } } },
    { L"EFI_EVENT_NOTIFICATION_TYEP_CPE_GUID",                                { 0x4e292f96, 0xd843, 0x4a55, { 0xa8, 0xc2, 0xd4, 0x81, 0xf2, 0x7e, 0xbe, 0xee } } },
    { L"EFI_EVENT_NOTIFICATION_TYEP_DMAR_GUID",                               { 0x667dd791, 0xc6b3, 0x4c27, { 0x8a, 0x6b, 0x0f, 0x8e, 0x72, 0x2d, 0xeb, 0x41 } } },
    { L"EFI_EVENT_NOTIFICATION_TYEP_INIT_GUID",                               { 0xcc5263e8, 0x9308, 0x454a, { 0x89, 0xd0, 0x34, 0x0b, 0xd3, 0x9b, 0xc9, 0x8e } } },
    { L"EFI_EVENT_NOTIFICATION_TYEP_MCE_GUID",                                { 0xe8f56ffe, 0x919c, 0x4cc5, { 0xba, 0x88, 0x65, 0xab, 0xe1, 0x49, 0x13, 0xbb } } },
    { L"EFI_EVENT_NOTIFICATION_TYEP_NMI_GUID",                                { 0x5bad89ff, 0xb7e6, 0x42c9, { 0x81, 0x4a, 0xcf, 0x24, 0x85, 0xd6, 0xe9, 0x8a } } },
    { L"EFI_EVENT_NOTIFICATION_TYEP_PCIE_GUID",                               { 0xcf93c01f, 0x1a16, 0x4dfc, { 0xb8, 0xbc, 0x9c, 0x4d, 0xaf, 0x67, 0xc1, 0x04 } } },
    { L"EFI_EXTENDED_SAL_BASE_IO_SERVICES_PROTOCOL_GUID",                     { 0x5aea42b5, 0x31e1, 0x4515, { 0xbc, 0x31, 0xb8, 0xd5, 0x25, 0x75, 0x65, 0xa6 } } },
    { L"EFI_EXTENDED_SAL_BASE_SERVICES_PROTOCOL_GUID",                        { 0xd9e9fa06, 0x0fe0, 0x41c3, { 0x96, 0xfb, 0x83, 0x42, 0x5a, 0x33, 0x94, 0xf8 } } },
    { L"EFI_EXTENDED_SAL_CACHE_SERVICES_PROTOCOL_GUID",                       { 0x0edc9494, 0x2743, 0x4ba5, { 0x88, 0x18, 0x0a, 0xef, 0x52, 0x13, 0xf1, 0x88 } } },
    { L"EFI_EXTENDED_SAL_ELOG_SERVICES_PROTOCOL_GUID",                        { 0xd5e4ee5f, 0x3e0a, 0x453c, { 0xa7, 0x25, 0xb6, 0x92, 0xbb, 0x06, 0x36, 0x5a } } },
    { L"EFI_EXTENDED_SAL_FV_BLOCK_SERVICES_PROTOCOL_GUID",                    { 0xa2271df1, 0xbcbb, 0x4f1d, { 0x98, 0xa9, 0x06, 0xbc, 0x17, 0x2f, 0x07, 0x1a } } },
    { L"EFI_EXTENDED_SAL_LOCK_SERVICES_PROTOCOL_GUID",                        { 0x76b75c23, 0xfe4f, 0x4e17, { 0xa2, 0xad, 0x1a, 0x65, 0x3d, 0xbb, 0x49, 0x4a } } },
    { L"EFI_EXTENDED_SAL_MCA_LOG_SERVICES_PROTOCOL_GUID",                     { 0xcb3fd86e, 0x38a3, 0x4c03, { 0x9a, 0x5c, 0x90, 0xcf, 0xa3, 0xa2, 0xab, 0x7a } } },
    { L"EFI_EXTENDED_SAL_MCA_SERVICES_PROTOCOL_GUID",                         { 0x2a591128, 0x6cc7, 0x42b1, { 0x8a, 0xf0, 0x58, 0x93, 0x3b, 0x68, 0x2d, 0xbb } } },
    { L"EFI_EXTENDED_SAL_MP_SERVICES_PROTOCOL_GUID",                          { 0x697d81a2, 0xcf18, 0x4dc0, { 0x9e, 0x0d, 0x06, 0x11, 0x3b, 0x61, 0x8a, 0x3f } } },
    { L"EFI_EXTENDED_SAL_MTC_SERVICES_PROTOCOL_GUID",                         { 0x899afd18, 0x75e8, 0x408b, { 0xa4, 0x1a, 0x6e, 0x2e, 0x7e, 0xcd, 0xf4, 0x54 } } },
    { L"EFI_EXTENDED_SAL_PAL_SERVICES_PROTOCOL_GUID",                         { 0xe1cd9d21, 0x0fc2, 0x438d, { 0x97, 0x03, 0x04, 0xe6, 0x6d, 0x96, 0x1e, 0x57 } } },
    { L"EFI_EXTENDED_SAL_PCI_SERVICES_PROTOCOL_GUID",                         { 0xa46b1a31, 0xad66, 0x4905, { 0x92, 0xf6, 0x2b, 0x46, 0x59, 0xdc, 0x30, 0x63 } } },
    { L"EFI_EXTENDED_SAL_RESET_SERVICES_PROTOCOL_GUID",                       { 0x7d019990, 0x8ce1, 0x46f5, { 0xa7, 0x76, 0x3c, 0x51, 0x98, 0x67, 0x6a, 0xa0 } } },
    { L"EFI_EXTENDED_SAL_RTC_SERVICES_PROTOCOL_GUID",                         { 0x7e97a470, 0xefdb, 0x4d02, { 0x8f, 0xce, 0x61, 0x90, 0xd2, 0x7b, 0xa2, 0x96 } } },
    { L"EFI_EXTENDED_SAL_SENSOR_SERVICES_PROTOCOL_GUID",                      { 0x4a153b6e, 0x85a1, 0x4982, { 0x98, 0xf4, 0x6a, 0x8c, 0xfc, 0xa4, 0xab, 0xa1 } } },
    { L"EFI_EXTENDED_SAL_SM_COM_LAYER_SERVICES_PROTOCOL_GUID",                { 0x04356799, 0x81b7, 0x4e08, { 0xa3, 0x8d, 0xd9, 0x78, 0xfa, 0x47, 0xba, 0x42 } } },
    { L"EFI_EXTENDED_SAL_SST_GUID",                                           { 0x38802700, 0x868a, 0x4b4e, { 0x81, 0xd4, 0x4f, 0x1b, 0xdc, 0xcf, 0xb4, 0x6f } } },
    { L"EFI_EXTENDED_SAL_STALL_SERVICES_PROTOCOL_GUID",                       { 0x53a58d06, 0xac27, 0x4d8c, { 0xb5, 0xe9, 0xf0, 0x8a, 0x80, 0x65, 0x41, 0x70 } } },
    { L"EFI_EXTENDED_SAL_STATUS_CODE_SERVICES_PROTOCOL_GUID",                 { 0x00dbd91d, 0x55e9, 0x420f, { 0x96, 0x39, 0x5e, 0x9f, 0x84, 0x37, 0xb4, 0x4f } } },
    { L"EFI_EXTENDED_SAL_VARIABLE_SERVICES_PROTOCOL_GUID",                    { 0x4ecb6c53, 0xc641, 0x4370, { 0x8c, 0xb2, 0x3b, 0x0e, 0x49, 0x6e, 0x83, 0x78 } } },
    { L"EFI_EXTENDED_SAL_VIRTUAL_SERVICES_PROTOCOL_GUID",                     { 0xc1a74056, 0x260e, 0x4871, { 0xa0, 0x31, 0xe6, 0x45, 0xa6, 0x5b, 0x6e, 0x11 } } },
    { L"EFI_EXT_SCSI_PASS_THRU_PROTOCOL_GUID",                                { 0x143b7632, 0xb81b, 0x4cb7, { 0xab, 0xd3, 0xb6, 0x25, 0xa5, 0xb9, 0xbf, 0xfe } } },
    { L"EFI_FAULT_TOLERANT_WRITE_PROTOCOL_GUID",                              { 0x3ebd9e82, 0x2c78, 0x4de6, { 0x97, 0x86, 0x8d, 0x4b, 0xfc, 0xb7, 0xc8, 0x81 } } },
    { L"EFI_FFS_VOLUME_TOP_FILE_GUID",                                        { 0x1ba0062e, 0xc779, 0x4582, { 0x85, 0x66, 0x33, 0x6a, 0xe8, 0xf7, 0x8f, 0x09 } } },
    { L"EFI_FILE_SYSTEM_INFO_ID_GUID",                                        { 0x09576e93, 0x6d3f, 0x11d2, { 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_FILE_SYSTEM_VOLUME_LABEL_INFO_ID_GUID",                           { 0xdb47d7d3, 0xfe81, 0x11d3, { 0x9a, 0x35, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_FIND_FV_PPI_GUID",                                                { 0x36164812, 0xa023, 0x44e5, { 0xbd, 0x85, 0x05, 0xbf, 0x3c, 0x77, 0x00, 0xaa } } },
    { L"EFI_FIRMWARE_CONTENTS_SIGNED_GUID",                                   { 0x0f9d89e8, 0x9259, 0x4f76, { 0xa5, 0xaf, 0x0c, 0x89, 0xe3, 0x40, 0x23, 0xdf } } },
    { L"EFI_FIRMWARE_FILE_SYSTEM2_GUID",                                      { 0x8c8ce578, 0x8a3d, 0x4f1c, { 0x99, 0x35, 0x89, 0x61, 0x85, 0xc3, 0x2d, 0xd3 } } },
    { L"EFI_FIRMWARE_FILE_SYSTEM3_GUID",                                      { 0x5473c07a, 0x3dcb, 0x4dca, { 0xbd, 0x6f, 0x1e, 0x96, 0x89, 0xe7, 0x34, 0x9a } } },
    { L"EFI_FIRMWARE_FILE_SYSTEM_GUID",                                       { 0x7a9354d9, 0x0468, 0x444a, { 0x81, 0xce, 0x0b, 0xf6, 0x17, 0xd8, 0x90, 0xdf } } },
    { L"EFI_FIRMWARE_MANAGEMENT_CAPSULE_ID_GUID",                             { 0x6dcbd5ed, 0xe82d, 0x4c44, { 0xbd, 0xa1, 0x71, 0x94, 0x19, 0x9a, 0xd9, 0x2a } } },
    { L"EFI_FIRMWARE_MANAGEMENT_PROTOCOL_GUID",                               { 0x86c77a67, 0x0b97, 0x4633, { 0xa1, 0x87, 0x49, 0x10, 0x4d, 0x06, 0x85, 0xc7 } } },
    { L"EFI_FIRMWARE_PERFORMANCE_GUID",                                       { 0xc095791a, 0x3001, 0x47b2, { 0x80, 0xc9, 0xea, 0xc7, 0x31, 0x9f, 0x2f, 0xa4 } } },
    { L"EFI_FIRMWARE_VOLUME2_PROTOCOL_GUID",                                  { 0x220e73b6, 0x6bdb, 0x4413, { 0x84, 0x05, 0xb9, 0x74, 0xb1, 0x08, 0x61, 0x9a } } },
    { L"EFI_FIRMWARE_VOLUME_BLOCK2_PROTOCOL_GUID",                            { 0x8f644fa9, 0xe850, 0x4db1, { 0x9c, 0xe2, 0x0b, 0x44, 0x69, 0x8e, 0x8d, 0xa4 } } },
    { L"EFI_FIRMWARE_VOLUME_BLOCK_PROTOCOL_GUID",                             { 0x8f644fa9, 0xe850, 0x4db1, { 0x9c, 0xe2, 0x0b, 0x44, 0x69, 0x8e, 0x8d, 0xa4 } } },
    { L"EFI_FIRMWARE_VOLUME_DISPATCH_PROTOCOL_GUID",                          { 0x7aa35a69, 0x506c, 0x444f, { 0xa7, 0xaf, 0x69, 0x4b, 0xf5, 0x6f, 0x71, 0xc8 } } },
    { L"EFI_FIRMWARE_VOLUME_PROTOCOL_GUID",                                   { 0x389f751f, 0x1838, 0x4388, { 0x83, 0x90, 0xcd, 0x81, 0x54, 0xbd, 0x27, 0xf8 } } },
    { L"EFI_FLASH_MAP_HOB_GUID",                                              { 0xb091e7d2, 0x05a0, 0x4198, { 0x94, 0xf0, 0x74, 0xb7, 0xb8, 0xc5, 0x54, 0x59 } } },
    { L"EFI_FORM_BROWSER2_PROTOCOL_GUID",                                     { 0xb9d4c360, 0xbcfb, 0x4f9b, { 0x92, 0x98, 0x53, 0xc1, 0x36, 0x98, 0x22, 0x58 } } },
    { L"EFI_FORM_BROWSER_COMPATIBILITY_PROTOCOL_GUID",                        { 0x0fb7c852, 0xadca, 0x4853, { 0x8d, 0x0f, 0xfb, 0xa7, 0x1b, 0x1c, 0xe1, 0x1a } } },
    { L"EFI_FORM_BROWSER_PROTOCOL_GUID",                                      { 0x0fb7c852, 0xadca, 0x4853, { 0x8d, 0x0f, 0xfb, 0xa7, 0x1b, 0x1c, 0xe1, 0x1a } } },
    { L"EFI_FORM_BROWSER_PROTOCOL_GUID",                                      { 0xe5a1333e, 0xe1b4, 0x4d55, { 0xce, 0xeb, 0x35, 0xc3, 0xef, 0x13, 0x34, 0x43 } } },
    { L"EFI_FORM_CALLBACK_PROTOCOL_GUID",                                     { 0xf3e4543d, 0xcf35, 0x6cef, { 0x35, 0xc4, 0x4f, 0xe6, 0x34, 0x4d, 0xfc, 0x54 } } },
    { L"EFI_FRAMEWORK_DEVICE_PATH_GUID",                                      { 0xb7084e63, 0x46b7, 0x4d1a, { 0x86, 0x77, 0xe3, 0x0b, 0x53, 0xdb, 0xf0, 0x50 } } },
    { L"EFI_FTP4_PROTOCOL_GUID",                                              { 0xeb338826, 0x681b, 0x4295, { 0xb3, 0x56, 0x2b, 0x36, 0x4c, 0x75, 0x7b, 0x09 } } },
    { L"EFI_FTP4_SERVICE_BINDING_PROTOCOL_GUID",                              { 0x0faaecb1, 0x226e, 0x4782, { 0xaa, 0xce, 0x7d, 0xb9, 0xbc, 0xbf, 0x4d, 0xaf } } },
    { L"EFI_FTW_LITE_PROTOCOL_GUID",                                          { 0x3f557189, 0x8dae, 0x45ae, { 0xa0, 0xb3, 0x2b, 0x99, 0xca, 0x7a, 0xa7, 0xa0 } } },
    { L"EFI_FVB_EXTENSION_PROTOCOL_GUID",                                     { 0x53a4c71b, 0xb581, 0x4170, { 0x91, 0xb3, 0x8d, 0xb8, 0x7a, 0x4b, 0x5c, 0x46 } } },
    { L"EFI_GENERIC_MEMORY_TEST_PROTOCOL_GUID",                               { 0x309de7f1, 0x7f5e, 0x4ace, { 0xb4, 0x9c, 0x53, 0x1b, 0xe5, 0xaa, 0x95, 0xef } } },
    { L"EFI_GENERIC_VARIABLE_GUID",                                           { 0x59d1c24f, 0x50f1, 0x401a, { 0xb1, 0x01, 0xf3, 0x3e, 0x0d, 0xae, 0xd4, 0x43 } } },
    { L"EFI_GLOBAL_NVS_AREA_PROTOCOL_GUID",                                   { 0x074e1e48, 0x8132, 0x47a1, { 0x8c, 0x2c, 0x3f, 0x14, 0xad, 0x9a, 0x66, 0xdc } } },
    { L"EFI_GLOBAL_VARIABLE_GUID",                                            { 0x8be4df61, 0x93ca, 0x11d2, { 0xaa, 0x0d, 0x00, 0xe0, 0x98, 0x03, 0x2b, 0x8c } } },
    { L"EFI_GPIO_PROTOCOL_GUID",                                              { 0xb5d09084, 0x80ad, 0x4759, { 0xb5, 0x1c, 0x27, 0x54, 0x8a, 0xfb, 0x8b, 0x8d } } },
    { L"EFI_GRAPHICS_OUTPUT_PROTOCOL_GUID",                                   { 0x9042a9de, 0x23dc, 0x4a38, { 0x96, 0xfb, 0x7a, 0xde, 0xd0, 0x80, 0x51, 0x6a } } },
    { L"EFI_GUID",                                                            { 0x1e753e16, 0xdcef, 0x47d0, { 0x9a, 0x38, 0x7a, 0xde, 0xcd, 0xb9, 0x83, 0xed } } },
    { L"EFI_GUID",                                                            { 0x8983fd2d, 0x113c, 0x4e2b, { 0x8f, 0x47, 0x0a, 0xbf, 0xeb, 0x20, 0xa4, 0x1a } } },
    { L"EFI_GUID",                                                            { 0x8ff925f1, 0x8624, 0x4d38, { 0x9e, 0xd2, 0xf8, 0xf5, 0xaa, 0x94, 0xf8, 0x4a } } },
    { L"EFI_GUID",                                                            { 0xa6a72875, 0x2962, 0x4c18, { 0x9f, 0x46, 0x8d, 0xa6, 0x44, 0xcc, 0xfe, 0x00 } } },
    { L"EFI_GUID",                                                            { 0xbb2f3c9d, 0xc7a1, 0x4283, { 0x8a, 0xe2, 0x4f, 0x43, 0x62, 0x99, 0x0e, 0x2e } } },
    { L"EFI_GUID",                                                            { 0xc1bdd34e, 0x9ec0, 0x48aa, { 0x80, 0x6a, 0x6c, 0x2e, 0xba, 0x0d, 0xc4, 0x45 } } },
    { L"EFI_HARDWARE_ERROR_VARIABLE_GUID",                                    { 0x414e6bdd, 0xe47b, 0x47cc, { 0xb2, 0x44, 0xbb, 0x61, 0x02, 0x0c, 0xf5, 0x16 } } },
    { L"EFI_HASH_ALGORITHM_SHA1_GUID",                                        { 0x2ae9d80f, 0x3fb2, 0x4095, { 0xb7, 0xb1, 0xe9, 0x31, 0x57, 0xb9, 0x46, 0xb6 } } },
    { L"EFI_HASH_ALGORITHM_SHA1_NOPAD_GUID",                                  { 0x24c5dc2f, 0x53e2, 0x40ca, { 0x9e, 0xd6, 0xa5, 0xd9, 0xa4, 0x9f, 0x46, 0x3b } } },
    { L"EFI_HASH_ALGORITHM_SHA224_GUID",                                      { 0x8df01a06, 0x9bd5, 0x4bf7, { 0xb0, 0x21, 0xdb, 0x4f, 0xd9, 0xcc, 0xf4, 0x5b } } },
    { L"EFI_HASH_ALGORITHM_SHA256_GUID",                                      { 0x51aa59de, 0xfdf2, 0x4ea3, { 0xbc, 0x63, 0x87, 0x5f, 0xb7, 0x84, 0x2e, 0xe9 } } },
    { L"EFI_HASH_ALGORITHM_SHA256_NOPAD_GUID",                                { 0x8628752a, 0x6cb7, 0x4814, { 0x96, 0xfc, 0x24, 0xa8, 0x15, 0xac, 0x22, 0x26 } } },
    { L"EFI_HASH_ALGORITHM_SHA384_GUID",                                      { 0xefa96432, 0xde33, 0x4dd2, { 0xae, 0xe6, 0x32, 0x8c, 0x33, 0xdf, 0x77, 0x7a } } },
    { L"EFI_HASH_ALGORITHM_SHA512_GUID",                                      { 0xcaa4381e, 0x750c, 0x4770, { 0xb8, 0x70, 0x7a, 0x23, 0xb4, 0xe4, 0x21, 0x30 } } },
    { L"EFI_HASH_ALGORTIHM_MD5_GUID",                                         { 0x0af7c79c, 0x65b5, 0x4319, { 0xb0, 0xae, 0x44, 0xec, 0x48, 0x4e, 0x4a, 0xd7 } } },
    { L"EFI_HASH_PROTOCOL_GUID",                                              { 0xc5184932, 0xdba5, 0x46db, { 0xa5, 0xba, 0xcc, 0x0b, 0xda, 0x9c, 0x14, 0x35 } } },
    { L"EFI_HASH_SERVICE_BINDING_PROTOCOL_GUID",                              { 0x42881c98, 0xa4f3, 0x44b0, { 0xa3, 0x9d, 0xdf, 0xa1, 0x86, 0x67, 0xd8, 0xcd } } },
    { L"EFI_HII_COMPATIBILITY_PROTOCOL_GUID",                                 { 0x5542cce1, 0xdf5c, 0x4d1b, { 0xab, 0xca, 0x36, 0x4f, 0x77, 0xd3, 0x99, 0xfb } } },
    { L"EFI_HII_CONFIG_ACCESS_PROTOCOL_GUID",                                 { 0x330d4706, 0xf2a0, 0x4e4f, { 0xa3, 0x69, 0xb6, 0x6f, 0xa8, 0xd5, 0x43, 0x85 } } },
    { L"EFI_HII_CONFIG_ROUTING_PROTOCOL_GUID",                                { 0x587e72d7, 0xcc50, 0x4f79, { 0x82, 0x09, 0xca, 0x29, 0x1f, 0xc1, 0xa1, 0x0f } } },
    { L"EFI_HII_DATABASE_PROTOCOL_GUID",                                      { 0xef9fc172, 0xa1b2, 0x4693, { 0xb3, 0x27, 0x6d, 0x32, 0xfc, 0x41, 0x60, 0x42 } } },
    { L"EFI_HII_DRIVER_HEALTH_FORMSET_GUID",                                  { 0xf22fc20c, 0x8cf4, 0x45eb, { 0x8e, 0x06, 0xad, 0x4e, 0x50, 0xb9, 0x5d, 0xd3 } } },
    { L"EFI_HII_EXT_PROTOCOL_GUID",                                           { 0x2a57ae75, 0x8b7a, 0x4c64, { 0x86, 0x56, 0xdb, 0x51, 0xdd, 0xc3, 0x6f, 0x7b } } },
    { L"EFI_HII_FONT_PROTOCOL_GUID",                                          { 0xe9ca4775, 0x8657, 0x47fc, { 0x97, 0xe7, 0x7e, 0xd6, 0x5a, 0x08, 0x43, 0x24 } } },
    { L"EFI_HII_FRONT_PAGE_CLASS_GUID",                                       { 0x94d411b7, 0x7669, 0x45c3, { 0xba, 0x3b, 0xf3, 0xa5, 0x8a, 0x71, 0x56, 0x81 } } },
    { L"EFI_HII_IMAGE_PROTOCOL_GUID",                                         { 0x31a6406a, 0x6bdf, 0x4e46, { 0xb2, 0xa2, 0xeb, 0xaa, 0x89, 0xc4, 0x09, 0x20 } } },
    { L"EFI_HII_NEW_PROTOCOL_GUID",                                           { 0xea816d2c, 0xcee5, 0x4f02, { 0x99, 0xb5, 0xd3, 0x90, 0x5c, 0xbb, 0xd0, 0x77 } } },
    { L"EFI_HII_OLD_PROTOCOL_GUID",                                           { 0xcd361957, 0xafbe, 0x425e, { 0xa3, 0x58, 0x5f, 0x58, 0x89, 0xcf, 0xfe, 0x7b } } },
    { L"EFI_HII_PACKAGE_LIST_PROTOCOL_GUID",                                  { 0x6a1ee763, 0xd47a, 0x43b4, { 0xaa, 0xbe, 0xef, 0x1d, 0xe2, 0xab, 0x56, 0xfc } } },
    { L"EFI_HII_PLATFORM_SETUP_FORMSET_GUID",                                 { 0x93039971, 0x8545, 0x4b04, { 0xb4, 0x5e, 0x32, 0xeb, 0x83, 0x26, 0x04, 0x0e } } },
    { L"EFI_HII_PROTOCOL_GUID",                                               { 0x5542cce1, 0xdf5c, 0x4d1b, { 0xab, 0xca, 0x36, 0x4f, 0x77, 0xd3, 0x99, 0xfb } } },
    { L"EFI_HII_PROTOCOL_GUID",                                               { 0xd7ad636e, 0xb997, 0x459b, { 0xbf, 0x3f, 0x88, 0x46, 0x89, 0x79, 0x80, 0xe1 } } },
    { L"EFI_HII_SET_KEYBOARD_LAYOUT_EVENT_GUID",                              { 0x14982a4f, 0xb0ed, 0x45b8, { 0xa8, 0x11, 0x5a, 0x7a, 0x9b, 0xc2, 0x32, 0xdf } } },
    { L"EFI_HII_STANDARD_FORM_GUID",                                          { 0x3bd2f4ec, 0xe524, 0x46e4, { 0xa9, 0xd8, 0x51, 0x01, 0x17, 0x42, 0x55, 0x62 } } },
    { L"EFI_HII_STRING_PROTOCOL_GUID",                                        { 0x0fd96974, 0x23aa, 0x4cdc, { 0xb9, 0xcb, 0x98, 0xd1, 0x77, 0x50, 0x32, 0x2a } } },
    { L"EFI_HII_USER_CREDENTIAL_FORMSET_GUID",                                { 0x337f4407, 0x5aee, 0x4b83, { 0xb2, 0xa7, 0x4e, 0xad, 0xca, 0x30, 0x88, 0xcd } } },
    { L"EFI_HOB_LIST_GUID",                                                   { 0x7739f24c, 0x93d7, 0x11d4, { 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_HOB_MEMORY_ALLOC_BSP_STORE_GUID",                                 { 0x564b33cd, 0xc92a, 0x4593, { 0x90, 0xbf, 0x24, 0x73, 0xe4, 0x3c, 0x63, 0x22 } } },
    { L"EFI_HOB_MEMORY_ALLOC_MODULE_GUID",                                    { 0xf8e21975, 0x0899, 0x4f58, { 0xa4, 0xbe, 0x55, 0x25, 0xa9, 0xc6, 0xd7, 0x7a } } },
    { L"EFI_HOB_MEMORY_ALLOC_STACK_GUID",                                     { 0x4ed4bf27, 0x4092, 0x42e9, { 0x80, 0x7d, 0x52, 0x7b, 0x1d, 0x00, 0xc9, 0xbd } } },
    { L"EFI_HOT_KEYS_PROTOCOL_GUID",                                          { 0xf1e48287, 0x3fe1, 0x4535, { 0x89, 0xab, 0x48, 0xd6, 0xc3, 0xda, 0x27, 0x59 } } },
    { L"EFI_HT_BIST_HOB_GUID",                                                { 0xbe644001, 0xe7d4, 0x48b1, { 0xb0, 0x96, 0x8b, 0xa0, 0x47, 0xbc, 0x7a, 0xe7 } } },
    { L"EFI_I2C_BUS_CONFIGURATION_MANAGEMENT_PROTOCOL_GUID",                  { 0x55b71fb5, 0x17c6, 0x410e, { 0xb5, 0xbd, 0x5f, 0xa2, 0xe3, 0xd4, 0x46, 0x6b } } },
    { L"EFI_I2C_ENUMERATE_PROTOCOL_GUID",                                     { 0xda8cd7c4, 0x1c00, 0x49e2, { 0x80, 0x3e, 0x52, 0x14, 0xe7, 0x01, 0x89, 0x4c } } },
    { L"EFI_I2C_HOST_PROTOCOL_GUID",                                          { 0xa5aab9e3, 0xc727, 0x48cd, { 0x8b, 0xbf, 0x42, 0x72, 0x33, 0x85, 0x49, 0x48 } } },
    { L"EFI_I2C_IO_PROTOCOL_GUID",                                            { 0xb60a3e6b, 0x18c4, 0x46e5, { 0xa2, 0x9a, 0xc9, 0xa1, 0x06, 0x65, 0xa2, 0x8e } } },
    { L"EFI_I2C_MASTER_PROTOCOL_GUID",                                        { 0xcd72881f, 0x45b5, 0x4feb, { 0x98, 0xc8, 0x31, 0x3d, 0xa8, 0x11, 0x74, 0x62 } } },
    { L"EFI_IA32_X64_ERROR_TYPE_BUS_CHECK_GUID",                              { 0x1cf3f8b3, 0xc5b1, 0x49a2, { 0xaa, 0x59, 0x5e, 0xef, 0x92, 0xff, 0xa6, 0x3c } } },
    { L"EFI_IA32_X64_ERROR_TYPE_CACHE_CHECK_GUID",                            { 0xa55701f5, 0xe3ef, 0x43de, { 0xac, 0x72, 0x24, 0x9b, 0x57, 0x3f, 0xad, 0x2c } } },
    { L"EFI_IA32_X64_ERROR_TYPE_MS_CHECK_GUID",                               { 0x48ab7f57, 0xdc34, 0x4f6c, { 0xa7, 0xd3, 0xb0, 0xb5, 0xb0, 0xa7, 0x43, 0x14 } } },
    { L"EFI_IA32_X64_ERROR_TYPE_TLB_CHECK_GUID",                              { 0xfc06b535, 0x5e1f, 0x4562, { 0x9f, 0x25, 0x0a, 0x3b, 0x9a, 0xdb, 0x63, 0xc3 } } },
    { L"EFI_IDE_CONTROLLER_INIT_PROTOCOL_GUID",                               { 0xa1e37052, 0x80d9, 0x4e65, { 0xa3, 0x17, 0x3e, 0x9a, 0x55, 0xc4, 0x3e, 0xc9 } } },
    { L"EFI_IDER_CONTROLLER_DRIVER_PROTOCOL_GUID",                            { 0x956a2ed0, 0xa6cf, 0x409a, { 0xb8, 0xf5, 0x35, 0xf1, 0x4c, 0x3e, 0x3c, 0x02 } } },
    { L"EFI_IFR_FRAMEWORK_GUID",                                              { 0x31ca5d1a, 0xd511, 0x4931, { 0xb7, 0x82, 0xae, 0x6b, 0x2b, 0x17, 0x8c, 0xd7 } } },
    { L"EFI_IFR_REFRESH_ID_OP_GUID",                                          { 0xf5e655d9, 0x02a6, 0x46f2, { 0x9e, 0x76, 0xb8, 0xbe, 0x8e, 0x60, 0xab, 0x22 } } },
    { L"EFI_IFR_TIANO_GUID",                                                  { 0x0f0b1735, 0x87a0, 0x4193, { 0xb2, 0x66, 0x53, 0x8c, 0x38, 0xaf, 0x48, 0xce } } },
    { L"EFI_IMAGE_SECURITY_DATABASE_GUID",                                    { 0xd719b2cb, 0x3d3a, 0x4596, { 0xa3, 0xbc, 0xda, 0xd0, 0x0e, 0x67, 0x65, 0x6f } } },
    { L"EFI_INCOMPATIBLE_PCI_DEVICE_SUPPORT_PROTOCOL_GUID",                   { 0xeb23f55a, 0x7863, 0x4ac2, { 0x8d, 0x3d, 0x95, 0x65, 0x35, 0xde, 0x03, 0x75 } } },
    { L"EFI_INTEL_MFG_FORMAT_FRU_GUID",                                       { 0x79e8c9c7, 0x1152, 0x4f00, { 0xb8, 0x31, 0x14, 0xf1, 0xc4, 0x04, 0x1a, 0xe0 } } },
    { L"EFI_IOBASE_HOB_GUID",                                                 { 0xd4a28a3e, 0xdcf2, 0x43cf, { 0xa2, 0xb7, 0xf3, 0x57, 0x2a, 0x7c, 0xab, 0x09 } } },
    { L"EFI_IP4_CONFIG_PROTOCOL_GUID",                                        { 0x3b95aa31, 0x3793, 0x434b, { 0x86, 0x67, 0xc8, 0x07, 0x08, 0x92, 0xe0, 0x5e } } },
    { L"EFI_IP4_PROTOCOL_GUID",                                               { 0x41d94cd2, 0x35b6, 0x455a, { 0x82, 0x58, 0xd4, 0xe5, 0x13, 0x34, 0xaa, 0xdd } } },
    { L"EFI_IP4_SERVICE_BINDING_PROTOCOL_GUID",                               { 0xc51711e7, 0xb4bf, 0x404a, { 0xbf, 0xb8, 0x0a, 0x04, 0x8e, 0xf1, 0xff, 0xe4 } } },
    { L"EFI_IP6_CONFIG_PROTOCOL_GUID",                                        { 0x937fe521, 0x95ae, 0x4d1a, { 0x89, 0x29, 0x48, 0xbc, 0xd9, 0x0a, 0xd3, 0x1a } } },
    { L"EFI_IP6_PROTOCOL_GUID",                                               { 0x2c8759d5, 0x5c2d, 0x66ef, { 0x92, 0x5f, 0xb6, 0x6c, 0x10, 0x19, 0x57, 0xe2 } } },
    { L"EFI_IP6_SERVICE_BINDING_PROTOCOL_GUID",                               { 0xec835dd3, 0xfe0f, 0x617b, { 0xa6, 0x21, 0xb3, 0x50, 0xc3, 0xe1, 0x33, 0x88 } } },
    { L"EFI_IP_PROTOCOL_GUID",                                                { 0x89deef37, 0x31d8, 0x469c, { 0x95, 0xb6, 0x01, 0x69, 0xbc, 0x86, 0x6c, 0xfb } } },
    { L"EFI_IPSEC2_PROTOCOL_GUID",                                            { 0xa3979e64, 0xace8, 0x4ddc, { 0xbc, 0x07, 0x4d, 0x66, 0xb8, 0xfd, 0x09, 0x77 } } },
    { L"EFI_IPSEC_CONFIG_PROTOCOL_GUID",                                      { 0xce5e5929, 0xc7a3, 0x4602, { 0xad, 0x9e, 0xc9, 0xda, 0xf9, 0x4e, 0xbf, 0xcf } } },
    { L"EFI_IPSEC_PROTOCOL_GUID",                                             { 0xdfb386f7, 0xe100, 0x43ad, { 0x9c, 0x9a, 0xed, 0x90, 0xd0, 0x8a, 0x5e, 0x12 } } },
    { L"EFI_ISA_ACPI_PROTOCOL_GUID",                                          { 0x64a892dc, 0x5561, 0x4536, { 0x92, 0xc7, 0x79, 0x9b, 0xfc, 0x18, 0x33, 0x55 } } },
    { L"EFI_ISA_IO_PROTOCOL_GUID",                                            { 0x7ee2bd44, 0x3da0, 0x11d4, { 0x9a, 0x38, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_ISCSI_INITIATOR_NAME_PROTOCOL_GUID",                              { 0x59324945, 0xec44, 0x4c0d, { 0xb1, 0xcd, 0x9d, 0xb1, 0x39, 0xdf, 0x07, 0x0c } } },
    { L"EFI_KMS_FORMAT_AESCBC_128_GUID",                                      { 0xa0e8ee6a, 0x0e92, 0x44d4, { 0x86, 0x1b, 0x0e, 0xaa, 0x4a, 0xca, 0x44, 0xa2 } } },
    { L"EFI_KMS_FORMAT_AESCBC_256_GUID",                                      { 0xd7e69789, 0x1f68, 0x45e8, { 0x96, 0xef, 0x3b, 0x64, 0x07, 0xa5, 0xb2, 0xdc } } },
    { L"EFI_KMS_FORMAT_AESXTS_128_GUID",                                      { 0x4776e33f, 0xdb47, 0x479a, { 0xa2, 0x5f, 0xa1, 0xcd, 0x0a, 0xfa, 0xb3, 0x8b } } },
    { L"EFI_KMS_FORMAT_AESXTS_256_GUID",                                      { 0xdc7e8613, 0xc4bb, 0x4db0, { 0x84, 0x62, 0x13, 0x51, 0x13, 0x57, 0xab, 0xe2 } } },
    { L"EFI_KMS_FORMAT_GENERIC_1024_GUID",                                    { 0x43be0b44, 0x874b, 0x4ead, { 0xb0, 0x9c, 0x24, 0x1a, 0x4f, 0xbd, 0x7e, 0xb3 } } },
    { L"EFI_KMS_FORMAT_GENERIC_128_GUID",                                     { 0xec8a3d69, 0x6ddf, 0x4108, { 0x94, 0x76, 0x73, 0x37, 0xfc, 0x52, 0x21, 0x36 } } },
    { L"EFI_KMS_FORMAT_GENERIC_160_GUID",                                     { 0xa3b3e6f8, 0xefca, 0x4bc1, { 0x88, 0xfb, 0xcb, 0x87, 0x33, 0x9b, 0x25, 0x79 } } },
    { L"EFI_KMS_FORMAT_GENERIC_2048_GUID",                                    { 0x40093f23, 0x630c, 0x4626, { 0x9c, 0x48, 0x40, 0x37, 0x3b, 0x19, 0xcb, 0xbe } } },
    { L"EFI_KMS_FORMAT_GENERIC_256_GUID",                                     { 0x70f64793, 0xc323, 0x4261, { 0xac, 0x2c, 0xd8, 0x76, 0xf2, 0x7c, 0x53, 0x45 } } },
    { L"EFI_KMS_FORMAT_GENERIC_3072_GUID",                                    { 0xb9237513, 0x6c44, 0x4411, { 0xa9, 0x90, 0x21, 0xe5, 0x56, 0xe0, 0x5a, 0xde } } },
    { L"EFI_KMS_FORMAT_GENERIC_512_GUID",                                     { 0x978fe043, 0xd7af, 0x422e, { 0x8a, 0x92, 0x2b, 0x48, 0xe4, 0x63, 0xbd, 0xe6 } } },
    { L"EFI_KMS_FORMAT_MD2_128_GUID",                                         { 0x78be11c4, 0xee44, 0x4a22, { 0x9f, 0x05, 0x03, 0x85, 0x2e, 0xc5, 0xc9, 0x78 } } },
    { L"EFI_KMS_FORMAT_MD4_128_GUID",                                         { 0xd1c17aa1, 0xcac5, 0x400f, { 0xbe, 0x17, 0xe2, 0xa2, 0xae, 0x06, 0x67, 0x7c } } },
    { L"EFI_KMS_FORMAT_MD5_128_GUID",                                         { 0xdcbc3662, 0x9cda, 0x4b52, { 0xa0, 0x4c, 0x82, 0xeb, 0x1d, 0x23, 0x48, 0xc7 } } },
    { L"EFI_KMS_FORMAT_MD5SHA_128_GUID",                                      { 0x1c178237, 0x6897, 0x459e, { 0x9d, 0x36, 0x67, 0xce, 0x8e, 0xf9, 0x4f, 0x76 } } },
    { L"EFI_KMS_FORMAT_MDC2_128_GUID",                                        { 0xf7ad60f8, 0xefa8, 0x44a3, { 0x91, 0x13, 0x23, 0x1f, 0x39, 0x9e, 0xb4, 0xc7 } } },
    { L"EFI_KMS_FORMAT_MDC4_128_GUID",                                        { 0x3fa4f847, 0xd8eb, 0x4df4, { 0xbd, 0x49, 0x10, 0x3a, 0x0a, 0x84, 0x7b, 0xbc } } },
    { L"EFI_KMS_FORMAT_RSASHA1_1024_GUID",                                    { 0x56417bed, 0x6bbe, 0x4882, { 0x86, 0xa0, 0x3a, 0xe8, 0xbb, 0x17, 0xf8, 0xf9 } } },
    { L"EFI_KMS_FORMAT_RSASHA1_2048_GUID",                                    { 0xf66447d4, 0x75a6, 0x463e, { 0xa8, 0x19, 0x07, 0x7f, 0x2d, 0xda, 0x05, 0xe9 } } },
    { L"EFI_KMS_FORMAT_RSASHA256_2048_GUID",                                  { 0xa477af13, 0x877d, 0x4060, { 0xba, 0xa1, 0x25, 0xd1, 0xbe, 0xa0, 0x8a, 0xd3 } } },
    { L"EFI_KMS_FORMAT_RSASHA256_3072_GUID",                                  { 0x4e1356c2, 0x0eed, 0x463f, { 0x81, 0x47, 0x99, 0x33, 0xab, 0xdb, 0xc7, 0xd5 } } },
    { L"EFI_KMS_FORMAT_SHA1_160_GUID",                                        { 0x453c5e5a, 0x482d, 0x43f0, { 0x87, 0xc9, 0x59, 0x41, 0xf3, 0xa3, 0x8a, 0xc2 } } },
    { L"EFI_KMS_FORMAT_SHA256_256_GUID",                                      { 0x6bb4f5cd, 0x8022, 0x448d, { 0xbc, 0x6d, 0x77, 0x1b, 0xae, 0x93, 0x5f, 0xc6 } } },
    { L"EFI_KMS_FORMAT_SHA512_512_GUID",                                      { 0x2f240e12, 0xe14d, 0x475c, { 0x83, 0xb0, 0xef, 0xff, 0x22, 0xd7, 0x7b, 0xe7 } } },
    { L"EFI_KMS_PROTOCOL_GUID",                                               { 0xec3a978d, 0x7c4e, 0x48fa, { 0x9a, 0xbe, 0x6a, 0xd9, 0x1c, 0xc8, 0xf8, 0x11 } } },
    { L"EFI_LEGACY_8259_PROTOCOL_GUID",                                       { 0x38321dba, 0x4fe0, 0x4e17, { 0x8a, 0xec, 0x41, 0x30, 0x55, 0xea, 0xed, 0xc1 } } },
    { L"EFI_LEGACY_BIOS_EXT_PROTOCOL_GUID",                                   { 0x8e008510, 0x9bb1, 0x457d, { 0x9f, 0x70, 0x89, 0x7a, 0xba, 0x86, 0x5d, 0xb9 } } },
    { L"EFI_LEGACY_BIOS_GUID",                                                { 0x2e3044ac, 0x879f, 0x490f, { 0x97, 0x60, 0xbb, 0xdf, 0xaf, 0x69, 0x5f, 0x50 } } },
    { L"EFI_LEGACY_BIOS_PLATFORM_PROTOCOL_GUID",                              { 0x783658a3, 0x4172, 0x4421, { 0xa2, 0x99, 0xe0, 0x09, 0x07, 0x9c, 0x0c, 0xb4 } } },
    { L"EFI_LEGACY_BIOS_PROTOCOL_GUID",                                       { 0xdb9a1e3d, 0x45cb, 0x4abb, { 0x85, 0x3b, 0xe5, 0x38, 0x7f, 0xdb, 0x2e, 0x2d } } },
    { L"EFI_LEGACY_BIOS_THUNK_PROTOCOL_GUID",                                 { 0x4c51a7ba, 0x7195, 0x442d, { 0x87, 0x92, 0xbe, 0xea, 0x6e, 0x2f, 0xf6, 0xec } } },
    { L"EFI_LEGACY_DEV_ORDER_VARIABLE_GUID",                                  { 0xa56074db, 0x65fe, 0x45f7, { 0xbd, 0x21, 0x2d, 0x2b, 0xdd, 0x8e, 0x96, 0x52 } } },
    { L"EFI_LEGACY_INTERRUPT_PROTOCOL_GUID",                                  { 0x31ce593d, 0x108a, 0x485d, { 0xad, 0xb2, 0x78, 0xf2, 0x1f, 0x29, 0x66, 0xbe } } },
    { L"EFI_LEGACY_REGION2_PROTOCOL_GUID",                                    { 0x70101eaf, 0x0085, 0x440c, { 0xb3, 0x56, 0x8e, 0xe3, 0x6f, 0xef, 0x24, 0xf0 } } },
    { L"EFI_LEGACY_REGION_PROTOCOL_GUID",                                     { 0x0fc9013a, 0x0568, 0x4ba9, { 0x9b, 0x7e, 0xc9, 0xc3, 0x90, 0xa6, 0x60, 0x9b } } },
    { L"EFI_LEGACY_SREDIR_PROTOCOL_GUID",                                     { 0xa062cf1f, 0x8473, 0x4aa3, { 0x87, 0x93, 0x60, 0x0b, 0xc4, 0xff, 0xa9, 0xa9 } } },
    { L"EFI_LIGHT_ISA_IO_PROTOCOL_GUID",                                      { 0x7cc7ed80, 0x9a68, 0x4781, { 0x80, 0xe4, 0xda, 0x16, 0x99, 0x10, 0x5a, 0xfe } } },
    { L"EFI_LOADED_IMAGE_DEVICE_PATH_PROTOCOL_GUID",                          { 0xbc62157e, 0x3e33, 0x4fec, { 0x99, 0x20, 0x2d, 0x3b, 0x36, 0xd7, 0x50, 0xdf } } },
    { L"EFI_LOADED_IMAGE_PROTOCOL_GUID",                                      { 0x5b1b31a1, 0x9562, 0x11d2, { 0x8e, 0x3f, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_LOAD_FILE2_PROTOCOL_GUID",                                        { 0x4006c0c1, 0xfcb3, 0x403e, { 0x99, 0x6d, 0x4a, 0x6c, 0x87, 0x24, 0xe0, 0x6d } } },
    { L"EFI_LOAD_FILE_PROTOCOL_GUID",                                         { 0x56ec3091, 0x954c, 0x11d2, { 0x8e, 0x3f, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_LOAD_FIXED_ADDRESS_CONFIGURATION_TABLE_GUID",                     { 0x2ca88b53, 0xd296, 0x4080, { 0xa4, 0xa5, 0xca, 0xd9, 0xba, 0xe2, 0x4b, 0x09 } } },
    { L"EFI_LOCK_BOX_PROTOCOL_GUID",                                          { 0xbd445d79, 0xb7ad, 0x4f04, { 0x9a, 0xd8, 0x29, 0xbd, 0x20, 0x40, 0xeb, 0x3c } } },
    { L"EFI_MANAGED_NETWORK_PROTOCOL_GUID",                                   { 0x7ab33a91, 0xace5, 0x4326, { 0xb5, 0x72, 0xe7, 0xee, 0x33, 0xd3, 0x9f, 0x16 } } },
    { L"EFI_MANAGED_NETWORK_SERVICE_BINDING_PROTOCOL_GUID",                   { 0xf36ff770, 0xa7e1, 0x42cf, { 0x9e, 0xd2, 0x56, 0xf0, 0xf2, 0x71, 0xf4, 0x4c } } },
    { L"EFI_MEASURED_FV_HOB_GUID",                                            { 0xb2360b42, 0x7173, 0x420a, { 0x86, 0x96, 0x46, 0xca, 0x6b, 0xab, 0x10, 0x60 } } },
    { L"EFI_ME_BIOS_EXTENSION_SETUP_GUID",                                    { 0x1bad711c, 0xd451, 0x4241, { 0xb1, 0xf3, 0x85, 0x37, 0x81, 0x2e, 0x0c, 0x70 } } },
    { L"EFI_ME_FW_SKU_VARIABLE_GUID",                                         { 0xe1a21d94, 0x4a20, 0x4e0e, { 0xae, 0x09, 0xa9, 0xa2, 0x1f, 0x24, 0xbb, 0x9e } } },
    { L"EFI_MEMORY_CONFIG_DATA_GUID",                                         { 0x80dbd530, 0xb74c, 0x4f11, { 0x8c, 0x03, 0x41, 0x86, 0x65, 0x53, 0x28, 0x31 } } },
    { L"EFI_MEMORY_PRODUCER_GUID",                                            { 0x1d7add6e, 0xb2da, 0x4b0b, { 0xb2, 0x9f, 0x49, 0xcb, 0x42, 0xf4, 0x63, 0x56 } } },
    { L"EFI_MEMORY_SUBCLASS_DRIVER_GUID",                                     { 0x1767ceed, 0xdb82, 0x47cd, { 0xbf, 0x2b, 0x68, 0x45, 0x8a, 0x8c, 0xcf, 0xff } } },
    { L"EFI_MEMORY_SUBCLASS_GUID",                                            { 0x4e8f4ebb, 0x64b9, 0x4e05, { 0x9b, 0x18, 0x4c, 0xfe, 0x49, 0x23, 0x50, 0x97 } } },
    { L"EFI_MEMORY_TYPE_FRU_GUID",                                            { 0xd50234f4, 0x6f4b, 0x43e8, { 0xa0, 0x13, 0x3c, 0x1e, 0x33, 0xd9, 0xb9, 0xb1 } } },
    { L"EFI_MEMORY_TYPE_INFORMATION_GUID",                                    { 0x4c19049f, 0x4137, 0x4dd3, { 0x9c, 0x10, 0x8b, 0x97, 0xa8, 0x3f, 0xfd, 0xfa } } },
    { L"EFI_ME_RC_INFO_PROTOCOL_GUID",                                        { 0x11fbfdfb, 0x10d2, 0x43e6, { 0xb5, 0xb1, 0xb4, 0x38, 0x6e, 0xdc, 0xcb, 0x9a } } },
    { L"EFI_METRONOME_ARCH_PROTOCOL_GUID",                                    { 0x26baccb2, 0x6f42, 0x11d4, { 0xbc, 0xe7, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_MINI_SHELL_FILE_GUID",                                            { 0x86ad232b, 0xd33a, 0x465c, { 0xbf, 0x5f, 0x41, 0x37, 0x0b, 0xa9, 0x2f, 0xe2 } } },
    { L"EFI_MISC_PRODUCER_GUID",                                              { 0x62512c92, 0x63c4, 0x4d80, { 0x82, 0xb1, 0xc1, 0xa4, 0xdc, 0x44, 0x80, 0xe5 } } },
    { L"EFI_MISC_SUBCLASS_DRIVER_GUID",                                       { 0xf50e702c, 0x8653, 0x4cde, { 0xbb, 0xce, 0x43, 0xb4, 0xd5, 0x5b, 0x34, 0xb8 } } },
    { L"EFI_MISC_SUBCLASS_GUID",                                              { 0x772484b2, 0x7482, 0x4b91, { 0x9f, 0x9a, 0xad, 0x43, 0xf8, 0x1c, 0x58, 0x81 } } },
    { L"EFI_MMC_HOST_PROTOCOL_GUID",                                          { 0x3e591c00, 0x9e4a, 0x11df, { 0x92, 0x44, 0x00, 0x02, 0xa5, 0xd5, 0xc5, 0x1b } } },
    { L"EFI_MONOTONIC_COUNTER_ARCH_PROTOCOL_GUID",                            { 0x1da97072, 0xbddc, 0x4b30, { 0x99, 0xf1, 0x72, 0xa0, 0xb5, 0x6f, 0xff, 0x2a } } },
    { L"EFI_MONTONIC_COUNTER_ARCH_PROTOCOL_GUID",                             { 0x1da97072, 0xbddc, 0x4b30, { 0x99, 0xf1, 0x72, 0xa0, 0xb5, 0x6f, 0xff, 0x2a } } },
    { L"EFI_MP_SERVICES_PROTOCOL_GUID",                                       { 0x3fdda605, 0xa76e, 0x4f46, { 0xad, 0x29, 0x12, 0xf4, 0x53, 0x1b, 0x3d, 0x08 } } },
    { L"EFI_MP_SERVICES_PROTOCOL_GUID",                                       { 0xf33261e7, 0x23cb, 0x11d5, { 0xbd, 0x5c, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_MPS_TABLE_GUID",                                                  { 0xeb9d2d2f, 0x2d88, 0x11d3, { 0x9a, 0x16, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_MTFTP4_PROTOCOL_GUID",                                            { 0x78247c57, 0x63db, 0x4708, { 0x99, 0xc2, 0xa8, 0xb4, 0xa9, 0xa6, 0x1f, 0x6b } } },
    { L"EFI_MTFTP4_SERVICE_BINDING_PROTOCOL_GUID",                            { 0x2fe800be, 0x8f01, 0x4aa6, { 0x94, 0x6b, 0xd7, 0x13, 0x88, 0xe1, 0x83, 0x3f } } },
    { L"EFI_MTFTP6_PROTOCOL_GUID",                                            { 0xbf0a78ba, 0xec29, 0x49cf, { 0xa1, 0xc9, 0x7a, 0xe5, 0x4e, 0xab, 0x6a, 0x51 } } },
    { L"EFI_MTFTP6_SERVICE_BINDING_PROTOCOL_GUID",                            { 0xd9760ff3, 0x3cca, 0x4267, { 0x80, 0xf9, 0x75, 0x27, 0xfa, 0xfa, 0x42, 0x23 } } },
    { L"EFI_NB_ERROR_LOG_DISPATCH_PROTOCOL_GUID",                             { 0xff2d54d4, 0x5c55, 0x4c06, { 0x85, 0x49, 0xc3, 0x62, 0x7c, 0xb8, 0xb9, 0x95 } } },
    { L"EFI_NB_MRC_INFO_GUID",                                                { 0xd7bd52b0, 0xb2dc, 0x4f08, { 0xb4, 0x67, 0xde, 0x50, 0xd7, 0x28, 0xf6, 0xbd } } },
    { L"EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL_GUID",                      { 0x1aced566, 0x76ed, 0x4218, { 0xbc, 0x81, 0x76, 0x7f, 0x1f, 0x97, 0x7a, 0x89 } } },
    { L"EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL_GUID",                      { 0xe18541cd, 0xf755, 0x4f73, { 0x92, 0x8d, 0x64, 0x3c, 0x8a, 0x79, 0xb2, 0x29 } } },
    { L"EFI_NIC_IP4_CONFIG_NVDATA_GUID",                                      { 0x09d5b53f, 0xf4b0, 0x4f59, { 0xa0, 0xb1, 0x7b, 0x57, 0xd3, 0x5c, 0x0e, 0x05 } } },
    { L"EFI_NIC_IP4_CONFIG_PROTOCOL_GUID",                                    { 0x0dca3d4d, 0x12da, 0x4728, { 0xbf, 0x7e, 0x86, 0xce, 0xb9, 0x28, 0xd0, 0x67 } } },
    { L"EFI_NIC_IP4_CONFIG_VARIABLE_GUID",                                    { 0xd8944553, 0xc4dd, 0x41f4, { 0x9b, 0x30, 0xe1, 0x39, 0x7c, 0xfb, 0x26, 0x7b } } },
    { L"EFI_NONSMMEMUL6064TRAP_PROTOCOL_GUID",                                { 0x68b81e51, 0x2583, 0x4582, { 0x95, 0xdb, 0xc5, 0x72, 0x32, 0x36, 0xc4, 0xf1 } } },
    { L"EFI_NT_LOAD_AS_DLL_PPI_GUID",                                         { 0xccc53f6b, 0xa03a, 0x4ed8, { 0x83, 0x9a, 0x03, 0xd9, 0x9c, 0x02, 0xb4, 0xe3 } } },
    { L"EFI_NULL_GUID",                                                       { 0x00000000, 0x0000, 0x0000, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } } },
    { L"EFI_OEM_BADGING_PROTOCOL_GUID",                                       { 0x170e13c0, 0xbf1b, 0x4218, { 0x87, 0x1d, 0x2a, 0xbd, 0xc6, 0xf8, 0x87, 0xbc } } },
    { L"EFI_PART_TYPE_EFI_SYSTEM_PART_GUID",                                  { 0xc12a7328, 0xf81f, 0x11d2, { 0xba, 0x4b, 0x00, 0xa0, 0xc9, 0x3e, 0xc9, 0x3b } } },
    { L"EFI_PART_TYPE_LEGACY_MBR_GUID",                                       { 0x024dee41, 0x33e7, 0x11d3, { 0x9d, 0x69, 0x00, 0x08, 0xc7, 0x81, 0xf3, 0x9f } } },
    { L"EFI_PART_TYPE_UNUSED_GUID",                                           { 0x00000000, 0x0000, 0x0000, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } } },
    { L"EFI_PATH_FILE_NAME_GUID",                                             { 0x7644c181, 0xfa6e, 0x46da, { 0x80, 0xcb, 0x04, 0xb9, 0x90, 0x40, 0x62, 0xe8 } } },
    { L"EFI_PC_ANSI_GUID",                                                    { 0xe0c14753, 0xf9be, 0x11d2, { 0x9a, 0x0c, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_PCCARD_CS_PROTOCOL_GUID",                                         { 0xca54f443, 0x1ef2, 0x4dab, { 0x9e, 0x7e, 0x6d, 0xb7, 0xb7, 0x20, 0xb5, 0x87 } } },
    { L"EFI_PCCARD_SS_PROTOCOL_GUID",                                         { 0xc38e6d34, 0x5a7f, 0x4bf9, { 0xbe, 0x57, 0x94, 0xdd, 0x30, 0x38, 0x02, 0x76 } } },
    { L"EFI_PCD_PROTOCOL_GUID",                                               { 0x13a3f0f6, 0x264a, 0x3ef0, { 0xf2, 0xe0, 0xde, 0xc5, 0x12, 0x34, 0x2f, 0x34 } } },
    { L"EFI_PCH_INFO_PROTOCOL_GUID",                                          { 0x984eb4e9, 0x5a95, 0x41de, { 0xaa, 0xd0, 0x53, 0x66, 0x8c, 0xa5, 0x13, 0xc0 } } },
    { L"EFI_PCH_S3_IMAGE_GUID",                                               { 0x271dd6f2, 0x54cb, 0x45e6, { 0x85, 0x85, 0x8c, 0x92, 0x3c, 0x1a, 0xc7, 0x06 } } },
    { L"EFI_PCH_S3_SUPPORT_PROTOCOL_GUID",                                    { 0xe287d20b, 0xd897, 0x4e1e, { 0xa5, 0xd9, 0x97, 0x77, 0x63, 0x93, 0x6a, 0x04 } } },
    { L"EFI_PCI_ENUMERATION_COMPLETE_GUID",                                   { 0x30cfe3e7, 0x3de1, 0x4586, { 0xbe, 0x20, 0xde, 0xab, 0xa1, 0xb3, 0xb7, 0x93 } } },
    { L"EFI_PCI_EXPRESS_BASE_ADDRESS_GUID",                                   { 0x3677d529, 0x326f, 0x4603, { 0xa9, 0x26, 0xea, 0xac, 0xe0, 0x1d, 0xcb, 0xb0 } } },
    { L"EFI_PCI_HOST_BRIDGE_RESOURCE_ALLOCATION_PROTOCOL_GUID",               { 0xcf8034be, 0x6768, 0x4d8b, { 0xb7, 0x39, 0x7c, 0xce, 0x68, 0x3a, 0x9f, 0xbe } } },
    { L"EFI_PCI_HOTPLUG_DEVICE_GUID",                                         { 0x0b280816, 0x52e7, 0x4e51, { 0xaa, 0x57, 0x11, 0xbd, 0x41, 0xcb, 0xef, 0xc3 } } },
    { L"EFI_PCI_HOT_PLUG_INIT_PROTOCOL_GUID",                                 { 0xaa0e8bc1, 0xdabc, 0x46b0, { 0xa8, 0x44, 0x37, 0xb8, 0x16, 0x9b, 0x2b, 0xea } } },
    { L"EFI_PCI_HOTPLUG_REQUEST_PROTOCOL_GUID",                               { 0x19cb87ab, 0x2cb9, 0x4665, { 0x83, 0x60, 0xdd, 0xcf, 0x60, 0x54, 0xf7, 0x9d } } },
    { L"EFI_PCI_IO_PROTOCOL_GUID",                                            { 0x4cf5b200, 0x68b8, 0x4ca5, { 0x9e, 0xec, 0xb2, 0x3e, 0x3f, 0x50, 0x02, 0x9a } } },
    { L"EFI_PCI_OPTION_ROM_TABLE_GUID",                                       { 0x7462660f, 0x1cbd, 0x48da, { 0xad, 0x11, 0x91, 0x71, 0x79, 0x13, 0x83, 0x1c } } },
    { L"EFI_PCI_OVERRIDE_GUID",                                               { 0xb5b35764, 0x460c, 0x4a06, { 0x99, 0xfc, 0x77, 0xa1, 0x7c, 0x1b, 0x5c, 0xeb } } },
    { L"EFI_PCI_PLATFORM_PROTOCOL_GUID",                                      { 0x07d75280, 0x27d4, 0x4d69, { 0x90, 0xd0, 0x56, 0x43, 0xe2, 0x38, 0xb3, 0x41 } } },
    { L"EFI_PCI_ROOT_BRIDGE_IO_PROTOCOL_GUID",                                { 0x2f707ebb, 0x4a1a, 0x11d4, { 0x9a, 0x38, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_PCMCIA_REQUEST_PROTOCOL_GUID",                                    { 0xf238f47c, 0x1de9, 0x4e8b, { 0x81, 0xb9, 0xcc, 0x92, 0x4e, 0x6b, 0x5b, 0xe5 } } },
    { L"EFI_PEI_AMI_KEYCODE_PPI_GUID",                                        { 0x20b0f1c2, 0xb0d8, 0x4c5d, { 0xaa, 0xd9, 0xf4, 0x45, 0x80, 0xdf, 0xdf, 0x8b } } },
    { L"EFI_PEI_APRIORI_FILE_NAME_GUID",                                      { 0x1b45cc0a, 0x156a, 0x428a, { 0xaf, 0x62, 0x49, 0x86, 0x4d, 0xa0, 0xe6, 0xe6 } } },
    { L"EFI_PEI_BOOT_SCRIPT_EXECUTER_PPI_GUID",                               { 0xabd42895, 0x78cf, 0x4872, { 0x84, 0x44, 0x1b, 0x5c, 0x18, 0x0b, 0xfb, 0xff } } },
    { L"EFI_PEI_CAPSULE_PPI_GUID",                                            { 0x066785b1, 0xedb8, 0x46dc, { 0x84, 0x2f, 0x57, 0x44, 0x04, 0xb8, 0x69, 0x2f } } },
    { L"EFI_PEI_CMOS_ACCESS_GUID",                                            { 0xccbf2786, 0xcd6c, 0x4308, { 0xbd, 0xfa, 0x62, 0x58, 0x70, 0xce, 0xbf, 0x81 } } },
    { L"EFI_PEI_CONSPLIT_AMI_KEYCODE_PPI_GUID",                               { 0x73ddb5e1, 0x5fb4, 0x4751, { 0xaf, 0x1e, 0x83, 0xcf, 0x75, 0xbe, 0xcb, 0xb6 } } },
    { L"EFI_PEI_CORE_PRIVATE_GUID",                                           { 0xd641a0f5, 0xcb7c, 0x4846, { 0xa3, 0x80, 0x1d, 0x01, 0xb4, 0xd9, 0xe3, 0xb9 } } },
    { L"EFI_PEI_CPU_IO_PPI_INSTALLED_GUID",                                   { 0xe6af1f7b, 0xfc3f, 0x46da, { 0xa8, 0x28, 0xa3, 0xb4, 0x57, 0xa4, 0x42, 0x82 } } },
    { L"EFI_PEI_DECOMPRESS_PPI_GUID",                                         { 0x1a36e4e7, 0xfab6, 0x476a, { 0x8e, 0x75, 0x69, 0x5a, 0x05, 0x76, 0xfd, 0xd7 } } },
    { L"EFI_PEI_DEVICE_RECOVERY_MODULE_PPI_GUID",                             { 0x0de2ce25, 0x446a, 0x45a7, { 0xbf, 0xc9, 0x37, 0xda, 0x26, 0x34, 0x4b, 0x37 } } },
    { L"EFI_PEI_END_OF_PEI_PHASE_PPI_GUID",                                   { 0x605ea650, 0xc65c, 0x42e1, { 0xba, 0x80, 0x91, 0xa5, 0x2a, 0xb6, 0x18, 0xc6 } } },
    { L"EFI_PEI_FIND_FV_PPI_GUID",                                            { 0x36164812, 0xa023, 0x44e5, { 0xbd, 0x85, 0x05, 0xbf, 0x3c, 0x77, 0x00, 0xaa } } },
    { L"EFI_PEI_FIRMWARE_VOLUME_INFO2_PPI_GUID",                              { 0xea7ca24b, 0xded5, 0x4dad, { 0xa3, 0x89, 0xbf, 0x82, 0x7e, 0x8f, 0x9b, 0x38 } } },
    { L"EFI_PEI_FIRMWARE_VOLUME_INFO_MEASUREMENT_EXCLUDED_PPI_GUID",          { 0x6e056ff9, 0xc695, 0x4364, { 0x9e, 0x2c, 0x61, 0x26, 0xf5, 0xce, 0xea, 0xae } } },
    { L"EFI_PEI_FIRMWARE_VOLUME_INFO_PPI_GUID",                               { 0x49edb1c1, 0xbf21, 0x4761, { 0xbb, 0x12, 0xeb, 0x00, 0x31, 0xaa, 0xbb, 0x39 } } },
    { L"EFI_PEI_FLUSH_INSTRUCTION_CACHE_GUID",                                { 0xd8117cfc, 0x94a6, 0x11d4, { 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_PEI_FV_FILE_LOADER_GUID",                                         { 0x7e1f0d85, 0x04ff, 0x4bb2, { 0x86, 0x6a, 0x31, 0xa2, 0x99, 0x6a, 0x48, 0xa8 } } },
    { L"EFI_PEI_I2C_MASTER_PPI_GUID",                                         { 0xb3bfab9b, 0x9f9c, 0x4e8b, { 0xad, 0x37, 0x7f, 0x8c, 0x51, 0xfc, 0x62, 0x80 } } },
    { L"EFI_PEI_LOADED_IMAGE_PPI_GUID",                                       { 0xa62a3fff, 0x97f0, 0x4332, { 0x8c, 0xfd, 0x1e, 0x34, 0x3d, 0x36, 0x31, 0xf2 } } },
    { L"EFI_PEI_LOADED_IMAGE_PPI_GUID",                                       { 0xc1fcd448, 0x6300, 0x4458, { 0xb8, 0x64, 0x28, 0xdf, 0x01, 0x53, 0x64, 0xbc } } },
    { L"EFI_PEI_LOAD_FILE_GUID",                                              { 0xb9e0abfe, 0x5979, 0x4914, { 0x97, 0x7f, 0x6d, 0xee, 0x78, 0xc2, 0x78, 0xa6 } } },
    { L"EFI_PEI_LOAD_FILE_PPI_GUID",                                          { 0xb9e0abfe, 0x5979, 0x4914, { 0x97, 0x7f, 0x6d, 0xee, 0x78, 0xc2, 0x78, 0xa6 } } },
    { L"EFI_PEI_PCD_PPI_GUID",                                                { 0x01f34d25, 0x4de2, 0x23ad, { 0x3f, 0xf3, 0x36, 0x35, 0x3f, 0xf3, 0x23, 0xf1 } } },
    { L"EFI_PEI_PCI_CFG2_PPI_GUID",                                           { 0x057a449a, 0x1fdc, 0x4c06, { 0xbf, 0xc9, 0xf5, 0x3f, 0x6a, 0x99, 0xbb, 0x92 } } },
    { L"EFI_PEI_PCI_CFG2_PPI_GUID",                                           { 0xe1f2eba0, 0xf7b9, 0x4a26, { 0x86, 0x20, 0x13, 0x12, 0x21, 0x64, 0x2a, 0x90 } } },
    { L"EFI_PEI_PCI_CFG_PPI_INSTALLED_GUID",                                  { 0xe1f2eba0, 0xf7b9, 0x4a26, { 0x86, 0x20, 0x13, 0x12, 0x21, 0x64, 0x2a, 0x90 } } },
    { L"EFI_PEI_PE_COFF_LOADER_GUID",                                         { 0xd8117cff, 0x94a6, 0x11d4, { 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_PEI_PERFORMANCE_HOB_GUID",                                        { 0x10f432de, 0xdeec, 0x4631, { 0x80, 0xcd, 0x47, 0xf6, 0x5d, 0x8f, 0x80, 0xbb } } },
    { L"EFI_PEI_PERMANENT_MEMORY_INSTALLED_PPI_GUID",                         { 0xf894643d, 0xc449, 0x42d1, { 0x8e, 0xa8, 0x85, 0xbd, 0xd8, 0xc6, 0x5b, 0xde } } },
    { L"EFI_PEI_PLATFORMPEI_EXECUTED_PPI_GUID",                               { 0x8c72c36e, 0xdacc, 0x4e81, { 0x8d, 0x60, 0xff, 0xa6, 0x1d, 0x88, 0xff, 0x54 } } },
    { L"EFI_PEI_READ_ONLY_VARIABLE2_PPI_GUID",                                { 0x2ab86ef5, 0xecb5, 0x4134, { 0xb5, 0x56, 0x38, 0x54, 0xca, 0x1f, 0xe1, 0xb4 } } },
    { L"EFI_PEI_READ_ONLY_VARIABLE_ACCESS_PPI_GUID",                          { 0x3cdc90c6, 0x13fb, 0x4a75, { 0x9e, 0x79, 0x59, 0xe9, 0xdd, 0x78, 0xb9, 0xfa } } },
    { L"EFI_PEI_READ_ONLY_VARIABLE_PPI_GUID",                                 { 0x3cdc90c6, 0x13fb, 0x4a75, { 0x9e, 0x79, 0x59, 0xe9, 0xdd, 0x78, 0xb9, 0xfa } } },
    { L"EFI_PEI_RECOVERY_BLOCK_IO_PPI_GUID",                                  { 0x695d8aa1, 0x42ee, 0x4c46, { 0x80, 0x5c, 0x6e, 0xa6, 0xbc, 0xe7, 0x99, 0xe3 } } },
    { L"EFI_PEI_RECOVERY_MODULE_PPI_GUID",                                    { 0xfb6d9542, 0x612d, 0x4f45, { 0x87, 0x2f, 0x5c, 0xff, 0x52, 0xe9, 0x3d, 0xcf } } },
    { L"EFI_PEI_REPORT_PROGRESS_CODE_PPI_GUID",                               { 0x229832d3, 0x7a30, 0x4b36, { 0xb8, 0x27, 0xf4, 0x0c, 0xb7, 0xd4, 0x54, 0x36 } } },
    { L"EFI_PEI_RESET_PPI_GUID",                                              { 0xef398d58, 0x9dfd, 0x4103, { 0xbf, 0x94, 0x78, 0xc6, 0xf4, 0xfe, 0x71, 0x2f } } },
    { L"EFI_PEI_RSC_HANDLER_PPI_GUID",                                        { 0x0065d394, 0x9951, 0x4144, { 0x82, 0xa3, 0x0a, 0xfc, 0x85, 0x79, 0xc2, 0x51 } } },
    { L"EFI_PEI_S3_RESUME2_PPI_GUID",                                         { 0x6d582dbc, 0xdb85, 0x4514, { 0x8f, 0xcc, 0x5a, 0xdf, 0x62, 0x27, 0xb1, 0x47 } } },
    { L"EFI_PEI_S3_RESUME_PPI_GUID",                                          { 0x4426ccb2, 0xe684, 0x4a8a, { 0xae, 0x40, 0x20, 0xd4, 0xb0, 0x25, 0xb7, 0x10 } } },
    { L"EFI_PEI_SECTION_EXTRACTION_PPI_GUID",                                 { 0x4f89e208, 0xe144, 0x4804, { 0x9e, 0xc8, 0x0f, 0x89, 0x4f, 0x7e, 0x36, 0xd7 } } },
    { L"EFI_PEI_SECURITY2_PPI_GUID",                                          { 0xdcd0be23, 0x9586, 0x40f4, { 0xb6, 0x43, 0x06, 0x52, 0x2c, 0xed, 0x4e, 0xde } } },
    { L"EFI_PEI_SECURITY_PPI_GUID",                                           { 0x1388066e, 0x3a57, 0x4efa, { 0x98, 0xf3, 0xc1, 0x2f, 0x3a, 0x95, 0x8a, 0x29 } } },
    { L"EFI_PEI_SMBUS2_PPI_GUID",                                             { 0x9ca93627, 0xb65b, 0x4324, { 0xa2, 0x02, 0xc0, 0xb4, 0x61, 0x76, 0x45, 0x43 } } },
    { L"EFI_PEI_SMBUS_PPI_GUID",                                              { 0xabd42895, 0x78cf, 0x4872, { 0x84, 0x44, 0x1b, 0x5c, 0x18, 0x0b, 0xfb, 0xda } } },
    { L"EFI_PEI_SMM_COMMUNICATION_PPI_GUID",                                  { 0xae933e1c, 0xcc47, 0x4e38, { 0x8f, 0x0e, 0xe2, 0xf6, 0x1d, 0x26, 0x05, 0xdf } } },
    { L"EFI_PEI_STALL_PPI_GUID",                                              { 0x1f4c6f90, 0xb06b, 0x48d8, { 0xa2, 0x01, 0xba, 0xe5, 0xf1, 0xcd, 0x7d, 0x56 } } },
    { L"EFI_PEI_TEMPORARY_RAM_SUPPORT_PPI_GUID",                              { 0xdbe23aa9, 0xa345, 0x4b97, { 0x85, 0xb6, 0xb2, 0x26, 0xf1, 0x61, 0x73, 0x89 } } },
    { L"EFI_PEI_TRANSFER_CONTROL_GUID",                                       { 0xd8117d02, 0x94a6, 0x11d4, { 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_PERFORMANCE_PROTOCOL_GUID",                                       { 0xffecffff, 0x923c, 0x14d2, { 0x9e, 0x3f, 0x22, 0xa0, 0xc9, 0x69, 0x56, 0x3b } } },
    { L"EFI_PHYSICAL_PRESENCE_DATA_GUID",                                     { 0x0f6499b1, 0xe9ad, 0x493d, { 0xb9, 0xc2, 0x2f, 0x90, 0x81, 0x5c, 0x6c, 0xbc } } },
    { L"EFI_PI_MP_SERVICES_PROTOCOL_GUID",                                    { 0x3fdda605, 0xa76e, 0x4f46, { 0xad, 0x29, 0x12, 0xf4, 0x53, 0x1b, 0x3d, 0x08 } } },
    { L"EFI_PLATFORM_DRIVER_OVERRIDE_PROTOCOL_GUID",                          { 0x6b30c738, 0xa391, 0x11d4, { 0x9a, 0x3b, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_PLATFORM_GOP_POLICY_PROTOCOL_GUID",                               { 0xec2e931b, 0x3281, 0x48a5, { 0x81, 0x07, 0xdf, 0x8a, 0x8b, 0xed, 0x3c, 0x5d } } },
    { L"EFI_PLATFORM_INFO_PROTOCOL_GUID",                                     { 0xd9035175, 0x8ce2, 0x47de, { 0xa8, 0xb8, 0xcc, 0x98, 0xe5, 0xe2, 0xa8, 0x85 } } },
    { L"EFI_PLATFORM_MEMTEST_PROTOCOL_GUID",                                  { 0x0859ba18, 0x7dd7, 0x4ed7, { 0xa8, 0x8e, 0x10, 0x9c, 0x63, 0x91, 0x7b, 0xdd } } },
    { L"EFI_PLATFORM_TO_DRIVER_CONFIGURATION_CLP_GUID",                       { 0x345ecc0e, 0x0cb6, 0x4b75, { 0xbb, 0x57, 0x1b, 0x12, 0x9c, 0x47, 0x33, 0x3e } } },
    { L"EFI_PLATFORM_TO_DRIVER_CONFIGURATION_PROTOCOL_GUID",                  { 0x642cd590, 0x8059, 0x4c0a, { 0xa9, 0x58, 0xc5, 0xec, 0x07, 0xd2, 0x3c, 0x4b } } },
    { L"EFI_POWER_ON_HOB_GUID",                                               { 0x0468a601, 0xc535, 0x46fd, { 0xa9, 0x5d, 0xbb, 0xab, 0x99, 0x1b, 0x17, 0x8c } } },
    { L"EFI_PPM_GLOBAL_NVS_AREA_PROTOCOL_GUID",                               { 0x6c50cdcb, 0x7f46, 0x4dcc, { 0x8d, 0xdd, 0xd9, 0xf0, 0xa3, 0xc6, 0x11, 0x28 } } },
    { L"EFI_PPM_INFO_PROTOCOL_GUID",                                          { 0xd71db106, 0xe32d, 0x4225, { 0xbf, 0xf4, 0xde, 0x6d, 0x77, 0x87, 0x17, 0x61 } } },
    { L"EFI_PRIMARY_CONSOLE_IN_DEVICE_GUID",                                  { 0xe451dcbe, 0x96a1, 0x4729, { 0xa5, 0xcf, 0x6b, 0x9c, 0x2c, 0xff, 0x47, 0xfd } } },
    { L"EFI_PRIMARY_CONSOLE_OUT_DEVICE_GUID",                                 { 0x62bdf38a, 0xe3d5, 0x492c, { 0x95, 0x0c, 0x23, 0xa7, 0xf6, 0x6e, 0x67, 0x2e } } },
    { L"EFI_PRIMARY_STANDARD_ERROR_DEVICE_GUID",                              { 0x5a68191b, 0x9b97, 0x4752, { 0x99, 0x46, 0xe3, 0x6a, 0x5d, 0xa9, 0x42, 0xb1 } } },
    { L"EFI_PRINT2_PROTOCOL_GUID",                                            { 0xf05976ef, 0x83f1, 0x4f3d, { 0x86, 0x19, 0xf7, 0x59, 0x5d, 0x41, 0xe5, 0x38 } } },
    { L"EFI_PRINT_PROTOCOL_GUID",                                             { 0xdf2d868e, 0x32fc, 0x4cf0, { 0x8e, 0x6b, 0xff, 0xd9, 0x5d, 0x13, 0x43, 0xd0 } } },
    { L"EFI_PROCESSOR_PRODUCER_GUID",                                         { 0x1bf06aea, 0x5bec, 0x4a8d, { 0x95, 0x76, 0x74, 0x9b, 0x09, 0x56, 0x2d, 0x30 } } },
    { L"EFI_PROCESSOR_SUBCLASS_GUID",                                         { 0x26fdeb7e, 0xb8af, 0x4ccf, { 0xaa, 0x97, 0x02, 0x63, 0x3c, 0xe4, 0x8c, 0xa7 } } },
    { L"EFI_PS2_POLICY_PROTOCOL_GUID",                                        { 0x4df19259, 0xdc71, 0x4d46, { 0xbe, 0xf1, 0x35, 0x7b, 0xb5, 0x78, 0xc4, 0x18 } } },
    { L"EFI_PXE_BASE_CODE_CALLBACK_PROTOCOL_GUID",                            { 0x245dca21, 0xfb7b, 0x11d3, { 0x8f, 0x01, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_PXE_BASE_CODE_PROTOCOL_GUID",                                     { 0x03c4e603, 0xac28, 0x11d3, { 0x9a, 0x2d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_PXE_DHCP4_CALLBACK_PROTOCOL_GUID",                                { 0xc1544c01, 0x92a4, 0x4198, { 0x8a, 0x84, 0x77, 0x85, 0x83, 0xc2, 0x36, 0x21 } } },
    { L"EFI_PXE_DHCP4_PROTOCOL_GUID",                                         { 0x03c4e624, 0xac28, 0x11d3, { 0x9a, 0x2d, 0x00, 0x90, 0x29, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_REAL_TIME_CLOCK_ARCH_PROTOCOL_GUID",                              { 0x27cfac87, 0x46cc, 0x11d4, { 0x9a, 0x38, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_RESET_ARCH_PROTOCOL_GUID",                                        { 0x27cfac88, 0x46cc, 0x11d4, { 0x9a, 0x38, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_RSC_HANDLER_PROTOCOL_GUID",                                       { 0x86212936, 0x0e76, 0x41c8, { 0xa0, 0x3a, 0x2a, 0xf2, 0xfc, 0x1c, 0x39, 0xe2 } } },
    { L"EFI_RUNTIME_ARCH_PROTOCOL_GUID",                                      { 0xb7dfb4e1, 0x052f, 0x449f, { 0x87, 0xbe, 0x98, 0x18, 0xfc, 0x91, 0xb7, 0x33 } } },
    { L"EFI_RUNTIME_CRYPT_PROTOCOL_GUID",                                     { 0xe1475e0c, 0x1746, 0x4802, { 0x86, 0x2e, 0x01, 0x1c, 0x2c, 0x2d, 0x9d, 0x86 } } },
    { L"EFI_S3_SAVE_STATE_PROTOCOL_GUID",                                     { 0xe857caf6, 0xc046, 0x45dc, { 0xbe, 0x3f, 0xee, 0x07, 0x65, 0xfb, 0xa8, 0x87 } } },
    { L"EFI_S3_SMM_SAVE_STATE_PROTOCOL_GUID",                                 { 0x320afe62, 0xe593, 0x49cb, { 0xa9, 0xf1, 0xd4, 0xc2, 0xf4, 0xaf, 0x01, 0x4c } } },
    { L"EFI_SA_INFO_PROTOCOL_GUID",                                           { 0x493b5bac, 0xbb9e, 0x4bf5, { 0x83, 0x79, 0x20, 0xe2, 0xac, 0xa9, 0x85, 0x41 } } },
    { L"EFI_SAL_MCA_INIT_PMI_PROTOCOL_GUID",                                  { 0xb60dc6e8, 0x3b6f, 0x11d5, { 0xaf, 0x09, 0x00, 0xa0, 0xc9, 0x44, 0xa0, 0x5b } } },
    { L"EFI_SAL_SYSTEM_TABLE_GUID",                                           { 0xeb9d2d32, 0x2d88, 0x11d3, { 0x9a, 0x16, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_SAS_DEVICE_PATH_GUID",                                            { 0xd487ddb4, 0x008b, 0x11d9, { 0xaf, 0xdc, 0x00, 0x10, 0x83, 0xff, 0xca, 0x4d } } },
    { L"EFI_SB_PCIE_ERROR_LOG_DISPATCH_PROTOCOL_GUID",                        { 0xf281fc6e, 0xf4c4, 0x431c, { 0x96, 0x2b, 0x2f, 0x13, 0xae, 0x79, 0x84, 0xec } } },
    { L"EFI_SCSI_IO_PROTOCOL_GUID",                                           { 0x932f47e6, 0x2362, 0x4002, { 0x80, 0x3e, 0x3c, 0xd5, 0x4b, 0x13, 0x8f, 0x85 } } },
    { L"EFI_SCSI_PASS_THRU_PROTOCOL_GUID",                                    { 0xa59e8fcf, 0xbda0, 0x43bb, { 0x90, 0xb1, 0xd3, 0x73, 0x2e, 0xca, 0xa8, 0x77 } } },
    { L"EFI_SEC_PLATFORM_INFORMATION_GUID",                                   { 0x6f8c2b35, 0xfef4, 0x448d, { 0x82, 0x56, 0xe1, 0x1b, 0x19, 0xd6, 0x10, 0x77 } } },
    { L"EFI_SEC_SMI_FLASH_GUID",                                              { 0x3bf4af16, 0xab7c, 0x4b43, { 0x89, 0x8d, 0xab, 0x26, 0xac, 0x5d, 0xdc, 0x6c } } },
    { L"EFI_SECTION_EXTRACTION_PROTOCOL_GUID",                                { 0x448f5da4, 0x6dd7, 0x4fe1, { 0x93, 0x07, 0x69, 0x22, 0x41, 0x92, 0x21, 0x5d } } },
    { L"EFI_SECURITY2_ARCH_PROTOCOL_GUID",                                    { 0x94ab2f58, 0x1438, 0x4ef1, { 0x91, 0x52, 0x18, 0x94, 0x1a, 0x3a, 0x0e, 0x68 } } },
    { L"EFI_SECURITY_ARCH_PROTOCOL_GUID",                                     { 0xa46423e3, 0x4617, 0x49f1, { 0xb9, 0xff, 0xd1, 0xbf, 0xa9, 0x11, 0x58, 0x39 } } },
    { L"EFI_SECURITY_POLICY_PROTOCOL_GUID",                                   { 0x78e4d245, 0xcd4d, 0x4a05, { 0xa2, 0xba, 0x47, 0x43, 0xe8, 0x6c, 0xfc, 0xab } } },
    { L"EFI_SE_EXT_SIGNATURE_GUID",                                           { 0xd2c18636, 0x40e5, 0x4eb5, { 0xa3, 0x1b, 0x36, 0x69, 0x5f, 0xd4, 0x2c, 0x87 } } },
    { L"EFI_SERIAL_GPIO_PROTOCOL_GUID",                                       { 0xf52c3858, 0x5ef8, 0x4d41, { 0x83, 0x4e, 0xc3, 0x9e, 0xef, 0x8a, 0x45, 0xa3 } } },
    { L"EFI_SERIAL_IO_PROTOCOL_GUID",                                         { 0xbb25cf6f, 0xf1d4, 0x11d2, { 0x9a, 0x0c, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0xfd } } },
    { L"EFI_SHELL_FILE_GUID",                                                 { 0xc57ad6b7, 0x0515, 0x40a8, { 0x9d, 0x21, 0x55, 0x16, 0x52, 0x85, 0x4e, 0x37 } } },
    { L"EFI_SHELL_PARAMETERS_PROTOCOL_GUID",                                  { 0x752f3136, 0x4e16, 0x4fdc, { 0xa2, 0x2a, 0xe5, 0xf4, 0x68, 0x12, 0xf4, 0xca } } },
    { L"EFI_SHELLPKG_TOKEN_SPACE_GUID",                                       { 0x171e9188, 0x31d3, 0x40f5, { 0xb1, 0x0c, 0x53, 0x9b, 0x2d, 0xb9, 0x40, 0xcd } } },
    { L"EFI_SHELL_PROTOCOL_GUID",                                             { 0x6302d008, 0x7f9b, 0x4f30, { 0x87, 0xac, 0x60, 0xc9, 0xfe, 0xf5, 0xda, 0x4e } } },
    { L"EFI_SIMPLE_AUDIO_OUT_PROTOCOL_GUID",                                  { 0xc723f288, 0x52f9, 0x4d80, { 0xb6, 0x33, 0xe1, 0x52, 0xf9, 0x30, 0xa0, 0xdc } } },
    { L"EFI_SIMPLE_FILE_SYSTEM_PROTOCOL_GUID",                                { 0x964e5b22, 0x6459, 0x11d2, { 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_SIMPLE_NETWORK_PROTOCOL_GUID",                                    { 0xa19832b9, 0xac25, 0x11d3, { 0x9a, 0x2d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_SIMPLE_POINTER_PROTOCOL_GUID",                                    { 0x31878c87, 0x0b75, 0x11d5, { 0x9a, 0x4f, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_SIMPLE_TEXT_IN_PROTOCOL_GUID",                                    { 0x387477c1, 0x69c7, 0x11d2, { 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_SIMPLE_TEXT_INPUT_EX_PROTOCOL_GUID",                              { 0xdd9e7534, 0x7762, 0x4698, { 0x8c, 0x14, 0xf5, 0x85, 0x17, 0xa6, 0x25, 0xaa } } },
    { L"EFI_SIMPLE_TEXT_INPUT_PROTOCOL_GUID",                                 { 0x387477c1, 0x69c7, 0x11d2, { 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_SIMPLE_TEXT_OUT_PROTOCOL_GUID",                                   { 0x387477c2, 0x69c7, 0x11d2, { 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_SIMPLE_TEXT_OUTPUT_PROTOCOL_GUID",                                { 0x387477c2, 0x69c7, 0x11d2, { 0x8e, 0x39, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_SIO_PROTOCOL_GUID",                                               { 0x215fdd18, 0xbd50, 0x4feb, { 0x89, 0x0b, 0x58, 0xca, 0x0b, 0x47, 0x39, 0xe9 } } },
    { L"EFI_SMBIOS_BOARD_PROTOCOL_GUID",                                      { 0x0903dd14, 0x2ca0, 0x458a, { 0xb5, 0xeb, 0x0c, 0x0c, 0xa3, 0x0d, 0x78, 0x5c } } },
    { L"EFI_SMBIOS_DYNAMIC_DATA_GUID",                                        { 0xe380280c, 0x4c35, 0x4aa3, { 0xb9, 0x61, 0x7a, 0xe4, 0x89, 0xa2, 0xb9, 0x26 } } },
    { L"EFI_SMBIOS_NVRAM_DATA_GUID",                                          { 0x4b3082a3, 0x80c6, 0x4d7e, { 0x9c, 0xd0, 0x58, 0x39, 0x17, 0x26, 0x5d, 0xf1 } } },
    { L"EFI_SMBIOS_PROTOCOL_GUID",                                            { 0x03583ff6, 0xcb36, 0x4940, { 0x94, 0x7e, 0xb9, 0xb3, 0x9f, 0x4a, 0xfa, 0xf7 } } },
    { L"EFI_SMBIOS_PROTOCOL_GUID",                                            { 0x5e90a50d, 0x6955, 0x4a49, { 0x90, 0x32, 0xda, 0x38, 0x12, 0xf8, 0xe8, 0xe5 } } },
    { L"EFI_SMBIOS_STATIC_DATA_GUID",                                         { 0xdaf4bf89, 0xce71, 0x4917, { 0xb5, 0x22, 0xc8, 0x9d, 0x32, 0xfb, 0xc5, 0x9f } } },
    { L"EFI_SMBIOS_TABLE_GUID",                                               { 0xeb9d2d31, 0x2d88, 0x11d3, { 0x9a, 0x16, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_SMBUS_ARP_MAP_GUID",                                              { 0x707be83e, 0x0bf6, 0x40a5, { 0xbe, 0x64, 0x34, 0xc0, 0x3a, 0xa0, 0xb8, 0xe2 } } },
    { L"EFI_SMBUS_HC_PROTOCOL_GUID",                                          { 0xe49d33ed, 0x513d, 0x4634, { 0xb6, 0x98, 0x6f, 0x55, 0xaa, 0x75, 0x1c, 0x1b } } },
    { L"EFI_SMM_ACCESS2_PROTOCOL_GUID",                                       { 0xc2702b74, 0x800c, 0x4131, { 0x87, 0x46, 0x8f, 0xb5, 0xb8, 0x9c, 0xe4, 0xac } } },
    { L"EFI_SMM_ACCESS_PROTOCOL_GUID",                                        { 0x3792095a, 0xe309, 0x4c1e, { 0xaa, 0x01, 0x85, 0xf5, 0x65, 0x5a, 0x17, 0xf1 } } },
    { L"EFI_SMM_BASE2_PROTOCOL_GUID",                                         { 0xf4ccbfb7, 0xf6e0, 0x47fd, { 0x9d, 0xd4, 0x10, 0xa8, 0xf1, 0x50, 0xc1, 0x91 } } },
    { L"EFI_SMM_BASE_HELPER_READY_PROTOCOL_GUID",                             { 0x910dca07, 0x1f94, 0x4ee7, { 0xaf, 0x2f, 0xff, 0x72, 0xf3, 0x15, 0x43, 0x53 } } },
    { L"EFI_SMM_BASE_PROTOCOL_GUID",                                          { 0x1390954d, 0xda95, 0x4227, { 0x93, 0x28, 0x72, 0x82, 0xc2, 0x17, 0xda, 0xa8 } } },
    { L"EFI_SMM_BASE_THUNK_COMMUNICATION_GUID",                               { 0x6568a3d6, 0x015f, 0x4b4a, { 0x9c, 0x89, 0x1d, 0x14, 0x63, 0x14, 0x13, 0x0a } } },
    { L"EFI_SMM_BIOS_WRITE_DISPATCH_PROTOCOL_GUID",                           { 0xe512dfe4, 0xbf44, 0x480d, { 0x9b, 0x7a, 0x77, 0x7b, 0x0b, 0xe3, 0x27, 0x75 } } },
    { L"EFI_SMM_CMOS_ACCESS_GUID",                                            { 0xe5d3026a, 0x1ca5, 0x40f0, { 0x8f, 0xb6, 0x4b, 0x1a, 0xfa, 0x3c, 0x6e, 0xaa } } },
    { L"EFI_SMM_COMMUNICATION_PROTOCOL_GUID",                                 { 0xc68ed8e2, 0x9dc6, 0x4cbd, { 0x9d, 0x94, 0xdb, 0x65, 0xac, 0xc5, 0xc3, 0x32 } } },
    { L"EFI_SMM_CONFIGURATION_PROTOCOL_GUID",                                 { 0x26eeb3de, 0xb689, 0x492e, { 0x80, 0xf0, 0xbe, 0x8b, 0xd7, 0xda, 0x4b, 0xa7 } } },
    { L"EFI_SMM_CONTROL2_PROTOCOL_GUID",                                      { 0x843dc720, 0xab1e, 0x42cb, { 0x93, 0x57, 0x8a, 0x00, 0x78, 0xf3, 0x56, 0x1b } } },
    { L"EFI_SMM_CONTROL_PROTOCOL_GUID",                                       { 0x8d12e231, 0xc667, 0x4fd1, { 0x98, 0xf2, 0x24, 0x49, 0xa7, 0xe7, 0xb2, 0xe5 } } },
    { L"EFI_SMM_CPU_IO2_PROTOCOL_GUID",                                       { 0x3242a9d8, 0xce70, 0x4aa0, { 0x95, 0x5d, 0x5e, 0x7b, 0x14, 0x0d, 0xe4, 0xd2 } } },
    { L"EFI_SMM_CPU_IO_GUID",                                                 { 0x5f439a0b, 0x45d8, 0x4682, { 0xa4, 0xf4, 0xf0, 0x57, 0x6b, 0x51, 0x34, 0x41 } } },
    { L"EFI_SMM_CPU_PROTOCOL_GUID",                                           { 0xeb346b97, 0x975f, 0x4a9f, { 0x8b, 0x22, 0xf8, 0xe9, 0x2b, 0xb3, 0xd5, 0x69 } } },
    { L"EFI_SMM_CPU_SAVE_STATE_PROTOCOL_GUID",                                { 0x21f302ad, 0x6e94, 0x471b, { 0x84, 0xbc, 0xb1, 0x48, 0x00, 0x40, 0x3a, 0x1d } } },
    { L"EFI_SMM_END_OF_DXE_PROTOCOL_GUID",                                    { 0x24e70042, 0xd5c5, 0x4260, { 0x8c, 0x39, 0x0a, 0xd3, 0xaa, 0x32, 0xe9, 0x3d } } },
    { L"EFI_SMM_FAULT_TOLERANT_WRITE_PROTOCOL_GUID",                          { 0x3868fc3b, 0x7e45, 0x43a7, { 0x90, 0x6c, 0x4b, 0xa4, 0x7d, 0xe1, 0x75, 0x4d } } },
    { L"EFI_SMM_FIRMWARE_VOLUME_BLOCK_PROTOCOL_GUID",                         { 0xd326d041, 0xbd31, 0x4c01, { 0xb5, 0xa8, 0x62, 0x8b, 0xe8, 0x7f, 0x06, 0x53 } } },
    { L"EFI_SMM_GPI_DISPATCH2_PROTOCOL_GUID",                                 { 0x25566b03, 0xb577, 0x4cbf, { 0x95, 0x8c, 0xed, 0x66, 0x3e, 0xa2, 0x43, 0x80 } } },
    { L"EFI_SMM_GPI_DISPATCH_PROTOCOL_GUID",                                  { 0xe0744b81, 0x9513, 0x49cd, { 0x8c, 0xea, 0xe9, 0x24, 0x5e, 0x70, 0x39, 0xda } } },
    { L"EFI_SMM_ICHN_DISPATCH_EX_PROTOCOL_GUID",                              { 0x3920405b, 0xc897, 0x44da, { 0x88, 0xf3, 0x4c, 0x49, 0x8a, 0x6f, 0xf7, 0x36 } } },
    { L"EFI_SMM_ICHN_DISPATCH_PROTOCOL_GUID",                                 { 0xc50b323e, 0x9075, 0x4f2a, { 0xac, 0x8e, 0xd2, 0x59, 0x6a, 0x10, 0x85, 0xcc } } },
    { L"EFI_SMM_IO_TRAP_DISPATCH2_PROTOCOL_GUID",                             { 0x58dc368d, 0x7bfa, 0x4e77, { 0xab, 0xbc, 0x0e, 0x29, 0x41, 0x8d, 0xf9, 0x30 } } },
    { L"EFI_SMM_IO_TRAP_DISPATCH2_PROTOCOL_GUID",                             { 0xf1507845, 0x6494, 0x4377, { 0xa1, 0x15, 0x45, 0xdf, 0xe6, 0x5f, 0x5d, 0x71 } } },
    { L"EFI_SMM_IO_TRAP_DISPATCH_PROTOCOL_GUID",                              { 0x58dc368d, 0x7bfa, 0x4e77, { 0xab, 0xbc, 0x0e, 0x29, 0x41, 0x8d, 0xf9, 0x30 } } },
    { L"EFI_SMM_IO_TRAP_DISPATCH_PROTOCOL_GUID",                              { 0xbd18369d, 0xc242, 0x45ca, { 0x82, 0xad, 0x13, 0x8a, 0xc2, 0xe2, 0x9b, 0xab } } },
    { L"EFI_SMM_IO_TRAP_DISPATCH_PROTOCOL_GUID",                              { 0xdb7f536b, 0xede4, 0x4714, { 0xa5, 0xc8, 0xe3, 0x46, 0xeb, 0xaa, 0x20, 0x1d } } },
    { L"EFI_SMM_LOCK_BOX_COMMUNICATION_GUID",                                 { 0x2a3cfebd, 0x27e8, 0x4d0a, { 0x8b, 0x79, 0xd6, 0x88, 0xc2, 0xa3, 0xe1, 0xc0 } } },
    { L"EFI_SMM_PCI_ROOT_BRIDGE_IO_PROTOCOL_GUID",                            { 0x8bc1714d, 0xffcb, 0x41c3, { 0x89, 0xdc, 0x6c, 0x74, 0xd0, 0x6d, 0x98, 0xea } } },
    { L"EFI_SMM_PERIODIC_TIMER_DISPATCH2_PROTOCOL_GUID",                      { 0x4cec368e, 0x8e8e, 0x4d71, { 0x8b, 0xe1, 0x95, 0x8c, 0x45, 0xfc, 0x8a, 0x53 } } },
    { L"EFI_SMM_PERIODIC_TIMER_DISPATCH_PROTOCOL_GUID",                       { 0x9cca03fc, 0x4c9e, 0x4a19, { 0x9b, 0x06, 0xed, 0x7b, 0x47, 0x9b, 0xde, 0x55 } } },
    { L"EFI_SMM_POWER_BUTTON_DISPATCH2_PROTOCOL_GUID",                        { 0x1b1183fa, 0x1823, 0x46a7, { 0x88, 0x72, 0x9c, 0x57, 0x87, 0x55, 0x40, 0x9d } } },
    { L"EFI_SMM_POWER_BUTTON_DISPATCH_PROTOCOL_GUID",                         { 0xb709efa0, 0x47a6, 0x4b41, { 0xb9, 0x31, 0x12, 0xec, 0xe7, 0xa8, 0xee, 0x56 } } },
    { L"EFI_SMM_RC_TO_APTIO_BRIDGE_GUID",                                     { 0xfcdf7788, 0x7878, 0x11ff, { 0xcc, 0x77, 0x88, 0xcc, 0xcc, 0x77, 0x88, 0xcc } } },
    { L"EFI_SMM_READY_TO_LOCK_PROTOCOL_GUID",                                 { 0x47b7fa8c, 0xf4bd, 0x4af6, { 0x82, 0x00, 0x33, 0x30, 0x86, 0xf0, 0xd2, 0xc8 } } },
    { L"EFI_SMM_RSC_HANDLER_PROTOCOL_GUID",                                   { 0x2ff29fa7, 0x5e80, 0x4ed9, { 0xb3, 0x80, 0x01, 0x7d, 0x3c, 0x55, 0x4f, 0xf4 } } },
    { L"EFI_SMM_RUNTIME_PROTOCOL_GUID",                                       { 0xa56897a1, 0xa77f, 0x4600, { 0x84, 0xdb, 0x22, 0xb0, 0xa8, 0x01, 0xfa, 0x9a } } },
    { L"EFI_SMM_RUNTIME_SERVICES_TABLE_GUID",                                 { 0x395c33fe, 0x287f, 0x413e, { 0xa0, 0x55, 0x80, 0x88, 0xc0, 0xe1, 0xd4, 0x3e } } },
    { L"EFI_SMM_SMBUS_PROTOCOL_GUID",                                         { 0x72e40094, 0x2ee1, 0x497a, { 0x8f, 0x33, 0x4c, 0x93, 0x4a, 0x9e, 0x9c, 0x0c } } },
    { L"EFI_SMM_SPI_PROTOCOL_GUID",                                           { 0xaff3be49, 0x6d71, 0x421c, { 0x92, 0x77, 0xa0, 0xb1, 0x50, 0x8e, 0x84, 0x7d } } },
    { L"EFI_SMM_SPI_PROTOCOL_GUID",                                           { 0xd9072c35, 0xeb8f, 0x43ad, { 0xa2, 0x20, 0x34, 0xd4, 0x0e, 0x2a, 0x82, 0x85 } } },
    { L"EFI_SMM_STANDBY_BUTTON_DISPATCH2_PROTOCOL_GUID",                      { 0x7300c4a1, 0x43f2, 0x4017, { 0xa5, 0x1b, 0xc8, 0x1a, 0x7f, 0x40, 0x58, 0x5b } } },
    { L"EFI_SMM_STANDBY_BUTTON_DISPATCH_PROTOCOL_GUID",                       { 0x78965b98, 0xb0bf, 0x449e, { 0x8b, 0x22, 0xd2, 0x91, 0x4e, 0x49, 0x8a, 0x98 } } },
    { L"EFI_SMM_STATUS_CODE_PROTOCOL_GUID",                                   { 0x6afd2b77, 0x98c1, 0x4acd, { 0xa6, 0xf9, 0x8a, 0x94, 0x39, 0xde, 0x0f, 0xb1 } } },
    { L"EFI_SMM_SWAP_ADDRESS_RANGE_PROTOCOL_GUID",                            { 0x67c4f112, 0x3385, 0x4e55, { 0x9c, 0x5b, 0xc0, 0x5b, 0x71, 0x7c, 0x42, 0x28 } } },
    { L"EFI_SMM_SW_DISPATCH2_PROTOCOL_GUID",                                  { 0x18a3c6dc, 0x5eea, 0x48c8, { 0xa1, 0xc1, 0xb5, 0x33, 0x89, 0xf9, 0x89, 0x99 } } },
    { L"EFI_SMM_SW_DISPATCH_PROTOCOL_GUID",                                   { 0xe541b773, 0xdd11, 0x420c, { 0xb0, 0x26, 0xdf, 0x99, 0x36, 0x53, 0xf8, 0xbf } } },
    { L"EFI_SMM_SX_DISPATCH2_PROTOCOL_GUID",                                  { 0x456d2859, 0xa84b, 0x4e47, { 0xa2, 0xee, 0x32, 0x76, 0xd8, 0x86, 0x99, 0x7d } } },
    { L"EFI_SMM_SX_DISPATCH_PROTOCOL_GUID",                                   { 0x14fc52be, 0x01dc, 0x426c, { 0x91, 0xae, 0xa2, 0x3c, 0x3e, 0x22, 0x0a, 0xe8 } } },
    { L"EFI_SMM_TCO_DISPATCH_PROTOCOL_GUID",                                  { 0x0e2d6bb1, 0xc624, 0x446d, { 0x99, 0x82, 0x69, 0x3c, 0xd1, 0x81, 0xa6, 0x07 } } },
    { L"EFI_SMM_THUNK_PROTOCOL_GUID",                                         { 0x2a82fce6, 0x8bb6, 0x413e, { 0xb9, 0xeb, 0x45, 0xdf, 0xc0, 0x52, 0x2d, 0xf3 } } },
    { L"EFI_SMM_USB_DISPATCH2_PROTOCOL_GUID",                                 { 0xee9b8d90, 0xc5a6, 0x40a2, { 0xbd, 0xe2, 0x52, 0x55, 0x8d, 0x33, 0xcc, 0xa1 } } },
    { L"EFI_SMM_USB_DISPATCH_PROTOCOL_GUID",                                  { 0xa05b6ffd, 0x87af, 0x4e42, { 0x95, 0xc9, 0x62, 0x28, 0xb6, 0x3c, 0xf3, 0xf3 } } },
    { L"EFI_SMM_VARIABLE_PROTOCOL_GUID",                                      { 0x3025da01, 0xdc5f, 0x4f59, { 0xbc, 0xc3, 0xb3, 0x77, 0xc8, 0x32, 0x5a, 0x4a } } },
    { L"EFI_SMM_VARIABLE_PROTOCOL_GUID",                                      { 0xed32d533, 0x99e6, 0x4209, { 0x9c, 0xc0, 0x2d, 0x72, 0xcd, 0xd9, 0x98, 0xa7 } } },
    { L"EFI_SMM_VARIABLE_WRITE_GUID",                                         { 0x93ba1826, 0xdffb, 0x45dd, { 0x82, 0xa7, 0xe7, 0xdc, 0xaa, 0x3b, 0xbd, 0xf3 } } },
    { L"EFI_SMRAM_NVS_HEADER_GUID",                                           { 0xec7f4fa1, 0xb217, 0x42fc, { 0xa7, 0xf7, 0x02, 0x0c, 0x43, 0x05, 0xd5, 0xba } } },
    { L"EFI_SMTP_PROTOCOL_GUID",                                              { 0x5f67d40c, 0x1d06, 0x4e3e, { 0x8b, 0x4a, 0xd2, 0x71, 0x3f, 0x46, 0xe1, 0xdc } } },
    { L"EFI_SPEAKER_INTERFACE_PROTOCOL_GUID",                                 { 0x400b4476, 0x3081, 0x11d6, { 0x87, 0xed, 0x00, 0x06, 0x29, 0x45, 0xc3, 0xb9 } } },
    { L"EFI_SPI_PROTOCOL_GUID",                                               { 0x01a660d9, 0x8009, 0x4330, { 0xba, 0x89, 0x71, 0xb0, 0x76, 0xcd, 0x5d, 0x0a } } },
    { L"EFI_SPI_PROTOCOL_GUID",                                               { 0x1156efc6, 0xea32, 0x4396, { 0xb5, 0xd5, 0x26, 0x93, 0x2e, 0x83, 0xc3, 0x13 } } },
    { L"EFI_STANDARD_CALLER_ID_GUID",                                         { 0xc9dcf469, 0xa7c4, 0x11d5, { 0x87, 0xda, 0x00, 0x06, 0x29, 0x45, 0xc3, 0xb9 } } },
    { L"EFI_STANDARD_ERROR_DEVICE_GUID",                                      { 0xd3b36f2d, 0xd551, 0x11d4, { 0x9a, 0x46, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_STATUS_CODE_ARCH_PROTOCOL_GUID",                                  { 0xd98e3ea3, 0x6f39, 0x4be4, { 0x82, 0xce, 0x5a, 0x89, 0x0c, 0xcb, 0x2c, 0x95 } } },
    { L"EFI_STATUS_CODE_DATA_TYPE_ASSERT_GUID",                               { 0xda571595, 0x4d99, 0x487c, { 0x82, 0x7c, 0x26, 0x22, 0x67, 0x7d, 0x33, 0x07 } } },
    { L"EFI_STATUS_CODE_DATA_TYPE_DEBUG_GUID",                                { 0x9a4e9246, 0xd553, 0x11d5, { 0x87, 0xe2, 0x00, 0x06, 0x29, 0x45, 0xc3, 0xb9 } } },
    { L"EFI_STATUS_CODE_DATA_TYPE_ERROR_GUID",                                { 0xab359ce3, 0x99b3, 0xae18, { 0xc8, 0x9d, 0x95, 0xd3, 0xb0, 0x72, 0xe1, 0x9b } } },
    { L"EFI_STATUS_CODE_DATA_TYPE_EXCEPTION_HANDLER_GUID",                    { 0x3bc2bd12, 0xad2e, 0x11d5, { 0x87, 0xdd, 0x00, 0x06, 0x29, 0x45, 0xc3, 0xb9 } } },
    { L"EFI_STATUS_CODE_DATA_TYPE_PROGRESS_CODE_GUID",                        { 0xa356ab39, 0x35c4, 0x35da, { 0xb3, 0x7a, 0xf8, 0xea, 0x9e, 0x8b, 0x36, 0xa3 } } },
    { L"EFI_STATUS_CODE_DATA_TYPE_STRING_GUID",                               { 0x92d11080, 0x496f, 0x4d95, { 0xbe, 0x7e, 0x03, 0x74, 0x88, 0x38, 0x2b, 0x0a } } },
    { L"EFI_STATUS_CODE_GUID",                                                { 0xd083e94c, 0x6560, 0x42e4, { 0xb6, 0xd4, 0x2d, 0xf7, 0x5a, 0xdf, 0x6a, 0x2a } } },
    { L"EFI_STATUS_CODE_RUNTIME_PROTOCOL_GUID",                               { 0xd2b2b828, 0x0826, 0x48a7, { 0xb3, 0xdf, 0x98, 0x3c, 0x00, 0x60, 0x24, 0xf0 } } },
    { L"EFI_STATUS_CODE_SPECIFIC_DATA_GUID",                                  { 0x335984bd, 0xe805, 0x409a, { 0xb8, 0xf8, 0xd2, 0x7e, 0xce, 0x5f, 0xf7, 0xa6 } } },
    { L"EFI_STORAGE_SECURITY_COMMAND_PROTOCOL_GUID",                          { 0xc88b0b6d, 0x0dfc, 0x49a7, { 0x9c, 0xb4, 0x49, 0x07, 0x4b, 0x4c, 0x3a, 0x78 } } },
    { L"EFI_SWAP_ADDRESS_RANGE_PROTOCOL_GUID",                                { 0x1259f60d, 0xb754, 0x468e, { 0xa7, 0x89, 0x4d, 0xb8, 0x5d, 0x55, 0xe8, 0x7e } } },
    { L"EFI_SYSTEM_NV_DATA_FV_GUID",                                          { 0xfff12b8d, 0x7696, 0x4c8b, { 0xa9, 0x85, 0x27, 0x47, 0x07, 0x5b, 0x4f, 0x50 } } },
    { L"EFI_SYSTEM_NV_DATA_HOB_GUID",                                         { 0xd6e5092d, 0xc7b2, 0x4872, { 0xaf, 0x66, 0xfd, 0xc0, 0xe6, 0xf9, 0x5e, 0x78 } } },
    { L"EFI_SYSTEM_TYPE_FRU_GUID",                                            { 0xaab16018, 0x679d, 0x4461, { 0xba, 0x20, 0xe7, 0x0c, 0xf7, 0x86, 0x6a, 0x9b } } },
    { L"EFI_TAPE_IO_PROTOCOL_GUID",                                           { 0x1e93e633, 0xd65a, 0x459e, { 0xab, 0x84, 0x93, 0xd9, 0xec, 0x26, 0x6d, 0x18 } } },
    { L"EFI_TCG_EVENT_HOB_GUID",                                              { 0x2b9ffb52, 0x1b13, 0x416f, { 0xa8, 0x7b, 0xbc, 0x93, 0x0d, 0xef, 0x92, 0xa8 } } },
    { L"EFI_TCG_LOG_HOB_GUID",                                                { 0x5f7d4e0e, 0x3d6d, 0x42bc, { 0xa9, 0x42, 0x0e, 0x91, 0xe8, 0x3e, 0x3c, 0x31 } } },
    { L"EFI_TCG_PEI_READ_ONLY_VARIABLE_PPI_GUID",                             { 0x3cdc90c6, 0x13fb, 0x4a75, { 0x9e, 0x79, 0x59, 0xe9, 0xdd, 0x78, 0xb9, 0xfa } } },
    { L"EFI_TCG_PLATFORM_PROTOCOL_GUID",                                      { 0x8c4c9a41, 0xbf56, 0x4627, { 0x9e, 0x0a, 0xc8, 0x38, 0x6d, 0x66, 0x11, 0x5c } } },
    { L"EFI_TCG_PRIVATE_INTERFACE_GUID",                                      { 0x8c4c9a41, 0xbf56, 0x4627, { 0x9e, 0x0a, 0xc8, 0x38, 0x6d, 0x66, 0x11, 0x5c } } },
    { L"EFI_TCG_PROTOCOL_GUID",                                               { 0xf541796d, 0xa62e, 0x4954, { 0xa7, 0x75, 0x95, 0x84, 0xf6, 0x1b, 0x9c, 0xdd } } },
    { L"EFI_TCG_WAKE_EVENT_DATA_HOB_GUID",                                    { 0xbbb810bb, 0x5ef0, 0x4e8f, { 0xb2, 0x98, 0xad, 0x74, 0xaa, 0x50, 0xef, 0x0a } } },
    { L"EFI_TCP4_PROTOCOL_GUID",                                              { 0x65530bc7, 0xa359, 0x410f, { 0xb0, 0x10, 0x5a, 0xad, 0xc7, 0xec, 0x2b, 0x62 } } },
    { L"EFI_TCP4_SERVICE_BINDING_PROTOCOL_GUID",                              { 0x00720665, 0x67eb, 0x4a99, { 0xba, 0xf7, 0xd3, 0xc3, 0x3a, 0x1c, 0x7c, 0xc9 } } },
    { L"EFI_TCP6_PROTOCOL_GUID",                                              { 0x46e44855, 0xbd60, 0x4ab7, { 0xab, 0x0d, 0xa6, 0x79, 0xb9, 0x44, 0x7d, 0x77 } } },
    { L"EFI_TCP6_SERVICE_BINDING_PROTOCOL_GUID",                              { 0xec20eb79, 0x6c1a, 0x4664, { 0x9a, 0x0d, 0xd2, 0xe4, 0xcc, 0x16, 0xd6, 0x64 } } },
    { L"EFI_TCP_PROTOCOL_GUID",                                               { 0x02b3d5f2, 0xac28, 0x11d3, { 0x9a, 0x2d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_TCP_SOCK_PROTOCOL_GUID",                                          { 0x5187359b, 0x790d, 0x425b, { 0xa5, 0x93, 0xca, 0x1c, 0xdb, 0x3c, 0xeb, 0xad } } },
    { L"EFI_TDT_PROTOCOL_GUID",                                               { 0x0bf70067, 0xd53b, 0x42df, { 0xb7, 0x70, 0xe9, 0x2c, 0x91, 0xc6, 0x14, 0x11 } } },
    { L"EFI_TELNET_SERVER_PROTOCOL_GUID",                                     { 0x6d3569d4, 0x85e5, 0x4943, { 0xae, 0x46, 0xee, 0x67, 0xa6, 0xe1, 0xab, 0x5a } } },
    { L"EFI_TIANO_DECOMPRESS_PROTOCOL_GUID",                                  { 0xe84cf29c, 0x191f, 0x4eae, { 0x96, 0xe1, 0xf4, 0x6a, 0xec, 0xea, 0xea, 0x0b } } },
    { L"EFI_TIMER_ARCH_PROTOCOL_GUID",                                        { 0x26baccb3, 0x6f42, 0x11d4, { 0xbc, 0xe7, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_TIMESTAMP_PROTOCOL_GUID",                                         { 0xafbfde41, 0x2e6e, 0x4262, { 0xba, 0x65, 0x62, 0xb9, 0x23, 0x6e, 0x54, 0x95 } } },
    { L"EFI_TIME_VARIABLE_GUID",                                              { 0x9d0da369, 0x540b, 0x46f8, { 0x85, 0xa0, 0x2b, 0x5f, 0x2c, 0x30, 0x1e, 0x15 } } },
    { L"EFI_TPM_DEVICE_PROTOCOL_GUID",                                        { 0xde161cfe, 0x1e60, 0x42a1, { 0x8c, 0xc3, 0xee, 0x7e, 0xf0, 0x73, 0x52, 0x12 } } },
    { L"EFI_TPM_STATE_INIT_HUB_GUID",                                         { 0xa0c6d918, 0x8dee, 0x41bb, { 0x9d, 0x92, 0x67, 0x53, 0xa5, 0x72, 0xb6, 0x52 } } },
    { L"EFI_TREE_PHYSICAL_PRESENCE_DATA_GUID",                                { 0xf24643c2, 0xc622, 0x494e, { 0x8a, 0x0d, 0x46, 0x32, 0x57, 0x9c, 0x2d, 0x5b } } },
    { L"EFI_TREE_PROTOCOL_GUID",                                              { 0x607f766c, 0x7455, 0x42be, { 0x93, 0x0b, 0xe4, 0xd7, 0x6d, 0xb2, 0x72, 0x0f } } },
    { L"EFI_TSC_FREQUENCY_GUID",                                              { 0xdba6a7e3, 0xbb57, 0x4be7, { 0x8a, 0xf8, 0xd5, 0x78, 0xdb, 0x7e, 0x56, 0x87 } } },
    { L"EFI_TXT_INFO_PROTOCOL_GUID",                                          { 0x601211dc, 0x0b12, 0x4c09, { 0xae, 0x27, 0xab, 0x0e, 0xc9, 0x69, 0x24, 0x68 } } },
    { L"EFI_UART_DEVICE_PATH_GUID",                                           { 0x37499a9d, 0x542f, 0x4c89, { 0xa0, 0x26, 0x35, 0xda, 0x14, 0x20, 0x94, 0xe4 } } },
    { L"EFI_UDP4_PROTOCOL_GUID",                                              { 0x3ad9df29, 0x4501, 0x478d, { 0xb1, 0xf8, 0x7f, 0x7f, 0xe7, 0x0e, 0x50, 0xf3 } } },
    { L"EFI_UDP4_SERVICE_BINDING_PROTOCOL_GUID",                              { 0x83f01464, 0x99bd, 0x45e5, { 0xb3, 0x83, 0xaf, 0x63, 0x05, 0xd8, 0xe9, 0xe6 } } },
    { L"EFI_UDP6_PROTOCOL_GUID",                                              { 0x4f948815, 0xb4b9, 0x43cb, { 0x8a, 0x33, 0x90, 0xe0, 0x60, 0xb3, 0x49, 0x55 } } },
    { L"EFI_UDP6_SERVICE_BINDING_PROTOCOL_GUID",                              { 0x66ed4721, 0x3c98, 0x4d3e, { 0x81, 0xe3, 0xd0, 0x3d, 0xd3, 0x9a, 0x72, 0x54 } } },
    { L"EFI_UDP_PROTOCOL_GUID",                                               { 0xc56fb1b2, 0x017b, 0x4984, { 0xa3, 0xf6, 0x3f, 0x73, 0x4f, 0xfa, 0x9e, 0x33 } } },
    { L"EFI_UGA_DRAW_PROTOCOL_GUID",                                          { 0x982c298b, 0xf4fa, 0x41cb, { 0xb8, 0x38, 0x77, 0xaa, 0x68, 0x8f, 0xb8, 0x39 } } },
    { L"EFI_UGA_IO_PROTOCOL_GUID",                                            { 0x61a4d49e, 0x6f68, 0x4f1b, { 0xb9, 0x22, 0xa8, 0x6e, 0xed, 0x0b, 0x07, 0xa2 } } },
    { L"EFI_UGA_SPLASH_PROTOCOL_GUID",                                        { 0xa45b3a0d, 0x2e55, 0x4c03, { 0xad, 0x9c, 0x27, 0xd4, 0x82, 0x0b, 0x50, 0x7e } } },
    { L"EFI_UNICODE_COLLATION2_PROTOCOL_GUID",                                { 0xa4c751fc, 0x23ae, 0x4c3e, { 0x92, 0xe9, 0x49, 0x64, 0xcf, 0x63, 0xf3, 0x49 } } },
    { L"EFI_UNICODE_COLLATION_PROTOCOL2_GUID",                                { 0xa4c751fc, 0x23ae, 0x4c3e, { 0x92, 0xe9, 0x49, 0x64, 0xcf, 0x63, 0xf3, 0x49 } } },
    { L"EFI_UNICODE_COLLATION_PROTOCOL_GUID",                                 { 0x1d85cd7f, 0xf43d, 0x11d2, { 0x9a, 0x0c, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_UPDATE_DATA_FILE_GUID",                                           { 0x283fa2ee, 0x532c, 0x484d, { 0x93, 0x83, 0x9f, 0x93, 0xb3, 0x6f, 0x0b, 0x7e } } },
    { L"EFI_USB2_HC_PROTOCOL_GUID",                                           { 0x3e745226, 0x9818, 0x45b6, { 0xa2, 0xac, 0xd7, 0xcd, 0x0e, 0x8b, 0xa2, 0xbc } } },
    { L"EFI_USB_ATAPI_PROTOCOL_GUID",                                         { 0x2b2f68da, 0x0cd2, 0x44cf, { 0x8e, 0x8b, 0xbb, 0xa2, 0x0b, 0x1b, 0x5b, 0x75 } } },
    { L"EFI_USB_HC_PROTOCOL_GUID",                                            { 0xf5089266, 0x1aa0, 0x4953, { 0x97, 0xd8, 0x56, 0x2f, 0x8a, 0x73, 0xb5, 0x19 } } },
    { L"EFI_USB_IO_PROTOCOL_GUID",                                            { 0x2b2f68d6, 0x0cd2, 0x44cf, { 0x8e, 0x8b, 0xbb, 0xa2, 0x0b, 0x1b, 0x5b, 0x75 } } },
    { L"EFI_USB_POLICY_PROTOCOL_GUID",                                        { 0x5859cb76, 0x6bef, 0x468a, { 0xbe, 0x2d, 0xb3, 0xdd, 0x1a, 0x27, 0xf0, 0x12 } } },
    { L"EFI_USB_PROTOCOL_GUID",                                               { 0x2ad8e2d2, 0x2e91, 0x4cd1, { 0x95, 0xf5, 0xe7, 0x8f, 0xe5, 0xeb, 0xe3, 0x16 } } },
    { L"EFI_USER_CREDENTIAL2_PROTOCOL_GUID",                                  { 0xe98adb03, 0xb8b9, 0x4af8, { 0xba, 0x20, 0x26, 0xe9, 0x11, 0x4c, 0xbc, 0xe5 } } },
    { L"EFI_USER_CREDENTIAL_PROTOCOL_GUID",                                   { 0x71ee5e94, 0x65b9, 0x45d5, { 0x82, 0x1a, 0x3a, 0x4d, 0x86, 0xcf, 0xe6, 0xbe } } },
    { L"EFI_USER_INFO_ACCESS_SETUP_ADMIN_GUID",                               { 0x85b75607, 0xf7ce, 0x471e, { 0xb7, 0xe4, 0x2a, 0xea, 0x5f, 0x72, 0x32, 0xee } } },
    { L"EFI_USER_INFO_ACCESS_SETUP_NORMAL_GUID",                              { 0x1db29ae0, 0x9dcb, 0x43bc, { 0x8d, 0x87, 0x5d, 0xa1, 0x49, 0x64, 0xdd, 0xe2 } } },
    { L"EFI_USER_INFO_ACCESS_SETUP_RESTRICTED_GUID",                          { 0xbdb38125, 0x4d63, 0x49f4, { 0x82, 0x12, 0x61, 0xcf, 0x5a, 0x19, 0x0a, 0xf8 } } },
    { L"EFI_USER_MANAGER_PROTOCOL_GUID",                                      { 0x6fd5b00c, 0xd426, 0x4283, { 0x98, 0x87, 0x6c, 0xf5, 0xcf, 0x1c, 0xb1, 0xfe } } },
    { L"EFI_VARIABLE_ARCH_PROTOCOL_GUID",                                     { 0x1e5668e2, 0x8481, 0x11d4, { 0xbc, 0xf1, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_VARIABLE_GUID",                                                   { 0xddcf3616, 0x3275, 0x4164, { 0x98, 0xb6, 0xfe, 0x85, 0x70, 0x7f, 0xfe, 0x7d } } },
    { L"EFI_VARIABLE_INDEX_TABLE_GUID",                                       { 0x8cfdb8c8, 0xd6b2, 0x40f3, { 0x8e, 0x97, 0x02, 0x30, 0x7c, 0xc9, 0x8b, 0x7c } } },
    { L"EFI_VARIABLE_STORE_PROTOCOL_GUID",                                    { 0xf088cd91, 0xa046, 0x11d2, { 0x8e, 0x42, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"EFI_VARIABLE_WRITE_ARCH_PROTOCOL_GUID",                               { 0x6441f818, 0x6362, 0x4e44, { 0xb5, 0x70, 0x7d, 0xba, 0x31, 0xdd, 0x24, 0x53 } } },
    { L"EFI_VGA_MINI_PORT_PROTOCOL_GUID",                                     { 0xc7735a2f, 0x88f5, 0x4882, { 0xae, 0x63, 0xfa, 0xac, 0x8c, 0x8b, 0x86, 0xb3 } } },
    { L"EFI_VIRTUAL_MEMORY_ACCESS_PROTOCOL_GUID",                             { 0x745d377a, 0xb988, 0x47b2, { 0xb1, 0x8f, 0xbb, 0xc8, 0x0d, 0xc5, 0x66, 0x98 } } },
    { L"EFI_VLAN_CONFIG_PROTOCOL_GUID",                                       { 0x9e23d768, 0xd2f3, 0x4366, { 0x9f, 0xc3, 0x3a, 0x7a, 0xba, 0x86, 0x43, 0x74 } } },
    { L"EFI_VT_100_GUID",                                                     { 0xdfa66065, 0xb419, 0x11d3, { 0x9a, 0x2d, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_VT_100_PLUS_GUID",                                                { 0x7baec70b, 0x57e0, 0x4c76, { 0x8e, 0x87, 0x2f, 0x9e, 0x28, 0x08, 0x83, 0x43 } } },
    { L"EFI_VT_UTF8_GUID",                                                    { 0xad15a0d6, 0x8bec, 0x4acf, { 0xa0, 0x73, 0xd0, 0x1d, 0xe7, 0x7e, 0x2d, 0x88 } } },
    { L"EFI_WATCHDOG_TIMER_ARCH_PROTOCOL_GUID",                               { 0x665e3ff5, 0x46cc, 0x11d4, { 0x9a, 0x38, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EFI_WIN_NT_BUS_DRIVER_IO_PROTOCOL_GUID",                              { 0x96eb4ad6, 0xa32a, 0x11d4, { 0xbc, 0xfd, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_CONSOLE_GUID",                                             { 0xba73672c, 0xa5d3, 0x11d4, { 0xbd, 0x00, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_CPU_MODEL_GUID",                                           { 0xbee9b6ce, 0x2f8a, 0x11d4, { 0xbd, 0x0d, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_CPU_SPEED_GUID",                                           { 0xd4f29055, 0xe1fb, 0x11d4, { 0xbd, 0x0d, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_FILE_SYSTEM_GUID",                                         { 0x0c95a935, 0xa006, 0x11d4, { 0xbc, 0xfa, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_GOP_GUID",                                                 { 0x4e11e955, 0xccca, 0x11d4, { 0xbd, 0x0d, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_IO_PROTOCOL_GUID",                                         { 0x96eb4ad6, 0xa32a, 0x11d4, { 0xbc, 0xfd, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_MEMORY_GUID",                                              { 0x99042912, 0x122a, 0x11d4, { 0xbd, 0x0d, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_PASS_THROUGH_GUID",                                        { 0xcc664eb8, 0x3c24, 0x4086, { 0xb6, 0xf6, 0x34, 0xe8, 0x56, 0xbc, 0xe3, 0x6e } } },
    { L"EFI_WIN_NT_PHYSICAL_DISKS_GUID",                                      { 0x0c95a92f, 0xa006, 0x11d4, { 0xbc, 0xfa, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_SERIAL_PORT_GUID",                                         { 0x0c95a93d, 0xa006, 0x11d4, { 0xbc, 0xfa, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_SYSTEM_CONFIG_GUID",                                       { 0xb347f047, 0xaf8c, 0x490e, { 0xac, 0x07, 0x0a, 0xa9, 0xb7, 0xe5, 0x38, 0x58 } } },
    { L"EFI_WIN_NT_THUNK_PROTOCOL_GUID",                                      { 0x58c518b1, 0x76f3, 0x11d4, { 0xbc, 0xea, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_UGA_GUID",                                                 { 0xab248e99, 0xabe1, 0x11d4, { 0xbd, 0x0d, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_WIN_NT_VIRTUAL_DISKS_GUID",                                       { 0x0c95a928, 0xa006, 0x11d4, { 0xbc, 0xfa, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"EFI_XEN_INFO_GUID",                                                   { 0xd3b46f3b, 0xd441, 0x1244, { 0x9a, 0x12, 0x00, 0x12, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"EMBEDDED_DEVICE_PROTOCOL_GUID",                                       { 0xbf4b9d10, 0x13ec, 0x43dd, { 0x88, 0x80, 0xe9, 0x0b, 0x71, 0x8f, 0x27, 0xde } } },
    { L"EMBEDDED_EXTERNAL_DEVICE_PROTOCOL_GUID",                              { 0x735f8c64, 0xd696, 0x44d0, { 0xbd, 0xf2, 0x44, 0x7f, 0xd0, 0x5a, 0x54, 0x06 } } },
    { L"EMU_BLOCK_IO_PROTOCOL_GUID",                                          { 0x6888a4ae, 0xafce, 0xe84b, { 0x91, 0x02, 0xf7, 0xb9, 0xda, 0xe6, 0xa0, 0x30 } } },
    { L"EMU_GRAPHICS_WINDOW_PROTOCOL_GUID",                                   { 0x30fd316a, 0x6728, 0x2e41, { 0xa6, 0x90, 0x0d, 0x13, 0x33, 0xd8, 0xca, 0xc1 } } },
    { L"EMU_IO_THUNK_PROTOCO_GUID",                                           { 0x453368f6, 0x7c85, 0x434a, { 0xa9, 0x8a, 0x72, 0xd1, 0xb7, 0xff, 0xa9, 0x26 } } },
    { L"EMU_SNP_PROTOCOL_GUID",                                               { 0xfd5fbe54, 0x8c35, 0xb345, { 0x8a, 0x0f, 0x7a, 0xc8, 0xa5, 0xfd, 0x05, 0x21 } } },
    { L"EMU_THUNK_PPI_GUID",                                                  { 0xb958b78c, 0x1d3e, 0xee40, { 0x8b, 0xf4, 0xf0, 0x63, 0x2d, 0x06, 0x39, 0x16 } } },
    { L"EMU_THUNK_PROTOCOL_GUID",                                             { 0x5cf32e0b, 0x8edf, 0x2e44, { 0x9c, 0xda, 0x93, 0x20, 0x5e, 0x99, 0xec, 0x1c } } },
    { L"ERROR_MANAGER_GUID",                                                  { 0xaddebf82, 0xa560, 0x46b9, { 0xa2, 0x80, 0x78, 0xc6, 0xab, 0x61, 0xae, 0xda } } },
    { L"EXIT_FORM_SET_GUID",                                                  { 0xa43b03dc, 0xc18a, 0x41b1, { 0x91, 0xc8, 0x3f, 0xf9, 0xaa, 0xa2, 0x57, 0x13 } } },
    { L"EXIT_PAGE_GUID",                                                      { 0xec87d643, 0xeba4, 0x4bb5, { 0xa1, 0xe5, 0x3f, 0x3e, 0x36, 0xb2, 0x0d, 0xa9 } } },
    { L"EXIT_PM_AUTH_PROTOCOL_GUID",                                          { 0xd088a413, 0x0a70, 0x4217, { 0xba, 0x55, 0x9a, 0x3c, 0xb6, 0x5c, 0x41, 0xb3 } } },
    { L"EXTENDED_SAL_BOOT_SERVICE_PROTOCOL_GUID",                             { 0xde0ee9a4, 0x3c7a, 0x44f2, { 0xb7, 0x8b, 0xe3, 0xcc, 0xd6, 0x9c, 0x3a, 0xf7 } } },
    { L"FAST_BOOT_TSE_PROTOCOL_GUID",                                         { 0x0fba43b8, 0xacdb, 0x4ee2, { 0xab, 0x31, 0x0f, 0xa4, 0xd5, 0xb6, 0xc3, 0xc5 } } },
    { L"FAST_BOOT_VARIABLE_GUID",                                             { 0xb540a530, 0x6978, 0x4da7, { 0x91, 0xcb, 0x72, 0x07, 0xd7, 0x64, 0xd2, 0x62 } } },
    { L"FID_TABLE_GUID",                                                      { 0x3fd1d3a2, 0x99f7, 0x420b, { 0xbc, 0x69, 0x8b, 0xb1, 0xd4, 0x92, 0xa3, 0x32 } } },
    { L"FID_TABLE_SECTION_GUID",                                              { 0x2ebe0275, 0x6458, 0x4af9, { 0x91, 0xed, 0xd3, 0xf4, 0xed, 0xb1, 0x00, 0xaa } } },
    { L"FILE_EXPLORE_FORMSET_GUID",                                           { 0x1f2d63e1, 0xfebd, 0x4dc7, { 0x9c, 0xc5, 0xba, 0x2b, 0x1c, 0xef, 0x9c, 0x5b } } },
    { L"FIRMWARE_PERFORMANCE_PROTOCOL_GUID",                                  { 0xbc412d75, 0x2729, 0x4c3a, { 0xb1, 0x93, 0x5b, 0x9a, 0x58, 0x8f, 0xf6, 0x6f } } },
    { L"FIRMWARE_PERFORMANCE_S3_POINTER_GUID",                                { 0x0dc65adc, 0xa973, 0x4130, { 0x8d, 0xf0, 0x2a, 0xdb, 0xeb, 0x9e, 0x4a, 0x31 } } },
    { L"FLASH_PROTOCOL_GUID",                                                 { 0x755b6596, 0x6896, 0x4ba3, { 0xb3, 0xdd, 0x1c, 0x62, 0x9f, 0xd1, 0xea, 0x88 } } },
    { L"FLASH_SMM_PROTOCOL_GUID",                                             { 0xecb867ab, 0x8df4, 0x492d, { 0x81, 0x50, 0xa7, 0xfd, 0x1b, 0x9b, 0x5a, 0x75 } } },
    { L"FLASH_UPDATE_GUID",                                                   { 0x974231d5, 0xed4b, 0x44d1, { 0x88, 0x70, 0xce, 0x51, 0x5c, 0xc1, 0x4d, 0x68 } } },
    { L"FONT_FFS_FILE_GUID",                                                  { 0xdac2b117, 0xb5fb, 0x4964, { 0xa3, 0x12, 0x0d, 0xcc, 0x77, 0x06, 0x1b, 0x9b } } },
    { L"FORM_BROWSER_EXTENSION_PROTOCOL_GUID",                                { 0x1f73b18d, 0x4630, 0x43c1, { 0xa1, 0xde, 0x6f, 0x80, 0x85, 0x5d, 0x7d, 0xa4 } } },
    { L"FPDT_PERFORMANCE_PROTOCOL_GUID",                                      { 0x444c3203, 0xf8b1, 0x42a7, { 0xab, 0xe9, 0x2e, 0x58, 0x02, 0x5b, 0xe1, 0x2a } } },
    { L"FRAMEWORK_BDS_FRONTPAGE_FORMSET_GUID",                                { 0x9e0c30bc, 0x3f06, 0x4ba6, { 0x82, 0x88, 0x09, 0x17, 0x9b, 0x85, 0x5d, 0xbe } } },
    { L"FRAMEWORK_EFI_FIRMWARE_VOLUME_BLOCK_PROTOCOL_GUID",                   { 0xde28bc59, 0x6228, 0x41bd, { 0xbd, 0xf6, 0xa3, 0xb9, 0xad, 0xb5, 0x8d, 0xa1 } } },
    { L"FRAMEWORK_EFI_MP_SERVICES_PROTOCOL_GUID",                             { 0xf33261e7, 0x23cb, 0x11d5, { 0xbd, 0x5c, 0x00, 0x80, 0xc7, 0x3c, 0x88, 0x81 } } },
    { L"FRONT_PAGE_FORMSET_GUID",                                             { 0x9e0c30bc, 0x3f06, 0x4ba6, { 0x82, 0x88, 0x09, 0x17, 0x9b, 0x85, 0x5d, 0xbe } } },
    { L"FW_VERSION_GUID",                                                     { 0xb5c59087, 0xfeac, 0x4b41, { 0x9d, 0x80, 0x79, 0x0b, 0xa5, 0xaa, 0x07, 0x0f } } },
    { L"FW_VOLUME_BLOCK_PROTOCOL_GUID",                                       { 0xde28bc59, 0x6228, 0x41bd, { 0xbd, 0xf6, 0xa3, 0xb9, 0xad, 0xb5, 0x8d, 0xa1 } } },
    { L"HANDLE_PARSING_HII_GUID",                                             { 0xb8969637, 0x81de, 0x43af, { 0xbc, 0x9a, 0x24, 0xd9, 0x89, 0x13, 0xf2, 0xf6 } } },
    { L"HD_BOOT_DEVICE_PATH_VARIABLE_GUID",                                   { 0xfab7e9e1, 0x39dd, 0x4f2b, { 0x84, 0x08, 0xe2, 0x0e, 0x90, 0x6c, 0xb6, 0xde } } },
    { L"HDD_SECURITY_END_PROTOCOL_GUID",                                      { 0xad77ae29, 0x4c20, 0x4fdd, { 0x85, 0x04, 0x81, 0x76, 0x61, 0x9b, 0x67, 0x6a } } },
    { L"HDD_SECURITY_INIT_PROTOCOL_GUID",                                     { 0xce6f86bb, 0xb800, 0x4c71, { 0xb2, 0xd1, 0x38, 0x97, 0xa3, 0xbc, 0x1d, 0xae } } },
    { L"HDD_SMART_INIT_PROTOCOL_GUID",                                        { 0x9401bd4f, 0x1a00, 0x4990, { 0xab, 0x56, 0xda, 0xf0, 0xe4, 0xe3, 0x48, 0xde } } },
    { L"HDD_UNLOCKED_GUID",                                                   { 0x1fd29be6, 0x70d0, 0x42a4, { 0xa6, 0xe7, 0xe5, 0xd1, 0x0e, 0x6a, 0xc3, 0x76 } } },
    { L"HECI_PROTOCOL_GUID",                                                  { 0xcfb33810, 0x6e87, 0x4284, { 0xb2, 0x03, 0xa6, 0x6a, 0xbe, 0x07, 0xf6, 0xe8 } } },
    { L"HII_RESOURCE_SAMPLE_FORM_SET_GUID",                                   { 0x4f4ef7f0, 0xaa29, 0x4ce9, { 0xba, 0x41, 0x64, 0x3e, 0x01, 0x23, 0xa9, 0x9f } } },
    { L"HII_RESOURCES_FFS_SECTION_GUID",                                      { 0x97e409e6, 0x4cc1, 0x11d9, { 0x81, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } } },
    { L"HOB_LIST_GUID",                                                       { 0x7739f24c, 0x93d7, 0x11d4, { 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"HOT_PLUG_DEVICE_GUID",                                                { 0x220ac432, 0x1d43, 0x49e5, { 0xa7, 0x4f, 0x4c, 0x9d, 0xa6, 0x7a, 0xd2, 0x3b } } },
    { L"ICC_OVERCLOCKING_PROTOCOL_GUID",                                      { 0x8e8cbc58, 0x834c, 0x41e3, { 0xb8, 0xca, 0xf0, 0x0c, 0xcf, 0x5a, 0x71, 0x7c } } },
    { L"ICC_PERSISTENT_DATA_GUID",                                            { 0x64192dca, 0xd034, 0x49d2, { 0xa6, 0xde, 0x65, 0xa8, 0x29, 0xeb, 0x4c, 0x74 } } },
    { L"ICC_VOLATILE_SETUP_DATA_GUID",                                        { 0x7b77fb8b, 0x1e0d, 0x4d7e, { 0x95, 0x3f, 0x39, 0x80, 0xa2, 0x61, 0xe0, 0x77 } } },
    { L"IDE_BUS_DRIVER_BINDING_PROTOCOL_GUID",                                { 0x8aa67071, 0x8bec, 0x47ab, { 0x83, 0xc8, 0xcd, 0x0e, 0xb7, 0x23, 0xd0, 0x72 } } },
    { L"IDE_BUS_INIT_PROTOCOL_GUID",                                          { 0xe159a956, 0x3299, 0x4ee9, { 0x91, 0x76, 0x65, 0x18, 0x1a, 0x4e, 0x5e, 0x9f } } },
    { L"IDE_CONTROLLER_PROTOCOL_GUID",                                        { 0x20e28787, 0xdf32, 0x4bda, { 0xb7, 0xe7, 0xcb, 0xbd, 0xa3, 0x37, 0x1e, 0xf8 } } },
    { L"IDE_HPA_INTERFACE_GUID",                                              { 0x51aa65fc, 0x82b6, 0x49e6, { 0x95, 0xe2, 0xe6, 0x82, 0x7a, 0x8d, 0x7d, 0xb4 } } },
    { L"IDE_POWER_MGMT_INTERFACE_GUID",                                       { 0x67bc3883, 0x7e79, 0x4bc1, { 0xa3, 0x3e, 0x3a, 0xf7, 0xd1, 0x75, 0x89, 0xba } } },
    { L"IDE_SECURITY_INTERFACE_GUID",                                         { 0xf4f63529, 0x281e, 0x4040, { 0xa3, 0x13, 0xc1, 0xd6, 0x76, 0x63, 0x84, 0xbe } } },
    { L"IDE_SECURITY_PWNV_GUID",                                              { 0x69967a8c, 0x1159, 0x4522, { 0xaa, 0x89, 0x74, 0xcd, 0xc6, 0xe5, 0x99, 0xa0 } } },
    { L"IDE_SETUP_PROTOCOL_GUID",                                             { 0x5578ae16, 0xf1c9, 0x4e8f, { 0xb1, 0x29, 0xba, 0x07, 0xf8, 0xfc, 0xf8, 0x4a } } },
    { L"IDE_SMART_INTERFACE_GUID",                                            { 0xffbd9ad2, 0xf1db, 0x4f92, { 0xa6, 0x49, 0xeb, 0x9e, 0xed, 0xea, 0x86, 0xb5 } } },
    { L"IDLE_LOOP_EVENT_GUID",                                                { 0x3c8d294c, 0x5fc3, 0x4451, { 0xbb, 0x31, 0xc4, 0xc0, 0x32, 0x29, 0x5e, 0x6c } } },
    { L"IFFS_ACPI_TABLE_STORAGE_GUID",                                        { 0x60ac3a8f, 0x4d66, 0x4cd4, { 0x89, 0x5a, 0xc3, 0xf0, 0x6e, 0x66, 0x65, 0xee } } },
    { L"IFFS_GLOBAL_NVS_AREA_PROTOCOL_GUID",                                  { 0xa5559f06, 0x6415, 0x4759, { 0x88, 0x69, 0xde, 0x15, 0xf9, 0xcd, 0x9c, 0x9b } } },
    { L"IFFS_GPT_GUID",                                                       { 0xd3bfe2de, 0x3daf, 0x11df, { 0xba, 0x40, 0xe3, 0xa5, 0x56, 0xd8, 0x95, 0x93 } } },
    { L"IFFS_INFO_PROTOCOL_GUID",                                             { 0xd231db5b, 0x4a9c, 0x4092, { 0xa8, 0xc5, 0x9c, 0xa0, 0xbc, 0x7d, 0x6a, 0xa6 } } },
    { L"IFFS_PARTITION_STATUS_PROTOCOL_GUID",                                 { 0x65639144, 0xd492, 0x4328, { 0xa4, 0x98, 0xf4, 0xb5, 0x54, 0x5e, 0x4a, 0x30 } } },
    { L"IFFS_PERSISTENT_DATA_GUID",                                           { 0xf9f0b131, 0xf346, 0x4f16, { 0x80, 0xdd, 0xf9, 0x41, 0x07, 0x2b, 0x3a, 0x7d } } },
    { L"IFFS_PLATFORM_POLICY_PROTOCOL_GUID",                                  { 0x42bbaca3, 0x7161, 0x4891, { 0xac, 0x10, 0xc7, 0x5e, 0x2e, 0x4d, 0xf6, 0x14 } } },
    { L"IFFS_PPI_GUID",                                                       { 0x3d0e663a, 0xdc72, 0x4489, { 0x87, 0xc5, 0xe4, 0x9e, 0xe7, 0x73, 0xa4, 0x52 } } },
    { L"IGD_OPREGION_PROTOCOL_GUID",                                          { 0xcdc5dddf, 0xe79d, 0x41ec, { 0xa9, 0xb0, 0x65, 0x65, 0x49, 0x0d, 0xb9, 0xd3 } } },
    { L"INTEL_FRAMEWORK_MODULEPKG_TOKEN_SPACE_GUID",                          { 0xd3705011, 0xbc19, 0x4af7, { 0xbe, 0x16, 0xf6, 0x80, 0x30, 0x37, 0x8c, 0x15 } } },
    { L"INTEL_MEBX_PROTOCOL_GUID",                                            { 0x01ab1829, 0xcecd, 0x4cfa, { 0xa1, 0x8c, 0xea, 0x75, 0xd6, 0x6f, 0x3e, 0x74 } } },
    { L"IP4_ISCSI_CONFIG_GUID",                                               { 0x6456ed61, 0x3579, 0x41c9, { 0x8a, 0x26, 0x0a, 0x0b, 0xd6, 0x2b, 0x78, 0xfc } } },
    { L"IP6_CONFIG_NVDATA_GUID",                                              { 0x02eea107, 0x98db, 0x400e, { 0x98, 0x30, 0x46, 0x0a, 0x15, 0x42, 0xd7, 0x99 } } },
    { L"ISCSI_CHAP_AUTH_INFO_GUID",                                           { 0x786ec0ac, 0x65ae, 0x4d1b, { 0xb1, 0x37, 0x0d, 0x11, 0x0a, 0x48, 0x37, 0x97 } } },
    { L"ISCSI_CONFIG_GUID",                                                   { 0x4b47d616, 0xa8d6, 0x4552, { 0x9d, 0x44, 0xcc, 0xad, 0x2e, 0x0f, 0x4c, 0xf9 } } },
    { L"ISCSI_V4_PRIVATE_GUID",                                               { 0xfa3cde4c, 0x87c2, 0x427d, { 0xae, 0xde, 0x7d, 0xd0, 0x96, 0xc8, 0x8c, 0x58 } } },
    { L"ISCSI_V6_PRIVATE_GUID",                                               { 0x28be27e5, 0x66cc, 0x4a31, { 0xa3, 0x15, 0xdb, 0x14, 0xc3, 0x74, 0x4d, 0x85 } } },
    { L"LAST_ENUM_LANGUAGE_GUID",                                             { 0x0e8c545b, 0xa2ee, 0x470d, { 0x8e, 0x26, 0xbd, 0xa1, 0xa1, 0x3c, 0x0a, 0xa3 } } },
    { L"LDR_MEMORY_DESCRIPTOR_GUID",                                          { 0x7701d7e5, 0x7d1d, 0x4432, { 0xa4, 0x68, 0x67, 0x3d, 0xab, 0x8a, 0xde, 0x60 } } },
    { L"LEGACY_DEV_ORDER_GUID",                                               { 0xa56074db, 0x65fe, 0x45f7, { 0xbd, 0x21, 0x2d, 0x2b, 0xdd, 0x8e, 0x96, 0x52 } } },
    { L"LOAD_FILE_PROTOCOL_GUID",                                             { 0x56ec3091, 0x954c, 0x11d2, { 0x8e, 0x3f, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"LZMA_CUSTOM_DECOMPRESS_GUID",                                         { 0xee4e5898, 0x3914, 0x4259, { 0x9d, 0x6e, 0xdc, 0x7b, 0xd7, 0x94, 0x03, 0xcf } } },
    { L"LZMAF86_CUSTOM_DECOMPRESS_GUID",                                      { 0xd42ae6bd, 0x1352, 0x4bfb, { 0x90, 0x9a, 0xca, 0x72, 0xa6, 0xea, 0xe8, 0x89 } } },
    { L"MAIN_FORM_SET_GUID",                                                  { 0x985eee91, 0xbcac, 0x4238, { 0x87, 0x78, 0x57, 0xef, 0xdc, 0x93, 0xf2, 0x4e } } },
    { L"MDEMODULEPKG_TOKEN_SPACE_GUID",                                       { 0xa1aff049, 0xfdeb, 0x442a, { 0xb3, 0x20, 0x13, 0xab, 0x4c, 0xb7, 0x2b, 0xbc } } },
    { L"MDEPKG_TOKEN_SPACE_GUID",                                             { 0x914aebe7, 0x4635, 0x459b, { 0xaa, 0x1c, 0x11, 0xe2, 0x19, 0xb0, 0x3a, 0x10 } } },
    { L"MDES_STATUS_CODE_PROTOCOL_GUID",                                      { 0xe5d0875a, 0xf647, 0x4e16, { 0xbe, 0x4d, 0x95, 0x02, 0x40, 0x29, 0xcc, 0x44 } } },
    { L"ME_ALERT_AT_HANDLER_GUID",                                            { 0xb441df87, 0x8d94, 0x4811, { 0x85, 0xf7, 0x0f, 0x9a, 0x7b, 0xf8, 0x9d, 0x2a } } },
    { L"ME_BIOS_PAYLOAD_DATA_PROTOCOL_GUID",                                  { 0x71a19494, 0x2ab6, 0x4e96, { 0x85, 0x81, 0xcf, 0x34, 0x25, 0x42, 0x73, 0xfe } } },
    { L"MEBX_FILE_GUID",                                                      { 0x7c81c66a, 0x4f11, 0x47ab, { 0x82, 0xd3, 0x67, 0xc4, 0xd6, 0x35, 0xae, 0xd1 } } },
    { L"ME_INFO_SETUP_GUID",                                                  { 0x78259433, 0x7b6d, 0x4db3, { 0x9a, 0xe8, 0x36, 0xc4, 0xc2, 0xc3, 0xa1, 0x7d } } },
    { L"MEM_INFO_PROTOCOL_GUID",                                              { 0x6f20f7c8, 0xe5ef, 0x4f21, { 0x8d, 0x19, 0xed, 0xc5, 0xf0, 0xc4, 0x96, 0xae } } },
    { L"MEMORY_ONLY_RESET_CONTROL_GUID",                                      { 0xe20939be, 0x32d4, 0x41be, { 0xa1, 0x50, 0x89, 0x7f, 0x85, 0xd4, 0x98, 0x29 } } },
    { L"MEMORY_STATUS_CODE_RECORD_GUID",                                      { 0x060cc026, 0x4c0d, 0x4dda, { 0x8f, 0x41, 0x59, 0x5f, 0xef, 0x00, 0xa5, 0x02 } } },
    { L"ME_PLATFORM_GET_RESET_TYPE_GUID",                                     { 0xb8cdced7, 0xbdc4, 0x4464, { 0x9a, 0x1a, 0xff, 0x3f, 0xbd, 0xf7, 0x48, 0x69 } } },
    { L"MEUD_ERROR_GUID",                                                     { 0x0732bd39, 0xd6b0, 0x4039, { 0xb6, 0xc2, 0x96, 0x54, 0x46, 0x6d, 0xe5, 0x25 } } },
    { L"MEUD_FILE_GUID",                                                      { 0xfeaaa7a6, 0xcb95, 0x4670, { 0xb4, 0x99, 0x87, 0x7f, 0xa6, 0xca, 0x6b, 0xae } } },
    { L"MICROCODE_LOADER_PPI_GUID",                                           { 0x9b6eecf6, 0xfbdc, 0x4db6, { 0x95, 0x62, 0xd2, 0x5f, 0x40, 0xd5, 0x76, 0x61 } } },
    { L"MINI_SETUP_RESOURCE_SECTION_GUID",                                    { 0x97e409e6, 0x4cc1, 0x11d9, { 0x81, 0xf6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } } },
    { L"MTC_VENDOR_GUID",                                                     { 0xeb704011, 0x1402, 0x11d3, { 0x8e, 0x77, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"MXM30_PEI_GUID",                                                      { 0x2ef1ba1a, 0xc836, 0x4a50, { 0xbf, 0x89, 0x52, 0x5f, 0xf2, 0x9f, 0xf7, 0x87 } } },
    { L"MXM3_EFI_GUID",                                                       { 0x4ea9d4fe, 0xe6f6, 0x410b, { 0x90, 0x37, 0x0f, 0x98, 0xb5, 0x96, 0x8b, 0x65 } } },
    { L"NBCI_EFI_GUID",                                                       { 0x4ea9d4fe, 0xe6f6, 0x410b, { 0x80, 0x37, 0x0f, 0x98, 0xb5, 0x96, 0x8b, 0x65 } } },
    { L"NETWORK_STACK_GUID",                                                  { 0xd1405d16, 0x7afc, 0x4695, { 0xbb, 0x12, 0x41, 0x45, 0x9d, 0x36, 0x95, 0xa2 } } },
    { L"NT_FWH_PPI_GUID",                                                     { 0x4e76928f, 0x50ad, 0x4334, { 0xb0, 0x6b, 0xa8, 0x42, 0x13, 0x10, 0x8a, 0x57 } } },
    { L"NT_PEI_LOAD_FILE_GUID",                                               { 0xfd0c65eb, 0x0405, 0x4cd2, { 0x8a, 0xee, 0xf4, 0x00, 0xef, 0x13, 0xba, 0xc2 } } },
    { L"NVM_EXPRESS_PASS_THRU_PROTOCOL_GUID",                                 { 0xec51ef5c, 0x2cf3, 0x4a55, { 0xbf, 0x85, 0xb6, 0x3c, 0xa3, 0xb1, 0x3f, 0x44 } } },
    { L"NVRAM_HOB_GUID",                                                      { 0xc0ec00fd, 0xc2f8, 0x4e47, { 0x90, 0xef, 0x9c, 0x81, 0x55, 0x28, 0x5b, 0xec } } },
    { L"NVRAM_MAILBOX_ADDRESS_VARIABLE_GUID",                                 { 0x54913a6d, 0xf4ee, 0x4cdb, { 0x84, 0x75, 0x74, 0x06, 0x2b, 0xfc, 0xec, 0xf5 } } },
    { L"OEM_RECOVERY_CAPSULE_GUID",                                           { 0x595a6edc, 0x6d2c, 0x474a, { 0x90, 0x82, 0x3b, 0x99, 0x28, 0x51, 0xdf, 0xfe } } },
    { L"OEM_ROM_HOLE_0_GUID",                                                 { 0x05ca01fc, 0x0fc1, 0x11dc, { 0x90, 0x11, 0x00, 0x17, 0x31, 0x53, 0xeb, 0xa8 } } },
    { L"OEM_ROM_HOLE_1_GUID",                                                 { 0x05ca01fd, 0x0fc1, 0x11dc, { 0x90, 0x11, 0x00, 0x17, 0x31, 0x53, 0xeb, 0xa8 } } },
    { L"OEM_TSE_VAR_GUID",                                                    { 0xf4b2c007, 0x94a1, 0x4cd5, { 0xa7, 0x10, 0xf4, 0x14, 0x1f, 0xce, 0xbc, 0xa0 } } },
    { L"ONBOARD_RAID_GUID",                                                   { 0x5d206dd3, 0x516a, 0x47dc, { 0xa1, 0xbc, 0x6d, 0xa2, 0x04, 0xaa, 0xbe, 0x08 } } },
    { L"OPAL_SEC_INIT_PROTOCOL_GUID",                                         { 0x59af16b0, 0x661d, 0x4865, { 0xa3, 0x81, 0x38, 0xde, 0x68, 0x38, 0x5d, 0x8d } } },
    { L"OPROM_START_END_PROTOCOL_GUID",                                       { 0xf2a128ff, 0x257b, 0x456e, { 0x9d, 0xe8, 0x63, 0xe7, 0xc7, 0xdc, 0xdf, 0xac } } },
    { L"PARTITION_VARIABLE_GUID",                                             { 0x8db699cc, 0xbc81, 0x41e2, { 0xaa, 0xc6, 0xd8, 0x1d, 0x53, 0x00, 0xd7, 0x59 } } },
    { L"PASSWORD_HOB_GUID",                                                   { 0x79ce097a, 0x91aa, 0x41ff, { 0xb3, 0xa8, 0x53, 0x45, 0x59, 0xb3, 0x0d, 0xb1 } } },
    { L"PCATCHIPSET_TOKEN_SPACE_GUID",                                        { 0x326ae723, 0xae32, 0x4589, { 0x98, 0xb8, 0xca, 0xc2, 0x3c, 0xdc, 0xc1, 0xb1 } } },
    { L"PCD_DATABASE_HOB_GUID",                                               { 0xea296d92, 0x0b69, 0x423c, { 0x8c, 0x28, 0x33, 0xb4, 0xe0, 0xa9, 0x12, 0x68 } } },
    { L"PCD_PPI_GUID",                                                        { 0x06e81c58, 0x4ad7, 0x44bc, { 0x83, 0x90, 0xf1, 0x02, 0x65, 0xf7, 0x24, 0x80 } } },
    { L"PCD_PROTOCOL_GUID",                                                   { 0x11b34006, 0xd85b, 0x4d0a, { 0xa2, 0x90, 0xd5, 0xa5, 0x71, 0x31, 0x0e, 0xf7 } } },
    { L"PCH_DMI_TC_VC_PPI_GUID",                                              { 0xed097352, 0x9041, 0x445a, { 0x80, 0xb6, 0xb2, 0x9d, 0x50, 0x9e, 0x88, 0x45 } } },
    { L"PCH_EFI_RAID_DRIVER_EXECUTION_GUID",                                  { 0x99d5757c, 0xd906, 0x11e0, { 0x8d, 0x78, 0x8d, 0xe4, 0x48, 0x24, 0x01, 0x9b } } },
    { L"PCH_INIT_PPI_GUID",                                                   { 0xe8c7ce14, 0x1eed, 0x48fd, { 0x83, 0x47, 0x8e, 0x55, 0x41, 0x10, 0xc0, 0xd9 } } },
    { L"PCH_INIT_VARIABLE_GUID",                                              { 0xe6c2f70a, 0xb604, 0x4877, { 0x85, 0xba, 0xde, 0xec, 0x89, 0xe1, 0x17, 0xeb } } },
    { L"PCH_ME_UMA_PPI_GUID",                                                 { 0x8c376010, 0x2400, 0x4d7d, { 0xb4, 0x7b, 0x9d, 0x85, 0x1d, 0xf3, 0xc9, 0xd1 } } },
    { L"PCH_PLATFORM_POLICY_PPI_GUID",                                        { 0x22074e71, 0xbccc, 0x4517, { 0x87, 0x57, 0x79, 0x95, 0xed, 0xfd, 0x80, 0x32 } } },
    { L"PCH_RESET_CALLBACK_PROTOCOL_GUID",                                    { 0x3a3300ab, 0xc929, 0x487d, { 0xab, 0x34, 0x15, 0x9b, 0xc1, 0x35, 0x62, 0xc0 } } },
    { L"PCH_RESET_PROTOCOL_GUID",                                             { 0xdb63592c, 0xb8cc, 0x44c8, { 0x91, 0x8c, 0x51, 0xf5, 0x34, 0x59, 0x8a, 0x5a } } },
    { L"PCH_SATA_CONTROLLER_DRIVER_GUID",                                     { 0xbb929da9, 0x68f7, 0x4035, { 0xb2, 0x2c, 0xa3, 0xbb, 0x3f, 0x23, 0xda, 0x55 } } },
    { L"PCH_USB_POLICY_PPI_GUID",                                             { 0xc02b0573, 0x2b4e, 0x4a31, { 0xa3, 0x1a, 0x94, 0x56, 0x7b, 0x50, 0x44, 0x2c } } },
    { L"PE32_IMAGE_PROTOCOL_GUID",                                            { 0x5cb5c776, 0x60d5, 0x45ee, { 0x88, 0x3c, 0x45, 0x27, 0x08, 0xcd, 0x74, 0x3f } } },
    { L"PE_COFF_LOADER_PROTOCOL_GUID",                                        { 0xb323179b, 0x97fb, 0x477e, { 0xb0, 0xfe, 0xd8, 0x85, 0x91, 0xfa, 0x11, 0xab } } },
    { L"PEI_AMT_PLATFORM_POLICY_PPI_GUID",                                    { 0xb4a1208e, 0x4d9a, 0x4ea2, { 0x9d, 0x6b, 0xe4, 0x1a, 0x61, 0xe6, 0xc5, 0xac } } },
    { L"PEI_AMT_STATUS_CODE_PPI_GUID",                                        { 0x881807d2, 0x98d1, 0x4ec9, { 0xaf, 0xa0, 0x77, 0x46, 0xc4, 0x2f, 0x24, 0x49 } } },
    { L"PEI_APRIORI_FILE_NAME_GUID",                                          { 0x1b45cc0a, 0x156a, 0x428a, { 0x62, 0xaf, 0x49, 0x86, 0x4d, 0xa0, 0xe6, 0xe6 } } },
    { L"PEI_AP_STARTUP_FILE_GUID",                                            { 0xd1e59f50, 0xe8c3, 0x4545, { 0xbf, 0x61, 0x11, 0xf0, 0x02, 0x23, 0x3c, 0x97 } } },
    { L"PEI_ATA_CONTROLLER_PPI_GUID",                                         { 0xa1e2176f, 0xcbda, 0x4f32, { 0x87, 0x56, 0x7d, 0x7a, 0xe5, 0x22, 0xd6, 0x93 } } },
    { L"PEI_ATA_CONTROLLER_PPI_GUID",                                         { 0xa45e60d1, 0xc719, 0x44aa, { 0xb0, 0x7a, 0xaa, 0x77, 0x7f, 0x85, 0x90, 0x6d } } },
    { L"PEI_ATA_POLICY_PPI_GUID",                                             { 0x1b8ddea4, 0xdeb2, 0x4152, { 0x91, 0xc2, 0xb7, 0x3c, 0xb1, 0x6c, 0xe4, 0x64 } } },
    { L"PEI_BASE_MEMORY_TEST_GUID",                                           { 0xb6ec423c, 0x21d2, 0x490d, { 0x85, 0xc6, 0xdd, 0x58, 0x64, 0xea, 0xa6, 0x74 } } },
    { L"PEI_BIOS_ACM_FILE_GUID",                                              { 0x2d27c618, 0x7dcd, 0x41f5, { 0xbb, 0x10, 0x21, 0x16, 0x6b, 0xe7, 0xe1, 0x43 } } },
    { L"PEI_BLOCK_IO_PPI_GUID",                                               { 0x695d8aa1, 0x42ee, 0x4c46, { 0x80, 0x5c, 0x6e, 0xa6, 0xbc, 0xe7, 0x99, 0xe3 } } },
    { L"PEI_BOOT_SCRIPT_DONE_PPI_GUID",                                       { 0xfd7c4665, 0x34be, 0x426b, { 0xb1, 0xf8, 0x3a, 0xb7, 0x53, 0xce, 0x44, 0xb0 } } },
    { L"PEI_BOOT_SCRIPT_EXECUTER_PPI_GUID",                                   { 0xabd42895, 0x78cf, 0x4872, { 0x84, 0x44, 0x1b, 0x5c, 0x18, 0x0b, 0xfb, 0xff } } },
    { L"PEI_CACHE_PPI_GUID",                                                  { 0x09be4bc2, 0x790e, 0x4dea, { 0x8b, 0xdc, 0x38, 0x05, 0x16, 0x98, 0x39, 0x44 } } },
    { L"PEI_CACHE_PPI_GUID",                                                  { 0xc153205a, 0xe898, 0x4c24, { 0x86, 0x89, 0xa4, 0xb4, 0xbc, 0xc5, 0xc8, 0xa2 } } },
    { L"PEI_CAPSULE_PPI_GUID",                                                { 0x3acf33ee, 0xd892, 0x40f4, { 0xa2, 0xfc, 0x38, 0x54, 0xd2, 0xe1, 0x32, 0x3d } } },
    { L"PEI_CPU_IO_PPI_GUID",                                                 { 0xe6af1f7b, 0xfc3f, 0x46da, { 0xa8, 0x28, 0xa3, 0xb4, 0x57, 0xa4, 0x42, 0x82 } } },
    { L"PEI_CPU_PLATFORM_POLICY_PPI_GUID",                                    { 0x7b8ee7a1, 0x4e35, 0x4556, { 0xbb, 0x56, 0x67, 0x97, 0xe2, 0x44, 0x45, 0xc2 } } },
    { L"PEI_END_OF_PEI_PHASE_PPI_GUID",                                       { 0x605ea650, 0xc65c, 0x42e1, { 0xba, 0x80, 0x91, 0xa5, 0x2a, 0xb6, 0x18, 0xc6 } } },
    { L"PEI_FLASH_MAP_PPI_GUID",                                              { 0xf34c2fa0, 0xde88, 0x4270, { 0x84, 0x14, 0x96, 0x12, 0x22, 0xf4, 0x52, 0x1c } } },
    { L"PEI_HECI_PPI_GUID",                                                   { 0xee0ea811, 0xfbd9, 0x4777, { 0xb9, 0x5a, 0xba, 0x4f, 0x71, 0x10, 0x1f, 0x74 } } },
    { L"PEI_IDE_RECOVERY_NATIVE_MODE_PPI_GUID",                               { 0x7e13637a, 0xc3f8, 0x43d1, { 0xb0, 0x51, 0xed, 0x19, 0xd7, 0x08, 0xec, 0x7a } } },
    { L"PEI_IFFS_TRANSITION_START_PPI_GUID",                                  { 0xde8f2878, 0x36d5, 0x498e, { 0xba, 0x59, 0x16, 0x8c, 0x26, 0x47, 0xb3, 0x35 } } },
    { L"PEI_IN_MEMORY_GUID",                                                  { 0x643b8786, 0xb417, 0x48d2, { 0x8f, 0x5e, 0x78, 0x19, 0x93, 0x1c, 0xae, 0xd8 } } },
    { L"PEI_LOCK_PHYSICAL_PRESENCE_PPI_GUID",                                 { 0xef9aefe5, 0x2bd3, 0x4031, { 0xaf, 0x7d, 0x5e, 0xfe, 0x5a, 0xbb, 0x9a, 0x0d } } },
    { L"PEI_ME_PLATFORM_POLICY_PPI_GUID",                                     { 0x7ae3ceb7, 0x2ee2, 0x48fa, { 0xaa, 0x49, 0x35, 0x10, 0xbc, 0x83, 0xca, 0xbf } } },
    { L"PEI_NT_AUTOSCAN_PPI_GUID",                                            { 0x0dce384d, 0x007c, 0x4ba5, { 0x94, 0xbd, 0x0f, 0x6e, 0xb6, 0x4d, 0x2a, 0xa9 } } },
    { L"PEI_NT_THUNK_GUID",                                                   { 0x98c281e5, 0xf906, 0x43dd, { 0xa9, 0x2b, 0xb0, 0x03, 0xbf, 0x27, 0x65, 0xda } } },
    { L"PEI_NT_THUNK_PPI_GUID",                                               { 0x98c281e5, 0xf906, 0x43dd, { 0xa9, 0x2b, 0xb0, 0x03, 0xbf, 0x27, 0x65, 0xda } } },
    { L"PEI_OPERATOR_PRESENCE_PPI_GUID",                                      { 0x20a7378c, 0xaa83, 0x4ce1, { 0x82, 0x1f, 0x47, 0x40, 0xee, 0x1b, 0x3f, 0x9f } } },
    { L"PEI_PCI_CFG_PPI_GUID",                                                { 0xe1f2eba0, 0xf7b9, 0x4a26, { 0x86, 0x20, 0x13, 0x12, 0x21, 0x64, 0x2a, 0x90 } } },
    { L"PEI_PERMANENT_MEMORY_INSTALLED_PPI_GUID",                             { 0xf894643d, 0xc449, 0x42d1, { 0x8e, 0xa8, 0x85, 0xbd, 0xd8, 0xc6, 0x5b, 0xde } } },
    { L"PEI_PLATFORM_MEMORY_RANGE_PPI_GUID",                                  { 0x30eb2979, 0xb0f7, 0x4d60, { 0xb2, 0xdc, 0x1a, 0x2c, 0x96, 0xce, 0xb1, 0xf4 } } },
    { L"PEI_PLATFORM_MEMORY_SIZE_PPI_GUID",                                   { 0x9a7ef41e, 0xc140, 0x4bd1, { 0xb8, 0x84, 0x1e, 0x11, 0x24, 0x0b, 0x4c, 0xe6 } } },
    { L"PEI_POST_BOOT_SCRIPT_TABLE_PPI_GUID",                                 { 0x88c9d306, 0x0900, 0x4eb5, { 0x82, 0x60, 0x3e, 0x2d, 0xbe, 0xda, 0x1f, 0x89 } } },
    { L"PEI_READ_ONLY_VARIABLE_ACCESS_PPI_GUID",                              { 0x3cdc90c6, 0x13fb, 0x4a75, { 0x9e, 0x79, 0x59, 0xe9, 0xdd, 0x78, 0xb9, 0xfa } } },
    { L"PEI_RESET_PPI_GUID",                                                  { 0xef398d58, 0x9dfd, 0x4103, { 0xbf, 0x94, 0x78, 0xc6, 0xf4, 0xfe, 0x71, 0x2f } } },
    { L"PEI_S3_RESUME_PPI_GUID",                                              { 0x4426ccb2, 0xe684, 0x4a8a, { 0xae, 0x40, 0x20, 0xd4, 0xb0, 0x25, 0xb7, 0x10 } } },
    { L"PEI_SEC_PERFORMANCE_PPI_GUID",                                        { 0x0ecc666b, 0x4662, 0x47f9, { 0x9d, 0xd5, 0xd0, 0x96, 0xff, 0x7d, 0xa4, 0x9e } } },
    { L"PEI_SECURITY_PPI_GUID",                                               { 0x1388066e, 0x3a57, 0x4efa, { 0x98, 0xf3, 0xc1, 0x2f, 0x3a, 0x95, 0x8a, 0x29 } } },
    { L"PEI_SMBUS2_PPI_GUID",                                                 { 0x9ca93627, 0xb65b, 0x4324, { 0xa2, 0x02, 0xc0, 0xb4, 0x61, 0x76, 0x45, 0x43 } } },
    { L"PEI_SMBUS_POLICY_PPI_GUID",                                           { 0x63b6e435, 0x32bc, 0x49c6, { 0x81, 0xbd, 0xb7, 0xa1, 0xa0, 0xfe, 0x1a, 0x6c } } },
    { L"PEI_SMBUS_PPI_GUID",                                                  { 0xabd42895, 0x78cf, 0x4872, { 0x84, 0x44, 0x1b, 0x5c, 0x18, 0x0b, 0xfb, 0xda } } },
    { L"PEI_SMM_ACCESS_PPI_GUID",                                             { 0x268f33a9, 0xcccd, 0x48be, { 0x88, 0x17, 0x86, 0x05, 0x3a, 0xc3, 0x2e, 0xd6 } } },
    { L"PEI_SMM_CONTROL_PPI_GUID",                                            { 0x61c68702, 0x4d7e, 0x4f43, { 0x8d, 0xef, 0xa7, 0x43, 0x05, 0xce, 0x74, 0xc5 } } },
    { L"PEI_SPI_PPI_GUID",                                                    { 0x64e42e92, 0xe958, 0x4e99, { 0x90, 0xe2, 0xf7, 0xfd, 0x90, 0xa7, 0x6c, 0x59 } } },
    { L"PEI_STALL_PPI_GUID",                                                  { 0x1f4c6f90, 0xb06b, 0x48d8, { 0xa2, 0x01, 0xba, 0xe5, 0xf1, 0xcd, 0x7d, 0x56 } } },
    { L"PEI_STATUS_CODE_MEMORY_PPI_GUID",                                     { 0x26f8ab01, 0xd3cd, 0x489c, { 0x98, 0x4f, 0xdf, 0xde, 0xf7, 0x68, 0x39, 0x5b } } },
    { L"PEI_STATUS_CODE_PPI_GUID",                                            { 0x229832d3, 0x7a30, 0x4b36, { 0xb8, 0x27, 0xf4, 0x0c, 0xb7, 0xd4, 0x54, 0x36 } } },
    { L"PEI_TCG_INTERNAL_FLAGS_GUID",                                         { 0x70fff0ff, 0xa543, 0x45b9, { 0x8b, 0xe3, 0x1b, 0xdb, 0x90, 0x41, 0x20, 0x80 } } },
    { L"PEI_TCG_PPI_GUID",                                                    { 0x177d39d2, 0x43b8, 0x40c8, { 0x9a, 0xe1, 0x3c, 0x51, 0x98, 0xd6, 0x94, 0x1e } } },
    { L"PEI_TPM_INITIALIZED_PPI_GUID",                                        { 0xe9db0d58, 0xd48d, 0x47f6, { 0x9c, 0x6e, 0x6f, 0x40, 0xe8, 0x6c, 0x7b, 0x41 } } },
    { L"PEI_TPM_PPI_2_GUID",                                                  { 0xca4853f4, 0xe94b, 0x42b4, { 0x86, 0x42, 0xcd, 0xe2, 0x8a, 0x7f, 0xac, 0x2d } } },
    { L"PEI_TPM_PPI_GUID",                                                    { 0xca4853f4, 0xe94b, 0x42b4, { 0x86, 0x42, 0xcd, 0xe2, 0x8a, 0x7f, 0xac, 0x2d } } },
    { L"PEI_TPM_PPI_GUID",                                                    { 0xe9db0d58, 0xd48d, 0x47f6, { 0x9c, 0x6e, 0x6f, 0x40, 0xe8, 0x6c, 0x7b, 0x41 } } },
    { L"PEI_TXT_MEMORY_UNLOCKED_PPI_GUID",                                    { 0x38cdd10b, 0x767d, 0x4f6e, { 0xa7, 0x44, 0x67, 0xee, 0x1d, 0xfe, 0x2f, 0xa5 } } },
    { L"PEI_USB2_HOST_CONTROLLER_PPI_GUID",                                   { 0xa7d09fe1, 0x74d4, 0x4ba5, { 0x84, 0x7c, 0x12, 0xed, 0x5b, 0x19, 0xad, 0xe4 } } },
    { L"PEI_USB_CONTROLLER_PPI_GUID",                                         { 0x3bc1f6de, 0x693e, 0x4547, { 0xa3, 0x00, 0x21, 0x82, 0x3c, 0xa4, 0x20, 0xb2 } } },
    { L"PEI_USB_HOST_CONTROLLER_PPI_GUID",                                    { 0x652b38a9, 0x77f4, 0x453f, { 0x89, 0xd5, 0xe7, 0xbd, 0xc3, 0x52, 0xfc, 0x53 } } },
    { L"PEI_USB_IO_PPI_GUID",                                                 { 0x7c29785c, 0x66b9, 0x49fc, { 0xb7, 0x97, 0x1c, 0xa5, 0x55, 0x0e, 0xf2, 0x83 } } },
    { L"PERFORMANCE_EX_PROTOCOL_GUID",                                        { 0x1ea81bec, 0xf01a, 0x4d98, { 0xa2, 0x01, 0x4a, 0x61, 0xce, 0x2f, 0xc0, 0x22 } } },
    { L"PERFORMANCEPKG_TOKEN_SPACE_GUID",                                     { 0x669346ef, 0xfdad, 0x4aeb, { 0x08, 0xa6, 0x21, 0x46, 0x2d, 0x3f, 0xef, 0x7d } } },
    { L"PERFORMANCE_PROTOCOL_GUID",                                           { 0x76b6bdfa, 0x2acd, 0x4462, { 0x9e, 0x3f, 0xcb, 0x58, 0xc9, 0x69, 0xd9, 0x37 } } },
    { L"PERF_TUNE_PPI_GUID",                                                  { 0xc49189f3, 0x1d4c, 0x4ad7, { 0xa4, 0x39, 0xd0, 0x13, 0xab, 0x72, 0x09, 0x31 } } },
    { L"PERF_TUNE_PROTOCOL_GUID",                                             { 0xdd6c613a, 0x5a77, 0x4b4f, { 0xa6, 0x1e, 0x3b, 0xdd, 0x2a, 0xe2, 0x1d, 0x81 } } },
    { L"PERF_TUNE_WDT_PPI_GUID",                                              { 0xa7c88fae, 0xebec, 0x45ed, { 0xa7, 0xc5, 0x5f, 0xa7, 0x55, 0x17, 0x73, 0x06 } } },
    { L"PERF_TUNE_WDT_PROTOCOL_GUID",                                         { 0xc0557eed, 0x9a89, 0x4770, { 0x96, 0x26, 0xfc, 0xa0, 0x51, 0xf2, 0xba, 0x09 } } },
    { L"PK_PUB_FFS_FILE_EFI_AUTH_VAR_GUID",                                   { 0x9e625a27, 0x4840, 0x47cc, { 0xa6, 0xb5, 0x1e, 0x93, 0x11, 0xcf, 0xc6, 0x0e } } },
    { L"PKPUB_KEY_GUID",                                                      { 0xa6c0e11e, 0x929e, 0x42b3, { 0x90, 0xcc, 0x4f, 0x77, 0x8e, 0x03, 0xff, 0x57 } } },
    { L"PLATFORM_IDE_PROTOCOL_GUID",                                          { 0x6737f69b, 0xb8cc, 0x45bc, { 0x93, 0x27, 0xcc, 0xf5, 0xee, 0xf7, 0x0c, 0xde } } },
    { L"PLATFORM_ME_HOOK_PPI_GUID",                                           { 0xe806424f, 0xd425, 0x4b1a, { 0xbc, 0x26, 0x5f, 0x69, 0x03, 0x89, 0xa1, 0x5a } } },
    { L"PLATFORM_ME_HOOK_PROTOCOL_GUID",                                      { 0xbc52476e, 0xf67e, 0x4301, { 0xb2, 0x62, 0x36, 0x9c, 0x48, 0x78, 0xaa, 0xc2 } } },
    { L"PLAT_OVER_MNGR_GUID",                                                 { 0x8614567d, 0x35be, 0x4415, { 0x8d, 0x88, 0xbd, 0x7d, 0x0c, 0x9c, 0x70, 0xc0 } } },
    { L"POWER_MANAGEMENT_ACPI_TABLE_STORAGE_GUID",                            { 0x299141bb, 0x211a, 0x48a5, { 0x92, 0xc0, 0x6f, 0x9a, 0x0a, 0x3a, 0x00, 0x6e } } },
    { L"PPM_PLATFORM_POLICY_PROTOCOL_GUID",                                   { 0x6f27e990, 0x7bc8, 0x42c9, { 0x8f, 0x71, 0x99, 0x80, 0x06, 0x36, 0x93, 0xe9 } } },
    { L"PPM_PROCESSOR_SUPPORT_PROTOCOL_3_GUID",                               { 0xa60c7dcd, 0x512f, 0x4f02, { 0xb1, 0x80, 0x52, 0x2e, 0x01, 0x5e, 0x06, 0xb7 } } },
    { L"PR_KEY_FFS_FILE_RAW_GUID",                                            { 0x3feec852, 0xf14c, 0x4e7f, { 0x97, 0xfd, 0x4c, 0x3a, 0x8c, 0x5b, 0xbe, 0xcc } } },
    { L"PR_KEY_GUID",                                                         { 0x4e0f9bd4, 0xe338, 0x4b26, { 0x84, 0x3e, 0xbd, 0x3a, 0xd9, 0xb2, 0x83, 0x7b } } },
    { L"PTID_FFS_TABLE_STORAGE_GUID",                                         { 0x95dfcae5, 0xbb28, 0x4d6b, { 0xb1, 0xe2, 0x3a, 0xf3, 0xa6, 0xbf, 0x43, 0x4f } } },
    { L"PWD_CREDENTIAL_PROVIDER_GUID",                                        { 0x78b9ec8b, 0xc000, 0x46c5, { 0xac, 0x93, 0x24, 0xa0, 0xc1, 0xbb, 0x00, 0xce } } },
    { L"RECOVERY_FORM_SET_GUID",                                              { 0x80e1202e, 0x2697, 0x4264, { 0x9c, 0xc9, 0x80, 0x76, 0x2c, 0x3e, 0x58, 0x63 } } },
    { L"RECOVERY_ON_DATA_CD_GUID",                                            { 0x5cac0099, 0x0dc9, 0x48e5, { 0x80, 0x68, 0xbb, 0x95, 0xf5, 0x40, 0x0a, 0x9f } } },
    { L"RECOVERY_ON_FAT_FLOPPY_DISK_GUID",                                    { 0x2e3d2e75, 0x9b2e, 0x412d, { 0xb4, 0xb1, 0x70, 0x41, 0x6b, 0x87, 0x00, 0xff } } },
    { L"RECOVERY_ON_FAT_IDE_DISK_GUID",                                       { 0xb38573b6, 0x6200, 0x4ac5, { 0xb5, 0x1d, 0x82, 0xe6, 0x59, 0x38, 0xd7, 0x83 } } },
    { L"RECOVERY_ON_FAT_USB_DISK_GUID",                                       { 0x0ffbce19, 0x324c, 0x4690, { 0xa0, 0x09, 0x98, 0xc6, 0xae, 0x2e, 0xb1, 0x86 } } },
    { L"ROM_CACHE_ENABLE_PPI_GUID",                                           { 0x36e835bb, 0x661d, 0x4d37, { 0x8d, 0xe5, 0x88, 0x53, 0x25, 0xda, 0xe9, 0x10 } } },
    { L"ROM_IMAGE_ADDRESS_GUID",                                              { 0xdde1bc72, 0xd45e, 0x4209, { 0xab, 0x85, 0x14, 0x46, 0x2d, 0x2f, 0x50, 0x74 } } },
    { L"ROM_IMAGE_MEMORY_HOB_GUID",                                           { 0xee2f45d2, 0x5ba4, 0x441e, { 0x8a, 0x1d, 0xaa, 0x22, 0xdf, 0xa3, 0xb6, 0xc5 } } },
    { L"ROM_LAYOUT_FFS_GUID",                                                 { 0x0dca793a, 0xea96, 0x42d8, { 0xbd, 0x7b, 0xdc, 0x7f, 0x68, 0x4e, 0x38, 0xc1 } } },
    { L"ROM_LAYOUT_SECTION_GUID",                                             { 0x88a15a4f, 0x977d, 0x4682, { 0xb1, 0x7c, 0xda, 0x1f, 0x31, 0x6c, 0x1f, 0x32 } } },
    { L"RSDP_PLUS_PROTOCOL_GUID",                                             { 0xa33319b5, 0x8ee1, 0x45e0, { 0x8c, 0x9f, 0x80, 0x9f, 0x5b, 0x09, 0x02, 0xcc } } },
    { L"SAL_SYSTEM_TABLE_GUID",                                               { 0xeb9d2d32, 0x2d88, 0x11d3, { 0x9a, 0x16, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"SA_PEG_DATA_HOB_GUID",                                                { 0x5f5d3502, 0x8a4b, 0x40ca, { 0x88, 0xa2, 0x23, 0x05, 0x42, 0x7a, 0x13, 0x1a } } },
    { L"SA_PEG_DATA_VARIABLE_GUID",                                           { 0xc4975200, 0x64f1, 0x4fb6, { 0x97, 0x73, 0xf6, 0xa9, 0xf8, 0x9d, 0x98, 0x5e } } },
    { L"SA_PEI_INIT_PPI_GUID",                                                { 0x09ea8911, 0xbe0d, 0x4230, { 0xa0, 0x03, 0xed, 0xc6, 0x93, 0xb4, 0x8e, 0x11 } } },
    { L"SA_PLATFORM_POLICY_PPI_GUID",                                         { 0x150ce416, 0xee63, 0x46b6, { 0x8b, 0xa3, 0x73, 0x22, 0xbb, 0xe0, 0x46, 0x37 } } },
    { L"SATA_CONTROLLER_PROTOCOL_GUID",                                       { 0x2acb6627, 0xdf02, 0x4e23, { 0xb4, 0xf9, 0x6a, 0x93, 0xfa, 0x6e, 0x9d, 0xa6 } } },
    { L"SECUREBOOT_CONFIG_FORM_SET_GUID",                                     { 0x5daf50a5, 0xea81, 0x4de2, { 0x8f, 0x9b, 0xca, 0xbd, 0xa9, 0xcf, 0x5c, 0x14 } } },
    { L"SECURITY_FORM_SET_GUID",                                              { 0x981ceaee, 0x931c, 0x4a17, { 0xb9, 0xc8, 0x66, 0xc7, 0xbc, 0xfd, 0x77, 0xe1 } } },
    { L"SECURITYPKG_TOKEN_SPACE_GUID",                                        { 0x0d3fb176, 0x9569, 0x4d51, { 0xa3, 0xef, 0x7d, 0x61, 0xc6, 0x4f, 0xea, 0xba } } },
    { L"SERIAL_RECOVERY_CAPSULE_GUID",                                        { 0x699add70, 0x8554, 0x4993, { 0x83, 0xf6, 0xd2, 0xcd, 0xc0, 0x81, 0xdd, 0x85 } } },
    { L"SETUP_DEFAULTS_FFS_GUID",                                             { 0x9221315b, 0x30bb, 0x46b5, { 0x81, 0x3e, 0x1b, 0x1b, 0xf4, 0x71, 0x2b, 0xd3 } } },
    { L"SETUP_GUID",                                                          { 0xec87d643, 0xeba4, 0x4bb5, { 0xa1, 0xe5, 0x3f, 0x3e, 0x36, 0xb2, 0x0d, 0xa9 } } },
    { L"SG_ACPI_TABLE_STORAGE_GUID",                                          { 0xcacb3817, 0x81e6, 0x497e, { 0x87, 0xff, 0xc8, 0xfa, 0x8f, 0x24, 0xec, 0x28 } } },
    { L"SG_INFO_HOB_GUID",                                                    { 0x648ce07b, 0xae5d, 0x4973, { 0xbd, 0x3c, 0x8c, 0x91, 0x53, 0xc0, 0x5d, 0xc5 } } },
    { L"SGOEM_ACPI_SSDT_GUID",                                                { 0x5b232086, 0x350a, 0x42c7, { 0xa7, 0x0e, 0x34, 0x97, 0xb5, 0x76, 0x5d, 0x85 } } },
    { L"SG_PEI_INIT_PPI_GUID",                                                { 0xaa40d00e, 0x5b9b, 0x4dad, { 0xa4, 0x87, 0xfc, 0x1b, 0xcb, 0xef, 0x81, 0x70 } } },
    { L"SG_PLATFORM_POLICY_PPI_GUID",                                         { 0xa391e822, 0x7044, 0x4cf4, { 0xbe, 0x5b, 0x34, 0x5e, 0x44, 0xb8, 0x62, 0x7c } } },
    { L"SGTPV_ACPI_SSDT_GUID",                                                { 0x6a061113, 0xfe54, 0x4a07, { 0xa2, 0x8e, 0x0a, 0x69, 0x35, 0x9e, 0xb0, 0x69 } } },
    { L"SHELL_ALIAS_VARIABLE_GUID",                                           { 0x0053d9d6, 0x2659, 0x4599, { 0xa2, 0x6b, 0xef, 0x45, 0x36, 0xe6, 0x31, 0xa9 } } },
    { L"SHELL_DEBUG1_HII_GUID",                                               { 0x25f200aa, 0xd3cb, 0x470a, { 0xbf, 0x51, 0xe7, 0xd1, 0x62, 0xd2, 0x2e, 0x6f } } },
    { L"SHELL_DRIVER1_HII_GUID",                                              { 0x0af0b742, 0x63ec, 0x45bd, { 0x8d, 0xb6, 0x71, 0xad, 0x7f, 0x2f, 0xe8, 0xe8 } } },
    { L"SHELL_ENVIRONMENT_PROTOCOL_GUID",                                     { 0x47c7b221, 0xc42a, 0x11d2, { 0x8e, 0x57, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"SHELL_INSTALL1_HII_GUID",                                             { 0x7d574d54, 0xd364, 0x4d4a, { 0x95, 0xe3, 0x49, 0x45, 0xdb, 0x7a, 0xd3, 0xee } } },
    { L"SHELL_INTERFACE_PROTOCOL_GUID",                                       { 0x47c7b223, 0xc42a, 0x11d2, { 0x8e, 0x57, 0x00, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"SHELL_LEVEL1_HII_GUID",                                               { 0xdec5daa4, 0x6781, 0x4820, { 0x9c, 0x63, 0xa7, 0xb0, 0xe4, 0xf1, 0xdb, 0x31 } } },
    { L"SHELL_LEVEL2_HII_GUID",                                               { 0xf95a7ccc, 0x4c55, 0x4426, { 0xa7, 0xb4, 0xdc, 0x89, 0x61, 0x95, 0x0b, 0xae } } },
    { L"SHELL_LEVEL3_HII_GUID",                                               { 0x4344558d, 0x4ef9, 0x4725, { 0xb1, 0xe4, 0x33, 0x76, 0xe8, 0xd6, 0x97, 0x4f } } },
    { L"SHELL_MAP_GUID",                                                      { 0x51271e13, 0x7de3, 0x43af, { 0x8b, 0xc2, 0x71, 0xad, 0x3b, 0x82, 0x43, 0x25 } } },
    { L"SHELL_NETWORK1_HII_GUID",                                             { 0xf3d301bb, 0xf4a5, 0x45a8, { 0xb0, 0xb7, 0xfa, 0x99, 0x9c, 0x62, 0x37, 0xae } } },
    { L"SHELLPKG_SHELL_ENV2_EXT_GUID",                                        { 0xd2c18636, 0x40e5, 0x4eb5, { 0xa3, 0x1b, 0x36, 0x69, 0x5f, 0xd4, 0x2c, 0x87 } } },
    { L"SHELL_VARIABLE_GUID",                                                 { 0x158def5a, 0xf656, 0x419c, { 0xb0, 0x27, 0x7a, 0x31, 0x92, 0xc0, 0x79, 0xd2 } } },
    { L"SIO_DEV_STATUS_VAR_GUID",                                             { 0x5820de98, 0xfc8e, 0x4b0b, { 0xa4, 0xb9, 0x0a, 0x94, 0x0d, 0x16, 0x2a, 0x7e } } },
    { L"SIO_IO_PROTOCOL_GUID",                                                { 0x964e5b21, 0x6000, 0x23d2, { 0x9e, 0x39, 0x01, 0xa0, 0xc9, 0x69, 0x72, 0x3b } } },
    { L"SMBIOS_FLASH_DATA_FFS_GUID",                                          { 0xfd44820b, 0xf1ab, 0x41c0, { 0xae, 0x4e, 0x0c, 0x55, 0x55, 0x6e, 0xb9, 0xbd } } },
    { L"SMBIOS_TABLE_GUID",                                                   { 0xeb9d2d31, 0x2d88, 0x11d3, { 0x9a, 0x16, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"SM_BUS_CONTROLLER_IDENTIFIER_GUID",                                   { 0x882f2546, 0xef1f, 0x4090, { 0x9f, 0x9c, 0x93, 0x84, 0x5a, 0xd7, 0x84, 0x1c } } },
    { L"SMM_CHILD_DISPATCHER2_GUID",                                          { 0x950c3a26, 0xe0c2, 0x491c, { 0xb6, 0xb2, 0x03, 0x74, 0xf5, 0xc7, 0x3b, 0x96 } } },
    { L"SMM_COMMUNICATE_HEADER_GUID",                                         { 0xf328e36c, 0x23b6, 0x4a95, { 0x85, 0x4b, 0x32, 0xe1, 0x95, 0x34, 0xcd, 0x75 } } },
    { L"SMM_HECI_PROTOCOL_GUID",                                              { 0xfc9a50c1, 0x8b3d, 0x40d0, { 0x99, 0x12, 0x6e, 0x26, 0xd7, 0x89, 0x6c, 0xba } } },
    { L"SMM_PERFORMANCE_EX_PROTOCOL_GUID",                                    { 0x931fc048, 0xc71d, 0x4455, { 0x89, 0x30, 0x47, 0x06, 0x30, 0xe3, 0x0e, 0xe5 } } },
    { L"SMM_PERFORMANCE_PROTOCOL_GUID",                                       { 0xf866226a, 0xeaa5, 0x4f5a, { 0xa9, 0x0a, 0x6c, 0xfb, 0xa5, 0x7c, 0x58, 0x8e } } },
    { L"SMRAM_CPU_DATA_HEADER_GUID",                                          { 0x5848fd2d, 0xd6af, 0x474b, { 0x82, 0x75, 0x95, 0xdd, 0xe7, 0x0a, 0xe8, 0x23 } } },
    { L"SMRAM_CPU_DATA_VARIABLE_GUID",                                        { 0x429501d9, 0xe447, 0x40f4, { 0x86, 0x7b, 0x75, 0xc9, 0x3a, 0x1d, 0xb5, 0x4e } } },
    { L"STATUS_CODE_CALLBACK_GUID",                                           { 0xe701458c, 0x4900, 0x4ca5, { 0xb7, 0x72, 0x3d, 0x37, 0x94, 0x9f, 0x79, 0x27 } } },
    { L"SYSTEM_ACCESS_GUID",                                                  { 0xe770bb69, 0xbcb4, 0x4d04, { 0x9e, 0x97, 0x23, 0xff, 0x94, 0x56, 0xfe, 0xac } } },
    { L"TCG_CONFIG_FORM_SET_GUID",                                            { 0xb0f901e4, 0xc424, 0x45de, { 0x90, 0x81, 0x95, 0xe2, 0x0b, 0xde, 0x6f, 0xb5 } } },
    { L"TCG_EFI_ACPI_TABLE_GUID",                                             { 0xeb9d2d30, 0x2d88, 0x11d3, { 0x9a, 0x16, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"TCG_EFI_HOB_LIST_GUID",                                               { 0x7739f24c, 0x93d7, 0x11d4, { 0x9a, 0x3a, 0x00, 0x90, 0x27, 0x3f, 0xc1, 0x4d } } },
    { L"TCG_INTERNAL_FLAGS_GUID",                                             { 0x70fff0ff, 0xa543, 0x45b9, { 0x8b, 0xe3, 0x1b, 0xdb, 0x90, 0x41, 0x20, 0x80 } } },
    { L"TCG_LOCK_DOWN_VAR_GUID",                                              { 0x6e605536, 0xa30a, 0x4d56, { 0x93, 0x9e, 0x1c, 0x37, 0x3f, 0x79, 0x8d, 0x7b } } },
    { L"TCG_PLATFORM_SETUP_PEI_POLICY_GUID",                                  { 0xa76b4e22, 0xb50a, 0x401d, { 0x8b, 0x35, 0x51, 0x24, 0xb0, 0xba, 0x41, 0x04 } } },
    { L"TCG_PLATFORM_SETUP_POLICY_GUID",                                      { 0xbb6cbeff, 0xe072, 0x40d2, { 0xa6, 0xeb, 0xba, 0xb7, 0x5b, 0xde, 0x87, 0xe7 } } },
    { L"TCG_PPI_SYNC_FLAG_GUID",                                              { 0xf3ed95df, 0x828e, 0x41c7, { 0xbc, 0xa0, 0x16, 0xc4, 0x19, 0x65, 0xa6, 0x34 } } },
    { L"TDTHI_PROTOCOL_FIXED_GUID",                                           { 0xfa8f55e8, 0xab22, 0x42dd, { 0xb9, 0x16, 0x7d, 0xce, 0x39, 0x00, 0x25, 0x74 } } },
    { L"TDTHI_PROTOCOL_GUID",                                                 { 0x3c4852d6, 0xd47b, 0x4f46, { 0xb0, 0x5e, 0xb5, 0xed, 0xc1, 0xaa, 0x43, 0x0a } } },
    { L"TDT_VOLATILE_SETUP_DATA_GUID",                                        { 0x7b77fb8b, 0x1e0d, 0x4d7e, { 0x95, 0x3f, 0x39, 0x80, 0xa2, 0x61, 0xe0, 0x76 } } },
    { L"TEMPORARY_RAM_SUPPORT_PPI_GUID",                                      { 0xdbe23aa9, 0xa345, 0x4b97, { 0x85, 0xb6, 0xb2, 0x26, 0xf1, 0x61, 0x73, 0x89 } } },
    { L"TERMINAL_VAR_GUID",                                                   { 0x560bf58a, 0x1e0d, 0x4d7e, { 0x95, 0x3f, 0x29, 0x80, 0xa2, 0x61, 0xe0, 0x31 } } },
    { L"TIANO_CUSTOM_DECOMPRESS_GUID",                                        { 0xa31280ad, 0x481e, 0x41b6, { 0x95, 0xe8, 0x12, 0x7f, 0x4c, 0x98, 0x47, 0x79 } } },
    { L"TPM_BOOT_FLOW_VARIABLE_GUID",                                         { 0xb6460a49, 0x0ac1, 0x484f, { 0xae, 0x58, 0xf1, 0x6e, 0xb2, 0x39, 0xdb, 0x3d } } },
    { L"TPM_DEVICE_SELECTED_GUID",                                            { 0x7f4158d3, 0x074d, 0x456d, { 0x8c, 0xb2, 0x01, 0xf9, 0xc8, 0xf7, 0x9d, 0xaa } } },
    { L"TREE_CONFIG_FORM_SET_GUID",                                           { 0xc54b425f, 0xaa79, 0x48b4, { 0x98, 0x1f, 0x99, 0x8b, 0x3c, 0x4b, 0x64, 0x1c } } },
    { L"TXT_INFO_HOB_GUID",                                                   { 0x2986883f, 0x88e0, 0x48d0, { 0x4b, 0x82, 0x20, 0xc2, 0x69, 0x48, 0xdd, 0xac } } },
    { L"TXT_ONE_TOUCH_GUID",                                                  { 0x3d989471, 0xcfac, 0x46b7, { 0x9b, 0x1c, 0x08, 0x43, 0x01, 0x09, 0x40, 0x2d } } },
    { L"TXT_ONE_TOUCH_OP_PROTOCOL_GUID",                                      { 0xfa2338ad, 0x80df, 0x49d0, { 0x93, 0x96, 0xcf, 0x71, 0x45, 0xd0, 0x3a, 0x76 } } },
    { L"UNKNOWN_DEVICE_GUID",                                                 { 0xcf31fac5, 0xc24e, 0x11d2, { 0x85, 0xf3, 0x00, 0xa0, 0xc9, 0x3e, 0xc9, 0x3b } } },
    { L"USB_CREDENTIAL_PROVIDER_GUID",                                        { 0xd0849ed1, 0xa88c, 0x4ba6, { 0xb1, 0xd6, 0xab, 0x50, 0xe2, 0x80, 0xb7, 0xa9 } } },
    { L"USB_KEYBOARD_LAYOUT_KEY_GUID",                                        { 0x3a4d7a7c, 0x018a, 0x4b42, { 0x81, 0xb3, 0xdc, 0x10, 0xe3, 0xb5, 0x91, 0xbd } } },
    { L"USB_KEYBOARD_LAYOUT_PACKAGE_GUID",                                    { 0x0c0f3b43, 0x44de, 0x4907, { 0xb4, 0x78, 0x22, 0x5f, 0x6f, 0x62, 0x89, 0xdc } } },
    { L"USB_TIMING_POLICY_PROTOCOL_GUID",                                     { 0x89e3c1dc, 0xb5e3, 0x4d34, { 0xae, 0xad, 0xdd, 0x7e, 0xb2, 0x82, 0x8c, 0x18 } } },
    { L"USER_DEFAULTS_GUID",                                                  { 0xc4cc0de8, 0x0687, 0x4422, { 0x99, 0xc1, 0x65, 0x35, 0x1a, 0x5d, 0x5f, 0x95 } } },
    { L"USER_IDENTIFY_MANAGER_GUID",                                          { 0x3ccd3dd8, 0x8d45, 0x4fed, { 0x96, 0x2d, 0x2b, 0x38, 0xcd, 0x82, 0xb3, 0xc4 } } },
    { L"USER_PROFILE_MANAGER_GUID",                                           { 0xc35f272c, 0x97c2, 0x465a, { 0xa2, 0x16, 0x69, 0x6b, 0x66, 0x8a, 0x8c, 0xfe } } },
    { L"VIRTUAL_UNCACHED_PAGES_PROTOCOL_GUID",                                { 0xad651c7d, 0x3c22, 0x4dbf, { 0x92, 0xe8, 0x38, 0xa7, 0xcd, 0xae, 0x87, 0xb2 } } },
    { L"VLAN_CONFIG_FORM_SET_GUID",                                           { 0xd79df6b0, 0xef44, 0x43bd, { 0x97, 0x97, 0x43, 0xe9, 0x3b, 0xcf, 0x5f, 0xa8 } } },
    { L"WDT_APP_PROTOCOL_GUID",                                               { 0x92c7d0bb, 0x679e, 0x479d, { 0x87, 0x8d, 0xd4, 0xb8, 0x29, 0x68, 0x57, 0x8b } } },
    { L"WDT_HOB_GUID",                                                        { 0x65675786, 0xacca, 0x4b11, { 0x8a, 0xb7, 0xf8, 0x43, 0xaa, 0x2a, 0x8b, 0xea } } },
    { L"WDT_PERSISTENT_DATA_GUID",                                            { 0x78ce2354, 0xcfbc, 0x4643, { 0xae, 0xba, 0x07, 0xa2, 0x7f, 0xa8, 0x92, 0xbf } } },
    { L"WDT_PPI_GUID",                                                        { 0xf38d1338, 0xaf7a, 0x4fb6, { 0x91, 0xdb, 0x1a, 0x9c, 0x21, 0x83, 0x57, 0x0d } } },
    { L"WDT_PROTOCOL_GUID",                                                   { 0xb42b8d12, 0x2acb, 0x499a, { 0xa9, 0x20, 0xdd, 0x5b, 0xe6, 0xcf, 0x09, 0xb1 } } },
    { L"CPU_PEI_BEFORE_MEM_GUID",                                             { 0x1555acf3, 0xbd07, 0x4e88, { 0xb3, 0xa0, 0xb7, 0x7f, 0x78, 0xeb, 0x34, 0xfe } } },
    { L"CPU_PEI_GUID",                                                        { 0x2bb5afa9, 0xff33, 0x417b, { 0x84, 0x97, 0xcb, 0x77, 0x3c, 0x2b, 0x93, 0xbf } } },
    { L"CPU_DXE_GUID",                                                        { 0xe03abadf, 0xe536, 0x4e88, { 0xb3, 0xa0, 0xb7, 0x7f, 0x78, 0xeb, 0x34, 0xfe } } },
    { L"PCI_OSC_HOST_BUS_GUID",                                               { 0x33db4d5b, 0x1ff7, 0x401c, { 0x96, 0x57, 0x74, 0x41, 0xc0, 0x3d, 0xd7, 0x66 } } },
    { L"DEFINE_CpuSsdtTemplate_GUID",                                         { 0x8337f5ab, 0x1ec0, 0x4e64, { 0x97, 0x4a, 0x86, 0xf1, 0xe1, 0x72, 0x42, 0xe1 } } },
    { L"EistSsdtTemplate_GUID",                                               { 0xafae7706, 0x55b4, 0x4325, { 0xa8, 0x9a, 0x7d, 0x7c, 0x6f, 0x2e, 0x5b, 0x27 } } },
    { L"CstSsdtTemplate_GUID",                                                { 0xafaebc06, 0x64b4, 0x4123, { 0x55, 0x73, 0x2c, 0x1f, 0x35, 0x89, 0x94, 0x1b } } },
    { L"EcPs2KbdBin_GUID",                                                    { 0x2f72309e, 0xd5b0, 0x4a9d, { 0x84, 0xa9, 0x1a, 0xb3, 0x8c, 0x69, 0x8f, 0x78 } } },
    { L"SgTpvAcpiS3SaveBin_GUID",                                             { 0xc18b8105, 0xab89, 0x44de, { 0x8d, 0x37, 0x50, 0xb3, 0x1f, 0xae, 0x5d, 0x1e } } },
    { L"SgTpvPeiBin_GUID",                                                    { 0x0e2daf63, 0x8a4f, 0x4026, { 0xa8, 0x99, 0xde, 0x2d, 0x7f, 0x46, 0xe5, 0xec } } },
    { L"SgTpvDxeBin_GUID",                                                    { 0x3fe57ac2, 0xc675, 0x46b1, { 0x84, 0x58, 0xac, 0x62, 0x06, 0x58, 0x84, 0x24 } } },
    { L"Mxm30DxeBin_GUID",                                                    { 0x31a0b6ef, 0xa400, 0x4419, { 0x83, 0x27, 0x0f, 0xb1, 0x34, 0xaa, 0x59, 0xe7 } } },
    { L"MXMdat_GUID",                                                         { 0x6707536e, 0x46af, 0x42d3, { 0x8f, 0x6c, 0x15, 0xf2, 0xf2, 0x02, 0xc2, 0x34 } } },
    { L"NvOptimusSMMBin_GUID",                                                { 0x8a4e8240, 0x74f8, 0x4024, { 0xae, 0x2b, 0xb3, 0x92, 0x21, 0xc9, 0xfa, 0x59 } } },
    { L"NVHG_NOTIFY_POLICYCHANGE_GUID",                                       { 0x921a2f40, 0x0dc4, 0x402d, { 0xac, 0x18, 0xb4, 0x84, 0x44, 0xef, 0x9e, 0xd2 } } },
    { L"NVHG_NOTIFY_POLICYSET_GUID",                                          { 0xc12ad361, 0x9fa9, 0x4c74, { 0x90, 0x1f, 0x95, 0xcb, 0x09, 0x45, 0xcf, 0x3e } } },
    { L"NVHG_DISPLAY_SCALING_GUID",                                           { 0x42848006, 0x8886, 0x490e, { 0x8c, 0x72, 0x2b, 0xdc, 0xa9, 0x3a, 0x8a, 0x09 } } },
    { L"ACPI_NOTIFY_PANEL_SWITCH_GUID",                                       { 0xe06bde62, 0xee75, 0x48f4, { 0xa5, 0x83, 0xb2, 0x3e, 0x69, 0xab, 0xf8, 0x91 } } },
    { L"ACPI_NOTIFY_DEVICE_HOTPLUG_GUID",                                     { 0x3adebd0f, 0x0c5f, 0x46ed, { 0xab, 0x2e, 0x04, 0x96, 0x2b, 0x4f, 0xdc, 0xbc } } },
    { L"ACPI_NOTIFY_INC_BRIGHTNESS_HOTKEY_GUID",                              { 0x1e519311, 0x3e75, 0x4208, { 0xb0, 0x5e, 0xeb, 0xe1, 0x7e, 0x3f, 0xf4, 0x1f } } },
    { L"ACPI_NOTIFY_DEC_BRIGHTNESS_HOTKEY_GUID",                              { 0x37f85341, 0x4418, 0x4f24, { 0x85, 0x33, 0x38, 0xff, 0xc7, 0x29, 0x55, 0x42 } } },
    { L"Ventura_DSM_GUID",                                                    { 0x95db88fd, 0x940a, 0x4253, { 0xa4, 0x46, 0x70, 0xce, 0x05, 0x04, 0xae, 0xdf } } },
    { L"SG_dGPU_GUID",                                                        { 0x9d95a0a0, 0x0060, 0x4d48, { 0xb3, 0x4d, 0x7e, 0x5f, 0xea, 0x12, 0x9f, 0xd4 } } },
    { L"NBCI_GUID",                                                           { 0xd4a50b75, 0x65c7, 0x46f7, { 0xbf, 0xb7, 0x41, 0x51, 0x4c, 0xea, 0x02, 0x44 } } },
    { L"Ventura_GUID",                                                        { 0x95db88fd, 0x940a, 0x4253, { 0xa4, 0x46, 0x70, 0xce, 0x05, 0x04, 0xae, 0xdf } } },
    { L"Optimus_DSM_GUID",                                                    { 0xa486d8f8, 0x0bda, 0x471b, { 0xa7, 0x2b, 0x60, 0x42, 0xa6, 0xb5, 0xbe, 0xe0 } } },
    { L"ECBin_GUID",                                                          { 0x41015350, 0xba3b, 0x4916, { 0xb0, 0x43, 0x46, 0x15, 0x40, 0x8a, 0x87, 0xb3 } } },
    { L"ECSMIBin_GUID",                                                       { 0xe7e63dd1, 0xe89f, 0x4845, { 0x9e, 0x4a, 0xb6, 0x09, 0x52, 0xb3, 0x58, 0x9c } } },
    { L"TXTWrapperPeiBin_GUID",                                               { 0x6b789215, 0xb063, 0x45fd, { 0x86, 0x8a, 0x66, 0x8a, 0x49, 0xf0, 0x0e, 0xc6 } } },
    { L"TXTWrapperDxeBin_GUID",                                               { 0x87d402cd, 0x8b07, 0x4b93, { 0xb3, 0x8b, 0xf8, 0x79, 0x9f, 0x28, 0xb0, 0x33 } } },
    { L"MePciPlatformBin_GUID",                                               { 0x459c70c3, 0x9344, 0x4484, { 0x9f, 0x93, 0x78, 0x22, 0x53, 0x0d, 0x0d, 0x11 } } },
    { L"IccOverClocking_GUID",                                                { 0x5bba83e5, 0xf027, 0x4ca7, { 0xbf, 0xd0, 0x16, 0x35, 0x8c, 0xc9, 0xe1, 0x23 } } },
    { L"IccPlatform_Bin_GUID",                                                { 0x14257b56, 0xbda2, 0x4faf, { 0x8e, 0x4f, 0xc8, 0x85, 0xdf, 0x75, 0x58, 0x3c } } },
    { L"MePlatformPolicyBin_GUID",                                            { 0xba67550c, 0x3628, 0x4137, { 0xa5, 0x3e, 0x42, 0x66, 0x0e, 0x08, 0x16, 0x04 } } },
    { L"AmtSmbiosBin_GUID",                                                   { 0xa8c67255, 0xe029, 0x4b1a, { 0x96, 0x8e, 0xec, 0xa6, 0xe9, 0xc1, 0x1c, 0x73 } } },
    { L"AmtPlatformPolicyBin_GUID",                                           { 0x1be65202, 0x9318, 0x492d, { 0xa5, 0x51, 0x08, 0xdf, 0x2b, 0xd6, 0x0a, 0xee } } },
    { L"AMTLOCKKBDBin_GUID",                                                  { 0x5507247a, 0x846b, 0x4f22, { 0xb5, 0x5f, 0x72, 0xb4, 0x04, 0x94, 0x35, 0xef } } },
    { L"AmtWrapperDxeBin_GUID",                                               { 0xd77c900d, 0xa1c7, 0x41c5, { 0xb9, 0x89, 0x0c, 0x3d, 0x37, 0xfc, 0xa4, 0x32 } } },
    { L"AmtPetAlertBin_GUID",                                                 { 0x290ea249, 0x6e88, 0x423c, { 0xb0, 0xda, 0x75, 0xcd, 0xde, 0x79, 0x20, 0xcc } } },
    { L"AsfTableBin_GUID",                                                    { 0xe72527cf, 0x505b, 0x4b50, { 0x99, 0xcd, 0xa3, 0x24, 0x67, 0xfa, 0x4a, 0xa4 } } },
    { L"AmtSetupBin_GUID",                                                    { 0x773cb08b, 0x511a, 0x4bd5, { 0x85, 0xad, 0x41, 0xd4, 0xf4, 0xb6, 0x4a, 0x52 } } },
    { L"ASFVERBBin_GUID",                                                     { 0x4f4ff580, 0xb8a0, 0x4332, { 0xa6, 0xb0, 0xe2, 0xe5, 0x68, 0xe3, 0x6c, 0x9c } } },
    { L"TdtWrapperBin_GUID",                                                  { 0xca5e3df0, 0x940a, 0x48f1, { 0x8c, 0x14, 0xdb, 0x2f, 0xb5, 0x99, 0x8b, 0x36 } } },
    { L"MeSpiRegionBin_GUID",                                                 { 0x10654683, 0xe6cb, 0x49f6, { 0x99, 0xed, 0x1b, 0x23, 0xa2, 0xce, 0xfc, 0x09 } } },
    { L"SmmMeSpiRegionBin_GUID",                                              { 0x0eb9d3ed, 0xc4d3, 0x4d9a, { 0xb2, 0x91, 0xac, 0x3b, 0xc9, 0xc3, 0xc8, 0xfb } } },
    { L"AmtSmbios131Bin_GUID",                                                { 0x2b341c7b, 0x0b32, 0x4a65, { 0x9d, 0x46, 0xe1, 0xb3, 0xab, 0xd4, 0xc2, 0x5c } } },
    { L"ACPI20_DSDT_GUID",                                                    { 0x11d8ac35, 0xfb8a, 0x44d1, { 0x8d, 0x09, 0x0b, 0x56, 0x06, 0xd3, 0x21, 0xb9 } } },
    { L"ACPIBin_GUID",                                                        { 0x16d0a23e, 0xc09c, 0x407d, { 0xa1, 0x4a, 0xad, 0x05, 0x8f, 0xdd, 0x0c, 0xa1 } } },
    { L"SmbiosDMIEditBoardBin_GUID",                                          { 0xaf382531, 0x52e6, 0x4cc4, { 0xb2, 0x47, 0xdb, 0x8e, 0x32, 0x0c, 0xbb, 0xa3 } } },
    { L"SMBiosStaticData_SECTION_GUID",                                       { 0xab56dc60, 0x0057, 0x11da, { 0xa8, 0xdb, 0x00, 0x01, 0x02, 0xee, 0xe6, 0x26 } } },
    { L"SMBiosBoardBin_GUID",                                                 { 0xcef68c66, 0x06ab, 0x4fb3, { 0xa3, 0xed, 0x5f, 0xfa, 0x88, 0x5b, 0x57, 0x25 } } },
    { L"DtsDxePolicyInit_FILE_GUID",                                          { 0x09767db6, 0x412a, 0x45ba, { 0x80, 0x26, 0xf0, 0x87, 0xca, 0xe2, 0x10, 0xe3 } } },
    { L"AmiDtsPolicyBin_GUID",                                                { 0x1ab12a1b, 0xeebd, 0x33f0, { 0x8b, 0x3c, 0xa1, 0x45, 0xb8, 0xbe, 0x3f, 0xf0 } } },
    { L"SetupBin_GUID",                                                       { 0x899407d7, 0x99fe, 0x43d8, { 0x9a, 0x21, 0x79, 0xec, 0x32, 0x8c, 0xac, 0x21 } } },
    { L"AmiPpmPolicyBin_GUID",                                                { 0x1ce12314, 0xafbc, 0x11f0, { 0x8a, 0x3e, 0xab, 0x44, 0xb8, 0xee, 0x31, 0x20 } } },
    { L"PpmPolicyInitDxe_FILE_GUID",                                          { 0x2df10014, 0xcf21, 0x4280, { 0x8c, 0x3f, 0xe5, 0x39, 0xb8, 0xee, 0x51, 0x50 } } },
    { L"DPPM_ACPI_TABLE_STORAGE_GUID",                                        { 0xd8de84b4, 0x223e, 0x4aa9, { 0xa7, 0xb3, 0x7f, 0x17, 0x13, 0x76, 0x8d, 0xb2 } } },
    { L"Dppm_FILE_GUID",                                                      { 0x42a78463, 0x8175, 0x406a, { 0xb5, 0x63, 0x75, 0x8a, 0xda, 0x64, 0x5e, 0xbc } } },
    { L"AcpiPlatformBin_GUID",                                                { 0x8b5fbabd, 0xf51f, 0x4942, { 0xbf, 0x16, 0x16, 0xaa, 0xa3, 0x8a, 0xe5, 0x2b } } },
    { L"SMBIOSUpdateDataBin_GUID",                                            { 0xb98999a4, 0xe96f, 0x475a, { 0x99, 0xfc, 0x76, 0x21, 0x26, 0xf5, 0x0f, 0x5a } } },
    { L"PlatformInfoBin_GUID",                                                { 0x1314216c, 0xcb8d, 0x421c, { 0xb8, 0x54, 0x06, 0x23, 0x13, 0x86, 0xe6, 0x42 } } },
    { L"AMI_EFI_SOL_POST_MESSAGE_GUID",                                       { 0xf42f3752, 0x012e, 0x4812, { 0x99, 0xe6, 0x49, 0xf9, 0x43, 0x04, 0x84, 0x54 } } },
    { L"DXE_CPU_INT_LIB_GUID",                                                { 0x1ba0062e, 0xc779, 0x4582, { 0x85, 0x66, 0x33, 0x6a, 0xe8, 0xf7, 0x8f, 0x09 } } },
    { L"FastBootPeiBin_GUID",                                                 { 0x333bb2a3, 0x4f20, 0x4ccc, { 0xac, 0x38, 0x06, 0x72, 0xd7, 0x41, 0x23, 0x45 } } },
    { L"LegacyRegionBin_GUID",                                                { 0x59242dd8, 0xe7cf, 0x4979, { 0xb6, 0x0e, 0xa6, 0x06, 0x7e, 0x2a, 0x18, 0x5f } } },
    { L"UpdateMemoryRecordBin_GUID",                                          { 0x24ccd374, 0x3df6, 0x4181, { 0x86, 0xf6, 0xe3, 0xc6, 0x69, 0x20, 0xa1, 0x45 } } },
    { L"SmBiosMemoryBin_GUID",                                                { 0xeda39402, 0xf375, 0x4496, { 0x92, 0xd3, 0x83, 0xb4, 0x3c, 0xb8, 0xa7, 0x6a } } },
    { L"SmmChildDispatcherBin_GUID",                                          { 0x753630c9, 0xfae5, 0x47a9, { 0xbb, 0xbf, 0x88, 0xd6, 0x21, 0xcd, 0x72, 0x82 } } },
    { L"LegacyInterruptBin_GUID",                                             { 0x71ed12d1, 0x250b, 0x42fb, { 0x8c, 0x17, 0x10, 0xdc, 0xfa, 0x77, 0x17, 0x01 } } },
    { L"SBSMIBin_GUID",                                                       { 0x7b8db049, 0xc7c7, 0x4d3b, { 0x80, 0x9f, 0x92, 0x6d, 0xee, 0x47, 0xcc, 0xa2 } } },
    { L"AcpiModeEnableBin_GUID",                                              { 0x750890a6, 0x7acf, 0x4f4f, { 0x81, 0xbd, 0xb4, 0x00, 0xc2, 0xbe, 0xa9, 0x5a } } },
    { L"PowerButtonBin_GUID",                                                 { 0xe566b097, 0x4378, 0x485f, { 0x91, 0xd0, 0x1c, 0x09, 0x7c, 0x19, 0x0c, 0xe2 } } },
    { L"SleepSmiBin_GUID",                                                    { 0x6298fe18, 0xd5ef, 0x42b7, { 0xbb, 0x0c, 0x29, 0x53, 0x28, 0x3f, 0x57, 0x04 } } },
    { L"WdtAppDxe_Bin_GUID",                                                  { 0xce366d33, 0xb057, 0x4c03, { 0x85, 0x61, 0xca, 0xf1, 0x77, 0x38, 0xb6, 0x6f } } },
    { L"WdtAppPeiBin_GUID",                                                   { 0x0f69f6d7, 0x0e4b, 0x43a6, { 0xbf, 0xc2, 0x68, 0x71, 0x69, 0x43, 0x69, 0xb0 } } },
    { L"PciHotPlugBin_GUID",                                                  { 0x3022e512, 0xb94a, 0x4f12, { 0x80, 0x6d, 0x7e, 0xf1, 0x17, 0x78, 0x99, 0xd8 } } },
    { L"PchSpiWrapBin_GUID",                                                  { 0xb716a6f8, 0xf3a1, 0x4b8e, { 0x85, 0x82, 0x5a, 0x30, 0x3f, 0x1c, 0xdd, 0x64 } } },
    { L"SignONPack_GUID",                                                     { 0x2ebe0275, 0x6458, 0x4af9, { 0x91, 0xed, 0xd3, 0xf4, 0xed, 0xb1, 0x00, 0xaa } } },
    { L"AMICspLibDxe_GUID",                                                   { 0xcd84562c, 0x6864, 0x40a3, { 0xa0, 0x81, 0xc8, 0xd3, 0x5e, 0x82, 0xb9, 0x20 } } },
    { L"MicrocodeUpdateBin_GUID",                                             { 0xf3331de6, 0x4a55, 0x44e4, { 0xb7, 0x67, 0x74, 0x53, 0xf7, 0xa1, 0xa0, 0x21 } } },
    { L"CORE_DXEBin_GUID",                                                    { 0x5ae3f37e, 0x4eae, 0x41ae, { 0x82, 0x40, 0x35, 0x46, 0x5b, 0x5e, 0x81, 0xeb } } },
    { L"NVRAM_FFS_GUID",                                                      { 0xcef5b9a3, 0x476d, 0x497f, { 0x9f, 0xdc, 0xe9, 0x81, 0x43, 0xe0, 0x42, 0x2c } } },
    { L"IdeSMARTBin_GUID",                                                    { 0xd57c852e, 0x809f, 0x45cf, { 0xa3, 0x77, 0xd7, 0x7b, 0xc0, 0xcb, 0x78, 0xee } } },
    { L"AhciSmmBin_GUID",                                                     { 0xbc3245bd, 0xb982, 0x4f55, { 0x9f, 0x79, 0x05, 0x6a, 0xd7, 0xe9, 0x87, 0xc5 } } },
    { L"AhciBin_GUID",                                                        { 0x8f5a2e02, 0x538c, 0x4d59, { 0xb9, 0x20, 0xc4, 0x78, 0x6a, 0xcb, 0xc5, 0x52 } } },
    { L"CSMCOREBin_GUID",                                                     { 0xa062cf1f, 0x8473, 0x4aa3, { 0x87, 0x93, 0x60, 0x0b, 0xc4, 0xff, 0xe9, 0xa8 } } },
    { L"CSMCOREBin_GUID",                                                     { 0xe6f4f8f7, 0x4992, 0x47b2, { 0x83, 0x02, 0x85, 0x08, 0x74, 0x5e, 0x4a, 0x23 } } },
    { L"x86Thunk_ffs_GUID",                                                   { 0xa08276ec, 0xa0fe, 0x4e06, { 0x86, 0x70, 0x38, 0x53, 0x36, 0xc7, 0xd0, 0x93 } } },
    { L"CsmVideoBin_GUID",                                                    { 0x29cf55f8, 0xb675, 0x4f5d, { 0x8f, 0x2f, 0xb8, 0x7a, 0x3e, 0xcf, 0xd0, 0x63 } } },
    { L"CsmBlockIoBin_GUID",                                                  { 0x25acf158, 0xdd61, 0x4e64, { 0x9a, 0x49, 0x55, 0x85, 0x1e, 0x9a, 0x26, 0xc7 } } },
    { L"PeiRamBootBin_GUID",                                                  { 0x08efd15d, 0xec55, 0x4023, { 0xb6, 0x48, 0x7b, 0xa4, 0x0d, 0xf7, 0xd0, 0x5d } } },
    { L"PeiRamBootCacheRdyBin_GUID",                                          { 0xa6a3a962, 0xc591, 0x4701, { 0x9d, 0x25, 0x73, 0xd0, 0x22, 0x6d, 0x89, 0xdc } } },
    { L"SmmDispatcherBin_GUID",                                               { 0x4a37320b, 0x3fb3, 0x4365, { 0x97, 0x30, 0x9e, 0x89, 0xc6, 0x00, 0x39, 0x5d } } },
    { L"SmmEntryBin_GUID",                                                    { 0xd2596f82, 0xf0e1, 0x49fa, { 0x95, 0xbc, 0x62, 0x01, 0x2c, 0x79, 0x57, 0x28 } } },
    { L"SmmBaseBin_GUID",                                                     { 0xd0632c90, 0xafd7, 0x4492, { 0xb1, 0x86, 0x25, 0x7c, 0x63, 0x14, 0x3c, 0x61 } } },
    { L"TERMINALBIN_GUID",                                                    { 0x7a08cb98, 0xe9bc, 0x41c3, { 0xbe, 0x19, 0xb3, 0x02, 0xf3, 0xf1, 0xf5, 0x95 } } },
    { L"tcgdxeBin_GUID",                                                      { 0x5e9caba3, 0xf2b1, 0x497a, { 0xad, 0xac, 0x24, 0xf5, 0x75, 0xe9, 0xcd, 0xe9 } } },
    { L"MPTPM_ffs_GUID",                                                      { 0x7d113aa9, 0x6280, 0x48c6, { 0xba, 0xce, 0xdf, 0xe7, 0x66, 0x8e, 0x83, 0x07 } } },
    { L"TPM32BIN_ffs_GUID",                                                   { 0x0aa31bc6, 0x3379, 0x41e8, { 0x82, 0x5a, 0x53, 0xf8, 0x2c, 0xc0, 0xf2, 0x54 } } },
    { L"LEGX16_ffs_GUID",                                                     { 0x142204e2, 0xc7b1, 0x4af9, { 0xa7, 0x29, 0x92, 0x37, 0x58, 0xd9, 0x6d, 0x03 } } },
    { L"TcgLegacyBIN_GUID",                                                   { 0x858ebe6f, 0x360f, 0x415b, { 0xb7, 0xdc, 0x46, 0x3a, 0xae, 0xb0, 0x34, 0x12 } } },
    { L"TCGSmmBin_GUID",                                                      { 0xfd93f9e1, 0x3c73, 0x46e0, { 0xb7, 0xb8, 0x2b, 0xba, 0x3f, 0x71, 0x8f, 0x6c } } },
    { L"TcgPeiBin_GUID",                                                      { 0x34989d8e, 0x930a, 0x4a95, { 0xab, 0x04, 0x2e, 0x6c, 0xfd, 0xff, 0x66, 0x31 } } },
    { L"OFBDBin_GUID",                                                        { 0x57e56594, 0xce95, 0x46ad, { 0x95, 0x31, 0x3c, 0x49, 0x31, 0x0c, 0xa7, 0xce } } },
    { L"AMITSEBin_GUID",                                                      { 0xb1da0adf, 0x4f77, 0x4070, { 0xa8, 0x8e, 0xbf, 0xfe, 0x1c, 0x60, 0x52, 0x9a } } },
    { L"AMITSEBin_GUID",                                                      { 0xfe612b72, 0x203c, 0x47b1, { 0x85, 0x60, 0xa6, 0x6d, 0x94, 0x6e, 0xb3, 0x71 } } },
    { L"SmLogo_ffs_GUID",                                                     { 0x294b1cef, 0x9beb, 0x42d5, { 0x99, 0x71, 0x0c, 0x89, 0x63, 0xcd, 0xaf, 0x02 } } },
    { L"SignONPack_GUID",                                                     { 0xa59a0056, 0x3341, 0x44b5, { 0x9c, 0x9c, 0x6d, 0x76, 0xf7, 0x67, 0x38, 0x17 } } },
    { L"UhcipeiUsbBin_GUID",                                                  { 0x6895f6f0, 0x8879, 0x45b8, { 0xa9, 0xd9, 0x96, 0x39, 0xe5, 0x32, 0x31, 0x9e } } },
    { L"UhcPeimBin_GUID",                                                     { 0xc463ceac, 0xfc57, 0x4f36, { 0x88, 0xb7, 0x35, 0x6c, 0x75, 0x0c, 0x3b, 0xca } } },
    { L"OhciPeiBin_GUID",                                                     { 0x52daa304, 0xdeb3, 0x449b, { 0xaf, 0xb8, 0xa8, 0x8a, 0x54, 0xf2, 0x8f, 0x95 } } },
    { L"XhciPeiBin_GUID",                                                     { 0x45d68db9, 0x8b4e, 0x48c0, { 0x99, 0xe9, 0xf2, 0x1f, 0x26, 0x2d, 0xb6, 0x53 } } },
    { L"EhciPeiBin_GUID",                                                     { 0xd56a4094, 0x570f, 0x4d3d, { 0x8f, 0x5f, 0x8d, 0x8a, 0xa0, 0xb3, 0x96, 0xcb } } },
    { L"UsbBotPeimSrcBin_GUID",                                               { 0x8401a046, 0x6f70, 0x4505, { 0x84, 0x71, 0x70, 0x15, 0xb4, 0x03, 0x55, 0xe3 } } },
    { L"FloppyCtrlBin_GUID",                                                  { 0x8b9d3ee0, 0x4ba4, 0x433b, { 0x9c, 0x48, 0x4e, 0x83, 0x0b, 0x3b, 0x40, 0xfd } } },
    { L"FileSystemBin_GUID",                                                  { 0x93022f8c, 0x1f09, 0x47ef, { 0xbb, 0xb2, 0x58, 0x14, 0xff, 0x60, 0x9d, 0xf5 } } },
    { L"LEGACYSREDIRBin_GUID",                                                { 0x4a3602bc, 0x1a05, 0x4c82, { 0x99, 0xb4, 0x58, 0x8c, 0xd2, 0xa3, 0x2c, 0xd5 } } },
    { L"LEGACYSREDIRBin_GUID",                                                { 0x9ba21891, 0x7e7d, 0x4e94, { 0xb8, 0xdf, 0xf4, 0xd2, 0xd3, 0x20, 0x80, 0x1c } } },
    { L"ReFlashBin_GUID",                                                     { 0x70e1a818, 0x0be1, 0x4449, { 0xbf, 0xd4, 0x9e, 0xf6, 0x8c, 0x7f, 0x02, 0xa8 } } },
    { L"RecoveryBin_GUID",                                                    { 0xe008b434, 0x0e73, 0x440c, { 0x86, 0x12, 0xa1, 0x43, 0xf6, 0xa0, 0x7b, 0xcb } } },
    { L"PciBusBin_GUID",                                                      { 0x3c1de39f, 0xd207, 0x408a, { 0xaa, 0xcc, 0x73, 0x1c, 0xfb, 0x7f, 0x1d, 0xd7 } } },
    { L"PciRootBridgeBin_GUID",                                               { 0x80e66e0a, 0xccd1, 0x43fa, { 0xa7, 0xb1, 0x2d, 0x5e, 0xe0, 0xf1, 0x39, 0x10 } } },
    { L"SmbiosDMIEditBin_GUID",                                               { 0xe2a74738, 0x8934, 0x48f5, { 0x84, 0x12, 0x99, 0xe9, 0x48, 0xc8, 0xdc, 0x1b } } },
    { L"SmbiosGetFlashDataBin_GUID",                                          { 0xded7956d, 0x7e20, 0x4f20, { 0x91, 0xa1, 0x19, 0x04, 0x39, 0xb0, 0x4d, 0x5b } } },
    { L"SMBiosBin_GUID",                                                      { 0xb13edd38, 0x684c, 0x41ed, { 0xa3, 0x05, 0xd7, 0xb7, 0xe3, 0x24, 0x97, 0xdf } } },
    { L"AmiBoardInfoBin_GUID",                                                { 0x9f3a0016, 0xae55, 0x4288, { 0x82, 0x9d, 0xd2, 0x2f, 0xd3, 0x44, 0xc3, 0x47 } } },
    { L"RUNTIMEBin_GUID",                                                     { 0xcbc59c4a, 0x383a, 0x41eb, { 0xa8, 0xee, 0x44, 0x98, 0xae, 0xa5, 0x67, 0xe4 } } },
    { L"IDEBusBin_GUID",                                                      { 0x59b90a53, 0x461b, 0x4c50, { 0xa7, 0x9f, 0xa3, 0x27, 0x73, 0xc3, 0x19, 0xae } } },
    { L"CmosManagerSmmBin_GUID",                                              { 0x6869c5b3, 0xac8d, 0x4973, { 0x8b, 0x37, 0xe3, 0x54, 0xdb, 0xf3, 0x4a, 0xdd } } },
    { L"PeiDbgIDTBin_GUID",                                                   { 0x811b4f4d, 0xfb0b, 0x4008, { 0xa4, 0x2b, 0xe5, 0x51, 0xfd, 0x4a, 0x0f, 0x28 } } },
    { L"PeiDbgXportBin_GUID",                                                 { 0xc7e8bb67, 0x1c3f, 0x41ba, { 0x82, 0x0f, 0x3d, 0x0e, 0x9c, 0x36, 0x50, 0x42 } } },
    { L"PeiDbgDbgrBin_GUID",                                                  { 0x4aaaae15, 0x5aeb, 0x4c11, { 0xb9, 0x1d, 0xa3, 0x96, 0x6a, 0xc0, 0x48, 0x47 } } },
    { L"PeiDebugSupportBin_GUID",                                             { 0xa47438d5, 0x94e9, 0x49b3, { 0xbc, 0x31, 0x7e, 0x6b, 0xc9, 0x36, 0x38, 0x14 } } },
    { L"PeiDbgPortBin_GUID",                                                  { 0xeb7d9740, 0xdb60, 0x45c2, { 0xa7, 0xa0, 0xc2, 0x71, 0x4e, 0xf4, 0xeb, 0x56 } } },
    { L"PeiDbgXportx64Bin_GUID",                                              { 0x511d0266, 0xf2e0, 0x4df8, { 0xae, 0x3a, 0xfd, 0xb9, 0x85, 0x23, 0xbf, 0xb9 } } },
    { L"PeiDbgDbgrx64Bin_GUID",                                               { 0xc253ed0a, 0xc48b, 0x4ee3, { 0xa6, 0x5e, 0x75, 0xf6, 0x1f, 0x3a, 0xd2, 0x51 } } },
    { L"IdeSMMBin_GUID",                                                      { 0x316b1230, 0x0500, 0x4592, { 0x8c, 0x09, 0xea, 0xba, 0x0f, 0xb6, 0xb0, 0x7f } } },
    { L"IdeSecurityBin_GUID",                                                 { 0xa9b700cf, 0x019e, 0x4d8b, { 0xa3, 0xa7, 0x88, 0xe1, 0xea, 0x01, 0x69, 0x9e } } },
    { L"SMIFlashBin_GUID",                                                    { 0xbc327dbd, 0xb982, 0x4f55, { 0x9f, 0x79, 0x05, 0x6a, 0xd7, 0xe9, 0x87, 0xc5 } } },
    { L"S3SaveBin_GUID",                                                      { 0x26a2481e, 0x4424, 0x46a2, { 0x99, 0x43, 0xcc, 0x40, 0x39, 0xea, 0xd8, 0xf8 } } },
    { L"S3RestoreBin_GUID",                                                   { 0xefd652cc, 0x0e99, 0x40f0, { 0x96, 0xc0, 0xe0, 0x8c, 0x08, 0x90, 0x70, 0xfc } } },
    { L"USBRTBin_GUID",                                                       { 0x04eaaaa1, 0x29a1, 0x11d7, { 0x88, 0x38, 0x00, 0x50, 0x04, 0x73, 0xd4, 0xeb } } },
    { L"USBI13_GUID",                                                         { 0x4c006cd9, 0x19ba, 0x4617, { 0x84, 0x83, 0x60, 0x91, 0x94, 0xa1, 0xac, 0xfc } } },
    { L"UHCDBin_GUID",                                                        { 0x580dd900, 0x385d, 0x11d7, { 0x88, 0x3a, 0x00, 0x50, 0x04, 0x73, 0xd4, 0xeb } } },
    { L"CORE_PEIBin_GUID",                                                    { 0x92685943, 0xd810, 0x47ff, { 0xa1, 0x12, 0xcc, 0x84, 0x90, 0x77, 0x6a, 0x1f } } },
    { L"DigitalThermalSensorSmmBin_GUID",                                     { 0x77a6009e, 0x116e, 0x464d, { 0x8e, 0xf8, 0xb3, 0x52, 0x01, 0xa0, 0x22, 0xdd } } },
    { L"SwitchableGraphicsDxeBin_GUID",                                       { 0x0d82a9ec, 0x1289, 0x4fd4, { 0xac, 0x0b, 0x4c, 0x6b, 0x1a, 0x25, 0xab, 0xc6 } } },
    { L"SgDxePolicyInitBin_GUID",                                             { 0x63b2bc2d, 0xdf5d, 0x419b, { 0x87, 0x3c, 0x2c, 0x78, 0xa6, 0x60, 0x4a, 0x7a } } },
    { L"SgPeiPolicyInitBin_GUID",                                             { 0x1e75e77f, 0x8a15, 0x4653, { 0x96, 0x4d, 0x54, 0x2c, 0x15, 0x7e, 0xf4, 0x0a } } },
    { L"SwitchableGraphicsPeiBin_GUID",                                       { 0x7ede6a1f, 0x548e, 0x453e, { 0xa9, 0x5c, 0x66, 0x93, 0x9f, 0xe0, 0x29, 0x5c } } },
    { L"TxtDxeBin_GUID",                                                      { 0xff917e22, 0xa228, 0x448d, { 0xbd, 0xaa, 0x68, 0xef, 0xcc, 0xdd, 0xa5, 0xd3 } } },
    { L"TxtPeiBin_GUID",                                                      { 0xca9d8617, 0xd652, 0x403b, { 0xb6, 0xc5, 0xba, 0x47, 0x57, 0x01, 0x16, 0xad } } },
    { L"PciExpressDxeBin_GUID",                                               { 0xa89ec8e0, 0x0ba1, 0x40aa, { 0xa0, 0x3e, 0xab, 0xdd, 0xa5, 0x29, 0x5c, 0xde } } },
    { L"SmmAccessBin_GUID",                                                   { 0x1323c7f8, 0xdad5, 0x4126, { 0xa5, 0x4b, 0x7a, 0x05, 0xfb, 0xf4, 0x15, 0x15 } } },
    { L"MemoryInitBin_GUID",                                                  { 0x3b42ef57, 0x16d3, 0x44cb, { 0x86, 0x32, 0x9f, 0xdb, 0x06, 0xb4, 0x14, 0x51 } } },
    { L"SaInitDxeBin_GUID",                                                   { 0xde23acee, 0xcf55, 0x4fb6, { 0xaa, 0x77, 0x98, 0x4a, 0xb5, 0x3d, 0xe8, 0x11 } } },
    { L"PchInitDxeBin_GUID",                                                  { 0xde23acee, 0xcf55, 0x4fb6, { 0xaa, 0x77, 0x98, 0x4a, 0xb5, 0x3d, 0xe8, 0x23 } } },
    { L"CvInitDxeBin_GUID",                                                   { 0xde23acee, 0xcf55, 0x4fb6, { 0xaa, 0x77, 0x98, 0x4a, 0xb5, 0x3d, 0xe8, 0x11 } } },
    { L"SaInitPeimBin_GUID",                                                  { 0xfd236ae7, 0x0791, 0x48c4, { 0xb2, 0x9e, 0x29, 0xbd, 0xee, 0xe1, 0xa8, 0x11 } } },
    { L"PchInitPeimBin_GUID",                                                 { 0xfd236ae7, 0x0791, 0x48c4, { 0xb2, 0x9e, 0x29, 0xbd, 0xee, 0xe1, 0xa8, 0x38 } } },
    { L"CvInitPeimBin_GUID",                                                  { 0xfd236ae7, 0x0791, 0x48c4, { 0xb2, 0x9e, 0x29, 0xbd, 0xee, 0xe1, 0xa8, 0x11 } } },
    { L"IchInitPeimBin_GUID",                                                 { 0xfd236ae7, 0x0791, 0x48c4, { 0xb2, 0x9e, 0x29, 0xbd, 0xee, 0xe1, 0xa8, 0x38 } } },
    { L"SaAcpiTables_ffs_GUID",                                               { 0x27e569d5, 0x0afc, 0x4d8f, { 0x8c, 0x90, 0x78, 0x3a, 0xc4, 0xa3, 0x18, 0xab } } },
    { L"PciHostBridgeBin_GUID",                                               { 0x8d6756b9, 0xe55e, 0x4d6a, { 0xa3, 0xa5, 0x5e, 0x4d, 0x72, 0xdd, 0xf7, 0x72 } } },
    { L"SataControllerBin_GUID",                                              { 0xbb65942b, 0x521f, 0x4ec3, { 0xba, 0xf9, 0xa9, 0x25, 0x40, 0xcf, 0x60, 0xd2 } } },
    { L"SmmControlBin_GUID",                                                  { 0xa0bad9f7, 0xab78, 0x491b, { 0xb5, 0x83, 0xc5, 0x2b, 0x7f, 0x84, 0xb9, 0xe0 } } },
    { L"PchResetBin_GUID",                                                    { 0xbb1fbd4f, 0x2e30, 0x4793, { 0x9b, 0xed, 0x74, 0xf6, 0x72, 0xbc, 0x8f, 0xfe } } },
    { L"PchSmbusDxeBin_GUID",                                                 { 0xe052d8a6, 0x224a, 0x4c32, { 0x8d, 0x37, 0x2e, 0x0a, 0xe1, 0x62, 0x36, 0x4d } } },
    { L"DxeIchSmbusBin_GUID",                                                 { 0xe052d8a6, 0x224a, 0x4c32, { 0x8d, 0x37, 0x2e, 0x0a, 0xe1, 0x62, 0x36, 0x4d } } },
    { L"PchSmbusSmmBin_GUID",                                                 { 0x59287178, 0x59b2, 0x49ca, { 0xbc, 0x63, 0x53, 0x2b, 0x12, 0xea, 0x2c, 0x53 } } },
    { L"PchSmbusArpDisabledBin_GUID",                                         { 0x643df777, 0xf312, 0x42ed, { 0x81, 0xcc, 0x1b, 0x1f, 0x57, 0xe1, 0x8a, 0xd6 } } },
    { L"IchSmbusArpDisabledBin_GUID",                                         { 0x643df777, 0xf312, 0x42ed, { 0x81, 0xcc, 0x1b, 0x1f, 0x57, 0xe1, 0x8a, 0xd6 } } },
    { L"PchSmbusArpEnabledBin_GUID",                                          { 0x22b194b4, 0xcc0e, 0x46c7, { 0x9f, 0xce, 0xda, 0x10, 0xd6, 0xed, 0x17, 0x31 } } },
    { L"WdtDxeBin_GUID",                                                      { 0x5aab83e5, 0xf027, 0x4ca7, { 0xbf, 0xd0, 0x16, 0x35, 0x8c, 0xc9, 0xe4, 0x53 } } },
    { L"WdtPeiBin_GUID",                                                      { 0x1d88c542, 0x9df7, 0x424a, { 0xaa, 0x90, 0x02, 0xb6, 0x1f, 0x28, 0x69, 0x38 } } },
    { L"PchPcieSmmBin_GUID",                                                  { 0xacaeaa7a, 0xc039, 0x4424, { 0x88, 0xda, 0xf4, 0x22, 0x12, 0xea, 0x0e, 0x55 } } },
    { L"SmartTimerBin_GUID",                                                  { 0x90cb75db, 0x71fc, 0x489d, { 0xaa, 0xcf, 0x94, 0x34, 0x77, 0xec, 0x72, 0x12 } } },
    { L"PchSpiSmmBin_GUID",                                                   { 0x27f4917b, 0xa707, 0x4aad, { 0x96, 0x76, 0x26, 0xdf, 0x16, 0x8c, 0xbf, 0x0d } } },
    { L"IchSpiSmmBin_GUID",                                                   { 0x27f4917b, 0xa707, 0x4aad, { 0x96, 0x76, 0x26, 0xdf, 0x16, 0x8c, 0xbf, 0x0d } } },
    { L"PchSpiPeimBin_GUID",                                                  { 0xaa652cb9, 0x2d52, 0x4624, { 0x9f, 0xae, 0xd4, 0xe5, 0x8b, 0x67, 0xca, 0x46 } } },
    { L"IchSpiPeimBin_GUID",                                                  { 0xaa652cb9, 0x2d52, 0x4624, { 0x9f, 0xae, 0xd4, 0xe5, 0x8b, 0x67, 0xca, 0x46 } } },
    { L"PchSpiRuntimeBin_GUID",                                               { 0xc194c6ea, 0xb68c, 0x4981, { 0xb6, 0x4b, 0x9b, 0xd2, 0x71, 0x47, 0x4b, 0x20 } } },
    { L"IchSpiRuntimeBin_GUID",                                               { 0xc194c6ea, 0xb68c, 0x4981, { 0xb6, 0x4b, 0x9b, 0xd2, 0x71, 0x47, 0x4b, 0x20 } } },
    { L"PchSerialGpioBin_GUID",                                               { 0xfc1b7640, 0x3466, 0x4c06, { 0xb1, 0xcc, 0x1c, 0x93, 0x53, 0x94, 0xb5, 0xc2 } } },
    { L"IoTrapBin_GUID",                                                      { 0x2374eddf, 0xf203, 0x4fc0, { 0xa2, 0x0e, 0x61, 0xba, 0xd7, 0x30, 0x89, 0xd6 } } },
    { L"PchS3SupportBin_GUID",                                                { 0x08f2c63b, 0x08de, 0x4ccd, { 0x86, 0x70, 0xac, 0xfe, 0x64, 0x4a, 0x1c, 0x48 } } },
    { L"PchS3PeimBin_GUID",                                                   { 0x271dd6f2, 0x54cb, 0x45e6, { 0x85, 0x85, 0x8c, 0x92, 0x3c, 0x1a, 0xc7, 0x06 } } },
    { L"PchSmiDispatcherBin_GUID",                                            { 0xb0d6ed53, 0xb844, 0x43f5, { 0xbd, 0x2f, 0x61, 0x09, 0x52, 0x64, 0xe7, 0x7e } } },
    { L"PchUsbBin_GUID",                                                      { 0x6b4fdbd2, 0x47e1, 0x4a09, { 0xba, 0x8e, 0x8e, 0x04, 0x1f, 0x20, 0x8b, 0x95 } } },
    { L"IntelLegacyInterruptBin_GUID",                                        { 0xc1c418f9, 0x591d, 0x461c, { 0x82, 0xa2, 0xb9, 0xcd, 0x96, 0xdf, 0xea, 0x86 } } },
    { L"ActiveBiosBin_GUID",                                                  { 0xbfd59d42, 0xfe0f, 0x4251, { 0xb7, 0x72, 0x4b, 0x09, 0x8a, 0x1a, 0xec, 0x85 } } },
    { L"LegacyMebxMain_ffs_GUID",                                             { 0x17772369, 0xd262, 0x4b90, { 0x9f, 0x31, 0xbd, 0xc4, 0x1f, 0x26, 0x63, 0xa5 } } },
    { L"LegacyMebxLaunch_ffs_GUID",                                           { 0x7c81c66a, 0x4f11, 0x47ab, { 0x82, 0xd3, 0x67, 0xc4, 0xd6, 0x35, 0xae, 0xd1 } } },
    { L"BiosExtensionLoaderBin_GUID",                                         { 0x97cc7188, 0x79c9, 0x449f, { 0xb9, 0x69, 0x06, 0x5b, 0x64, 0xbf, 0x9c, 0x69 } } },
    { L"HeciDxeBin_GUID",                                                     { 0x55e76644, 0x78a5, 0x4a82, { 0xa9, 0x00, 0x71, 0x26, 0xa5, 0x79, 0x88, 0x92 } } },
    { L"HeciSmmBin_GUID",                                                     { 0x921cd783, 0x3e22, 0x4579, { 0xa7, 0x1f, 0x00, 0xd7, 0x41, 0x97, 0xfc, 0xc8 } } },
    { L"TdtDxeBin_GUID",                                                      { 0xdcaa4b60, 0x408f, 0x4bad, { 0x99, 0xb9, 0xb8, 0x80, 0xd4, 0xef, 0x09, 0x50 } } },
    { L"TdtAmBin_GUID",                                                       { 0xc810485e, 0xd0ec, 0x4e98, { 0xaa, 0xb5, 0x12, 0x0c, 0x7e, 0x55, 0x44, 0x28 } } },
    { L"Tdt3gBin_GUID",                                                       { 0x24be45e6, 0x2b61, 0x440d, { 0x8a, 0x75, 0xe7, 0x1f, 0xb6, 0xeb, 0x5b, 0x10 } } },
    { L"TdtUsbWdmBin_GUID",                                                   { 0xe9490ad8, 0x348c, 0x4e65, { 0xba, 0xba, 0xed, 0x14, 0xc6, 0x16, 0xc4, 0x14 } } },
    { L"AMTDxeBin_GUID",                                                      { 0xd739f969, 0xfb2d, 0x4bc2, { 0xaf, 0xe7, 0x08, 0x13, 0x27, 0xd3, 0xfe, 0xde } } },
    { L"AsfInitSmmBin_GUID",                                                  { 0xeb78ce7e, 0x4107, 0x4ef5, { 0x86, 0xcb, 0x22, 0xe8, 0xd8, 0xac, 0x49, 0x50 } } },
    { L"StartWatchDogBin_GUID",                                               { 0x5479e09c, 0x2e74, 0x481b, { 0x89, 0xf8, 0xb0, 0x17, 0x2e, 0x38, 0x8d, 0x1f } } },
    { L"IdeRControllerBin_GUID",                                              { 0xc4f2d007, 0x37fd, 0x422d, { 0xb6, 0x3d, 0x7e, 0xd7, 0x38, 0x86, 0xe6, 0xca } } },
    { L"PciSerialBin_GUID",                                                   { 0xfb142b99, 0xdf57, 0x46cb, { 0xbc, 0x69, 0x0b, 0xf8, 0x58, 0xa7, 0x34, 0xf9 } } },
    { L"FlashWriteProtectBin_GUID",                                           { 0xc1443436, 0xb954, 0x43ba, { 0x82, 0x78, 0xc1, 0xe4, 0x42, 0xc2, 0x15, 0x39 } } },
    { L"FlashWriteProtectSmmBin_GUID",                                        { 0x69ef78bc, 0x3b71, 0x4ecc, { 0x83, 0x4f, 0x3b, 0x74, 0xf9, 0x14, 0x84, 0x30 } } },
    { L"AlertStandardFormatDxeBin_GUID",                                      { 0x33c6406d, 0x2f6b, 0x41b5, { 0x87, 0x05, 0x52, 0xba, 0xfb, 0x63, 0x3c, 0x09 } } },
    { L"AlertStandardFormatSmmBin_GUID",                                      { 0xbb87b31d, 0xf366, 0x47e9, { 0x88, 0x5e, 0xe8, 0x16, 0xb0, 0x9b, 0x97, 0xb6 } } },
    { L"AlertStandardFormatPeiBin_GUID",                                      { 0x3e4817fd, 0x2742, 0x4351, { 0xb5, 0x9f, 0x91, 0x49, 0x32, 0x80, 0x32, 0x9c } } },
    { L"MeFwDowngradeBin_GUID",                                               { 0x5820eeb4, 0xc135, 0x4854, { 0x9d, 0x2a, 0xaa, 0x9e, 0xfc, 0x44, 0x75, 0xe9 } } },
    { L"PowerManagementDxeBin_GUID",                                          { 0x84991287, 0x3ff0, 0x4fcc, { 0x9c, 0x11, 0xc7, 0xe0, 0x41, 0x86, 0x2c, 0x76 } } },
    { L"PowerManagementBin_GUID",                                             { 0x8c783970, 0xf02a, 0x4a4d, { 0xaf, 0x09, 0x87, 0x97, 0xa5, 0x1e, 0xec, 0x8d } } },
    { L"CpuCspLibAsm_obj_GUID",                                               { 0x1ba0062e, 0xc779, 0x4582, { 0x85, 0x66, 0x33, 0x6a, 0xe8, 0xf7, 0x8f, 0x09 } } },
    { L"STARTUP_GUID",                                                        { 0x1ba0062e, 0xc779, 0x4582, { 0x85, 0x66, 0x33, 0x6a, 0xe8, 0xf7, 0x8f, 0x09 } } },
    { L"IntelGigabitLan_ffs_GUID",                                            { 0x4953f720, 0x006d, 0x41f5, { 0x99, 0x0d, 0x0a, 0xc7, 0x74, 0x2a, 0xbb, 0x60 } } },
    { L"RsdpPlusBin_GUID",                                                    { 0x67c53648, 0xda56, 0x4726, { 0xae, 0x21, 0xfb, 0xa4, 0xd0, 0x46, 0x86, 0xb3 } } },
    { L"AmiTcgPlatformPeiBeforeMembin_GUID",                                  { 0xe9312938, 0xe56b, 0x4614, { 0xa2, 0x52, 0xcf, 0x7d, 0x2f, 0x37, 0x7e, 0x26 } } },
    { L"TcgPeiplatformBin_GUID",                                              { 0x6b844c5b, 0x6b75, 0x42ca, { 0x8e, 0x8e, 0x1c, 0xb9, 0x44, 0x12, 0xb5, 0x9b } } },
    { L"AmiTcgPlatformPeiAfterMembin_GUID",                                   { 0x9b3f28d5, 0x10a6, 0x46c8, { 0xba, 0x72, 0xbd, 0x40, 0xb8, 0x47, 0xa7, 0x1a } } },
    { L"TcgPlatformSetupPolicyBin_GUID",                                      { 0x196ca3d8, 0x9a5a, 0x4735, { 0xb3, 0x28, 0x8f, 0xfc, 0x1d, 0x93, 0xd1, 0x88 } } },
    { L"TcgDxeplatformBin_GUID",                                              { 0x2688b232, 0x9c02, 0x4c12, { 0xbe, 0x1f, 0x85, 0x7c, 0x0f, 0xf2, 0xaa, 0xe3 } } },
    { L"AmiTcgPlatformDxebin_GUID",                                           { 0xa29a63e3, 0xe4e7, 0x495f, { 0x8a, 0x6a, 0x07, 0x73, 0x83, 0x00, 0xcb, 0xb3 } } },
    { L"AmiTcgNvflagSamplebin_GUID",                                          { 0x50f6096d, 0x7c98, 0x4c78, { 0x9a, 0x1d, 0xc5, 0xa1, 0x83, 0x3b, 0x6a, 0x88 } } },
    { L"TcgPlatformSetupPeiPolicyBin_GUID",                                   { 0x0fe9da53, 0x043d, 0x4265, { 0xa9, 0x4d, 0xfd, 0x77, 0xfe, 0xde, 0x2e, 0xb4 } } },
    { L"MEPeiPolicyInitBin_GUID",                                             { 0x12c67be1, 0xad2e, 0x4f13, { 0xa9, 0x5f, 0x6e, 0xdc, 0x2c, 0x43, 0x92, 0xde } } },
    { L"AmtPeiPolicyInitBin_GUID",                                            { 0xa05ece52, 0x15a8, 0x424e, { 0xbf, 0xd3, 0xfc, 0xf3, 0xd5, 0x66, 0xa0, 0x9c } } },
    { L"iFfsDxePolicyInitBin_GUID",                                           { 0xddb412a6, 0xe3f3, 0x4e9e, { 0x90, 0xa3, 0x2a, 0x99, 0x12, 0x70, 0x21, 0x9c } } },
    { L"AcousticBin_GUID",                                                    { 0x0639408b, 0x19a6, 0x4b5d, { 0xba, 0xfb, 0x12, 0xa2, 0xf5, 0x11, 0x40, 0x32 } } },
    { L"PerfTunePeiBin_GUID",                                                 { 0xdf8556f0, 0x3a61, 0x11de, { 0x8a, 0x39, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } } },
    { L"PerfTuneDxeBin_GUID",                                                 { 0xf16bdbf0, 0x3a61, 0x11de, { 0x8a, 0x39, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } } },
    { L"PerfTuneSmmBin_GUID",                                                 { 0xcb49ce50, 0x3a75, 0x11de, { 0x8a, 0x39, 0x08, 0x00, 0x20, 0x0c, 0x9a, 0x66 } } },
    { L"SBSATAIDE_ffs_GUID",                                                  { 0x22046d50, 0xf390, 0x498c, { 0x92, 0xe5, 0x5b, 0xa4, 0xf8, 0xe7, 0xf8, 0xb6 } } },
    { L"LegacyRegion2Bin_GUID",                                               { 0xfe6f8acd, 0x55a6, 0x4c6b, { 0xb4, 0x48, 0x64, 0xe6, 0x59, 0xde, 0x94, 0xb3 } } },
    { L"IntelSaGopDriverBin_GUID",                                            { 0x5c266089, 0xe103, 0x4d43, { 0x9a, 0xb5, 0x12, 0xd7, 0x09, 0x5b, 0xe2, 0xaf } } },
    { L"IvbDummyName_ffs_GUID",                                               { 0x878ac2cc, 0x5343, 0x46f2, { 0xb5, 0x63, 0x51, 0xf8, 0x9d, 0xaf, 0x56, 0xba } } },
    { L"IntelIvbGopDriver_ffs_GUID",                                          { 0x5bba83e6, 0xf027, 0x4ca7, { 0xbf, 0xd0, 0x16, 0x35, 0x8c, 0xc9, 0xe1, 0x23 } } },
    { L"SnbDummyName_ffs_GUID",                                               { 0x0f729f33, 0x25c1, 0x41a7, { 0x86, 0xb2, 0x23, 0xa7, 0x37, 0xa9, 0x18, 0x23 } } },
    { L"IntelSnbGopDriver_ffs_GUID",                                          { 0x8d59ebc8, 0xb85e, 0x400e, { 0x97, 0x0a, 0x1f, 0x99, 0x5d, 0x1d, 0xb9, 0x1e } } },
    { L"SmmChildDispatcher2Bin_GUID",                                         { 0xe53734a3, 0xe594, 0x4c25, { 0xb1, 0xa2, 0x08, 0x14, 0x45, 0x65, 0x0f, 0x7f } } },
    { L"AMISmBusLib_lib_GUID",                                                { 0x4b680e2d, 0x0d63, 0x4f62, { 0xb9, 0x30, 0x7a, 0xe9, 0x95, 0xb9, 0xb3, 0xa3 } } },
    { L"SmBusPeiBin_GUID",                                                    { 0x9ea28d33, 0x0175, 0x4788, { 0xbe, 0xa8, 0x69, 0x50, 0x51, 0x60, 0x30, 0xa5 } } },
    { L"SataDriver_ffs_GUID",                                                 { 0x91b4d9c1, 0x141c, 0x4824, { 0x8d, 0x02, 0x3c, 0x29, 0x8e, 0x36, 0xeb, 0x3f } } },
    { L"CpuSpSmiBin_GUID",                                                    { 0x116e1acf, 0x2533, 0x4cc2, { 0x82, 0x0a, 0xbb, 0xc1, 0x0a, 0x2a, 0xb0, 0x7c } } },
    { L"CpuSmmSaveResBin_GUID",                                               { 0x326e7ace, 0x2133, 0x1ba2, { 0x80, 0x0a, 0xb9, 0xc0, 0x0a, 0xcc, 0xb1, 0x7d } } },
    { L"NVRAM_FFS_GUID",                                                      { 0x9221315b, 0x30bb, 0x46b5, { 0x81, 0x3e, 0x1b, 0x1b, 0xf4, 0x71, 0x2b, 0xd3 } } },
    { L"RomLayout_ini_GUID",                                                  { 0xae717c2f, 0x1a42, 0x4f2b, { 0x88, 0x61, 0x78, 0xb7, 0x9c, 0xa0, 0x7e, 0x07 } } },
    { L"AhciMmioSmmBin_GUID",                                                 { 0x96f1ac24, 0x2b21, 0x45fa, { 0xa0, 0xb5, 0x67, 0x01, 0x0c, 0x95, 0xe9, 0xd8 } } },
    { L"CryptoAPIPeiBin_GUID",                                                { 0xd6d2fba6, 0xef60, 0x4c38, { 0xa8, 0x3e, 0x67, 0x69, 0x81, 0x4d, 0x23, 0xb0 } } },
    { L"CryptoAPIDxeBin_GUID",                                                { 0x20d8fffe, 0x15c3, 0x4ea9, { 0x9d, 0x28, 0xcf, 0xe2, 0x74, 0x5d, 0x78, 0xf3 } } },
    { L"TcgPeiBinMem_GUID",                                                   { 0x12345678, 0x930a, 0x4a95, { 0xab, 0x04, 0x2e, 0x6c, 0xfd, 0xff, 0x66, 0x31 } } },
    { L"FastBootSMIBin_GUID",                                                 { 0xd122882c, 0xda73, 0x438b, { 0xa6, 0xb3, 0xe0, 0x7b, 0x7d, 0x18, 0xdb, 0x6f } } },
    { L"EBCBin_GUID",                                                         { 0x13ac6dd0, 0x73d0, 0x11d4, { 0xb0, 0x6b, 0x00, 0xaa, 0x00, 0xbd, 0x6d, 0xe7 } } },
    { L"KbcEmulBin_GUID",                                                     { 0x3b24f79d, 0x91a0, 0x46ff, { 0xbe, 0x29, 0x45, 0x8a, 0xe2, 0x11, 0xfa, 0xc5 } } },
    { L"OemActivationBin_GUID",                                               { 0xc8ca0bb8, 0x67da, 0x4883, { 0x8c, 0xfc, 0x91, 0x80, 0xcb, 0x9e, 0xec, 0x68 } } },
    { L"SecFlashUpdDxeBin_GUID",                                              { 0xa0ef80e3, 0xf9ab, 0x4cba, { 0x98, 0xfd, 0x70, 0x46, 0x20, 0xf4, 0x04, 0x8d } } },
    { L"FwCapsuleRecoveryPPIBin_GUID",                                        { 0x83fa5aed, 0x5171, 0x4949, { 0xbd, 0xc9, 0x0c, 0xbc, 0x9e, 0x12, 0x36, 0x63 } } },
    { L"FWpriv_GUID",                                                         { 0x3feec852, 0xf14c, 0x4e7f, { 0x97, 0xfd, 0x4c, 0x3a, 0x8c, 0x5b, 0xbe, 0xcc } } },
    { L"FWpriv_GUID",                                                         { 0x9e625a27, 0x4840, 0x47cc, { 0xa6, 0xb5, 0x1e, 0x93, 0x11, 0xcf, 0xc6, 0x0e } } },
    { L"SecureBootModDxe_GUID",                                               { 0xa95c1d60, 0xcb9f, 0x4bd8, { 0xa0, 0x30, 0x3f, 0x1c, 0x4a, 0x18, 0x51, 0x56 } } },
    { L"SETPLATFORMKEYS_GUID",                                                { 0xcc0f8a3f, 0x3dea, 0x4376, { 0x96, 0x79, 0x54, 0x26, 0xba, 0x0a, 0x90, 0x7e } } },
    { L"SETPLATFORMKEYS_GUID",                                                { 0x9fe7de69, 0x0aea, 0x470a, { 0xb5, 0x0a, 0x13, 0x98, 0x13, 0x64, 0x91, 0x89 } } },
    { L"SETPLATFORMKEYS_GUID",                                                { 0xfbf95065, 0x427f, 0x47b3, { 0x80, 0x77, 0xd1, 0x3c, 0x60, 0x71, 0x09, 0x98 } } },
    { L"SETPLATFORMKEYS_GUID",                                                { 0x9d7a05e9, 0xf740, 0x44c3, { 0x85, 0x8b, 0x75, 0x58, 0x6a, 0x8f, 0x9c, 0x8e } } },
    { L"Dpc_ffs_GUID",                                                        { 0x399cf3a7, 0x82c7, 0x4d9b, { 0x91, 0x23, 0xdb, 0x11, 0x84, 0x29, 0x86, 0xd3 } } },
    { L"UefiPxeBc_ffs_GUID",                                                  { 0x0ef8a3b1, 0x388a, 0x4b62, { 0x8b, 0xe6, 0xc7, 0x87, 0x7d, 0x50, 0xae, 0xdf } } },
    { L"Arp_ffs_GUID",                                                        { 0x8dd91798, 0xee87, 0x4f0e, { 0x8a, 0x84, 0x3f, 0x99, 0x83, 0x11, 0xf9, 0x30 } } },
    { L"Mnp_ffs_GUID",                                                        { 0xc30b94e3, 0xc8f2, 0x4ab0, { 0x91, 0xab, 0xfa, 0x8d, 0xf6, 0x21, 0xb1, 0xc9 } } },
    { L"NetworkStackSetupScreenBin_GUID",                                     { 0x0029de6a, 0xe024, 0x4eb8, { 0xa9, 0x1d, 0x9f, 0x23, 0xaa, 0x1f, 0x4e, 0x92 } } },
    { L"Snp_ffs_GUID",                                                        { 0x3dd7a87b, 0xd5bd, 0x44af, { 0x98, 0x6f, 0x2e, 0x13, 0xdb, 0x5d, 0x27, 0x4c } } },
    { L"IpSec_ffs_GUID",                                                      { 0xfcf94301, 0x9763, 0x4a64, { 0xaa, 0x84, 0x78, 0x92, 0xc4, 0x71, 0x23, 0x67 } } },
    { L"Tcp_ffs_GUID",                                                        { 0xb1625d3c, 0x9d2d, 0x4e0d, { 0xb8, 0x64, 0x8a, 0x76, 0x3e, 0xe4, 0xec, 0x50 } } },
    { L"Mtftp6_ffs_GUID",                                                     { 0x61afa251, 0x8ac8, 0x4440, { 0x9a, 0xb5, 0x76, 0x2b, 0x1b, 0xf0, 0x51, 0x56 } } },
    { L"Dhcp6_ffs_GUID",                                                      { 0x8dd9176d, 0xee87, 0x4f0e, { 0x8a, 0x84, 0x3f, 0x99, 0x83, 0x11, 0xf9, 0x30 } } },
    { L"Ip6_ffs_GUID",                                                        { 0x8f92960e, 0x2880, 0x4659, { 0xb8, 0x57, 0x91, 0x5a, 0x89, 0x01, 0xbd, 0xc8 } } },
    { L"Udp6_ffs_GUID",                                                       { 0x10ee54ae, 0xb207, 0x4a4f, { 0xab, 0xd8, 0xcb, 0x52, 0x2e, 0xca, 0xa3, 0xa4 } } },
    { L"Ip4_ffs_GUID",                                                        { 0x8f92960f, 0x2880, 0x4659, { 0xb8, 0x57, 0x91, 0x5a, 0x89, 0x01, 0xbd, 0xc8 } } },
    { L"Udp4_ffs_GUID",                                                       { 0x10ee5462, 0xb207, 0x4a4f, { 0xab, 0xd8, 0xcb, 0x52, 0x2e, 0xca, 0xa3, 0xa4 } } },
    { L"Ip4Config_ffs_GUID",                                                  { 0x8f9296ef, 0x2880, 0x4659, { 0xb8, 0x57, 0x91, 0x5a, 0x89, 0x01, 0xbd, 0xc8 } } },
    { L"Mtftp4_ffs_GUID",                                                     { 0x61afa223, 0x8ac8, 0x4440, { 0x9a, 0xb5, 0x76, 0x2b, 0x1b, 0xf0, 0x51, 0x56 } } },
    { L"Dhcp4_ffs_GUID",                                                      { 0x8dd9176e, 0xee87, 0x4f0e, { 0x8a, 0x84, 0x3f, 0x99, 0x83, 0x11, 0xf9, 0x30 } } },
    { L"TxtOneTouchDxeBin_GUID",                                              { 0x67791e00, 0x0c05, 0x4ae7, { 0xa9, 0x21, 0xfc, 0x40, 0x57, 0x22, 0x16, 0x53 } } },
    { L"SmmDispBin_GUID",                                                     { 0x9cc55d7d, 0xfbff, 0x431c, { 0xbc, 0x14, 0x33, 0x4e, 0xae, 0xa6, 0x05, 0x2b } } },
    { L"SmmBasePeimBin_GUID",                                                 { 0x8b8214f9, 0x4adb, 0x47dd, { 0xac, 0x62, 0x83, 0x13, 0xc5, 0x37, 0xe9, 0xfa } } },
    { L"SmmBaseRuntimeBin_GUID",                                              { 0x5552575a, 0x7e00, 0x4d61, { 0xa3, 0xa4, 0xf7, 0x54, 0x73, 0x51, 0xb4, 0x9e } } },
    { L"SmmThunkBin_GUID",                                                    { 0x8d3be215, 0xd6f6, 0x4264, { 0xbe, 0xa6, 0x28, 0x07, 0x3f, 0xb1, 0x3a, 0xea } } },
    { L"SmmRelocDxeBin_GUID",                                                 { 0x7fed72ee, 0x0170, 0x4814, { 0x98, 0x78, 0xa8, 0xfb, 0x18, 0x64, 0xdf, 0xaf } } },
    { L"SmmRelocPeimBin_GUID",                                                { 0xabb74f50, 0xfd2d, 0x4072, { 0xa3, 0x21, 0xca, 0xfc, 0x72, 0x97, 0x7e, 0xfa } } },
    { L"CpuPolicyInitDxeBin_GUID",                                            { 0x15b9b6da, 0x00a9, 0x4de7, { 0xb8, 0xe8, 0xed, 0x7a, 0xfb, 0x88, 0xf1, 0x6e } } },
    { L"CpuPolicyPeiBin_GUID",                                                { 0x0ac2d35d, 0x1c77, 0x1033, { 0xa6, 0xf8, 0x7c, 0xa5, 0x5d, 0xf7, 0xd0, 0xaa } } },
    { L"CpuS3PeimBin_GUID",                                                   { 0xc866bd71, 0x7c79, 0x4bf1, { 0xa9, 0x3b, 0x06, 0x6b, 0x83, 0x0d, 0x8f, 0x9a } } },
    { L"CpuInitDxeBin_GUID",                                                  { 0x62d171cb, 0x78cd, 0x4480, { 0x86, 0x78, 0xc6, 0xa2, 0xa7, 0x97, 0xa8, 0xde } } },
    { L"CpuInitPeiBin_GUID",                                                  { 0x01359d99, 0x9446, 0x456d, { 0xad, 0xa4, 0x50, 0xa7, 0x11, 0xc0, 0x3a, 0xda } } },
    { L"SmmAccessPeimBin_GUID",                                               { 0x6ecfce51, 0x5724, 0x450c, { 0xa3, 0x8a, 0x58, 0x55, 0x3e, 0x95, 0x44, 0x22 } } },
    { L"BdatAccessHandlerBin_GUID",                                           { 0x6db9486f, 0x6af6, 0x4090, { 0x98, 0x4d, 0x23, 0x84, 0x82, 0xce, 0x3e, 0xa4 } } },
    { L"SaLateInitSmmBin_GUID",                                               { 0x2d1e361c, 0x7b3f, 0x4d15, { 0x8b, 0x1f, 0x66, 0xe5, 0x51, 0xfa, 0xbd, 0xc7 } } },
    { L"PchResetPeimBin_GUID",                                                { 0xff259f16, 0x18d1, 0x4298, { 0x8d, 0xd2, 0xbd, 0x87, 0xff, 0x28, 0x94, 0xa9 } } },
    { L"Mebx_ffs_GUID",                                                       { 0x9cfd802c, 0x09a1, 0x43d6, { 0x82, 0x17, 0xaa, 0x49, 0xc1, 0xf9, 0x0d, 0x2c } } },
    { L"MebxSetupBrowser_ffs_GUID",                                           { 0xb62efbbb, 0x3923, 0x4cb9, { 0xa6, 0xe8, 0xdb, 0x81, 0x8e, 0x82, 0x8a, 0x80 } } },
    { L"HeciPeiBin_GUID",                                                     { 0x9cf30325, 0xdc5c, 0x4556, { 0xa8, 0xb0, 0x74, 0x21, 0x5c, 0x5f, 0x7f, 0xc4 } } },
    { L"MdesStatusCodeDrvBin_GUID",                                           { 0xdf5cd25a, 0x8e55, 0x46ba, { 0x8c, 0xda, 0xbc, 0x7d, 0xb7, 0xbf, 0x9c, 0x64 } } },
    { L"PlatformResetBin_GUID",                                               { 0x9a9a912b, 0x5f53, 0x4586, { 0x88, 0x20, 0x70, 0x44, 0x85, 0xa2, 0x9d, 0x21 } } },
    { L"iFfsDxe_Bin_GUID",                                                    { 0xb6b9295f, 0xcabf, 0x4cec, { 0xbb, 0x14, 0xfe, 0x42, 0x46, 0xf2, 0x17, 0x3a } } },
    { L"IffsSmmBin_GUID",                                                     { 0x43172851, 0xcf7e, 0x4345, { 0x9f, 0xe0, 0xd7, 0x01, 0x2b, 0xb1, 0x7b, 0x88 } } },
    { L"iFfsPeiBin_GUID",                                                     { 0x53f019e9, 0xbb0c, 0x424b, { 0x87, 0x0a, 0x1f, 0xaf, 0x10, 0xb1, 0xcb, 0x4c } } },
    { L"FirmwarePerformanceTableBin_GUID",                                    { 0xaec4159d, 0xf2fc, 0x4090, { 0x95, 0xce, 0x38, 0x31, 0x7a, 0x8e, 0xd6, 0x4c } } },
    { L"PB_DTSBin_GUID",                                                      { 0x20cbbcc9, 0x5a4d, 0x40ed, { 0xb1, 0xe0, 0x80, 0x42, 0x3a, 0xb1, 0x55, 0x4f } } },
    { L"CLKGENPEIBin_GUID",                                                   { 0x64fa16c2, 0x5deb, 0x4254, { 0xa7, 0x9e, 0x25, 0xb7, 0x85, 0x18, 0x2a, 0x02 } } },
    { L"CLKGENDXEBin_GUID",                                                   { 0x5640497f, 0x645e, 0x4611, { 0xb9, 0x15, 0xe6, 0x82, 0xc8, 0xbd, 0x47, 0x83 } } },
    { L"ASM106XPEIBin_GUID",                                                  { 0xb8cacf99, 0x5c9d, 0x445b, { 0xb6, 0xac, 0x6e, 0xf3, 0x0f, 0xc8, 0x27, 0x50 } } },
    { L"ASM106XDXEBin_GUID",                                                  { 0xf3872f18, 0x7879, 0x49aa, { 0xac, 0x8e, 0x8d, 0xf3, 0x31, 0x27, 0xa1, 0xa3 } } },
    { L"SaveConfigMemDataBin_GUID",                                           { 0x1faaa415, 0xf8a9, 0x4a33, { 0xb4, 0x34, 0xa7, 0x81, 0x1f, 0xbe, 0xc1, 0x45 } } },
    { L"PciHostBridgeWrapBin_GUID",                                           { 0x1323c999, 0xdad5, 0x5432, { 0xa5, 0x4b, 0x7a, 0x05, 0xfb, 0xf4, 0x15, 0x15 } } },
    { L"RCSMIWrapBin_GUID",                                                   { 0xaa5c4b18, 0x0e65, 0x4969, { 0xa0, 0xae, 0xf3, 0xd3, 0xda, 0x25, 0x1b, 0xa8 } } },
    { L"SBIDEBin_GUID",                                                       { 0x0f39fa36, 0x072f, 0x4ba3, { 0x9e, 0xab, 0x3e, 0x4f, 0x28, 0xfd, 0x18, 0xfc } } },
    { L"SBIDEBin_GUID",                                                       { 0xed32f7e0, 0x5f9a, 0x499d, { 0xbd, 0xba, 0xb1, 0xeb, 0x58, 0xd5, 0xb0, 0xeb } } },
    { L"SmmCommunicateBin_GUID",                                              { 0x7e2d983f, 0xf703, 0x4a29, { 0x97, 0x61, 0x77, 0xb5, 0x1f, 0x53, 0x54, 0xed } } },
    { L"DigitalThermalSensorSmmBin_GUID",                                     { 0x76b048da, 0x15ea, 0x420f, { 0x9d, 0x97, 0x8e, 0x63, 0x24, 0x7d, 0x2b, 0x3c } } },
    { L"SataControllerBin_GUID",                                              { 0x4c5c6a74, 0xbab7, 0x46d6, { 0x86, 0x88, 0x3b, 0x2e, 0x7f, 0x24, 0x6e, 0x3f } } },
    { L"SmmControlBin_GUID",                                                  { 0x1a2b4139, 0x0da4, 0x416c, { 0xad, 0xe3, 0x85, 0x87, 0x7b, 0x31, 0x82, 0x66 } } },
    { L"IchInitDxeBin_GUID",                                                  { 0x5f4735f7, 0xdcf9, 0x40fd, { 0x88, 0x58, 0x02, 0x6f, 0x93, 0x19, 0x42, 0xa9 } } },
    { L"IntelIchResetBin_GUID",                                               { 0xe424c009, 0xcd92, 0x4fec, { 0x80, 0x29, 0xd7, 0x9d, 0x3f, 0x1c, 0xf3, 0xde } } },
    { L"IoTrapBin_GUID",                                                      { 0x0dba19da, 0x5197, 0x4e71, { 0xa6, 0x2f, 0x4f, 0x8c, 0xb3, 0xcd, 0xb5, 0x5f } } },
    { L"IchTptSmmDispatcherBin_GUID",                                         { 0x35c5ab3e, 0xb77a, 0x450c, { 0x88, 0x54, 0x15, 0x9b, 0x2f, 0x0d, 0x32, 0xa6 } } },
    { L"IntelIchLegacyInterruptBin_GUID",                                     { 0xd3709bb4, 0xb194, 0x4b71, { 0xb9, 0xc0, 0xdb, 0xd8, 0xd2, 0xda, 0x97, 0xad } } },
    { L"ActiveBiosBin_GUID",                                                  { 0x67ac0b1e, 0x54c2, 0x41a6, { 0xb5, 0x7e, 0xc2, 0xa3, 0x21, 0x41, 0x6a, 0xbc } } },
    { L"PciExpressBin_GUID",                                                  { 0xa19fb0ee, 0x05f4, 0x4cd6, { 0x8f, 0x28, 0x59, 0xb7, 0x82, 0xff, 0x95, 0xc6 } } },
    { L"SmmAccessBin_GUID",                                                   { 0x326e9cc6, 0x9839, 0x4885, { 0xb2, 0xed, 0x27, 0x59, 0x03, 0xb6, 0x68, 0xe1 } } },
    { L"MemoryInitBin_GUID",                                                  { 0xd4ee25ea, 0x0b48, 0x43ae, { 0xa0, 0x16, 0x4d, 0x6e, 0x8b, 0x6c, 0x43, 0xb3 } } },
    { L"PciHostBridgeBin_GUID",                                               { 0x9fd2360e, 0x6b48, 0x11d5, { 0x8e, 0x71, 0x00, 0x90, 0x27, 0x07, 0xb3, 0x5e } } },
    { L"PowerManagement2Bin_GUID",                                            { 0xf7731b4c, 0x58a2, 0x4df4, { 0x89, 0x80, 0x56, 0x45, 0xd3, 0x9e, 0xce, 0x58 } } },
    { L"PowerManagementAcpiTables2_ffs_GUID",                                 { 0x161be597, 0xe9c5, 0x49db, { 0xae, 0x50, 0xc4, 0x62, 0xab, 0x54, 0xee, 0xda } } },
    { L"PlatformInfoPeiBin_GUID",                                             { 0x3870ef56, 0xe2d1, 0x43d4, { 0xab, 0x71, 0xdf, 0x30, 0xf7, 0xda, 0x65, 0x24 } } },
    { L"DockSmmBin_GUID",                                                     { 0x854fb23e, 0xea74, 0x42bb, { 0xae, 0x7f, 0x13, 0x66, 0x4b, 0x03, 0xae, 0x4c } } },
    { L"ZERO_GUID",                                                           { 0x00000000, 0x0000, 0x0000, { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 } } },
};

#endif
