/*
 * Copyright (c) 2022 Winsider Seminars & Solutions, Inc.  All rights reserved.
 *
 * This file is part of System Informer.
 *
 * Authors:
 *
 *     jxy-s   2025
 *
 */

#ifndef _PH_PHSMBIOS_H
#define _PH_PHSMBIOS_H

#include <smbios.h>

EXTERN_C_START

typedef union _PH_SMBIOS_ENTRY
{
    SMBIOS_HEADER Header;
    SMBIOS_FIRMWARE_INFORMATION Firmware;
    SMBIOS_SYSTEM_INFORMATION System;
    SMBIOS_BASEBOARD_INFORMATION Baseboard;
    SMBIOS_CHASSIS_INFORMATION Chassis;
    SMBIOS_PROCESSOR_INFORMATION Processor;
    SMBIOS_MEMORY_CONTROLLER_INFORMATION MemoryController;
    SMBIOS_MEMORY_MODULE_INFORMATION MemoryModule;
    SMBIOS_CACHE_INFORMATION Cache;
    SMBIOS_PORT_CONNECTOR_INFORMATION PortConnector;
    SMBIOS_SYSTEM_SLOT_INFORMATION SystemSlot;
    SMBIOS_ON_BOARD_DEVICE_INFORMATION OnBoardDevice;
    SMBIOS_OEM_STRING_INFORMATION OEMString;
    SMBIOS_FIRMWARE_LANGUAGE_INFORMATION FirmwareLanguage;
    SMBIOS_GROUP_ASSOCIATION_INFORMATION GroupAssociation;
    SMBIOS_SYSTEM_EVENT_LOG_INFORMATION EventLog;
    SMBIOS_PHYSICAL_MEMORY_ARRAY_INFORMATION PhysicalMemoryArray;
    SMBIOS_MEMORY_DEVICE_INFORMATION MemoryDevice;
    SMBIOS_32_BIT_MEMORY_ERROR_INFORMATION MemoryError32;
    SMBIOS_MEMORY_ARRAY_MAPPED_ADDRESS_INFORMATION MemoryArrayMappedAddress;
    SMBIOS_MEMORY_DEVICE_MAPPED_DATA_INFORMATION MemoryDeviceMappedData;
    SMBIOS_BUILT_IN_POINTING_DEVICE_INFORMATION BuiltInPointingDevice;
    SMBIOS_PORTABLE_BATTERY_INFORMATION PortableBattery;
    SMBIOS_SYSTEM_RESET_INFORMATION SystemReset;
    SMBIOS_HARDWARE_SECURITY_INFORMATION HardwareSecurity;
    SMBIOS_SYSTEM_POWER_CONTROLS_INFORMATION SystemPowerControls;
    SMBIOS_VOLTAGE_PROBE_INFORMATION VoltageProbe;
    SMBIOS_COOLING_DEVICE_INFORMATION CoolingDevice;
    SMBIOS_TEMPERATURE_PROBE_INFORMATION TemperatureProbe;
    SMBIOS_ELECTRICAL_CURRENT_PROBE_INFORMATION ElectricalCurrentProbe;
    SMBIOS_OUT_OF_BAND_REMOTE_ACCESS_INFORMATION OutOfBandRemoteAccess;
    SMBIOS_SYSTEM_BOOT_INFORMATION SystemBoot;
    SMBIOS_64_BIT_MEMORY_ERROR_INFORMATION MemoryError64;
    SMBIOS_MANAGEMENT_DEVICE_INFORMATION ManagementDevice;
    SMBIOS_MANAGEMENT_DEVICE_COMPONENT_INFORMATION ManagementDeviceComponent;
    SMBIOS_MANAGEMENT_DEVICE_THRESHOLD_INFORMATION ManagementDeviceThreshold;
    SMBIOS_MEMORY_CHANNEL_INFORMATION MemoryChannel;
    SMBIOS_IPMI_DEVICE_INFORMATION IPMIDevice;
    SMBIOS_SYSTEM_POWER_SUPPLY_INFORMATION SystemPowerSupply;
    SMBIOS_ADDITIONAL_INFORMATION AdditionalInformation;
    SMBIOS_ONBOARD_DEVICE_INFORMATION OnboardDevice;
    SMBIOS_MCHI_INFORMATION MCHInterface;
    SMBIOS_TPM_DEVICE_INFORMATION TPMDevice;
    SMBIOS_PROCESSOR_ADDITIONAL_INFORMATION ProcessorAdditional;
    SMBIOS_FIRMWARE_INVENTORY_INFORMATION FirmwareInventory;
    SMBIOS_STRING_PROPERTY StringProperty;
    SMBIOS_INACTIVE Inactive;
    SMBIOS_END_OF_TABLE EndOfTable;
} PH_SMBIOS_ENTRY, *PPH_SMBIOS_ENTRY;

typedef
_Function_class_(PH_ENUM_SMBIOS_CALLBACK)
BOOLEAN
NTAPI
PH_ENUM_SMBIOS_CALLBACK(
    _In_ ULONG_PTR EnumHandle,
    _In_ UCHAR MajorVersion,
    _In_ UCHAR MinorVersion,
    _In_ PPH_SMBIOS_ENTRY Entry,
    _In_opt_ PVOID Context
    );
typedef PH_ENUM_SMBIOS_CALLBACK* PPH_ENUM_SMBIOS_CALLBACK;

PHLIBAPI
NTSTATUS
NTAPI
PhEnumSMBIOS(
    _In_ PPH_ENUM_SMBIOS_CALLBACK Callback,
    _In_opt_ PVOID Context
    );

PHLIBAPI
NTSTATUS
NTAPI
PhGetSMBIOSString(
    _In_ ULONG_PTR EnumHandle,
    _In_ UCHAR Index,
    _Out_ PPH_STRING* String
    );

EXTERN_C_END

#endif
