<p align="center">
  <img alt="Github Checks" src="https://badgen.net/github/checks/willnguyen1312/zoom-image/main"/>
  <img alt="Github Stars" src="https://badgen.net/github/stars/willnguyen1312/zoom-image" />
</p>

<br />

- [Zoom Image](#zoom-image)
- [Development](#development)
- [Commands](#commands)
  - [With Docs](#with-docs)
  - [With Preact](#with-preact)
  - [With React](#with-react)
  - [With Remix](#with-remix)
  - [With Next](#with-next)
  - [With Svelte](#with-svelte)
  - [With Vanilla JS](#with-vanilla-js)
  - [With Vue](#with-vue)
  - [With Solid](#with-solid)
  - [With Qwik](#with-qwik)
- [Relevant projects](#relevant-projects)
- [Sponsor](#sponsor)
- [License](#license)

## Zoom Image

A little yet powerful framework agnostic headless library to zoom images on the web. It is a typical experience on
e-commerce sites. Examples are written with Preact, React, Svelte, Vanilla JS and Vue.

- ✅ Zoom on wheel (scroll & pinch)
- ✅ Zoom on hover
- ✅ Zoom on move
- ✅ Zoom on click

## Development

```bash
git clone https://github.com/willnguyen1312/zoom-image
cd zoom-image
pnpm install
pnpm build
```

## Commands

Please change all versions from "latest" to "workspace:\*" inside the example project you want to start, run pnpm
install before executing one of the commands below. I wanted to keep those packages for Stackblitz usage so I use
"latest", unfortunately pnpm doesn't understand it during local development 🙈

### With Docs

```bash
pnpm start-docs
```

### With Preact

```bash
pnpm start-preact
```

### With React

```bash
pnpm start-react
```

### With Remix

```bash
pnpm start-remix
```

### With Next

```bash
pnpm start-next
```

### With Svelte

```bash
pnpm start-svelte
```

### With Vanilla JS

```bash
pnpm start-vanilla
```

### With Vue

```bash
pnpm start-vue
```

### With Solid

```bash
pnpm start-solid
```

### With Qwik

```bash
pnpm start-qwik
```

## Relevant projects

- [react-zoomable-media](https://github.com/willnguyen1312/react-zoomable-media) - The library I wrote for my previous
  company
- [zagjs](https://github.com/chakra-ui/zag) - The project's architecture is inspired by this library
- [TanStack](https://tanstack.com) - The project's core headless pattern is heavily inspired by this project - Headless
  UI
- [js-image-zoom](https://github.com/malaman/js-image-zoom) - The internal working of zoom image on hover is inspired by
  this library

## Sponsor

<a href="https://www.buymeacoffee.com/namnguyenle" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/v2/default-yellow.png" alt="Buy Me A Coffee" style="height: 60px !important;width: 217px !important;" ></a>

## License

MIT © [Nam Nguyen](https://github.com/willnguyen1312)
