import pytest

import flirt

from fixtures import __EH_prolog3_sig
from fixtures import __EH_prolog3_pat
from fixtures import __EH_prolog3_catch_align


def test_parse_pat(__EH_prolog3_pat):
    sigs = flirt.parse_pat(__EH_prolog3_pat)
    matcher = flirt.compile(sigs)

    matches = matcher.match(__EH_prolog3_catch_align)
    assert len(matches) == 1

    match = matches[0]
    assert match.names[0] == ("__EH_prolog3_catch_align", "public", 0)
    assert str(match) == 'FlirtSignature("__EH_prolog3_catch_align")'


def test_parse_sig(__EH_prolog3_sig):
    sigs = flirt.parse_sig(__EH_prolog3_sig)
    matcher = flirt.compile(sigs)

    matches = matcher.match(__EH_prolog3_catch_align)
    assert len(matches) == 1

    match = matches[0]
    assert match.names[0] == ("__EH_prolog3_catch_align", "public", 0)
    assert str(match) == 'FlirtSignature("__EH_prolog3_catch_align")'


def test_too_much_data():
    buf = bytes([0xff,0x35,0xa0,0x22,0x41,0x00,0xff,0x74,0x24,0x08,0xe8,0x03,0x00,0x00,0x00,0x59,0x59,0xc3,0x83,0x7c,0x24,0x04,0xe0,0x77,0x22,0xff,0x74,0x24,0x04,0xe8,0x1c,0x00,0x00,0x00,0x85,0xc0,0x59,0x75,0x16,0x39,0x44,0x24,0x08,0x74,0x10,0xff,0x74,0x24,0x04,0xe8,0x7d,0x2e,0x00,0x00,0x85,0xc0,0x59,0x75,0xde,0x33,0xc0,0xc3,0x55,0x8b,0xec,0x6a,0xff,0x68,0x88,0xd1,0x40,0x00,0x68,0x84,0x68,0x40,0x00,0x64,0xa1,0x00,0x00,0x00,0x00,0x50,0x64,0x89,0x25,0x00,0x00,0x00,0x00,0x83,0xec,0x0c,0x53,0x56,0x57,0xa1,0xa4,0x36,0x41,0x00,0x83,0xf8,0x03,0x75,0x43,0x8b,0x75,0x08,0x3b,0x35,0x9c,0x36,0x41,0x00,0x0f,0x87,0x93,0x00,0x00,0x00,0x6a,0x09,0xe8,0xbc,0x2d,0x00,0x00,0x59,0x83,0x65,0xfc,0x00,0x56,0xe8,0x10,0x1f,0x00,0x00,0x59,0x89,0x45,0xe4,0x83,0x4d,0xfc,0xff,0xe8,0x0c,0x00,0x00,0x00,0x8b,0x45,0xe4,0x85,0xc0,0x74,0x6d,0xe9,0x86,0x00,0x00,0x00,0x6a,0x09,0xe8,0xf2,0x2d,0x00,0x00,0x59,0xc3,0x83,0xf8,0x02,0x75,0x5a,0x8b,0x45,0x08,0x85,0xc0,0x74,0x08,0x8d,0x70,0x0f,0x83,0xe6,0xf0,0xeb,0x03,0x6a,0x10,0x5e,0x89,0x75,0x08,0x3b,0x35,0xfc,0x14,0x41,0x00,0x77,0x2e,0x6a,0x09,0xe8,0x66,0x2d,0x00,0x00,0x59,0xc7,0x45,0xfc,0x01,0x00,0x00,0x00,0x8b,0xc6,0xc1,0xe8,0x04,0x50,0xe8,0x55,0x29,0x00,0x00,0x59,0x89,0x45,0xe4,0x83,0x4d,0xfc,0xff,0xe8,0x0d,0x00,0x00,0x00,0x8b,0x45,0xe4,0x85,0xc0,0x75,0x2d,0x56,0xeb])
    pat = "ff35........ff742408e8........5959c3 00 0000 0012 :0000 _malloc\n---";
    sigs = flirt.parse_pat(pat)
    matcher = flirt.compile(sigs)
    matches = matcher.match(buf)
    assert len(matches) == 1

    match = matches[0]
    assert match.names[0] == ("_malloc", "public", 0)

