import os.path

import pytest

CD = os.path.dirname(__file__)


@pytest.fixture
def __EH_prolog3_pat():
    with open(os.path.join(CD, "data", "__EH_prolog3.pat"), "rb") as f:
        return f.read().decode("utf-8")


@pytest.fixture
def __EH_prolog3_sig():
    # sigmake ./data/__EH_prolog3.pat ./data/__EH_prolog3.sig
    #
    # ```
    # 518b4c240c895c240c8d5c240c508d442408f7d923c18d60f88b43f08904248b 22 e4ce 006f :0000 __EH_prolog3_catch_GS_align
    # 518b4c240c895c240c8d5c240c508d442408f7d923c18d60f88b43f08904248b 21 b4fe 006e :0000 __EH_prolog3_GS_align
    # 518b4c240c895c240c8d5c240c508d442408f7d923c18d60f88b43f08904248b 20 6562 0067 :0000 __EH_prolog3_catch_align
    # 518b4c240c895c240c8d5c240c508d442408f7d923c18d60f88b43f08904248b 1f e4cf 0063 :0000 __EH_prolog3_align
    # ```
    with open(os.path.join(CD, "data", "__EH_prolog3.sig"), "rb") as f:
        return f.read()


__EH_prolog3_catch_align = bytes([
    # utcutil.dll
    #  MD5 abc9ea116498feb8f1de45f60d595af6
    #  SHA-1 2f1ba350237b74c454caf816b7410490f5994c59
    #  SHA-256 7607897638e9dae406f0840dbae68e879c3bb2f08da350c6734e4e2ef8d61ac2 
    # __EH_prolog3_catch_align
    
    # first 0x20
    0x51,0x8b,0x4c,0x24,0x0c,0x89,0x5c,0x24,0x0c,0x8d,0x5c,0x24,0x0c,0x50,0x8d,0x44,
    0x24,0x08,0xf7,0xd9,0x23,0xc1,0x8d,0x60,0xf8,0x8b,0x43,0xf0,0x89,0x04,0x24,0x8b,
    # crc16 start
    0x43,0xf8,0x50,0x8b,0x43,0xfc,0x8b,0x4b,0xf4,0x89,0x6c,0x24,0x0c,0x8d,0x6c,0x24,
    0x0c,0xc7,0x44,0x24,0x08,0xff,0xff,0xff,0xff,0x51,0x53,0x2b,0xe0,0x56,0x57,0xa1,
    # footer start
    0x70,0x14,0x01,0x10,0x33,0xc5,0x50,0x89,0x65,0xf0,0x8b,0x43,0x04,0x89,0x45,0x04,
    0xff,0x75,0xf4,0x64,0xa1,0x00,0x00,0x00,0x00,0x89,0x45,0xf4,0x8d,0x45,0xf4,0x64,
    0xa3,0x00,0x00,0x00,0x00,0xf2,0xc3
])