// This file is @generated by prost-build
// using a line like:
//
//     prost_build::compile_protos(
//       &["src/workspace/export/binexport2.proto"],
//       &["src/"]
//     )?;
//
// in core/build.rs, and vendored into the source tree here.
// The build script was subsequently removed.
//
// This avoids requiring protoc to be available in the build environment,
// which is tricky when cross compiling.
// see: https://github.com/williballenthin/lancelot/blob/dc2293d77f3e26f456f7c058136966b6d7dc8845/core/build.rs#L4
//
// In October, 2024, I had tried to use protobuf-src to provide protoc to
// prost-build, but this was
//   1) very hard to get working across all platforms in GH Actions, and
//   2) took a long time to compile (like 4+ minutes).
// Vendoring is simpler, though it will require some maintenance
// if we ever update the proto.
//
// Don't update this file directly.
// Update the proto and then re-generate this file.

#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BinExport2 {
    #[prost(message, optional, tag = "1")]
    pub meta_information:        ::core::option::Option<bin_export2::Meta>,
    #[prost(message, repeated, tag = "2")]
    pub expression:              ::prost::alloc::vec::Vec<bin_export2::Expression>,
    #[prost(message, repeated, tag = "3")]
    pub operand:                 ::prost::alloc::vec::Vec<bin_export2::Operand>,
    #[prost(message, repeated, tag = "4")]
    pub mnemonic:                ::prost::alloc::vec::Vec<bin_export2::Mnemonic>,
    #[prost(message, repeated, tag = "5")]
    pub instruction:             ::prost::alloc::vec::Vec<bin_export2::Instruction>,
    #[prost(message, repeated, tag = "6")]
    pub basic_block:             ::prost::alloc::vec::Vec<bin_export2::BasicBlock>,
    #[prost(message, repeated, tag = "7")]
    pub flow_graph:              ::prost::alloc::vec::Vec<bin_export2::FlowGraph>,
    #[prost(message, optional, tag = "8")]
    pub call_graph:              ::core::option::Option<bin_export2::CallGraph>,
    #[prost(string, repeated, tag = "9")]
    pub string_table:            ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// No longer written. This is here so that BinDiff can work with older
    /// BinExport files.
    #[deprecated]
    #[prost(message, repeated, tag = "10")]
    pub address_comment:         ::prost::alloc::vec::Vec<bin_export2::Reference>,
    /// Rich comment index used for BinDiff's comment porting.
    #[prost(message, repeated, tag = "17")]
    pub comment:                 ::prost::alloc::vec::Vec<bin_export2::Comment>,
    #[prost(message, repeated, tag = "11")]
    pub string_reference:        ::prost::alloc::vec::Vec<bin_export2::Reference>,
    #[prost(message, repeated, tag = "12")]
    pub expression_substitution: ::prost::alloc::vec::Vec<bin_export2::Reference>,
    #[prost(message, repeated, tag = "13")]
    pub section:                 ::prost::alloc::vec::Vec<bin_export2::Section>,
    #[prost(message, repeated, tag = "14")]
    pub library:                 ::prost::alloc::vec::Vec<bin_export2::Library>,
    #[prost(message, repeated, tag = "15")]
    pub data_reference:          ::prost::alloc::vec::Vec<bin_export2::DataReference>,
    #[prost(message, repeated, tag = "16")]
    pub module:                  ::prost::alloc::vec::Vec<bin_export2::Module>,
}
/// Nested message and enum types in `BinExport2`.
pub mod bin_export2 {
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Meta {
        /// Input binary filename including file extension but excluding file
        /// path. example: "insider_gcc.exe"
        #[prost(string, optional, tag = "1")]
        pub executable_name:   ::core::option::Option<::prost::alloc::string::String>,
        /// Application defined executable id. Often the SHA256 hash of the
        /// input binary.
        #[prost(string, optional, tag = "2")]
        pub executable_id:     ::core::option::Option<::prost::alloc::string::String>,
        /// Input architecture name, e.g. x86-32.
        #[prost(string, optional, tag = "3")]
        pub architecture_name: ::core::option::Option<::prost::alloc::string::String>,
        /// When did this file get created? Unix time. This may be used for some
        /// primitive versioning in case the file format ever changes.
        #[prost(int64, optional, tag = "4")]
        pub timestamp:         ::core::option::Option<i64>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct CallGraph {
        /// vertices == functions in the call graph.
        /// Important: Most downstream tooling (notably BinDiff), need these to
        /// be             sorted by `Vertex::address` (ascending). For
        /// C++, the             `BinExport2Writer` class enforces this
        /// invariant.
        #[prost(message, repeated, tag = "1")]
        pub vertex: ::prost::alloc::vec::Vec<call_graph::Vertex>,
        /// edges == calls in the call graph.
        #[prost(message, repeated, tag = "2")]
        pub edge:   ::prost::alloc::vec::Vec<call_graph::Edge>,
    }
    /// Nested message and enum types in `CallGraph`.
    pub mod call_graph {
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct Vertex {
            /// The function's entry point address. Messages need to be sorted,
            /// see comment below on `vertex`.
            #[prost(uint64, optional, tag = "1")]
            pub address:        ::core::option::Option<u64>,
            #[prost(enumeration = "vertex::Type", optional, tag = "2", default = "Normal")]
            pub r#type:         ::core::option::Option<i32>,
            /// If the function has a user defined, real name it will be given
            /// here. main() is a proper name, sub_BAADF00D is not
            /// (auto generated dummy name).
            #[prost(string, optional, tag = "3")]
            pub mangled_name:   ::core::option::Option<::prost::alloc::string::String>,
            /// Demangled name if the function is a mangled C++ function and we
            /// could demangle it.
            #[prost(string, optional, tag = "4")]
            pub demangled_name: ::core::option::Option<::prost::alloc::string::String>,
            /// If this is a library function, what is its index in library
            /// arrays.
            #[prost(int32, optional, tag = "5")]
            pub library_index:  ::core::option::Option<i32>,
            /// If module name, such as class name for DEX files, is present -
            /// index in module table.
            #[prost(int32, optional, tag = "6")]
            pub module_index:   ::core::option::Option<i32>,
        }
        /// Nested message and enum types in `Vertex`.
        pub mod vertex {
            #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
            #[repr(i32)]
            pub enum Type {
                /// Regular function with full disassembly.
                Normal   = 0,
                /// This function is a well known library function.
                Library  = 1,
                /// Imported from a dynamic link library (e.g. dll).
                Imported = 2,
                /// A thunk function, forwarding its work via an unconditional
                /// jump.
                Thunk    = 3,
                /// An invalid function (a function that contained invalid code
                /// or was considered invalid by some
                /// heuristics).
                Invalid  = 4,
            }
            impl Type {
                /// String value of the enum field names used in the ProtoBuf
                /// definition.
                ///
                /// The values are not transformed in any way and thus are
                /// considered stable (if the ProtoBuf
                /// definition does not change) and safe for programmatic use.
                pub fn as_str_name(&self) -> &'static str {
                    match self {
                        Self::Normal => "NORMAL",
                        Self::Library => "LIBRARY",
                        Self::Imported => "IMPORTED",
                        Self::Thunk => "THUNK",
                        Self::Invalid => "INVALID",
                    }
                }

                /// Creates an enum from field names used in the ProtoBuf
                /// definition.
                pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                    match value {
                        "NORMAL" => Some(Self::Normal),
                        "LIBRARY" => Some(Self::Library),
                        "IMPORTED" => Some(Self::Imported),
                        "THUNK" => Some(Self::Thunk),
                        "INVALID" => Some(Self::Invalid),
                        _ => None,
                    }
                }
            }
        }
        #[derive(Clone, Copy, PartialEq, ::prost::Message)]
        pub struct Edge {
            /// source and target index into the vertex repeated field.
            #[prost(int32, optional, tag = "1")]
            pub source_vertex_index: ::core::option::Option<i32>,
            #[prost(int32, optional, tag = "2")]
            pub target_vertex_index: ::core::option::Option<i32>,
        }
    }
    /// An operand consists of 1 or more expressions, linked together as a tree.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Expression {
        /// IMMEDIATE_INT is by far the most common type and thus we can save
        /// some space by omitting it as the default.
        #[prost(enumeration = "expression::Type", optional, tag = "1", default = "ImmediateInt")]
        pub r#type:        ::core::option::Option<i32>,
        /// Symbol for this expression. Interpretation depends on type. Examples
        /// include: "eax", "[", "+"
        #[prost(string, optional, tag = "2")]
        pub symbol:        ::core::option::Option<::prost::alloc::string::String>,
        /// If the expression can be interpreted as an integer value
        /// (IMMEDIATE_INT) the value is given here.
        #[prost(uint64, optional, tag = "3")]
        pub immediate:     ::core::option::Option<u64>,
        /// The parent expression. Example expression tree for the second
        /// operand of: mov eax, b4 \[ebx + 12\]
        /// "b4" --- "[" --- "+" --- "ebx"
        ///                        \  "12"
        #[prost(int32, optional, tag = "4")]
        pub parent_index:  ::core::option::Option<i32>,
        /// true if the expression has entry in relocation table
        #[prost(bool, optional, tag = "5")]
        pub is_relocation: ::core::option::Option<bool>,
    }
    /// Nested message and enum types in `Expression`.
    pub mod expression {
        #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
        #[repr(i32)]
        pub enum Type {
            Symbol         = 1,
            ImmediateInt   = 2,
            ImmediateFloat = 3,
            Operator       = 4,
            Register       = 5,
            SizePrefix     = 6,
            Dereference    = 7,
        }
        impl Type {
            /// String value of the enum field names used in the ProtoBuf
            /// definition.
            ///
            /// The values are not transformed in any way and thus are
            /// considered stable (if the ProtoBuf definition does
            /// not change) and safe for programmatic use.
            pub fn as_str_name(&self) -> &'static str {
                match self {
                    Self::Symbol => "SYMBOL",
                    Self::ImmediateInt => "IMMEDIATE_INT",
                    Self::ImmediateFloat => "IMMEDIATE_FLOAT",
                    Self::Operator => "OPERATOR",
                    Self::Register => "REGISTER",
                    Self::SizePrefix => "SIZE_PREFIX",
                    Self::Dereference => "DEREFERENCE",
                }
            }

            /// Creates an enum from field names used in the ProtoBuf
            /// definition.
            pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                match value {
                    "SYMBOL" => Some(Self::Symbol),
                    "IMMEDIATE_INT" => Some(Self::ImmediateInt),
                    "IMMEDIATE_FLOAT" => Some(Self::ImmediateFloat),
                    "OPERATOR" => Some(Self::Operator),
                    "REGISTER" => Some(Self::Register),
                    "SIZE_PREFIX" => Some(Self::SizePrefix),
                    "DEREFERENCE" => Some(Self::Dereference),
                    _ => None,
                }
            }
        }
    }
    /// An instruction may have 0 or more operands.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Operand {
        /// Contains all expressions constituting this operand. All expressions
        /// should be linked into a single tree, i.e. there should only be one
        /// expression in this list with parent_index == NULL and all others
        /// should descend from that. Rendering order for expressions on
        /// the same tree level (siblings) is implicitly given by the
        /// order they are referenced in this repeated field.
        /// Implicit: expression sequence
        #[prost(int32, repeated, packed = "false", tag = "1")]
        pub expression_index: ::prost::alloc::vec::Vec<i32>,
    }
    /// An instruction has exactly 1 mnemonic.
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Mnemonic {
        /// Literal representation of the mnemonic, e.g.: "mov".
        #[prost(string, optional, tag = "1")]
        pub name: ::core::option::Option<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Instruction {
        /// This will only be filled for instructions that do not just flow from
        /// the immediately preceding instruction. Regular instructions
        /// will have to calculate their own address by adding
        /// raw_bytes.size() to the previous instruction's address.
        #[prost(uint64, optional, tag = "1")]
        pub address:        ::core::option::Option<u64>,
        /// If this is a call instruction and call targets could be determined
        /// they'll be given here. Note that we may or may not have a flow graph
        /// for the target and thus cannot use an index into the flow
        /// graph table here. We could potentially use call graph nodes,
        /// but linking instructions to the call graph directly does not
        /// seem a good choice.
        #[prost(uint64, repeated, packed = "false", tag = "2")]
        pub call_target:    ::prost::alloc::vec::Vec<u64>,
        /// Index into the mnemonic array of strings. Used for de-duping the
        /// data. The default value is used for the most common mnemonic
        /// in the executable.
        #[prost(int32, optional, tag = "3", default = "0")]
        pub mnemonic_index: ::core::option::Option<i32>,
        /// Indices into the operand tree. On X86 this can be 0, 1 or 2 elements
        /// long, 3 elements with VEX/EVEX.
        /// Implicit: operand sequence
        #[prost(int32, repeated, packed = "false", tag = "4")]
        pub operand_index:  ::prost::alloc::vec::Vec<i32>,
        /// The unmodified input bytes corresponding to this instruction.
        #[prost(bytes = "vec", optional, tag = "5")]
        pub raw_bytes:      ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
        /// Implicit: comment sequence
        #[prost(int32, repeated, packed = "false", tag = "6")]
        pub comment_index:  ::prost::alloc::vec::Vec<i32>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct BasicBlock {
        /// Implicit: instruction sequence
        #[prost(message, repeated, tag = "1")]
        pub instruction_index: ::prost::alloc::vec::Vec<basic_block::IndexRange>,
    }
    /// Nested message and enum types in `BasicBlock`.
    pub mod basic_block {
        /// This is a space optimization. The instructions for an individual
        /// basic block will usually be in a continuous index range.
        /// Thus it is more efficient to store the range instead of
        /// individual indices. However, this does not hold true for all
        /// basic blocks, so we need to be able to store multiple index
        /// ranges per block.
        #[derive(Clone, Copy, PartialEq, ::prost::Message)]
        pub struct IndexRange {
            /// These work like begin and end iterators, i.e. the sequence is
            /// [begin_index, end_index). If the sequence only contains a single
            /// element end_index will be omitted.
            #[prost(int32, optional, tag = "1")]
            pub begin_index: ::core::option::Option<i32>,
            #[prost(int32, optional, tag = "2")]
            pub end_index:   ::core::option::Option<i32>,
        }
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct FlowGraph {
        /// Basic blocks are sorted by address.
        #[prost(int32, repeated, packed = "false", tag = "1")]
        pub basic_block_index:       ::prost::alloc::vec::Vec<i32>,
        /// The flow graph's entry point address is the first instruction of the
        /// entry_basic_block.
        #[prost(int32, optional, tag = "3")]
        pub entry_basic_block_index: ::core::option::Option<i32>,
        #[prost(message, repeated, tag = "2")]
        pub edge:                    ::prost::alloc::vec::Vec<flow_graph::Edge>,
    }
    /// Nested message and enum types in `FlowGraph`.
    pub mod flow_graph {
        #[derive(Clone, Copy, PartialEq, ::prost::Message)]
        pub struct Edge {
            /// Source instruction will always be the last instruction of the
            /// source basic block, target instruction the first
            /// instruction of the target basic block.
            #[prost(int32, optional, tag = "1")]
            pub source_basic_block_index: ::core::option::Option<i32>,
            #[prost(int32, optional, tag = "2")]
            pub target_basic_block_index: ::core::option::Option<i32>,
            #[prost(enumeration = "edge::Type", optional, tag = "3", default = "Unconditional")]
            pub r#type:                   ::core::option::Option<i32>,
            /// Indicates whether this is a loop edge as determined by
            /// Lengauer-Tarjan.
            #[prost(bool, optional, tag = "4", default = "false")]
            pub is_back_edge:             ::core::option::Option<bool>,
        }
        /// Nested message and enum types in `Edge`.
        pub mod edge {
            #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
            #[repr(i32)]
            pub enum Type {
                ConditionTrue  = 1,
                ConditionFalse = 2,
                Unconditional  = 3,
                Switch         = 4,
            }
            impl Type {
                /// String value of the enum field names used in the ProtoBuf
                /// definition.
                ///
                /// The values are not transformed in any way and thus are
                /// considered stable (if the ProtoBuf
                /// definition does not change) and safe for programmatic use.
                pub fn as_str_name(&self) -> &'static str {
                    match self {
                        Self::ConditionTrue => "CONDITION_TRUE",
                        Self::ConditionFalse => "CONDITION_FALSE",
                        Self::Unconditional => "UNCONDITIONAL",
                        Self::Switch => "SWITCH",
                    }
                }

                /// Creates an enum from field names used in the ProtoBuf
                /// definition.
                pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                    match value {
                        "CONDITION_TRUE" => Some(Self::ConditionTrue),
                        "CONDITION_FALSE" => Some(Self::ConditionFalse),
                        "UNCONDITIONAL" => Some(Self::Unconditional),
                        "SWITCH" => Some(Self::Switch),
                        _ => None,
                    }
                }
            }
        }
    }
    /// Generic reference class used for address comments (deprecated), string
    /// references and expression substitutions. It allows referencing from an
    /// instruction, operand, expression subtree tuple to a de-duped string in
    /// the string table.
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Reference {
        /// Index into the global instruction table.
        #[prost(int32, optional, tag = "1")]
        pub instruction_index:         ::core::option::Option<i32>,
        /// Index into the operand array local to an instruction.
        #[prost(int32, optional, tag = "2", default = "0")]
        pub instruction_operand_index: ::core::option::Option<i32>,
        /// Index into the expression array local to an operand.
        #[prost(int32, optional, tag = "3", default = "0")]
        pub operand_expression_index:  ::core::option::Option<i32>,
        /// Index into the global string table.
        #[prost(int32, optional, tag = "4")]
        pub string_table_index:        ::core::option::Option<i32>,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct DataReference {
        /// Index into the global instruction table.
        #[prost(int32, optional, tag = "1")]
        pub instruction_index: ::core::option::Option<i32>,
        /// Address being referred.
        #[prost(uint64, optional, tag = "2")]
        pub address:           ::core::option::Option<u64>,
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Comment {
        /// Index into the global instruction table. This is here to enable
        /// comment processing without having to iterate over all instructions.
        /// There is an N:M mapping of instructions to comments.
        #[prost(int32, optional, tag = "1")]
        pub instruction_index:         ::core::option::Option<i32>,
        /// Index into the operand array local to an instruction.
        #[prost(int32, optional, tag = "2", default = "0")]
        pub instruction_operand_index: ::core::option::Option<i32>,
        /// Index into the expression array local to an operand, like in
        /// Reference. This is not currently used, but allows to
        /// implement expression substitutions.
        #[prost(int32, optional, tag = "3", default = "0")]
        pub operand_expression_index:  ::core::option::Option<i32>,
        /// Index into the global string table.
        #[prost(int32, optional, tag = "4")]
        pub string_table_index:        ::core::option::Option<i32>,
        /// Comment is propagated to all locations that reference the original
        /// location.
        #[prost(bool, optional, tag = "5")]
        pub repeatable:                ::core::option::Option<bool>,
        #[prost(enumeration = "comment::Type", optional, tag = "6", default = "Default")]
        pub r#type:                    ::core::option::Option<i32>,
    }
    /// Nested message and enum types in `Comment`.
    pub mod comment {
        #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
        #[repr(i32)]
        pub enum Type {
            /// A regular instruction comment. Typically displayed next to the
            /// instruction disassembly.
            Default         = 0,
            /// A comment line that is typically displayed before (above) the
            /// instruction it refers to.
            Anterior        = 1,
            /// Like ANTERIOR, but a typically displayed after (below).
            Posterior       = 2,
            /// Similar to an ANTERIOR comment, but applies to the beginning of
            /// an identified function. Programs displaying the
            /// proto may choose to render these differently (e.g.
            /// above an inferred function signature).
            Function        = 3,
            /// Named constants, bitfields and similar.
            Enum            = 4,
            /// Named locations, usually the target of a jump.
            Location        = 5,
            /// Data cross references.
            GlobalReference = 6,
            /// Local/stack variables.
            LocalReference  = 7,
        }
        impl Type {
            /// String value of the enum field names used in the ProtoBuf
            /// definition.
            ///
            /// The values are not transformed in any way and thus are
            /// considered stable (if the ProtoBuf definition does
            /// not change) and safe for programmatic use.
            pub fn as_str_name(&self) -> &'static str {
                match self {
                    Self::Default => "DEFAULT",
                    Self::Anterior => "ANTERIOR",
                    Self::Posterior => "POSTERIOR",
                    Self::Function => "FUNCTION",
                    Self::Enum => "ENUM",
                    Self::Location => "LOCATION",
                    Self::GlobalReference => "GLOBAL_REFERENCE",
                    Self::LocalReference => "LOCAL_REFERENCE",
                }
            }

            /// Creates an enum from field names used in the ProtoBuf
            /// definition.
            pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
                match value {
                    "DEFAULT" => Some(Self::Default),
                    "ANTERIOR" => Some(Self::Anterior),
                    "POSTERIOR" => Some(Self::Posterior),
                    "FUNCTION" => Some(Self::Function),
                    "ENUM" => Some(Self::Enum),
                    "LOCATION" => Some(Self::Location),
                    "GLOBAL_REFERENCE" => Some(Self::GlobalReference),
                    "LOCAL_REFERENCE" => Some(Self::LocalReference),
                    _ => None,
                }
            }
        }
    }
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct Section {
        /// Section start address.
        #[prost(uint64, optional, tag = "1")]
        pub address: ::core::option::Option<u64>,
        /// Section size.
        #[prost(uint64, optional, tag = "2")]
        pub size:    ::core::option::Option<u64>,
        /// Read flag of the section, True when section is readable.
        #[prost(bool, optional, tag = "3")]
        pub flag_r:  ::core::option::Option<bool>,
        /// Write flag of the section, True when section is writable.
        #[prost(bool, optional, tag = "4")]
        pub flag_w:  ::core::option::Option<bool>,
        /// Execute flag of the section, True when section is executable.
        #[prost(bool, optional, tag = "5")]
        pub flag_x:  ::core::option::Option<bool>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Library {
        /// If this library is statically linked.
        #[prost(bool, optional, tag = "1")]
        pub is_static:    ::core::option::Option<bool>,
        /// Address where this library was loaded, 0 if unknown.
        #[prost(uint64, optional, tag = "2", default = "0")]
        pub load_address: ::core::option::Option<u64>,
        /// Name of the library (format is platform-dependent).
        #[prost(string, optional, tag = "3")]
        pub name:         ::core::option::Option<::prost::alloc::string::String>,
    }
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Module {
        /// Name, such as Java class name. Platform-dependent.
        #[prost(string, optional, tag = "1")]
        pub name: ::core::option::Option<::prost::alloc::string::String>,
    }
}
