"""
Move summary

Revision ID: f43499b4f914
Revises: 8820a6b34f40
Create Date: 2018-10-14 16:23:22.552013+00:00
"""

from __future__ import annotations
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = "f43499b4f914"
down_revision = "8820a6b34f40"
branch_labels: None = None
depends_on: None = None

schema = sa.MetaData()

project = sa.Table(
    "projects",
    schema,
    sa.Column("id", sa.Integer, primary_key=True, nullable=False),
    sa.Column("name", sa.Unicode(2048), nullable=False, unique=True),
    sa.Column("display_name", sa.Unicode(2048), nullable=False, unique=True),
    sa.Column("summary", sa.Unicode(2048), nullable=True),
)

version = sa.Table(
    "versions",
    schema,
    sa.Column("id", sa.Integer, primary_key=True, nullable=False),
    sa.Column(
        "project_id",
        sa.Integer,
        sa.ForeignKey("projects.id", ondelete="CASCADE"),
        nullable=False,
    ),
    sa.Column("name", sa.Unicode(2048), nullable=False),
    sa.Column("display_name", sa.Unicode(2048), nullable=False),
    sa.Column("ordering", sa.Integer, nullable=False, default=0),
    sa.UniqueConstraint("project_id", "name"),
)

wheel = sa.Table(
    "wheels",
    schema,
    sa.Column("id", sa.Integer, primary_key=True, nullable=False),
    sa.Column("filename", sa.Unicode(2048), nullable=False, unique=True),
    sa.Column("url", sa.Unicode(2048), nullable=False),
    sa.Column(
        "version_id",
        sa.Integer,
        sa.ForeignKey("versions.id", ondelete="CASCADE"),
        nullable=False,
    ),
    sa.Column("size", sa.Integer, nullable=False),
    sa.Column("md5", sa.Unicode(32), nullable=True),
    sa.Column("sha256", sa.Unicode(64), nullable=True),
    sa.Column("uploaded", sa.Unicode(32), nullable=False),
    sa.Column("ordering", sa.Integer, nullable=False, default=0),
)

wheel_data = sa.Table(
    "wheel_data",
    schema,
    sa.Column("id", sa.Integer, primary_key=True, nullable=False),
    sa.Column(
        "wheel_id",
        sa.Integer,
        sa.ForeignKey("wheels.id", ondelete="CASCADE"),
        nullable=False,
        unique=True,
    ),
    sa.Column("raw_data", sa.JSON, nullable=False),
    sa.Column("processed", sa.DateTime(timezone=True), nullable=False),
    sa.Column("wheel_inspect_version", sa.Unicode(32), nullable=False),
    sa.Column("summary", sa.Unicode(2048), nullable=True),
    sa.Column("valid", sa.Boolean, nullable=False),
)


def upgrade() -> None:
    op.add_column(
        "projects",
        sa.Column("summary", sa.Unicode(length=2048), nullable=True),
    )
    conn = op.get_bind()
    subq = (
        sa.select(
            project.c.id,
            wheel_data.c.summary,
            sa.func.ROW_NUMBER()
            .over(
                partition_by=project.c.id,
                order_by=(version.c.ordering.desc(), wheel.c.ordering.desc()),
            )
            .label("rownum"),
        )
        .select_from(project.join(version).join(wheel).join(wheel_data))
        .order_by(project.c.name.asc())
        .cte()
    )
    for pid, summary in conn.execute(
        sa.select(subq.c.id, subq.c.summary).where(subq.c.rownum == 1)
    ):
        conn.execute(
            project.update().values(summary=summary).where(project.c.id == pid)
        )
    op.drop_column("wheel_data", "summary")


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "wheel_data",
        sa.Column(
            "summary",
            sa.VARCHAR(length=2048),
            autoincrement=False,
            nullable=True,
        ),
    )
    op.drop_column("projects", "summary")
    # ### end Alembic commands ###
