"""
Remove unused columns

Revision ID: aec0bfd26f9a
Revises: 2508919c9f86
Create Date: 2018-10-11 16:16:54.113822+00:00
"""

from __future__ import annotations
from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = "aec0bfd26f9a"
down_revision = "2508919c9f86"
branch_labels: None = None
depends_on: None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("files", "sha256_base64")
    op.drop_column("files", "size")
    op.drop_column("wheel_data", "project")
    op.drop_column("wheel_data", "version")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "wheel_data",
        sa.Column(
            "version",
            sa.VARCHAR(length=2048),
            autoincrement=False,
            nullable=False,
        ),
    )
    op.add_column(
        "wheel_data",
        sa.Column(
            "project",
            sa.VARCHAR(length=2048),
            autoincrement=False,
            nullable=False,
        ),
    )
    op.add_column(
        "files",
        sa.Column("size", sa.INTEGER(), autoincrement=False, nullable=True),
    )
    op.add_column(
        "files",
        sa.Column(
            "sha256_base64",
            sa.VARCHAR(length=43),
            autoincrement=False,
            nullable=True,
        ),
    )
    # ### end Alembic commands ###
