"""Viewport presets.

Attributes:
    presets (dict): Viewport visibility presets.

"""
presets = {
    'Show All Nodes': {
        'rendererName': 'vp2Renderer',
        'displayLights': 'default',
        'useDefaultMaterial': True,
        'twoSidedLighting': False,
        'displayAppearance': 'flatShaded',
        'wireframeOnShaded': True,
        'smoothWireframe': False,
        'lineWidth': 1.0,
        'headsUpDisplay': True,
        'selectionHiliteDisplay': True,
        'backfaceCulling': False,
        'xray': False,
        'jointXray': False,
        'activeComponentsXray': False,
        'maxConstantTransparency': 1.0,
        'displayTextures': False,
        'textureAnisotropic': True,
        'textureSampling': 2,
        'textureDisplay': 'modulate',
        'textureHilight': False,
        'shadows': False,
        'imagePlane': True,
        'useRGBImagePlane': True,
        'nurbsCurves': True,
        'nurbsSurfaces': True,
        'polymeshes': True,
        'subdivSurfaces': True,
        'planes': True,
        'lights': True,
        'cameras': True,
        'controlVertices': True,
        'grid': True,
        'hulls': True,
        'joints': True,
        'ikHandles': True,
        'deformers': True,
        'dynamics': True,
        'fluids': True,
        'hairSystems': True,
        'follicles': True,
        'nCloths': True,
        'nParticles': True,
        'nRigids': True,
        'dynamicConstraints': True,
        'locators': True,
        'manipulators': True,
        'dimensions': True,
        'handles': True,
        'pivots': True,
        'textures': True,
        'strokes': True
    },
    'Animation Nodes': {
        'displayLights': 'default',
        'twoSidedLighting': False,
        'displayAppearance': 'flatShaded',
        'wireframeOnShaded': False,
        'headsUpDisplay': True,
        'selectionHiliteDisplay': True,
        'useDefaultMaterial': True,
        'imagePlane': False,
        'useRGBImagePlane': True,
        'backfaceCulling': True,
        'xray': False,
        'jointXray': False,
        'activeComponentsXray': False,
        'maxConstantTransparency': 1.0,
        'displayTextures': False,
        'smoothWireframe': False,
        'lineWidth': 1.0,
        'textureAnisotropic': False,
        'textureSampling': 2,
        'textureDisplay': 'modulate',
        'textureHilight': True,
        'shadows': False,
        'rendererName': 'vp2Renderer',
        'nurbsCurves': True,
        'nurbsSurfaces': True,
        'polymeshes': True,
        'subdivSurfaces': True,
        'planes': False,
        'lights': False,
        'cameras': False,
        'controlVertices': False,
        'grid': False,
        'hulls': False,
        'joints': False,
        'ikHandles': True,
        'deformers': True,
        'dynamics': False,
        'fluids': False,
        'hairSystems': False,
        'follicles': False,
        'nCloths': False,
        'nParticles': False,
        'nRigids': False,
        'dynamicConstraints': False,
        'locators': False,
        'manipulators': True,
        'dimensions': False,
        'handles': False,
        'pivots': False,
        'textures': False,
        'strokes': False,
    },
    'Show Mesh Nodes': {
        'displayLights': 'default',
        'twoSidedLighting': False,
        'displayAppearance': 'smoothShaded',
        'wireframeOnShaded': False,
        'headsUpDisplay': False,
        'selectionHiliteDisplay': False,
        'useDefaultMaterial': False,
        'imagePlane': False,
        'useRGBImagePlane': True,
        'backfaceCulling': False,
        'xray': False,
        'jointXray': False,
        'activeComponentsXray': False,
        'maxConstantTransparency': 1.0,
        'displayTextures': True,
        'smoothWireframe': True,
        'lineWidth': 1.0,
        'textureAnisotropic': False,
        'textureSampling': 2,
        'textureDisplay': 'modulate',
        'textureHilight': True,
        'shadows': False,
        'rendererName': 'vp2Renderer',
        'nurbsCurves': False,
        'nurbsSurfaces': False,
        'polymeshes': True,
        'subdivSurfaces': True,
        'planes': False,
        'lights': False,
        'cameras': False,
        'controlVertices': False,
        'grid': False,
        'hulls': False,
        'joints': False,
        'ikHandles': False,
        'deformers': False,
        'dynamics': False,
        'fluids': False,
        'hairSystems': False,
        'follicles': False,
        'nCloths': False,
        'nParticles': False,
        'nRigids': False,
        'dynamicConstraints': False,
        'locators': False,
        'manipulators': False,
        'dimensions': False,
        'handles': False,
        'pivots': False,
        'textures': False,
        'strokes': False,
    }
}
